/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.TACongestionInfo;
import de.core.TADetailsAffectedFrame;
import de.core.TAMainFrame;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class TADetailsFrame
extends JDialog {
    private TACongestionInfo myCongestion;
    private TAMainFrame parent;
    private JButton btnAffected;
    private JButton btnLoadScenario;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblLineName;
    private JTable tblDetails;

    public TADetailsFrame(TAMainFrame parent, TACongestionInfo myCongestion) {
        super((Dialog)parent, true);
        this.initComponents();
        this.myCongestion = myCongestion;
        this.parent = parent;
        this.populateDetailsTable();
    }

    private void populateDetailsTable() {
        this.lblLineName.setText(this.myCongestion.getBranch().getName());
        DefaultTableModel model = (DefaultTableModel)this.tblDetails.getModel();
        for (int i = 0; i < this.myCongestion.getTotalOccurrences(); ++i) {
            Object[] o = new Object[]{this.myCongestion.lblock.get(i) + 1, this.myCongestion.lhydro.get(i) + 1, this.myCongestion.ltype.get(i).name(), this.myCongestion.lvalue.get(i), this.myCongestion.ldescription.get(i)};
            model.addRow(o);
        }
        this.tblDetails.setModel(model);
    }

    private void updateSchematic(int nBlock, int nHydro) {
        this.parent.updateSchematicFromTPDB(nBlock, nHydro);
    }

    private int getSelectedBlock() {
        int nRow = this.tblDetails.getSelectedRow();
        int nBlock = -1;
        if (nRow != -1) {
            nBlock = (Integer)this.tblDetails.getValueAt(nRow, 0) - 1;
        }
        return nBlock;
    }

    private int getSelectedHydro() {
        int nRow = this.tblDetails.getSelectedRow();
        int nHydro = -1;
        if (nRow != -1) {
            nHydro = (Integer)this.tblDetails.getValueAt(nRow, 1) - 1;
        }
        return nHydro;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblDetails = new JTable();
        this.btnLoadScenario = new JButton();
        this.lblLineName = new JLabel();
        this.btnAffected = new JButton();
        this.setDefaultCloseOperation(2);
        this.tblDetails.setAutoCreateRowSorter(true);
        this.tblDetails.setModel(new DefaultTableModel(new Object[0][], new String[]{"Time [block]", "Sample [hydro]", "Reason", "Value", "Limit Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Integer.class, String.class, Double.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblDetails.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblDetails);
        if (this.tblDetails.getColumnModel().getColumnCount() > 0) {
            this.tblDetails.getColumnModel().getColumn(4).setPreferredWidth(125);
        }
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 556, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE));
        this.btnLoadScenario.setText("Load Scenario");
        this.btnLoadScenario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TADetailsFrame.this.btnLoadScenarioActionPerformed(evt);
            }
        });
        this.lblLineName.setText("Initializing Congestion Manager...");
        this.btnAffected.setText("Show Balance");
        this.btnAffected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TADetailsFrame.this.btnAffectedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblLineName, -2, 226, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnAffected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoadScenario).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnLoadScenario).addComponent(this.btnAffected)).addComponent(this.lblLineName)).addGap(9, 9, 9)));
        this.pack();
    }

    private void btnLoadScenarioActionPerformed(ActionEvent evt) {
        int nBlock = this.getSelectedBlock();
        int nHydro = this.getSelectedHydro();
        if (nBlock < 0 || nHydro < 0) {
            JOptionPane.showMessageDialog(this, "Please select (only) one row from the Contigency Details List", "Selection warning", 2);
            return;
        }
        this.updateSchematic(nBlock, nHydro);
        this.parent.close();
        this.dispose();
    }

    private void btnAffectedActionPerformed(ActionEvent evt) {
        int nBlock = this.getSelectedBlock();
        int nHydro = this.getSelectedHydro();
        TADetailsAffectedFrame afcFrame = new TADetailsAffectedFrame(this, this.myCongestion, TACongestionInfo.SUPPLIER_BALANCE, nBlock, nHydro);
        afcFrame.setLocationRelativeTo(this);
        afcFrame.setVisible(true);
    }
}

