/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.TACongestionInfo;
import de.core.TADetailsFrame;
import de.core.comp;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class TADetailsAffectedFrame
extends JDialog {
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblCongestionTxt;
    private JLabel lblCongestionValue;
    private JLabel lblOccTxt;
    private JLabel lblOccValue;
    private JLabel lblProgress;
    private JTable tblAffected;

    public TADetailsAffectedFrame(TADetailsFrame parent, TACongestionInfo myCongestion, String balanceType, int nBlock, int nHydro) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.updateAffectedDetails(myCongestion, balanceType, nBlock, nHydro);
        this.setLabels(myCongestion, balanceType);
    }

    public TADetailsAffectedFrame(JDialog parent, TACongestionInfo myCongestion, String balanceType) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.updateAffectedDetails(myCongestion, balanceType);
        this.setLabels(myCongestion, balanceType);
    }

    private void updateAffectedDetails(TACongestionInfo myCongestion, String balanceType, int nBlock, int nHydro) {
        DefaultTableModel model = (DefaultTableModel)this.tblAffected.getModel();
        comp[] strAffectedAct = myCongestion.getAffectedMarketParticipant(nBlock, nHydro);
        String[] strAffectedCont = myCongestion.getAffectedContracts(nBlock, nHydro);
        double[] dBalanceRealAct = myCongestion.getAffectedMarketParticipantRevenueReal(nBlock, nHydro);
        double[] dBalanceTheoryAct = myCongestion.getAffectedMarketParticipantRevenueTheory(nBlock, nHydro);
        double[] dLossesAct = myCongestion.getAffectedMarketParticipantLosses(nBlock, nHydro);
        for (int i = 0; i < strAffectedAct.length; ++i) {
            Object[] o = new Object[]{strAffectedAct[i].getName(), strAffectedCont[i], dBalanceRealAct[i], dBalanceTheoryAct[i], dLossesAct[i]};
            if (balanceType.equals(TACongestionInfo.CUSTOMER_BALANCE) && !strAffectedCont[i].equals(TACongestionInfo.CUSTOMER_BALANCE) || !balanceType.equals(TACongestionInfo.CUSTOMER_BALANCE) && strAffectedCont[i].equals(TACongestionInfo.CUSTOMER_BALANCE)) continue;
            model.addRow(o);
        }
        this.tblAffected.setModel(model);
    }

    private void updateAffectedDetails(TACongestionInfo myCongestion, String balanceType) {
        HashMap<Integer, String> AffectedID = new HashMap<Integer, String>();
        ArrayList<comp> Affected = new ArrayList<comp>();
        ArrayList<String> Contract = new ArrayList<String>();
        ArrayList<Double> Revenue = new ArrayList<Double>();
        ArrayList<Double> RevenueT = new ArrayList<Double>();
        ArrayList<Double> Losses = new ArrayList<Double>();
        for (int nPeriod : myCongestion.getCongestionPeriods()) {
            int nBlock = myCongestion.getBlockFromPeriodID(nPeriod);
            int nHydro = myCongestion.getHydroFromPeriodID(nPeriod);
            comp[] strAffectedAct = myCongestion.getAffectedMarketParticipant(nBlock, nHydro);
            String[] strAffectedContract = myCongestion.getAffectedContracts(nBlock, nHydro);
            double[] dBalanceRealAct = myCongestion.getAffectedMarketParticipantRevenueReal(nBlock, nHydro);
            double[] dBalanceTheoryAct = myCongestion.getAffectedMarketParticipantRevenueTheory(nBlock, nHydro);
            double[] dLossesAct = myCongestion.getAffectedMarketParticipantLosses(nBlock, nHydro);
            block1: for (int i = 0; i < strAffectedAct.length; ++i) {
                if (balanceType.equals(TACongestionInfo.CUSTOMER_BALANCE) && !strAffectedContract[i].equals(TACongestionInfo.CUSTOMER_BALANCE) || !balanceType.equals(TACongestionInfo.CUSTOMER_BALANCE) && strAffectedContract[i].equals(TACongestionInfo.CUSTOMER_BALANCE)) continue;
                if (AffectedID.containsValue(strAffectedAct[i] + "_" + strAffectedContract[i])) {
                    Iterator i$ = AffectedID.keySet().iterator();
                    while (i$.hasNext()) {
                        int mykey = (Integer)i$.next();
                        if (!((String)AffectedID.get(mykey)).equals(strAffectedAct[i] + "_" + strAffectedContract[i])) continue;
                        double dRevenue = (Double)Revenue.get(mykey) + dBalanceRealAct[i];
                        double dRevenueT = (Double)RevenueT.get(mykey) + dBalanceTheoryAct[i];
                        double dLosses = (Double)Losses.get(mykey) + dLossesAct[i];
                        Revenue.set(mykey, dRevenue);
                        RevenueT.set(mykey, dRevenueT);
                        Losses.set(mykey, dLosses);
                        continue block1;
                    }
                    continue;
                }
                AffectedID.put(AffectedID.size(), strAffectedAct[i] + "_" + strAffectedContract[i]);
                Affected.add(strAffectedAct[i]);
                Contract.add(strAffectedContract[i]);
                Revenue.add(dBalanceRealAct[i]);
                RevenueT.add(dBalanceTheoryAct[i]);
                Losses.add(dLossesAct[i]);
            }
        }
        DefaultTableModel model = (DefaultTableModel)this.tblAffected.getModel();
        for (int i = 0; i < Affected.size(); ++i) {
            Object[] o = new Object[]{((comp)Affected.get(i)).getName(), balanceType.equals(TACongestionInfo.CUSTOMER_BALANCE) ? ((comp)Affected.get(i)).getinv_owner() : Contract.get(i), Revenue.get(i), RevenueT.get(i), Losses.get(i)};
            model.addRow(o);
        }
        this.tblAffected.setModel(model);
    }

    public final void setLabels(TACongestionInfo myTACI, String balanceType) {
        this.lblProgress.setText("Balance type: " + balanceType);
        this.lblCongestionValue.setText(myTACI.getBranch().getName());
        this.lblOccValue.setText(String.valueOf(myTACI.getNonConcurrentOccurrences()));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblAffected = new JTable();
        this.jPanel1 = new JPanel();
        this.lblCongestionTxt = new JLabel();
        this.lblOccTxt = new JLabel();
        this.lblProgress = new JLabel();
        this.lblCongestionValue = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.lblOccValue = new JLabel();
        this.setDefaultCloseOperation(2);
        this.tblAffected.setAutoCreateRowSorter(true);
        this.tblAffected.setModel(new DefaultTableModel(new Object[0][], new String[]{"Market Participant", "Wheel Contract", "Spot Market Revenue", "Unconstrained Revenue", "Potential Losses"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Double.class, Double.class, Double.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.tblAffected);
        this.lblCongestionTxt.setText("Congestion:");
        this.lblOccTxt.setText("Total Occurances:");
        this.lblProgress.setForeground(new Color(0, 0, 204));
        this.lblProgress.setText("Calculating affected market participants. Please wait...");
        this.lblCongestionValue.setBackground(new Color(153, 153, 153));
        this.lblCongestionValue.setText("Line");
        this.lblOccValue.setText("n");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblCongestionTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCongestionValue).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.filler1, -2, -1, -2).addGap(58, 58, 58).addComponent(this.filler2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblOccTxt, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblOccValue)).addComponent(this.lblProgress)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblProgress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filler1, -2, 11, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.filler2, -2, 11, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCongestionTxt).addComponent(this.lblCongestionValue)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOccTxt, -2, 14, -2).addComponent(this.lblOccValue))))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 548, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 299, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0)));
        this.pack();
    }
}

