/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.TACongestionAffected;
import de.core.comp;
import de.core.ndb_branch;
import de.data.DE_GeneralEnums;
import de.utils.Utils;
import java.io.PrintWriter;
import java.util.ArrayList;

public class TACongestionInfo {
    public static String CUSTOMER_BALANCE = "loadBalance";
    public static String SUPPLIER_BALANCE = "genBalance";
    private ndb_branch branch;
    public ArrayList<DE_GeneralEnums.CongestionType> ltype;
    public ArrayList<Double> lvalue = new ArrayList();
    public ArrayList<Double> lflow = new ArrayList();
    public ArrayList<Double> lCmg = new ArrayList();
    public ArrayList<Integer> lblock = new ArrayList();
    public ArrayList<Integer> lhydro = new ArrayList();
    public ArrayList<String> ldescription;
    public ArrayList<Integer> lperiodId = new ArrayList();
    public ArrayList<Integer> lunique = new ArrayList();
    private ArrayList<TACongestionAffected> lAffected;
    private boolean hasCustomerBalance;
    private boolean hasBilateralMarketBalance;
    private double index = 0.0;
    private int occurances = 0;
    private int nTotalBlock;
    private int nTotalHydro;

    public TACongestionInfo(int nTotalPeriod, int nTotalHydro) {
        this.ltype = new ArrayList();
        this.ldescription = new ArrayList();
        this.lAffected = new ArrayList();
        this.nTotalBlock = nTotalPeriod;
        this.nTotalHydro = nTotalHydro;
        this.hasBilateralMarketBalance = false;
        this.hasCustomerBalance = false;
    }

    public void addCongestion(double dValue, DE_GeneralEnums.CongestionType eType, double cmgDiff, double dFlow, int nBlock, int nHydro, String description) {
        this.ltype.add(eType);
        this.lvalue.add(dValue);
        this.lflow.add(dFlow);
        this.lCmg.add(cmgDiff);
        this.lblock.add(nBlock);
        this.lhydro.add(nHydro);
        this.lperiodId.add(this.getPeriodID(nBlock, nHydro));
        this.ldescription.add(description);
        ++this.occurances;
    }

    public void addLoadMargin(double dLoadMargin, double dFlow, int nBlock, int nHydro, String description) {
        this.ltype.add(DE_GeneralEnums.CongestionType.BranchLoadMargin);
        this.lvalue.add(dLoadMargin);
        this.lflow.add(dFlow);
        this.lblock.add(nBlock);
        this.lhydro.add(nHydro);
        this.lperiodId.add(this.getPeriodID(nBlock, nHydro));
        this.ldescription.add(description);
        ++this.occurances;
    }

    public void addCmgDiff(double dCmgDiff, double dFlow, int nBlock, int nHydro, String description) {
        this.ltype.add(DE_GeneralEnums.CongestionType.MarginalCostDiff);
        this.lvalue.add(dCmgDiff);
        this.lCmg.add(dCmgDiff);
        this.lflow.add(dFlow);
        this.lblock.add(nBlock);
        this.lhydro.add(nHydro);
        this.lperiodId.add(this.getPeriodID(nBlock, nHydro));
        this.ldescription.add(description);
        ++this.occurances;
    }

    public void addAffectedMarketParticipant(comp actName, String contName, double dBalanceReal, double dBalanceTheory, int nBlock, int nHydro) {
        if (actName == null) {
            actName = new comp("NONE_AFFECTED", 0, 0){

                @Override
                comp Copy(int xo, int yo) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        TACongestionAffected myEffect = this.getAffected(nBlock, nHydro);
        myEffect.lMarketParticipant.add(actName);
        myEffect.lContracts.add(contName);
        myEffect.dBalanceReal.add(dBalanceReal);
        myEffect.dBalanceTheory.add(dBalanceTheory);
        this.lAffected.add(myEffect);
        if (contName.equals(CUSTOMER_BALANCE) || contName.isEmpty()) {
            this.hasCustomerBalance = true;
        } else {
            this.hasBilateralMarketBalance = true;
        }
    }

    public boolean hasBilateralMarketBalance() {
        if (this.lAffected.isEmpty()) {
            return false;
        }
        return this.hasBilateralMarketBalance;
    }

    public boolean hasCustomerBalance() {
        if (this.lAffected.isEmpty()) {
            return false;
        }
        return this.hasCustomerBalance;
    }

    public int getTotalOccurrences() {
        return this.occurances;
    }

    public double getAvgMarginalIncome() {
        double dTotalMarginalIncome = 0.0;
        for (int i = 0; i < this.lperiodId.size(); ++i) {
            dTotalMarginalIncome += Math.abs(this.lCmg.get(i) * this.lflow.get(i));
        }
        return Utils.safeDivision(dTotalMarginalIncome, this.occurances);
    }

    public double getMarginalIncome(int nBlock, int nHydro) {
        double dCmgDigff = this.lCmg.get(this.getPeriodID(nBlock, nHydro));
        double dFlow = this.lflow.get(this.getPeriodID(nBlock, nHydro));
        return dCmgDigff * dFlow;
    }

    public double getTotalLosses() {
        double dLosses = 0.0;
        for (TACongestionAffected aff : this.lAffected) {
            for (int i = 0; i < aff.dBalanceReal.size(); ++i) {
                dLosses += aff.dBalanceTheory.get(i).doubleValue();
                dLosses -= aff.dBalanceReal.get(i).doubleValue();
            }
        }
        return dLosses;
    }

    public double getRevenueByMarketParticipant(String sAffectedName, String sContract) {
        double dRevenue = 0.0;
        for (TACongestionAffected aff : this.lAffected) {
            for (int i = 0; i < aff.lMarketParticipant.size(); ++i) {
                if (!aff.lMarketParticipant.get(i).getName().equalsIgnoreCase(sAffectedName) || !aff.lContracts.get(i).equals(sContract)) continue;
                dRevenue += aff.dBalanceReal.get(i).doubleValue();
            }
        }
        return dRevenue;
    }

    public double getRevenueTheoryByMarketParticipant(String sAffectedName, String sContract) {
        double dRevenue = 0.0;
        for (TACongestionAffected aff : this.lAffected) {
            for (int i = 0; i < aff.lMarketParticipant.size(); ++i) {
                if (!aff.lMarketParticipant.get(i).getName().equalsIgnoreCase(sAffectedName) || !aff.lContracts.get(i).equals(sContract)) continue;
                dRevenue += aff.dBalanceTheory.get(i).doubleValue();
            }
        }
        return dRevenue;
    }

    public double getLossesByMarketParticipant(String sAffectedName, String sContract) {
        double dRevenue = this.getRevenueByMarketParticipant(sAffectedName, sContract);
        double dRevenueTheory = this.getRevenueTheoryByMarketParticipant(sAffectedName, sContract);
        return dRevenueTheory - dRevenue;
    }

    public int getNonConcurrentOccurrences() {
        ArrayList<Integer> unique = this.getCongestionPeriods();
        return unique.size();
    }

    public ArrayList<Integer> getCongestionPeriods() {
        this.lunique.clear();
        for (int t : this.lperiodId) {
            if (this.lunique.contains(t)) continue;
            this.lunique.add(t);
        }
        return this.lunique;
    }

    public double getProbability() {
        double realOcurrances = this.getNonConcurrentOccurrences();
        return realOcurrances / (double)(this.nTotalBlock * this.nTotalHydro);
    }

    public double getAverage(DE_GeneralEnums.CongestionType eType) {
        double dAvgCongestionType = 0.0;
        int nOcurranceType = 0;
        for (int i = 0; i < this.ltype.size(); ++i) {
            if (!this.ltype.get(i).equals((Object)eType)) continue;
            dAvgCongestionType += this.lvalue.get(i).doubleValue();
            ++nOcurranceType;
        }
        return Utils.safeDivision(dAvgCongestionType, nOcurranceType);
    }

    public int getPeriodID(int nBlock, int nHydro) {
        return nBlock * this.nTotalHydro + nHydro;
    }

    public int getHydroFromPeriodID(int nPeriodID) {
        return nPeriodID % this.nTotalHydro;
    }

    public int getBlockFromPeriodID(int nPeriodId) {
        return new Double(nPeriodId / this.nTotalHydro).intValue();
    }

    public comp[] getAffectedMarketParticipant(int nBlock, int nHydro) {
        TACongestionAffected myEffect = this.getAffected(nBlock, nHydro);
        comp[] affectedAct = myEffect.lMarketParticipant.toArray(new comp[myEffect.lMarketParticipant.size()]);
        return affectedAct;
    }

    public String[] getAffectedContracts(int nBlock, int nHydro) {
        TACongestionAffected myEffect = this.getAffected(nBlock, nHydro);
        String[] affectedCont = myEffect.lContracts.toArray(new String[myEffect.lContracts.size()]);
        return affectedCont;
    }

    public double[] getAffectedMarketParticipantLosses(int nBlock, int nHydro) {
        TACongestionAffected myEffect = this.getAffected(nBlock, nHydro);
        Double[] BalanceReal = myEffect.dBalanceReal.toArray(new Double[myEffect.lMarketParticipant.size()]);
        Double[] BalanceTheory = myEffect.dBalanceTheory.toArray(new Double[myEffect.lMarketParticipant.size()]);
        double[] returnLosses = new double[BalanceReal.length];
        for (int i = 0; i < BalanceReal.length; ++i) {
            returnLosses[i] = BalanceTheory[i] - BalanceReal[i];
        }
        return returnLosses;
    }

    public double[] getAffectedMarketParticipantRevenueReal(int nBlock, int nHydro) {
        TACongestionAffected myEffect = this.getAffected(nBlock, nHydro);
        Double[] BalanceReal = myEffect.dBalanceReal.toArray(new Double[myEffect.lMarketParticipant.size()]);
        double[] returnArray = new double[BalanceReal.length];
        for (int i = 0; i < BalanceReal.length; ++i) {
            returnArray[i] = BalanceReal[i];
        }
        return returnArray;
    }

    public double[] getAffectedMarketParticipantRevenueTheory(int nBlock, int nHydro) {
        TACongestionAffected myEffect = this.getAffected(nBlock, nHydro);
        Double[] BalanceTheory = myEffect.dBalanceTheory.toArray(new Double[myEffect.lMarketParticipant.size()]);
        double[] returnArray = new double[BalanceTheory.length];
        for (int i = 0; i < BalanceTheory.length; ++i) {
            returnArray[i] = BalanceTheory[i];
        }
        return returnArray;
    }

    public void writeResultsInCSV(PrintWriter myPrintStream, boolean bPrintAffected) {
        String strBranchName = this.branch.getName();
        String coma = ",";
        for (int i = 0; i < this.ltype.size(); ++i) {
            String strBasicLine;
            String c1 = this.ltype.get(i).name();
            double c2 = this.lvalue.get(i);
            int nBlock = this.lblock.get(i);
            int nHydro = this.lhydro.get(i);
            String c5 = this.ldescription.get(i);
            String strFullLine = strBasicLine = strBranchName + coma + c1 + coma + c2 + coma + (nBlock + 1) + coma + (nHydro + 1) + coma + c5 + coma;
            if (bPrintAffected) {
                comp[] strAffectedAct = this.getAffectedMarketParticipant(nBlock, nHydro);
                String[] strAffectedCont = this.getAffectedContracts(nBlock, nHydro);
                double[] dBalanceRealAct = this.getAffectedMarketParticipantRevenueReal(nBlock, nHydro);
                double[] dBalanceTheoryAct = this.getAffectedMarketParticipantRevenueTheory(nBlock, nHydro);
                double[] dLossesAct = this.getAffectedMarketParticipantLosses(nBlock, nHydro);
                for (int k = 0; k < strAffectedAct.length; ++k) {
                    String c6 = strAffectedAct[k].getName();
                    String c7 = strAffectedCont[k];
                    double c8 = dBalanceRealAct[k];
                    double c9 = dBalanceTheoryAct[k];
                    double c10 = dLossesAct[k];
                    strFullLine = strBasicLine + c6 + coma + c7 + coma + c8 + coma + c9 + coma + c10 + coma;
                    myPrintStream.println(strFullLine);
                }
            }
            myPrintStream.println(strFullLine);
        }
    }

    private TACongestionAffected getAffected(int nBlock, int nHydro) {
        for (TACongestionAffected myEffect : this.lAffected) {
            if (myEffect.nBlock != nBlock || myEffect.nHydro != nHydro) continue;
            return myEffect;
        }
        return new TACongestionAffected(nBlock, nHydro);
    }

    public ndb_branch getBranch() {
        return this.branch;
    }

    public void setBranch(ndb_branch branch) {
        this.branch = branch;
    }

    public String getBusbarFromName() {
        return this.branch.getcon1();
    }

    public String getBusbarToName() {
        return this.branch.getcon2();
    }

    public double getIndex() {
        return this.index;
    }

    public void setIndex(double index) {
        this.index = index;
    }

    public ArrayList<DE_GeneralEnums.CongestionType> getLtype() {
        return this.ltype;
    }

    public ArrayList<Double> getLvalue() {
        return this.lvalue;
    }

    public ArrayList<Integer> getLperiodId() {
        return this.lperiodId;
    }

    public ArrayList<Integer> getLblock() {
        return this.lblock;
    }

    public ArrayList<Integer> getLhydro() {
        return this.lhydro;
    }
}

