/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Load;
import de.core.Schematic;
import de.core.SensitivitiesJAVA;
import de.core.TACongestionInfo;
import de.core.TPDBProcessor;
import de.core.XmlBranchLimitInfo;
import de.core.XmlBranchLimitInfos;
import de.core.comp;
import de.core.mdb_act;
import de.core.mdb_cust;
import de.core.mdb_sup;
import de.core.mdb_wheel;
import de.core.ndb_branch;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import de.utils.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class TACongestion
extends AnalysisTool
implements Runnable {
    public static final String DATE_FOMAT = "dd/MM/yyyy";
    protected DeepEdit MyDeepEdit;
    protected boolean bRecalculate;
    protected Calendar initialDateDB;
    protected Calendar finalDateDB;
    protected int initialBlock;
    protected int finalBlock;
    protected int finalHydro;
    protected ArrayList<Calendar> iniBlockDate;
    protected boolean bMakeReport;
    protected boolean bUseDoubleCircuit;
    protected boolean bCalculateMarketBalance;
    protected boolean bUsePriceDiff;
    protected boolean bUseLineLoad;
    protected boolean bUseRelPriceDiff;
    protected boolean bUseDynPriceDiff;
    protected double dLineTol;
    protected double dPriceDiffTol;
    protected double dPriceFactor;
    protected double dLineLoadFactor;
    protected double dProbabilityFactor;
    protected double dRevenueLossFactor;
    protected double dMarginalIncomeFactor;
    protected String sDBPath;
    protected String sUserName;
    protected String sPass;
    protected String sServer;
    private String strInputFolder;
    private String strOutputFolder;
    private String strPLEXOSOutputDBName;
    protected String sSchDiffReportFile;
    protected String sSoftwareSource;
    protected String sLastSourceFileType;
    protected String sLogFilePath;
    protected double dRelPriceDiffTol;
    protected String sLimitXMLFile;
    protected ArrayList<Double> blockDuration;
    protected ArrayList<ParameterData> lFlowP;
    protected ArrayList<ParameterData> lFlowPMax;
    protected ArrayList<ParameterData> lInservice;
    protected ArrayList<ParameterData> lFlowPMin;
    protected ArrayList<ParameterData> lCmg;
    protected ArrayList<ParameterData> lGenerationP;
    protected ArrayList<ParameterData> lLoadP;
    protected ArrayList<ParameterData> lCmgDiff;
    protected ArrayList<ParameterData> lFlow;
    protected ArrayList<ParameterData> lBranchLoad;
    protected ArrayList<TACongestionInfo> lCongestion;
    double[][][] pf;
    Map<String, Integer> mBranchName2GSDF_ID;
    Map<String, Integer> mNodesName2GSDF_ID;
    private double[][] Cmg_Theory;
    private Map<Integer, Double> mFlow;
    private Map<Integer, Double> mCmgDiff;
    private double[][] Pmax;
    private Map<String, Integer> mNames;
    private Map<String, String> mTransmissionDetails;

    public TACongestion(DeepEdit MyDE) {
        super(DeepEdit.MySchematic);
        this.MyDeepEdit = MyDE;
        this.initializeDefaults(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Calculate() {
        long currentProcessTime;
        long elapsed = 0L;
        long iniTime = System.currentTimeMillis();
        boolean bOldPrint = DeepEdit.PrintConnecWarnings;
        this.checkActSchematicCompatibility(false, false, true);
        TACongestion.setMessageText("---------- Initializing Transmission Analysis Tools ----------", 0);
        this.initializeCalculate();
        if (!this.isSchematicValid()) {
            DeepEdit.PrintConnecWarnings = true;
            this.isSchematicValid();
            DeepEdit.PrintConnecWarnings = bOldPrint;
            int nYesNo = JOptionPane.showConfirmDialog(this.ActFrame, "Schematic has validation errors. \n Do you wish to continue?", "Invalid Schematic", 0, 2);
            if (nYesNo == 1) {
                return;
            }
        }
        TACongestion.showProgressFrame("Executing Transmission Congestion Analysis", null);
        TACongestion.setMessageText("Finished Validating schematic...", 5);
        if (this.useFullMemory()) {
            TACongestion.setMessageText("Initializing connection to TPDB database. Please wait...", 5);
            if (!this.updateALLFromTADatabase()) {
                TACongestion.disposeProgressFrame();
                return;
            }
            elapsed = System.currentTimeMillis() - iniTime;
            TACongestion.setMessageText("Finished reading dispatch data from database. Time: " + elapsed / 1000L + "[sec]", 85);
            TACongestion.setMessageText("Computing price differences for all transmission branches...", 85);
            this.lCmgDiff = this.computeAllPriceDiff();
            currentProcessTime = System.currentTimeMillis() - iniTime - elapsed;
            elapsed = System.currentTimeMillis() - iniTime;
            TACongestion.setMessageText("Finished computing price differences. Time: " + currentProcessTime / 1000L + "[sec]", 90);
            TACongestion.setMessageText("Computing line's load margin for all transmission branches...", 90);
            this.lBranchLoad = this.computeAllLoadMargin();
            currentProcessTime = System.currentTimeMillis() - iniTime - elapsed;
            elapsed = System.currentTimeMillis() - iniTime;
            TACongestion.setMessageText("Finished computing line's loads. Time: " + currentProcessTime / 1000L + "[sec]", 95);
        } else {
            TACongestion.setMessageText("Computing price differences and line's load for all transmission branches...", 5);
            this.lCmgDiff = new ArrayList();
            this.lBranchLoad = new ArrayList();
            int nBlock = 0;
            int nHydro = 0;
            TACongestion.setMessageText("Retrieving Line's flow values from TPDB database...", 0);
            Connection conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, true);
            try {
                for (nBlock = 0; nBlock < this.finalBlock; ++nBlock) {
                    for (nHydro = 0; nHydro < this.finalHydro; ++nHydro) {
                        this.CalculateFlow(conTADB, nBlock, nHydro);
                        TACongestion.setProgress(100 * (nBlock * this.finalHydro + nHydro) / (this.finalBlock * this.finalHydro));
                    }
                }
            }
            catch (SQLException ex) {
                System.out.println("Unexpected error querying flows from TPDB at period " + nBlock + " hydro " + nHydro + ". Execution stopped");
                ex.printStackTrace(System.out);
                return;
            }
            finally {
                DeepEdit.CloseJDBCConnection(conTADB);
            }
            TACongestion.setMessageText("Retrieving Nodal prices from TPDB database...", 0);
            conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, true);
            try {
                for (nBlock = 0; nBlock < this.finalBlock; ++nBlock) {
                    for (nHydro = 0; nHydro < this.finalHydro; ++nHydro) {
                        this.Calculate(conTADB, nBlock, nHydro);
                        TACongestion.setProgress(100 * (nBlock * this.finalHydro + nHydro) / (this.finalBlock * this.finalHydro));
                    }
                }
            }
            catch (SQLException ex) {
                System.out.println("Unexpected error calculating period " + nBlock + " hydro " + nHydro + ". Execution stopped");
                ex.printStackTrace(System.out);
                return;
            }
            finally {
                DeepEdit.CloseJDBCConnection(conTADB);
            }
        }
        TACongestion.setMessageText("Preparing congestion list...", 50);
        this.lCongestion = this.computeCongestionList();
        TACongestion.setMessageText("Calculating spot market balance and affected market participants...", 50);
        if (this.bCalculateMarketBalance) {
            int nCongestion = 0;
            for (TACongestionInfo oCongestion : this.lCongestion) {
                TACongestion.setMessageText("Calculating affected market participants for line " + oCongestion.getBranch().getName() + "...", 50 + (int)(49.0 * Utils.safeDivision(nCongestion, this.lCongestion.size())));
                this.updateAffectedMarketParticipants(oCongestion);
                double dIndex = oCongestion.getIndex();
                oCongestion.setIndex(dIndex += this.dRevenueLossFactor * Math.abs(oCongestion.getTotalLosses()));
                ++nCongestion;
            }
        }
        this.deleteData();
        this.bRecalculate = false;
        currentProcessTime = System.currentTimeMillis() - iniTime - elapsed;
        TACongestion.setMessageText("Finished computing affected market participants. Time: " + currentProcessTime / 1000L + "[sec]", 99);
        if (this.bMakeReport) {
            File f = new File(this.sLogFilePath);
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(f));
                this.writeResults(pw);
                pw.close();
                TACongestion.setMessageText("Finished writing results to log file:" + f.getAbsoluteFile(), 100);
            }
            catch (IOException ex) {
                TACongestion.setMessageText("Error while writing congestion analysis log file " + f.getAbsolutePath(), 100);
                TACongestion.setMessageText("Exception details: " + ex.getMessage(), 100);
            }
        }
        elapsed = System.currentTimeMillis() - iniTime;
        TACongestion.setMessageText("Process finished successfully. Total execution time: " + elapsed / 1000L + "[sec]", 100);
        TACongestion.setMessageText("---------- Finished Transmission Analysis Tools ----------");
        TACongestion.disposeProgressFrame();
    }

    private void CalculateFlow(Connection conTADB, int nBlock, int nHydro) throws SQLException {
        ArrayList<ParameterData> lDataFlow = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "flow", nBlock, nHydro, "p12", "ndb_branch");
        for (ParameterData pDataFlow : lDataFlow) {
            double dFlow = pDataFlow.getdValue();
            this.addFlowFromTPDB(dFlow, pDataFlow.getStrOwnerName(), nBlock, nHydro);
        }
    }

    private void Calculate(Connection conTADB, int nBlock, int nHydro) throws SQLException {
        ArrayList<ParameterData> lDataCmg = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "cmg", nBlock, nHydro, "cmg_p", "Busbar");
        for (ndb_branch branch : this.ndb_branches) {
            branch.InformAllComponents();
            String strNode1 = branch.getcon1();
            String strNode2 = branch.getcon2();
            double cmgBar1 = 0.0;
            double cmgBar2 = 0.0;
            double dCmgDiff = 0.0;
            double dCmgRelDiff = 0.0;
            double dCmgDynPriceDiffTol = 0.0;
            double dFlow = 0.0;
            double dPmax = 0.0;
            double dPmin = 0.0;
            double dLineLoad = 0.0;
            int nID = 0;
            dPmax = this.getPmaxFromTPDB(branch.getName(), nBlock);
            if (dPmax == 0.0) continue;
            nID = (branch.getName() + "_" + nBlock + "_" + nHydro).hashCode();
            if (this.mFlow.containsKey(nID)) {
                dFlow = this.mFlow.get((branch.getName() + "_" + nBlock + "_" + nHydro).hashCode());
            }
            for (ParameterData pDataCmg : lDataCmg) {
                if (pDataCmg.getStrOwnerName().equals(strNode1)) {
                    cmgBar1 = pDataCmg.getdValue();
                }
                if (pDataCmg.getStrOwnerName().equals(strNode2)) {
                    cmgBar2 = pDataCmg.getdValue();
                }
                dCmgDiff = Math.abs(cmgBar1 - cmgBar2);
                dCmgRelDiff = Utils.safeDivision(dCmgDiff, Math.abs(cmgBar1));
            }
            if (this.bUseDynPriceDiff) {
                dCmgDynPriceDiffTol = Utils.safeDivision(this.getMarginalLossAtNode(strNode1, nBlock, nHydro) - this.getMarginalLossAtNode(strNode2, nBlock, nHydro), 1.0 - this.getMarginalLossAtNode(strNode2, nBlock, nHydro));
            }
            if (this.bUsePriceDiff && dCmgDiff > this.dPriceDiffTol || (this.bUseDynPriceDiff || this.bUseRelPriceDiff) && dCmgRelDiff > Math.abs(dCmgDynPriceDiffTol) + this.dRelPriceDiffTol) {
                ParameterData pDataIncomep = new ParameterData("m_incomep");
                pDataIncomep.setStrOwnerName(branch.getName());
                pDataIncomep.setnBlock(nBlock);
                pDataIncomep.setnHydro(nHydro);
                pDataIncomep.setdValue(dCmgRelDiff);
                this.lCmgDiff.add(pDataIncomep);
                this.addCmgDiffFromTPDB(dCmgDiff, branch.getName(), nBlock, nHydro);
            }
            if (!(dPmax > 0.0)) continue;
            if (dPmin == 0.0) {
                dPmin = -1.0 * dPmax;
            }
            if (!((dLineLoad = Math.abs(dFlow / Math.min(Math.abs(dPmax), Math.abs(dPmin)))) >= this.dLineTol)) continue;
            ParameterData pDataLineload = new ParameterData("lineload");
            pDataLineload.setStrOwnerName(branch.getName());
            pDataLineload.setnBlock(nBlock);
            pDataLineload.setnHydro(nHydro);
            pDataLineload.setdValue(dLineLoad);
            this.lBranchLoad.add(pDataLineload);
            this.addCmgDiffFromTPDB(dCmgDiff, branch.getName(), nBlock, nHydro);
        }
    }

    private void initializeCalculate() {
        this.pf = null;
        this.Cmg_Theory = null;
        this.mCmgDiff = null;
        this.mFlow = null;
        this.lCongestion = null;
    }

    private ArrayList<ParameterData> computeAllPriceDiff() {
        ArrayList<ParameterData> lDataIncomep = new ArrayList<ParameterData>();
        if (!this.bUsePriceDiff && !this.bUseRelPriceDiff) {
            return lDataIncomep;
        }
        for (ndb_branch branch : this.ndb_branches) {
            branch.InformAllComponents();
            String strNode1 = branch.getcon1();
            String strNode2 = branch.getcon2();
            double[][] cmgBar1 = new double[this.finalBlock][this.finalHydro];
            double[][] cmgBar2 = new double[this.finalBlock][this.finalHydro];
            for (ParameterData pDataCmg : this.lCmg) {
                int nBlockId = pDataCmg.getnBlock();
                int nHydroId = pDataCmg.getnHydro();
                if (pDataCmg.getStrOwnerName().equals(strNode1)) {
                    cmgBar1[nBlockId][nHydroId] = pDataCmg.getdValue();
                }
                if (!pDataCmg.getStrOwnerName().equals(strNode2)) continue;
                cmgBar2[nBlockId][nHydroId] = pDataCmg.getdValue();
            }
            for (int b = 0; b < this.finalBlock; ++b) {
                double pmax = this.getPmaxFromTPDB(branch.getName(), b);
                if (pmax == 0.0) continue;
                for (int h = 0; h < this.finalHydro; ++h) {
                    double dCmgDiff = Math.abs(cmgBar1[b][h] - cmgBar2[b][h]);
                    double dCmgRelDiff = Utils.safeDivision(dCmgDiff, Math.abs(cmgBar1[b][h]));
                    this.addCmgDiffFromTPDB(dCmgRelDiff, branch.getName(), b, h);
                    double dCmgDynPriceDiffTol = 0.0;
                    if (this.bUseDynPriceDiff) {
                        dCmgDynPriceDiffTol = Utils.safeDivision(this.getMarginalLossAtNode(strNode1, b, h) - this.getMarginalLossAtNode(strNode2, b, h), 1.0 - this.getMarginalLossAtNode(strNode2, b, h));
                    }
                    if (!(this.bUsePriceDiff && dCmgDiff > this.dPriceDiffTol) && (!this.bUseDynPriceDiff && !this.bUseRelPriceDiff || !(dCmgRelDiff > Math.abs(dCmgDynPriceDiffTol) + this.dRelPriceDiffTol))) continue;
                    ParameterData pDataIncomep = new ParameterData("m_incomep");
                    pDataIncomep.setStrOwnerName(branch.getName());
                    pDataIncomep.setnBlock(b);
                    pDataIncomep.setnHydro(h);
                    pDataIncomep.setdValue(dCmgRelDiff);
                    lDataIncomep.add(pDataIncomep);
                }
            }
        }
        return lDataIncomep;
    }

    private ArrayList<ParameterData> computeAllLoadMargin() {
        ArrayList<ParameterData> lDataLineLoad = new ArrayList<ParameterData>();
        if (!this.bUseLineLoad) {
            return lDataLineLoad;
        }
        for (ParameterData pDataFlow : this.lFlowP) {
            double dFlow = pDataFlow.getdValue();
            if (-0.1 < dFlow && dFlow < 0.1) continue;
            String strCompName = pDataFlow.getStrOwnerName();
            double dPmax = this.getPmaxFromTPDB(strCompName, pDataFlow.getnBlock());
            if (this.mNames.get(strCompName) == null) continue;
            double dPmin = 0.0;
            if (!(dPmax > 0.0)) continue;
            if (dPmin == 0.0) {
                dPmin = -1.0 * dPmax;
            }
            double dLineLoad = Math.abs(dFlow / Math.min(Math.abs(dPmax), Math.abs(dPmin)));
            assert (dLineLoad <= 1.0) : "Why flow is greater than limit in line " + pDataFlow.getStrOwnerName();
            if (!(dLineLoad >= this.dLineTol)) continue;
            ParameterData pDataLineload = new ParameterData("lineload");
            pDataLineload.setStrOwnerName(pDataFlow.getStrOwnerName());
            pDataLineload.setnBlock(pDataFlow.getnBlock());
            pDataLineload.setnHydro(pDataFlow.getnHydro());
            pDataLineload.setdValue(dLineLoad);
            lDataLineLoad.add(pDataLineload);
        }
        return lDataLineLoad;
    }

    public ArrayList<TACongestionInfo> getCongestionList() {
        if (this.lCongestion == null) {
            this.lCongestion = this.computeCongestionList();
        }
        return this.lCongestion;
    }

    private ArrayList<TACongestionInfo> computeCongestionList() {
        ArrayList<TACongestionInfo> lmyCongestion = new ArrayList<TACongestionInfo>();
        for (ndb_branch branch : this.ndb_branches) {
            if (!branch.getactive() || !branch.getinservice() || this.bUseDoubleCircuit && !branch.hasParallelBranches()) continue;
            String sLimitDetails = this.getTransmissionDetails(branch.getName());
            if (sLimitDetails == null) {
                sLimitDetails = "No available description";
            }
            TACongestionInfo oCongestion = new TACongestionInfo(this.finalBlock, this.finalHydro);
            for (ParameterData pData : this.lCmgDiff) {
                if (!pData.getStrOwnerName().equals(branch.getName())) continue;
                double dCmgDiff = pData.getdValue();
                double dFlow = this.getFlowFromTPDB(branch.getName(), pData.getnBlock(), pData.getnHydro());
                oCongestion.addCongestion(dCmgDiff, DE_GeneralEnums.CongestionType.MarginalCostDiff, dCmgDiff, dFlow, pData.getnBlock(), pData.getnHydro(), sLimitDetails);
            }
            for (ParameterData pData : this.lBranchLoad) {
                if (!pData.getStrOwnerName().equals(branch.getName())) continue;
                double dLoadMargin = pData.getdValue();
                double dCmgDiff = this.getCmgDiffFromTPDB(branch.getName(), pData.getnBlock(), pData.getnHydro());
                double dFlow = this.getFlowFromTPDB(branch.getName(), pData.getnBlock(), pData.getnHydro());
                oCongestion.addCongestion(dLoadMargin, DE_GeneralEnums.CongestionType.BranchLoadMargin, dCmgDiff, dFlow, pData.getnBlock(), pData.getnHydro(), sLimitDetails);
            }
            if (oCongestion.getTotalOccurrences() <= 0) continue;
            oCongestion.setBranch(branch);
            double dIndex = this.dPriceFactor * oCongestion.getAverage(DE_GeneralEnums.CongestionType.MarginalCostDiff);
            dIndex += this.dLineLoadFactor * oCongestion.getAverage(DE_GeneralEnums.CongestionType.BranchLoadMargin);
            dIndex += this.dProbabilityFactor * oCongestion.getProbability();
            oCongestion.setIndex(dIndex += this.dMarginalIncomeFactor * oCongestion.getAvgMarginalIncome());
            lmyCongestion.add(oCongestion);
        }
        return lmyCongestion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAffectedMarketParticipants(TACongestionInfo myCongestion) {
        int nContract = 0;
        int nTotalPeriods = this.finalBlock * this.finalHydro;
        int nTotalWheelContract = this.mdb_wheels.size();
        if (myCongestion == null) {
            return;
        }
        if (!this.bCalculateMarketBalance) {
            TACongestion.showProgressFrame("Calculating Affected Customers", null);
        }
        TACongestion.setMessageText("Initializing calculation of customer balance. Please wait...", 2);
        for (mdb_wheel myWheel : this.mdb_wheels) {
            String strBusbarLoad;
            int nLoad;
            int nUnit;
            int nPeriod;
            int nHydro;
            int nBlock;
            comp oComp;
            myWheel.InformAllComponents();
            mdb_act tempComp = myWheel.getoSupplier();
            if (!(tempComp instanceof mdb_sup)) continue;
            mdb_sup mySupplier = tempComp;
            tempComp = myWheel.getoCustomer();
            if (!(tempComp instanceof mdb_cust)) continue;
            mdb_cust myCustomer = (mdb_cust)tempComp;
            int nTotalUnits = mySupplier.Components.size();
            int nTotalLoads = myCustomer.Components.size();
            double[][] CmgInj = new double[nTotalUnits][nTotalPeriods];
            double[][] CmgInj_Theory = new double[nTotalUnits][nTotalPeriods];
            double[][] Inj_p = new double[nTotalUnits][nTotalPeriods];
            double[][] CmgLoad = new double[nTotalLoads][nTotalPeriods];
            double[][] CmgLoad_Theory = new double[nTotalLoads][nTotalPeriods];
            double[][] Load_p = new double[nTotalLoads][nTotalPeriods];
            ArrayList<String> sBusbar = new ArrayList<String>();
            ArrayList<String> sGenerators = new ArrayList<String>();
            ArrayList<String> sLoads = new ArrayList<String>();
            for (Object o : mySupplier.Components) {
                oComp = (comp)o;
                oComp.InformAllComponents();
                sGenerators.add(oComp.getName());
                sBusbar.add(oComp.getcon2());
            }
            for (Object o : myCustomer.Components) {
                oComp = (comp)o;
                oComp.InformAllComponents();
                sLoads.add(oComp.getcon2());
                sBusbar.add(oComp.getcon2());
            }
            String sWhereCmg = "resultName='cmg'";
            String sWhereGen = "resultName='gen_p'";
            String sWhereLoad = "resultName='load_p'";
            boolean isFirst = true;
            for (String s : sBusbar) {
                if (isFirst) {
                    sWhereCmg = sWhereCmg + " AND objectName='" + s + "'";
                    isFirst = false;
                    continue;
                }
                sWhereCmg = sWhereCmg + " OR objectName='" + s + "'";
            }
            isFirst = true;
            for (String s : sGenerators) {
                if (isFirst) {
                    sWhereGen = sWhereGen + " AND objectName='" + s + "'";
                    isFirst = false;
                    continue;
                }
                sWhereGen = sWhereGen + " OR objectName='" + s + "'";
            }
            isFirst = true;
            for (String s : sLoads) {
                if (isFirst) {
                    sWhereLoad = sWhereLoad + " AND objectName='" + s + "'";
                    isFirst = false;
                    continue;
                }
                sWhereLoad = sWhereLoad + " OR objectName='" + s + "'";
            }
            Connection conTADB = null;
            try {
                conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, false);
                this.lCmg = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", sWhereCmg, "spotp", "Busbar");
                this.lGenerationP = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", sWhereGen, "p0", "Generator");
                this.lLoadP = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", sWhereLoad, "pini", "Load");
            }
            catch (SQLException e) {
                try {
                    System.out.println("Error querying balance data for wheeling contract '" + myWheel.getName() + "' from TPDB. Details: " + e);
                }
                catch (Throwable throwable) {
                    DeepEdit.CloseJDBCConnection(conTADB);
                    throw throwable;
                }
                DeepEdit.CloseJDBCConnection(conTADB);
                continue;
            }
            DeepEdit.CloseJDBCConnection(conTADB);
            block10: for (ParameterData pData : this.lCmg) {
                nBlock = pData.getnBlock();
                nPeriod = myCongestion.getPeriodID(nBlock, nHydro = pData.getnHydro());
                if (!myCongestion.lperiodId.contains(nPeriod)) continue;
                double dCmgSlack = this.getTheoreticalMarginalCost(nBlock, nHydro);
                nUnit = 0;
                for (Object o : mySupplier.Components) {
                    if (!(o instanceof Generator)) continue;
                    Generator myGen = (Generator)o;
                    String strBusbarInj = myGen.con2;
                    if (pData.getStrOwnerName().equals(strBusbarInj)) {
                        CmgInj[nUnit][nPeriod] = pData.getdValue();
                        CmgInj_Theory[nUnit][nPeriod] = dCmgSlack * (1.0 - this.getMarginalLossAtNode(strBusbarInj, nBlock, nHydro));
                    }
                    ++nUnit;
                }
                nLoad = 0;
                for (Object o : myCustomer.Components) {
                    if (!(o instanceof Load)) continue;
                    Load myLoad = (Load)o;
                    strBusbarLoad = myLoad.con2;
                    if (pData.getStrOwnerName().equals(strBusbarLoad)) {
                        CmgLoad[nLoad][nPeriod] = pData.getdValue();
                        CmgLoad_Theory[nLoad][nPeriod] = dCmgSlack * (1.0 - this.getMarginalLossAtNode(strBusbarLoad, nBlock, nHydro));
                        continue block10;
                    }
                    ++nLoad;
                }
            }
            for (ParameterData pData : this.lGenerationP) {
                nBlock = pData.getnBlock();
                nPeriod = myCongestion.getPeriodID(nBlock, nHydro = pData.getnHydro());
                if (!myCongestion.lperiodId.contains(nPeriod)) continue;
                nUnit = 0;
                for (Object o : mySupplier.Components) {
                    if (!(o instanceof Generator)) continue;
                    Generator myGen = (Generator)o;
                    if (pData.getStrOwnerName().equals(myGen.getName())) {
                        Inj_p[nUnit][nPeriod] = pData.getdValue();
                    }
                    ++nUnit;
                }
            }
            nLoad = 0;
            for (ParameterData o : myCustomer.Components) {
                if (o instanceof Load) {
                    Load myLoad = (Load)((Object)o);
                    double dLoadFactor = myLoad.getLoadFactor();
                    for (ParameterData pData : this.lLoadP) {
                        nBlock = pData.getnBlock();
                        nPeriod = myCongestion.getPeriodID(nBlock, nHydro = pData.getnHydro());
                        if (!myCongestion.lperiodId.contains(nPeriod)) continue;
                        strBusbarLoad = myLoad.con2;
                        if (!pData.getStrOwnerName().equals(strBusbarLoad)) continue;
                        Load_p[nLoad][nPeriod] = pData.getdValue() * dLoadFactor;
                    }
                }
                ++nLoad;
            }
            mdb_wheel[] wheels = myCustomer.InformAllWheelingContracts();
            mdb_wheel[] orderedWheels = new mdb_wheel[wheels.length];
            for (int i = 0; i < wheels.length; ++i) {
                if (i == 0) {
                    orderedWheels[i] = wheels[i];
                    continue;
                }
                if (wheels[i].getprio() > orderedWheels[i - 1].getprio()) {
                    orderedWheels[i] = wheels[i];
                    continue;
                }
                orderedWheels[i] = orderedWheels[i - 1];
                orderedWheels[i - 1] = wheels[i];
            }
            for (int periodID : myCongestion.getCongestionPeriods()) {
                double dBalanceReal = 0.0;
                double dBalanceTheory = 0.0;
                nBlock = myCongestion.getBlockFromPeriodID(periodID);
                nHydro = myCongestion.getHydroFromPeriodID(periodID);
                double dDuration = this.blockDuration.get(nBlock);
                boolean bIsAffected = false;
                for (nUnit = 0; nUnit < nTotalUnits; ++nUnit) {
                    double dCmgInj = CmgInj[nUnit][periodID];
                    double dCmgInj_Theory = CmgInj_Theory[nUnit][periodID];
                    double dInj = Inj_p[nUnit][periodID];
                    for (nLoad = 0; nLoad < nTotalLoads; ++nLoad) {
                        double dCmgLoad = CmgLoad[nLoad][periodID];
                        double dCmgLoad_Theory = CmgLoad_Theory[nLoad][periodID];
                        double dLoad_p = Load_p[nLoad][periodID];
                        if (dLoad_p < 0.001 || dInj < 0.001) continue;
                        double dRelPriceLoad = Utils.safeDivision(dCmgLoad - dCmgInj, dCmgInj);
                        double dRelPriceLoad_Theory = 0.0;
                        if (this.bUseDynPriceDiff) {
                            dRelPriceLoad_Theory = Utils.safeDivision(dCmgLoad_Theory - dCmgInj_Theory, dCmgInj_Theory);
                        }
                        if (dRelPriceLoad > dRelPriceLoad_Theory + this.dRelPriceDiffTol) {
                            bIsAffected = true;
                        }
                        double dRelPriceInj = Utils.safeDivision(dCmgInj - dCmgLoad, dCmgLoad);
                        double dRelPriceInj_Theory = 0.0;
                        if (this.bUseDynPriceDiff) {
                            dRelPriceInj_Theory = Utils.safeDivision(dCmgInj_Theory - dCmgLoad_Theory, dCmgLoad_Theory);
                        }
                        if (!(dRelPriceInj > dRelPriceInj_Theory + this.dRelPriceDiffTol)) continue;
                        bIsAffected = true;
                    }
                }
                for (nUnit = 0; nUnit < nTotalUnits; ++nUnit) {
                    for (nLoad = 0; nLoad < nTotalLoads; ++nLoad) {
                        if (bIsAffected) continue;
                        CmgInj_Theory[nUnit][periodID] = CmgInj[nUnit][periodID];
                        CmgLoad_Theory[nLoad][periodID] = CmgLoad[nLoad][periodID];
                    }
                }
                double dCustLoad = 0.0;
                for (nLoad = 0; nLoad < nTotalLoads; ++nLoad) {
                    dCustLoad += Load_p[nLoad][periodID];
                }
                double dMyPmax = myWheel.getpcontract();
                double dPmaxOtherContract = 0.0;
                for (mdb_wheel w : orderedWheels) {
                    if (w.hashCode() == myWheel.hashCode()) {
                        if (!(dCustLoad - dPmaxOtherContract > 0.0)) break;
                        dMyPmax = Math.min(dMyPmax, dCustLoad - dPmaxOtherContract);
                        break;
                    }
                    dPmaxOtherContract += w.getpcontract();
                }
                double dContLoadFactor = dMyPmax > dCustLoad ? 1.0 : Utils.safeDivision(dMyPmax, dCustLoad);
                for (nUnit = 0; nUnit < nTotalUnits; ++nUnit) {
                    dBalanceReal += CmgInj[nUnit][periodID] * Inj_p[nUnit][periodID] * dDuration;
                    dBalanceTheory += CmgInj_Theory[nUnit][periodID] * Inj_p[nUnit][periodID] * dDuration;
                }
                for (nLoad = 0; nLoad < nTotalLoads; ++nLoad) {
                    dBalanceReal -= CmgLoad[nLoad][periodID] * Load_p[nLoad][periodID] * dDuration * dContLoadFactor;
                    dBalanceTheory -= CmgLoad_Theory[nLoad][periodID] * Load_p[nLoad][periodID] * dDuration * dContLoadFactor;
                }
                if (!((dBalanceReal /= (double)this.finalHydro) < (dBalanceTheory /= (double)this.finalHydro))) continue;
                myCongestion.addAffectedMarketParticipant(mySupplier, myWheel.getName(), dBalanceReal, dBalanceTheory, nBlock, nHydro);
            }
            TACongestion.setProgress((int)(Utils.safeDivision(++nContract, nTotalWheelContract) * 100.0));
        }
        if (!this.bCalculateMarketBalance) {
            TACongestion.disposeProgressFrame();
        }
        TACongestion.setMessageText("Finished updating market balance and affected participants for congestion periods in line " + myCongestion.getBranch().getName());
    }

    public void updateAffectedCustomers(TACongestionInfo myCongestion) {
        if (myCongestion == null) {
            return;
        }
        long timeQry = 0L;
        long timeComp = 0L;
        Connection conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, false);
        ArrayList<Integer> lUniqueBlocks = new ArrayList<Integer>();
        if (!this.bCalculateMarketBalance) {
            TACongestion.showProgressFrame("Calculating Affected Customers", null);
        }
        TACongestion.setMessageText("Initializing calculation of customer balance. Please wait...", 2);
        int nTotalCongestionPeriods = myCongestion.getNonConcurrentOccurrences();
        int nCurrentPeriod = 0;
        for (int periodID : myCongestion.getCongestionPeriods()) {
            double dBalanceReal = 0.0;
            double dBalanceTheory = 0.0;
            int nBlock = myCongestion.getBlockFromPeriodID(periodID);
            int nHydro = myCongestion.getHydroFromPeriodID(periodID);
            double dDuration = this.getBlockDuration(nBlock);
            long timeIni = System.currentTimeMillis();
            ArrayList<Object> lCmgL = new ArrayList();
            ArrayList<Object> lLoad_P = new ArrayList();
            try {
                lCmgL = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "cmg", nBlock, nHydro, "cmg_p", "Busbar");
                if (!lUniqueBlocks.contains(nBlock)) {
                    lLoad_P = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "load_p", nBlock, "pini", "Load");
                    lUniqueBlocks.add(nBlock);
                }
            }
            catch (SQLException e) {
                System.out.println("Error querying customer balance period [" + nBlock + "] hydro{" + nHydro + "] from TPDB. Details: " + e);
                DeepEdit.CloseJDBCConnection(conTADB);
                return;
            }
            timeQry += System.currentTimeMillis() - timeIni;
            timeIni = System.currentTimeMillis();
            HashMap<String, Integer> mBusNamesInCmg = new HashMap<String, Integer>(lCmgL.size());
            HashMap<String, Integer> mBusNamesInLoad = new HashMap<String, Integer>(lLoad_P.size());
            double[] CmgLoad = new double[lCmgL.size()];
            double[] CmgLoad_Theory = new double[lCmgL.size()];
            double[] Load_P = new double[lLoad_P.size()];
            double dCmgSlack = this.getTheoreticalMarginalCost(nBlock, nHydro);
            int cont = 0;
            for (ParameterData parameterData : lCmgL) {
                mBusNamesInCmg.put(parameterData.getStrOwnerName(), cont);
                CmgLoad[cont] = parameterData.getdValue();
                CmgLoad_Theory[cont] = dCmgSlack * (1.0 - this.getMarginalLossAtNode(parameterData.getStrOwnerName(), nBlock, nHydro));
                ++cont;
            }
            cont = 0;
            for (ParameterData parameterData : lLoad_P) {
                mBusNamesInLoad.put(parameterData.getStrOwnerName(), cont);
                Load_P[cont] = parameterData.getdValue();
                ++cont;
            }
            for (Load load : this.Loads) {
                load.InformAllComponents();
                String busbarName = load.getcon2();
                double dLoadFactor = load.getLoadFactor();
                if (busbarName == null) continue;
                Integer nLoad = (Integer)mBusNamesInLoad.get(busbarName);
                Integer nBusbar = (Integer)mBusNamesInCmg.get(busbarName);
                if (nLoad == null || nBusbar == null || Load_P[nLoad] < 0.001 || !(Math.abs(Utils.safeDivision(CmgLoad[nBusbar] - CmgLoad_Theory[nBusbar], CmgLoad_Theory[nBusbar])) > this.dRelPriceDiffTol)) continue;
                dBalanceReal = -CmgLoad[nBusbar] * Load_P[nLoad] * dLoadFactor * dDuration / (double)this.finalHydro;
                dBalanceTheory = -CmgLoad_Theory[nBusbar] * Load_P[nLoad] * dLoadFactor * dDuration / (double)this.finalHydro;
                myCongestion.addAffectedMarketParticipant(load, TACongestionInfo.CUSTOMER_BALANCE, dBalanceReal, dBalanceTheory, nBlock, nHydro);
            }
            timeComp += System.currentTimeMillis() - timeIni;
            TACongestion.setProgress((int)(Utils.safeDivision(++nCurrentPeriod, nTotalCongestionPeriods) * 100.0));
        }
        if (!this.bCalculateMarketBalance) {
            TACongestion.disposeProgressFrame();
        }
        DeepEdit.CloseJDBCConnection(conTADB);
        TACongestion.setMessageText("Finished updating customer balance. Total querying time: " + timeQry / 1000L + "[sec]");
        TACongestion.setMessageText("Total calculation time: " + (timeQry + timeComp) / 1000L + "[sec]");
    }

    public double getMarginalLossAtNode(String BusbarName, int nBlock, int nHydro) {
        Integer nodeID;
        if (this.pf == null) {
            this.computePenaltyFactor();
        }
        if ((nodeID = this.mNodesName2GSDF_ID.get(BusbarName)) == null) {
            return 0.0;
        }
        return this.pf[nodeID][nBlock][nHydro];
    }

    private void computePenaltyFactor() {
        int nBranches = this.ndb_branches.size();
        int nBusbars = this.Busbars.size();
        double[] Resistance = new double[nBranches];
        int[] Conn1 = new int[nBranches];
        int[] Conn2 = new int[nBranches];
        this.pf = new double[nBusbars][this.finalBlock][this.finalHydro];
        this.mBranchName2GSDF_ID = new HashMap<String, Integer>();
        this.mNodesName2GSDF_ID = new HashMap<String, Integer>();
        SensitivitiesJAVA mySensi = new SensitivitiesJAVA(this.ActSchematic, "All", false, 1, false, false);
        double[][] dGSDF = mySensi.getGSDF(0, 0);
        for (ndb_branch branch : this.ndb_branches) {
            int idBranch = mySensi.getBranchID(branch.getName());
            if (idBranch == -1) continue;
            this.mBranchName2GSDF_ID.put(branch.getName(), idBranch);
            Resistance[idBranch] = branch.getSeriesResistance(this.sref);
            Conn1[idBranch] = mySensi.numbus(branch.getcon1());
            Conn2[idBranch] = mySensi.numbus(branch.getcon2());
            assert (Conn1[idBranch] != -1) : "GSDF tool used the branch " + branch.getName() + " but not the sender node. Posible bug in Sensitivity tool";
            assert (Conn2[idBranch] != -1) : "GSDF tool used the branch " + branch.getName() + " but not the reciever node. Posible bug in Sensitivity tool";
        }
        for (Busbar bar : this.Busbars) {
            int idNode = mySensi.numbus(bar.getName());
            if (idNode == -1) continue;
            this.mNodesName2GSDF_ID.put(bar.getName(), idNode);
        }
        for (ndb_branch branch : this.ndb_branches) {
            Integer idBranch = this.mBranchName2GSDF_ID.get(branch.getName());
            if (idBranch == null) continue;
            for (int nBlock = 0; nBlock < this.finalBlock; ++nBlock) {
                for (int nHydro = 0; nHydro < this.finalHydro; ++nHydro) {
                    double incrLosses = 2.0 * Resistance[idBranch] * this.getFlowFromTPDB(branch.getName(), nBlock, nHydro) / this.sref;
                    for (Integer idBus : this.mNodesName2GSDF_ID.values()) {
                        double[] dArray = this.pf[idBus][nBlock];
                        int n = nHydro;
                        dArray[n] = dArray[n] + incrLosses * dGSDF[idBranch][idBus];
                    }
                }
            }
        }
    }

    public double getTheoreticalMarginalCost(int nBlock, int nHydro) {
        if (this.Cmg_Theory == null) {
            Busbar oSlackBus = this.getSlackBurbar();
            if (oSlackBus == null) {
                return 0.0;
            }
            this.computeTheoreticalMarginalCost();
        }
        if (nBlock > this.Cmg_Theory.length || nHydro > this.Cmg_Theory[0].length) {
            return 0.0;
        }
        return this.Cmg_Theory[nBlock][nHydro];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTheoreticalMarginalCost() {
        this.Cmg_Theory = new double[this.finalBlock][this.finalHydro];
        Busbar oSlackBus = this.getSlackBurbar();
        if (oSlackBus == null) {
            return;
        }
        ArrayList<Object> lCmgSlack = new ArrayList();
        Connection conTADB = null;
        try {
            conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, false);
            lCmgSlack = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "cmg", oSlackBus.getName(), "spotp", "Busbar");
        }
        catch (SQLException e) {
            try {
                System.out.println("Error querying slack bus '" + oSlackBus.getName() + "' marginal cost. Details: " + e);
            }
            catch (Throwable throwable) {
                DeepEdit.CloseJDBCConnection(conTADB);
                throw throwable;
            }
            DeepEdit.CloseJDBCConnection(conTADB);
        }
        DeepEdit.CloseJDBCConnection(conTADB);
        for (ParameterData parameterData : lCmgSlack) {
            if (!parameterData.getStrOwnerName().equals(oSlackBus.getName())) continue;
            int nCurrentBlock = parameterData.getnBlock();
            int nCurrentHydro = parameterData.getnHydro();
            this.Cmg_Theory[nCurrentBlock][nCurrentHydro] = parameterData.getdValue();
        }
    }

    public static void setSchematicObjectOwner(Schematic sch, ArrayList<ParameterData> lData, String strClass) {
        for (ParameterData pData : lData) {
            comp c = sch.SearchComponentByName(strClass, pData.getStrOwnerName());
            if (c == null) continue;
            pData.setoOwnerComponent(c);
            c.InformAllComponents();
        }
    }

    private boolean updateALLFromTADatabase() {
        Connection conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, true);
        if (!this.initializeDatesFromTPDB(conTADB)) {
            System.out.println("Error initializing dates. Execution stopped. No further queries will be performed");
            try {
                conTADB.close();
            }
            catch (SQLException ex) {
                System.out.println("Error closing the database connection after retrieving dates. Details: " + ex);
                return false;
            }
            return false;
        }
        TACongestion.setMessageText("Retrieving flow data from Database", 25);
        try {
            this.lFlowP = TPDBProcessor.executeTPDBQuery("flow", "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", conTADB, "p12", null);
            for (ParameterData pDataFlow : this.lFlowP) {
                this.addFlowFromTPDB(pDataFlow.getdValue(), pDataFlow.getStrOwnerName(), pDataFlow.getnBlock(), pDataFlow.getnHydro());
            }
        }
        catch (SQLException ex) {
            System.out.println("Error retrieving flow from database: " + ex.getMessage());
            return false;
        }
        try {
            this.lFlowPMax = TPDBProcessor.executeTPDBQuery("maxflow_p", "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", conTADB, "smax", null);
        }
        catch (SQLException ex) {
            System.out.println("Error retrieving maxflow_p from database: " + ex.getMessage());
            return false;
        }
        try {
            this.lFlowPMin = TPDBProcessor.executeTPDBQuery("minflow_p", "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", conTADB, "pmin", null);
        }
        catch (SQLException ex) {
            System.out.println("Error retrieving minflow_p from database: " + ex.getMessage());
            return false;
        }
        try {
            this.lInservice = TPDBProcessor.executeTPDBQuery("units", "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", conTADB, "inservice", null);
        }
        catch (SQLException ex) {
            System.out.println("Error retrieving units from database: " + ex.getMessage());
            return false;
        }
        TACongestion.setMessageText("Retrieving busbar data from Database", 65);
        try {
            this.lCmg = TPDBProcessor.executeTPDBQuery("cmg", "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", conTADB, "spotp", "Busbar");
        }
        catch (SQLException ex) {
            System.out.println("Error retrieving cmg from database: " + ex.getMessage());
            return false;
        }
        DeepEdit.CloseJDBCConnection(conTADB);
        return true;
    }

    public void dispatchFileDataToDatabase(String strTPDBDabasePath, String strInputFolder, String strOutFolder, String nInputFileType) {
        TPDBProcessor myProcess = new TPDBProcessor(strTPDBDabasePath, strInputFolder, strOutFolder, nInputFileType);
        Thread TAThread = new Thread((Runnable)myProcess, "Thread-Calculate");
        TAThread.start();
    }

    public double[] getFlowInTPDB(String sBranchName) throws SQLException {
        String TPDBparameterName = "flow";
        String strWhere = " objectName = '" + sBranchName + "' AND resultName='" + TPDBparameterName + "'";
        Connection conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, true);
        ArrayList<ParameterData> lData = TPDBProcessor.executeTPDBQuery(conTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", strWhere, TPDBparameterName, null);
        DeepEdit.CloseJDBCConnection(conTADB);
        Double[] Flows = new Double[lData.size()];
        for (int i = 0; i < lData.size(); ++i) {
            Flows[i] = lData.get(i).getdValue();
        }
        Arrays.sort(Flows, Collections.reverseOrder());
        double[] dFlows = new double[Flows.length];
        for (int i = 0; i < Flows.length; ++i) {
            dFlows[i] = Flows[i];
        }
        return dFlows;
    }

    private boolean initializeDatesFromTPDB() {
        Connection conTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, true);
        boolean bIsSuccess = this.initializeDatesFromTPDB(conTADB);
        DeepEdit.CloseJDBCConnection(conTADB);
        return bIsSuccess;
    }

    private boolean initializeDatesFromTPDB(Connection conTADB) {
        int nInitialHourDB;
        int nInitialDayDB;
        int nInitialMonthDB;
        int nInitialYearDB;
        ResultSet r;
        Statement s;
        try {
            s = conTADB.createStatement();
            r = s.executeQuery("SELECT * FROM SimInfo");
            if (!r.next()) {
                return false;
            }
            nInitialYearDB = r.getInt("InitialYear");
            nInitialMonthDB = r.getInt("InitialMonth");
            nInitialDayDB = r.getInt("InitialDay");
            nInitialHourDB = r.getInt("InitialHour");
            this.initialBlock = 0;
            this.finalBlock = r.getInt("BlockNumber");
            this.finalHydro = r.getInt("HydroNumber");
            this.sSoftwareSource = r.getString("SoftwareSource");
        }
        catch (SQLException ex) {
            System.out.println("Error querying 'SimInfo' table from database: " + ex.getMessage());
            DeepEdit.CloseJDBCConnection(conTADB);
            return false;
        }
        this.blockDuration = new ArrayList();
        try {
            s = conTADB.createStatement();
            r = s.executeQuery("SELECT * FROM blockTime ORDER BY BlockNumber");
            while (r.next()) {
                this.blockDuration.add(r.getDouble("Duration"));
            }
        }
        catch (SQLException ex) {
            System.out.println("Error querying 'blockTime' table from database: " + ex.getMessage());
            DeepEdit.CloseJDBCConnection(conTADB);
            return false;
        }
        double dCumulateDuration = 0.0;
        Calendar c = Calendar.getInstance();
        c.set(nInitialYearDB, nInitialMonthDB - 1, nInitialDayDB, nInitialHourDB, 0);
        for (int b = 0; b < this.blockDuration.size(); ++b) {
            dCumulateDuration += this.blockDuration.get(b).doubleValue();
            if (b == this.initialBlock) {
                this.initialDateDB = Calendar.getInstance();
                this.initialDateDB.setTime(c.getTime());
            } else if (b == this.finalBlock || b == this.blockDuration.size() - 1) {
                this.finalDateDB = Calendar.getInstance();
                this.finalDateDB.setTime(c.getTime());
            }
            c.add(11, this.blockDuration.get(b).intValue());
        }
        return true;
    }

    private boolean useFullMemory() {
        return this.getDBVendor() == DE_GeneralEnums.DatabaseVendor.SQLite && (double)(this.finalBlock * this.finalHydro * 1000) < 3000000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkActSchematicCompatibility(boolean bShowReport, boolean bUseCSVFormat, boolean bUpdateSchematic) {
        ArrayList<String> lstrMissingBranchesInSch = new ArrayList<String>();
        ArrayList<String> lstrMissingBranchesInTPDB = new ArrayList<String>();
        ArrayList<String> lstrMissingGeneratorsInSch = new ArrayList<String>();
        ArrayList<String> lstrMissingGeneratorsInTPDB = new ArrayList<String>();
        ArrayList<String> lstrMissingBusbarsInSch = new ArrayList<String>();
        ArrayList<String> lstrMissingBusbarsInTPDB = new ArrayList<String>();
        ArrayList<String> lstrMissingLoadsInSch = new ArrayList<String>();
        ArrayList<String> lstrMissingLoadsInTPDB = new ArrayList<String>();
        Connection MyConnTADB = DeepEdit.OpenJDBCConnection(this.sDBPath, true);
        if (MyConnTADB == null) {
            System.out.println("Error opening TPDB database. Current Schematic hasn't been updated.");
            return;
        }
        try {
            this.checkTPDBSchDifferences(MyConnTADB, "flow", this.ndb_branches, lstrMissingBranchesInSch, lstrMissingBranchesInTPDB);
            this.checkTPDBSchDifferences(MyConnTADB, "gen_p", this.Generators, lstrMissingGeneratorsInSch, lstrMissingGeneratorsInTPDB);
            this.checkTPDBSchDifferences(MyConnTADB, "cmg", this.Busbars, lstrMissingBusbarsInSch, lstrMissingBusbarsInTPDB);
            this.checkTPDBSchDifferences(MyConnTADB, "cmg", this.Loads, lstrMissingLoadsInSch, lstrMissingLoadsInTPDB);
        }
        catch (SQLException ex) {
            System.out.println("Unable to verify database compatibility with current Schematic.");
            System.out.println("Error retrieving parameters required to update schematic from database: " + ex.getMessage());
            return;
        }
        finally {
            DeepEdit.CloseJDBCConnection(MyConnTADB);
        }
        if (bUpdateSchematic) {
            comp TempComponent;
            for (ndb_branch branch : this.ndb_branches) {
                branch.setinservice(true);
            }
            for (Generator gen : this.Generators) {
                gen.setinservice(true);
            }
            for (Load load : this.Loads) {
                load.setinservice(true);
            }
            for (Busbar bus : this.Busbars) {
                bus.setinservice(true);
            }
            for (String s : lstrMissingBranchesInTPDB) {
                TempComponent = this.ActSchematic.SearchComponentByName("Line", s);
                if (TempComponent == null) {
                    TempComponent = this.ActSchematic.SearchComponentByName("Trafo", s);
                }
                assert (TempComponent != null) : "Bug in function checkDifferences(): it shouldn't have returned component " + s + " as missing if it wasn't in schematic ";
                TempComponent.setinservice(false);
                if (!DeepEdit.PrintConnecWarnings) continue;
                System.out.println(TempComponent.getName() + " disabled in current schematic...");
            }
            for (String s : lstrMissingGeneratorsInTPDB) {
                TempComponent = this.ActSchematic.SearchComponentByName("Generator", s);
                if (TempComponent == null && (TempComponent = this.ActSchematic.SearchComponentByName("GeneratorEO", s)) == null) {
                    TempComponent = this.ActSchematic.SearchComponentByName("GeneratorPV", s);
                }
                assert (TempComponent != null) : "Bug in function checkDifferences(): it shouldn't have returned component " + s + " as missing if it wasn't in schematic ";
                TempComponent.setinservice(false);
                if (!DeepEdit.PrintConnecWarnings) continue;
                System.out.println(TempComponent.getName() + " disabled in current schematic...");
            }
            for (String s : lstrMissingBusbarsInTPDB) {
                TempComponent = this.ActSchematic.SearchComponentByName("Busbar", s);
                assert (TempComponent != null) : "Bug in function checkDifferences(): it shouldn't have returned component " + s + " as missing if it wasn't in schematic ";
                TempComponent.setinservice(false);
                TempComponent = this.ActSchematic.SearchComponentByName("Load", s);
                if (TempComponent == null) {
                    if (!DeepEdit.PrintConnecWarnings) continue;
                    System.out.println("Load " + s + " is missing from schematic...");
                    continue;
                }
                TempComponent.setinservice(false);
                if (!DeepEdit.PrintConnecWarnings) continue;
                System.out.println(TempComponent.getName() + " disabled in current schematic...");
            }
        }
        if (this.bMakeReport) {
            ArrayList<String> sPrintDifferences = new ArrayList<String>();
            String strSeparator = bUseCSVFormat ? "," : "                                       ";
            for (String s : lstrMissingBranchesInSch) {
                sPrintDifferences.add(StringUtil.printf("MissingInSchematic" + strSeparator, 35) + StringUtil.printf(" Branch" + strSeparator, 35) + s);
            }
            for (String s : lstrMissingGeneratorsInSch) {
                sPrintDifferences.add(StringUtil.printf("MissingInSchematic" + strSeparator, 35) + StringUtil.printf(" Generator" + strSeparator, 35) + s);
            }
            for (String s : lstrMissingBusbarsInSch) {
                sPrintDifferences.add(StringUtil.printf("MissingInSchematic" + strSeparator, 35) + StringUtil.printf(" Busbar" + strSeparator, 35) + s);
            }
            for (String s : lstrMissingLoadsInSch) {
                sPrintDifferences.add(StringUtil.printf("MissingInSchematic" + strSeparator, 35) + StringUtil.printf(" Load" + strSeparator, 35) + s);
            }
            for (String s : lstrMissingBranchesInTPDB) {
                sPrintDifferences.add(StringUtil.printf("MissingInTPDBDatabase" + strSeparator, 35) + StringUtil.printf(" Branch" + strSeparator, 35) + s);
            }
            for (String s : lstrMissingGeneratorsInTPDB) {
                sPrintDifferences.add(StringUtil.printf("MissingInTPDBDatabase" + strSeparator, 35) + StringUtil.printf(" Generator" + strSeparator, 35) + s);
            }
            for (String s : lstrMissingBusbarsInTPDB) {
                sPrintDifferences.add(StringUtil.printf("MissingInTPDBDatabase" + strSeparator, 35) + StringUtil.printf(" Busbar" + strSeparator, 35) + s);
            }
            for (String s : lstrMissingLoadsInTPDB) {
                sPrintDifferences.add(StringUtil.printf("MissingInTPDBDatabase" + strSeparator, 35) + StringUtil.printf(" Load" + strSeparator, 35) + s);
            }
            File f = new File(this.sSchDiffReportFile);
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(f));
                pw.println(StringUtil.printf("MissMatchType" + strSeparator, 35) + StringUtil.printf(" Class" + strSeparator, 35) + "Name");
                for (String linea : sPrintDifferences) {
                    pw.println(linea);
                }
                pw.close();
            }
            catch (IOException ex) {
                System.out.println("Error while writing comparison results to the log file " + f.getAbsolutePath());
                System.out.println("Exception details: " + ex.getMessage());
                return;
            }
            if (!bUseCSVFormat && bShowReport) {
                this.ActFrame.DoListResults(f.getAbsolutePath());
            }
        }
    }

    private void checkTPDBSchDifferences(Connection conTADB, String TPDBparameterName, ArrayList<? extends comp> lwhereToLook, ArrayList<String> lstrMissingInSch, ArrayList<String> lstrMissingInTPDB) throws SQLException {
        assert (lwhereToLook != null || lstrMissingInSch != null || lstrMissingInTPDB != null) : "This function requires arrays to be initialized. Do so from where you call it";
        ArrayList<String> lObjectNamesinDB = TPDBProcessor.getObjectNameInTPDBDatabase(TPDBparameterName, conTADB);
        for (comp comp2 : lwhereToLook) {
            if (!lObjectNamesinDB.contains(comp2.getName())) {
                lstrMissingInTPDB.add(comp2.getName());
                continue;
            }
            lObjectNamesinDB.remove(comp2.getName());
        }
        lstrMissingInSch.addAll(lObjectNamesinDB);
    }

    private void updateSchematic(ArrayList<ParameterData> lData, int nBlock, int nHydro) {
        ArrayList<ParameterData> lOutData = ParameterData.filterParameterData(lData, nBlock, nHydro);
        this.setParameterInfo(lOutData);
    }

    private double getFlowFromTPDB(String strBranchName, int nBlock, int nHydro) {
        if (this.mFlow == null) {
            assert (false) : "Never call this function before calling calculateFlow()";
            return 0.0;
        }
        int nID = (strBranchName + "_" + nBlock + "_" + nHydro).hashCode();
        Double dFlow = this.mFlow.get(nID);
        if (dFlow == null) {
            return 0.0;
        }
        return dFlow;
    }

    private void addFlowFromTPDB(double dValue, String strBranchName, int nBlock, int nHydro) {
        if (this.mFlow == null) {
            this.mFlow = new HashMap<Integer, Double>(this.finalBlock * this.finalHydro);
        }
        int nID = (strBranchName + "_" + nBlock + "_" + nHydro).hashCode();
        this.mFlow.put(nID, dValue);
    }

    public Double[][] getFlowFromTPDB(String sBranchName) {
        Double[][] dFlows = new Double[this.finalBlock][this.finalHydro];
        for (int nBlock = 0; nBlock < this.finalBlock; ++nBlock) {
            for (int nHydro = 0; nHydro < this.finalHydro; ++nHydro) {
                dFlows[nBlock][nHydro] = this.getFlowFromTPDB(sBranchName, nBlock, nHydro);
            }
        }
        return dFlows;
    }

    public double getCmgDiffFromTPDB(String strBranchName, int nBlock, int nHydro) {
        int nID = (strBranchName + "_" + nBlock + "_" + nHydro).hashCode();
        return this.mCmgDiff.get(nID);
    }

    private void addCmgDiffFromTPDB(double dValue, String strBranchName, int nBlock, int nHydro) {
        if (this.mCmgDiff == null) {
            this.mCmgDiff = new HashMap<Integer, Double>(this.finalBlock * this.finalHydro);
        }
        int nID = (strBranchName + "_" + nBlock + "_" + nHydro).hashCode();
        this.mCmgDiff.put(nID, dValue);
    }

    public double getPmaxFromTPDB(String strBranchName, int nBlock) {
        if (this.Pmax != null && this.mNames != null) {
            if (this.mNames.containsKey(strBranchName)) {
                return this.Pmax[this.mNames.get(strBranchName)][nBlock];
            }
            return 0.0;
        }
        this.calculatePmaxFromTPDB();
        if (this.mNames.containsKey(strBranchName)) {
            return this.Pmax[this.mNames.get(strBranchName)][nBlock];
        }
        return 0.0;
    }

    private void calculatePmaxFromTPDB() {
        int row;
        int nBranchesWithPMaxInTPDB;
        Connection myConn = DeepEdit.OpenJDBCConnection(this.sDBPath, true);
        try {
            ArrayList<String> l = TPDBProcessor.getObjectNameInTPDBDatabase("maxflow_p", myConn);
            nBranchesWithPMaxInTPDB = l.size();
        }
        catch (SQLException ex) {
            System.out.println("Unable to retrieve object list from TPDB database. Branches's line loads calculation interrupted");
            System.out.println("SQL Exception details: " + ex);
            DeepEdit.CloseJDBCConnection(myConn);
            return;
        }
        this.mNames = new HashMap<String, Integer>();
        this.Pmax = new double[nBranchesWithPMaxInTPDB][this.finalBlock];
        double[][] PmaxTemp = new double[nBranchesWithPMaxInTPDB][this.finalBlock];
        boolean[][] NewPmax = Utils.getInitBoolean2DArray(nBranchesWithPMaxInTPDB, this.finalBlock, false);
        if (this.lFlowPMax == null || this.lInservice == null) {
            try {
                this.lFlowPMax = TPDBProcessor.executeTPDBQuery("maxflow_p", "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", myConn, "smax", null);
            }
            catch (SQLException ex) {
                System.out.println("Error retrieving maxflow_p from database: " + ex.getMessage());
                DeepEdit.CloseJDBCConnection(myConn);
                return;
            }
            try {
                this.lInservice = TPDBProcessor.executeTPDBQuery("units", "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", myConn, "inservice", null);
            }
            catch (SQLException ex) {
                System.out.println("Error retrieving units from database: " + ex.getMessage());
                DeepEdit.CloseJDBCConnection(myConn);
                return;
            }
        }
        for (ParameterData pDataMaxFlow : this.lFlowPMax) {
            if (pDataMaxFlow.getnHydro() > 0) continue;
            if (this.mNames.containsKey(pDataMaxFlow.getStrOwnerName())) {
                row = this.mNames.get(pDataMaxFlow.getStrOwnerName());
            } else {
                row = this.mNames.size();
                this.mNames.put(pDataMaxFlow.getStrOwnerName(), row);
            }
            assert (row < nBranchesWithPMaxInTPDB) : "Map names should always return an index lower than number of branches in TPDB";
            NewPmax[row][pDataMaxFlow.getnBlock()] = true;
            PmaxTemp[row][pDataMaxFlow.getnBlock()] = pDataMaxFlow.getdValue();
            this.Pmax[row][pDataMaxFlow.getnBlock()] = pDataMaxFlow.getdValue();
            for (int t = pDataMaxFlow.getnBlock() + 1; t < this.finalBlock && !NewPmax[row][t]; ++t) {
                PmaxTemp[row][t] = pDataMaxFlow.getdValue();
                this.Pmax[row][t] = pDataMaxFlow.getdValue();
            }
        }
        boolean[][] NewInservice = Utils.getInitBoolean2DArray(nBranchesWithPMaxInTPDB, this.finalBlock, false);
        for (ParameterData pDataInservice : this.lInservice) {
            Integer ObjRow;
            if (pDataInservice.getnHydro() > 0 || (ObjRow = this.mNames.get(pDataInservice.getStrOwnerName())) == null) continue;
            row = ObjRow;
            NewInservice[row][pDataInservice.getnBlock()] = true;
            this.Pmax[row][pDataInservice.getnBlock()] = PmaxTemp[row][pDataInservice.getnBlock()] * pDataInservice.getdValue();
            for (int t = pDataInservice.getnBlock() + 1; t < this.finalBlock && !NewInservice[row][t]; ++t) {
                this.Pmax[row][t] = PmaxTemp[row][t] * pDataInservice.getdValue();
            }
        }
    }

    public double[] getPmaxFromTPDB(String sBranchName) {
        double[] dMaxFlow = new double[this.finalBlock];
        for (int i = 0; i < this.finalBlock; ++i) {
            dMaxFlow[i] = this.getPmaxFromTPDB(sBranchName, i);
        }
        return dMaxFlow;
    }

    public void createLineLimitXMLFileFromSchematic(String sLimitXMLFile) {
        ArrayList<XmlBranchLimitInfo> myLimits = new ArrayList<XmlBranchLimitInfo>();
        for (ndb_branch branch : this.ndb_branches) {
            XmlBranchLimitInfo myLimit = new XmlBranchLimitInfo(branch.getName(), branch.getsmax(), branch.getsmax(), -1.0 * branch.getsmax(), branch.getsmax(), "Thermal", null);
            myLimits.add(myLimit);
        }
        XmlBranchLimitInfos myXmlLimitList = new XmlBranchLimitInfos();
        myXmlLimitList.setBranchLimitInfo(myLimits);
        try {
            TACongestion.saveLimitsInXml(sLimitXMLFile, myXmlLimitList);
        }
        catch (JAXBException ex) {
            System.out.println("Error saving branch limit details to xml file :" + ex.getMessage());
            System.out.println("Details: " + ex.toString());
        }
    }

    public static void saveLimitsInXml(String sLimitXMLFile, XmlBranchLimitInfos myLimits) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlBranchLimitInfos.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)myLimits, new File(sLimitXMLFile));
    }

    public static XmlBranchLimitInfos loadLimitsFromXML(String sLimitXMLFile) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlBranchLimitInfos.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        XmlBranchLimitInfos myLimits = (XmlBranchLimitInfos)jaxbUnmarshaller.unmarshal(new File(sLimitXMLFile));
        return myLimits;
    }

    private static Map<String, String> getTransmissionDetailsFromXML(String sLimitXMLFile) {
        XmlBranchLimitInfos myInfos;
        HashMap<String, String> mData = new HashMap<String, String>();
        try {
            myInfos = TACongestion.loadLimitsFromXML(sLimitXMLFile);
        }
        catch (JAXBException ex) {
            System.out.println("Unexpected error retrieving limits from input xml file");
            System.out.println("Exception details: " + (Object)((Object)ex));
            return mData;
        }
        if (myInfos == null) {
            return mData;
        }
        for (XmlBranchLimitInfo x : myInfos.getBranchLimitInfo()) {
            mData.put(x.getBranchName(), x.getRealLimitReason());
        }
        return mData;
    }

    private String getTransmissionDetails(String ComponentName) {
        if (this.mTransmissionDetails == null || this.isRecalculate()) {
            this.mTransmissionDetails = TACongestion.getTransmissionDetailsFromXML(this.sLimitXMLFile);
        }
        String sLimitReason = this.mTransmissionDetails.get(ComponentName);
        return sLimitReason;
    }

    protected void writeResults(PrintWriter myPrintStream) {
        boolean bPrintDetails = this.bCalculateMarketBalance;
        String strHeader = "Branch,type,value,block,hydro,description";
        if (bPrintDetails) {
            strHeader = strHeader + ",Participant_affected,contract,revenue,revenue_unconstrained,losses";
        }
        myPrintStream.println(strHeader);
        if (this.lCongestion != null) {
            for (TACongestionInfo myCongestion : this.lCongestion) {
                myCongestion.writeResultsInCSV(myPrintStream, bPrintDetails);
            }
        }
    }

    public Calendar getInitialDate() {
        if (!this.isRecalculate()) {
            return this.initialDateDB;
        }
        if (this.initializeDatesFromTPDB()) {
            return this.initialDateDB;
        }
        return null;
    }

    public Calendar getFinalDate() {
        if (!this.isRecalculate()) {
            return this.finalDateDB;
        }
        if (this.initializeDatesFromTPDB()) {
            return this.finalDateDB;
        }
        return null;
    }

    public String getSoftwareSource() {
        if (this.isRecalculate() || this.sSoftwareSource == null || this.sSoftwareSource.isEmpty()) {
            this.initializeDatesFromTPDB();
        }
        return this.sSoftwareSource;
    }

    public String getsLastSourceFileType() {
        if (this.sLastSourceFileType == null) {
            return DE_GeneralEnums.DispatchSoftware.PLEXOS_ST.name();
        }
        return this.sLastSourceFileType;
    }

    public void setsLastSourceFileType(String sLastSourceFileType) {
        this.sLastSourceFileType = sLastSourceFileType;
    }

    public boolean isbMakeReport() {
        return this.bMakeReport;
    }

    public void setbMakeReport(boolean bMakeReport) {
        this.bMakeReport = bMakeReport;
    }

    public boolean isbUseDoubleCircuit() {
        return this.bUseDoubleCircuit;
    }

    public void setbUseDoubleCircuit(boolean bUseDoubleCircuit) {
        this.bUseDoubleCircuit = bUseDoubleCircuit;
    }

    public boolean isbCalculateMarketBalance() {
        return this.bCalculateMarketBalance;
    }

    public void setbCalculateMarketBalance(boolean bCalculateMarketBalance) {
        this.bCalculateMarketBalance = bCalculateMarketBalance;
    }

    public double getdLineTol() {
        return this.dLineTol;
    }

    public void setdLineTol(double dLineTol) {
        this.dLineTol = dLineTol;
    }

    public double getdPriceDiffTol() {
        return this.dPriceDiffTol;
    }

    public void setdPriceDiffTol(double dPriceDiffTol) {
        this.dPriceDiffTol = dPriceDiffTol;
    }

    public double getBlockDuration(int nBlock) {
        if (this.blockDuration == null) {
            this.initializeDatesFromTPDB();
        }
        assert (nBlock < this.finalBlock) : "Why are you asking for a period outside the scope?";
        return this.blockDuration.get(nBlock);
    }

    public String getsUserName() {
        return this.sUserName;
    }

    public void setsUserName(String sUserName) {
        this.sUserName = sUserName;
    }

    public String getsPass() {
        return this.sPass;
    }

    public void setsPass(String sPass) {
        this.sPass = sPass;
    }

    public String getsServer() {
        return this.sServer;
    }

    public void setsServer(String sServer) {
        this.sServer = sServer;
    }

    public String getsDBPath() {
        return this.sDBPath;
    }

    public void setsDBPath(String sDBPath) {
        this.sDBPath = sDBPath;
    }

    public DE_GeneralEnums.DatabaseVendor getDBVendor() {
        if (this.sDBPath.contains(".mdb") || this.sDBPath.contains(".accdb")) {
            return DE_GeneralEnums.DatabaseVendor.MSAccess;
        }
        return DE_GeneralEnums.DatabaseVendor.SQLite;
    }

    public double getdPriceFactor() {
        return this.dPriceFactor;
    }

    public void setdPriceFactor(double dPriceFactor) {
        this.dPriceFactor = dPriceFactor;
    }

    public double getdLineLoadFactor() {
        return this.dLineLoadFactor;
    }

    public void setdLineLoadFactor(double dLineLoadFactor) {
        this.dLineLoadFactor = dLineLoadFactor;
    }

    public double getdProbabilityFactor() {
        return this.dProbabilityFactor;
    }

    public void setdProbabilityFactor(double dProbabilityFactor) {
        this.dProbabilityFactor = dProbabilityFactor;
    }

    public String getsSchDiffReportFile() {
        return this.sSchDiffReportFile;
    }

    public void setsSchDiffReportFile(String sSchDiffReportFile) {
        this.sSchDiffReportFile = sSchDiffReportFile;
    }

    public String getsLogFilePath() {
        return this.sLogFilePath;
    }

    public void setsLogFilePath(String sLogFilePath) {
        this.sLogFilePath = sLogFilePath;
    }

    public double getdRelPriceDiffTol() {
        return this.dRelPriceDiffTol;
    }

    public void setdRelPriceDiffTol(double dRelPriceDiff) {
        this.dRelPriceDiffTol = dRelPriceDiff;
    }

    public String getsLimitXMLFile() {
        return this.sLimitXMLFile;
    }

    public void setsLimitXMLFile(String sLimitXMLFile) {
        this.sLimitXMLFile = sLimitXMLFile;
    }

    public double getdRevenueLossFactor() {
        return this.dRevenueLossFactor;
    }

    public void setdRevenueLossFactor(double dRevenueLossFactor) {
        this.dRevenueLossFactor = dRevenueLossFactor;
    }

    public double getdMarginalIncomeFactor() {
        return this.dMarginalIncomeFactor;
    }

    public void setdMarginalIncomeFactor(double dMarginalIncomeFactor) {
        this.dMarginalIncomeFactor = dMarginalIncomeFactor;
    }

    public boolean isRecalculate() {
        return this.lCmgDiff == null || this.lBranchLoad == null || this.lCongestion == null || this.bRecalculate;
    }

    public void setRecalculate(boolean bRecalculate) {
        this.bRecalculate = bRecalculate;
    }

    public boolean isbUsePriceDiff() {
        return this.bUsePriceDiff;
    }

    public void setbUsePriceDiff(boolean bUsePriceDiff) {
        this.bUsePriceDiff = bUsePriceDiff;
    }

    public boolean isbUseLineLoad() {
        return this.bUseLineLoad;
    }

    public void setbUseLineLoad(boolean bUseLineLoad) {
        this.bUseLineLoad = bUseLineLoad;
    }

    public boolean isbUseRelPriceDiff() {
        return this.bUseRelPriceDiff;
    }

    public boolean isbUseDynPriceDiff() {
        return this.bUseDynPriceDiff;
    }

    public void setbUseRelPriceDiff(boolean bUseRelPriceDiff) {
        this.bUseRelPriceDiff = bUseRelPriceDiff;
    }

    public void setbUseDynPriceDiff(boolean bUseDynPriceDiff) {
        this.bUseDynPriceDiff = bUseDynPriceDiff;
        if (bUseDynPriceDiff) {
            this.bUseRelPriceDiff = bUseDynPriceDiff;
        }
    }

    public String getStrInputFolder() {
        return this.strInputFolder;
    }

    public void setStrInputFolder(String strInputFolder) {
        this.strInputFolder = strInputFolder;
    }

    public String getStrOutputFolder() {
        return this.strOutputFolder;
    }

    public void setStrOutputFolder(String strOutputFolder) {
        this.strOutputFolder = strOutputFolder;
    }

    public String getStrPLEXOSOutputDBName() {
        return this.strPLEXOSOutputDBName;
    }

    public void setStrPLEXOSOutputDBName(String strPLEXOSOutputDBName) {
        this.strPLEXOSOutputDBName = strPLEXOSOutputDBName;
    }

    private void initializeDefaults(String inputOptionFile) {
        this.bMakeReport = DeepEdit.getBooleanOptionValue("TA_MakeReport");
        this.bUseDoubleCircuit = DeepEdit.getBooleanOptionValue("TA_UseDoubleCircuit");
        this.bCalculateMarketBalance = false;
        this.bUseLineLoad = DeepEdit.getBooleanOptionValue("TA_UseLineLoad");
        this.bUsePriceDiff = DeepEdit.getBooleanOptionValue("TA_UsePriceDiff");
        this.bUseRelPriceDiff = DeepEdit.getBooleanOptionValue("TA_UseRelPriceDiff");
        this.bUseDynPriceDiff = DeepEdit.getBooleanOptionValue("TA_UseDynPriceDiff");
        this.dLineTol = DeepEdit.getDoubleOptionValue("TA_LineTol");
        this.dPriceDiffTol = DeepEdit.getDoubleOptionValue("TA_PriceDiffTol");
        this.dRelPriceDiffTol = DeepEdit.getDoubleOptionValue("TA_RelPriceDiffTol");
        this.sDBPath = DeepEdit.getOptionValue("TA_DBPath");
        this.sLastSourceFileType = DeepEdit.getOptionValue("TA_LastInputFileType");
        this.strInputFolder = DeepEdit.getOptionValue("TA_InputFolder");
        this.strOutputFolder = DeepEdit.getOptionValue("TA_OutputFolder");
        this.strPLEXOSOutputDBName = DeepEdit.getOptionValue("TA_PLEXOSOutputDBName");
        this.sUserName = "admin";
        this.sPass = "root";
        this.sServer = "Localhost";
        this.dPriceFactor = DeepEdit.getDoubleOptionValue("TA_PriceFactor");
        this.dLineLoadFactor = DeepEdit.getDoubleOptionValue("TA_LineLoadFactor");
        this.dProbabilityFactor = DeepEdit.getDoubleOptionValue("TA_ProbabilityFactor");
        this.dRevenueLossFactor = DeepEdit.getDoubleOptionValue("TA_RevenueLossFactor");
        this.dMarginalIncomeFactor = DeepEdit.getDoubleOptionValue("TA_MarginalIncomeFactor");
        this.sSchDiffReportFile = AnalysisTool.RESULT_FOLDER + File.separator + "TADB-schematic.log";
        this.sLogFilePath = AnalysisTool.RESULT_FOLDER + File.separator + "TACongestion.csv";
        this.sLimitXMLFile = "." + File.separator + "database" + File.separator + "TABranchLimits.xml";
    }

    public void safeDefaults() {
        DeepEdit.setOptionValue("TA_MakeReport", this.bMakeReport);
        DeepEdit.setOptionValue("TA_UseDoubleCircuit", this.bUseDoubleCircuit);
        DeepEdit.setOptionValue("TA_UseLineLoad", this.bUseLineLoad);
        DeepEdit.setOptionValue("TA_UsePriceDiff", this.bUsePriceDiff);
        DeepEdit.setOptionValue("TA_UseRelPriceDiff", this.bUseRelPriceDiff);
        DeepEdit.setOptionValue("TA_UseDynPriceDiff", this.bUseDynPriceDiff);
        DeepEdit.setOptionValue("TA_LineTol", this.dLineTol);
        DeepEdit.setOptionValue("TA_PriceDiffTol", this.dPriceDiffTol);
        DeepEdit.setOptionValue("TA_RelPriceDiffTol", this.dRelPriceDiffTol);
        DeepEdit.setOptionValue("TA_DBPath", this.sDBPath);
        DeepEdit.setOptionValue("TA_LastInputFileType", this.sLastSourceFileType);
        DeepEdit.setOptionValue("TA_InputFolder", this.strInputFolder);
        DeepEdit.setOptionValue("TA_OutputFolder", this.strOutputFolder);
        DeepEdit.setOptionValue("TA_PLEXOSOutputDBName", this.strPLEXOSOutputDBName);
        DeepEdit.setOptionValue("TA_PriceFactor", this.dPriceFactor);
        DeepEdit.setOptionValue("TA_LineLoadFactor", this.dLineLoadFactor);
        DeepEdit.setOptionValue("TA_ProbabilityFactor", this.dProbabilityFactor);
        DeepEdit.setOptionValue("TA_RevenueLossFactor", this.dRevenueLossFactor);
        DeepEdit.setOptionValue("TA_MarginalIncomeFactor", this.dMarginalIncomeFactor);
    }

    public void deleteData() {
        this.lFlowP = null;
        this.lFlowPMax = null;
        this.lFlowPMin = null;
        this.lCmg = null;
        this.lGenerationP = null;
        this.lLoadP = null;
        try {
            System.gc();
        }
        catch (Exception e) {
            System.err.println("Unable to call Garbage collector when deleting arrays from TA. Message: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        this.Calculate();
    }
}

