/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.TACongestion;
import de.core.XmlBranchLimitInfo;
import de.core.XmlBranchLimitInfos;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.xml.bind.JAXBException;

public class TABranchLimitFrame
extends JDialog {
    String sXMLBranchLimitFile;
    private JButton btnExit;
    private JButton btnSave;
    private JScrollPane jScrollPane1;
    private JTable tblBranchLimits;

    public TABranchLimitFrame(JDialog parent, String sXMLBranchLimitFile) {
        super((Dialog)parent, false);
        this.initComponents();
        this.sXMLBranchLimitFile = sXMLBranchLimitFile;
        File f = new File(sXMLBranchLimitFile);
        if (f.canRead()) {
            this.setTitle("Input file: " + f.getName());
        }
    }

    public void setTblValues(XmlBranchLimitInfos myLimits) {
        DefaultTableModel model = (DefaultTableModel)this.tblBranchLimits.getModel();
        for (XmlBranchLimitInfo myLimit : myLimits.getBranchLimitInfo()) {
            Object[] o = new Object[]{myLimit.getBranchName(), myLimit.getThermalLimit_Smax(), myLimit.getThermalLimit_Pmax(), myLimit.getRealLimit(), myLimit.getRealLimitReason()};
            model.addRow(o);
        }
        this.tblBranchLimits.setModel(model);
    }

    public XmlBranchLimitInfos getBranchLimitsFromGUI() {
        XmlBranchLimitInfos myLimits = new XmlBranchLimitInfos();
        for (int i = 0; i < this.tblBranchLimits.getRowCount(); ++i) {
            String branchName = (String)this.tblBranchLimits.getValueAt(i, 0);
            double dThermalLimit_Smax = (Double)this.tblBranchLimits.getValueAt(i, 1);
            double dThermalLimit_Pmax = (Double)this.tblBranchLimits.getValueAt(i, 2);
            double dThermalLimit_Pmin = (Double)this.tblBranchLimits.getValueAt(i, 3);
            String sRealLimitReason = (String)this.tblBranchLimits.getValueAt(i, 4);
            XmlBranchLimitInfo myLimit = new XmlBranchLimitInfo(branchName, dThermalLimit_Smax, dThermalLimit_Pmax, dThermalLimit_Pmin, dThermalLimit_Pmin, sRealLimitReason, null);
            myLimits.addBranchLimitInfo(myLimit);
        }
        return myLimits;
    }

    private void saveBranchLimits() {
        XmlBranchLimitInfos myLimits = this.getBranchLimitsFromGUI();
        try {
            TACongestion.saveLimitsInXml(this.sXMLBranchLimitFile, myLimits);
            JOptionPane.showMessageDialog(this, "File succesfully updated!", "Save XML File successful", 1);
        }
        catch (JAXBException ex) {
            JOptionPane.showMessageDialog(this, "XML Parsing error writing file: \n" + this.sXMLBranchLimitFile + "\n Exception details: " + ex.toString(), "Error saving XML File", 0);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblBranchLimits = new JTable();
        this.btnSave = new JButton();
        this.btnExit = new JButton();
        this.setDefaultCloseOperation(2);
        this.tblBranchLimits.setAutoCreateRowSorter(true);
        this.tblBranchLimits.setModel(new DefaultTableModel(new Object[0][], new String[]{"Branch", "Thermal Limit [MVA]", "Thermal Limit [MW]", "Real Limit", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Double.class, Double.class, Double.class, Object.class};
                this.canEdit = new boolean[]{false, true, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblBranchLimits.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.tblBranchLimits);
        if (this.tblBranchLimits.getColumnModel().getColumnCount() > 0) {
            this.tblBranchLimits.getColumnModel().getColumn(1).setPreferredWidth(20);
            this.tblBranchLimits.getColumnModel().getColumn(2).setPreferredWidth(20);
            this.tblBranchLimits.getColumnModel().getColumn(3).setPreferredWidth(20);
            this.tblBranchLimits.getColumnModel().getColumn(4).setPreferredWidth(300);
        }
        this.btnSave.setText("Save");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TABranchLimitFrame.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnExit.setText("Cancel");
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TABranchLimitFrame.this.btnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 600, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnSave, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnExit, -2, 70, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 285, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSave).addComponent(this.btnExit)).addGap(4, 4, 4)));
        this.pack();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.saveBranchLimits();
        this.dispose();
    }
}

