/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.NonFlickerPanel;
import de.core.MMTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class StripChartFrame
extends JFrame
implements ActionListener {
    public String comentario;
    public Label lcomentario;
    public double[][] valor;
    public double[][][] valor3;
    public double[][] dvalor;
    public double[][][] dvalor3;
    public String[] leyenda;
    public String titulo;
    public String[] ejex;
    public String etiquetaejex;
    public String etiquetaejey;
    public double[][] promedio;
    public double[][] dpromedio;
    public double[][] desvestarriba;
    public double[][] ddesvestarriba;
    public double[][] desvestabajo;
    public double[][] ddesvestabajo;
    public double[] maxext;
    public double[] minext;
    public boolean prom = false;
    public boolean de = false;
    boolean eliminaceros = false;
    public LineChart chart;
    public NonFlickerPanel p;
    public Panel f;

    public StripChartFrame(String ttitulo, double[][] vvalor, String[] lleyenda, String ccomentario, String[] eejex, String eetiquetaejex, String eetiquetaejey) {
        super(ttitulo);
        this.ejex = eejex;
        this.etiquetaejex = eetiquetaejex;
        this.etiquetaejey = eetiquetaejey;
        this.valor = vvalor;
        this.leyenda = lleyenda;
        this.comentario = ccomentario;
        this.titulo = ttitulo;
        this.dvalor = new double[this.valor.length][this.valor[0].length];
        this.dpromedio = new double[this.valor.length][this.valor[0].length];
        this.ddesvestabajo = new double[this.valor.length][this.valor[0].length];
        this.ddesvestarriba = new double[this.valor.length][this.valor[0].length];
        this.lcomentario = new Label(this.comentario);
        this.actualizar(vvalor, ccomentario);
        this.f = new Panel();
        this.f.setLayout(new BorderLayout());
        this.f.add((Component)this.chart, "Center");
        this.f.add((Component)this.lcomentario, "South");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.add(this.f);
        this.setDefaultCloseOperation(2);
        this.setLocation(450, 50);
        this.setSize(350, 250);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.dispose();
    }

    public void actualizar(double[][] vvalor, String ccomentario) {
        int j;
        Color[] sampleColors;
        this.valor = vvalor;
        this.comentario = ccomentario;
        this.lcomentario.setText(this.comentario);
        double auxmax = 0.0;
        double auxmin = 1.0E8;
        this.chart = null;
        this.chart = new LineChart();
        this.chart.setTitleOn(true);
        this.chart.setTitle(this.titulo);
        this.chart.setSampleCount(this.valor.length);
        int[][] pig = new int[this.dvalor[0].length][3];
        pig = MMTool.colores(this.dvalor[0].length);
        if (!this.prom) {
            if (!this.de) {
                int i;
                this.chart.setSeriesCount(this.dvalor[0].length);
                int[] discontinuidades = new int[this.valor[0].length];
                for (i = 0; i < this.valor.length; ++i) {
                    for (int j2 = 0; j2 < this.valor[0].length; ++j2) {
                        if (this.eliminaceros) {
                            if (this.valor[i][j2] == 0.0) {
                                this.dvalor[i][j2] = Double.NaN;
                                int n = j2;
                                discontinuidades[n] = discontinuidades[n] + 1;
                            } else {
                                this.dvalor[i][j2] = this.valor[i][j2];
                            }
                        } else {
                            this.dvalor[i][j2] = this.valor[i][j2];
                        }
                        auxmax = Math.max(this.dvalor[i][j2], auxmax);
                        auxmin = Math.min(this.dvalor[i][j2], auxmin);
                    }
                }
                for (i = 0; i < discontinuidades.length; ++i) {
                    if (discontinuidades[i] == 0) continue;
                    System.out.println("Reservoir " + this.leyenda[i] + " has " + discontinuidades[i] + " points in MMS database.");
                }
                sampleColors = new Color[this.dvalor[0].length];
                for (i = 0; i < this.dvalor[0].length; ++i) {
                    sampleColors[i] = new Color(pig[i][0], pig[i][1], pig[i][2]);
                    this.chart.setSampleValues(i, this.getColumn(this.dvalor, i));
                }
            } else {
                int i;
                this.chart.setSeriesCount(this.dvalor[0].length * 3);
                sampleColors = new Color[this.dvalor[0].length * 3];
                for (i = 0; i < this.valor.length; ++i) {
                    for (j = 0; j < this.valor[0].length; ++j) {
                        this.dvalor[i][j] = this.valor[i][j];
                        this.ddesvestarriba[i][j] = this.desvestarriba[i][j];
                        this.ddesvestabajo[i][j] = this.desvestabajo[i][j];
                        auxmax = Math.max(this.dvalor[i][j], auxmax);
                        auxmin = Math.min(this.dvalor[i][j], auxmin);
                    }
                }
                for (i = 0; i < this.dvalor[0].length; ++i) {
                    sampleColors[i] = new Color(pig[i][0], pig[i][1], pig[i][2]);
                    sampleColors[i + this.dvalor[0].length] = sampleColors[i];
                    sampleColors[i + 2 * this.dvalor[0].length] = sampleColors[i];
                    this.chart.setSampleValues(i, this.getColumn(this.dvalor, i));
                    this.chart.setSampleValues(i + this.dvalor[0].length, this.getColumn(this.ddesvestarriba, i));
                    this.chart.setSampleValues(i + 2 * this.dvalor[0].length, this.getColumn(this.ddesvestabajo, i));
                }
            }
        } else if (!this.de) {
            int i;
            this.chart.setSeriesCount(this.dvalor[0].length * 2);
            sampleColors = new Color[this.dvalor[0].length * 2];
            for (i = 0; i < this.valor.length; ++i) {
                for (j = 0; j < this.valor[0].length; ++j) {
                    this.dvalor[i][j] = this.valor[i][j];
                    this.dpromedio[i][j] = this.promedio[i][j];
                    auxmax = Math.max(this.dvalor[i][j], auxmax);
                    auxmin = Math.min(this.dvalor[i][j], auxmin);
                }
            }
            for (i = 0; i < this.dvalor[0].length; ++i) {
                sampleColors[i] = new Color(pig[i][0], pig[i][1], pig[i][2]);
                sampleColors[i + this.dvalor[0].length] = sampleColors[i];
                this.chart.setSampleValues(i, this.getColumn(this.dvalor, i));
                this.chart.setSampleValues(i + this.dvalor[0].length, this.getColumn(this.dpromedio, i));
                this.chart.setLineWidth(i + this.dvalor[0].length, 4);
            }
        } else {
            int i;
            this.chart.setSeriesCount(this.dvalor[0].length * 4);
            sampleColors = new Color[this.dvalor[0].length * 4];
            for (i = 0; i < this.valor.length; ++i) {
                for (j = 0; j < this.valor[0].length; ++j) {
                    this.dvalor[i][j] = this.valor[i][j];
                    this.dpromedio[i][j] = this.promedio[i][j];
                    this.ddesvestarriba[i][j] = this.desvestarriba[i][j];
                    this.ddesvestabajo[i][j] = this.desvestabajo[i][j];
                    auxmax = Math.max(this.dvalor[i][j], auxmax);
                    auxmin = Math.min(this.dvalor[i][j], auxmin);
                }
            }
            for (i = 0; i < this.dvalor[0].length; ++i) {
                sampleColors[i] = new Color(pig[i][0], pig[i][1], pig[i][2]);
                sampleColors[i + this.dvalor[0].length] = sampleColors[i];
                sampleColors[i + 2 * this.dvalor[0].length] = sampleColors[i];
                sampleColors[i + 3 * this.dvalor[0].length] = sampleColors[i];
                this.chart.setSampleValues(i, this.getColumn(this.dvalor, i));
                this.chart.setSampleValues(i + this.dvalor[0].length, this.getColumn(this.ddesvestarriba, i));
                this.chart.setLineWidth(i + this.dvalor[0].length, 1);
                this.chart.setSampleValues(i + 2 * this.dvalor[0].length, this.getColumn(this.ddesvestabajo, i));
                this.chart.setLineWidth(i + 2 * this.dvalor[0].length, 1);
                this.chart.setSampleValues(i + 3 * this.dvalor[0].length, this.getColumn(this.dpromedio, i));
                this.chart.setLineWidth(i + 3 * this.dvalor[0].length, 4);
            }
        }
        auxmin = 0.0;
        if (this.maxext != null) {
            auxmax = this.maxext[0];
            for (int i = 0; i < this.maxext.length; ++i) {
                auxmax = Math.max(auxmax, this.maxext[i]);
            }
        }
        if (this.minext != null) {
            auxmin = this.minext[0];
            for (int i = 0; i < this.minext.length; ++i) {
                auxmin = Math.min(auxmin, this.minext[i]);
            }
        }
        this.chart.setRange(0, auxmax);
        this.chart.setLowerRange(0, auxmin);
        this.chart.setLegendOn(true);
        this.chart.setLegendLabels(this.leyenda);
        this.chart.setFont(new Font("Verdana", 0, 12));
        this.chart.setSampleColors(sampleColors);
        this.chart.setLegendPosition(3);
        this.chart.setSampleLabels(this.ejex);
        this.chart.setLabel("rangeAxisLabel", this.etiquetaejey);
        this.chart.setLabel("sampleAxisLabel", this.etiquetaejex);
        this.chart.setSampleLabelsOn(true);
        this.chart.setSampleLabelsOn(true);
        this.chart.setAutoLabelSpacingOn(true);
        this.chart.setLabelAngle("rangeAxisLabelAngle", 270);
        this.chart.setLabelAngle("sampleLabelAngle", 270);
        this.chart.setSampleScrollerOn(true);
        this.chart.setRangeAdjusterOn(0, true);
        this.chart.setValueLabelsOn(-1, true);
        this.chart.setValueLabelStyle(2);
        this.chart.setBackground(Color.white);
    }

    protected double[] getColumn(double[][] arreglo, int columna) {
        int l = arreglo.length;
        double[] ret = new double[l];
        for (int i = 0; i < l; ++i) {
            ret[i] = arreglo[i][columna];
        }
        return ret;
    }

    protected double[] getColumn(double[][][] arreglo, int columna, int profundidad) {
        int l = arreglo.length;
        double[] ret = new double[l];
        for (int i = 0; i < l; ++i) {
            ret[i] = arreglo[i][columna][profundidad];
        }
        return ret;
    }

    public Chart getChart() {
        return this.chart;
    }
}

