/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import java.awt.Dimension;
import java.awt.Label;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatusJPanel
extends JPanel {
    private final DeepEdit MyDeepEdit;
    private String ActMessage = "Please wait";
    private int posx;
    private int posy;
    private boolean SimulationRunning = false;
    private JSlider jZoomSlider;
    private Label lblStatus;
    private JProgressBar proMainProgressBar;

    public StatusJPanel(DeepEdit app) {
        this.initComponents();
        this.MyDeepEdit = app;
        this.proMainProgressBar.setVisible(false);
    }

    public void setStatusMessage(String msg) {
        this.ActMessage = msg;
        this.updateLabel();
    }

    public void setposx(int pposx) {
        this.posx = pposx;
    }

    public void setposy(int pposy) {
        this.posy = pposy;
    }

    public void updateLabel() {
        String pos = " (" + this.posx + "," + this.posy + ")";
        this.lblStatus.setText(this.ActMessage + pos);
        this.repaint();
    }

    public void updatevalue(int grilla) {
        this.jZoomSlider.setValue(grilla);
    }

    public void SimulationStart() {
        this.jZoomSlider.setEnabled(false);
        this.SimulationRunning = true;
    }

    public void SimulationStop() {
        this.jZoomSlider.setEnabled(true);
        this.SimulationRunning = false;
    }

    public void showProgressBar() {
        this.proMainProgressBar.setMaximum(100);
        this.proMainProgressBar.setValue(0);
        this.proMainProgressBar.setVisible(true);
    }

    public void showProgressBar(int nTask) {
        this.proMainProgressBar.setMaximum(nTask);
        this.proMainProgressBar.setValue(0);
        this.proMainProgressBar.setVisible(true);
    }

    public void hideProgressBar() {
        this.proMainProgressBar.setVisible(false);
        this.repaint();
    }

    public void updateProgress() {
        int nValue = this.proMainProgressBar.getValue();
        this.proMainProgressBar.setValue(nValue++);
        if (nValue >= this.proMainProgressBar.getMaximum()) {
            this.proMainProgressBar.setVisible(false);
        }
    }

    public void updateProgress(int nPercentage) {
        this.proMainProgressBar.setValue(nPercentage);
        if (nPercentage >= this.proMainProgressBar.getMaximum()) {
            this.proMainProgressBar.setVisible(false);
        }
    }

    private void initComponents() {
        this.jZoomSlider = new JSlider();
        this.lblStatus = new Label();
        this.proMainProgressBar = new JProgressBar();
        this.jZoomSlider.setMaximum(16);
        this.jZoomSlider.setMinimum(1);
        this.jZoomSlider.setMinorTickSpacing(15);
        this.jZoomSlider.setPaintTicks(true);
        this.jZoomSlider.setToolTipText("");
        StatusJPanel statusJPanel = this;
        this.jZoomSlider.setValue(statusJPanel.MyDeepEdit.getGridStep());
        this.jZoomSlider.setAlignmentX(1.0f);
        this.jZoomSlider.setAlignmentY(1.0f);
        this.jZoomSlider.setFocusable(false);
        this.jZoomSlider.setMinimumSize(new Dimension(36, 20));
        this.jZoomSlider.setName("");
        this.jZoomSlider.setPreferredSize(new Dimension(200, 28));
        this.jZoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StatusJPanel.this.SetNewValues(evt);
            }
        });
        this.lblStatus.setText("label1");
        this.proMainProgressBar.setToolTipText("");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.proMainProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatus, -1, 287, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jZoomSlider, -2, 100, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE).addComponent(this.jZoomSlider, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.proMainProgressBar, -1, -1, Short.MAX_VALUE).addGap(3, 3, 3)));
    }

    private void SetNewValues(ChangeEvent evt) {
        int GridStep = this.jZoomSlider.getValue();
        this.MyDeepEdit.setGridStep(GridStep);
        this.MyDeepEdit.updateZoom();
    }

    public boolean isSimulationRunning() {
        return this.SimulationRunning;
    }
}

