/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Injection;
import de.core.SpotVisual;
import de.core.comp;
import de.core.ndb_comp;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class SpotFrame
extends Frame
implements KeyListener,
ActionListener {
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    SpotVisual MySpot = null;
    Button button1;
    Button button2;
    comp TempComponent;
    ndb_comp Tempndb;
    Busbar TempBusbar;
    Injection TempInjection;
    Generator TempGenerator;

    public SpotFrame(SpotVisual aaSpot) {
        super("Spot Prices visualization parameters");
        this.setBackground(Color.lightGray);
        this.MySpot = aaSpot;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "SPOT PRICES LEVEL VISUALIZATION", gridbag, c, Color.blue);
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "Visualization of the Spot Prices", gridbag, c, Color.black);
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "levels of active power in the system.", gridbag, c, Color.black);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button button1 = new Button("Repaint");
        button1.setActionCommand("Repaint");
        button1.addActionListener(this);
        gridbag.setConstraints(button1, c);
        this.add(button1);
        Button button2 = new Button("Exit");
        button2.setActionCommand("Exit");
        button2.addActionListener(this);
        gridbag.setConstraints(button2, c);
        this.add(button2);
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SpotFrame.this.restorecolor();
                SpotFrame.this.setVisible(false);
                SpotFrame.this.dispose();
                try {
                    SpotFrame.this.MySpot.MySpotColorSpec.setVisible(false);
                    SpotFrame.this.MySpot.MySpotColorSpec.dispose();
                    SpotFrame.this.MySpot.MySpotColorSpec = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SpotFrame.this.MySpot.MySpotFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.restorecolor();
            this.setVisible(false);
            this.dispose();
            try {
                this.MySpot.MySpotColorSpec.setVisible(false);
                this.MySpot.MySpotColorSpec.dispose();
                this.MySpot.MySpotColorSpec = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.MySpot.MySpotFrame = null;
            DeepEdit.MySchematicPanel.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            if (label.equals("Exit")) {
                this.restorecolor();
                this.setVisible(false);
                this.dispose();
                try {
                    this.MySpot.MySpotColorSpec.setVisible(false);
                    this.MySpot.MySpotColorSpec.dispose();
                    this.MySpot.MySpotColorSpec = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.MySpot.MySpotFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            } else {
                this.visualization();
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            }
        }
    }

    public void visualization() {
        int ix;
        double auxf = 0.0;
        boolean auxi = false;
        double bezug = 1.0E7;
        double spotmax = -1.0E7;
        double spotmin = 1.0E7;
        for (ix = 0; ix < this.MySpot.ActSchematic.Components.size(); ++ix) {
            this.TempComponent = (comp)this.MySpot.ActSchematic.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !this.TempComponent.getvalid() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof ndb_comp)) continue;
            this.Tempndb = (ndb_comp)this.TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.gray;
            ndb_comp.Color2 = Color.gray;
            ndb_comp.Color3 = Color.gray;
            if (this.TempComponent instanceof Busbar) {
                this.TempBusbar = (Busbar)this.Tempndb;
                spotmax = Math.max(this.TempBusbar.getspot_p(), spotmax);
                spotmin = Math.min(this.TempBusbar.getspot_p(), spotmin);
            }
            if (this.TempComponent instanceof Generator) {
                this.TempGenerator = (Generator)this.TempComponent;
                if (this.TempGenerator.getp() - this.TempGenerator.getpmin() > 0.1 && this.TempGenerator.getpmax() - this.TempGenerator.getp() > 0.1) {
                    this.TempGenerator.setAlternatekv_Color(Color.yellow);
                    bezug = Math.min(bezug, this.TempGenerator.getspot_p());
                    continue;
                }
                this.TempGenerator.setAlternatekv_Color(Color.gray);
                continue;
            }
            if (this.TempComponent instanceof Injection) {
                this.TempInjection = (Injection)this.TempComponent;
                if (this.TempInjection.getp() - this.TempInjection.getpmin() > 0.1 && this.TempInjection.getpmax() - this.TempInjection.getp() > 0.1) {
                    this.TempInjection.setAlternatekv_Color(Color.yellow);
                    bezug = Math.min(bezug, this.TempInjection.getspot_p());
                    continue;
                }
                this.TempInjection.setAlternatekv_Color(Color.gray);
                continue;
            }
            this.Tempndb.setAlternatekv_Color(Color.gray);
        }
        for (ix = 0; ix < this.MySpot.ActSchematic.Components.size(); ++ix) {
            this.TempComponent = (comp)this.MySpot.ActSchematic.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !this.TempComponent.getinservice() || !(this.TempComponent instanceof ndb_comp)) continue;
            this.Tempndb = (ndb_comp)this.TempComponent;
            if (!(this.TempComponent instanceof Busbar)) continue;
            this.TempBusbar = (Busbar)this.Tempndb;
            this.TempBusbar.setAlternatekv_Color(this.floatToColor(this.assignv(bezug, this.TempBusbar.getspot_p(), spotmax, spotmin)));
        }
        this.MySpot.startSpotColor(spotmin, spotmax, bezug);
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }

    public Color floatToColor(double f) {
        int elec = (int)f;
        Color acolor = Color.gray;
        switch (elec) {
            case 0: {
                acolor = new Color(0, 14, 190);
                break;
            }
            case 1: {
                acolor = new Color(0, 17, 236);
                break;
            }
            case 2: {
                acolor = new Color(57, 71, 255);
                break;
            }
            case 3: {
                acolor = new Color(125, 134, 255);
                break;
            }
            case 4: {
                acolor = new Color(195, 199, 255);
                break;
            }
            case 5: {
                acolor = new Color(255, 255, 255);
                break;
            }
            case 6: {
                acolor = new Color(255, 202, 201);
                break;
            }
            case 7: {
                acolor = new Color(254, 166, 164);
                break;
            }
            case 8: {
                acolor = new Color(254, 108, 104);
                break;
            }
            case 9: {
                acolor = new Color(253, 46, 41);
            }
        }
        if (elec >= 10) {
            acolor = Color.red;
        }
        if (f == 0.0) {
            acolor = Color.black;
        }
        return acolor;
    }

    public double assignv(double ref, double ist, double max, double min) {
        double auxf = 0.0;
        auxf = (ist - min) / (max - min) * 10.0;
        return auxf;
    }
}

