/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.comp;
import de.data.ParameterData;
import de.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class Simulation
extends comp {
    private int nInitialLDC;
    private int nTotalLDCs;
    private int nLDC_perPeriod = 12;
    private int nTotalPeriods;
    private int nLastPeriod;
    private int nLastLDC;
    private int nLastBlock;
    private int nLDC_numblocks;
    private List<String> lPeriodNames;
    private List<String> lLDCNames;
    private List<String> lBlockNames;
    private List<String> lHydroNames;

    public Simulation(String Name) {
        this.setName(Name);
    }

    private void initTotalLDCPeriods() {
        int initialperiod = Integer.parseInt(this.getParamaterValue("initialperiod"));
        this.nInitialLDC = Integer.parseInt(this.getParamaterValue("initialmonth"));
        int initialblock = Integer.parseInt(this.getParamaterValue("initialblock"));
        int totalblock = Integer.parseInt(this.getParamaterValue("totalblock"));
        this.nLDC_numblocks = Integer.parseInt(this.getParamaterValue("LDC_numblocks"));
        String LDC_type = this.getParamaterValue("LDC_type");
        this.nTotalLDCs = (int)Utils.safeDivision(totalblock, this.nLDC_numblocks);
        if (totalblock % this.nLDC_numblocks != 0) {
            ++this.nTotalLDCs;
        }
        this.nLastLDC = (this.nInitialLDC + this.nTotalLDCs) % this.nLDC_perPeriod;
        this.nTotalPeriods = (int)Utils.safeDivision(this.nTotalLDCs, this.nLDC_perPeriod);
        if (this.nTotalLDCs % this.nLDC_perPeriod != 0) {
            ++this.nTotalPeriods;
        }
        this.nLastPeriod = initialperiod + this.nTotalPeriods - 1;
        this.nLastBlock = totalblock % this.nLDC_numblocks == 0 ? this.nLDC_numblocks : totalblock % this.nLDC_numblocks;
    }

    public List<String> getPeriodNames() {
        if (this.lPeriodNames != null) {
            return this.lPeriodNames;
        }
        this.initTotalLDCPeriods();
        int initialperiod = Integer.parseInt(this.getParamaterValue("initialperiod"));
        this.lPeriodNames = new ArrayList<String>(this.nTotalPeriods);
        for (int nPeriod = initialperiod; nPeriod <= this.nLastPeriod; ++nPeriod) {
            this.lPeriodNames.add(String.valueOf(nPeriod));
        }
        return this.lPeriodNames;
    }

    public List<String> getLDCNames() {
        if (this.lLDCNames != null) {
            return this.lLDCNames;
        }
        this.initTotalLDCPeriods();
        this.lLDCNames = new ArrayList<String>(this.nLDC_perPeriod);
        for (int nLDC = 0; nLDC < this.nLDC_perPeriod; ++nLDC) {
            this.lLDCNames.add(String.valueOf(nLDC + 1));
        }
        return this.lLDCNames;
    }

    public List<String> getBlockNames() {
        if (this.lBlockNames != null) {
            return this.lBlockNames;
        }
        this.initTotalLDCPeriods();
        this.lBlockNames = new ArrayList<String>();
        for (int nBlock = 0; nBlock < this.nLDC_numblocks; ++nBlock) {
            this.lBlockNames.add(String.valueOf(nBlock + 1));
        }
        return this.lBlockNames;
    }

    public List<String> getHydroNames() {
        if (this.lHydroNames != null) {
            return this.lHydroNames;
        }
        this.lHydroNames = new ArrayList<String>();
        int nTotalHydro = Integer.parseInt(this.getParamaterValue("totalhydro"));
        for (int nHydro = 0; nHydro < nTotalHydro; ++nHydro) {
            this.lHydroNames.add(String.valueOf(nHydro + 1));
        }
        return this.lHydroNames;
    }

    public int getLastSimulationPeriod() {
        this.initTotalLDCPeriods();
        return this.nLastPeriod;
    }

    public int getLastSimulationLDC() {
        this.initTotalLDCPeriods();
        return this.nLastLDC;
    }

    public String getParameterValue(String sParameterName) {
        ParameterData pData = new ParameterData(sParameterName);
        if (this.getParameterInfo(sParameterName, pData)) {
            return pData.getValue();
        }
        return null;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        if (sParameterName.equalsIgnoreCase("Name")) {
            ParameterData oDataOld = DeepEdit.getDefaultParameterInfo("Simulation", sParameterName);
            oDataOld.setValue(this.getName());
            oDataOld.copyParameterInto(oData);
            return true;
        }
        ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
        if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo("Simulation", sParameterName)) == null) {
            assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by this 'Simulation' object?";
            return false;
        }
        oDataOld.copyParameterInto(oData);
        return true;
    }

    @Override
    public boolean setParameterValue(String sValue, String sParameterName) {
        ParameterData pData = DeepEdit.getDefaultParameterInfo("Simulation", sParameterName);
        pData.setValue(sValue);
        return this.setParameterInfo(sParameterName, pData);
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        assert (DeepEdit.getParameterNameList("Simulation").contains(sParameterName)) : "Why are you looking for parameter '" + sParameterName + "' not supported by this object?";
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }

    @Override
    comp Copy(int xo, int yo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

