/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.SimMDE_ptocva;
import de.core.SimMPE_taboferta;
import java.util.Vector;

public class SimMPE {
    SimMDE_ptocva transaccion = new SimMDE_ptocva();
    double pm_consumidor;
    int tipo_interseccion;
    SimMPE_taboferta[] OfVentaAgente;
    SimMPE_taboferta[] OfCompraAgente;

    SimMPE(Vector OfsVenta, Vector OfsCompra) {
        int i;
        this.OfVentaAgente = new SimMPE_taboferta[OfsVenta.size()];
        this.OfCompraAgente = new SimMPE_taboferta[OfsCompra.size()];
        for (i = 0; i < OfsVenta.size(); ++i) {
            this.OfVentaAgente[i] = (SimMPE_taboferta)OfsVenta.elementAt(i);
        }
        for (i = 0; i < OfsCompra.size(); ++i) {
            this.OfCompraAgente[i] = (SimMPE_taboferta)OfsCompra.elementAt(i);
        }
        System.out.println("---------- Start One Period Market Simulation ------------");
    }

    public boolean casacionSimple() {
        SimMDE_ptocva[] COA;
        SimMDE_ptocva[] COV = this.getCOV();
        double[] sol = this.getEqMerc(COV, COA = this.getCOA());
        if (sol[2] == -1.0) {
            return false;
        }
        this.asignarProdyDem(sol[0], sol[1], sol[2], sol[3]);
        this.transaccion.precio = sol[0];
        this.transaccion.energia = sol[1];
        Double aux = new Double(sol[2]);
        this.tipo_interseccion = aux.intValue();
        this.pm_consumidor = sol[3];
        return true;
    }

    private double[] getEqMerc(SimMDE_ptocva[] COV, SimMDE_ptocva[] COA) {
        double PM = 0.0;
        double QD = 0.0;
        double tipointers = -1.0;
        double PMC = 1.0E11;
        boolean hayinters = true;
        int i = COV.length - 1;
        int j = COA.length - 1;
        if (i > 0 && j > 0) {
            if (COV[i].precio < COA[j].precio) {
                hayinters = false;
                PM = COV[i].precio;
                QD = COV[i].energia < COA[j].energia ? COV[i].energia : COA[j].energia;
            }
            j = 1;
            i = 1;
            if (COV[i].precio > COA[j].precio) {
                hayinters = false;
            }
        } else {
            hayinters = false;
        }
        if (hayinters) {
            for (i = 1; i < COV.length; ++i) {
                for (j = 1; j < COA.length && !(COA[j].precio < COV[i].precio); ++j) {
                }
                if (COV[i].energia >= COA[--j].energia) break;
            }
            int j2 = j;
            while (i < COA.length && !(COA[j2].energia >= COV[i - 1].energia)) {
                ++j2;
            }
            if (COV[i].energia == COA[j].energia && COV[i].precio == COA[j].precio) {
                PM = COV[i].precio;
                QD = COV[i].energia;
                tipointers = 0.0;
            } else if (COV[i].energia != COA[j].energia && COV[i].precio == COA[j].precio) {
                if (COV[i - 1].energia == COA[j].energia) {
                    PM = COV[i - 1].precio;
                    QD = COA[j].energia;
                    tipointers = 0.0;
                } else {
                    PM = COV[i].precio;
                    QD = COA[j].energia;
                    tipointers = 2.0;
                }
            } else if (COV[i].energia == COA[j].energia && COV[i].precio != COA[j].precio) {
                PM = COV[i].precio;
                QD = COA[j].energia;
                tipointers = 0.0;
            } else if (COV[i - 1].energia < COA[j].energia && COV[i].precio < COA[j].precio) {
                PM = COV[i].precio;
                QD = COA[j].energia;
                tipointers = 2.0;
            } else {
                PM = COV[i - 1].precio;
                QD = COV[i - 1].energia;
                tipointers = COA[j2].energia == COV[i - 1].energia ? 0.0 : 1.0;
            }
        }
        for (i = COA.length - 1; i >= 0; --i) {
            if (!(COA[i].precio >= PM)) continue;
            PMC = COA[i].precio;
            break;
        }
        if (i < 0) {
            System.out.println("Error en procedimiento de interseccion de curvas de mercado. PMC no encontrado.");
        }
        double[] solucion = new double[]{PM, QD, tipointers, PMC};
        return solucion;
    }

    private SimMDE_ptocva[] getCOV() {
        int i;
        SimMPE_taboferta tabvendedor = null;
        Vector<SimMDE_ptocva> aux = new Vector<SimMDE_ptocva>(100, 25);
        SimMDE_ptocva punto = new SimMDE_ptocva();
        punto.precio = -10.0;
        punto.energia = 0.0;
        aux.addElement(punto);
        for (int ivendedor = 0; ivendedor < this.OfVentaAgente.length; ++ivendedor) {
            tabvendedor = this.OfVentaAgente[ivendedor];
        }
        int numtramos = tabvendedor.numtramos;
        if (numtramos > 0) {
            int j = 0;
            for (int itramo = 1; itramo <= numtramos; ++itramo) {
                double precio = tabvendedor.ofhora[itramo].precio;
                double incenergia = tabvendedor.ofhora[itramo].energia - tabvendedor.ofhora[itramo - 1].energia;
                while (j < aux.size()) {
                    punto = (SimMDE_ptocva)aux.elementAt(j);
                    if (precio < punto.precio) {
                        punto = new SimMDE_ptocva();
                        punto.precio = precio;
                        punto.energia = incenergia;
                        aux.insertElementAt(punto, j);
                        break;
                    }
                    if (precio == punto.precio) {
                        punto.energia += incenergia;
                        aux.setElementAt(punto, j);
                        break;
                    }
                    ++j;
                }
                if (j != aux.size()) continue;
                punto = new SimMDE_ptocva();
                punto.precio = precio;
                punto.energia = incenergia;
                aux.addElement(punto);
            }
        }
        SimMDE_ptocva[] res = new SimMDE_ptocva[aux.size()];
        for (i = 0; i < aux.size(); ++i) {
            res[i] = (SimMDE_ptocva)aux.elementAt(i);
        }
        for (i = 1; i < res.length; ++i) {
            res[i].energia += res[i - 1].energia;
        }
        return res;
    }

    private SimMDE_ptocva[] getCOA() {
        int i;
        Vector<SimMDE_ptocva> aux = new Vector<SimMDE_ptocva>(100, 25);
        SimMDE_ptocva punto = new SimMDE_ptocva();
        punto.precio = 1.0E101;
        punto.energia = 0.0;
        aux.addElement(punto);
        for (int icomprador = 0; icomprador < this.OfCompraAgente.length; ++icomprador) {
            SimMPE_taboferta tabcomprador = this.OfCompraAgente[icomprador];
            int numtramos = tabcomprador.numtramos;
            if (numtramos <= 0) continue;
            int j = 0;
            for (int itramo = 1; itramo <= numtramos; ++itramo) {
                double precio = tabcomprador.ofhora[itramo].precio;
                double incenergia = tabcomprador.ofhora[itramo].energia - tabcomprador.ofhora[itramo - 1].energia;
                while (j < aux.size()) {
                    punto = (SimMDE_ptocva)aux.elementAt(j);
                    if (precio > punto.precio) {
                        punto = new SimMDE_ptocva();
                        punto.precio = precio;
                        punto.energia = incenergia;
                        aux.insertElementAt(punto, j);
                        break;
                    }
                    if (precio == punto.precio) {
                        punto.energia += incenergia;
                        aux.setElementAt(punto, j);
                        break;
                    }
                    ++j;
                }
                if (j != aux.size()) continue;
                punto = new SimMDE_ptocva();
                punto.precio = precio;
                punto.energia = incenergia;
                aux.addElement(punto);
            }
        }
        SimMDE_ptocva[] res = new SimMDE_ptocva[aux.size()];
        for (i = 0; i < aux.size(); ++i) {
            res[i] = (SimMDE_ptocva)aux.elementAt(i);
        }
        for (i = 1; i < res.length; ++i) {
            res[i].energia += res[i - 1].energia;
        }
        return res;
    }

    private void asignarProdyDem(double PM, double QD, double tipointers, double PMC) {
        int itramo;
        int k;
        double ETM = 0.0;
        double EPDT = 0.0;
        double EXOF = 0.0;
        double[] ED = new double[this.OfVentaAgente.length];
        double[] EM = new double[this.OfVentaAgente.length];
        block0: for (k = 0; k < this.OfVentaAgente.length; ++k) {
            SimMPE_taboferta pvendor = this.OfVentaAgente[k];
            for (itramo = pvendor.numtramos; itramo > 0; --itramo) {
                if (pvendor.ofhora[itramo].precio == PM) {
                    pvendor.tramocas = itramo;
                    if (tipointers == 2.0) {
                        EM[k] = pvendor.ofhora[itramo].energia - pvendor.ofhora[itramo - 1].energia;
                        ED[k] = pvendor.ofhora[itramo - 1].energia;
                        continue block0;
                    }
                    ED[k] = pvendor.ofhora[itramo].energia;
                    continue block0;
                }
                if (!(pvendor.ofhora[itramo].precio < PM)) continue;
                pvendor.tramocas = itramo;
                ED[k] = pvendor.ofhora[itramo].energia;
                continue block0;
            }
        }
        if (tipointers == 2.0) {
            for (k = 0; k < this.OfVentaAgente.length; ++k) {
                ETM += EM[k];
                EPDT += ED[k];
            }
            EXOF = ETM + EPDT - QD;
            for (k = 0; k < this.OfVentaAgente.length; ++k) {
                if (!(EM[k] > 0.0)) continue;
                int n = k;
                ED[n] = ED[n] + EM[k] * (1.0 - EXOF / ETM);
            }
        }
        for (k = 0; k < this.OfVentaAgente.length; ++k) {
            this.OfVentaAgente[k].QD = ED[k];
            this.OfVentaAgente[k].PM = PM;
        }
        ETM = 0.0;
        EPDT = 0.0;
        EXOF = 0.0;
        ED = new double[this.OfCompraAgente.length];
        EM = new double[this.OfCompraAgente.length];
        block5: for (k = 0; k < this.OfCompraAgente.length; ++k) {
            SimMPE_taboferta pconsum = this.OfCompraAgente[k];
            for (itramo = pconsum.numtramos; itramo > 0; --itramo) {
                if (pconsum.ofhora[itramo].precio == PMC) {
                    pconsum.tramocas = itramo;
                    if (tipointers == 1.0) {
                        EM[k] = pconsum.ofhora[itramo].energia;
                        continue block5;
                    }
                    ED[k] = pconsum.ofhora[itramo].energia;
                    continue block5;
                }
                if (!(pconsum.ofhora[itramo].precio > PMC)) continue;
                pconsum.tramocas = itramo;
                ED[k] = pconsum.ofhora[itramo].energia;
                continue block5;
            }
        }
        if (tipointers == 1.0) {
            for (k = 0; k < this.OfCompraAgente.length; ++k) {
                ETM += EM[k];
                EPDT += ED[k];
            }
            EXOF = ETM + EPDT - QD;
            for (k = 0; k < this.OfCompraAgente.length; ++k) {
                if (!(EM[k] > 0.0)) continue;
                ED[k] = EM[k] * (1.0 - EXOF / ETM);
            }
        }
        for (k = 0; k < this.OfCompraAgente.length; ++k) {
            this.OfCompraAgente[k].PM = PM;
            this.OfCompraAgente[k].QD = ED[k];
        }
    }

    public Vector obtenerSolucion() {
        Vector<Object> resultado = new Vector<Object>();
        double[] sol = new double[3];
        if (this.casacionSimple()) {
            sol[0] = 1.0;
        }
        sol[1] = this.tipo_interseccion;
        sol[2] = this.pm_consumidor;
        resultado.addElement(sol);
        resultado.addElement(this.transaccion);
        return resultado;
    }

    private void SimMDE_Error(String mensaje) throws Exception {
        mensaje = "Error: " + mensaje;
        throw new Exception(mensaje);
    }
}

