/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.SimMDE_ptocva;
import de.utils.StringUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

class SimMDE_taboferta {
    String cod_UP = "";
    String cod_UA = "";
    double ing_min_TF = 0.0;
    double ing_min_TV = 0.0;
    double grad_subida = 0.0;
    double grad_bajada = 0.0;
    double grad_parada = 0.0;
    double grad_arranque = 0.0;
    double pmax = 10000.0;
    boolean con_var_carga = false;
    boolean[] pt_indivisible = new boolean[25];
    boolean[] parada_programada = new boolean[4];
    boolean participa = true;
    int[] numtramos = new int[25];
    private String[] idUsuarios;
    private String Name = "";
    private String[] emailAdresses;
    SimMDE_ptocva[][] ofhora = new SimMDE_ptocva[25][26];

    SimMDE_taboferta() {
        for (int hora = 1; hora < 25; ++hora) {
            this.numtramos[hora] = 1;
            for (int tramo = 0; tramo < 26; ++tramo) {
                this.ofhora[hora][tramo] = new SimMDE_ptocva();
            }
        }
    }

    void cargarOfVenta(Connection dbtrab, String cod_UP) throws Exception {
        boolean codigoexiste = false;
        try {
            Statement s = dbtrab.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM PRODUCTORES WHERE (COD_UP='" + cod_UP + "'" + ")");
            while (r.next()) {
                int i;
                codigoexiste = true;
                cod_UP = r.getString("COD_UP");
                this.ing_min_TF = r.getDouble("Ing_min_TF");
                this.ing_min_TV = r.getDouble("Ing_min_TV");
                this.grad_subida = r.getDouble("Grad_Subida");
                this.grad_bajada = r.getDouble("Grad_Bajada");
                this.grad_parada = r.getDouble("Grad_Parada");
                this.grad_arranque = r.getDouble("Grad_Arranque");
                this.pmax = r.getDouble("PMAX");
                boolean sino = r.getBoolean("Pt_indivisible");
                for (i = 1; i < 25; ++i) {
                    this.pt_indivisible[i] = sino;
                }
                sino = r.getBoolean("Parada_Prog");
                for (i = 1; i < 4; ++i) {
                    this.parada_programada[i] = sino;
                }
                this.participa = r.getBoolean("PARTICIPA");
            }
            if (!codigoexiste) {
                System.out.println("No se encuentra en la base de datos a " + cod_UP);
                return;
            }
            s.close();
            for (int hora = 1; hora < 25; ++hora) {
                s = dbtrab.createStatement();
                r = s.executeQuery("SELECT * FROM OVHORA" + hora + " WHERE (COD_UP= '" + cod_UP + "')" + " ORDER BY COD_UP, TRAMO, PRECIO");
                int contt = 0;
                while (r.next()) {
                    int auxtramo = r.getInt("TRAMO");
                    if (++contt != auxtramo) {
                        throw new Exception("Base de datos corrupta");
                    }
                    this.ofhora[hora][contt].precio = r.getDouble("PRECIO");
                    this.ofhora[hora][contt].energia = r.getDouble("ENERGIA");
                }
                this.numtramos[hora] = contt;
                s.close();
            }
            System.out.println("Datos de " + cod_UP + " cargados con exito");
        }
        catch (Exception e) {
            System.out.println("Error al leer de MDE tabla PRODUCTORES: " + e);
        }
    }

    void cargarOfAdquisicion(Connection dbtrab, String cod_UA) throws Exception {
        boolean codigoexiste = false;
        try {
            Statement s = dbtrab.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM COMPRADORES WHERE (COD_UA='" + cod_UA + "'" + ")");
            while (r.next()) {
                codigoexiste = true;
                this.participa = r.getBoolean("PARTICIPA");
            }
            if (!codigoexiste) {
                System.out.println("No se encuentra en la base de datos a " + this.cod_UP);
                return;
            }
            s.close();
            for (int hora = 1; hora < 25; ++hora) {
                s = dbtrab.createStatement();
                r = s.executeQuery("SELECT * FROM OAHORA" + hora + " WHERE (COD_UA= '" + this.cod_UP + "')" + " ORDER BY COD_UA, TRAMO, PRECIO");
                int contt = 0;
                while (r.next()) {
                    int auxtramo = r.getInt("TRAMO");
                    if (++contt != auxtramo) {
                        throw new Exception("Base de datos corrupta");
                    }
                    this.ofhora[hora][contt].precio = r.getDouble("PRECIO");
                    this.ofhora[hora][contt].energia = r.getDouble("ENERGIA");
                }
                this.numtramos[hora] = contt;
                s.close();
            }
            System.out.println("Datos de " + cod_UA + " cargados con exito");
        }
        catch (Exception e) {
            System.out.println("Error al leer de MDE tabla COMPRADORES: " + e);
        }
    }

    String verifyCompletDatos() {
        int conttval = 0;
        if (this.cod_UA.equals("")) {
            if (this.grad_arranque < 0.0 || this.grad_subida < 0.0 || this.grad_parada < 0.0 || this.grad_bajada < 0.0) {
                String mensaje = "Error: existe al menos un gradiente negativo";
                return mensaje;
            }
            this.con_var_carga = this.grad_arranque > 0.0 || this.grad_subida > 0.0 || this.grad_parada > 0.0 || this.grad_bajada > 0.0;
            if (this.ing_min_TF < 0.0) {
                String mensaje = "Error: ingreso minimo fijo negativo";
                return mensaje;
            }
            if (this.ing_min_TV < 0.0) {
                String mensaje = "Error: ingreso minimo variable negativo";
                return mensaje;
            }
            if (this.ing_min_TV > 0.0 && this.ing_min_TF == 0.0) {
                String mensaje = "Error: ingreso minimo fijo cero para ingreso minimo variable positivo";
                return mensaje;
            }
            if (this.pmax <= 0.0) {
                String mensaje = "Error: potencia maxima no valida";
                return mensaje;
            }
            for (int hora = 1; hora < 25; ++hora) {
                if (this.ofhora[hora][1].precio < 0.0) {
                    String mensaje = "Error: precio no valido en hora " + hora + " en tramo 1";
                    return mensaje;
                }
                if (this.ofhora[hora][1].energia < 0.0) {
                    String mensaje = "Error: energia no valida en hora " + hora + " en tramo 1";
                    return mensaje;
                }
                boolean contartramos = true;
                conttval = 0;
                for (int tramo = 1; tramo < 25; ++tramo) {
                    if (this.ofhora[hora][tramo].precio < this.ofhora[hora][tramo + 1].precio && this.ofhora[hora][tramo].energia < this.ofhora[hora][tramo + 1].energia) {
                        if (!contartramos) continue;
                        ++conttval;
                        continue;
                    }
                    if (this.ofhora[hora][tramo + 1].precio != 0.0) {
                        String mensaje = "Error: precio no creciente en hora " + hora + " entre tramos " + tramo + "y " + (tramo + 1) + ".";
                        return mensaje;
                    }
                    if (this.ofhora[hora][tramo + 1].energia != 0.0) {
                        String mensaje = "Error: energia no creciente en hora " + hora + " entre tramos " + tramo + "y " + (tramo + 1) + ".";
                        return mensaje;
                    }
                    contartramos = false;
                }
                if (contartramos) {
                    // empty if block
                }
                this.numtramos[hora] = ++conttval;
            }
            System.out.println("Datos de " + this.cod_UP + " correctos.");
        } else {
            for (int hora = 1; hora < 25; ++hora) {
                if (this.ofhora[hora][1].precio < 0.0) {
                    String mensaje = "Error: precio no valido en hora " + hora + " en tramo 1";
                    return mensaje;
                }
                if (this.ofhora[hora][1].energia < 0.0) {
                    String mensaje = "Error: energia no valida en hora " + hora + " en tramo 1";
                    return mensaje;
                }
                boolean contartramos = true;
                conttval = 0;
                for (int tramo = 1; tramo < 25; ++tramo) {
                    if (this.ofhora[hora][tramo].precio > this.ofhora[hora][tramo + 1].precio && this.ofhora[hora][tramo].energia < this.ofhora[hora][tramo + 1].energia) {
                        if (!contartramos) continue;
                        ++conttval;
                        continue;
                    }
                    if (this.ofhora[hora][tramo + 1].precio != 0.0) {
                        String mensaje = "Error: precio no decreciente en hora " + hora + " entre tramos " + tramo + " y " + (tramo + 1);
                        return mensaje;
                    }
                    if (this.ofhora[hora][tramo + 1].energia != 0.0) {
                        String mensaje = "Error: energia no creciente en hora " + hora + " entre tramos " + tramo + "y " + (tramo + 1) + ".";
                        return mensaje;
                    }
                    contartramos = false;
                }
                if (contartramos) {
                    // empty if block
                }
                this.numtramos[hora] = ++conttval;
            }
            System.out.println("Datos de " + this.cod_UA + " correctos.");
        }
        return "OK";
    }

    void ingresarDatos(Connection dbtrab) {
        try {
            if (this.cod_UA.equals("")) {
                Statement s = dbtrab.createStatement();
                s.executeUpdate("DELETE FROM PRODUCTORES WHERE (COD_UP='" + this.cod_UP + "')");
                s.close();
                String filatabla = "'" + this.cod_UP + "'" + ", ";
                filatabla = filatabla + this.ing_min_TF + ", ";
                filatabla = filatabla + this.ing_min_TV + ", ";
                filatabla = filatabla + this.grad_subida + ", ";
                filatabla = filatabla + this.grad_bajada + ", ";
                filatabla = filatabla + this.grad_arranque + ", ";
                filatabla = filatabla + this.grad_parada + ", ";
                filatabla = filatabla + this.pmax + ", ";
                filatabla = this.pt_indivisible[1] ? filatabla + "1, " : filatabla + "0, ";
                filatabla = this.parada_programada[1] ? filatabla + "1, " : filatabla + "0, ";
                filatabla = this.participa ? filatabla + "1" : filatabla + "0";
                s = dbtrab.createStatement();
                s.executeUpdate("INSERT INTO PRODUCTORES (Cod_UP,Ing_min_TF,Ing_min_TV,Grad_Subida,Grad_Bajada,Grad_Arranque,Grad_Parada,PMAX,Pt_indivisible,Parada_Prog,Participa) VALUES (" + filatabla + ")");
                s.close();
                for (int hora = 1; hora < 25; ++hora) {
                    s = dbtrab.createStatement();
                    s.executeUpdate("DELETE FROM OVHORA" + hora + " WHERE (COD_UP='" + this.cod_UP + "')");
                    s.close();
                    for (int tramo = 1; tramo <= this.numtramos[hora]; ++tramo) {
                        filatabla = "'" + this.cod_UP + "'" + " ," + tramo + " ," + this.ofhora[hora][tramo].precio + " ," + this.ofhora[hora][tramo].energia;
                        s = dbtrab.createStatement();
                        s.executeUpdate("INSERT INTO OVHORA" + hora + " (COD_UP,TRAMO,PRECIO,ENERGIA)" + " VALUES (" + filatabla + ")");
                        s.close();
                    }
                }
            } else {
                for (int hora = 1; hora < 25; ++hora) {
                    Statement s = dbtrab.createStatement();
                    s.executeUpdate("DELETE FROM OAHORA" + hora + " WHERE COD_UA = '" + this.cod_UA + "'");
                    s.close();
                    for (int tramo = 1; tramo <= this.numtramos[hora]; ++tramo) {
                        String filatabla = "'" + this.cod_UA + "'" + " ," + tramo + " ," + this.ofhora[hora][tramo].precio + " ," + this.ofhora[hora][tramo].energia;
                        s = dbtrab.createStatement();
                        s.executeUpdate("INSERT INTO OAHORA" + hora + " (COD_UA,TRAMO,PRECIO,ENERGIA)" + " VALUES (" + filatabla + ")");
                        s.close();
                    }
                }
                System.out.println("Datos de " + this.cod_UA + " ingresados con exito");
            }
        }
        catch (Exception e) {
            System.out.println("Error al ingresar oferta en la base de datos: " + e);
        }
    }

    SimMDE_taboferta(String AgentName, boolean isSupp) {
        if (isSupp) {
            this.cod_UP = AgentName;
        } else {
            this.cod_UA = AgentName;
        }
        this.ofhora = new SimMDE_ptocva[2][3];
        this.numtramos = new int[2];
    }

    public void setOffCurve(SimMDE_ptocva[] offcurve) {
        this.ofhora[1] = offcurve;
        this.numtramos[1] = offcurve.length - 1;
    }

    public void setInelastDemCurve(SimMDE_ptocva demand) {
        this.ofhora[1][0] = new SimMDE_ptocva();
        this.ofhora[1][1] = demand;
        this.ofhora[1][2] = new SimMDE_ptocva();
        this.ofhora[1][2].precio = 0.0;
        this.ofhora[1][2].energia = demand.energia + 0.1;
        this.numtramos[1] = 2;
    }

    public void setParticipa(boolean val) {
        this.participa = val;
    }

    public String[] getIdUsuarios() {
        return this.idUsuarios;
    }

    public void setIdUsuarios(String[] idUsuarios) {
        this.idUsuarios = idUsuarios;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String Name) {
        this.Name = Name;
    }

    public String[] getEmailAdresses() {
        return this.emailAdresses;
    }

    public void setEmailAdresses(String[] emailAdresses) {
        this.emailAdresses = emailAdresses;
    }

    public void write2Stream(PrintWriter myPrintStream) {
        if (this.cod_UP.equals("") && this.cod_UA.equals("")) {
            myPrintStream.println("Empty offer");
            return;
        }
        if (this.cod_UA.equals("")) {
            myPrintStream.println("Sale Offer by :" + this.cod_UP);
        } else {
            myPrintStream.println("Buy Offer by :" + this.cod_UA);
        }
        if (!this.participa) {
            myPrintStream.println("-----------> Not participate");
            return;
        }
        for (int hora = 1; hora < this.ofhora.length; ++hora) {
            int i;
            myPrintStream.println("---------------------------------------- hour(" + hora + ") ----------------------------------------");
            myPrintStream.print("Prices: ");
            for (i = 0; i <= this.numtramos[hora]; ++i) {
                myPrintStream.print(StringUtil.numformat(this.ofhora[hora][i].precio, 8, 1));
            }
            myPrintStream.print("\nEnergy: ");
            for (i = 0; i <= this.numtramos[hora]; ++i) {
                myPrintStream.print(StringUtil.numformat(this.ofhora[hora][i].energia, 8, 1));
            }
            myPrintStream.println("");
        }
    }
}

