/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.SimMDE_ptocva;
import de.core.SimMDE_taboferta;
import de.core.SimMDE_tabresultado;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SimMDE_CVA {
    Connection dbtrab;
    Vector origAgentesVenta = new Vector();
    Vector AgentesVenta = new Vector();
    Vector AgentesCompra = new Vector();
    Vector MejorSolucion = new Vector();
    SimMDE_ptocva[] transaccion;
    double[] pm_consumidor;
    int[] tipo_interseccion;
    SimMDE_tabresultado[] productor;
    SimMDE_tabresultado[] consumidor;

    SimMDE_CVA() {
        System.out.println("---------- Inicio de Carga de Curvas ------------");
    }

    public Connection OpenDataBase(String DBName, String user, String password) throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println("Error: en Connection OpenDatabase " + message);
            return null;
        }
        String dsn = "jdbc:odbc:" + DBName;
        return DriverManager.getConnection(dsn, user, password);
    }

    private void LeerDatos() throws Exception {
        boolean participa;
        ResultSet r;
        Statement s;
        try {
            s = this.dbtrab.createStatement();
            r = s.executeQuery("SELECT * FROM PRODUCTORES ORDER BY COD_UP , PARTICIPA");
            while (r.next() && (participa = r.getBoolean("PARTICIPA"))) {
                this.AgentesVenta.addElement(this.cargar_OfertaAgente(r, "PRODUCTORES"));
            }
            s.close();
            System.out.println("lectura OK de PRODUCTORES");
        }
        catch (Exception e) {
            System.out.println("Error al leer MDE en tabla de parametros PRODUCTORES " + e);
        }
        try {
            s = this.dbtrab.createStatement();
            r = s.executeQuery("SELECT * FROM COMPRADORES ORDER BY COD_UA , PARTICIPA");
            while (r.next() && (participa = r.getBoolean("PARTICIPA"))) {
                this.AgentesCompra.addElement(this.cargar_OfertaAgente(r, "COMPRADORES"));
            }
            s.close();
            System.out.println("lectura OK de COMPRADORES");
        }
        catch (Exception e) {
            System.out.println("Error al leer MDE en tabla de parametros COMPRADORES " + e);
        }
    }

    private SimMDE_taboferta cargar_OfertaAgente(ResultSet r0, String agente) throws Exception {
        int contt = 0;
        String tablahora = "";
        SimMDE_taboferta tof = new SimMDE_taboferta();
        try {
            String cod_unid;
            String cod_u;
            if (agente.equals("PRODUCTORES")) {
                int i;
                tablahora = "OVHORA";
                cod_u = "COD_UP ";
                tof.cod_UP = cod_unid = r0.getString("COD_UP");
                tof.ing_min_TF = r0.getDouble("Ing_min_TF");
                tof.ing_min_TV = r0.getDouble("Ing_min_TV");
                tof.grad_subida = r0.getDouble("Grad_Subida");
                tof.grad_bajada = r0.getDouble("Grad_Bajada");
                tof.grad_parada = r0.getDouble("Grad_Parada");
                tof.grad_arranque = r0.getDouble("Grad_Arranque");
                tof.pmax = r0.getDouble("PMAX");
                tof.con_var_carga = tof.grad_subida > 0.0 & tof.grad_bajada > 0.0 & tof.grad_parada > 0.0 & tof.grad_arranque > 0.0;
                boolean sino = r0.getBoolean("Pt_indivisible");
                for (i = 1; i < 25; ++i) {
                    tof.pt_indivisible[i] = sino;
                }
                sino = r0.getBoolean("Parada_Prog");
                for (i = 1; i < 4; ++i) {
                    tof.parada_programada[i] = sino;
                }
            } else {
                cod_u = "COD_UA ";
                tof.cod_UA = cod_unid = r0.getString("COD_UA");
                tablahora = "OAHORA";
            }
            for (int hora = 1; hora < 25; ++hora) {
                Statement s = this.dbtrab.createStatement();
                ResultSet r1 = s.executeQuery("SELECT * FROM " + tablahora + hora + " WHERE (" + cod_u + " = " + "'" + cod_unid + "'" + ")" + " ORDER BY " + cod_u + ", TRAMO, PRECIO");
                contt = 0;
                while (r1.next()) {
                    int auxtramo = r1.getInt("TRAMO");
                    if (++contt != auxtramo) {
                        this.SimMDE_Error("Error en MDE: tramos inconsistentes en " + tablahora + ", " + cod_unid);
                    }
                    tof.ofhora[hora][auxtramo].precio = r1.getDouble("PRECIO");
                    tof.ofhora[hora][auxtramo].energia = r1.getDouble("ENERGIA");
                }
                tof.numtramos[hora] = contt;
                s.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error al leer MDE en tabla " + tablahora + ": " + e);
        }
        return tof;
    }

    private void SimMDE_Error(String mensaje) throws Exception {
        mensaje = "Error: " + mensaje;
        throw new Exception(mensaje);
    }

    void principal() {
        try {
            this.dbtrab = this.OpenDataBase("MDE_DBwork", "admin", "lilo");
            this.dbtrab.setAutoCommit(true);
            this.LeerDatos();
            this.escribir_ArchCva();
            this.dbtrab.close();
            System.out.println("cerrada la coneccion con MDE");
        }
        catch (Exception e) {
            System.out.println(" Error en procedimiento:" + e);
            return;
        }
    }

    void escribir_ArchCva() throws Exception {
        for (int i = 0; i < this.AgentesVenta.size(); ++i) {
            SimMDE_taboferta pauxtabla = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
            String nomarch = pauxtabla.cod_UP + ".dat";
            FileOutputStream os = new FileOutputStream(nomarch);
            PrintStream myPrintStream = new PrintStream(os);
            myPrintStream.println("HORA \t TRAMO \t PRECIO \t ENERGIA");
            for (int hora = 1; hora < 25; ++hora) {
                for (int tramo = 1; tramo <= pauxtabla.numtramos[hora]; ++tramo) {
                    myPrintStream.println(hora + " \t " + tramo + " \t\t " + pauxtabla.ofhora[hora][tramo].precio + " \t " + pauxtabla.ofhora[hora][tramo].energia);
                }
            }
        }
    }
}

