/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.SimMDE;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SimMDEFrame
extends JDialog {
    private final SimMDE mySimMDE;
    private Thread MDEThread;
    private JButton btnBrowseMDE;
    private JButton btnBrowseOutFolder;
    private JButton btnCalculate;
    private JButton btnCancel;
    private JButton btnEraseDB;
    private JButton btnSendEmail;
    private JComboBox cbHost;
    private JCheckBox chkDoSplit;
    private JCheckBox chkShowCharts;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblOutFolder;
    private JLabel lblOutFolder2;
    private JPanel pnlConfig;
    private JPanel pnlDB;
    private JPanel pnlEmailConfig;
    private JTabbedPane pnlMainTabPanel;
    private JPanel pnlOK;
    private JPanel pnlUninodal;
    private JTextArea textArea;
    private JTextField txtEmailFrom;
    private JTextField txtMDELocation;
    private JTextField txtOutFolder;
    private JPasswordField txtPassFrom;

    public SimMDEFrame(Frame parent, SimMDE mysmde) {
        super(parent, false);
        this.initComponents();
        this.mySimMDE = mysmde;
    }

    public void appendText(String NewTextLine) {
        String newline = "\n";
        this.textArea.append(NewTextLine + newline);
        System.out.println(NewTextLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMDEFrame() {
        try {
            this.mySimMDE.disposeChartFrames();
            this.mySimMDE.finalizeMDEConnection();
        }
        catch (SQLException e) {
            System.out.println("Error closing connection with MDE database: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Unexpected error closing charts: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            this.dispose();
        }
    }

    private void initComponents() {
        this.pnlMainTabPanel = new JTabbedPane();
        this.pnlUninodal = new JPanel();
        this.jPanel1 = new JPanel();
        this.chkDoSplit = new JCheckBox();
        this.lblOutFolder = new JLabel();
        this.txtOutFolder = new JTextField();
        this.btnBrowseOutFolder = new JButton();
        this.chkShowCharts = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.pnlConfig = new JPanel();
        this.pnlEmailConfig = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtEmailFrom = new JTextField();
        this.txtPassFrom = new JPasswordField();
        this.cbHost = new JComboBox();
        this.pnlDB = new JPanel();
        this.lblOutFolder2 = new JLabel();
        this.txtMDELocation = new JTextField();
        this.btnBrowseMDE = new JButton();
        this.btnEraseDB = new JButton();
        this.pnlOK = new JPanel();
        this.btnCalculate = new JButton();
        this.btnCancel = new JButton();
        this.btnSendEmail = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Power Exchange Simulator");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SimMDEFrame.this.WindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.chkDoSplit.setSelected(true);
        this.chkDoSplit.setText("Split Result in Files");
        this.lblOutFolder.setText("Output Folder:");
        this.txtOutFolder.setText("Select Output Folder...");
        this.txtOutFolder.setToolTipText("Not implemented yet...");
        this.txtOutFolder.setEnabled(false);
        this.btnBrowseOutFolder.setText("...");
        this.btnBrowseOutFolder.setEnabled(false);
        this.chkShowCharts.setText("Show Charts");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkShowCharts).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblOutFolder).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtOutFolder, -2, 176, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseOutFolder, -2, 21, -2)).addComponent(this.chkDoSplit)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOutFolder).addComponent(this.txtOutFolder, -2, -1, -2).addComponent(this.btnBrowseOutFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addComponent(this.chkShowCharts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDoSplit).addContainerGap()));
        this.textArea.setEditable(false);
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Courier New", 0, 10));
        this.textArea.setRows(5);
        this.jScrollPane1.setViewportView(this.textArea);
        GroupLayout pnlUninodalLayout = new GroupLayout(this.pnlUninodal);
        this.pnlUninodal.setLayout(pnlUninodalLayout);
        pnlUninodalLayout.setHorizontalGroup(pnlUninodalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlUninodalLayout.createSequentialGroup().addGap(38, 38, 38).addGroup(pnlUninodalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jPanel1, -1, 324, Short.MAX_VALUE)).addGap(34, 34, 34)));
        pnlUninodalLayout.setVerticalGroup(pnlUninodalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlUninodalLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 190, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlMainTabPanel.addTab("Uninodal", this.pnlUninodal);
        this.pnlEmailConfig.setBorder(BorderFactory.createTitledBorder("Email Configuration"));
        this.jLabel1.setText("Sender user ID:");
        this.jLabel2.setText("Sender user Password:");
        this.jLabel3.setText("SMTP server:");
        this.txtEmailFrom.setText("example@email.com");
        this.txtPassFrom.setText("jPasswordField1");
        this.cbHost.setModel(new DefaultComboBoxModel<String>(new String[]{"smtp.gmail.com"}));
        GroupLayout pnlEmailConfigLayout = new GroupLayout(this.pnlEmailConfig);
        this.pnlEmailConfig.setLayout(pnlEmailConfigLayout);
        pnlEmailConfigLayout.setHorizontalGroup(pnlEmailConfigLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEmailConfigLayout.createSequentialGroup().addContainerGap().addGroup(pnlEmailConfigLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlEmailConfigLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtEmailFrom).addComponent(this.txtPassFrom, -1, 115, Short.MAX_VALUE).addComponent(this.cbHost, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18)));
        pnlEmailConfigLayout.setVerticalGroup(pnlEmailConfigLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlEmailConfigLayout.createSequentialGroup().addContainerGap().addGroup(pnlEmailConfigLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtEmailFrom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEmailConfigLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtPassFrom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlEmailConfigLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.cbHost, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        this.pnlDB.setBorder(BorderFactory.createTitledBorder("Dabatase"));
        this.lblOutFolder2.setText("Location:");
        this.txtMDELocation.setText("/database/MDE.mdb");
        this.txtMDELocation.setToolTipText("Not implemented yet...");
        this.txtMDELocation.setEnabled(false);
        this.btnBrowseMDE.setText("...");
        this.btnBrowseMDE.setEnabled(false);
        this.btnEraseDB.setText("Erase DB");
        this.btnEraseDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimMDEFrame.this.btnEraseDBActionPerformed(evt);
            }
        });
        GroupLayout pnlDBLayout = new GroupLayout(this.pnlDB);
        this.pnlDB.setLayout(pnlDBLayout);
        pnlDBLayout.setHorizontalGroup(pnlDBLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDBLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.lblOutFolder2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtMDELocation, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseMDE, -2, 21, -2).addContainerGap(12, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnlDBLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnEraseDB).addContainerGap()));
        pnlDBLayout.setVerticalGroup(pnlDBLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlDBLayout.createSequentialGroup().addContainerGap().addGroup(pnlDBLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOutFolder2).addComponent(this.txtMDELocation, -2, -1, -2).addComponent(this.btnBrowseMDE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addComponent(this.btnEraseDB).addContainerGap()));
        GroupLayout pnlConfigLayout = new GroupLayout(this.pnlConfig);
        this.pnlConfig.setLayout(pnlConfigLayout);
        pnlConfigLayout.setHorizontalGroup(pnlConfigLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConfigLayout.createSequentialGroup().addGap(35, 35, 35).addGroup(pnlConfigLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlDB, -1, -1, Short.MAX_VALUE).addComponent(this.pnlEmailConfig, -1, -1, Short.MAX_VALUE)).addGap(37, 37, 37)));
        pnlConfigLayout.setVerticalGroup(pnlConfigLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConfigLayout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.pnlEmailConfig, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlDB, -2, -1, -2).addContainerGap(64, Short.MAX_VALUE)));
        this.pnlMainTabPanel.addTab("Config", this.pnlConfig);
        this.btnCalculate.setText("Calculate");
        this.btnCalculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimMDEFrame.this.btnCalculateActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Close");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimMDEFrame.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnSendEmail.setText("Send Email");
        this.btnSendEmail.setEnabled(false);
        this.btnSendEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimMDEFrame.this.btnSendEmailActionPerformed(evt);
            }
        });
        GroupLayout pnlOKLayout = new GroupLayout(this.pnlOK);
        this.pnlOK.setLayout(pnlOKLayout);
        pnlOKLayout.setHorizontalGroup(pnlOKLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlOKLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnSendEmail).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCalculate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 76, -2).addContainerGap()));
        pnlOKLayout.setVerticalGroup(pnlOKLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlOKLayout.createSequentialGroup().addGroup(pnlOKLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCalculate).addComponent(this.btnCancel).addComponent(this.btnSendEmail)).addContainerGap(13, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMainTabPanel).addComponent(this.pnlOK, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlMainTabPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlOK, -2, -1, -2).addGap(0, 0, 0)));
        this.pack();
    }

    private void WindowClosing(WindowEvent evt) {
        this.closeMDEFrame();
    }

    private void btnCalculateActionPerformed(ActionEvent evt) {
        try {
            this.mySimMDE.setCreateCharts(this.chkShowCharts.isSelected());
            this.mySimMDE.Calculate();
            if (this.chkDoSplit.isSelected()) {
                this.mySimMDE.doSplitResInFiles();
                this.btnSendEmail.setEnabled(true);
                System.out.println("Splitting Results in Files Done!");
            }
        }
        catch (FileNotFoundException e) {
            String message = "Error creating results files: " + e.getMessage();
            JOptionPane.showMessageDialog(this, message, "Split File Error", 0);
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            String message = "Error splitting results in files: " + e.getMessage();
            JOptionPane.showMessageDialog(this, message, "File IO Error", 0);
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            String message = "Error performing market cleareance: " + e.toString();
            JOptionPane.showMessageDialog(this, message, "Calculation Error", 0);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeMDEFrame();
    }

    private void btnSendEmailActionPerformed(ActionEvent evt) {
        String tempsmtp = this.cbHost.getSelectedItem().toString();
        String tempemail = this.txtEmailFrom.getText();
        String temppass = new String(this.txtPassFrom.getPassword());
        this.mySimMDE.setEmailParameters(tempsmtp, tempemail, temppass);
        this.MDEThread = new Thread((Runnable)this.mySimMDE, "Thread-SendEmail");
        this.MDEThread.start();
    }

    private void btnEraseDBActionPerformed(ActionEvent evt) {
        int nYesNoDel = JOptionPane.showOptionDialog(this, "Are you sure you want to delete all offers from database?", "Delete Database", 0, 2, null, null, null);
        if (nYesNoDel == 1) {
            return;
        }
        try {
            this.mySimMDE.erase();
        }
        catch (Exception e) {
            String message = "Error Erasing Data Base: " + e.toString();
            JOptionPane.showMessageDialog(this, message, "Erasing Data Base Information", 0);
        }
    }
}

