/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import com.objectplanet.chart.LineChart;
import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.Schematic;
import de.core.SimMDEFrame;
import de.core.SimMDE_ptocva;
import de.core.SimMDE_taboferta;
import de.core.SimMDE_tabresultado;
import de.utils.Utils;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.MessagingException;

public class SimMDE
extends AnalysisTool
implements Runnable {
    SimMDEFrame MySimMDEFrame;
    Vector origAgentesVenta;
    Vector AgentesVenta;
    Vector AgentesCompra;
    Vector MejorSolucion;
    SimMDE_ptocva[] transaccion;
    double[] pm_consumidor;
    int[] tipo_interseccion;
    SimMDE_tabresultado[] productor;
    SimMDE_tabresultado[] consumidor;
    Vector auxResul;
    double[] lastEquil;
    private double lastPM;
    private double lastPMC;
    private double lastQD;
    private double lastTypInt;
    public Vector chartFrames;
    private Connection conMDE;
    public static String SIMDE_RESULT_FOLDER = RESULT_FOLDER + File.separator + "MDE_RES";
    public static String fileNamePat = "Res_";
    private String host;
    private String emailFrom;
    private String passFrom;
    private boolean createCharts = false;
    private Map<String, File> createdFiles;

    SimMDE(Schematic sch) {
        super(sch);
        this.origAgentesVenta = new Vector();
        this.AgentesVenta = new Vector();
        this.AgentesCompra = new Vector();
        this.MejorSolucion = new Vector();
        this.chartFrames = new Vector();
        System.out.println("---------- Inicio de Daily Market Simulation ------------");
        if (this.MySimMDEFrame == null) {
            this.MySimMDEFrame = new SimMDEFrame((Frame)DeepEdit.frame, this);
        }
        this.MySimMDEFrame.setLocationRelativeTo(DeepEdit.frame);
        this.MySimMDEFrame.setVisible(true);
    }

    SimMDE(Schematic sch, boolean disc) {
        super(sch);
        this.AgentesVenta = new Vector();
        this.AgentesCompra = new Vector();
        this.auxResul = new Vector();
    }

    public void addMarketAgent(SimMDE_taboferta tableAgentOf, SimMDE_tabresultado tableAgentRes, boolean isSupp) {
        if (isSupp) {
            this.AgentesVenta.addElement(tableAgentOf);
            this.auxResul.addElement(tableAgentRes);
        } else {
            this.AgentesCompra.addElement(tableAgentOf);
        }
    }

    private boolean LeerDatos() {
        boolean participa;
        ResultSet r;
        Statement s;
        try {
            s = this.conMDE.createStatement();
            r = s.executeQuery("SELECT * FROM PRODUCTORES ORDER BY COD_UP , PARTICIPA");
            while (r.next() && (participa = r.getBoolean("PARTICIPA"))) {
                this.AgentesVenta.addElement(this.cargar_OfertaAgente(r, "PRODUCTORES"));
            }
            s.close();
            System.out.println("lectura OK de PRODUCTORES");
        }
        catch (Exception e) {
            System.out.println("Error al leer MDE en tabla de parametros PRODUCTORES " + e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        try {
            s = this.conMDE.createStatement();
            r = s.executeQuery("SELECT * FROM COMPRADORES ORDER BY COD_UA , PARTICIPA");
            while (r.next() && (participa = r.getBoolean("PARTICIPA"))) {
                this.AgentesCompra.addElement(this.cargar_OfertaAgente(r, "COMPRADORES"));
            }
            s.close();
            System.out.println("lectura OK de COMPRADORES");
        }
        catch (Exception e) {
            System.out.println("Error al leer MDE en tabla de parametros COMPRADORES " + e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        if (this.AgentesCompra.isEmpty()) {
            System.out.println("Error: No se encontraron compradores!");
            System.out.println("Asegurese que existen compradores en tabla COMPRADORES y que (al menos) 1 tenga Participa=true");
            return false;
        }
        if (this.AgentesVenta.isEmpty()) {
            System.out.println("Error: No se encontraron productores!");
            System.out.println("Asegurese que existen agentes en tabla PRODUCTORES y que (al menos) 1 tenga Participa=true");
            return false;
        }
        return true;
    }

    public void erase() throws Exception {
        String query = "";
        int x = 0;
        Statement s = this.conMDE.createStatement();
        for (int k = 1; k < 25; ++k) {
            query = "DELETE * FROM OAHORA" + k;
            System.out.println(query);
            x = s.executeUpdate(query);
            query = "DELETE * FROM OVHORA" + k;
            System.out.println(query);
            x = s.executeUpdate(query);
        }
        s.close();
        System.out.println("Borrado de Informaci\u00f3n de BD MDE");
    }

    private SimMDE_taboferta cargar_OfertaAgente(ResultSet r0, String agente) throws Exception {
        ResultSet r1;
        Statement s;
        int contt = 0;
        String tablahora = "";
        SimMDE_taboferta tof = new SimMDE_taboferta();
        try {
            String cod_unid;
            String cod_u;
            if (agente.equals("PRODUCTORES")) {
                int i;
                tablahora = "OVHORA";
                cod_u = "COD_UP ";
                tof.cod_UP = cod_unid = r0.getString("COD_UP");
                tof.ing_min_TF = r0.getDouble("Ing_min_TF");
                tof.ing_min_TV = r0.getDouble("Ing_min_TV");
                tof.grad_subida = r0.getDouble("Grad_Subida");
                tof.grad_bajada = r0.getDouble("Grad_Bajada");
                tof.grad_parada = r0.getDouble("Grad_Parada");
                tof.grad_arranque = r0.getDouble("Grad_Arranque");
                tof.pmax = r0.getDouble("PMAX");
                tof.con_var_carga = tof.grad_subida > 0.0 && tof.grad_bajada > 0.0 && tof.grad_parada > 0.0 && tof.grad_arranque > 0.0;
                boolean sino = r0.getBoolean("Pt_indivisible");
                for (i = 1; i < 25; ++i) {
                    tof.pt_indivisible[i] = sino;
                }
                sino = r0.getBoolean("Parada_Prog");
                for (i = 1; i < 4; ++i) {
                    tof.parada_programada[i] = sino;
                }
            } else {
                cod_u = "COD_UA ";
                tof.cod_UA = cod_unid = r0.getString("COD_UA");
                tablahora = "OAHORA";
            }
            tof.setName(cod_unid);
            for (int hora = 1; hora < 25; ++hora) {
                s = this.conMDE.createStatement();
                r1 = s.executeQuery("SELECT * FROM " + tablahora + hora + " WHERE (" + cod_u + " = " + "'" + cod_unid + "'" + ")" + " ORDER BY " + cod_u + ", TRAMO, PRECIO");
                contt = 0;
                while (r1.next()) {
                    int auxtramo = r1.getInt("TRAMO");
                    if (++contt != auxtramo) {
                        this.SimMDE_Error("Error en MDE: tramos inconsistentes en " + tablahora + hora + ", " + cod_unid);
                    }
                    tof.ofhora[hora][auxtramo].precio = r1.getDouble("PRECIO");
                    tof.ofhora[hora][auxtramo].energia = r1.getDouble("ENERGIA");
                }
                tof.numtramos[hora] = contt;
                s.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error al leer MDE en tabla " + tablahora + ": " + e);
        }
        try {
            String[] tempArray;
            s = this.conMDE.createStatement();
            r1 = s.executeQuery("SELECT * FROM usergeneral WHERE (utility = '" + tof.getName() + "')");
            ArrayList<String> tempIdUser = new ArrayList<String>();
            ArrayList<String> tempEmail = new ArrayList<String>();
            while (r1.next()) {
                String tempuserid;
                String tempemail = r1.getString("email");
                if (tempemail != null) {
                    tempEmail.add(tempemail);
                }
                if ((tempuserid = r1.getString("userid")) == null) continue;
                tempIdUser.add(tempuserid);
            }
            if (!tempIdUser.isEmpty()) {
                tempArray = tempIdUser.toArray(new String[tempIdUser.size()]);
                tof.setIdUsuarios(tempArray);
            }
            if (!tempEmail.isEmpty()) {
                tempArray = tempEmail.toArray(new String[tempEmail.size()]);
                tof.setEmailAdresses(tempArray);
            }
            s.close();
        }
        catch (SQLException e) {
            System.out.println("Error querying user's data from usergeneral table" + e.getMessage());
        }
        return tof;
    }

    public boolean casacionSimpleI(int hora) {
        double[] sol;
        double maxx = 0.0;
        double maxp = 0.0;
        boolean j = false;
        int k = 0;
        SimMDE_ptocva[] COV = this.getCOV(hora);
        SimMDE_ptocva[] COA = this.getCOA(hora);
        if (this.createCharts) {
            maxx = Math.max(maxx, COV[COV.length - 1].energia);
            maxx = Math.max(maxx, COA[COA.length - 1].energia);
            maxp = Math.max(maxp, COV[COV.length - 1].precio);
            maxp = Math.max(maxp, COA[COA.length - 1].precio);
            LineChart chart = new LineChart(2, (int)maxx + 200, maxp + 50.0);
            chart.setConnectedLinesOn(0, true);
            chart.setConnectedLinesOn(1, true);
            j = false;
            for (k = 0; k < COA.length - 1; ++k) {
                chart.setSampleValue(0, (int)Math.round(COA[k].energia), COA[k].precio);
                chart.setSampleValue(0, (int)Math.round(COA[k].energia + 1.0), COA[k + 1].precio);
            }
            chart.setSampleValue(0, (int)Math.round(COA[COA.length - 1].energia), COA[COA.length - 1].precio);
            for (k = 0; k < COV.length - 1; ++k) {
                chart.setSampleValue(1, (int)Math.round(COV[k].energia), COV[k].precio);
                chart.setSampleValue(1, (int)Math.round(COV[k].energia + 1.0), COV[k + 1].precio);
            }
            chart.setSampleValue(1, (int)Math.round(COV[COV.length - 1].energia), COV[COV.length - 1].precio);
            chart.setTitle("Casaci\u00f3n Hora " + hora);
            chart.setSeriesLabel(0, "Oferta Compra");
            chart.setSeriesLabel(1, "Oferta Venta");
            String[] labels = new String[(int)maxx + 1];
            for (k = 0; k < (int)maxx + 1; ++k) {
                labels[k] = "";
                if (Math.ceil((double)k / 10.0) != Math.floor((double)k / 10.0)) continue;
                labels[k] = "" + k;
            }
            chart.setSampleLabels(labels);
            chart.setTitleOn(true);
            chart.setLegendOn(true);
            chart.setValueLinesOn(true);
            chart.setRangeAdjusterOn(true);
            chart.setSampleLabelsOn(true);
            chart.setGridLinesOn(true);
            chart.setSampleScrollerOn(true);
            chart.setAutoLabelSpacingOn(true);
            chart.setLabel("Energ\u00eda", "[MWh]");
            chart.setLabel("Precio", "[$/MWh]");
            Frame f = new Frame("Casaci\u00f3n");
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    Frame f = (Frame)event.getWindow();
                    f.setVisible(false);
                    f.dispose();
                }
            });
            f.add("Center", chart);
            f.setSize(300, 300);
            f.setVisible(true);
            this.chartFrames.add(f);
        }
        if ((sol = this.getEqMerc(COV, COA))[2] == -1.0) {
            return false;
        }
        this.asignarProdyDem(sol[0], sol[1], sol[2], sol[3], hora);
        this.transaccion[hora].precio = sol[0];
        this.transaccion[hora].energia = sol[1];
        Double aux = new Double(sol[2]);
        this.tipo_interseccion[hora] = aux.intValue();
        this.pm_consumidor[hora] = sol[3];
        return true;
    }

    private double[] getEqMerc(SimMDE_ptocva[] COV, SimMDE_ptocva[] COA) {
        double PM = 0.0;
        double QD = 0.0;
        double tipointers = -1.0;
        double PMC = 1.0E11;
        boolean hayinters = true;
        int i = COV.length - 1;
        int j = COA.length - 1;
        if (i > 0 && j > 0) {
            if (COV[i].precio < COA[j].precio) {
                hayinters = false;
                PM = COV[i].precio;
                QD = COV[i].energia < COA[j].energia ? COV[i].energia : COA[j].energia;
            }
            j = 1;
            i = 1;
            if (COV[i].precio > COA[j].precio) {
                hayinters = false;
            }
        } else {
            hayinters = false;
        }
        if (hayinters) {
            int j2;
            for (i = 1; i < COV.length; ++i) {
                for (j = 1; j < COA.length && !(COA[j].precio < COV[i].precio); ++j) {
                }
                if (COV[i].energia >= COA[--j].energia) break;
            }
            for (j2 = j; j2 < COA.length && !(COA[j2].energia >= COV[i - 1].energia); ++j2) {
            }
            if (i >= COV.length) {
                i = COV.length - 1;
            }
            if (j >= COA.length) {
                j = COA.length - 1;
            }
            if (COV[i].energia == COA[j].energia && COV[i].precio == COA[j].precio) {
                PM = COV[i].precio;
                QD = COV[i].energia;
                tipointers = 0.0;
            } else if (COV[i].energia != COA[j].energia && COV[i].precio == COA[j].precio) {
                if (COV[i - 1].energia == COA[j].energia) {
                    PM = COV[i - 1].precio;
                    QD = COA[j].energia;
                    tipointers = 0.0;
                } else if (COV[i - 1].precio <= COA[j2].precio && COV[i - 1].energia > COA[j2 - 1].energia) {
                    PM = COV[i - 1].precio;
                    QD = COV[i - 1].energia;
                    tipointers = 1.0;
                } else {
                    PM = COV[i].precio;
                    QD = COA[j].energia;
                    tipointers = 2.0;
                }
            } else if (COV[i].energia == COA[j].energia && COV[i].precio != COA[j].precio) {
                PM = COV[i].precio;
                QD = COA[j].energia;
                tipointers = 0.0;
            } else if (COV[i - 1].energia < COA[j].energia && COV[i].precio < COA[j].precio) {
                PM = COV[i].precio;
                QD = COA[j].energia;
                tipointers = 2.0;
            } else {
                PM = COV[i - 1].precio;
                QD = COV[i - 1].energia;
                tipointers = COA[j2].energia == COV[i - 1].energia ? 0.0 : 1.0;
            }
        }
        for (i = COA.length - 1; i >= 0; --i) {
            if (!(COA[i].precio >= PM)) continue;
            if (tipointers == 1.0 && i > 0) {
                if (!(COA[i].energia > QD) || !(COA[i - 1].energia < QD)) continue;
                PMC = COA[i].precio;
                break;
            }
            PMC = COA[i].precio;
            break;
        }
        if (i < 0) {
            System.out.println("Error en procedimiento de interseccion de curvas de mercado. PMC no encontrado.");
        }
        double[] solucion = new double[]{PM, QD, tipointers, PMC};
        return solucion;
    }

    private SimMDE_ptocva[] getCOV(int hora) {
        int i;
        Vector<SimMDE_ptocva> aux = new Vector<SimMDE_ptocva>(100, 25);
        SimMDE_ptocva punto = new SimMDE_ptocva();
        punto.precio = -10.0;
        punto.energia = 0.0;
        aux.addElement(punto);
        for (int ivendedor = 0; ivendedor < this.AgentesVenta.size(); ++ivendedor) {
            if (!this.productor[ivendedor].cumpleIngMin || !this.productor[ivendedor].participa[hora]) continue;
            SimMDE_taboferta tabvendedor = (SimMDE_taboferta)this.AgentesVenta.elementAt(ivendedor);
            int numtramos = tabvendedor.numtramos[hora];
            if (numtramos <= 0) continue;
            int j = 0;
            for (int itramo = 1; itramo <= numtramos; ++itramo) {
                double precio = tabvendedor.ofhora[hora][itramo].precio;
                double incenergia = tabvendedor.ofhora[hora][itramo].energia - tabvendedor.ofhora[hora][itramo - 1].energia;
                while (j < aux.size()) {
                    punto = (SimMDE_ptocva)aux.elementAt(j);
                    if (precio < punto.precio) {
                        punto = new SimMDE_ptocva();
                        punto.precio = precio;
                        punto.energia = incenergia;
                        aux.insertElementAt(punto, j);
                        break;
                    }
                    if (precio == punto.precio) {
                        punto.energia += incenergia;
                        aux.setElementAt(punto, j);
                        break;
                    }
                    ++j;
                }
                if (j != aux.size()) continue;
                punto = new SimMDE_ptocva();
                punto.precio = precio;
                punto.energia = incenergia;
                aux.addElement(punto);
            }
        }
        SimMDE_ptocva[] res = new SimMDE_ptocva[aux.size()];
        for (i = 0; i < aux.size(); ++i) {
            res[i] = (SimMDE_ptocva)aux.elementAt(i);
        }
        for (i = 1; i < res.length; ++i) {
            res[i].energia += res[i - 1].energia;
        }
        return res;
    }

    private SimMDE_ptocva[] getCOA(int hora) {
        Vector<SimMDE_ptocva> aux = new Vector<SimMDE_ptocva>(100, 25);
        SimMDE_ptocva punto = new SimMDE_ptocva();
        punto.precio = 1.0E101;
        punto.energia = 0.0;
        aux.addElement(punto);
        for (int icomprador = 0; icomprador < this.AgentesCompra.size(); ++icomprador) {
            SimMDE_taboferta tabcomprador = (SimMDE_taboferta)this.AgentesCompra.elementAt(icomprador);
            int numtramos = tabcomprador.numtramos[hora];
            if (numtramos <= 0) continue;
            int j = 0;
            for (int itramo = 1; itramo <= numtramos; ++itramo) {
                double precio = tabcomprador.ofhora[hora][itramo].precio;
                double incenergia = tabcomprador.ofhora[hora][itramo].energia - tabcomprador.ofhora[hora][itramo - 1].energia;
                while (j < aux.size()) {
                    punto = (SimMDE_ptocva)aux.elementAt(j);
                    if (precio > punto.precio) {
                        punto = new SimMDE_ptocva();
                        punto.precio = precio;
                        punto.energia = incenergia;
                        aux.insertElementAt(punto, j);
                        break;
                    }
                    if (precio == punto.precio) {
                        punto.energia += incenergia;
                        aux.setElementAt(punto, j);
                        break;
                    }
                    ++j;
                }
                if (j != aux.size()) continue;
                punto = new SimMDE_ptocva();
                punto.precio = precio;
                punto.energia = incenergia;
                aux.addElement(punto);
            }
        }
        punto = new SimMDE_ptocva();
        punto.energia = 0.0;
        punto.precio = 0.0;
        aux.addElement(punto);
        SimMDE_ptocva[] res = new SimMDE_ptocva[aux.size()];
        res[0] = (SimMDE_ptocva)aux.elementAt(0);
        for (int i = 1; i < aux.size(); ++i) {
            res[i] = (SimMDE_ptocva)aux.elementAt(i);
            res[i].energia += res[i - 1].energia;
        }
        return res;
    }

    private void asignarProdyDem(double PM, double QD, double tipointers, double PMC, int hora) {
        int itramo;
        int k;
        double ETM = 0.0;
        double EPDT = 0.0;
        double EXOF = 0.0;
        double[] ED = new double[this.productor.length];
        double[] EM = new double[this.productor.length];
        block0: for (k = 0; k < this.productor.length; ++k) {
            if (!this.productor[k].cumpleIngMin || !this.productor[k].participa[hora]) continue;
            SimMDE_taboferta pvendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(k);
            for (itramo = pvendor.numtramos[hora]; itramo > 0; --itramo) {
                if (pvendor.ofhora[hora][itramo].precio == PM) {
                    this.productor[k].tramocas[hora] = itramo;
                    if (tipointers == 2.0) {
                        EM[k] = pvendor.ofhora[hora][itramo].energia - pvendor.ofhora[hora][itramo - 1].energia;
                        ED[k] = pvendor.ofhora[hora][itramo - 1].energia;
                        continue block0;
                    }
                    ED[k] = pvendor.ofhora[hora][itramo].energia;
                    continue block0;
                }
                if (!(pvendor.ofhora[hora][itramo].precio < PM)) continue;
                this.productor[k].tramocas[hora] = itramo;
                ED[k] = pvendor.ofhora[hora][itramo].energia;
                continue block0;
            }
        }
        if (tipointers == 2.0) {
            for (k = 0; k < this.productor.length; ++k) {
                ETM += EM[k];
                EPDT += ED[k];
            }
            EXOF = ETM + EPDT - QD;
            for (k = 0; k < this.productor.length; ++k) {
                if (!(EM[k] > 0.0)) continue;
                int n = k;
                ED[n] = ED[n] + EM[k] * (1.0 - EXOF / ETM);
            }
        }
        for (k = 0; k < this.productor.length; ++k) {
            this.productor[k].energiacas[hora] = ED[k];
        }
        ETM = 0.0;
        EPDT = 0.0;
        EXOF = 0.0;
        ED = new double[this.consumidor.length];
        EM = new double[this.consumidor.length];
        block5: for (k = 0; k < this.consumidor.length; ++k) {
            SimMDE_taboferta pconsum = (SimMDE_taboferta)this.AgentesCompra.elementAt(k);
            for (itramo = pconsum.numtramos[hora]; itramo > 0; --itramo) {
                if (pconsum.ofhora[hora][itramo].precio == PMC) {
                    this.consumidor[k].tramocas[hora] = itramo;
                    if (tipointers == 1.0) {
                        EM[k] = pconsum.ofhora[hora][itramo].energia - pconsum.ofhora[hora][itramo - 1].energia;
                        ED[k] = pconsum.ofhora[hora][itramo - 1].energia;
                        continue block5;
                    }
                    ED[k] = pconsum.ofhora[hora][itramo].energia;
                    continue block5;
                }
                if (!(pconsum.ofhora[hora][itramo].precio > PMC)) continue;
                this.consumidor[k].tramocas[hora] = itramo;
                ED[k] = pconsum.ofhora[hora][itramo].energia;
                continue block5;
            }
        }
        if (tipointers == 1.0) {
            for (k = 0; k < this.consumidor.length; ++k) {
                ETM += EM[k];
                EPDT += ED[k];
            }
            EXOF = ETM + EPDT - QD;
            for (k = 0; k < this.consumidor.length; ++k) {
                if (!(EM[k] > 0.0)) continue;
                int n = k;
                ED[n] = ED[n] + EM[k] * (1.0 - EXOF / ETM);
            }
        }
        for (k = 0; k < this.consumidor.length; ++k) {
            this.consumidor[k].energiacas[hora] = ED[k];
        }
    }

    private boolean casacionSimpleCondicionada() {
        SimMDE_taboferta vendor;
        int i;
        boolean haycondvarcarga = false;
        int hora = 1;
        boolean haysolucion = this.casacionSimpleI(hora);
        if (!haysolucion) {
            return false;
        }
        for (i = 0; i < this.productor.length; ++i) {
            if (!this.productor[i].cumpleIngMin) continue;
            vendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
            haycondvarcarga = vendor.con_var_carga;
            if (haycondvarcarga) break;
        }
        if (haycondvarcarga) {
            double gd;
            double EMAX;
            double PMAX;
            double PM0;
            double P1;
            double P0;
            double E1;
            double gu;
            int iprod;
            for (iprod = 0; iprod < this.AgentesVenta.size(); ++iprod) {
                vendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
                if (!vendor.con_var_carga) continue;
                gu = vendor.pt_indivisible[hora] ? (this.productor[iprod].energiacas[hora] < vendor.ofhora[hora][1].energia ? vendor.grad_arranque : vendor.grad_subida) : vendor.grad_subida;
                E1 = this.productor[iprod].energiacas[hora];
                P0 = E1 - gu * 30.0;
                P1 = E1 + gu * 30.0;
                double gu1 = P0 < 0.0 ? E1 / 30.0 : gu;
                PM0 = vendor.pmax;
                double gu2 = P1 > PM0 ? (PM0 - E1) / 30.0 : gu;
                gu = Math.min(gu1, gu2);
                P0 = E1 - gu * 30.0;
                P1 = E1 + gu * 30.0;
                PMAX = PM0;
                EMAX = E1;
                this.productor[iprod].potencia[0] = P0;
                this.productor[iprod].pmax[0] = PM0;
                this.productor[iprod].potencia[hora] = P1;
                this.productor[iprod].pmax[hora] = PMAX;
                this.productor[iprod].emax[hora] = EMAX;
                this.productor[iprod].grad_crec[hora] = gu;
            }
            for (hora = 2; hora < 25; ++hora) {
                for (iprod = 0; iprod < this.AgentesVenta.size(); ++iprod) {
                    vendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
                    if (!vendor.con_var_carga) continue;
                    P0 = this.productor[iprod].potencia[hora - 1];
                    gu = vendor.pt_indivisible[hora] ? (P0 < vendor.ofhora[hora][1].energia ? vendor.grad_arranque : vendor.grad_subida) : vendor.grad_subida;
                    PMAX = P0 + gu * 60.0;
                    PMAX = Math.min(PMAX, vendor.pmax);
                    EMAX = (P0 + PMAX) / 2.0;
                    this.productor[iprod].pmax[hora] = PMAX;
                    this.productor[iprod].emax[hora] = EMAX;
                    this.productor[iprod].grad_crec[hora] = gu;
                    if (!(EMAX < vendor.ofhora[hora][vendor.numtramos[hora]].energia)) continue;
                    this.limitar_oferta(vendor, hora, EMAX);
                }
                haysolucion = this.casacionSimpleI(hora);
                if (!haysolucion) {
                    return false;
                }
                for (iprod = 0; iprod < this.AgentesVenta.size(); ++iprod) {
                    vendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
                    if (!vendor.con_var_carga) continue;
                    P0 = this.productor[iprod].potencia[hora - 1];
                    double E0 = this.productor[iprod].energiacas[hora - 1];
                    E1 = this.productor[iprod].energiacas[hora];
                    P1 = hora == 2 ? (E1 > E0 ? Math.min(1.5 * E1 - 0.5 * E0, this.productor[iprod].pmax[hora]) : E1) : (E1 > P0 ? 2.0 * E1 - P0 : E1);
                    this.productor[iprod].potencia[hora] = P1;
                }
            }
            hora = 24;
            for (iprod = 0; iprod < this.AgentesVenta.size(); ++iprod) {
                vendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
                if (!vendor.con_var_carga) continue;
                gd = vendor.pt_indivisible[hora] ? (this.productor[iprod].energiacas[hora] < vendor.ofhora[hora][1].energia ? vendor.grad_parada : vendor.grad_bajada) : vendor.grad_bajada;
                E1 = this.productor[iprod].energiacas[hora];
                P0 = E1 + gd * 30.0;
                P1 = E1 - gd * 30.0;
                PM0 = this.productor[iprod].pmax[hora - 1];
                double gd1 = P0 > PM0 ? (PM0 - E1) / 30.0 : gd;
                double gd2 = P1 < 0.0 ? E1 / 30.0 : gd;
                gd = Math.min(gd1, gd2);
                P0 = E1 + gd * 30.0;
                P1 = E1 - gd * 30.0;
                this.productor[iprod].potencia[hora] = Math.min(P1, this.productor[iprod].potencia[hora]);
                this.productor[iprod].potencia[hora - 1] = Math.min(P0, this.productor[iprod].potencia[hora - 1]);
                this.productor[iprod].grad_decrec[hora] = gd;
            }
            for (hora = 23; hora > 0; --hora) {
                for (iprod = 0; iprod < this.AgentesVenta.size(); ++iprod) {
                    vendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
                    if (!vendor.con_var_carga) continue;
                    P1 = this.productor[iprod].potencia[hora];
                    gd = vendor.pt_indivisible[hora] ? (P1 < vendor.ofhora[hora][1].energia ? vendor.grad_parada : vendor.grad_bajada) : vendor.grad_bajada;
                    PMAX = P1 + gd * 60.0;
                    PMAX = Math.min(PMAX, this.productor[iprod].pmax[hora - 1]);
                    EMAX = (P1 + PMAX) / 2.0;
                    this.productor[iprod].pmax[hora - 1] = PMAX;
                    this.productor[iprod].grad_decrec[hora] = gd;
                    if (!(EMAX < this.productor[iprod].emax[hora]) || !(EMAX < vendor.ofhora[hora][vendor.numtramos[hora]].energia)) continue;
                    this.productor[iprod].emax[hora] = EMAX;
                    this.limitar_oferta(vendor, hora, EMAX);
                }
                haysolucion = this.casacionSimpleI(hora);
                if (!haysolucion) {
                    return false;
                }
                for (iprod = 0; iprod < this.AgentesVenta.size(); ++iprod) {
                    vendor = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
                    if (!vendor.con_var_carga) continue;
                    P1 = this.productor[iprod].potencia[hora];
                    E1 = this.productor[iprod].energiacas[hora];
                    double E2 = this.productor[iprod].energiacas[hora + 1];
                    P0 = hora == 23 ? (E1 > E2 ? Math.min(1.5 * E1 - 0.5 * E2, this.productor[iprod].pmax[hora - 1]) : E1) : (E1 > P1 ? 2.0 * E1 - P1 : E1);
                    this.productor[iprod].potencia[hora - 1] = P0;
                }
            }
        } else {
            for (hora = 2; hora < 25; ++hora) {
                haysolucion = this.casacionSimpleI(hora);
                if (haysolucion) continue;
                return false;
            }
        }
        return haysolucion;
    }

    private void limitar_oferta(SimMDE_taboferta vendor, int hora, double EMAX) {
        for (int itramo = 1; itramo <= vendor.numtramos[hora]; --itramo) {
            if (!(vendor.ofhora[hora][itramo].energia >= EMAX)) continue;
            vendor.numtramos[hora] = itramo;
            vendor.ofhora[hora][itramo].energia = EMAX;
            break;
        }
    }

    private boolean obtenerSolucionValida() {
        int i;
        this.productor = new SimMDE_tabresultado[this.AgentesVenta.size()];
        this.consumidor = new SimMDE_tabresultado[this.AgentesCompra.size()];
        this.pm_consumidor = new double[25];
        this.transaccion = new SimMDE_ptocva[25];
        this.tipo_interseccion = new int[25];
        for (i = 1; i < 25; ++i) {
            this.transaccion[i] = new SimMDE_ptocva();
        }
        for (i = 0; i < this.AgentesVenta.size(); ++i) {
            this.productor[i] = new SimMDE_tabresultado((SimMDE_taboferta)this.AgentesVenta.elementAt(i));
        }
        for (i = 0; i < this.AgentesCompra.size(); ++i) {
            this.consumidor[i] = new SimMDE_tabresultado((SimMDE_taboferta)this.AgentesCompra.elementAt(i));
        }
        return this.casacionSimpleCondicionada();
        {
        }
    }

    public void initMarket() {
        int i;
        this.productor = new SimMDE_tabresultado[this.AgentesVenta.size()];
        this.consumidor = new SimMDE_tabresultado[this.AgentesCompra.size()];
        this.pm_consumidor = new double[2];
        this.transaccion = new SimMDE_ptocva[2];
        this.tipo_interseccion = new int[2];
        for (i = 1; i < 2; ++i) {
            this.transaccion[i] = new SimMDE_ptocva();
        }
        for (i = 0; i < this.AgentesVenta.size(); ++i) {
            this.productor[i] = (SimMDE_tabresultado)this.auxResul.elementAt(i);
        }
        for (i = 0; i < this.AgentesCompra.size(); ++i) {
            this.consumidor[i] = new SimMDE_tabresultado((SimMDE_taboferta)this.AgentesCompra.elementAt(i));
        }
    }

    private void guardarResultado() {
        SimMDE_tabresultado[] presprod = (SimMDE_tabresultado[])this.MejorSolucion.elementAt(0);
        SimMDE_tabresultado[] prescomp = (SimMDE_tabresultado[])this.MejorSolucion.elementAt(1);
        SimMDE_ptocva[] presmercado = (SimMDE_ptocva[])this.MejorSolucion.elementAt(2);
        int[] ptipointers = (int[])this.MejorSolucion.elementAt(3);
        double[] ppmc = (double[])this.MejorSolucion.elementAt(4);
        if (this.conMDE == null) {
            assert (false) : "Why did you close the connection if you haven't saved the results??";
            this.conMDE = DeepEdit.OpenODBC_JDBCConnection("MDE", true);
        }
        try {
            String filatabla;
            int hora;
            int i;
            if (this.conMDE.isClosed()) {
                assert (false) : "Why did you close the connection if you haven't stored the results??";
                this.conMDE = DeepEdit.OpenODBC_JDBCConnection("MDE", true);
            }
            Statement s = this.conMDE.createStatement();
            s.executeUpdate("DELETE * FROM RES_PRODUCTORES");
            s.close();
            for (i = 0; i < presprod.length; ++i) {
                for (hora = 1; hora < 25; ++hora) {
                    filatabla = "'" + presprod[i].cod_UP + "'" + ", ";
                    filatabla = presprod[i].cumpleIngMin ? filatabla + "1, " : filatabla + "0, ";
                    filatabla = filatabla + hora + ", ";
                    filatabla = filatabla + presprod[i].tramocas[hora] + ", ";
                    filatabla = filatabla + presprod[i].energiacas[hora] + ", ";
                    filatabla = filatabla + presprod[i].grad_crec[hora] + ", ";
                    filatabla = filatabla + presprod[i].grad_decrec[hora] + ", ";
                    filatabla = filatabla + presprod[i].potencia[hora] + ", ";
                    filatabla = filatabla + presprod[i].emax[hora] + ", ";
                    filatabla = filatabla + presprod[i].pmax[hora];
                    s = this.conMDE.createStatement();
                    s.executeUpdate("INSERT INTO RES_PRODUCTORES (Cod_UP,Cumple_Ing_min,HORA,Tramo_casado,Energia_casada,grad_crec,grad_decrec,potencia,Energia_maxima,Potencia_maxima) VALUES (" + filatabla + ")");
                    s.close();
                }
            }
            System.out.println("Se guardo los resultados de productores exitosamente.");
            s = this.conMDE.createStatement();
            s.executeUpdate("DELETE * FROM RES_COMPRADORES");
            s.close();
            for (i = 0; i < prescomp.length; ++i) {
                for (hora = 1; hora < 25; ++hora) {
                    filatabla = "'" + prescomp[i].cod_UA + "'" + ", ";
                    filatabla = filatabla + hora + ", ";
                    filatabla = filatabla + prescomp[i].tramocas[hora] + ", ";
                    filatabla = filatabla + prescomp[i].energiacas[hora];
                    s = this.conMDE.createStatement();
                    s.executeUpdate("INSERT INTO RES_COMPRADORES (Cod_UA,HORA,Tramo_casado,Energia_casada) VALUES (" + filatabla + ")");
                    s.close();
                }
            }
            System.out.println("Se guardo los resultados de consumidores exitosamente.");
            s = this.conMDE.createStatement();
            s.executeUpdate("DELETE * FROM RES_MERCADO");
            s.close();
            for (hora = 1; hora < 25; ++hora) {
                filatabla = hora + ", ";
                filatabla = filatabla + presmercado[hora].precio + ", ";
                filatabla = filatabla + presmercado[hora].energia + ", ";
                filatabla = filatabla + ppmc[hora] + ", ";
                switch (ptipointers[hora]) {
                    case 0: {
                        filatabla = filatabla + "'cruce exacto'";
                        break;
                    }
                    case 1: {
                        filatabla = filatabla + "'exceso de demanda de compra'";
                        break;
                    }
                    case 2: {
                        filatabla = filatabla + "'exceso de oferta de venta'";
                        break;
                    }
                    default: {
                        filatabla = filatabla + "'no hay interseccion'";
                    }
                }
                s = this.conMDE.createStatement();
                s.executeUpdate("INSERT INTO RES_MERCADO (HORA,PRECIO_MARGINAL,ENERGIA_TRANSADA,PRECIO_MARGINAL_CONSUMIDOR,TIPO_INTERSECCION) VALUES (" + filatabla + ")");
                s.close();
            }
            this.conMDE.commit();
            System.out.println("Se guardo los resultados del mercado exitosamente.");
        }
        catch (Exception e) {
            System.out.println(e + "Error generado al gurdar resultados en base de datos");
        }
    }

    private void SimMDE_Error(String mensaje) throws Exception {
        mensaje = "Error: " + mensaje;
        throw new Exception(mensaje);
    }

    public void Calculate() {
        this.conMDE = DeepEdit.OpenODBC_JDBCConnection("MDE", true);
        if (!this.LeerDatos()) {
            System.out.println("Power exchange execution stopped. Validation errors detected...");
            return;
        }
        try {
            if (!this.obtenerSolucionValida()) {
                this.SimMDE_Error("No se encuentra una solucion");
            }
            this.MejorSolucion.addElement(this.productor);
            this.MejorSolucion.addElement(this.consumidor);
            this.MejorSolucion.addElement(this.transaccion);
            this.MejorSolucion.addElement(this.tipo_interseccion);
            this.MejorSolucion.addElement(this.pm_consumidor);
            this.guardarResultado();
        }
        catch (Exception e) {
            System.out.println(" Error en procedimiento:" + e);
            e.printStackTrace(System.out);
        }
    }

    public static String sendToServlet(String sURL, String logname, String pass, String bidaction, String bidtype, String biddata) throws MalformedURLException, IOException {
        String line;
        URL urlHost = new URL(sURL);
        String protocol = urlHost.getProtocol();
        String host = urlHost.getHost();
        int port = urlHost.getPort();
        String servletLocation = "/servlet/ReadDB";
        URL dataURL = new URL(protocol, host, port, servletLocation);
        URLConnection mylink = dataURL.openConnection();
        mylink.setUseCaches(false);
        mylink.setDoOutput(true);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
        PrintWriter out = new PrintWriter(byteStream, true);
        logname = URLEncoder.encode(logname, "UTF-8");
        pass = URLEncoder.encode(pass, "UTF-8");
        String datos = "UID=" + logname + "&pass=" + pass + "&protocolo=" + protocol + "&host=" + host + "&puerto=" + port + "&dbnombre=MDE&accion=" + bidaction + "&offerpoint=" + biddata + "&bidtype=" + bidtype;
        out.print(datos);
        out.flush();
        mylink.setRequestProperty("Content-Length", String.valueOf(byteStream.size()));
        mylink.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        byteStream.writeTo(mylink.getOutputStream());
        BufferedReader in = new BufferedReader(new InputStreamReader(mylink.getInputStream()));
        String sRet = "";
        int contline = 0;
        while ((line = in.readLine()) != null) {
            System.out.println(line);
            sRet = sRet + line;
            ++contline;
        }
        return sRet;
    }

    void escribir_archivo() throws Exception {
        int hora;
        int j;
        String auxstring;
        SimMDE_taboferta pauxtabla;
        int i;
        String nomarch = "baseinfo.dat";
        FileOutputStream os = new FileOutputStream(nomarch);
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("numprod " + this.AgentesVenta.size());
        for (i = 0; i < this.AgentesVenta.size(); ++i) {
            pauxtabla = (SimMDE_taboferta)this.AgentesVenta.elementAt(i);
            myPrintStream.println("cod_UP " + pauxtabla.cod_UP);
            myPrintStream.println("ing_min_TF " + pauxtabla.ing_min_TF);
            myPrintStream.println("ing_min_TV " + pauxtabla.ing_min_TV);
            myPrintStream.println("grad_subida " + pauxtabla.grad_subida);
            myPrintStream.println("grad_bajada " + pauxtabla.grad_bajada);
            myPrintStream.println("grad_parada " + pauxtabla.grad_parada);
            myPrintStream.println("grad_arranque " + pauxtabla.grad_arranque);
            myPrintStream.println("pmax " + pauxtabla.pmax);
            myPrintStream.println("con_var_carga " + pauxtabla.con_var_carga);
            auxstring = "";
            for (j = 0; j < 25; ++j) {
                auxstring = auxstring + " " + pauxtabla.pt_indivisible[j];
            }
            myPrintStream.println("pt_indivisible " + auxstring);
            auxstring = "";
            for (j = 0; j < 4; ++j) {
                auxstring = auxstring + " " + pauxtabla.parada_programada[j];
            }
            myPrintStream.println("parada_programada " + auxstring);
            auxstring = "";
            for (j = 0; j < 25; ++j) {
                auxstring = auxstring + " " + pauxtabla.numtramos[j];
            }
            myPrintStream.println("numtramos " + auxstring);
            for (hora = 1; hora < 25; ++hora) {
                auxstring = "";
                for (j = 0; j < 26; ++j) {
                    auxstring = auxstring + " " + pauxtabla.ofhora[hora][j].precio;
                }
                myPrintStream.println("ofhora" + hora + "P " + auxstring);
                auxstring = "";
                for (j = 0; j < 26; ++j) {
                    auxstring = auxstring + " " + pauxtabla.ofhora[hora][j].energia;
                }
                myPrintStream.println("ofhora" + hora + "E " + auxstring);
            }
        }
        myPrintStream.println("numcomp " + this.AgentesCompra.size());
        for (i = 0; i < this.AgentesVenta.size(); ++i) {
            pauxtabla = (SimMDE_taboferta)this.AgentesCompra.elementAt(i);
            myPrintStream.println("cod_UA " + pauxtabla.cod_UA);
            auxstring = "";
            for (j = 0; j < 25; ++j) {
                auxstring = auxstring + " " + pauxtabla.numtramos[j];
            }
            myPrintStream.println("numtramos " + auxstring);
            for (hora = 1; hora < 25; ++hora) {
                auxstring = "";
                for (j = 0; j < 26; ++j) {
                    auxstring = auxstring + " " + pauxtabla.ofhora[hora][j].precio;
                }
                myPrintStream.println("ofhora" + hora + "P " + auxstring);
                auxstring = "";
                for (j = 0; j < 26; ++j) {
                    auxstring = auxstring + " " + pauxtabla.ofhora[hora][j].energia;
                }
                myPrintStream.println("ofhora" + hora + "E " + auxstring);
            }
        }
    }

    void leer_archivo() throws Exception {
        int hora;
        int j;
        SimMDE_taboferta pauxtabla;
        int i;
        Object D = null;
        Object B = null;
        Object Int = null;
        String nomarch = "baseinfo.dat";
        DataInputStream farch = new DataInputStream(new FileInputStream(nomarch));
        StringTokenizer st = new StringTokenizer(farch.readLine(), " ");
        String auxstring = st.nextToken();
        int numag = Integer.valueOf(st.nextToken());
        this.AgentesVenta = new Vector();
        for (i = 0; i < numag; ++i) {
            pauxtabla = new SimMDE_taboferta();
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            while (st.hasMoreTokens()) {
                pauxtabla.cod_UP = pauxtabla.cod_UP + " " + st.nextToken();
            }
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.ing_min_TF = Double.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.ing_min_TV = Double.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.grad_subida = Double.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.grad_bajada = Double.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.grad_parada = Double.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.grad_arranque = Double.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.pmax = Double.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            pauxtabla.con_var_carga = Boolean.valueOf(st.nextToken());
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            for (j = 0; j < 25; ++j) {
                pauxtabla.pt_indivisible[j] = Boolean.valueOf(st.nextToken());
            }
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            for (j = 0; j < 4; ++j) {
                pauxtabla.parada_programada[j] = Boolean.valueOf(st.nextToken());
            }
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            for (j = 0; j < 25; ++j) {
                pauxtabla.numtramos[j] = Integer.valueOf(st.nextToken());
            }
            for (hora = 1; hora < 25; ++hora) {
                st = new StringTokenizer(farch.readLine(), " ");
                auxstring = st.nextToken();
                for (j = 0; j < 26; ++j) {
                    pauxtabla.ofhora[hora][j].precio = Double.valueOf(st.nextToken());
                }
                st = new StringTokenizer(farch.readLine(), " ");
                auxstring = st.nextToken();
                for (j = 0; j < 26; ++j) {
                    pauxtabla.ofhora[hora][j].energia = Double.valueOf(st.nextToken());
                }
            }
            this.AgentesVenta.addElement(pauxtabla);
        }
        st = new StringTokenizer(farch.readLine(), " ");
        auxstring = st.nextToken();
        numag = Integer.valueOf(st.nextToken());
        this.AgentesCompra = new Vector();
        for (i = 0; i < numag; ++i) {
            pauxtabla = new SimMDE_taboferta();
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            while (st.hasMoreTokens()) {
                pauxtabla.cod_UP = pauxtabla.cod_UP + " " + st.nextToken();
            }
            st = new StringTokenizer(farch.readLine(), " ");
            auxstring = st.nextToken();
            for (j = 0; j < 25; ++j) {
                pauxtabla.numtramos[j] = Integer.valueOf(st.nextToken());
            }
            for (hora = 1; hora < 25; ++hora) {
                st = new StringTokenizer(farch.readLine(), " ");
                auxstring = st.nextToken();
                for (j = 0; j < 26; ++j) {
                    pauxtabla.ofhora[hora][j].precio = Double.valueOf(st.nextToken());
                }
                st = new StringTokenizer(farch.readLine(), " ");
                auxstring = st.nextToken();
                for (j = 0; j < 26; ++j) {
                    pauxtabla.ofhora[hora][j].energia = Double.valueOf(st.nextToken());
                }
            }
            this.AgentesCompra.addElement(pauxtabla);
        }
        System.out.println("Terminada la lectura de archivos");
    }

    public boolean sendEmail(String[] emails, String empresa, String host, String emailuserid, String emailpassword) {
        if (emails == null) {
            this.appendText("WARNING: No email adresses registered for company: " + empresa);
            return false;
        }
        File outFile = this.getResultsFile(empresa);
        if (outFile == null) {
            this.appendText("WARNING: No attachment registered for company: " + empresa);
            this.appendText("No email was sent to " + empresa + ". Re-run simulation with 'Split Results' option selected");
            return false;
        }
        File[] attachment = new File[]{outFile};
        String subject = "Simulation results for " + empresa + " (" + this.getCurrentSimDateString() + ")";
        try {
            Utils.sendSMTPEmail(host, emailuserid, emailpassword, emails, subject, "", attachment);
            return true;
        }
        catch (MessagingException e) {
            System.out.println("SMTP connection error sending email to " + empresa + ". Details: " + e.getMessage());
        }
        catch (NullPointerException e) {
            System.out.println("Unexpected error sending email to " + empresa + ". Details: " + e.getMessage());
        }
        return false;
    }

    public void sendAllEmails(String host, String emailuserid, String emailpassword) {
        String[] emails;
        String empresa;
        if (!this.isDoFileExecuted()) {
            this.appendText("CSV files are not available. Execute again with 'Split Results' option selected");
            return;
        }
        if (this.AgentesVenta != null) {
            for (Object o : this.AgentesVenta) {
                SimMDE_taboferta oVenta = (SimMDE_taboferta)o;
                if (!oVenta.participa) continue;
                empresa = oVenta.getName();
                emails = oVenta.getEmailAdresses();
                if (!this.sendEmail(emails, empresa, host, emailuserid, emailpassword)) continue;
                this.appendText("Emails to " + empresa + ":");
                for (String to : emails) {
                    this.appendText(" -" + to);
                }
                this.appendText("Were sent successfully");
            }
        }
        if (this.AgentesCompra != null) {
            for (Object o : this.AgentesCompra) {
                SimMDE_taboferta oCompra = (SimMDE_taboferta)o;
                if (!oCompra.participa) continue;
                empresa = oCompra.getName();
                emails = oCompra.getEmailAdresses();
                if (!this.sendEmail(emails, empresa, host, emailuserid, emailpassword)) continue;
                this.appendText("Emails to " + empresa + ":");
                for (String to : emails) {
                    this.appendText(" -" + to);
                }
                this.appendText("Were sent successfully");
            }
        }
    }

    public void iniProgressFrame() {
    }

    public void appendText(String NewTextLine) {
        assert (this.MySimMDEFrame != null) : "Why are you calling this method if SimMDEFrame is not initialized!!";
        if (this.MySimMDEFrame != null) {
            this.MySimMDEFrame.appendText(NewTextLine);
        }
    }

    public double getClearPrice() {
        SimMDE_ptocva[] auxCOV = this.getCOV(1);
        SimMDE_ptocva[] auxCOV2 = new SimMDE_ptocva[auxCOV.length + 1];
        for (int i = 0; i < auxCOV.length; ++i) {
            auxCOV2[i] = auxCOV[i];
        }
        auxCOV2[auxCOV.length] = new SimMDE_ptocva();
        auxCOV2[auxCOV.length].precio = 1.0E7;
        auxCOV2[auxCOV.length].energia += 0.001;
        double[] aux = this.getEqMerc(auxCOV2, this.getCOA(1));
        this.lastEquil = aux;
        this.lastPM = aux[0];
        this.lastPMC = aux[3];
        this.lastQD = aux[1];
        this.lastTypInt = aux[2];
        if (aux[2] == 1.0) {
            System.out.println("Demand not staisfied!!");
        }
        return aux[0];
    }

    public String getCurrentSimDateString() {
        GregorianCalendar currentDate = new GregorianCalendar();
        String date = currentDate.get(5) + "." + (currentDate.get(2) + 1) + "." + currentDate.get(1);
        return date;
    }

    public File getResultsFile(String empresa) {
        if (this.createdFiles != null) {
            return this.createdFiles.get(empresa);
        }
        assert (false) : "You can only use this function after calling SimMDEFrame.doSplitResInFiles()";
        return null;
    }

    public void doSplitResInFiles() throws FileNotFoundException, IOException {
        int hora;
        PrintWriter myWriter;
        FileOutputStream actFOS;
        File outFile;
        SimMDE_tabresultado tempRes;
        int ix;
        String date = this.getCurrentSimDateString();
        SimMDE_ptocva[] presmercado = (SimMDE_ptocva[])this.MejorSolucion.elementAt(2);
        String strOutputFolder = SIMDE_RESULT_FOLDER;
        this.createdFiles = new HashMap<String, File>();
        if (!AnalysisTool.DirectoryExist(strOutputFolder)) {
            AnalysisTool.CreateDirectory(strOutputFolder);
        }
        for (ix = 0; ix < this.productor.length; ++ix) {
            tempRes = this.productor[ix];
            outFile = new File(strOutputFolder + File.separator + fileNamePat + tempRes.cod_UP + date + ".csv ");
            actFOS = new FileOutputStream(outFile);
            myWriter = new PrintWriter(actFOS);
            myWriter.println("Cod_UP, HORA, Tramo_casado, Energia_casada [MWh], Ventas_Netas [MUS$]");
            for (hora = 1; hora < tempRes.energiacas.length; ++hora) {
                double netSale = tempRes.energiacas[hora] * presmercado[hora].precio / 1000.0;
                myWriter.println(tempRes.cod_UP + ", " + hora + ", " + tempRes.tramocas[hora] + ", " + tempRes.energiacas[hora] + ", " + netSale);
            }
            myWriter.flush();
            actFOS.close();
            this.createdFiles.put(tempRes.cod_UP, outFile);
        }
        for (ix = 0; ix < this.consumidor.length; ++ix) {
            tempRes = this.consumidor[ix];
            outFile = new File(strOutputFolder + File.separator + fileNamePat + tempRes.cod_UA + date + ".csv ");
            actFOS = new FileOutputStream(outFile);
            myWriter = new PrintWriter(actFOS);
            myWriter.println("Cod_UA, HORA, Tramo_casado, Energia_casada [MWh], Compras_Netas [MUS$]");
            for (hora = 1; hora < tempRes.energiacas.length; ++hora) {
                double netPurchase = tempRes.energiacas[hora] * presmercado[hora].precio / 1000.0;
                myWriter.println(tempRes.cod_UA + ", " + hora + ", " + tempRes.tramocas[hora] + ", " + tempRes.energiacas[hora] + ", " + netPurchase);
            }
            myWriter.flush();
            actFOS.close();
            this.createdFiles.put(tempRes.cod_UA, outFile);
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public void setPassFrom(String passFrom) {
        this.passFrom = passFrom;
    }

    public void setCreateCharts(boolean createCharts) {
        this.createCharts = createCharts;
    }

    private boolean isDoFileExecuted() {
        return this.MySimMDEFrame != null && this.createdFiles != null && !this.createdFiles.isEmpty();
    }

    public void setEmailParameters(String host, String email, String pass) {
        this.host = host;
        this.emailFrom = email;
        this.passFrom = pass;
    }

    public void assignDispatch() {
        this.asignarProdyDem(this.lastPM, this.lastQD, this.lastTypInt, this.lastPMC, 1);
    }

    public void disposeChartFrames() {
        for (int ix = 0; ix < this.chartFrames.size(); ++ix) {
            ((Frame)this.chartFrames.elementAt(ix)).dispose();
        }
    }

    public void finalizeMDEConnection() throws SQLException {
        if (this.conMDE == null) {
            return;
        }
        if (this.conMDE.isClosed()) {
            this.conMDE = null;
            return;
        }
        this.conMDE.commit();
        this.conMDE.close();
        this.conMDE = null;
    }

    @Override
    public void run() {
        this.sendAllEmails(this.host, this.emailFrom, this.passFrom);
    }
}

