/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DeepEdit;
import de.core.Line;
import de.core.Load;
import de.core.SQPGL;
import de.core.Schematic;
import de.core.SensiFrameJAVA;
import de.core.SensitivitiesJAVAFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import de.data.DE_GeneralEnums;
import de.utils.StringUtil;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class SensitivitiesJAVA
extends AnalysisTool {
    SensitivitiesJAVAFrame MySensitivitiesJAVAFrame = null;
    SensiFrameJAVA MySensiFrameJAVA = null;
    ColorSpec MyColorSpec = null;
    String ctrla = null;
    protected Vector BusbarVector;
    double[] gen;
    double[] load;
    int[] GenNode;
    int[] LasNode;
    int numnod = 0;
    int numgen = 0;
    int numlast = 0;
    int numlin = 0;
    int numtrafo = 0;
    int numbran = 0;
    double[] node_p;
    double[] node_pl;
    double[] node_plaux;
    double[] node_pg;
    double[] Flow;
    double[] FlowsFactL;
    double[] FlowsFactG;
    double[] BranchR;
    double[] BranchX;
    double[] AVNR_COyM;
    int[] BranchI;
    int[] BranchJ;
    double numero;
    String[] NomBra;
    String[] NomLin;
    String[] NomTra;
    String[] NomGen;
    String[] NomNod;
    String[] CtrlANod;
    String[] NomLas;
    DoubleMatrix GSDF;
    DoubleMatrix GSDFS;
    DoubleMatrix GGDF;
    DoubleMatrix GLDF;
    public double[][][] Prorrateo;
    DoubleSquareMatrix MatX;
    DoubleSquareMatrix MatY;
    PrintStream myPPrintStream;
    FileOutputStream os;
    int slack = -1;
    double[][] ProrrataG;
    double[][] ProrrataL;
    String[] NomOwnerG;
    String[] NomOwnerL;
    int numownerG;
    int numownerL;
    String[] LosOwnerG;
    String[] LosOwnerL;
    double[][] PGenOwn;
    double[][] PConLoad;
    double pgaux = 0.0;
    double plaux = 0.0;

    public SensitivitiesJAVA(Schematic sch) {
        super(sch);
        System.out.println("---------- In JAVA Sensitivities ------------");
        if (this.MySensitivitiesJAVAFrame == null) {
            this.MySensitivitiesJAVAFrame = new SensitivitiesJAVAFrame(this);
        } else {
            this.MySensitivitiesJAVAFrame.setVisible(true);
        }
    }

    public SensitivitiesJAVA(Schematic sch, String CTRLA, boolean sino, int modelo, boolean rep, boolean top) {
        super(sch);
        System.out.println("---------- In JAVA Sensitivities ------------ 1");
        this.Calculate(CTRLA, sino, 1, false, false);
    }

    public SensitivitiesJAVA(Schematic sch, int solver) {
        super(sch);
        System.out.println("---------- In JAVA Sensitivities ------------ 2");
        if (solver == 1) {
            SQPGL MySQPGL = new SQPGL(sch, 1);
        } else {
            SQPGL sQPGL = new SQPGL(sch, 2);
        }
        this.Calculate("ALL CONTROL AREAS", true, 1, false, false);
        this.reporteGA();
    }

    public void Calculate(String cctrla, boolean sino, int modelo, boolean rep, boolean top) {
        String SensiJAVAdat = "./results/SensiJAVA.dat";
        try {
            int i;
            this.os = new FileOutputStream(SensiJAVAdat);
            this.myPPrintStream = new PrintStream(this.os);
            System.out.println("Making InitNetwork");
            this.InitNetwork(rep);
            System.out.println("InitNetwork     Done");
            System.out.println("Making build_Injection");
            this.build_Injection();
            System.out.println("build_Injection Done");
            System.out.println("Making build_GDF");
            this.build_GDF();
            System.out.println("build_GDF       Done");
            System.out.println("Making build_Flows");
            this.build_Flows();
            System.out.println("build_Flows     Done");
            System.out.println("Making build_Participa");
            this.build_Participa(rep);
            System.out.println("build_Participa Done");
            if (rep) {
                int j;
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("*********************************");
                this.myPPrintStream.println("IMPRESI\u00d3N DE MATRICES DE FACTORES");
                this.myPPrintStream.println("*********************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("ADMITTANCE MATRIX Y");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numnod; ++i) {
                    for (j = 0; j < this.numnod - 1; ++j) {
                        this.myPPrintStream.print("" + SensitivitiesJAVA.numformat(this.MatY.getElement(i, j), 10, 5) + "  ");
                    }
                    this.myPPrintStream.println("" + SensitivitiesJAVA.numformat(this.MatY.getElement(i, this.numnod - 1), 10, 5));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("REACTANCE MATRIX X");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numnod; ++i) {
                    for (j = 0; j < this.numnod - 1; ++j) {
                        this.myPPrintStream.print("" + SensitivitiesJAVA.numformat(this.MatX.getElement(i, j), 10, 5) + "  ");
                    }
                    this.myPPrintStream.println("" + SensitivitiesJAVA.numformat(this.MatX.getElement(i, this.numnod - 1), 10, 5));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("GGDF MATRIX");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numbran; ++i) {
                    for (j = 0; j < this.numnod - 1; ++j) {
                        this.myPPrintStream.print("" + SensitivitiesJAVA.numformat(this.GGDF.getElement(i, j), 10, 5) + "  ");
                    }
                    this.myPPrintStream.println("" + SensitivitiesJAVA.numformat(this.GGDF.getElement(i, this.numnod - 1), 10, 5));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("GLDF MATRIX");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numbran; ++i) {
                    for (j = 0; j < this.numnod - 1; ++j) {
                        this.myPPrintStream.print("" + SensitivitiesJAVA.numformat(this.GLDF.getElement(i, j), 10, 3) + "  ");
                    }
                    this.myPPrintStream.println("" + SensitivitiesJAVA.numformat(this.GLDF.getElement(i, this.numnod - 1), 10, 3));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("GSDF MATRIX");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numbran; ++i) {
                    for (j = 0; j < this.numnod - 1; ++j) {
                        this.myPPrintStream.print("" + SensitivitiesJAVA.numformat(this.GSDF.getElement(i, j), 10, 3) + "  ");
                    }
                    this.myPPrintStream.println("" + SensitivitiesJAVA.numformat(this.GSDF.getElement(i, this.numnod - 1), 10, 3));
                }
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("GSDFS MATRIX (with selected slack bus)");
                this.myPPrintStream.println(" ");
                for (i = 0; i < this.numbran; ++i) {
                    for (j = 0; j < this.numnod - 1; ++j) {
                        this.myPPrintStream.print("" + SensitivitiesJAVA.numformat(this.GSDFS.getElement(i, j), 10, 3) + "  ");
                    }
                    this.myPPrintStream.println("" + SensitivitiesJAVA.numformat(this.GSDFS.getElement(i, this.numnod - 1), 10, 3));
                }
            }
            if (rep) {
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("***********************************");
                this.myPPrintStream.println("Flujos Calculados v/s Flujos Le\u00eddos");
                this.myPPrintStream.println("***********************************");
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("        Nro Rama    -   Flujo GLDF   -    Flujo GGDF   -   Flujo Schematic");
                for (i = 0; i < this.numbran; ++i) {
                    this.myPPrintStream.println("" + SensitivitiesJAVA.numformat(i, 4) + "* " + SensitivitiesJAVA.strformat(this.NomBra[i], 20) + "* " + SensitivitiesJAVA.numformat(this.FlowsFactL[i], 10, 3) + "* " + SensitivitiesJAVA.numformat(this.FlowsFactG[i], 10, 3) + "* " + SensitivitiesJAVA.numformat(this.Flow[i], 10, 3));
                }
            }
            this.closefile();
        }
        catch (Exception e) {
            this.closefile();
            System.out.println("Error executing sensitivity calculation: " + e);
            e.printStackTrace(System.out);
        }
        if (rep) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad ./results/SensiJAVA.dat");
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
            }
        }
        if (rep) {
            if (this.MySensiFrameJAVA == null) {
                this.MySensiFrameJAVA = new SensiFrameJAVA(this, this.ctrla);
            } else {
                this.MySensiFrameJAVA.setVisible(true);
                if (top) {
                    this.MySensiFrameJAVA.toFront();
                }
            }
            if (this.MyColorSpec == null) {
                this.MyColorSpec = new ColorSpec("Sensitivities Color Definition");
            } else {
                this.MyColorSpec.setVisible(true);
                if (top) {
                    this.MyColorSpec.toFront();
                }
            }
        }
    }

    public void InitNetwork(boolean rep) {
        int ixi;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        this.slack = -100;
        int ix = 0;
        int i = 0;
        int j = 0;
        boolean countB = false;
        int count = 0;
        int count1 = 0;
        int countlas = 0;
        int countgen = 0;
        int countslack = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        if (DeepEdit.getEditor() != DE_GeneralEnums.editor.Power) {
            this.ActDeepEdit.setEditor(DE_GeneralEnums.editor.Power);
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numlin;
                } else if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtrafo;
                } else {
                    TempComponent.InformAllComponents();
                }
                ++this.numbran;
            }
            if (TempComponent instanceof ndb_inj) {
                TempComponent.InformAllComponents();
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numlast;
        }
        this.AVNR_COyM = new double[this.numbran];
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.node_p = new double[this.numnod];
        this.node_pl = new double[this.numnod];
        this.node_plaux = new double[this.numnod];
        this.node_pg = new double[this.numnod];
        this.Flow = new double[this.numbran];
        this.GenNode = new int[this.numgen];
        this.LasNode = new int[this.numlast];
        this.MatX = new DoubleSquareMatrix(this.numnod);
        this.MatY = new DoubleSquareMatrix(this.numnod);
        this.NomBra = new String[this.numbran];
        this.NomLin = new String[this.numlin];
        this.NomTra = new String[this.numtrafo];
        this.NomGen = new String[this.numgen];
        this.NomLas = new String[this.numlast];
        this.NomNod = new String[this.numnod];
        this.CtrlANod = new String[this.numnod];
        this.LosOwnerG = new String[this.numgen];
        this.LosOwnerL = new String[this.numlast];
        for (ixi = 0; ixi < this.numnod; ++ixi) {
            this.node_p[ixi] = 0.0;
            this.node_pl[ixi] = 0.0;
            this.node_plaux[ixi] = 0.0;
            this.node_pg[ixi] = 0.0;
            this.MatX.setElement(i, j, 0.0);
            this.MatY.setElement(i, j, 0.0);
        }
        for (ixi = 0; ixi < this.numbran; ++ixi) {
            this.Flow[ixi] = 0.0;
        }
        int countBra = 0;
        int countLin = 0;
        int countTra = 0;
        int countGen = 0;
        int countNod = 0;
        int countLas = 0;
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numnod - 1);
        this.GSDF = new DoubleMatrix(this.numbran, this.numnod);
        this.GSDFS = new DoubleMatrix(this.numbran, this.numnod);
        this.GGDF = new DoubleMatrix(this.numbran, this.numnod);
        this.GLDF = new DoubleMatrix(this.numbran, this.numnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                this.AVNR_COyM[countBra] = TempLine.getannuity(this.ActSchematic.intrate);
                this.NomLin[countLin] = TempLine.getName();
                this.NomBra[countBra] = TempLine.getName();
                yy = 1.0 / this.BranchX[count];
                this.MatY.setElement(this.BranchJ[count], this.BranchI[count], this.MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                this.MatY.setElement(this.BranchI[count], this.BranchJ[count], this.MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                this.MatY.setElement(this.BranchI[count], this.BranchI[count], this.MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                this.MatY.setElement(this.BranchJ[count], this.BranchJ[count], this.MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.Flow[count] = (TempLine.getp12() - (TempLine.getp12() + TempLine.getp21()) / 2.0) * this.getSref();
                ++count;
                ++countLin;
                ++countBra;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.getSref() / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / TempTrafo.getsn();
                this.BranchX[count] = reac = Math.sqrt(z * z - res * res);
                this.BranchR[count] = res;
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                this.AVNR_COyM[countBra] = TempTrafo.getannuity(this.ActSchematic.intrate);
                this.NomTra[countTra] = TempTrafo.getName();
                this.NomBra[countBra] = TempTrafo.getName();
                yy = 1.0 / this.BranchX[count];
                this.MatY.setElement(this.BranchJ[count], this.BranchI[count], this.MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                this.MatY.setElement(this.BranchI[count], this.BranchJ[count], this.MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                this.MatY.setElement(this.BranchI[count], this.BranchI[count], this.MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                this.MatY.setElement(this.BranchJ[count], this.BranchJ[count], this.MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.Flow[count] = (TempTrafo.getp12() - (TempTrafo.getp12() + TempTrafo.getp21()) / 2.0) * this.getSref();
                ++count;
                ++countTra;
                ++countBra;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                this.GenNode[countgen] = this.numbus(TempInj.getcon2());
                this.NomGen[countGen] = TempInj.getName();
                if (TempInj.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    this.slack = this.numbus(TempInj.getcon2());
                    System.out.println("slack name   = " + TempComponent.getName());
                }
                this.LosOwnerG[countGen] = TempInj.getinv_owner();
                ++count1;
                ++countgen;
                ++countGen;
            }
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                this.LasNode[countlas] = this.numbus(TempLoad.getcon2());
                this.NomLas[countLas] = TempLoad.getName();
                this.LosOwnerL[countLas] = TempLoad.getinv_owner();
                ++countlas;
                ++countLas;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.NomNod[countNod] = TempBusbar.getName();
            this.CtrlANod[countNod] = TempBusbar.getctrla();
            ++countNod;
        }
        if (countslack == 0) {
            System.out.println(" Caution: Slack was not found, please define one ");
        }
        for (int ii = 0; ii < this.numnod - 1; ++ii) {
            for (int jj = 0; jj < this.numnod - 1; ++jj) {
                MatXX.setElement(ii, jj, this.MatY.getElement(ii, jj));
            }
        }
        this.numownerG = 0;
        this.numownerL = 0;
        int auxact = 0;
        if (this.numgen >= 2) {
            for (i = 0; i < this.numgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numgen; ++j) {
                    if (!this.LosOwnerG[i].equals(this.LosOwnerG[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numownerG;
            }
        } else {
            this.numownerG = this.numgen;
        }
        this.NomOwnerG = new String[this.numownerG];
        auxact = 0;
        int mulina = 0;
        if (this.numgen >= 2) {
            for (i = 0; i < this.numgen; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numgen; ++j) {
                    if (!this.LosOwnerG[i].equals(this.LosOwnerG[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomOwnerG[mulina] = this.LosOwnerG[i];
                ++mulina;
            }
        } else {
            this.NomOwnerG[0] = this.LosOwnerG[0];
        }
        if (this.numlast >= 2) {
            for (i = 0; i < this.numlast; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numlast; ++j) {
                    if (!this.LosOwnerL[i].equals(this.LosOwnerL[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                ++this.numownerL;
            }
        } else {
            this.numownerL = this.numlast;
        }
        this.NomOwnerL = new String[this.numownerL];
        auxact = 0;
        mulina = 0;
        if (this.numlast >= 2) {
            for (i = 0; i < this.numlast; ++i) {
                auxact = 0;
                for (j = i + 1; j < this.numlast; ++j) {
                    if (!this.LosOwnerL[i].equals(this.LosOwnerL[j])) continue;
                    ++auxact;
                }
                if (auxact != 0) continue;
                this.NomOwnerL[mulina] = this.LosOwnerL[i];
                ++mulina;
            }
        } else {
            this.NomOwnerL[0] = this.LosOwnerL[0];
        }
        this.PGenOwn = new double[this.numownerG][this.numnod];
        this.PConLoad = new double[this.numownerL][this.numnod];
        System.out.println("Inverting MatXX Matrix");
        long timeMills = System.currentTimeMillis();
        MatXX = (DoubleSquareMatrix)MatXX.inverse();
        System.out.println("MatXX Matrix Inverted. Time: " + (System.currentTimeMillis() - timeMills) + " [ms]");
        for (i = 0; i < this.numnod - 1; ++i) {
            for (j = 0; j < this.numnod - 1; ++j) {
                this.MatX.setElement(i, j, MatXX.getElement(i, j));
            }
        }
        int countD = 0;
        boolean count1D = false;
        for (int iix = 0; iix < this.ActSchematic.Components.size(); ++iix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(iix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            reac = this.BranchX[countD];
            for (i = 0; i < this.numnod - 1; ++i) {
                y1 = this.MatX.getElement(this.BranchI[countD], i);
                y2 = this.MatX.getElement(this.BranchJ[countD], i);
                this.GSDF.setElement(countD, i, (y1 - y2) / reac);
            }
            ++countD;
        }
        if (this.slack == -100) {
            System.out.println("No se ha definido slack");
        } else {
            for (i = 0; i < this.numbran; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    this.GSDFS.setElement(i, j, this.GSDF.getElement(i, j) - this.GSDF.getElement(i, this.slack));
                }
            }
        }
    }

    public void build_Injection() {
        int i = 0;
        boolean j = false;
        int k = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        int count2 = 0;
        for (i = 0; i < this.numnod; ++i) {
            this.node_p[i] = 0.0;
            this.node_pl[i] = 0.0;
            this.node_plaux[i] = 0.0;
            this.node_pg[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                int n = this.LasNode[count1];
                this.node_pl[n] = this.node_pl[n] + TempLoad.getp0();
                int n2 = this.LasNode[count1];
                this.node_plaux[n2] = this.node_plaux[n2] + TempLoad.getp0();
                int n3 = this.LasNode[count1];
                this.node_p[n3] = this.node_p[n3] - TempLoad.getp0();
                for (k = 0; k < this.numownerL; ++k) {
                    if (!this.NomOwnerL[k].equals(TempLoad.getinv_owner())) continue;
                    double[] dArray = this.PConLoad[k];
                    int n4 = this.LasNode[count1];
                    dArray[n4] = dArray[n4] + TempLoad.getp0();
                }
                ++count1;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                int n = this.GenNode[count2];
                this.node_pg[n] = this.node_pg[n] + TempInj.getp();
                int n5 = this.GenNode[count2];
                this.node_p[n5] = this.node_p[n5] + TempInj.getp();
                for (k = 0; k < this.numownerG; ++k) {
                    if (!this.NomOwnerG[k].equals(TempInj.getinv_owner())) continue;
                    double[] dArray = this.PGenOwn[k];
                    int n6 = this.GenNode[count2];
                    dArray[n6] = dArray[n6] + TempInj.getp();
                }
                ++count2;
            }
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                int n = this.BranchI[count];
                this.node_p[n] = this.node_p[n] - (TempLine.getp12() + TempLine.getp21()) / 2.0 * this.getSref();
                int n7 = this.BranchJ[count];
                this.node_p[n7] = this.node_p[n7] - (TempLine.getp12() + TempLine.getp21()) / 2.0 * this.getSref();
                int n8 = this.BranchI[count];
                this.node_pl[n8] = this.node_pl[n8] + (TempLine.getp12() + TempLine.getp21()) / 2.0 * this.getSref();
                int n9 = this.BranchJ[count];
                this.node_pl[n9] = this.node_pl[n9] + (TempLine.getp12() + TempLine.getp21()) / 2.0 * this.getSref();
                ++count;
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            int n = this.BranchI[count];
            this.node_p[n] = this.node_p[n] - (TempTrafo.getp12() + TempTrafo.getp21()) / 2.0 * this.getSref();
            int n10 = this.BranchJ[count];
            this.node_p[n10] = this.node_p[n10] - (TempTrafo.getp12() + TempTrafo.getp21()) / 2.0 * this.getSref();
            int n11 = this.BranchI[count];
            this.node_pl[n11] = this.node_pl[n11] + (TempTrafo.getp12() + TempTrafo.getp21()) / 2.0 * this.getSref();
            int n12 = this.BranchJ[count];
            this.node_pl[n12] = this.node_pl[n12] + (TempTrafo.getp12() + TempTrafo.getp21()) / 2.0 * this.getSref();
            ++count;
        }
    }

    public void build_GDF() {
        int i = 0;
        int j = 0;
        double PLges = 0.0;
        double PGges = 0.0;
        double[] vec_DrefG = new double[this.numbran];
        double[] vec_DrefL = new double[this.numbran];
        for (i = 0; i < this.numbran; ++i) {
            vec_DrefG[i] = 0.0;
            vec_DrefL[i] = 0.0;
        }
        for (i = 0; i < this.numnod; ++i) {
            PGges += this.node_pg[i];
            PLges += this.node_pl[i];
        }
        i = 0;
        while (i < this.numbran) {
            vec_DrefG[i] = this.Flow[i];
            vec_DrefL[i] = this.Flow[i];
            for (j = 0; j < this.numnod; ++j) {
                int n = i;
                vec_DrefG[n] = vec_DrefG[n] - this.GSDFS.getElement(i, j) * this.node_pg[j];
                int n2 = i;
                vec_DrefL[n2] = vec_DrefL[n2] + this.GSDFS.getElement(i, j) * this.node_pl[j];
            }
            int n = i;
            vec_DrefG[n] = vec_DrefG[n] / PGges;
            int n3 = i++;
            vec_DrefL[n3] = vec_DrefL[n3] / PLges;
        }
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.GGDF.setElement(i, j, 0.0);
                this.GLDF.setElement(i, j, 0.0);
            }
        }
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.GGDF.setElement(i, j, this.GSDFS.getElement(i, j) + vec_DrefG[i]);
                this.GLDF.setElement(i, j, -this.GSDFS.getElement(i, j) + vec_DrefL[i]);
            }
        }
    }

    public void build_Flows() {
        int i = 0;
        int j = 0;
        this.FlowsFactL = new double[this.numbran];
        this.FlowsFactG = new double[this.numbran];
        for (i = 0; i < this.numbran; ++i) {
            this.FlowsFactL[i] = 0.0;
            this.FlowsFactG[i] = 0.0;
            for (j = 0; j < this.numnod; ++j) {
                int n = i;
                this.FlowsFactG[n] = this.FlowsFactG[n] + this.GGDF.getElement(i, j) * this.node_pg[j];
                int n2 = i;
                this.FlowsFactL[n2] = this.FlowsFactL[n2] + this.GLDF.getElement(i, j) * this.node_pl[j];
            }
        }
    }

    public void build_Participa(boolean rep) {
        int i = 0;
        int j = 0;
        double[][] AGEN = new double[this.numbran][this.numnod];
        double[][] ACON = new double[this.numbran][this.numnod];
        double[][] A = new double[this.numbran][this.numnod];
        double[][] GGDFGEN = new double[this.numbran][this.numnod];
        double[][] GCDFCON = new double[this.numbran][this.numnod];
        double[] PFA = new double[this.numbran];
        double[] PFAC = new double[this.numbran];
        double[] PFAF = new double[this.numbran];
        double[] PFAD = new double[this.numbran];
        double[] PFGDFF = new double[this.numbran];
        double[] PFGDFD = new double[this.numbran];
        for (i = 0; i < this.numbran; ++i) {
            PFA[i] = 0.0;
            PFAC[i] = 0.0;
            PFAF[i] = 0.0;
            PFAD[i] = 0.0;
            PFGDFF[i] = 0.0;
            PFGDFD[i] = 0.0;
            for (j = 0; j < this.numnod; ++j) {
                A[i][j] = 0.0;
                AGEN[i][j] = 0.0;
                ACON[i][j] = 0.0;
                GGDFGEN[i][j] = 0.0;
                GCDFCON[i][j] = 0.0;
            }
        }
        this.Prorrateo = new double[this.numbran][this.numnod][8];
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                AGEN[i][j] = this.node_pg[j] > 0.0 && this.GSDFS.getElement(i, j) * this.Flow[i] > 0.0 ? this.GSDFS.getElement(i, j) : 0.0;
                ACON[i][j] = this.node_pl[j] > 0.0 && this.GSDFS.getElement(i, j) * this.Flow[i] < 0.0 ? this.GSDFS.getElement(i, j) : 0.0;
                A[i][j] = this.GSDFS.getElement(i, j);
                GGDFGEN[i][j] = this.node_pg[j] > 0.0 && this.GGDF.getElement(i, j) * this.Flow[i] > 0.0 ? this.GGDF.getElement(i, j) : 0.0;
                GCDFCON[i][j] = this.node_pl[j] > 0.0 && this.GLDF.getElement(i, j) * this.Flow[i] > 0.0 ? this.GLDF.getElement(i, j) : 0.0;
            }
        }
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                if (AGEN[i][j] > 1.0) {
                    AGEN[i][j] = 1.0;
                }
                if (AGEN[i][j] < -1.0) {
                    AGEN[i][j] = -1.0;
                }
                if (ACON[i][j] > 1.0) {
                    ACON[i][j] = 1.0;
                }
                if (ACON[i][j] < -1.0) {
                    ACON[i][j] = -1.0;
                }
                if (A[i][j] > 1.0) {
                    A[i][j] = 1.0;
                }
                if (A[i][j] < -1.0) {
                    A[i][j] = -1.0;
                }
                PFAF[i] = PFAF[i] + AGEN[i][j] * this.node_pg[j];
                PFAD[i] = PFAD[i] - ACON[i][j] * this.node_pl[j];
                PFA[i] = PFA[i] + A[i][j] * this.node_pg[j];
                PFAC[i] = PFAC[i] - A[i][j] * this.node_pl[j];
                if (GGDFGEN[i][j] > 1.0) {
                    GGDFGEN[i][j] = 1.0;
                }
                if (GGDFGEN[i][j] < -1.0) {
                    GGDFGEN[i][j] = -1.0;
                }
                if (GCDFCON[i][j] > 1.0) {
                    GCDFCON[i][j] = 1.0;
                }
                if (GCDFCON[i][j] < -1.0) {
                    GCDFCON[i][j] = -1.0;
                }
                PFGDFF[i] = PFGDFF[i] + GGDFGEN[i][j] * this.node_pg[j];
                PFGDFD[i] = PFGDFD[i] + GCDFCON[i][j] * this.node_pl[j];
            }
        }
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.Prorrateo[i][j][0] = 0.0;
                this.Prorrateo[i][j][1] = 0.0;
                this.Prorrateo[i][j][2] = 0.0;
                this.Prorrateo[i][j][3] = 0.0;
                this.Prorrateo[i][j][4] = 0.0;
                this.Prorrateo[i][j][5] = 0.0;
                this.Prorrateo[i][j][6] = 0.0;
                this.Prorrateo[i][j][7] = 0.0;
            }
        }
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.Prorrateo[i][j][0] = Math.abs(PFAF[i]) > 1.0E-6 ? Math.abs(AGEN[i][j] * this.node_pg[j] / PFAF[i] * 100.0) : 0.0;
                this.Prorrateo[i][j][1] = Math.abs(PFAD[i]) > 1.0E-6 ? Math.abs(ACON[i][j] * this.node_pl[j] / PFAD[i] * 100.0) : 0.0;
                this.Prorrateo[i][j][2] = Math.abs(PFGDFF[i]) > 1.0E-6 ? Math.abs(GGDFGEN[i][j] * this.node_pg[j] / PFGDFF[i] * 100.0) : 0.0;
                this.Prorrateo[i][j][3] = Math.abs(PFGDFD[i]) > 1.0E-6 ? Math.abs(GCDFCON[i][j] * this.node_pl[j] / PFGDFD[i] * 100.0) : 0.0;
                this.Prorrateo[i][j][4] = Math.abs(this.Flow[i]) > 1.0E-6 ? this.GGDF.getElement(i, j) * this.node_pg[j] / this.Flow[i] * 100.0 : 0.0;
                this.Prorrateo[i][j][5] = Math.abs(this.Flow[i]) > 1.0E-6 ? this.GLDF.getElement(i, j) * this.node_pl[j] / this.Flow[i] * 100.0 : 0.0;
                this.Prorrateo[i][j][6] = Math.abs(PFA[i]) > 1.0E-6 ? A[i][j] * this.node_pg[j] / PFA[i] * 100.0 : 0.0;
                this.Prorrateo[i][j][7] = Math.abs(PFAC[i]) > 1.0E-6 ? -A[i][j] * this.node_pl[j] / Math.abs(PFAC[i]) * 100.0 : 0.0;
            }
        }
        if (rep) {
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("Flujos Lineas");
            for (i = 0; i < this.numlin; ++i) {
                this.myPPrintStream.println("Flow en " + this.NomLin[i] + " = " + this.Flow[i]);
            }
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("Flujos Trafos");
            for (i = 0; i < this.numtrafo; ++i) {
                this.myPPrintStream.println("Flow en " + this.NomTra[i] + " = " + this.Flow[i]);
            }
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("*********************************************************");
            this.myPPrintStream.println("Resultado de Prorrateos para los Distintos M\u00e9todos");
            this.myPPrintStream.println("*********************************************************");
            this.myPPrintStream.println(" ");
            this.myPPrintStream.println("       Nro Rama        - Anualidad  -         Nro Nodo        -     Zona    -   GSDF G    -    GSDF C   -    GGDF    -    GLDF    -    GGDFC    -    GLDFC    -    GSDFGC    -    GSDFCC    ");
            this.myPPrintStream.println(" ");
            for (i = 0; i < this.numbran; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.Prorrateo[i][j][0] + this.Prorrateo[i][j][1] + this.Prorrateo[i][j][2] + this.Prorrateo[i][j][3] + this.Prorrateo[i][j][4] + this.Prorrateo[i][j][5]) > 1.0E-6)) continue;
                    this.myPPrintStream.println(SensitivitiesJAVA.numformat(i, 4) + " " + SensitivitiesJAVA.strformat(this.NomBra[i], 20) + " - " + SensitivitiesJAVA.numformat(this.AVNR_COyM[i], 8, 1) + " - " + SensitivitiesJAVA.numformat(j, 4) + " " + SensitivitiesJAVA.strformat(this.NomNod[j], 20) + " " + SensitivitiesJAVA.strformat(this.CtrlANod[j], 20) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][0], 13, 5) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][1], 13, 5) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][2], 13, 5) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][3], 13, 5) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][4], 13, 5) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][5], 13, 5) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][6], 13, 5) + " - " + SensitivitiesJAVA.numformat(this.Prorrateo[i][j][7], 13, 5));
                }
            }
            this.myPPrintStream.println("*********************************************************");
            this.myPPrintStream.println("Fin Prorrateos ");
            this.myPPrintStream.println("*********************************************************");
        }
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    public void reporteGA() {
        int j;
        int i;
        this.ProrrataG = new double[this.numbran][this.numownerG];
        this.ProrrataL = new double[this.numbran][this.numownerL];
        double[] ResEmpresasG = new double[this.numownerG];
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                int k;
                for (k = 0; k < this.numownerG; ++k) {
                    if (!(this.node_pg[j] > 1.0E-6)) continue;
                    double[] dArray = this.ProrrataG[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.Prorrateo[i][j][2] * this.PGenOwn[k][j] / this.node_pg[j];
                }
                for (k = 0; k < this.numownerL; ++k) {
                    if (!(this.node_pl[j] > 1.0E-6)) continue;
                    double[] dArray = this.ProrrataL[i];
                    int n = k;
                    dArray[n] = dArray[n] + this.Prorrateo[i][j][3] * this.PConLoad[k][j] / this.node_plaux[j];
                }
            }
        }
        String filePrueba = "./results/PruebaSensiGA.txt";
        try {
            FileOutputStream osPrueba = new FileOutputStream(filePrueba);
            PrintStream PruebaStream = new PrintStream(osPrueba);
            PruebaStream.println(" ");
            PruebaStream.println("**************************************");
            PruebaStream.println(" PGenOwn ");
            PruebaStream.println("**************************************");
            PruebaStream.println(" ");
            PruebaStream.println("           OwnerG             -             Nodo             -             PGen");
            for (i = 0; i < this.numownerG; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    PruebaStream.println(StringUtil.strformat(this.NomOwnerG[i], 30) + "    " + StringUtil.strformat(this.NomNod[j], 30) + "    " + StringUtil.numformat(this.PGenOwn[i][j], 15, 5));
                }
            }
            PruebaStream.println(" ");
            PruebaStream.println("**************************************");
            PruebaStream.println("Resultado de Prorrateos Resumen Gen ");
            PruebaStream.println("**************************************");
            PruebaStream.println(" ");
            PruebaStream.println(" ");
            PruebaStream.println("           Branch             -             Owner             -             Prorrateo");
            for (i = 0; i < this.numownerG; ++i) {
                ResEmpresasG[i] = 0.0;
            }
            for (i = 0; i < this.numbran; ++i) {
                for (j = 0; j < this.numownerG; ++j) {
                    if (!(Math.abs(this.ProrrataG[i][j]) > 1.0E-6)) continue;
                    ResEmpresasG[j] = ResEmpresasG[j] + this.ProrrataG[i][j];
                    PruebaStream.println(StringUtil.strformat(i + "  " + this.NomBra[i], 30) + "    " + StringUtil.strformat(this.NomOwnerG[j], 30) + "    " + StringUtil.numformat(this.ProrrataG[i][j], 15, 5));
                }
            }
            double cuenta = 0.0;
            for (i = 0; i < this.numownerG; ++i) {
                cuenta += ResEmpresasG[i];
            }
            PruebaStream.println(" ");
            PruebaStream.println(" ");
            PruebaStream.println("**************************************");
            PruebaStream.println("    Resumen de pagos por empresa ");
            PruebaStream.println("**************************************");
            PruebaStream.println(" ");
            PruebaStream.println(" ");
            PruebaStream.println("    Empresa      -   Prorrateo Promedio");
            for (i = 0; i < this.numownerG; ++i) {
                PruebaStream.println(StringUtil.strformat(this.NomOwnerG[i], 30) + "    " + StringUtil.numformat(ResEmpresasG[i] / cuenta * 100.0, 15, 5));
            }
            PruebaStream.close();
            if (osPrueba != null) {
                osPrueba.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
            e.printStackTrace();
        }
        Runtime r = Runtime.getRuntime();
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
        }
    }

    public double[][] getGSDF(int year, int month) {
        if (this.GSDFS == null) {
            this.Calculate(this.ctrla, false, 1, false, false);
        }
        double[][] dGSDF = new double[this.numbran][this.numnod];
        for (int col = 0; col < this.GSDFS.columns(); ++col) {
            for (int row = 0; row < this.GSDFS.rows(); ++row) {
                dGSDF[row][col] = this.GSDFS.getElement(row, col);
            }
        }
        return dGSDF;
    }

    public String getBranchName(int nBranchID) {
        if (this.NomBra != null && nBranchID < this.numbran) {
            return this.NomNod[nBranchID];
        }
        return null;
    }

    public String getBusbarName(int nBusbarID) {
        if (this.NomNod != null && nBusbarID < this.numnod) {
            return this.NomNod[nBusbarID];
        }
        return null;
    }

    public int getBranchID(String sBranchName) {
        for (int i = 0; i < this.NomBra.length; ++i) {
            if (this.NomBra[i] == null || !this.NomBra[i].equals(sBranchName)) continue;
            return i;
        }
        return -1;
    }
}

