/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DeepEdit;
import de.core.FileFormatException;
import de.core.Generator;
import de.core.Injection;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.SensiFrame;
import de.core.SensitivitiesFrame;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class Sensitivities
extends AnalysisTool {
    protected Vector BusbarVector;
    double[] gen;
    double[] load;
    SensitivitiesFrame MySensitivitiesFrame = null;
    SensiFrame MySensiFrame = null;
    ColorSpec MyColorSpec = null;
    String ctrla = null;

    public Sensitivities(Schematic sch) {
        super(sch);
        System.out.println("---------- In Sensitivities ------------");
        if (this.MySensitivitiesFrame == null) {
            this.MySensitivitiesFrame = new SensitivitiesFrame(this);
        } else {
            this.MySensitivitiesFrame.setVisible(true);
        }
    }

    public Sensitivities(Schematic sch, String CTRLA, boolean sino, int modelo) {
        super(sch);
        System.out.println("---------- In Sensitivities ------------ 1");
        this.Calculate(CTRLA, sino, modelo);
    }

    public void Calculate(String cctrla, boolean sino, int modelo) {
        FileOutputStream os;
        this.ctrla = cctrla;
        String paramlin = WORK_FOLDER + File.separator + "paramlin.dat";
        String paramtran = WORK_FOLDER + File.separator + "paramtran.dat";
        String prorrata = WORK_FOLDER + File.separator + "prorrata.dat";
        String despnodo = WORK_FOLDER + File.separator + "despnodo.dat";
        String desplin = WORK_FOLDER + File.separator + "desplin.dat";
        String desptran = WORK_FOLDER + File.separator + "desptran.dat";
        String nomlin = WORK_FOLDER + File.separator + "nomlin.dat";
        String nomtran = WORK_FOLDER + File.separator + "nomtran.dat";
        String nomnod = WORK_FOLDER + File.separator + "nomnod.dat";
        try {
            AnalysisTool.CreateDirectory(WORK_FOLDER);
            os = new FileOutputStream(nomnod);
            this.DoParamgen(os);
            os.close();
            os = new FileOutputStream(paramlin);
            FileOutputStream os1 = new FileOutputStream(desplin);
            FileOutputStream os2 = new FileOutputStream(paramtran);
            FileOutputStream os3 = new FileOutputStream(nomlin);
            FileOutputStream os4 = new FileOutputStream(nomtran);
            FileOutputStream os5 = new FileOutputStream(desptran);
            this.DoParambran(os, os1, os2, os3, os4, os5);
            os.close();
            os1.close();
            os2.close();
            os3.close();
            os4.close();
            os5.close();
            os = new FileOutputStream(despnodo);
            os1 = new FileOutputStream(prorrata);
            this.DoParam1pole(os, os1);
            os.close();
            os1.close();
            if (modelo == 1) {
                Sensitivities.Dorun(DeepEdit.PathDOS + "Sensitivities.bat", DeepEdit.PathUNIX + "Sensitivities.bat");
            }
            if (modelo == 2) {
                Sensitivities.Dorun(DeepEdit.PathDOS + "SensitivitiesDME.bat", DeepEdit.PathUNIX + "SensitivitiesDME.bat");
            }
            if (modelo == 3) {
                Sensitivities.Dorun(DeepEdit.PathDOS + "SensitivitiesUDL.bat", DeepEdit.PathUNIX + "SensitivitiesUDL.bat");
            }
            if (modelo == 4) {
                Sensitivities.Dorun(DeepEdit.PathDOS + "SensitivitiesDS.bat", DeepEdit.PathUNIX + "SensitivitiesDS.bat");
            }
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Sensitivities", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sino) {
            this.DoListResults("sys.log");
            if (this.MySensiFrame == null) {
                this.MySensiFrame = new SensiFrame(this, this.ctrla);
            } else {
                this.MySensiFrame.setVisible(true);
            }
            if (this.MyColorSpec == null) {
                this.MyColorSpec = new ColorSpec("Sensitivities Color Definition");
            } else {
                this.MyColorSpec.setVisible(true);
            }
        }
    }

    public void DoParamgen(FileOutputStream os) {
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("Nomnod, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        this.BusbarVector = new Vector();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                ++this.numnod;
                this.BusbarVector.addElement(TempComponent);
                myPrintStream.println(TempComponent.getName());
                myPrintStream.println(TempComponent.getName().length());
                if (TempBusbar.getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) {
                    myPrintStream.println(1);
                } else {
                    myPrintStream.println(0);
                }
            }
            if (TempComponent instanceof Line) {
                ++this.numlin;
            }
            if (TempComponent instanceof Trafo) {
                ++this.numtran;
            }
            if (TempComponent instanceof Generator) {
                ++this.numgen;
            }
            if (TempComponent instanceof Injection) {
                ++this.numinj;
            }
            if (!(TempComponent instanceof Load)) continue;
            ++this.numload;
        }
        this.gen = new double[this.numnod];
        this.load = new double[this.numnod];
        for (ix = 0; ix < this.numnod; ++ix) {
            this.gen[ix] = 0.0;
            this.load[ix] = 0.0;
        }
    }

    public void DoParambran(FileOutputStream os, FileOutputStream os1, FileOutputStream os2, FileOutputStream os3, FileOutputStream os4, FileOutputStream os5) throws IOException, FileFormatException {
        double perd = 0.0;
        double ueb = 0.0;
        double reac = 0.0;
        double res = 0.0;
        double z = 0.0;
        int ix = 0;
        PrintStream myPrintStream = new PrintStream(os);
        PrintStream myPrintStream1 = new PrintStream(os1);
        PrintStream myPrintStream2 = new PrintStream(os2);
        PrintStream myPrintStream3 = new PrintStream(os3);
        PrintStream myPrintStream4 = new PrintStream(os4);
        PrintStream myPrintStream5 = new PrintStream(os5);
        myPrintStream.println("LINES: ll\tkl\treactancia (pu)  resistencia (pu)");
        myPrintStream1.println("Desplin, System Name: " + this.ActSchematic.getsysname());
        myPrintStream2.println("TRANSFORMERS: ll\tkl\treactancia (pu)  resistencia (pu)");
        myPrintStream3.println("NOMLIN:");
        myPrintStream4.println("NOMTRAN:");
        myPrintStream5.println("Desptran, System Name: " + this.ActSchematic.getsysname());
        myPrintStream.println(this.numlin);
        myPrintStream2.println(this.numtran);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                perd = TempLine.getp12() + TempLine.getp21();
                myPrintStream.println(this.numbus(TempLine.getcon1()) + " " + this.numbus(TempLine.getcon2()) + " " + TempLine.getxx1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1()) + " " + TempLine.getr1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1()));
                myPrintStream1.println((TempLine.getp12() - perd / 2.0) * this.getSref());
                myPrintStream3.println(TempLine.getName());
                if (TempLine.getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) {
                    myPrintStream3.println(1);
                } else {
                    myPrintStream3.println(0);
                }
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            perd = TempTrafo.getp12() + TempTrafo.getp21();
            ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
            res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.getSref() / TempTrafo.getsn();
            z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / TempTrafo.getsn();
            reac = Math.sqrt(z * z - res * res);
            myPrintStream2.println(this.numbus(TempTrafo.getcon1()) + " " + this.numbus(TempTrafo.getcon2()) + " " + reac + " " + res);
            myPrintStream5.println((TempTrafo.getp12() - perd / 2.0) * this.getSref());
            myPrintStream4.println(TempTrafo.getName());
            if (TempTrafo.getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) {
                myPrintStream4.println(1);
                continue;
            }
            myPrintStream4.println(0);
        }
    }

    public void DoParam1pole(FileOutputStream os, FileOutputStream os1) throws IOException, FileFormatException {
        int ix = 0;
        int countslack = 0;
        PrintStream myPrintStream = new PrintStream(os);
        PrintStream myPrintStream1 = new PrintStream(os1);
        myPrintStream.println("Demand (MW), Generation (MW)");
        myPrintStream1.println("System Name: " + this.ActSchematic.getsysname() + " Peak Load, FirmPower");
        myPrintStream.println(this.numnod);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                int n = this.numbus(TempLoad.getcon2()) - 1;
                this.load[n] = this.load[n] + TempLoad.getp0();
            }
            if (TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)TempComponent;
                int n = this.numbus(TempGenerator.getcon2()) - 1;
                this.gen[n] = this.gen[n] + TempGenerator.getp();
                if (TempGenerator.getlf_type() == 3) {
                    if (++countslack > 1) {
                        System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
                    }
                    this.slack = this.numbus(TempGenerator.getcon2());
                }
            }
            if (!(TempComponent instanceof Injection)) continue;
            Injection TempInjection = (Injection)TempComponent;
            int n = this.numbus(TempInjection.getcon2()) - 1;
            this.gen[n] = this.gen[n] + TempInjection.getp();
            if (TempInjection.getlf_type() != 3) continue;
            if (++countslack > 1) {
                System.out.println(" Caution: More than one slack was defined. Actual: " + TempComponent.getName());
            }
            this.slack = this.numbus(TempInjection.getcon2());
        }
        myPrintStream.println(this.slack);
        myPrintStream.println(1);
        for (ix = 0; ix < this.numnod; ++ix) {
            myPrintStream.println(this.load[ix] + " " + this.gen[ix]);
            myPrintStream1.println(this.load[ix] + " " + this.gen[ix]);
        }
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix + 1;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }
}

