/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.FileFormatException;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Sensitivities;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;

class SensiFrame
extends Frame
implements KeyListener,
ActionListener {
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    Choice MyChoicename = null;
    Choice MyChoicecriteria = null;
    Choice MyChoiceline = null;
    Choice MyChoicelinecriteria = null;
    Choice MyChoicetrafo = null;
    Choice MyChoicetrafocriteria = null;
    Sensitivities MySensi = null;
    Button button1;
    Button button2;
    Button button3;
    Button button4;
    Button button5;
    Button button6;
    double[] sensi;

    public SensiFrame(Sensitivities aaSensi, String ctrla) {
        super("Sensitivities visualization parameters");
        comp TempComponent;
        this.setBackground(SystemColor.control);
        this.MySensi = aaSensi;
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "SENSITIVITIES TRANSMISSION PRICING VISUALIZATION", gridbag, c, Color.blue);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "Visualization of the cost allocation between participants.", gridbag, c, Color.black);
        c.anchor = 17;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "Selected Control Area: " + ctrla, gridbag, c, Color.red);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Busbar: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoicename = new Choice();
        this.MyChoicecriteria = new Choice();
        for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Busbar)) continue;
            this.MyChoicename.addItem(TempComponent.getName());
        }
        this.MyChoicecriteria.addItem("GSDF (Loads)");
        this.MyChoicecriteria.addItem("GLDF (Loads)");
        this.MyChoicecriteria.addItem("GSDF (Generators)");
        this.MyChoicecriteria.addItem("GGDF (Generators)");
        gridbag.setConstraints(this.MyChoicename, c);
        gridbag.setConstraints(this.MyChoicecriteria, c);
        this.add(this.MyChoicename);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicecriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button button1 = new Button("Show");
        button1.setActionCommand("Show");
        button1.addActionListener(this);
        gridbag.setConstraints(button1, c);
        this.add(button1);
        Button button2 = new Button("Exit");
        button2.setActionCommand("Exit");
        button2.addActionListener(this);
        gridbag.setConstraints(button2, c);
        this.add(button2);
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Line: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoiceline = new Choice();
        this.MyChoicelinecriteria = new Choice();
        for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line)) continue;
            this.MyChoiceline.addItem(TempComponent.getName());
        }
        this.MyChoicelinecriteria.addItem("GSDF (Loads)");
        this.MyChoicelinecriteria.addItem("GLDF (Loads)");
        this.MyChoicelinecriteria.addItem("GSDF (Generators)");
        this.MyChoicelinecriteria.addItem("GGDF (Generators)");
        gridbag.setConstraints(this.MyChoiceline, c);
        gridbag.setConstraints(this.MyChoicelinecriteria, c);
        this.add(this.MyChoiceline);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicelinecriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button button3 = new Button("Show");
        button3.setActionCommand("Showline");
        button3.addActionListener(this);
        gridbag.setConstraints(button3, c);
        this.add(button3);
        Button button4 = new Button("Exit");
        button4.setActionCommand("Exit");
        button4.addActionListener(this);
        gridbag.setConstraints(button4, c);
        this.add(button4);
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, "Select Transformer: ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        this.MyChoicetrafo = new Choice();
        this.MyChoicetrafocriteria = new Choice();
        for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Trafo)) continue;
            this.MyChoicetrafo.addItem(TempComponent.getName());
        }
        this.MyChoicetrafocriteria.addItem("GSDF (Loads)");
        this.MyChoicetrafocriteria.addItem("GLDF (Loads)");
        this.MyChoicetrafocriteria.addItem("GSDF (Generators)");
        this.MyChoicetrafocriteria.addItem("GGDF (Generators)");
        gridbag.setConstraints(this.MyChoicetrafo, c);
        gridbag.setConstraints(this.MyChoicetrafocriteria, c);
        this.add(this.MyChoicetrafo);
        Utils.makeLabel(this, "Select Criteria", gridbag, c);
        this.add(this.MyChoicetrafocriteria);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button button5 = new Button("Show");
        button5.setActionCommand("Showtrafo");
        button5.addActionListener(this);
        gridbag.setConstraints(button5, c);
        this.add(button5);
        Button button6 = new Button("Exit");
        button6.setActionCommand("Exit");
        button6.addActionListener(this);
        gridbag.setConstraints(button6, c);
        this.add(button6);
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SensiFrame.this.restorecolor();
                SensiFrame.this.setVisible(false);
                SensiFrame.this.dispose();
                try {
                    SensiFrame.this.MySensi.MyColorSpec.setVisible(false);
                    SensiFrame.this.MySensi.MyColorSpec.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SensiFrame.this.MySensi.MySensiFrame = null;
            }
        });
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            try {
                this.MySensi.MyColorSpec.setVisible(false);
                this.MySensi.MyColorSpec.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.MySensi.MySensiFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            if (label.equals("Exit")) {
                this.restorecolor();
                this.setVisible(false);
                this.dispose();
                try {
                    this.MySensi.MyColorSpec.setVisible(false);
                    this.MySensi.MyColorSpec.dispose();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.MySensi.MySensiFrame = null;
                DeepEdit.MySchematicPanel.repaint();
            } else if (label.equals("Show")) {
                this.visualization(this.MyChoicename.getSelectedItem(), this.MyChoicecriteria.getSelectedItem());
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            } else if (label.equals("Showline")) {
                this.visualizationline(this.MyChoiceline.getSelectedItem(), this.MyChoicelinecriteria.getSelectedItem());
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            } else if (label.equals("Showtrafo")) {
                this.visualizationtrafo(this.MyChoicetrafo.getSelectedItem(), this.MyChoicetrafocriteria.getSelectedItem());
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            }
        }
    }

    public void visualization(String nombre, String modelo) {
        FileInputStream os1 = null;
        Load TempLoad = null;
        Generator TempGenerator = null;
        int counterL = 0;
        int counterT = 0;
        try {
            os1 = new FileInputStream("results/" + nombre + ".sen");
            this.ReadSens(os1, modelo);
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Sensitivities, visualization", message, DlgButtons, 1, 0, 0, 1);
        }
        for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.gray;
            ndb_comp.Color2 = Color.gray;
            ndb_comp.Color3 = Color.gray;
            if (TempComponent instanceof Line) {
                Tempndb.lw = (int)(this.sensi[counterL] / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(this.sensi[counterL]));
                ++counterL;
                continue;
            }
            if (TempComponent instanceof Busbar && TempComponent.getName().equals(nombre)) {
                Tempndb.setAlternatekv_Color(Color.red);
                continue;
            }
            if (TempComponent instanceof Trafo) {
                Tempndb.lw = (int)(this.sensi[this.MySensi.numlin + counterT] / 10.0 + 1.0);
                Tempndb.setAlternatekv_Color(this.floatToColor(this.sensi[this.MySensi.numlin + counterT]));
                ++counterT;
                continue;
            }
            if (TempComponent instanceof Generator && (modelo.equals("GSDF (Generators)") || modelo.equals("GGDF (Generators)"))) {
                TempGenerator = (Generator)TempComponent;
                if (TempGenerator.getcon2().equals(nombre)) {
                    Tempndb.setAlternatekv_Color(Color.red);
                    continue;
                }
                Tempndb.setAlternatekv_Color(Color.gray);
                continue;
            }
            if (TempComponent instanceof Load && (modelo.equals("GSDF (Loads)") || modelo.equals("GLDF (Loads)"))) {
                TempLoad = (Load)TempComponent;
                if (TempLoad.getcon2().equals(nombre)) {
                    Tempndb.setAlternatekv_Color(Color.red);
                    continue;
                }
                Tempndb.setAlternatekv_Color(Color.gray);
                continue;
            }
            Tempndb.setAlternatekv_Color(Color.gray);
        }
    }

    public void visualizationline(String nombre, String modelo) {
        ndb_comp Tempndb;
        comp TempComponent;
        int ix;
        ndb_branch BTempLine = null;
        Load TempLoad = null;
        Generator TempGenerator = null;
        double acum = 0.0;
        double anteil = 0.0;
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.gray;
            ndb_comp.Color2 = Color.gray;
            ndb_comp.Color3 = Color.gray;
            Tempndb.setAlternatekv_Color(Color.gray);
            Tempndb.lw = 1;
            if (!(TempComponent instanceof Line) || !TempComponent.getName().equals(nombre)) continue;
            BTempLine = (Line)TempComponent;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            if (TempComponent instanceof Busbar) {
                anteil = this.visualization(nombre, TempComponent.getName(), modelo);
                acum += anteil;
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (TempComponent instanceof Generator && (modelo.equals("GSDF (Generators)") || modelo.equals("GGDF (Generators)"))) {
                TempGenerator = (Generator)TempComponent;
                anteil = this.visualization(nombre, TempGenerator.getcon2(), modelo);
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (!(TempComponent instanceof Load) || !modelo.equals("GSDF (Loads)") && !modelo.equals("GLDF (Loads)")) continue;
            TempLoad = (Load)TempComponent;
            anteil = this.visualization(nombre, TempLoad.getcon2(), modelo);
            Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
        }
        if (acum == 0.0) {
            System.out.println("WARNING: Line " + nombre + " is not paid.");
        }
        ((Line)BTempLine).lw = 5;
        BTempLine.setAlternatekv_Color(this.floatToColor(acum));
    }

    public void visualizationtrafo(String nombre, String modelo) {
        ndb_comp Tempndb;
        comp TempComponent;
        int ix;
        ndb_branch BTempTrafo = null;
        Load TempLoad = null;
        Generator TempGenerator = null;
        double acum = 0.0;
        double anteil = 0.0;
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            ndb_comp.CaptionColor = Color.gray;
            ndb_comp.TextColor1 = Color.gray;
            ndb_comp.TextColor2 = Color.gray;
            ndb_comp.TextColor3 = Color.gray;
            ndb_comp.Color1 = Color.gray;
            ndb_comp.Color2 = Color.gray;
            ndb_comp.Color3 = Color.gray;
            Tempndb.setAlternatekv_Color(Color.gray);
            Tempndb.lw = 1;
            if (!(TempComponent instanceof Trafo) || !TempComponent.getName().equals(nombre)) continue;
            BTempTrafo = (Trafo)TempComponent;
        }
        for (ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            if (TempComponent instanceof Busbar) {
                anteil = this.visualization(nombre, TempComponent.getName(), modelo);
                acum += anteil;
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (TempComponent instanceof Generator && (modelo.equals("GSDF (Generators)") || modelo.equals("GGDF (Generators)"))) {
                TempGenerator = (Generator)TempComponent;
                anteil = this.visualization(nombre, TempGenerator.getcon2(), modelo);
                Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
            }
            if (!(TempComponent instanceof Load) || !modelo.equals("GSDF (Loads)") && !modelo.equals("GLDF (Loads)")) continue;
            TempLoad = (Load)TempComponent;
            anteil = this.visualization(nombre, TempLoad.getcon2(), modelo);
            Tempndb.setAlternatekv_Color(this.floatToColor(anteil));
        }
        if (acum == 0.0) {
            System.out.println("WARNING: Trafo " + nombre + " is not paid.");
        }
        ((Trafo)BTempTrafo).lw = 5;
        BTempTrafo.setAlternatekv_Color(this.floatToColor(acum));
    }

    public double visualization(String nombran, String nombre, String modelo) {
        FileInputStream os1 = null;
        int counterL = 0;
        int counterT = 0;
        comp TempComponent = null;
        ndb_comp Tempndb = null;
        try {
            os1 = new FileInputStream("results/" + nombre + ".sen");
            this.ReadSens(os1, modelo);
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Sensitivities, visualization", message, DlgButtons, 1, 0, 0, 1);
        }
        for (int ix = 0; ix < this.MySensi.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.MySensi.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
            Tempndb = (ndb_comp)TempComponent;
            if (TempComponent instanceof Line) {
                if (TempComponent.getName().equals(nombran)) {
                    return this.sensi[counterL];
                }
                ++counterL;
            }
            if (!(TempComponent instanceof Trafo)) continue;
            if (TempComponent.getName().equals(nombran)) {
                return this.sensi[this.MySensi.numlin + counterT];
            }
            ++counterT;
        }
        System.out.println("Not found: " + nombre + ", " + nombran);
        return 0.0;
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }

    public void ReadSens(InputStream iss, String criteria) throws IOException, FileFormatException {
        String AuxText = "";
        this.sensi = new double[this.MySensi.numlin + this.MySensi.numtran];
        int i = 0;
        BufferedReader is = new BufferedReader(new InputStreamReader(iss));
        StreamTokenizer st = new StreamTokenizer(is);
        st.eolIsSignificant(true);
        if (criteria.equals("GSDF (Loads)")) {
            block16: while (true) {
                switch (st.nextToken()) {
                    case 10: {
                        continue block16;
                    }
                    case -2: {
                        this.sensi[i] = st.nval;
                        if (st.nextToken() != -2 || st.nextToken() != -2 || st.nextToken() == -2) {
                            // empty if block
                        }
                        ++i;
                        continue block16;
                    }
                }
                break;
            }
        }
        if (criteria.equals("GSDF (Generators)")) {
            block17: while (true) {
                switch (st.nextToken()) {
                    case 10: {
                        continue block17;
                    }
                    case -2: {
                        if (st.nextToken() == -2 && st.nextToken() == -2) {
                            this.sensi[i] = st.nval;
                            if (st.nextToken() == -2) {
                                // empty if block
                            }
                        }
                        ++i;
                        continue block17;
                    }
                }
                break;
            }
        }
        if (criteria.equals("GLDF (Loads)")) {
            block18: while (true) {
                switch (st.nextToken()) {
                    case 10: {
                        continue block18;
                    }
                    case -2: {
                        if (st.nextToken() == -2) {
                            this.sensi[i] = st.nval;
                            if (st.nextToken() != -2 || st.nextToken() == -2) {
                                // empty if block
                            }
                        }
                        ++i;
                        continue block18;
                    }
                }
                break;
            }
        }
        if (criteria.equals("GGDF (Generators)")) {
            block19: while (true) {
                switch (st.nextToken()) {
                    case 10: {
                        continue block19;
                    }
                    case -2: {
                        if (st.nextToken() == -2 && st.nextToken() == -2 && st.nextToken() == -2) {
                            this.sensi[i] = st.nval;
                        }
                        ++i;
                        continue block19;
                    }
                }
                break;
            }
        }
        iss.close();
    }

    public Color floatToColor(double f) {
        int elec = (int)(f / 10.0 + 1.0);
        Color acolor = Color.gray;
        switch (elec) {
            case 0: {
                acolor = Color.gray;
                break;
            }
            case 1: {
                acolor = Color.white;
                break;
            }
            case 2: {
                acolor = Color.cyan;
                break;
            }
            case 3: {
                acolor = Color.green;
                break;
            }
            case 4: {
                acolor = Color.yellow;
                break;
            }
            case 5: {
                acolor = Color.pink;
                break;
            }
            case 6: {
                acolor = Color.blue;
                break;
            }
            case 7: {
                acolor = Color.magenta;
                break;
            }
            case 8: {
                acolor = Color.orange;
                break;
            }
            case 9: {
                acolor = new Color(204, 136, 0);
                break;
            }
            case 10: {
                acolor = Color.red;
            }
        }
        if (elec > 10 && elec <= 11) {
            acolor = Color.red;
        }
        if (elec > 11) {
            acolor = Color.black;
        }
        if (f <= 1.0) {
            acolor = Color.gray;
        }
        return acolor;
    }
}

