/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.Caption;
import de.core.ComponentPin;
import de.core.Constraint;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.DeepEditMainPane;
import de.core.FileFormatException;
import de.core.Ga;
import de.core.Generator;
import de.core.GeneratorCHP;
import de.core.GeneratorDG;
import de.core.GeneratorEO;
import de.core.GeneratorPV;
import de.core.Injection;
import de.core.JMapObject;
import de.core.LaunchProgressFrame;
import de.core.Line;
import de.core.LineDC;
import de.core.Load;
import de.core.MMTool;
import de.core.PLPagreementDialog;
import de.core.Pin;
import de.core.Probe;
import de.core.SVC;
import de.core.SelectActorsDialog;
import de.core.SelectBusbarsDialog;
import de.core.SelectReservoirsDialog;
import de.core.SimpleDialog;
import de.core.Simulation;
import de.core.ThreeWindingTrafo;
import de.core.Trafo;
import de.core.Upfc;
import de.core.agreement;
import de.core.agreementDialog;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_comp;
import de.core.hdb_irr;
import de.core.hdb_link;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.core.hdb_unitDialog;
import de.core.mdb_act;
import de.core.mdb_comp;
import de.core.mdb_cust;
import de.core.mdb_custDialog;
import de.core.mdb_inv;
import de.core.mdb_invDialog;
import de.core.mdb_iso;
import de.core.mdb_owner;
import de.core.mdb_sup;
import de.core.mdb_supDialog;
import de.core.mdb_wheel;
import de.core.ndb_1pol;
import de.core.ndb_2pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import de.core.planpro;
import de.core.planproDialog;
import de.core.seeds.SEEDS_AgreementDialog;
import de.data.DE_ClassEnums;
import de.data.DE_GeneralEnums;
import de.data.DE_VariableEnums;
import de.data.ParameterData;
import de.utils.ExcelUtil;
import de.utils.StringUtil;
import de.utils.Utils;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.List;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class Schematic {
    public static final String SCHEMATICFILE_INI_DESCRIBE = "describe";
    public static final String SCHEMATICFILE_COMPONENT = "component";
    public static final String SCHEMATICFILE_VERSION = "version";
    public static final String SCHEMATICFILE_END_DESCRIBE = "end describe";
    public Vector Components;
    public Vector OptimizationComponents;
    public boolean Modified = false;
    public boolean Modifiedstate = true;
    public boolean cycle = false;
    public boolean changeGIS = false;
    public int count = 0;
    boolean ShowReactive = true;
    String focusowner = "NO FOCUS";
    public String FileDir = null;
    public String state = "------";
    String message = null;
    public String FileName = "untitled";
    int SimulateCycleID = 0;
    String OSName;
    private static final long BITMASK = (long)Math.pow(2.0, 64.0) - 1L;
    protected static double sref = 100.0;
    protected double intrate = 10.0;
    protected double convergence = 0.01;
    protected double loadfac1 = 0.0;
    protected double loadfac2 = 1.0;
    protected String sysname = "New_Name";
    protected String actday = "___";
    protected String actdaytype = "___";
    protected String acthour = "___";
    protected int iniperiod = 2001;
    protected int endperiod = 2030;
    protected int actperiod = 2014;
    protected int inimonth = 1;
    protected int endmonth = 12;
    protected int actmonth = 1;
    private int stepperiod = 1;
    protected int stepmonth = 1;
    protected int nitera = 40;
    protected int tiposimula = 0;
    protected int typsim = 0;
    protected boolean customsim = false;
    protected boolean peaksim = true;
    protected boolean meansim = false;
    protected boolean lowsim = false;
    protected int codebit = 0;
    protected int numoptimize = 0;
    protected double fitnes = 0.0;
    protected double totcost = 0.0;
    protected double totgen = 0.0;
    protected double totunser = 0.0;
    protected double totloss = 0.0;
    protected double totdem = 0.0;
    protected comp TempComponent = null;
    private JTree MyDataTree;
    private ImageIcon folderImageIcon;
    private double co2price = 0.0;
    private double flow2volume = 1.0;
    private double frequence = 50.0;
    private double maxuse = 100.0;
    private double minreserve = 0.0;
    private double reservevioprice = 0.0;
    private double useprice = 1000000.0;
    private Map<String, Map<String, comp>> DBObjects = new HashMap<String, Map<String, comp>>();

    public Schematic() {
        this.Components = new Vector();
        sref = 100.0;
        this.intrate = 10.0;
        this.loadfac1 = 0.0;
        this.loadfac2 = 1.0;
        this.sysname = null;
        this.iniperiod = 2001;
        this.endperiod = 2030;
        this.actperiod = 2014;
        this.actday = "___";
        this.actdaytype = "___";
        this.acthour = "___";
        this.stepperiod = 1;
        this.customsim = false;
        this.peaksim = true;
        this.meansim = false;
        this.lowsim = false;
        this.nitera = 40;
        this.tiposimula = 0;
        this.typsim = 0;
        this.codebit = 0;
        this.numoptimize = 0;
        this.fitnes = 0.0;
        this.focusowner = "NO FOCUS";
    }

    public Schematic(Schematic SchematicToCopy) {
        this.Components = new Vector();
        for (int ix = 0; ix < SchematicToCopy.Components.size(); ++ix) {
            this.TempComponent = (comp)SchematicToCopy.Components.elementAt(ix);
            if (!this.TempComponent.getvalid()) continue;
            this.addComponent(this.TempComponent);
        }
    }

    public String getsysname() {
        return this.sysname;
    }

    public double getsref() {
        return sref;
    }

    public double getloadfac1() {
        return this.loadfac1;
    }

    public double getloadfac2() {
        return this.loadfac2;
    }

    public double getintrate() {
        return this.intrate;
    }

    public int getiniperiod() {
        return this.iniperiod;
    }

    public int getendperiod() {
        return this.endperiod;
    }

    public int getactperiod() {
        return this.actperiod;
    }

    public int getstepperiod() {
        return this.stepperiod;
    }

    public int getinimonth() {
        return this.inimonth;
    }

    public int getendmonth() {
        return this.endmonth;
    }

    public int getactmonth() {
        return this.actmonth;
    }

    public int getstepmonth() {
        return this.stepmonth;
    }

    public boolean getpeaksim() {
        return this.peaksim;
    }

    public boolean getcustomsim() {
        return this.customsim;
    }

    public boolean getmeansim() {
        return this.meansim;
    }

    public boolean getlowsim() {
        return this.lowsim;
    }

    public int getnitera() {
        return this.nitera;
    }

    public double getconvergence() {
        return this.convergence;
    }

    public int gettiposimula() {
        return this.tiposimula;
    }

    public int gettypsim() {
        return this.typsim;
    }

    public int getcodebit() {
        return this.codebit;
    }

    public int getnumoptimize() {
        return this.numoptimize;
    }

    public double getfitnes() {
        return this.fitnes;
    }

    public double gettotcost() {
        return this.totcost;
    }

    public double gettotgen() {
        return this.totgen;
    }

    public double gettotunser() {
        return this.totunser;
    }

    public double gettotloss() {
        return this.totloss;
    }

    public double gettotdem() {
        return this.totdem;
    }

    public String getfocusowner() {
        return this.focusowner;
    }

    public String getactday() {
        return this.actday;
    }

    public String getactdaytype() {
        return this.actdaytype;
    }

    public String getacthour() {
        return this.acthour;
    }

    public String getstate() {
        return this.state;
    }

    public Vector getcomponents() {
        return this.Components;
    }

    public Collection<comp> getComponents() {
        ArrayList<comp> lReturn = new ArrayList<comp>();
        for (Map<String, comp> it : this.DBObjects.values()) {
            lReturn.addAll(it.values());
        }
        return lReturn;
    }

    public Collection<comp> getComponents(String className) {
        Map<String, comp> mComp = this.DBObjects.get(className);
        if (mComp == null) {
            return new ArrayList<comp>();
        }
        return mComp.values();
    }

    public Collection<comp> getComponents(Class subClass) {
        ArrayList<comp> lRet = new ArrayList<comp>();
        for (comp c : this.getComponents()) {
            if (!subClass.isInstance(c)) continue;
            lRet.add(c);
        }
        return lRet;
    }

    public comp getComponent(String objectName, String className) {
        Map<String, comp> mComp = this.DBObjects.get(className);
        if (mComp != null) {
            return mComp.get(objectName);
        }
        return null;
    }

    public Busbar getSlackBurbar() {
        for (comp g : this.getComponents("Generator")) {
            Generator myGen = (Generator)g;
            if (myGen.getlf_type() != 3) continue;
            myGen.InformAllComponents();
            String strBusbarName = myGen.getcon2();
            for (comp b : this.getComponents("Busbar")) {
                Busbar myBus = (Busbar)b;
                if (!strBusbarName.equals(myBus.getName())) continue;
                return myBus;
            }
        }
        return null;
    }

    public double getCo2price() {
        return this.co2price;
    }

    public double getFlow2volume() {
        return this.flow2volume;
    }

    public double getFrequence() {
        return this.frequence;
    }

    public double getMaxuse() {
        return this.maxuse;
    }

    public double getMinreserve() {
        return this.minreserve;
    }

    public double getReservevioprice() {
        return this.reservevioprice;
    }

    public int getNumloss() {
        Simulation sim = DeepEdit.getActiveSimulation();
        String sValue = sim.getParamaterValue("numloss");
        int numloss = 1;
        if (sValue != null) {
            numloss = Integer.parseInt(sValue);
        }
        return numloss;
    }

    public double getUseprice() {
        return this.useprice;
    }

    public void setsref(double n) {
        sref = n;
    }

    public void setloadfac1(double n) {
        this.loadfac1 = n;
    }

    public void setloadfac2(double n) {
        this.loadfac2 = n;
    }

    public void setintrate(double n) {
        this.intrate = n;
    }

    public void setsysname(String n) {
        this.sysname = n;
    }

    public void setactday(String n) {
        this.actday = n;
    }

    public void setactdaytype(String n) {
        this.actdaytype = n;
    }

    public void setacthour(String n) {
        this.acthour = n;
    }

    public void setiniperiod(int n) {
        this.iniperiod = n;
    }

    public void setendperiod(int n) {
        this.endperiod = n;
    }

    public void setactperiod(int n) {
        this.actperiod = n;
    }

    public void setstepperiod(int n) {
        this.stepperiod = n;
    }

    public void setinimonth(int n) {
        this.inimonth = n;
    }

    public void setendmonth(int n) {
        this.endmonth = n;
    }

    public void setactmonth(int n) {
        this.actmonth = n;
    }

    public void setstepmonth(int n) {
        this.stepmonth = n;
    }

    public void setpeaksim(boolean n) {
        this.peaksim = n;
    }

    public void setcustomsim(boolean n) {
        this.customsim = n;
    }

    public void setmeansim(boolean n) {
        this.meansim = n;
    }

    public void setlowsim(boolean n) {
        this.lowsim = n;
    }

    public void setnitera(int n) {
        this.nitera = n;
    }

    public void setconvergence(double n) {
        this.convergence = n;
    }

    public void settiposimula(int n) {
        this.tiposimula = n;
    }

    public void settypsim(int n) {
        this.typsim = n;
    }

    public void setcodebit(int n) {
        this.codebit = n;
    }

    public void setnumoptimize(int n) {
        this.numoptimize = n;
    }

    public void setfitnes(double n) {
        this.fitnes = n;
    }

    public void settotgen(double n) {
        this.totgen = n;
    }

    public void settotcost(double n) {
        this.totcost = n;
    }

    public void settotunser(double n) {
        this.totunser = n;
    }

    public void settotloss(double n) {
        this.totloss = n;
    }

    public void settotdem(double n) {
        this.totdem = n;
    }

    public void setfocusowner(String n) {
        this.focusowner = n;
    }

    public void setCo2price(double co2price) {
        this.co2price = co2price;
    }

    public void setFlow2volume(double flow2volume) {
        this.flow2volume = flow2volume;
    }

    public void setFrequence(double frequence) {
        this.frequence = frequence;
    }

    public void setMaxuse(double maxuse) {
        this.maxuse = maxuse;
    }

    public void setMinreserve(double minreserve) {
        this.minreserve = minreserve;
    }

    public void setReservevioprice(double reservevioprice) {
        this.reservevioprice = reservevioprice;
    }

    public void setNumloss(int numloss) {
        Simulation sim = DeepEdit.getActiveSimulation();
        sim.setParameterValue(String.valueOf(numloss), "numloss");
    }

    public void setUseprice(double useprice) {
        this.useprice = useprice;
    }

    public Schematic PasteSchematic(Pin[][] PinGrid, Schematic CopySchematic, int Xoff, int Yoff) {
        mdb_owner TempOwner;
        hdb_link TempLink;
        mdb_wheel TempContract;
        Line TempWire;
        comp TempComponent;
        int ix;
        Schematic NewSelectSchematic = new Schematic();
        int MinX = -1;
        int MinY = -1;
        this.Modified = true;
        this.Modifiedstate = true;
        for (ix = 0; ix < CopySchematic.size(); ++ix) {
            int WireYMin;
            int WireXMin;
            TempComponent = (comp)CopySchematic.Components.elementAt(ix);
            if (TempComponent instanceof ndb_comp) {
                this.changeGIS = true;
            }
            if (TempComponent instanceof Line) {
                TempWire = (Line)TempComponent;
                WireXMin = Math.min(TempWire.x1, TempWire.x2);
                WireYMin = Math.min(TempWire.y1, TempWire.y2);
                if (MinX == -1 || WireXMin < MinX) {
                    MinX = WireXMin - 1;
                }
                if (MinY != -1 && WireYMin >= MinY) continue;
                MinY = WireYMin - 1;
                continue;
            }
            if (TempComponent instanceof mdb_wheel) {
                TempContract = (mdb_wheel)TempComponent;
                WireXMin = Math.min(TempContract.x1, TempContract.x2);
                WireYMin = Math.min(TempContract.y1, TempContract.y2);
                if (MinX == -1 || WireXMin < MinX) {
                    MinX = WireXMin - 1;
                }
                if (MinY != -1 && WireYMin >= MinY) continue;
                MinY = WireYMin - 1;
                continue;
            }
            if (TempComponent instanceof hdb_link) {
                TempLink = (hdb_link)TempComponent;
                WireXMin = Math.min(TempLink.x1, TempLink.x2);
                WireYMin = Math.min(TempLink.y1, TempLink.y2);
                if (MinX == -1 || WireXMin < MinX) {
                    MinX = WireXMin - 1;
                }
                if (MinY != -1 && WireYMin >= MinY) continue;
                MinY = WireYMin - 1;
                continue;
            }
            if (TempComponent instanceof mdb_owner) {
                TempOwner = (mdb_owner)TempComponent;
                WireXMin = Math.min(TempOwner.x1, TempOwner.x2);
                WireYMin = Math.min(TempOwner.y1, TempOwner.y2);
                if (MinX == -1 || WireXMin < MinX) {
                    MinX = WireXMin - 1;
                }
                if (MinY != -1 && WireYMin >= MinY) continue;
                MinY = WireYMin - 1;
                continue;
            }
            if (MinX == -1 || TempComponent.Pos.x < MinX) {
                MinX = TempComponent.Pos.x;
            }
            if (MinY != -1 && TempComponent.Pos.y >= MinY) continue;
            MinY = TempComponent.Pos.y;
        }
        for (ix = 0; ix < CopySchematic.size(); ++ix) {
            TempComponent = (comp)CopySchematic.Components.elementAt(ix);
            comp NewComponent = TempComponent.Copy(MinX - Xoff, MinY - Yoff);
            TempComponent.setSelected(false);
            NewComponent.setSelected(true);
            if (TempComponent instanceof Line) {
                TempWire = (Line)NewComponent;
                TempWire.ChangingWire = 3;
            }
            if (TempComponent instanceof mdb_wheel) {
                TempContract = (mdb_wheel)NewComponent;
                TempContract.ChangingWire = 3;
            }
            if (TempComponent instanceof hdb_link) {
                TempLink = (hdb_link)NewComponent;
                TempLink.ChangingWire = 3;
            }
            if (TempComponent instanceof mdb_owner) {
                TempOwner = (mdb_owner)NewComponent;
                TempOwner.ChangingWire = 3;
            }
            NewSelectSchematic.addComponent(NewComponent);
        }
        return NewSelectSchematic;
    }

    public void SetAllComponentsSelected() {
        if (DeepEdit.ViewMode) {
            return;
        }
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (this.TempComponent.getvalid()) {
                this.TempComponent.setSelected(true);
                if (this.TempComponent instanceof Line) {
                    ((Line)this.TempComponent).ChangingWire = 3;
                    continue;
                }
                if (this.TempComponent instanceof mdb_wheel) {
                    ((mdb_wheel)this.TempComponent).ChangingWire = 3;
                    continue;
                }
                if (this.TempComponent instanceof mdb_owner) {
                    ((mdb_owner)this.TempComponent).ChangingWire = 3;
                    continue;
                }
                if (!(this.TempComponent instanceof hdb_link)) continue;
                ((hdb_link)this.TempComponent).ChangingWire = 3;
                continue;
            }
            this.TempComponent.setSelected(false);
        }
    }

    public static void SetAllCaptionsColor(Color newColor) {
        comp.setCaptionColor(newColor);
    }

    public static void SetAllComponentsLabelTextColor(Color newColor) {
        comp.setLabelTextColor(newColor);
    }

    public void restoreColor() {
        for (Object o : this.Components) {
            comp tempComp = (comp)o;
            if (!(tempComp instanceof ndb_comp)) continue;
            ((ndb_comp)tempComp).restoreColor();
        }
        DeepEdit.MySchematicPanel.repaint();
    }

    public void initOptimizationComponents() {
        int numbit = 0;
        this.OptimizationComponents = new Vector();
        this.setcodebit(0);
        this.setnumoptimize(0);
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof planpro)) continue;
            planpro Tempplanpro = (planpro)this.TempComponent;
            ++this.numoptimize;
            this.OptimizationComponents.addElement(Tempplanpro);
        }
        double raux = Math.log(this.endperiod - this.iniperiod + 1) / Math.log(2.0);
        this.codebit = (int)Math.ceil(raux);
        numbit = this.numoptimize * this.codebit;
        System.out.println("Periodos      : " + (this.endperiod - this.iniperiod + 1));
        System.out.println("Codebit       : " + this.codebit);
        System.out.println("Numoptimize   : " + this.numoptimize);
        System.out.println("Numbit        : " + numbit);
    }

    public void CodeSchematic(Ga ga, PrintStream report) {
        int numbit = 0;
        this.OptimizationComponents = new Vector();
        this.setcodebit(0);
        this.setnumoptimize(0);
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof planpro)) continue;
            planpro Tempplanpro = (planpro)this.TempComponent;
            ++this.numoptimize;
            this.OptimizationComponents.addElement(Tempplanpro);
        }
        double raux = Math.log(this.endperiod - this.iniperiod + 1) / Math.log(2.0);
        this.codebit = (int)Math.ceil(raux);
        numbit = this.numoptimize * this.codebit;
        System.out.println("Periodos      : " + (this.endperiod - this.iniperiod + 1));
        System.out.println("Codebit       : " + this.codebit);
        System.out.println("Numoptimize   : " + this.numoptimize);
        System.out.println("Numbit        : " + numbit);
        report.println("Periodos      : " + (this.endperiod - this.iniperiod + 1));
        report.println("Codebit       : " + this.codebit);
        report.println("Numoptimize   : " + this.numoptimize);
        report.println("Numbit        : " + numbit);
        ga.setParamFromDeep(2, numbit, this.iniperiod, this.endperiod, 0.004, 0.8, 10);
    }

    public void EvalSchematic(long genes, PrintStream report, int[] estadoenperiodo) {
        long bitmask = BITMASK << this.getcodebit() - 1;
        report.println("-------");
        report.println("gene " + genes);
        report.println("Bitmask " + (bitmask ^= 0xFFFFFFFFFFFFFFFFL));
        report.println("CodeBit " + this.getcodebit());
        report.println("numoptimize " + this.getnumoptimize());
        for (int ip = 0; ip < this.getendperiod() - this.getiniperiod() + 1; ++ip) {
            estadoenperiodo[ip] = 0;
        }
        for (int ix = 0; ix < this.OptimizationComponents.size(); ++ix) {
            planpro Tempplanpro = (planpro)this.OptimizationComponents.elementAt(ix);
            int auxint = (int)(genes & bitmask);
            if (auxint != 0) {
                int ip = auxint - 1;
                while (ip < this.getendperiod() - this.getiniperiod() + 1) {
                    int n = ip++;
                    estadoenperiodo[n] = estadoenperiodo[n] + (int)Math.pow(2.0, ix);
                }
            }
            Tempplanpro.setentry(auxint, this.getiniperiod(), this.getendperiod());
            genes >>= this.getcodebit();
        }
    }

    public void EvalSchematic(long genes, PrintStream report) {
        long bitmask = BITMASK << this.getcodebit() - 1;
        bitmask ^= 0xFFFFFFFFFFFFFFFFL;
        for (int ix = 0; ix < this.OptimizationComponents.size(); ++ix) {
            planpro Tempplanpro = (planpro)this.OptimizationComponents.elementAt(ix);
            int auxint = (int)(genes & bitmask);
            Tempplanpro.setentry(auxint, this.getiniperiod(), this.getendperiod());
            genes >>= this.getcodebit();
        }
    }

    public void drawBestGene(Graphics g, Dimension d, long genes, Point orig) {
        double ytickStep = orig.y / (this.numoptimize + 1);
        double x = orig.x;
        double y = 0.0;
        double xtickStep = ((double)d.width - (double)orig.x) / (double)(this.endperiod - this.iniperiod);
        long bitmask = BITMASK << this.getcodebit() - 1;
        bitmask ^= 0xFFFFFFFFFFFFFFFFL;
        for (int ix = 0; ix < this.OptimizationComponents.size(); ++ix) {
            planpro Tempplanpro = (planpro)this.OptimizationComponents.elementAt(ix);
            int auxint = (int)(genes & bitmask);
            if (auxint != 0) {
                g.setColor(Color.black);
                g.drawString(Tempplanpro.getText(), 4, (int)((double)(ix + 1) * ytickStep));
                g.setColor(Color.red);
                g.fillRect((int)((double)orig.x + (double)(auxint - 1) * xtickStep), (int)((double)(ix + 1) * ytickStep - ytickStep / 3.0), (int)((double)orig.x + (double)(Math.min(Tempplanpro.getexit_period(), this.endperiod) - (this.getiniperiod() + auxint - 1)) * xtickStep), (int)(ytickStep / 3.0 * 2.0));
                g.setColor(Color.black);
                g.drawRect((int)((double)orig.x + (double)(auxint - 1) * xtickStep), (int)((double)(ix + 1) * ytickStep - ytickStep / 3.0), (int)((double)orig.x + (double)(Math.min(Tempplanpro.getexit_period(), this.endperiod) - (this.getiniperiod() + auxint - 1)) * xtickStep), (int)(ytickStep / 3.0 * 2.0));
            }
            genes >>= this.getcodebit();
        }
    }

    public void RemoveSameElements(Pin[][] PinGrid, Schematic ActSchematic) {
        this.Modified = true;
        this.Modifiedstate = true;
        for (int ix = 0; ix < ActSchematic.size(); ++ix) {
            this.TempComponent = (comp)ActSchematic.Components.elementAt(ix);
            if (this.TempComponent instanceof ndb_comp) {
                this.changeGIS = true;
            }
            if (!this.Components.contains(this.TempComponent)) continue;
            this.TempComponent.RemovePinsGrid(PinGrid);
            this.removeComponent(this.TempComponent);
        }
    }

    public void DestroyComponents(Pin[][] PinGrid) {
        this.Modified = true;
        this.Modifiedstate = true;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (this.TempComponent instanceof ndb_comp) {
                this.changeGIS = true;
            }
            this.TempComponent.RemovePinsGrid(PinGrid);
        }
        this.removeAllComponents();
    }

    public double EvalInvest() {
        double sum = 0.0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_2pol)) continue;
            ndb_comp Tempndb = (ndb_comp)this.TempComponent;
            sum += Tempndb.getinvest(this.iniperiod, this.endperiod, this.intrate);
        }
        return sum;
    }

    public Point AdjustTopLeft() {
        Point ret = new Point(10000, 10000);
        Point PosCom = new Point();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !this.TempComponent.getvalid() || !this.TempComponent.isDrawnInSchematic()) continue;
            if (this.TempComponent instanceof Line) {
                Line TempLine = (Line)this.TempComponent;
                PosCom.x = Math.min(TempLine.x1, TempLine.x2);
                PosCom.y = Math.min(TempLine.y1, TempLine.y2);
            } else if (this.TempComponent instanceof mdb_wheel) {
                mdb_wheel Tempmdb_wheel = (mdb_wheel)this.TempComponent;
                PosCom.x = Math.min(Tempmdb_wheel.x1, Tempmdb_wheel.x2);
                PosCom.y = Math.min(Tempmdb_wheel.y1, Tempmdb_wheel.y2);
            } else if (this.TempComponent instanceof mdb_owner) {
                mdb_owner Tempmdb_owner = (mdb_owner)this.TempComponent;
                PosCom.x = Math.min(Tempmdb_owner.x1, Tempmdb_owner.x2);
                PosCom.y = Math.min(Tempmdb_owner.y1, Tempmdb_owner.y2);
            } else if (this.TempComponent instanceof hdb_link) {
                hdb_link Temphdblink = (hdb_link)this.TempComponent;
                PosCom.x = Math.min(Temphdblink.getx1(), Temphdblink.getx2());
                PosCom.y = Math.min(Temphdblink.gety1(), Temphdblink.gety2());
            } else {
                PosCom.x = this.TempComponent.Pos.x;
                PosCom.y = this.TempComponent.Pos.y;
            }
            if (PosCom.x < ret.x) {
                ret.x = PosCom.x;
            }
            if (PosCom.y >= ret.y) continue;
            ret.y = PosCom.y;
        }
        return ret;
    }

    public Point SearchBottonRight() {
        Point ret = new Point(0, 0);
        Point PosCom = new Point();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !this.TempComponent.getvalid() || !this.TempComponent.isDrawnInSchematic()) continue;
            if (this.TempComponent instanceof Line) {
                Line TempLine = (Line)this.TempComponent;
                PosCom.x = Math.max(TempLine.x1, TempLine.x2);
                PosCom.y = Math.max(TempLine.y1, TempLine.y2);
            } else if (this.TempComponent instanceof mdb_wheel) {
                mdb_wheel Tempmdb_wheel = (mdb_wheel)this.TempComponent;
                PosCom.x = Math.max(Tempmdb_wheel.x1, Tempmdb_wheel.x2);
                PosCom.y = Math.max(Tempmdb_wheel.y1, Tempmdb_wheel.y2);
            } else if (this.TempComponent instanceof mdb_owner) {
                mdb_owner Tempmdb_owner = (mdb_owner)this.TempComponent;
                PosCom.x = Math.max(Tempmdb_owner.x1, Tempmdb_owner.x2);
                PosCom.y = Math.max(Tempmdb_owner.y1, Tempmdb_owner.y2);
            } else if (this.TempComponent instanceof hdb_link) {
                hdb_link Temphdblink = (hdb_link)this.TempComponent;
                PosCom.x = Math.max(Temphdblink.getx1(), Temphdblink.getx2());
                PosCom.y = Math.max(Temphdblink.gety1(), Temphdblink.gety2());
            } else {
                PosCom.x = this.TempComponent.Pos.x + 50;
                PosCom.y = this.TempComponent.Pos.y + 50;
            }
            if (PosCom.x > ret.x) {
                ret.x = PosCom.x;
            }
            if (PosCom.y <= ret.y) continue;
            ret.y = PosCom.y;
        }
        return ret;
    }

    public Point AdjustSearchName(String searchname) {
        String string2;
        String string1;
        int ix;
        Point ret = new Point(100000, 100000);
        Point PosCom = new Point();
        int fin = this.Components.size();
        for (ix = 0; ix < fin; ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            string1 = this.TempComponent.getName();
            if (!string1.equalsIgnoreCase(string2 = searchname) || !this.TempComponent.getvalid() || !this.TempComponent.isDrawnInSchematic()) continue;
            this.TempComponent.setSelected(true);
            if (this.TempComponent instanceof ndb_comp) {
                this.changeGIS = true;
            }
            if (this.TempComponent instanceof Line) {
                Line TempLine = (Line)this.TempComponent;
                TempLine.ChangingWire = 3;
                PosCom.x = Math.min(TempLine.x1, TempLine.x2);
                PosCom.y = Math.min(TempLine.y1, TempLine.y2);
            } else if (this.TempComponent instanceof hdb_link) {
                hdb_link Temphdb_link = (hdb_link)this.TempComponent;
                PosCom.x = Math.min(Temphdb_link.x1, Temphdb_link.x2);
                PosCom.y = Math.min(Temphdb_link.y1, Temphdb_link.y2);
            } else if (this.TempComponent instanceof mdb_wheel) {
                mdb_wheel Tempmdb_wheel = (mdb_wheel)this.TempComponent;
                PosCom.x = Math.min(Tempmdb_wheel.x1, Tempmdb_wheel.x2);
                PosCom.y = Math.min(Tempmdb_wheel.y1, Tempmdb_wheel.y2);
            } else {
                PosCom.x = this.TempComponent.Pos.x;
                PosCom.y = this.TempComponent.Pos.y;
            }
            return PosCom;
        }
        for (ix = 0; ix < fin; ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            string1 = this.TempComponent.getName();
            string2 = searchname;
            if (!string1.toLowerCase().contains(string2.toLowerCase()) || !this.TempComponent.getvalid() || !this.TempComponent.isDrawnInSchematic()) continue;
            this.TempComponent.setSelected(true);
            if (this.TempComponent instanceof ndb_comp) {
                this.changeGIS = true;
            }
            if (this.TempComponent instanceof Line) {
                Line TempLine = (Line)this.TempComponent;
                TempLine.ChangingWire = 3;
                PosCom.x = Math.min(TempLine.x1, TempLine.x2);
                PosCom.y = Math.min(TempLine.y1, TempLine.y2);
            } else {
                PosCom.x = this.TempComponent.Pos.x;
                PosCom.y = this.TempComponent.Pos.y;
            }
            return PosCom;
        }
        return ret;
    }

    public void AssignControlArea(String ctrla) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)this.TempComponent;
            Tempndb.setctrla(ctrla);
        }
    }

    public void LoadScaling(double scalingfactor, String owner, String tipo) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            Load TempLoad;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Load) || ((TempLoad = (Load)this.TempComponent).getinv_owner().hashCode() != owner.hashCode() || !TempLoad.getinv_owner().equals(owner)) && !owner.equals("ALL LOADS") || (TempLoad.getinv_type().hashCode() != tipo.hashCode() || !TempLoad.getinv_type().equals(tipo)) && !tipo.equals("ALL LOADS")) continue;
            TempLoad.setpini(TempLoad.getpini() * scalingfactor / 100.0);
            TempLoad.setqini(TempLoad.getqini() * scalingfactor / 100.0);
            TempLoad.updateload(sref, this.actperiod, this.actmonth, this.loadfac1, this.loadfac2);
        }
    }

    public void LoadTLC(String daytype, String daytime, String owner, String ctrla) throws Exception {
        ResultSet rs = null;
        boolean more = false;
        Statement stmt = DeepEditFrame.conTLC.createStatement();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            Load TempLoad;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Load) || !this.TempComponent.getactive() || ((TempLoad = (Load)this.TempComponent).getinv_owner().hashCode() != owner.hashCode() || !TempLoad.getinv_owner().equals(owner)) && !owner.equals("ALL LOADS") || (TempLoad.getctrla().hashCode() != ctrla.hashCode() || !TempLoad.getctrla().equals(ctrla)) && !ctrla.equals("ALL CONTROL AREAS")) continue;
            String query = "SELECT " + TempLoad.getName() + " FROM " + daytype + " WHERE ZEIT = '" + daytime + "'";
            try {
                rs = stmt.executeQuery(query);
                more = rs.next();
            }
            catch (Exception e) {
                stmt.close();
                System.out.println("No load name: " + TempLoad.getName() + " found in TLC Database.");
            }
            if (!more) {
                System.out.println("No load name: " + TempLoad.getName() + " found in TLC Database.");
                stmt.close();
                return;
            }
            double pp = Double.valueOf(rs.getString(TempLoad.getName()));
            if (TempLoad.getpini() != 0.0) {
                TempLoad.setqini(TempLoad.getqini() / TempLoad.getpini() * pp);
            } else {
                System.out.println("Caution!!: for Load " + TempLoad.getName() + "cos(phi)=0");
            }
            TempLoad.setpini(pp);
            TempLoad.updateload(sref, this.actperiod, this.actmonth, this.loadfac1, this.loadfac2);
            rs.close();
        }
        stmt.close();
    }

    public void LoadTGD(String daytype, String daytime, String owner, String ctrla) throws Exception {
        ResultSet rs = null;
        boolean more = false;
        Statement stmt = DeepEditFrame.conTGD.createStatement();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            ndb_inj Tempinj;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_inj) || !this.TempComponent.getactive() || ((Tempinj = (ndb_inj)this.TempComponent).getinv_owner().hashCode() != owner.hashCode() || !Tempinj.getinv_owner().equals(owner)) && !owner.equals("ALL GENERATORS") || (Tempinj.getctrla().hashCode() != ctrla.hashCode() || !Tempinj.getctrla().equals(ctrla)) && !ctrla.equals("ALL CONTROL AREAS")) continue;
            String query = "SELECT " + Tempinj.getName() + " FROM " + daytype + " WHERE ZEIT = '" + daytime + "'";
            try {
                rs = stmt.executeQuery(query);
                more = rs.next();
            }
            catch (Exception e) {
                System.out.println("No Injection name: " + Tempinj.getName() + " found in TGD Database.");
            }
            if (!more) {
                System.out.println("No Injection name: " + Tempinj.getName() + " found in TGD Database.");
                stmt.close();
                return;
            }
            double pp = Double.valueOf(rs.getString(Tempinj.getName()));
            if (Tempinj.getp0() != 0.0) {
                Tempinj.setq0(Tempinj.getq0() / Tempinj.getp0() * pp);
            }
            Tempinj.setp0(pp);
            rs.close();
        }
        stmt.close();
    }

    public void LoadOwner(Choice MyChoice) {
        Vector<ndb_comp> v = new Vector<ndb_comp>();
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_comp)) continue;
            ndb_comp Tempndb = (ndb_comp)this.TempComponent;
            compare = false;
            for (int iv = 0; iv < v.size(); ++iv) {
                ndb_comp Tempndbb = (ndb_comp)v.elementAt(iv);
                if (Tempndb.getinv_owner().hashCode() != Tempndbb.getinv_owner().hashCode() || !Tempndb.getinv_owner().equals(Tempndbb.getinv_owner())) continue;
                compare = true;
            }
            if (compare) continue;
            v.addElement(Tempndb);
            MyChoice.addItem(Tempndb.getinv_owner());
        }
    }

    public void LoadOwner(List MyList) {
        Vector<Load> v = new Vector<Load>();
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)this.TempComponent;
            compare = false;
            for (int iv = 0; iv < v.size(); ++iv) {
                Load TempLoadb = (Load)v.elementAt(iv);
                if (TempLoad.getinv_owner().hashCode() != TempLoadb.getinv_owner().hashCode() || !TempLoad.getinv_owner().equals(TempLoadb.getinv_owner())) continue;
                compare = true;
            }
            if (compare) continue;
            v.addElement(TempLoad);
            MyList.add(TempLoad.getinv_owner());
        }
    }

    public void InjectionOwner(List MyList, String oowner, mdb_supDialog mydialog) {
        ArrayList<ndb_inj> lndb_inj = new ArrayList<ndb_inj>();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            ndb_inj Tempinj;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_inj) || !(Tempinj = (ndb_inj)this.TempComponent).getinv_owner().equalsIgnoreCase(oowner) && !Tempinj.getinv_owner().equalsIgnoreCase("None") && !Tempinj.getinv_owner().isEmpty() && !Tempinj.getinv_owner().equals("-")) continue;
            lndb_inj.add(Tempinj);
        }
        Utils.sortCompListByName(lndb_inj);
        int selec = 0;
        for (ndb_inj inj : lndb_inj) {
            MyList.add(inj.getName());
            mydialog.v.addElement(inj);
            if (inj.getinv_owner().equals(oowner)) {
                MyList.select(selec);
            }
            ++selec;
        }
    }

    public Vector InjectionOwner() {
        Vector<comp> lInjection = new Vector<comp>();
        for (Object o : this.Components) {
            comp tempComp = (comp)o;
            if (!(tempComp instanceof ndb_inj)) continue;
            lInjection.add(tempComp);
        }
        return lInjection;
    }

    public void mdb_actList(List MyList, SelectActorsDialog mydialog) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof mdb_sup) && !(this.TempComponent instanceof mdb_inv)) continue;
            mdb_act Tempact = (mdb_act)this.TempComponent;
            MyList.add(Tempact.getName());
            mydialog.v.addElement(Tempact);
        }
    }

    public void hdb_resList(List MyList, SelectReservoirsDialog mydialog) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof hdb_res)) continue;
            hdb_res Tempres = (hdb_res)this.TempComponent;
            MyList.add(Tempres.getName());
            mydialog.v.addElement(Tempres);
        }
    }

    public void busbarList(List MyList, SelectBusbarsDialog mydialog) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Busbar)) continue;
            Busbar Tempbus = (Busbar)this.TempComponent;
            MyList.add(Tempbus.getName());
            mydialog.v.addElement(Tempbus);
        }
    }

    public void InjectionOwner(List MyList, String oowner, mdb_invDialog mydialog) {
        int selec = 0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            ndb_inj Tempinj;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_inj) || ((Tempinj = (ndb_inj)this.TempComponent).getinv_owner().hashCode() != oowner.hashCode() || !Tempinj.getinv_owner().equals(oowner)) && (Tempinj.getinv_owner().hashCode() != "None".hashCode() || !Tempinj.getinv_owner().equals("None"))) continue;
            ++selec;
            MyList.add(Tempinj.getName());
            mydialog.v.addElement(Tempinj);
            if (Tempinj.getinv_owner().hashCode() != oowner.hashCode() || !Tempinj.getinv_owner().equals(oowner)) continue;
            MyList.select(selec - 1);
        }
    }

    public JList InjectionOwner(JList MyList, String elecpoint, hdb_unitDialog mydialog) {
        Vector<String> setGens = new Vector<String>();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            Generator Tempinj;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Generator) || !this.check_ndb_inj((Tempinj = (Generator)this.TempComponent).getName())) continue;
            setGens.add(Tempinj.getName());
            mydialog.v.addElement(Tempinj);
        }
        setGens.add("NEC");
        Collections.sort(setGens);
        MyList = new JList(setGens);
        return MyList;
    }

    public boolean check_ndb_inj(String injname) {
        for (int ixx = 0; ixx < this.Components.size(); ++ixx) {
            hdb_unit Tempunit;
            this.TempComponent = (comp)this.Components.elementAt(ixx);
            if (!(this.TempComponent instanceof hdb_unit) || !(Tempunit = (hdb_unit)this.TempComponent).getName().equals(injname)) continue;
            return false;
        }
        return true;
    }

    public void ndb_branchProject(List MyList, String pproject, planproDialog mydialog) {
        int selec = 0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            ndb_branch Tempbranch;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_branch) || ((Tempbranch = (ndb_branch)this.TempComponent).getproject().hashCode() != pproject.hashCode() || !Tempbranch.getproject().equals(pproject)) && (Tempbranch.getproject().hashCode() != "NONE".hashCode() || !Tempbranch.getproject().equals("NONE"))) continue;
            ++selec;
            MyList.add(Tempbranch.getName());
            mydialog.v.addElement(Tempbranch);
            if (Tempbranch.getproject().hashCode() != pproject.hashCode() || !Tempbranch.getproject().equals(pproject)) continue;
            MyList.select(selec - 1);
        }
    }

    public void hdb_compAgreement(List MyList, String aagreement, agreementDialog mydialog) {
        int selec = 0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof hdb_comp)) continue;
            hdb_comp Temphdb = (hdb_comp)this.TempComponent;
            ++selec;
            MyList.add(Temphdb.getName());
            mydialog.v.addElement(Temphdb);
        }
    }

    public void hdb_compAgreement(List MyList, String aagreement, PLPagreementDialog mydialog) {
        int selec = 0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof hdb_comp)) continue;
            hdb_comp Temphdb = (hdb_comp)this.TempComponent;
            ++selec;
            MyList.add(Temphdb.getName());
            mydialog.v.addElement(Temphdb);
        }
    }

    public void hdb_compAgreement(List MyList, String aagreement, SEEDS_AgreementDialog mydialog) {
        int selec = 0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof hdb_comp)) continue;
            hdb_comp Temphdb = (hdb_comp)this.TempComponent;
            ++selec;
            MyList.add(Temphdb.getName());
            mydialog.v.addElement(Temphdb);
        }
    }

    public void LoadOwner(List MyList, String oowner, mdb_custDialog mydialog) {
        ArrayList<Load> lLoads = new ArrayList<Load>();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            Load TempLoad;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Load) || !(TempLoad = (Load)this.TempComponent).getinv_owner().equalsIgnoreCase(oowner) && !TempLoad.getinv_owner().equalsIgnoreCase("None") && !TempLoad.getinv_owner().isEmpty() && !TempLoad.getinv_owner().equals("-")) continue;
            lLoads.add(TempLoad);
        }
        Utils.sortCompListByName(lLoads);
        int selec = 0;
        for (Load load : lLoads) {
            MyList.add(load.getName());
            mydialog.v.addElement(load);
            if (load.getinv_owner().equals(oowner)) {
                MyList.select(selec);
            }
            ++selec;
        }
    }

    public void Create_mdb_comp(String typeof, Pin[][] PinGrid, int XPos, int YPos, String Text, double alpha, double beta, double gamma, int entryperiod, int exitperiod, int entrymonth, int exitmonth, String logo, int level) {
        ndb_inj Tempinj;
        int ix;
        int owned = 0;
        Vector<ndb_1pol> v = new Vector<ndb_1pol>();
        boolean compare = false;
        if (typeof.equals("mdbcust")) {
            Load TempLoad;
            for (ix = 0; ix < this.Components.size(); ++ix) {
                this.TempComponent = (comp)this.Components.elementAt(ix);
                if (!(this.TempComponent instanceof Load) || !(TempLoad = (Load)this.TempComponent).getinv_owner().equals(Text)) continue;
                v.addElement(TempLoad);
                ++owned;
            }
            mdb_cust newcust = new mdb_cust(PinGrid, owned, XPos, YPos, Text, alpha, beta, gamma, entryperiod, exitperiod, entrymonth, exitmonth, logo, level);
            this.addComponent(newcust);
            for (ix = 0; ix < v.size(); ++ix) {
                TempLoad = (Load)v.elementAt(ix);
                newcust.addComponent(TempLoad);
            }
        }
        if (typeof.equals("mdbsup")) {
            for (ix = 0; ix < this.Components.size(); ++ix) {
                this.TempComponent = (comp)this.Components.elementAt(ix);
                if (!(this.TempComponent instanceof ndb_inj) || !(Tempinj = (ndb_inj)this.TempComponent).getinv_owner().equals(Text)) continue;
                v.addElement(Tempinj);
                ++owned;
            }
            mdb_sup newsup = new mdb_sup(PinGrid, owned, XPos, YPos, Text, alpha, beta, gamma, entryperiod, exitperiod, entrymonth, exitmonth, logo, level);
            this.addComponent(newsup);
            for (ix = 0; ix < v.size(); ++ix) {
                Tempinj = (ndb_inj)v.elementAt(ix);
                newsup.addComponent(Tempinj);
            }
        }
        if (typeof.equals("mdbinv")) {
            for (ix = 0; ix < this.Components.size(); ++ix) {
                this.TempComponent = (comp)this.Components.elementAt(ix);
                if (!(this.TempComponent instanceof ndb_inj) || !(Tempinj = (ndb_inj)this.TempComponent).getinv_owner().equals(Text)) continue;
                v.addElement(Tempinj);
                ++owned;
            }
            mdb_inv newinv = new mdb_inv(PinGrid, owned, XPos, YPos, Text, alpha, beta, gamma, entryperiod, exitperiod, entrymonth, exitmonth, logo, level);
            this.addComponent(newinv);
            for (ix = 0; ix < v.size(); ++ix) {
                Tempinj = (ndb_inj)v.elementAt(ix);
                newinv.addComponent(Tempinj);
            }
        }
    }

    public void AllOwner(Choice MyChoice) {
        Vector<ndb_comp> v = new Vector<ndb_comp>();
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_comp)) continue;
            ndb_comp TempElComponent = (ndb_comp)this.TempComponent;
            compare = false;
            for (int iv = 0; iv < v.size(); ++iv) {
                ndb_comp TempElComponentb = (ndb_comp)v.elementAt(iv);
                if (!TempElComponent.getinv_owner().equals(TempElComponentb.getinv_owner())) continue;
                compare = true;
            }
            if (compare) continue;
            v.addElement(TempElComponent);
            MyChoice.add(TempElComponent.getinv_owner());
        }
    }

    public void AllContract(Choice MyChoice) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof mdb_wheel)) continue;
            mdb_wheel Tempwheel = (mdb_wheel)this.TempComponent;
            MyChoice.addItem(Tempwheel.getparty2().getName() + "-" + Tempwheel.getparty1().getName());
        }
    }

    public void AllContract(List MyList) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof mdb_wheel)) continue;
            mdb_wheel Tempwheel = (mdb_wheel)this.TempComponent;
            MyList.add(Tempwheel.getparty2().getName() + "-" + Tempwheel.getparty1().getName());
        }
    }

    public void RepeatName(FileOutputStream os) throws IOException, FileFormatException {
        comp TempComponentb;
        int ix = 0;
        int iv = 0;
        Vector<comp> v = new Vector<comp>();
        Vector<comp> vv = new Vector<comp>();
        boolean compare = false;
        boolean correct = true;
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        myPrintStream.println("---------------------------");
        myPrintStream.println("Looking for doubled names: ");
        myPrintStream.println("---------------------------");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_comp)) continue;
            compare = false;
            for (iv = 0; iv < v.size(); ++iv) {
                TempComponentb = (comp)v.elementAt(iv);
                if (!this.TempComponent.getName().equalsIgnoreCase(TempComponentb.getName())) continue;
                myPrintStream.println("Double Name by Power System -Component: " + this.TempComponent.getName());
                compare = true;
                correct = false;
            }
            if (compare) continue;
            v.addElement(this.TempComponent);
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof mdb_comp)) continue;
            compare = false;
            for (iv = 0; iv < vv.size(); ++iv) {
                TempComponentb = (comp)vv.elementAt(iv);
                if (!this.TempComponent.getName().equalsIgnoreCase(TempComponentb.getName())) continue;
                myPrintStream.println("Double Name by Market-Component: " + this.TempComponent.getName());
                compare = true;
                correct = false;
            }
            if (compare) continue;
            vv.addElement(this.TempComponent);
        }
        if (correct) {
            myPrintStream.println("--- No double names in the System ---");
        }
        myPrintStream.println("--------------------------------");
        myPrintStream.println("End Statistics:");
        myPrintStream.println("-------------------------------");
        os.close();
    }

    public void LoadType(Choice MyChoice) {
        Vector<Load> v = new Vector<Load>();
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)this.TempComponent;
            compare = false;
            for (int iv = 0; iv < v.size(); ++iv) {
                Load TempLoadb = (Load)v.elementAt(iv);
                if (!TempLoad.getinv_type().equals(TempLoadb.getinv_type())) continue;
                compare = true;
            }
            if (compare) continue;
            v.addElement(TempLoad);
            MyChoice.addItem(TempLoad.getinv_type());
        }
    }

    public java.util.List<String> getCtrlaList() {
        ArrayList<String> lReturn = new ArrayList<String>();
        for (comp c : this.getComponents()) {
            ndb_comp ndb_c;
            if (!(c instanceof ndb_comp) || lReturn.contains((ndb_c = (ndb_comp)c).getctrla())) continue;
            lReturn.add(ndb_c.getctrla());
        }
        return lReturn;
    }

    public void LoadCtrla(Choice MyChoice) {
        for (String s : this.getCtrlaList()) {
            MyChoice.addItem(s);
        }
    }

    public void LoadCtrla(JComboBox MyChoice) {
        for (String s : this.getCtrlaList()) {
            MyChoice.addItem(s);
        }
    }

    public void LoadLevel(Choice MyChoice) {
        Vector<mdb_act> v = new Vector<mdb_act>();
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof mdb_act)) continue;
            mdb_act Tempmdb = (mdb_act)this.TempComponent;
            compare = false;
            for (int iv = 0; iv < v.size(); ++iv) {
                mdb_act Tempmdbb = (mdb_act)v.elementAt(iv);
                if (Tempmdb.getlevel() != Tempmdbb.getlevel()) continue;
                compare = true;
            }
            if (compare) continue;
            v.addElement(Tempmdb);
            MyChoice.addItem(String.valueOf(Tempmdb.getlevel()));
        }
    }

    public final boolean renameComp(String oldName, String newName, comp NewComponent) {
        comp oldComp;
        assert (newName.equals(NewComponent.getName())) : "Why are you trying to register an object with name '" + newName + "' different than it's own name '" + NewComponent.getName() + "'??";
        Map<String, comp> mClassList = this.DBObjects.get(NewComponent.getClassName());
        if (mClassList != null && (oldComp = mClassList.get(oldName)) != null) {
            if (mClassList.get(newName) == null) {
                if (oldComp.equals(NewComponent)) {
                    mClassList.remove(oldName);
                    mClassList.put(newName, NewComponent);
                    return true;
                }
                assert (!oldComp.getName().equals(newName)) : "Why are you registering an object with the same name of an existent one. Why createUniqueCompName(String) wasn't previous used??";
                return false;
            }
            if (oldComp.equals(NewComponent)) {
                mClassList.remove(oldName);
                mClassList.put(newName, NewComponent);
                return true;
            }
            assert (false) : "Why are you renaming a different object??";
            return false;
        }
        return false;
    }

    public final boolean isCompNameUnique(comp NewComponent) {
        return this.isCompNameUnique(NewComponent.getName(), NewComponent.getClassName());
    }

    public final boolean isCompNameUnique(String NewName, String className) {
        Map<String, comp> mClassList = this.DBObjects.get(className);
        if (mClassList == null) {
            mClassList = new HashMap<String, comp>();
        }
        return !mClassList.containsKey(NewName);
    }

    public final void addComponent(comp NewComponent) {
        Map<String, comp> mClassList;
        this.Modified = true;
        this.Modifiedstate = true;
        if (NewComponent instanceof ndb_comp) {
            this.changeGIS = true;
        }
        if ((mClassList = this.DBObjects.get(NewComponent.getClassName())) == null) {
            mClassList = new HashMap<String, comp>();
        }
        assert (!this.Components.contains(NewComponent)) : "Why are you adding the same component " + NewComponent.getName() + "  again?";
        comp oldComp = mClassList.put(NewComponent.getName(), NewComponent);
        if (oldComp != null) {
            String sName = NewComponent.getName();
            while (!this.isCompNameUnique(sName, NewComponent.getClassName())) {
                sName = StringUtil.createUniqueCompName(sName);
            }
            NewComponent.setName(sName);
            mClassList.put(sName, NewComponent);
        }
        this.DBObjects.put(NewComponent.getClassName(), mClassList);
        this.Components.addElement(NewComponent);
    }

    public final void removeComponent(comp ActComponent) {
        comp remComp;
        int nRemovedElements = 0;
        this.Modified = true;
        this.Modifiedstate = true;
        if (ActComponent instanceof ndb_comp) {
            this.changeGIS = true;
        }
        while (this.Components.removeElement(ActComponent)) {
            ++nRemovedElements;
        }
        if (nRemovedElements == 0) {
            assert (false) : "Why are you trying to delete component " + ActComponent.getName() + " if component didn't exist?";
        } else if (nRemovedElements > 1) assert (false) : "Why the component " + ActComponent.getName() + " was deleted " + nRemovedElements + " times??";
        nRemovedElements = 0;
        Map<String, comp> mClassList = this.DBObjects.get(ActComponent.getClassName());
        if (mClassList == null) {
            mClassList = new HashMap<String, comp>();
        }
        if ((remComp = mClassList.remove(ActComponent.getName())) == null) {
            for (String sKey : mClassList.keySet()) {
                if (!mClassList.get(sKey).getName().equals(ActComponent.getName())) continue;
                remComp = mClassList.remove(sKey);
                ++nRemovedElements;
                break;
            }
        } else {
            nRemovedElements = 1;
        }
        if (remComp != null) {
            this.updateConstraintCoefficients();
            if (remComp instanceof mdb_comp) {
                this.updateMarketOwnerships();
            }
            if (remComp instanceof hdb_comp) {
                this.updatehdbunit();
            }
            remComp = null;
        }
        assert (nRemovedElements == 1) : "Why are you trying to delete component " + ActComponent.getName() + " if component didn't exist?";
    }

    public void removeAllComponents() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.setSelected(false);
        }
        while (!this.Components.isEmpty()) {
            this.removeComponent((comp)this.Components.firstElement());
        }
        for (Map<String, comp> m : this.DBObjects.values()) {
            m.clear();
        }
        this.DBObjects.clear();
    }

    public comp SearchComponentByName(String compareClass, String compareName) {
        this.Modified = true;
        this.Modifiedstate = true;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            String compare = this.TempComponent.getName();
            if (!compare.equals(compareName)) continue;
            compare = this.TempComponent.getClassName();
            if (compare.equals(compareClass)) {
                return this.TempComponent;
            }
            if (!(this.TempComponent instanceof ndb_inj) || !compareClass.equals("ndb_inj")) continue;
            return this.TempComponent;
        }
        return null;
    }

    public void draw(Graphics2D g, int x, int y, int x2, int y2, int GridStep, boolean Short2, boolean Simulate, comp PrevSelectedComponent) {
        this.TempComponent = PrevSelectedComponent;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        if (Simulate) {
            ++this.count;
            if (this.count == 5) {
                this.cycle = !this.cycle;
            }
            for (int ix = 0; ix < this.Components.size(); ++ix) {
                this.TempComponent = (comp)this.Components.elementAt(ix);
                if (!this.TempComponent.CheckIfComponentInDrawArea(x, y, x2, y2) || !this.TempComponent.getactive() || !this.TempComponent.getvalid()) continue;
                if (this.TempComponent instanceof Line) {
                    Line TempLine = (Line)this.TempComponent;
                    TempLine.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref, this.actperiod, this.actmonth, this.typsim);
                    continue;
                }
                if (this.count != 5) continue;
                if (this.TempComponent instanceof ndb_inj) {
                    ndb_inj TempInj = (ndb_inj)this.TempComponent;
                    TempInj.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, sref, this.actperiod, this.actmonth, this.typsim);
                    continue;
                }
                if (this.TempComponent instanceof Trafo) {
                    Trafo TempTrafo = (Trafo)this.TempComponent;
                    TempTrafo.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof ThreeWindingTrafo) {
                    ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)this.TempComponent;
                    TempThreeWindingTrafo.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof LineDC) {
                    LineDC TempLineDC = (LineDC)this.TempComponent;
                    TempLineDC.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof Upfc) {
                    Upfc TempUpfc = (Upfc)this.TempComponent;
                    TempUpfc.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof Load) {
                    Load TempLoad = (Load)this.TempComponent;
                    TempLoad.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, sref, this.actperiod, this.actmonth, this.loadfac1, this.loadfac2, this.typsim);
                    continue;
                }
                if (!(this.TempComponent instanceof hdb_link)) continue;
                ((hdb_link)this.TempComponent).draw(g, x, y, GridStep, this.Modifiedstate);
            }
            if (this.count == 5) {
                this.count = 0;
            }
            return;
        }
        if (Short2 && this.TempComponent.getactive() && this.TempComponent.getvalid()) {
            if (this.TempComponent instanceof Load) {
                Load TempLoad = (Load)this.TempComponent;
                TempLoad.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, sref, this.actperiod, this.actmonth, this.loadfac1, this.loadfac2, this.typsim);
            }
            if (this.TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)this.TempComponent;
                TempInj.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, sref, this.actperiod, this.actmonth, this.typsim);
            } else if (this.TempComponent instanceof Line) {
                Line TempLine = (Line)this.TempComponent;
                TempLine.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref, this.actperiod, this.actmonth, this.typsim);
            } else if (this.TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)this.TempComponent;
                TempTrafo.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
            } else if (this.TempComponent instanceof ThreeWindingTrafo) {
                ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)this.TempComponent;
                TempThreeWindingTrafo.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
            } else if (this.TempComponent instanceof LineDC) {
                LineDC TempLineDC = (LineDC)this.TempComponent;
                TempLineDC.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
            } else if (this.TempComponent instanceof Upfc) {
                Upfc TempUpfc = (Upfc)this.TempComponent;
                TempUpfc.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
            } else if (this.TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)this.TempComponent;
                TempBusbar.draw(g, x, y, GridStep, this.Modifiedstate, sref, this.actperiod, this.actmonth, this.typsim);
            } else {
                this.TempComponent.draw(g, x, y, GridStep, this.Modifiedstate);
            }
        } else {
            for (int ix = 0; ix < this.Components.size(); ++ix) {
                this.TempComponent = (comp)this.Components.elementAt(ix);
                if (!this.TempComponent.CheckIfComponentInDrawArea(x, y, x2, y2) || !this.TempComponent.getactive() || !this.TempComponent.getvalid()) continue;
                if (this.TempComponent instanceof Load) {
                    Load TempLoad = (Load)this.TempComponent;
                    TempLoad.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, sref, this.actperiod, this.actmonth, this.loadfac1, this.loadfac2, this.typsim);
                    continue;
                }
                if (this.TempComponent instanceof ndb_inj) {
                    ndb_inj TempInj = (ndb_inj)this.TempComponent;
                    TempInj.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, sref, this.actperiod, this.actmonth, this.typsim);
                    continue;
                }
                if (this.TempComponent instanceof Line) {
                    Line TempLine = (Line)this.TempComponent;
                    TempLine.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref, this.actperiod, this.actmonth, this.typsim);
                    continue;
                }
                if (this.TempComponent instanceof Trafo) {
                    Trafo TempTrafo = (Trafo)this.TempComponent;
                    TempTrafo.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof ThreeWindingTrafo) {
                    ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)this.TempComponent;
                    TempThreeWindingTrafo.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof LineDC) {
                    LineDC TempLineDC = (LineDC)this.TempComponent;
                    TempLineDC.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof Upfc) {
                    Upfc TempUpfc = (Upfc)this.TempComponent;
                    TempUpfc.draw(g, x, y, GridStep, this.Modifiedstate, Simulate, this.cycle, this.ShowReactive, sref);
                    continue;
                }
                if (this.TempComponent instanceof Busbar) {
                    Busbar TempBusbar = (Busbar)this.TempComponent;
                    TempBusbar.draw(g, x, y, GridStep, this.Modifiedstate, sref, this.actperiod, this.actmonth, this.typsim);
                    continue;
                }
                this.TempComponent.draw(g, x, y, GridStep, this.Modifiedstate);
            }
        }
    }

    public int size() {
        return this.Components.size();
    }

    public boolean HasComponent(comp TempComponent) {
        return this.Components.contains(TempComponent);
    }

    public void CheckIfComponentsInSelectBox(Schematic SelectSchematic, int x1, int y1, int x2, int y2) {
        int swap;
        if (x1 > x2) {
            swap = x1;
            x1 = x2;
            x2 = swap;
        }
        if (y1 > y2) {
            swap = y1;
            y1 = y2;
            y2 = swap;
        }
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !this.TempComponent.getvalid() || !this.TempComponent.CheckIfComponentInSelectBox(x1, y1, x2, y2)) continue;
            SelectSchematic.addComponent(this.TempComponent);
        }
    }

    public void AdjustPosition(Pin[][] PinGrid, int x, int y) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.AdjustPosition(PinGrid, x, y);
        }
    }

    public void RemovePinsGrid(Pin[][] PinGrid) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.RemovePinsGrid(PinGrid);
        }
    }

    public void CheckPosition(DeepEdit app) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.CheckPosition(app);
        }
    }

    public void CheckActive() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.CheckActive(this.getactperiod(), this.getactmonth());
        }
    }

    public boolean assignJMap(JMapObject mo) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            Line TempLine;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Line) || !(TempLine = (Line)this.TempComponent).getName().equals(mo.getLabel())) continue;
            TempLine.setmo(mo);
            return true;
        }
        return false;
    }

    public void setLineCoordinates(PrintWriter mmyPrintStream) {
        PrintWriter myPrintStream = mmyPrintStream;
        ndb_1pol busbar = null;
        Line TempLine = null;
        double aux1 = 0.0;
        double aux2 = 0.0;
        double aux3 = 0.0;
        int auxi = 1;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent1;
            int ixx;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Line)) continue;
            TempLine = (Line)this.TempComponent;
            TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
            TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
            myPrintStream.println("line " + TempLine.getName());
            for (ixx = 0; ixx < this.Components.size(); ++ixx) {
                TempComponent1 = (comp)this.Components.elementAt(ixx);
                if (!(TempComponent1 instanceof Busbar) || !TempComponent1.getName().equals(TempLine.getcon1())) continue;
                busbar = (Busbar)TempComponent1;
                break;
            }
            aux1 = Math.abs(busbar.getlatitude());
            auxi = 1;
            if (busbar.getlatitude() <= 0.0) {
                auxi = -1;
            }
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            String latitude1 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            String latitude2 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            String latitude3 = String.valueOf((int)((double)auxi * aux2));
            aux1 = Math.abs(busbar.getlongitude());
            auxi = 1;
            if (busbar.getlongitude() <= 0.0) {
                auxi = -1;
            }
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            String longitude1 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            String longitude2 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            String longitude3 = String.valueOf((int)((double)auxi * aux2));
            myPrintStream.println("latlon " + latitude1 + " " + latitude2 + " " + latitude3 + " S " + longitude1 + " " + longitude2 + " " + longitude3 + " W");
            for (ixx = 0; ixx < this.Components.size(); ++ixx) {
                TempComponent1 = (comp)this.Components.elementAt(ixx);
                if (!(TempComponent1 instanceof Busbar) || !TempComponent1.getName().equals(TempLine.getcon2())) continue;
                busbar = (Busbar)TempComponent1;
                break;
            }
            aux1 = Math.abs(busbar.getlatitude());
            auxi = 1;
            if (busbar.getlatitude() <= 0.0) {
                auxi = -1;
            }
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            latitude1 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            latitude2 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            latitude3 = String.valueOf((int)((double)auxi * aux2));
            aux1 = Math.abs(busbar.getlongitude());
            auxi = 1;
            if (busbar.getlongitude() <= 0.0) {
                auxi = -1;
            }
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            longitude1 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            aux1 = (aux1 - aux2) * 60.0;
            longitude2 = String.valueOf((int)((double)auxi * aux2));
            aux2 = Math.floor(aux1);
            longitude3 = String.valueOf((int)((double)auxi * aux2));
            myPrintStream.println("latlon " + latitude1 + " " + latitude2 + " " + latitude3 + " S " + longitude1 + " " + longitude2 + " " + longitude3 + " W");
            myPrintStream.println("end (" + TempLine.getName() + ")");
        }
    }

    public void setEditor(DE_GeneralEnums.editor n) {
        block5: for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.setvalid(true);
            switch (n) {
                case Power: {
                    Caption TempCaption;
                    if (this.TempComponent instanceof Caption) {
                        TempCaption = (Caption)this.TempComponent;
                        if (TempCaption.getinv_owner().equals("Market")) {
                            this.TempComponent.setvalid(false);
                        }
                        if (TempCaption.getinv_owner().equals("Hydro")) {
                            this.TempComponent.setvalid(false);
                        }
                    }
                    if (this.TempComponent instanceof mdb_comp) {
                        this.TempComponent.setvalid(false);
                    }
                    if (!(this.TempComponent instanceof hdb_comp)) continue block5;
                    this.TempComponent.setvalid(false);
                    continue block5;
                }
                case Market: {
                    Caption TempCaption;
                    if (this.TempComponent instanceof Caption) {
                        TempCaption = (Caption)this.TempComponent;
                        if (TempCaption.getinv_owner().equals("Power")) {
                            this.TempComponent.setvalid(false);
                        }
                        if (TempCaption.getinv_owner().equals("Hydro")) {
                            this.TempComponent.setvalid(false);
                        }
                    }
                    if (this.TempComponent instanceof ndb_comp) {
                        this.TempComponent.setvalid(false);
                    }
                    if (this.TempComponent instanceof planpro) {
                        this.TempComponent.setvalid(false);
                    }
                    if (!(this.TempComponent instanceof hdb_comp)) continue block5;
                    this.TempComponent.setvalid(false);
                    continue block5;
                }
                case Hydro: {
                    Caption TempCaption;
                    if (this.TempComponent instanceof Caption) {
                        TempCaption = (Caption)this.TempComponent;
                        if (TempCaption.getinv_owner().equals("Power")) {
                            this.TempComponent.setvalid(false);
                        }
                        if (TempCaption.getinv_owner().equals("Market")) {
                            this.TempComponent.setvalid(false);
                        }
                    }
                    if (this.TempComponent instanceof ndb_comp) {
                        this.TempComponent.setvalid(false);
                    }
                    if (this.TempComponent instanceof planpro) {
                        this.TempComponent.setvalid(false);
                    }
                    if (!(this.TempComponent instanceof mdb_comp)) continue block5;
                    this.TempComponent.setvalid(false);
                    continue block5;
                }
                default: {
                    assert (false) : "How did you get here!!";
                    continue block5;
                }
            }
        }
    }

    public void PlacePinsHere(Pin[][] PinGrid) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.PlacePinsHere(PinGrid);
        }
    }

    public comp CheckIfComponentClicked(int x, int y) {
        for (int ix = this.Components.size() - 1; ix > -1; --ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !this.TempComponent.getvalid() || !this.TempComponent.CheckIfComponentClicked(x, y)) continue;
            return this.TempComponent;
        }
        return null;
    }

    public comp getComponentAt(int x, int y) {
        for (comp c : this.getComponents()) {
            if (!c.getactive() || !c.getvalid() || !c.isLocatedAt(x, y)) continue;
            return c;
        }
        return null;
    }

    public ComponentPin CheckIfComponentPinPosition(int x, int y) {
        for (int ix = this.Components.size() - 1; ix > -1; --ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!this.TempComponent.getactive() || !this.TempComponent.getvalid()) continue;
            if (this.TempComponent.InputPinInPosition(x, y) != null) {
                return this.TempComponent.InputPinInPosition(x, y);
            }
            if (this.TempComponent.OutputPinInPosition(x, y) == null) continue;
            return this.TempComponent.OutputPinInPosition(x, y);
        }
        return null;
    }

    public void SimulateSetUpFlows() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.TempComponent.SimulateSetUpFlows(sref);
        }
    }

    protected String NsrToDeep(String clr) {
        if ("NDB_gen".equals(clr)) {
            clr = "ndb_inj";
            return clr;
        }
        if ("NDB_node".equals(clr)) {
            clr = "Busbar";
            return clr;
        }
        if ("NDB_load".equals(clr)) {
            clr = "Load";
            return clr;
        }
        if ("NDB_line".equals(clr)) {
            clr = "Line";
            return clr;
        }
        if ("NDB_tran".equals(clr)) {
            clr = "Trafo";
            return clr;
        }
        if ("NDB_threewind".equals(clr)) {
            clr = "ThreeWindingTrafo";
            return clr;
        }
        if ("NDB_LineDC".equals(clr)) {
            clr = "LineDC";
            return clr;
        }
        if ("NDB_upfc".equals(clr)) {
            clr = "Upfc";
            return clr;
        }
        if ("NDB_wheel".equals(clr)) {
            clr = "mdb_wheel";
            return clr;
        }
        if ("System".equals(clr)) {
            clr = "System";
            return clr;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean LoadComponent(Pin[][] PinGrid, LineNumberReader is, StreamTokenizer st) throws IOException, FileFormatException {
        XPos = 0;
        YPos = 0;
        XPos2 = 0;
        YPos2 = 0;
        xpoly = new int[32];
        ypoly = new int[32];
        agreementcom = new String[10];
        ComponentName = st.sval;
        Text = " ";
        type = "None";
        owner = "None";
        ctrla = " ";
        alias = " ";
        logo = " ";
        place = " ";
        AuxText = " ";
        project = "NONE";
        alternative = "NONE";
        lado = " ";
        ladotap = " ";
        un1 = 0.0;
        un2 = 0.0;
        un3 = 0.0;
        ur1 = 0.0;
        ur2 = 0.0;
        ur3 = 0.0;
        umin = 0.9;
        umax = 1.1;
        sn = 0.0;
        sn1 = 0.0;
        sn2 = 0.0;
        us = 1.0;
        latitude = 0.0;
        longitude = 0.0;
        sst = 0.0;
        smax = 0.0;
        sc = 1.0;
        cost = 0.0;
        coym = 0.0;
        alpha = 0.0;
        beta = 0.0;
        gamma = 0.0;
        verhor = true;
        swapPS = false;
        suggest = false;
        inservice = true;
        isRegulTank = false;
        isStoch = true;
        grounded = true;
        lifetime = 0;
        lftype = 1;
        lftypes = 1;
        entryperiod = this.iniperiod;
        exitperiod = this.endperiod;
        entrymonth = 1;
        exitmonth = 12;
        filtType = 0;
        num = 2;
        prio = 0;
        planning = 0;
        maxt = 0;
        maxt1 = 0;
        maxt2 = 0;
        maxtg = 0;
        level = 1;
        sollt = 0.0;
        sollt1 = 0.0;
        sollt2 = 0.0;
        solltg = 0.0;
        t_im = 0.0;
        pmax = 0.0;
        pmin = 0.0;
        qmax = 0.0;
        qmin = 0.0;
        pveff = 12.0;
        coneff = 60.0;
        eqsurface = 10.0;
        zonalfactor = 1.0;
        CHPcoef = 1.0;
        eotype = "";
        eoheight = 0.0;
        rough = 0.1;
        wzone = "Zone0";
        p0 = 0.0;
        q0 = 0.0;
        pini = 0.0;
        qini = 0.0;
        r1 = 0.0;
        xx1 = 0.0;
        b1 = 0.0;
        g1 = 0.0;
        len = 0.0;
        incomep = 0.0;
        incomeq = 0.0;
        uk = 0.0;
        uk12 = 0.0;
        uk13 = 0.0;
        uk23 = 0.0;
        pcu = 0.0;
        pcu13 = 0.0;
        pcu23 = 0.0;
        pfe = 0.0;
        i0 = 0.0;
        z0z1 = 0.0;
        r0x0 = 0.0;
        pwheel = 0.0;
        qwheel = 0.0;
        percent = 0.0;
        controller = false;
        source = "None";
        energy = 0.0;
        ldc_T = 0.0;
        ldc_pmin = 0.0;
        ldc_pmax = 0.0;
        vd_p = 0.0;
        vd_q = 0.0;
        xs = 0.0;
        emin = 0.15;
        emax = 1.96;
        gradU = 10.0;
        gradD = 10.0;
        invstate = MMTool.invstate()[0];
        firstannyear = 0;
        firstannmonth = 0;
        grate = 0.0;
        pcontract = 0.0;
        qcontract = 0.0;
        zsl = 0.0;
        zslg = 0.0;
        zsl1 = 0.0;
        zsl2 = 0.0;
        excv = 0.0;
        boostv = 0.0;
        excang = 0.0;
        boostang = 0.0;
        pfinj = 0.0;
        qeinj = 0.0;
        qbinj = 0.0;
        pspec = 0.0;
        qspec = 0.0;
        vispec = 0.0;
        vspec = 0.0;
        bmax = 0.0;
        bmin = 0.0;
        iemax = 0.0;
        ibmax = 0.0;
        pdcmax = 0.0;
        sconv1 = 0.0;
        sconv2 = 0.0;
        var256_153 = 0.0;
        var258_154 = 0.0;
        var260_155 = 0.0;
        var262_156 = 0.0;
        var264_157 = " ";
        var265_158 = " ";
        var266_159 = " ";
        var267_160 = 0.0;
        var269_161 = 0.0;
        var271_162 = 0.0;
        var273_163 = 0.0;
        var275_164 = 0.0;
        var278_165 = false;
        var279_166 = false;
        var280_167 = false;
        var281_168 = false;
        var282_169 = false;
        var283_170 = false;
        var284_171 = false;
        var285_172 = false;
        var286_173 = 0.0;
        var288_174 = 0.0;
        var290_175 = 0.0;
        var292_176 = 0.0;
        var294_177 = 0.0;
        var296_178 = 0.0;
        var298_179 = 0.0;
        var300_180 = false;
        var301_181 = false;
        var302_182 = false;
        var303_183 = false;
        var304_184 = false;
        var305_185 = false;
        var306_186 = 1.0;
        var308_187 = 0.0;
        var310_188 = 0.0;
        var312_189 = 0.0;
        var314_190 = 0.0;
        var316_191 = 0.0;
        var318_192 = 1.0;
        var320_193 = 1.0;
        var322_194 = 1.0;
        var324_195 = 1.0;
        var326_196 = 1.0;
        var328_197 = 0.0;
        var330_198 = 0.0;
        var332_199 = 0.0;
        var334_200 = 0.0;
        var336_201 = 1.0;
        var338_202 = 1.0;
        var340_203 = 0.0;
        var342_204 = 9000.0;
        var344_205 = 0.0;
        var346_206 = 0.0;
        var348_207 = 9000.0;
        var350_208 = 100.0;
        var352_209 = " ";
        var353_210 = true;
        var354_211 = 0.0;
        var356_212 = 0.0;
        var358_213 = 0.0;
        var360_214 = 0.0;
        var362_215 = 0.0;
        var364_216 = 0.0;
        var366_217 = 0.0;
        var368_218 = 0.0;
        var370_219 = 0.0;
        var372_220 = 0.0;
        var374_221 = 0.0;
        var376_222 = 0.0;
        var378_223 = 0.0;
        var380_224 = 0.0;
        var382_225 = 0.0;
        var384_226 = 0.0;
        var386_227 = 0.0;
        var388_228 = 0.0;
        var390_229 = 0.0;
        var392_230 = false;
        while (ix < 10) {
            agreementcom[ix] = "";
            ++ix;
        }
        this.OSName = System.getProperty("os.name");
        block5: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block5;
                }
                case -3: {
                    if ("pos".equals(st.sval) && "pos".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            XPos = (int)st.nval;
                            if (st.nextToken() == -2) {
                                YPos = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("pospoly".equals(st.sval) && "pospoly".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            xpoly[++npoly - true] = (int)st.nval;
                            if (st.nextToken() == -2) {
                                ypoly[npoly - true] = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("Name".hashCode() == st.sval.hashCode() && "Name".equals(st.sval)) {
                        Text = is.readLine();
                        continue block5;
                    }
                    if ("sysname".hashCode() == st.sval.hashCode() && "sysname".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        this.setsysname(String.valueOf(st.sval));
                        continue block5;
                    }
                    if ("project".hashCode() == st.sval.hashCode() && "project".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        project = String.valueOf(st.sval);
                        continue block5;
                    }
                    if ("agreementcom".hashCode() == st.sval.hashCode() && "agreementcom".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        agreementcom[nag] = String.valueOf(st.sval);
                        ++nag;
                        continue block5;
                    }
                    if ("alternative".hashCode() == st.sval.hashCode() && "alternative".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        alternative = String.valueOf(st.sval);
                        continue block5;
                    }
                    if ("sref".hashCode() == st.sval.hashCode() && "sref".equals(st.sval)) {
                        AuxText = is.readLine();
                        Schematic.sref = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("loadfac1".hashCode() == st.sval.hashCode() && "loadfac1".equals(st.sval)) {
                        AuxText = is.readLine();
                        this.loadfac1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("loadfac2".hashCode() == st.sval.hashCode() && "loadfac2".equals(st.sval)) {
                        AuxText = is.readLine();
                        this.loadfac2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("intrate".hashCode() == st.sval.hashCode() && "intrate".equals(st.sval)) {
                        AuxText = is.readLine();
                        this.intrate = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("planning".hashCode() == st.sval.hashCode() && "planning".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            planning = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("iniperiod".hashCode() == st.sval.hashCode() && "iniperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.iniperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("endperiod".hashCode() == st.sval.hashCode() && "endperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.endperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("filtType".hashCode() == st.sval.hashCode() && "filtType".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            filtType = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("actperiod".hashCode() == st.sval.hashCode() && "actperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.actperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("inimonth".hashCode() == st.sval.hashCode() && "inimonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.inimonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("endmonth".hashCode() == st.sval.hashCode() && "endmonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.endmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("actmonth".hashCode() == st.sval.hashCode() && "actmonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.actmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("SS".hashCode() == st.sval.hashCode() && "SS".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            SS = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("WS".hashCode() == st.sval.hashCode() && "WS".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            WS = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("actday".hashCode() == st.sval.hashCode() && "actday".equals(st.sval)) {
                        this.setactday(String.valueOf(is.readLine()));
                        continue block5;
                    }
                    if ("actdaytype".hashCode() == st.sval.hashCode() && "actdaytype".equals(st.sval)) {
                        this.setactdaytype(String.valueOf(is.readLine()));
                        continue block5;
                    }
                    if ("acthour".hashCode() == st.sval.hashCode() && "acthour".equals(st.sval)) {
                        this.setacthour(String.valueOf(is.readLine()));
                        continue block5;
                    }
                    if ("stepperiod".hashCode() == st.sval.hashCode() && "stepperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.stepperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("stepmonth".hashCode() == st.sval.hashCode() && "stepmonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.stepmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("peaksim".hashCode() == st.sval.hashCode() && "peaksim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        this.peaksim = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("meansim".hashCode() == st.sval.hashCode() && "meansim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        this.meansim = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("lowsim".hashCode() == st.sval.hashCode() && "lowsim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        this.lowsim = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("isRegulTank".hashCode() == st.sval.hashCode() && "isRegulTank".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        isRegulTank = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("isStoch".hashCode() == st.sval.hashCode() && "isStoch".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        isStoch = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("grounded".hashCode() == st.sval.hashCode() && "grounded".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        grounded = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("ElGeName".hashCode() == st.sval.hashCode() && "ElGeName".equals(st.sval)) {
                        elgename = is.readLine();
                        continue block5;
                    }
                    if ("customsim".hashCode() == st.sval.hashCode() && "customsim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        this.customsim = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("load".hashCode() == st.sval.hashCode() && "load".equals(st.sval)) {
                        load = is.readLine();
                        continue block5;
                    }
                    if ("inj".hashCode() == st.sval.hashCode() && "inj".equals(st.sval)) {
                        inj = is.readLine();
                        continue block5;
                    }
                    if ("type".hashCode() == st.sval.hashCode() && "type".equals(st.sval)) {
                        type = is.readLine();
                        continue block5;
                    }
                    if ("lado".hashCode() == st.sval.hashCode() && "lado".equals(st.sval)) {
                        lado = is.readLine();
                        continue block5;
                    }
                    if ("ladotap".hashCode() == st.sval.hashCode() && "ladotap".equals(st.sval)) {
                        ladotap = is.readLine();
                        continue block5;
                    }
                    if ("eotype".hashCode() == st.sval.hashCode() && "eotype".equals(st.sval)) {
                        eotype = is.readLine();
                        continue block5;
                    }
                    if ("wzone".hashCode() == st.sval.hashCode() && "wzone".equals(st.sval)) {
                        wzone = is.readLine();
                        continue block5;
                    }
                    if ("owner".hashCode() == st.sval.hashCode() && "owner".equals(st.sval)) {
                        owner = is.readLine();
                        if (!owner.equals("null") || !owner.equals("Power")) continue block5;
                        owner = "None";
                        continue block5;
                    }
                    if ("ctrla".hashCode() == st.sval.hashCode() && "ctrla".equals(st.sval)) {
                        ctrla = is.readLine();
                        continue block5;
                    }
                    if ("alias".hashCode() == st.sval.hashCode() && "alias".equals(st.sval)) {
                        alias = is.readLine();
                        continue block5;
                    }
                    if ("logo".hashCode() == st.sval.hashCode() && "logo".equals(st.sval)) {
                        logo = is.readLine();
                        continue block5;
                    }
                    if ("place".hashCode() == st.sval.hashCode() && "place".equals(st.sval)) {
                        place = is.readLine();
                        continue block5;
                    }
                    if ("currency".hashCode() == st.sval.hashCode() && "currency".equals(st.sval)) {
                        currency = is.readLine();
                        continue block5;
                    }
                    if ("ldc_T".hashCode() == st.sval.hashCode() && "ldc_T".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_T = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("ldc_pmax".hashCode() == st.sval.hashCode() && "ldc_pmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_pmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("ldc_pmin".hashCode() == st.sval.hashCode() && "ldc_pmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_pmin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("vd_p".hashCode() == st.sval.hashCode() && "vd_p".equals(st.sval)) {
                        AuxText = is.readLine();
                        vd_p = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("vd_q".hashCode() == st.sval.hashCode() && "vd_q".equals(st.sval)) {
                        AuxText = is.readLine();
                        vd_q = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("xs".hashCode() == st.sval.hashCode() && "xs".equals(st.sval)) {
                        AuxText = is.readLine();
                        xs = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("emin".hashCode() == st.sval.hashCode() && "emin".equals(st.sval)) {
                        AuxText = is.readLine();
                        emin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("emax".hashCode() == st.sval.hashCode() && "emax".equals(st.sval)) {
                        AuxText = is.readLine();
                        emax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("gradU".hashCode() == st.sval.hashCode() && "gradU".equals(st.sval)) {
                        AuxText = is.readLine();
                        gradU = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("gradD".hashCode() == st.sval.hashCode() && "gradD".equals(st.sval)) {
                        AuxText = is.readLine();
                        gradD = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("invstate".hashCode() == st.sval.hashCode() && "invstate".equals(st.sval)) {
                        invstate = AuxText = is.readLine();
                        continue block5;
                    }
                    if ("source".hashCode() == st.sval.hashCode() && "source".equals(st.sval)) {
                        source = AuxText = is.readLine();
                        continue block5;
                    }
                    if ("firstannyear".hashCode() == st.sval.hashCode() && "firstannyear".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            firstannyear = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("firstannmonth".hashCode() == st.sval.hashCode() && "firstannmonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            firstannmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("un1".hashCode() == st.sval.hashCode() && "un1".equals(st.sval)) {
                        AuxText = is.readLine();
                        un1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("ur1".hashCode() == st.sval.hashCode() && "ur1".equals(st.sval)) {
                        AuxText = is.readLine();
                        ur1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("ur2".hashCode() == st.sval.hashCode() && "ur2".equals(st.sval)) {
                        AuxText = is.readLine();
                        ur2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("ur3".hashCode() == st.sval.hashCode() && "ur3".equals(st.sval)) {
                        AuxText = is.readLine();
                        ur3 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("latitude".hashCode() == st.sval.hashCode() && "latitude".equals(st.sval)) {
                        AuxText = is.readLine();
                        latitude = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("longitude".hashCode() == st.sval.hashCode() && "longitude".equals(st.sval)) {
                        AuxText = is.readLine();
                        longitude = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("us".hashCode() == st.sval.hashCode() && "us".equals(st.sval)) {
                        AuxText = is.readLine();
                        us = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("un2".hashCode() == st.sval.hashCode() && "un2".equals(st.sval)) {
                        AuxText = is.readLine();
                        un2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("un3".hashCode() == st.sval.hashCode() && "un3".equals(st.sval)) {
                        AuxText = is.readLine();
                        un3 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("umin".hashCode() == st.sval.hashCode() && "umin".equals(st.sval)) {
                        AuxText = is.readLine();
                        umin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("umax".hashCode() == st.sval.hashCode() && "umax".equals(st.sval)) {
                        AuxText = is.readLine();
                        umax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sn".hashCode() == st.sval.hashCode() && "sn".equals(st.sval)) {
                        AuxText = is.readLine();
                        sn = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sn1".hashCode() == st.sval.hashCode() && "sn1".equals(st.sval)) {
                        AuxText = is.readLine();
                        sn1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sn2".hashCode() == st.sval.hashCode() && "sn2".equals(st.sval)) {
                        AuxText = is.readLine();
                        sn2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("xd".hashCode() == st.sval.hashCode() && "xd".equals(st.sval)) {
                        AuxText = is.readLine();
                        xd = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("xd1".hashCode() == st.sval.hashCode() && "xd1".equals(st.sval)) {
                        AuxText = is.readLine();
                        xd1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("xd2".hashCode() == st.sval.hashCode() && "xd2".equals(st.sval)) {
                        AuxText = is.readLine();
                        xd2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("st".hashCode() == st.sval.hashCode() && "st".equals(st.sval)) {
                        AuxText = is.readLine();
                        sst = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("smax".hashCode() == st.sval.hashCode() && "smax".equals(st.sval)) {
                        AuxText = is.readLine();
                        smax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sc".hashCode() == st.sval.hashCode() && "sc".equals(st.sval)) {
                        AuxText = is.readLine();
                        sc = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("energy".hashCode() == st.sval.hashCode() && "energy".equals(st.sval)) {
                        AuxText = is.readLine();
                        energy = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pwheel".hashCode() == st.sval.hashCode() && "pwheel".equals(st.sval)) {
                        AuxText = is.readLine();
                        pwheel = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qwheel".hashCode() == st.sval.hashCode() && "qwheel".equals(st.sval)) {
                        AuxText = is.readLine();
                        qwheel = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("percent".hashCode() == st.sval.hashCode() && "percent".equals(st.sval)) {
                        AuxText = is.readLine();
                        percent = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("controller".hashCode() == st.sval.hashCode() && "controller".equals(st.sval)) {
                        AuxText = is.readLine();
                        controller = Boolean.valueOf(AuxText);
                        continue block5;
                    }
                    if ("source".hashCode() == st.sval.hashCode() && "source".equals(st.sval)) {
                        source = AuxText = is.readLine();
                        continue block5;
                    }
                    if ("pcontract".hashCode() == st.sval.hashCode() && "pcontract".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcontract = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qcontract".hashCode() == st.sval.hashCode() && "qcontract".equals(st.sval)) {
                        AuxText = is.readLine();
                        qcontract = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("cost".hashCode() == st.sval.hashCode() && "cost".equals(st.sval)) {
                        AuxText = is.readLine();
                        cost = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("coym".hashCode() == st.sval.hashCode() && "coym".equals(st.sval)) {
                        AuxText = is.readLine();
                        coym = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("verhor".hashCode() == st.sval.hashCode() && "verhor".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        verhor = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("suggest".hashCode() == st.sval.hashCode() && "suggest".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        suggest = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("swapPS".hashCode() == st.sval.hashCode() && "swapPS".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        swapPS = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("inservice".hashCode() == st.sval.hashCode() && "inservice".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        inservice = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("CvPLP".hashCode() == st.sval.hashCode() && "CvPLP".equals(st.sval)) {
                        AuxText = is.readLine();
                        CvPLP = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("fcaPLP".hashCode() == st.sval.hashCode() && "fcaPLP".equals(st.sval)) {
                        AuxText = is.readLine();
                        fcaPLP = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("inServiceVPQ".hashCode() == st.sval.hashCode() && "inServiceVPQ".equals(st.sval)) {
                        if (st.nextToken() == -3) {
                            inServiceV = Boolean.valueOf(st.sval);
                        }
                        if (st.nextToken() == -3) {
                            inServiceP = Boolean.valueOf(st.sval);
                        }
                        if (st.nextToken() != -3) continue block5;
                        inServiceQ = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("fromLFVPQ".hashCode() == st.sval.hashCode() && "fromLFVPQ".equals(st.sval)) {
                        if (st.nextToken() == -3) {
                            fromLFV = Boolean.valueOf(st.sval);
                        }
                        if (st.nextToken() == -3) {
                            fromLFP = Boolean.valueOf(st.sval);
                        }
                        if (st.nextToken() == -3) {
                            fromLFQ = Boolean.valueOf(st.sval);
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("value2VPQ".hashCode() == st.sval.hashCode() && "value2VPQ".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            value2V = st.nval;
                        }
                        if (st.nextToken() == -2) {
                            value2P = st.nval;
                        }
                        if (st.nextToken() == -2) {
                            value2P = st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("value1VPQ".hashCode() == st.sval.hashCode() && "value1VPQ".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            value2V = st.nval;
                        }
                        if (st.nextToken() == -2) {
                            value2P = st.nval;
                        }
                        if (st.nextToken() == -2) {
                            value2P = st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("TM".hashCode() == st.sval.hashCode() && "TM".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        TM = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("StarStopC".hashCode() == st.sval.hashCode() && "StarStopC".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        StarStopC = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("TMH".hashCode() == st.sval.hashCode() && "TMH".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        TMH = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("on".hashCode() == st.sval.hashCode() && "on".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block5;
                        on = Boolean.valueOf(st.sval);
                        continue block5;
                    }
                    if ("alpha".hashCode() == st.sval.hashCode() && "alpha".equals(st.sval)) {
                        AuxText = is.readLine();
                        alpha = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("beta".hashCode() == st.sval.hashCode() && "beta".equals(st.sval)) {
                        AuxText = is.readLine();
                        beta = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("gamma".hashCode() == st.sval.hashCode() && "gamma".equals(st.sval)) {
                        AuxText = is.readLine();
                        gamma = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("grate".hashCode() == st.sval.hashCode() && "grate".equals(st.sval)) {
                        AuxText = is.readLine();
                        grate = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pveff".hashCode() == st.sval.hashCode() && "pveff".equals(st.sval)) {
                        AuxText = is.readLine();
                        pveff = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("coneff".hashCode() == st.sval.hashCode() && "coneff".equals(st.sval)) {
                        AuxText = is.readLine();
                        coneff = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("eqsurface".hashCode() == st.sval.hashCode() && "eqsurface".equals(st.sval)) {
                        AuxText = is.readLine();
                        eqsurface = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("zonalfactor".hashCode() == st.sval.hashCode() && "zonalfactor".equals(st.sval)) {
                        AuxText = is.readLine();
                        zonalfactor = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("CHPcoef".hashCode() == st.sval.hashCode() && "CHPcoef".equals(st.sval)) {
                        AuxText = is.readLine();
                        CHPcoef = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("eoheight".hashCode() == st.sval.hashCode() && "eoheight".equals(st.sval)) {
                        AuxText = is.readLine();
                        eoheight = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("rough".hashCode() == st.sval.hashCode() && "rough".equals(st.sval)) {
                        AuxText = is.readLine();
                        rough = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pmax".hashCode() == st.sval.hashCode() && "pmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        pmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pmin".hashCode() == st.sval.hashCode() && "pmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        pmin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("p0".hashCode() == st.sval.hashCode() && "p0".equals(st.sval)) {
                        AuxText = is.readLine();
                        p0 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("q0".hashCode() == st.sval.hashCode() && "q0".equals(st.sval)) {
                        AuxText = is.readLine();
                        q0 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qmax".hashCode() == st.sval.hashCode() && "qmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        qmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qmin".hashCode() == st.sval.hashCode() && "qmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        qmin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("r1".hashCode() == st.sval.hashCode() && "r1".equals(st.sval)) {
                        AuxText = is.readLine();
                        r1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("xx1".hashCode() == st.sval.hashCode() && "xx1".equals(st.sval)) {
                        AuxText = is.readLine();
                        xx1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("b1".hashCode() == st.sval.hashCode() && "b1".equals(st.sval)) {
                        AuxText = is.readLine();
                        b1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("g1".hashCode() == st.sval.hashCode() && "g1".equals(st.sval)) {
                        AuxText = is.readLine();
                        g1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pini".hashCode() == st.sval.hashCode() && "pini".equals(st.sval)) {
                        AuxText = is.readLine();
                        pini = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("incomep".hashCode() == st.sval.hashCode() && "incomep".equals(st.sval)) {
                        AuxText = is.readLine();
                        incomep = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("incomeq".hashCode() == st.sval.hashCode() && "incomeq".equals(st.sval)) {
                        AuxText = is.readLine();
                        incomeq = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("uk".hashCode() == st.sval.hashCode() && "uk".equals(st.sval)) {
                        AuxText = is.readLine();
                        uk = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("uk12".hashCode() == st.sval.hashCode() && "uk12".equals(st.sval)) {
                        AuxText = is.readLine();
                        uk12 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("uk13".hashCode() == st.sval.hashCode() && "uk13".equals(st.sval)) {
                        AuxText = is.readLine();
                        uk13 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("uk23".hashCode() == st.sval.hashCode() && "uk23".equals(st.sval)) {
                        AuxText = is.readLine();
                        uk23 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pcu".hashCode() == st.sval.hashCode() && "pcu".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcu = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pcu13".hashCode() == st.sval.hashCode() && "pcu13".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcu13 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pcu23".hashCode() == st.sval.hashCode() && "pcu23".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcu23 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pfe".hashCode() == st.sval.hashCode() && "pfe".equals(st.sval)) {
                        AuxText = is.readLine();
                        pfe = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("i0".hashCode() == st.sval.hashCode() && "i0".equals(st.sval)) {
                        AuxText = is.readLine();
                        i0 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("z0z1".hashCode() == st.sval.hashCode() && "z0z1".equals(st.sval)) {
                        AuxText = is.readLine();
                        z0z1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("r0x0".hashCode() == st.sval.hashCode() && "r0x0".equals(st.sval)) {
                        AuxText = is.readLine();
                        r0x0 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qini".hashCode() == st.sval.hashCode() && "qini".equals(st.sval)) {
                        AuxText = is.readLine();
                        qini = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("len".hashCode() == st.sval.hashCode() && "len".equals(st.sval)) {
                        AuxText = is.readLine();
                        len = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("excv".hashCode() == st.sval.hashCode() && "excv".equals(st.sval)) {
                        AuxText = is.readLine();
                        excv = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("boostv".hashCode() == st.sval.hashCode() && "boostv".equals(st.sval)) {
                        AuxText = is.readLine();
                        boostv = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("excang".hashCode() == st.sval.hashCode() && "excang".equals(st.sval)) {
                        AuxText = is.readLine();
                        excang = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("boostang".hashCode() == st.sval.hashCode() && "boostang".equals(st.sval)) {
                        AuxText = is.readLine();
                        boostang = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pfinj".hashCode() == st.sval.hashCode() && "pfinj".equals(st.sval)) {
                        AuxText = is.readLine();
                        pfinj = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qeinj".hashCode() == st.sval.hashCode() && "qeinj".equals(st.sval)) {
                        AuxText = is.readLine();
                        qeinj = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qbinj".hashCode() == st.sval.hashCode() && "qbinj".equals(st.sval)) {
                        AuxText = is.readLine();
                        qbinj = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pspec".hashCode() == st.sval.hashCode() && "pspec".equals(st.sval)) {
                        AuxText = is.readLine();
                        pspec = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qspec".hashCode() == st.sval.hashCode() && "qspec".equals(st.sval)) {
                        AuxText = is.readLine();
                        qspec = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("vispec".hashCode() == st.sval.hashCode() && "vispec".equals(st.sval)) {
                        AuxText = is.readLine();
                        vispec = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("vspec".hashCode() == st.sval.hashCode() && "vspec".equals(st.sval)) {
                        AuxText = is.readLine();
                        vspec = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("emax".hashCode() == st.sval.hashCode() && "emax".equals(st.sval)) {
                        AuxText = is.readLine();
                        emax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("bmax".hashCode() == st.sval.hashCode() && "bmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        bmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("emin".hashCode() == st.sval.hashCode() && "emin".equals(st.sval)) {
                        AuxText = is.readLine();
                        emin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("bmin".hashCode() == st.sval.hashCode() && "bmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        bmin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("iemax".hashCode() == st.sval.hashCode() && "iemax".equals(st.sval)) {
                        AuxText = is.readLine();
                        iemax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("ibmax".hashCode() == st.sval.hashCode() && "ibmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        ibmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("pdcmax".hashCode() == st.sval.hashCode() && "pdcmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        pdcmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sconv1".hashCode() == st.sval.hashCode() && "sconv1".equals(st.sval)) {
                        AuxText = is.readLine();
                        sconv1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sconv2".hashCode() == st.sval.hashCode() && "sconv2".equals(st.sval)) {
                        AuxText = is.readLine();
                        sconv2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("rexc".hashCode() == st.sval.hashCode() && "rexc".equals(st.sval)) {
                        AuxText = is.readLine();
                        rexc = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("xexc".hashCode() == st.sval.hashCode() && "xexc".equals(st.sval)) {
                        AuxText = is.readLine();
                        xexc = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("rboost".hashCode() == st.sval.hashCode() && "rboost".equals(st.sval)) {
                        AuxText = is.readLine();
                        rboost = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("xboost".hashCode() == st.sval.hashCode() && "xboost".equals(st.sval)) {
                        AuxText = is.readLine();
                        xboost = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("nbridge".hashCode() == st.sval.hashCode() && "nbridge".equals(st.sval)) {
                        AuxText = is.readLine();
                        nbridge = Integer.valueOf(AuxText);
                        continue block5;
                    }
                    if ("Q".hashCode() == st.sval.hashCode() && "Q".equals(st.sval)) {
                        AuxText = is.readLine();
                        Q = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("renser".hashCode() == st.sval.hashCode() && "renser".equals(st.sval)) {
                        AuxText = is.readLine();
                        renser = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("renres1".hashCode() == st.sval.hashCode() && "renres1".equals(st.sval)) {
                        AuxText = is.readLine();
                        renres1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("renres2".hashCode() == st.sval.hashCode() && "renres2".equals(st.sval)) {
                        AuxText = is.readLine();
                        renres2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("renres3".hashCode() == st.sval.hashCode() && "renres3".equals(st.sval)) {
                        AuxText = is.readLine();
                        renres3 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("renres4".hashCode() == st.sval.hashCode() && "renres4".equals(st.sval)) {
                        AuxText = is.readLine();
                        renres4 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("renres5".hashCode() == st.sval.hashCode() && "renres5".equals(st.sval)) {
                        AuxText = is.readLine();
                        renres5 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("filres1".hashCode() == st.sval.hashCode() && "filres1".equals(st.sval)) {
                        AuxText = is.readLine();
                        filres1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("filres2".hashCode() == st.sval.hashCode() && "filres2".equals(st.sval)) {
                        AuxText = is.readLine();
                        filres2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("filres3".hashCode() == st.sval.hashCode() && "filres3".equals(st.sval)) {
                        AuxText = is.readLine();
                        filres3 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("filres4".hashCode() == st.sval.hashCode() && "filres4".equals(st.sval)) {
                        AuxText = is.readLine();
                        filres4 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("filres5".hashCode() == st.sval.hashCode() && "filres5".equals(st.sval)) {
                        AuxText = is.readLine();
                        filres5 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("Vmin".hashCode() == st.sval.hashCode() && "Vmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        Vmin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("Vmax".hashCode() == st.sval.hashCode() && "Vmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        Vmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("Vini".hashCode() == st.sval.hashCode() && "Vini".equals(st.sval)) {
                        AuxText = is.readLine();
                        Vini = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("Vfin".hashCode() == st.sval.hashCode() && "Vfin".equals(st.sval)) {
                        AuxText = is.readLine();
                        Vfin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("f".hashCode() == st.sval.hashCode() && "f".equals(st.sval)) {
                        AuxText = is.readLine();
                        f = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("Wat2PowRate".hashCode() == st.sval.hashCode() && "Wat2PowRate".equals(st.sval)) {
                        AuxText = is.readLine();
                        wat2powrate = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("WaterVal".hashCode() == st.sval.hashCode() && "WaterVal".equals(st.sval)) {
                        AuxText = is.readLine();
                        waterVal = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("SpillMin".hashCode() == st.sval.hashCode() && "SpillMin".equals(st.sval)) {
                        AuxText = is.readLine();
                        spillmin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("SpillMax".hashCode() == st.sval.hashCode() && "SpillMax".equals(st.sval)) {
                        AuxText = is.readLine();
                        spillmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("AvfiltFact".hashCode() == st.sval.hashCode() && "AvfiltFact".equals(st.sval)) {
                        AuxText = is.readLine();
                        avfiltf = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("TurbMin".hashCode() == st.sval.hashCode() && "TurbMin".equals(st.sval)) {
                        AuxText = is.readLine();
                        turbmin = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("TurbMax".hashCode() == st.sval.hashCode() && "TurbMax".equals(st.sval)) {
                        AuxText = is.readLine();
                        turbmax = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("lresis".hashCode() == st.sval.hashCode() && "lresis".equals(st.sval)) {
                        AuxText = is.readLine();
                        lresis = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("potdrec".hashCode() == st.sval.hashCode() && "potdrec".equals(st.sval)) {
                        AuxText = is.readLine();
                        potdrec = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("vinv".hashCode() == st.sval.hashCode() && "vinv".equals(st.sval)) {
                        AuxText = is.readLine();
                        vinv = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("mintapr".hashCode() == st.sval.hashCode() && "mintapr".equals(st.sval)) {
                        AuxText = is.readLine();
                        mintapr = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("mintapi".hashCode() == st.sval.hashCode() && "mintapi".equals(st.sval)) {
                        AuxText = is.readLine();
                        mintapi = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("maxtapr".hashCode() == st.sval.hashCode() && "maxtapr".equals(st.sval)) {
                        AuxText = is.readLine();
                        maxtapr = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("maxtapi".hashCode() == st.sval.hashCode() && "maxtapi".equals(st.sval)) {
                        AuxText = is.readLine();
                        maxtapi = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("minfir".hashCode() == st.sval.hashCode() && "minfir".equals(st.sval)) {
                        AuxText = is.readLine();
                        minfir = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("minext".hashCode() == st.sval.hashCode() && "minext".equals(st.sval)) {
                        AuxText = is.readLine();
                        minext = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("maxfir".hashCode() == st.sval.hashCode() && "maxfir".equals(st.sval)) {
                        AuxText = is.readLine();
                        maxfir = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("maxext".hashCode() == st.sval.hashCode() && "maxext".equals(st.sval)) {
                        AuxText = is.readLine();
                        maxext = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("resrec".hashCode() == st.sval.hashCode() && "resrec".equals(st.sval)) {
                        AuxText = is.readLine();
                        resrec = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("resinv".hashCode() == st.sval.hashCode() && "resinv".equals(st.sval)) {
                        AuxText = is.readLine();
                        resinv = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("reacrec".hashCode() == st.sval.hashCode() && "reacrec".equals(st.sval)) {
                        AuxText = is.readLine();
                        reacrec = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("reacinv".hashCode() == st.sval.hashCode() && "reacinv".equals(st.sval)) {
                        AuxText = is.readLine();
                        reacinv = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sv".hashCode() == st.sval.hashCode() && "sv".equals(st.sval)) {
                        AuxText = is.readLine();
                        sv = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qrect".hashCode() == st.sval.hashCode() && "qrect".equals(st.sval)) {
                        AuxText = is.readLine();
                        qrect = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("qinver".hashCode() == st.sval.hashCode() && "qinver".equals(st.sval)) {
                        AuxText = is.readLine();
                        qinver = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("lifetime".hashCode() == st.sval.hashCode() && "lifetime".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            lifetime = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("lftype".hashCode() == st.sval.hashCode() && "lftype".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            lftype = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("lftypes".hashCode() == st.sval.hashCode() && "lftypes".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            lftypes = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("prio".hashCode() == st.sval.hashCode() && "prio".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            prio = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("num".hashCode() == st.sval.hashCode() && "num".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            num = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("zsl".hashCode() == st.sval.hashCode() && "zsl".equals(st.sval)) {
                        AuxText = is.readLine();
                        zsl = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("zsl1".hashCode() == st.sval.hashCode() && "zsl1".equals(st.sval)) {
                        AuxText = is.readLine();
                        zsl1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("zsl2".hashCode() == st.sval.hashCode() && "zsl2".equals(st.sval)) {
                        AuxText = is.readLine();
                        zsl2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("zslg".hashCode() == st.sval.hashCode() && "zslg".equals(st.sval)) {
                        AuxText = is.readLine();
                        zslg = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("maxt".hashCode() == st.sval.hashCode() && "maxt".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            maxt = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("maxt1".hashCode() == st.sval.hashCode() && "maxt1".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            maxt1 = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("maxt2".hashCode() == st.sval.hashCode() && "maxt2".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            maxt2 = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("maxtg".hashCode() == st.sval.hashCode() && "maxtg".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            maxtg = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("sollt".hashCode() == st.sval.hashCode() && "sollt".equals(st.sval)) {
                        AuxText = is.readLine();
                        sollt = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sollt1".hashCode() == st.sval.hashCode() && "sollt1".equals(st.sval)) {
                        AuxText = is.readLine();
                        sollt1 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("sollt2".hashCode() == st.sval.hashCode() && "sollt2".equals(st.sval)) {
                        AuxText = is.readLine();
                        sollt2 = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("solltg".hashCode() == st.sval.hashCode() && "solltg".equals(st.sval)) {
                        AuxText = is.readLine();
                        solltg = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("t_im".hashCode() == st.sval.hashCode() && "t_im".equals(st.sval)) {
                        AuxText = is.readLine();
                        t_im = Double.valueOf(AuxText);
                        continue block5;
                    }
                    if ("entryperiod".hashCode() == st.sval.hashCode() && "entryperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            entryperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("exitperiod".hashCode() == st.sval.hashCode() && "exitperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            exitperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("entrymonth".hashCode() == st.sval.hashCode() && "entrymonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            entrymonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("exitmonth".hashCode() == st.sval.hashCode() && "exitmonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            exitmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("entrymon".hashCode() == st.sval.hashCode() && "entrymon".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            entrymonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("exitmon".hashCode() == st.sval.hashCode() && "exitmon".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            exitmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("pos2".hashCode() == st.sval.hashCode() && "pos2".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            XPos2 = (int)st.nval;
                            if (st.nextToken() == -2) {
                                YPos2 = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block5;
                            st.nextToken();
                        }
                    }
                    if ("end".hashCode() == st.sval.hashCode() && "end".equals(st.sval) && st.nextToken() == -3 && "describe".hashCode() == st.sval.hashCode() && "describe".equals(st.sval)) ** break;
                    continue block5;
                    if (alias.equals(" ")) {
                        alias = Text;
                    }
                    if ("Busbar".hashCode() == ComponentName.hashCode() && "Busbar".equals(ComponentName)) {
                        this.addComponent(new Busbar(PinGrid, num, XPos, YPos, Text, type, alias, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, umin, umax, latitude, longitude, inservice));
                    } else if ("Injection".hashCode() == ComponentName.hashCode() && "Injection".equals(ComponentName)) {
                        this.addComponent(new Injection(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pmin, pmax, qmin, qmax, alpha, beta, gamma, sn, sst, latitude, longitude));
                    } else if ("System".hashCode() != ComponentName.hashCode() || !"System".equals(ComponentName)) {
                        if ("Generator".hashCode() == ComponentName.hashCode() && "Generator".equals(ComponentName)) {
                            this.addComponent(new Generator(PinGrid, XPos, YPos, Text, type, alias, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pmin, pmax, qmin, qmax, p0, q0, alpha, beta, gamma, sn, sst, lftype, lftypes, us, latitude, longitude, inservice, xd, xd1, xd2, CvPLP, xs, emin, emax, gradU, gradD, invstate, source, firstannyear, firstannmonth));
                        } else if ("GeneratorPV".hashCode() == ComponentName.hashCode() && "GeneratorPV".equals(ComponentName)) {
                            this.addComponent(new GeneratorPV(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pmin, pmax, qmin, qmax, p0, q0, alpha, beta, gamma, sn, sst, lftype, lftypes, us, latitude, longitude, inservice, xd, xd1, xd2, CvPLP, pveff, coneff, eqsurface, zonalfactor, wzone));
                        } else if ("GeneratorDG".hashCode() == ComponentName.hashCode() && "GeneratorDG".equals(ComponentName)) {
                            this.addComponent(new GeneratorDG(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pmin, pmax, qmin, qmax, p0, q0, alpha, beta, gamma, sn, sst, lftype, lftypes, us, latitude, longitude, inservice, xd, xd1, xd2, CvPLP));
                        } else if ("GeneratorEO".hashCode() == ComponentName.hashCode() && "GeneratorEO".equals(ComponentName)) {
                            this.addComponent(new GeneratorEO(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pmin, pmax, qmin, qmax, p0, q0, alpha, beta, gamma, sn, sst, lftype, lftypes, us, latitude, longitude, inservice, xd, xd1, xd2, CvPLP, coneff, zonalfactor, eotype, eoheight, rough, wzone));
                        } else if ("GeneratorCHP".hashCode() == ComponentName.hashCode() && "GeneratorCHP".equals(ComponentName)) {
                            this.addComponent(new GeneratorCHP(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pmin, pmax, qmin, qmax, p0, q0, alpha, beta, gamma, sn, sst, lftype, lftypes, us, latitude, longitude, inservice, xd, xd1, xd2, CvPLP, coneff, CHPcoef, wzone));
                        } else if ("SVC".hashCode() == ComponentName.hashCode() && "SVC".equals(ComponentName)) {
                            this.addComponent(new SVC(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, qmin, qmax, q0, alpha, beta, gamma, sn, sst, lftype, lftypes, us, latitude, longitude));
                        } else if ("hdbaffl".hashCode() == ComponentName.hashCode() && "hdbaffl".equals(ComponentName)) {
                            this.addComponent(new hdb_affl(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, Q, latitude, longitude, isStoch));
                        } else if ("Load".hashCode() == ComponentName.hashCode() && "Load".equals(ComponentName)) {
                            this.addComponent(new Load(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, pini, qini, alpha, beta, gamma, ldc_T, ldc_pmin, ldc_pmax, grate, latitude, longitude, place, inservice, fcaPLP, vd_p, vd_q));
                        } else if ("Line".hashCode() == ComponentName.hashCode() && "Line".equals(ComponentName)) {
                            this.addComponent(new Line(PinGrid, XPos, YPos, XPos2, YPos2, Text, type, alias, owner, ctrla, cost, coym, un1, un1, smax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, r1, xx1, g1, b1, len, xpoly, ypoly, (int)npoly, sn, planning, project, alternative, suggest, sc, inservice));
                        } else if ("hdblink".hashCode() == ComponentName.hashCode() && "hdblink".equals(ComponentName)) {
                            this.addComponent(new hdb_link(PinGrid, XPos, YPos, XPos2, YPos2, Text, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, xpoly, ypoly, (int)npoly));
                        } else if ("mdbwheel".hashCode() == ComponentName.hashCode() && "mdbwheel".equals(ComponentName)) {
                            this.addComponent(new mdb_wheel(PinGrid, XPos, YPos, XPos2, YPos2, Text, pwheel, qwheel, pcontract, qcontract, prio, entryperiod, exitperiod, entrymonth, exitmonth, pmax, energy));
                        } else if ("mdbowner".hashCode() == ComponentName.hashCode() && "mdbowner".equals(ComponentName)) {
                            this.addComponent(new mdb_owner(PinGrid, XPos, YPos, XPos2, YPos2, Text, percent, controller, source, entryperiod, exitperiod, entrymonth, exitmonth));
                        } else if ("mdbsup".hashCode() == ComponentName.hashCode() && "mdbsup".equals(ComponentName)) {
                            this.Create_mdb_comp("mdbsup", PinGrid, XPos, YPos, Text, alpha, beta, gamma, entryperiod, exitperiod, entrymonth, exitmonth, logo, level);
                        } else if ("mdbinv".hashCode() == ComponentName.hashCode() && "mdbinv".equals(ComponentName)) {
                            this.Create_mdb_comp("mdbinv", PinGrid, XPos, YPos, Text, alpha, beta, gamma, entryperiod, exitperiod, entrymonth, exitmonth, logo, level);
                        } else if ("mdbcust".hashCode() == ComponentName.hashCode() && "mdbcust".equals(ComponentName)) {
                            this.Create_mdb_comp("mdbcust", PinGrid, XPos, YPos, Text, alpha, beta, gamma, entryperiod, exitperiod, entrymonth, exitmonth, logo, level);
                        } else if ("Trafo".hashCode() == ComponentName.hashCode() && "Trafo".equals(ComponentName)) {
                            this.addComponent(new Trafo(PinGrid, XPos, YPos, Text, type, alias, owner, ctrla, cost, coym, un1, un2, ur1, ur2, smax, sn, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, uk, pcu, pfe, i0, z0z1, r0x0, verhor, swapPS, planning, zsl, maxt, sollt, t_im, project, alternative, suggest, sc, inservice));
                        } else if ("ThreeWindingTrafo".hashCode() == ComponentName.hashCode() && "ThreeWindingTrafo".equals(ComponentName)) {
                            this.addComponent(new ThreeWindingTrafo(PinGrid, XPos, YPos, Text, type, alias, owner, ctrla, cost, coym, un1, un2, un3, ur1, ur2, ur3, smax, sn, sn1, sn2, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, uk12, uk13, uk23, pcu, pcu13, pcu23, lado, ladotap, pfe, i0, z0z1, r0x0, verhor, swapPS, planning, zsl, zsl1, zsl2, zslg, maxt, maxt1, maxt2, maxtg, sollt, sollt1, sollt2, solltg, project, alternative, suggest, sc, inservice));
                        } else if ("LineDC".hashCode() == ComponentName.hashCode() && "LineDC".equals(ComponentName)) {
                            this.addComponent(new LineDC(PinGrid, XPos, YPos, Text, type, alias, owner, ctrla, cost, coym, un1, un2, potdrec, lresis, smax, sn, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, mintapr, mintapi, maxtapr, maxtapi, sv, len, verhor, swapPS, planning, minext, minfir, maxext, maxfir, resrec, resinv, reacrec, reacinv, vinv, nbridge, qrect, qinver, project, alternative, suggest, sc, inservice));
                        } else if ("Upfc".hashCode() == ComponentName.hashCode() && "Upfc".equals(ComponentName)) {
                            this.addComponent(new Upfc(PinGrid, XPos, YPos, Text, type, owner, ctrla, cost, coym, un1, un2, smax, sn, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, incomep, incomeq, excv, boostv, excang, boostang, pfinj, qeinj, qbinj, pspec, qspec, vispec, vspec, emax, bmax, emin, bmin, iemax, ibmax, pdcmax, sconv1, sconv2, rexc, xexc, rboost, xboost, verhor, swapPS, planning, project, alternative, suggest, sc));
                        } else if ("hdbpaspur".hashCode() == ComponentName.hashCode() && "hdbpaspur".equals(ComponentName)) {
                            this.addComponent(new hdb_paspur(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, latitude, longitude, wat2powrate, spillmin, spillmax, isRegulTank, grounded));
                        } else if ("hdbser".hashCode() == ComponentName.hashCode() && "hdbser".equals(ComponentName)) {
                            this.addComponent(new hdb_ser(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, latitude, longitude, wat2powrate, spillmin, spillmax, turbmin, turbmax, grounded));
                        } else if ("hdbirr".hashCode() == ComponentName.hashCode() && "hdbirr".equals(ComponentName)) {
                            this.addComponent(new hdb_irr(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, latitude, longitude, spillmin, spillmax));
                        } else if ("hdbres".hashCode() == ComponentName.hashCode() && "hdbres".equals(ComponentName)) {
                            this.addComponent(new hdb_res(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, Vmin, Vmax, Vini, Vfin, latitude, longitude, wat2powrate, waterVal, spillmin, spillmax, avfiltf, filtType, turbmin, turbmax, elgename, grounded));
                        } else if ("Caption".hashCode() == ComponentName.hashCode() && "Caption".equals(ComponentName)) {
                            this.addComponent(new Caption(XPos, YPos, Text, entryperiod, exitperiod, entrymonth, exitmonth, owner));
                        } else if ("planpro".hashCode() == ComponentName.hashCode() && "planpro".equals(ComponentName)) {
                            this.addComponent(new planpro(XPos, YPos, Text, entryperiod, exitperiod, entrymonth, exitmonth, owner));
                        } else if ("Probe".hashCode() == ComponentName.hashCode() && "Probe".equals(ComponentName)) {
                            this.addComponent(new Probe(PinGrid, XPos, YPos, Text, false, false, entryperiod, exitperiod, entrymonth, exitmonth, inServiceV, inServiceP, inServiceQ, fromLFV, fromLFP, fromLFQ, (double)value1V, (double)value1P, (double)value1Q, value2V, value2P, (double)value2Q));
                        } else if ("agreement".hashCode() == ComponentName.hashCode() && "agreement".equals(ComponentName)) {
                            this.addComponent(new agreement(XPos, YPos, Text, entryperiod, exitperiod, entrymonth, exitmonth, owner, agreementcom, type, place));
                        } else if ("mdbiso".hashCode() == ComponentName.hashCode() && "mdbiso".equals(ComponentName)) {
                            this.addComponent(new mdb_iso(PinGrid, XPos, YPos, Text, entryperiod, exitperiod, entrymonth, exitmonth));
                        } else {
                            System.out.println("Possible Error with Component Name: " + ComponentName + "(" + st.sval + ")");
                            return false;
                        }
                    }
                    return true;
                }
            }
            break;
        }
        return true;
    }

    public Schematic(Pin[][] PinGrid) throws Exception {
        this();
        boolean SchematicCorrupt = false;
        DeepEdit.updateProgressFrame();
        String query = "SELECT  * FROM System";
        this.selectDB(PinGrid, "System", query);
        DeepEdit.setProgressFrameLabel("Loading System Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Busbar";
        this.selectDB(PinGrid, "Busbar", query);
        DeepEdit.setProgressFrameLabel("Loading Busbar Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Injection";
        this.selectDB(PinGrid, "Injection", query);
        DeepEdit.setProgressFrameLabel("Loading Injection Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Generator";
        this.selectDB(PinGrid, "Generator", query);
        query = "SELECT  * FROM GeneratorPV";
        this.selectDB(PinGrid, "GeneratorPV", query);
        query = "SELECT  * FROM GeneratorDG";
        this.selectDB(PinGrid, "GeneratorDG", query);
        query = "SELECT  * FROM GeneratorEO";
        this.selectDB(PinGrid, "GeneratorEO", query);
        query = "SELECT  * FROM GeneratorCHP";
        this.selectDB(PinGrid, "GeneratorCHP", query);
        DeepEdit.setProgressFrameLabel("Loading Generator Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM SVC";
        this.selectDB(PinGrid, "SVC", query);
        DeepEdit.setProgressFrameLabel("Loading SVC Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Load";
        this.selectDB(PinGrid, "Load", query);
        DeepEdit.setProgressFrameLabel("Loading Load Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Line";
        this.selectDB(PinGrid, "Line", query);
        DeepEdit.setProgressFrameLabel("Loading Line Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Trafo";
        DeepEdit.setProgressFrameLabel("Loading Trafo Information: ");
        this.selectDB(PinGrid, "Trafo", query);
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM ThreeWindingTrafo";
        DeepEdit.setProgressFrameLabel("Loading Three Winding Trafo Information: ");
        this.selectDB(PinGrid, "ThreeWindingTrafo", query);
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM LineDC";
        DeepEdit.setProgressFrameLabel("Loading LineDC Information: ");
        this.selectDB(PinGrid, "LineDC", query);
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Upfc";
        DeepEdit.setProgressFrameLabel("Loading Upfc Information: ");
        this.selectDB(PinGrid, "Upfc", query);
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM Caption";
        this.selectDB(PinGrid, "Caption", query);
        DeepEdit.setProgressFrameLabel("Loading Comments Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM planpro";
        this.selectDB(PinGrid, "planpro", query);
        query = "SELECT * FROM Probe";
        this.selectDB(PinGrid, "Probe", query);
        DeepEdit.setProgressFrameLabel("Loading Probe Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM agreement";
        this.selectDB(PinGrid, "agreement", query);
        DeepEdit.setProgressFrameLabel("Loading Planning Projects Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM mdb_sup";
        this.selectDB(PinGrid, "mdb_sup", query);
        DeepEdit.setProgressFrameLabel("Loading Supplier Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM mdb_inv";
        this.selectDB(PinGrid, "mdb_inv", query);
        DeepEdit.setProgressFrameLabel("Loading Investor Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM mdb_cust";
        this.selectDB(PinGrid, "mdb_cust", query);
        DeepEdit.setProgressFrameLabel("Loading Customer Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM mdb_iso";
        this.selectDB(PinGrid, "mdb_iso", query);
        DeepEdit.setProgressFrameLabel("Loading ISO Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM mdb_wheel";
        this.selectDB(PinGrid, "mdb_wheel", query);
        DeepEdit.setProgressFrameLabel("Loading Contract Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM mdb_owner";
        this.selectDB(PinGrid, "mdb_owner", query);
        DeepEdit.setProgressFrameLabel("Loading Owner Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM hdb_affl";
        this.selectDB(PinGrid, "hdb_affl", query);
        DeepEdit.setProgressFrameLabel("Loading Affluent Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM hdb_link";
        this.selectDB(PinGrid, "hdb_link", query);
        DeepEdit.setProgressFrameLabel("Loading Link Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM hdb_paspur";
        this.selectDB(PinGrid, "hdb_paspur", query);
        DeepEdit.setProgressFrameLabel("Loading Pasada Pura Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM hdb_ser";
        this.selectDB(PinGrid, "hdb_ser", query);
        query = "SELECT  * FROM hdb_irr";
        this.selectDB(PinGrid, "hdb_irr", query);
        DeepEdit.setProgressFrameLabel("Loading Serie Information: ");
        DeepEdit.updateProgressFrame();
        query = "SELECT  * FROM hdb_res";
        this.selectDB(PinGrid, "hdb_res", query);
        DeepEdit.setProgressFrameLabel("Loading Reservoir Information: ");
        DeepEdit.updateProgressFrame();
        this.Modified = false;
        this.Modifiedstate = true;
        this.changeGIS = true;
        this.updateload();
        this.updatehdbunit();
        this.CheckActive();
        if (SchematicCorrupt) {
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Unknown data in schematic. Schematic could be corrupt.";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading Database schematic", this.message, DlgButtons, 1, 0, 0, 2);
        }
    }

    void selectDB(Pin[][] PinGrid, String ComponentName, String query) throws SQLException {
        int[] xpoly = new int[32];
        int[] ypoly = new int[32];
        int npoly = 0;
        int ix = 0;
        double un1 = -1.0;
        String Name = "-1";
        String[] agreementcom = new String[10];
        Statement stmt = DeepEditFrame.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        for (ix = 0; ix < 10; ++ix) {
            agreementcom[ix] = "";
        }
        boolean more = rs.next();
        if (!more) {
            System.out.println("No " + ComponentName + " found.");
            return;
        }
        while (more) {
            double un2;
            if ("System".equals(ComponentName)) {
                this.setsysname(rs.getString("sysname").trim());
                sref = rs.getFloat("sref");
                this.loadfac1 = rs.getFloat("loadfac1");
                this.loadfac2 = rs.getFloat("loadfac2");
                this.intrate = rs.getFloat("intrate");
                this.iniperiod = rs.getInt("iniperiod");
                this.endperiod = rs.getInt("endperiod");
                this.actperiod = rs.getInt("actperiod");
                this.actday = rs.getString("actday");
                this.actdaytype = rs.getString("actdaytype");
                this.acthour = rs.getString("acthour");
                this.actmonth = rs.getInt("actmonth");
                this.stepperiod = rs.getInt("stepperiod");
                this.peaksim = rs.getBoolean("peaksim");
                this.meansim = rs.getBoolean("meansim");
                this.lowsim = rs.getBoolean("lowsim");
                this.customsim = rs.getBoolean("customsim");
            }
            if ("Probe".equals(ComponentName)) {
                Name = rs.getString("Name");
                this.addComponent(new Probe(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, false, false, rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getBoolean("inServiceV"), rs.getBoolean("inServiceP"), rs.getBoolean("inServiceQ"), rs.getBoolean("fromLFV"), rs.getBoolean("fromLFP"), rs.getBoolean("fromLFQ"), rs.getFloat("value1V"), rs.getFloat("value1P"), rs.getFloat("value1Q"), rs.getFloat("value2V"), rs.getFloat("value2P"), rs.getFloat("value2Q")));
            }
            if ("Line".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                npoly = rs.getInt("numpoly");
                Name = rs.getString("Name").trim();
                for (ix = 0; ix < npoly; ++ix) {
                    xpoly[ix] = rs.getInt("pospolyx" + String.valueOf(ix + 1));
                    ypoly[ix] = rs.getInt("pospolyy" + String.valueOf(ix + 1));
                }
                this.addComponent(new Line(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), rs.getInt("XPos2"), rs.getInt("YPos2"), Name, rs.getString("type").trim(), StringUtil.nonNullString(rs.getString("alias")).trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), rs.getFloat("coym"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("incomep"), rs.getFloat("incomeq"), rs.getFloat("r1"), rs.getFloat("xx1"), rs.getFloat("g1"), rs.getFloat("b1"), rs.getFloat("len"), xpoly, ypoly, npoly, rs.getFloat("sn"), rs.getInt("planning"), rs.getString("project").trim(), rs.getString("alternative").trim(), rs.getBoolean("suggest"), rs.getFloat("sc"), rs.getBoolean("inservice")));
            }
            if ("Generator".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new Generator(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), StringUtil.nonNullString(rs.getString("alias")).trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("pmin"), rs.getFloat("pmax"), rs.getFloat("qmin"), rs.getFloat("qmax"), rs.getFloat("p0"), rs.getFloat("q0"), rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getFloat("sn"), rs.getFloat("st"), rs.getInt("lftype"), rs.getInt("lftypes"), rs.getFloat("us"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getBoolean("inservice"), rs.getFloat("xd"), rs.getFloat("xd1"), rs.getFloat("xd2"), rs.getFloat("CvPLP"), rs.getFloat("xs"), rs.getFloat("emin"), rs.getFloat("emax"), rs.getFloat("gradU"), rs.getFloat("gradD"), rs.getString("invstate"), rs.getString("source"), rs.getInt("firstannyear"), rs.getInt("firstannmonth")));
            }
            if ("GeneratorPV".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new GeneratorPV(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("pmin"), rs.getFloat("pmax"), rs.getFloat("qmin"), rs.getFloat("qmax"), rs.getFloat("p0"), rs.getFloat("q0"), rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getFloat("sn"), rs.getFloat("st"), rs.getInt("lftype"), rs.getInt("lftypes"), rs.getFloat("us"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getBoolean("inservice"), rs.getFloat("xd"), rs.getFloat("xd1"), rs.getFloat("xd2"), rs.getFloat("CvPLP"), rs.getFloat("pveff"), rs.getFloat("coneff"), rs.getFloat("eqsurface"), rs.getFloat("zonalfactor"), rs.getString("wzone")));
            }
            if ("GeneratorDG".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new GeneratorDG(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("pmin"), rs.getFloat("pmax"), rs.getFloat("qmin"), rs.getFloat("qmax"), rs.getFloat("p0"), rs.getFloat("q0"), rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getFloat("sn"), rs.getFloat("st"), rs.getInt("lftype"), rs.getInt("lftypes"), rs.getFloat("us"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getBoolean("inservice"), rs.getFloat("xd"), rs.getFloat("xd1"), rs.getFloat("xd2"), rs.getFloat("CvPLP")));
            }
            if ("GeneratorEO".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new GeneratorEO(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), (double)rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), (double)rs.getFloat("pmin"), (double)rs.getFloat("pmax"), (double)rs.getFloat("qmin"), (double)rs.getFloat("qmax"), (double)rs.getFloat("p0"), (double)rs.getFloat("q0"), (double)rs.getFloat("alpha"), (double)rs.getFloat("beta"), (double)rs.getFloat("gamma"), (double)rs.getFloat("sn"), rs.getFloat("st"), rs.getInt("lftype"), rs.getInt("lftypes"), (double)rs.getFloat("us"), (double)rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getBoolean("inservice"), (double)rs.getFloat("xd"), (double)rs.getFloat("xd1"), (double)rs.getFloat("xd2"), (double)rs.getFloat("CvPLP"), (double)rs.getFloat("coneff"), (double)rs.getFloat("zonalfactor"), rs.getString("eotype"), rs.getFloat("eoheight"), rs.getFloat("rough"), rs.getString("wzone")));
            }
            if ("GeneratorCHP".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new GeneratorCHP(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), (double)rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), (double)rs.getFloat("pmin"), (double)rs.getFloat("pmax"), (double)rs.getFloat("qmin"), (double)rs.getFloat("qmax"), (double)rs.getFloat("p0"), (double)rs.getFloat("q0"), (double)rs.getFloat("alpha"), (double)rs.getFloat("beta"), (double)rs.getFloat("gamma"), (double)rs.getFloat("sn"), rs.getFloat("st"), rs.getInt("lftype"), rs.getInt("lftypes"), (double)rs.getFloat("us"), (double)rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getBoolean("inservice"), (double)rs.getFloat("xd"), (double)rs.getFloat("xd1"), (double)rs.getFloat("xd2"), rs.getFloat("CvPLP"), rs.getFloat("coneff"), rs.getFloat("CHPcoef"), rs.getString("wzone")));
            }
            if ("SVC".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new SVC(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("qmin"), rs.getFloat("qmax"), rs.getFloat("q0"), rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getFloat("sn"), rs.getFloat("st"), rs.getInt("lftype"), rs.getInt("lftypes"), rs.getFloat("us"), rs.getFloat("latitude"), rs.getFloat("longitude")));
            }
            if ("Injection".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new Injection(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), (double)rs.getFloat("pmin"), (double)rs.getFloat("pmax"), rs.getFloat("qmin"), rs.getFloat("qmax"), rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), (double)rs.getFloat("sn"), (double)rs.getFloat("st"), (double)rs.getFloat("latitude"), (double)rs.getFloat("longitude")));
            }
            if ("Load".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new Load(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("pini"), rs.getFloat("qini"), rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getFloat("ldc_T"), rs.getFloat("ldc_pmin"), rs.getFloat("ldc_pmax"), rs.getFloat("grate"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getString("place").trim(), rs.getBoolean("inservice"), rs.getFloat("fcaPLP"), rs.getFloat("vd_p"), rs.getFloat("vd_q")));
            }
            if ("Trafo".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                un2 = Math.rint(rs.getFloat("un2") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new Trafo(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), StringUtil.nonNullString(rs.getString("alias")).trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), rs.getFloat("coym"), un1, un2, rs.getFloat("ur1"), rs.getFloat("ur2"), rs.getFloat("smax"), rs.getFloat("sn"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("incomep"), rs.getFloat("incomeq"), rs.getFloat("uk"), rs.getFloat("pcu"), rs.getFloat("pfe"), rs.getFloat("i0"), rs.getFloat("z0z1"), rs.getFloat("r0x0"), rs.getBoolean("verhor"), rs.getBoolean("swapPS"), rs.getInt("planning"), rs.getFloat("zsl"), rs.getInt("maxt"), rs.getFloat("sollt"), rs.getFloat("t_im"), rs.getString("project").trim(), rs.getString("alternative").trim(), rs.getBoolean("suggest"), rs.getFloat("sc"), rs.getBoolean("inservice")));
            }
            if ("ThreeWindingTrafo".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                un2 = Math.rint(rs.getFloat("un2") * 1000.0f) / 1000.0;
                double un3 = Math.rint(rs.getFloat("un3") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new ThreeWindingTrafo(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), StringUtil.nonNullString(rs.getString("alias")).trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), rs.getFloat("coym"), un1, un2, un3, rs.getFloat("ur1"), rs.getFloat("ur2"), rs.getFloat("ur3"), rs.getFloat("smax"), rs.getFloat("sn1"), rs.getFloat("sn2"), rs.getFloat("sn3"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("incomep"), rs.getFloat("incomeq"), rs.getFloat("uk12"), rs.getFloat("uk13"), rs.getFloat("uk23"), rs.getFloat("pcu12"), rs.getFloat("pcu13"), rs.getFloat("pcu23"), rs.getString("lado").trim(), rs.getString("ladotap").trim(), rs.getFloat("pfe"), rs.getFloat("i0"), rs.getFloat("z0z1"), rs.getFloat("r0x0"), rs.getBoolean("verhor"), rs.getBoolean("swapPS"), rs.getInt("planning"), rs.getFloat("zsl"), rs.getFloat("zsl1"), rs.getFloat("zsl2"), rs.getFloat("zslg"), rs.getInt("maxt"), rs.getInt("maxt1"), rs.getInt("maxt2"), rs.getInt("maxtg"), rs.getFloat("sollt"), rs.getFloat("sollt1"), rs.getFloat("sollt2"), rs.getFloat("solltg"), rs.getString("project").trim(), rs.getString("alternative").trim(), rs.getBoolean("suggest"), rs.getFloat("sc"), rs.getBoolean("inservice")));
            }
            if ("LineDC".equals(ComponentName)) {
                double reacrec = rs.getFloat("reacrec");
                double reacinv = rs.getFloat("reacinv");
                Name = rs.getString("Name").trim();
                this.addComponent(new LineDC(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), StringUtil.nonNullString(rs.getString("alias")).trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), rs.getFloat("coym"), rs.getFloat("un1"), rs.getFloat("un2"), rs.getFloat("potdrec"), rs.getFloat("lresis"), rs.getFloat("smax"), rs.getFloat("sn"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("incomep"), rs.getFloat("incomeq"), rs.getFloat("mintapr"), rs.getFloat("mintapi"), rs.getFloat("maxtapr"), rs.getFloat("maxtapi"), rs.getFloat("sv"), rs.getFloat("len"), rs.getBoolean("verhor"), rs.getBoolean("swapPS"), rs.getInt("planning"), rs.getFloat("minext"), rs.getFloat("minfir"), rs.getFloat("maxext"), rs.getFloat("maxfir"), rs.getFloat("resrec"), rs.getFloat("resinv"), reacrec, reacinv, rs.getFloat("vinv"), rs.getInt("nbridge"), rs.getFloat("qrect"), rs.getFloat("qinver"), rs.getString("project").trim(), rs.getString("alternative").trim(), rs.getBoolean("suggest"), rs.getFloat("sc"), rs.getBoolean("inservice")));
            }
            if ("Upfc".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new Upfc(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), rs.getFloat("coym"), rs.getFloat("un1"), rs.getFloat("un2"), rs.getFloat("smax"), rs.getFloat("sn"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("incomep"), rs.getFloat("incomeq"), rs.getFloat("excv"), rs.getFloat("boostv"), rs.getFloat("excang"), rs.getFloat("boostang"), rs.getFloat("pfinj"), rs.getFloat("qeinj"), rs.getFloat("qbinj"), rs.getFloat("pspec"), rs.getFloat("qspec"), rs.getFloat("vispec"), rs.getFloat("vspec"), rs.getFloat("emax"), rs.getFloat("bmax"), rs.getFloat("emin"), rs.getFloat("bmin"), rs.getFloat("iemax"), rs.getFloat("ibmax"), rs.getFloat("pdcmax"), rs.getFloat("sconv1"), rs.getFloat("sconv2"), rs.getFloat("rexc"), rs.getFloat("xexc"), rs.getFloat("rboost"), rs.getFloat("xboost"), rs.getBoolean("verhor"), rs.getBoolean("swapPS"), rs.getInt("planning"), rs.getString("project").trim(), rs.getString("alternative").trim(), rs.getBoolean("suggest"), rs.getFloat("sc")));
            }
            if ("Busbar".equals(ComponentName)) {
                un1 = Math.rint(rs.getFloat("un1") * 1000.0f) / 1000.0;
                Name = rs.getString("Name").trim();
                this.addComponent(new Busbar(PinGrid, rs.getInt("num"), rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), StringUtil.nonNullString(rs.getString("alias")).trim(), rs.getString("owner").trim(), rs.getString("ctrla").trim(), rs.getFloat("cost"), un1, un1, rs.getFloat("smax"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("umin"), rs.getFloat("umax"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getBoolean("inservice")));
            }
            if ("mdb_sup".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.Create_mdb_comp("mdbsup", PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getString("logo").trim(), 1);
            }
            if ("mdb_inv".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.Create_mdb_comp("mdbinv", PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getString("logo").trim(), 1);
            }
            if ("mdb_cust".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.Create_mdb_comp("mdbcust", PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getFloat("alpha"), rs.getFloat("beta"), rs.getFloat("gamma"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getString("logo").trim(), 1);
            }
            if ("mdb_iso".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new mdb_iso(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth")));
            }
            if ("mdb_wheel".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new mdb_wheel(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), rs.getInt("XPos2"), rs.getInt("YPos2"), Name, rs.getFloat("pwheel"), rs.getFloat("qwheel"), rs.getFloat("pcontract"), rs.getFloat("qcontract"), rs.getInt("prio"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("pmax"), (double)rs.getFloat("energy")));
            }
            if ("mdb_owner".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new mdb_owner(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), rs.getInt("XPos2"), rs.getInt("YPos2"), Name, rs.getFloat("perc"), false, rs.getString("source"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth")));
            }
            if ("Caption".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new Caption(rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getString("owner").trim()));
            }
            if ("planpro".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new planpro(rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getString("owner").trim()));
            }
            if ("agreement".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                for (ix = 0; ix < 10; ++ix) {
                    agreementcom[ix] = rs.getString("agreement" + (ix + 1)).trim();
                }
                this.addComponent(new agreement(rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getString("owner").trim(), agreementcom, rs.getString("type").trim(), rs.getString("place").trim()));
            }
            if ("hdb_affl".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new hdb_affl(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getFloat("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("Caudal"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getBoolean("isStoch")));
            }
            if ("hdb_paspur".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new hdb_paspur(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getFloat("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("latitude"), (double)rs.getFloat("longitude"), rs.getFloat("wat2powrate"), rs.getFloat("spillmin"), rs.getFloat("spillmax"), rs.getBoolean("isRegulTank"), rs.getBoolean("grounded")));
            }
            if ("hdb_ser".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new hdb_ser(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getFloat("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getFloat("wat2powrate"), rs.getFloat("spillmin"), rs.getFloat("spillmax"), rs.getFloat("turbmin"), rs.getFloat("turbmax"), rs.getBoolean("grounded")));
            }
            if ("hdb_irr".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new hdb_irr(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getFloat("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getFloat("spillmin"), rs.getFloat("spillmax")));
            }
            if ("hdb_res".equals(ComponentName)) {
                Name = rs.getString("Name").trim();
                this.addComponent(new hdb_res(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getFloat("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), rs.getFloat("Vmin"), rs.getFloat("Vmax"), rs.getFloat("Vini"), rs.getFloat("Vfin"), rs.getFloat("latitude"), rs.getFloat("longitude"), rs.getFloat("wat2powrate"), rs.getFloat("waterVal"), rs.getFloat("spillmin"), rs.getFloat("spillmax"), rs.getFloat("avfiltf"), rs.getInt("filtType"), rs.getFloat("turbmin"), rs.getFloat("turbmax"), rs.getString("elgename"), rs.getBoolean("grounded")));
            }
            if ("hdb_link".equals(ComponentName)) {
                npoly = rs.getInt("numpoly");
                Name = rs.getString("Name").trim();
                for (ix = 0; ix < npoly; ++ix) {
                    xpoly[ix] = rs.getInt("pospolyx" + String.valueOf(ix + 1));
                    ypoly[ix] = rs.getInt("pospolyy" + String.valueOf(ix + 1));
                }
                this.addComponent(new hdb_link(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), rs.getInt("XPos2"), rs.getInt("YPos2"), Name, rs.getString("type").trim(), rs.getString("owner").trim(), rs.getFloat("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("entrymonth"), rs.getInt("exitmonth"), xpoly, ypoly, npoly));
            }
            more = rs.next();
        }
        rs.close();
        stmt.close();
    }

    public Schematic(Pin[][] PinGrid, InputStream iss, long linenumero) throws IOException, FileFormatException {
        this();
        int FileVersionHigh = 0;
        int FileVersionLow = 0;
        boolean SchematicCorrupt = false;
        LaunchProgressFrame loadLaunchFrame = null;
        LineNumberReader is = new LineNumberReader(new InputStreamReader(iss));
        StreamTokenizer st = new StreamTokenizer(is);
        loadLaunchFrame = new LaunchProgressFrame("Loading File: ", linenumero);
        loadLaunchFrame.setVisible(true);
        st.eolIsSignificant(true);
        st.commentChar(35);
        st.ordinaryChar(95);
        st.ordinaryChar(47);
        st.wordChars(95, 95);
        st.wordChars(58, 58);
        st.wordChars(45, 45);
        st.wordChars(48, 57);
        st.eolIsSignificant(true);
        st.parseNumbers();
        block4: while (true) {
            loadLaunchFrame.updateProgress(is.getLineNumber());
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if (SCHEMATICFILE_VERSION.equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            FileVersionHigh = (int)st.nval;
                            if (st.nextToken() == -2) {
                                FileVersionLow = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if (SCHEMATICFILE_INI_DESCRIBE.equals(st.sval)) {
                        if (st.nextToken() != -3 || !SCHEMATICFILE_COMPONENT.equals(st.sval) || st.nextToken() != -3 || this.LoadComponent(PinGrid, is, st)) continue block4;
                        SchematicCorrupt = true;
                        continue block4;
                    }
                    SchematicCorrupt = true;
                    continue block4;
                }
            }
            break;
        }
        is.close();
        loadLaunchFrame.dispose();
        loadLaunchFrame = null;
        if (st.ttype != -1) {
            SchematicCorrupt = true;
        }
        this.Modified = false;
        this.Modifiedstate = true;
        this.changeGIS = true;
        this.updateload();
        this.updatehdbunit();
        this.CheckActive();
        if (SchematicCorrupt) {
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Unknown data in schematic. Schematic could be corrupt.";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading schematic", this.message, DlgButtons, 1, 0, 0, 2);
        }
    }

    public Schematic(Pin[][] PinGrid, InputStream iss) throws IOException, FileFormatException {
        this();
        int FileVersionHigh = 0;
        int FileVersionLow = 0;
        boolean SchematicCorrupt = false;
        LineNumberReader is = new LineNumberReader(new InputStreamReader(iss));
        StreamTokenizer st = new StreamTokenizer(is);
        st.eolIsSignificant(true);
        st.commentChar(35);
        st.ordinaryChar(95);
        st.ordinaryChar(47);
        st.wordChars(95, 95);
        st.wordChars(58, 58);
        st.wordChars(45, 45);
        st.wordChars(48, 57);
        st.eolIsSignificant(true);
        st.parseNumbers();
        block4: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if (SCHEMATICFILE_VERSION.equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            FileVersionHigh = (int)st.nval;
                            if (st.nextToken() == -2) {
                                FileVersionLow = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if (SCHEMATICFILE_INI_DESCRIBE.equals(st.sval)) {
                        if (st.nextToken() != -3 || !SCHEMATICFILE_COMPONENT.equals(st.sval) || st.nextToken() != -3 || this.LoadComponent(PinGrid, is, st)) continue block4;
                        SchematicCorrupt = true;
                        continue block4;
                    }
                    SchematicCorrupt = true;
                    continue block4;
                }
            }
            break;
        }
        is.close();
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
        this.Modified = false;
        this.Modifiedstate = true;
        this.changeGIS = true;
        this.updateload();
        this.updatehdbunit();
        this.CheckActive();
        if (SchematicCorrupt) {
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Unknown data in schematic. Schematic could be corrupt.";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading schematic", this.message, DlgButtons, 1, 0, 0, 2);
        }
    }

    public Schematic(Pin[][] PinGrid, String fileName) throws FileNotFoundException, IOException, NumberFormatException, ExceptionInInitializerError {
        this.Components = new Vector();
        File f = new File(fileName);
        Scanner scanner = new Scanner(f);
        int numLines = Utils.countLinesInFile(fileName);
        int nLine = 0;
        scanner.useDelimiter(System.getProperty("line.separator"));
        while (scanner.hasNext()) {
            String[] lLine;
            String sLine = scanner.next().trim();
            if (nLine++ % 100 == 0) {
                DeepEdit.updateProgressFrame();
            }
            if (sLine.startsWith("#") || (lLine = StringUtil.SplitLineWhitespace(sLine.trim())).length == 0) continue;
            if (lLine[0].startsWith(SCHEMATICFILE_VERSION)) {
                String sMessage;
                int nYesNoAnswer;
                if (lLine.length != 3) continue;
                if (!Schematic.isSupportedVersion(lLine[1], lLine[2])) {
                    throw new ExceptionInInitializerError("This schematic version is newer than current DeepEdit installation. Schematic downgrade is not possible.\nCurrent installation version :3.4. File version: " + lLine[1] + "." + lLine[2]);
                }
                if (Schematic.upgradeRequired(lLine[1], lLine[2]) && (nYesNoAnswer = JOptionPane.showConfirmDialog(DeepEdit.frame, sMessage = "Older schematic version detected [" + lLine[1] + "." + lLine[2] + "] \nChages will be saved to file as newer version [" + 3 + "." + 4 + "]\nDo you wish to continue?", "Older Schematic Version", 0)) == 1) {
                    throw new ExceptionInInitializerError("Schematic file version " + lLine[1] + "." + lLine[2] + " couldn't be loaded. Cancelled by user...");
                }
                DeepEdit.showProgressFrame("Loading", (int)Math.round((double)numLines / 100.0));
                continue;
            }
            if (lLine[0].startsWith(SCHEMATICFILE_INI_DESCRIBE)) {
                if (lLine.length != 3) continue;
                String sClassName = lLine[2];
                Properties p = new Properties();
                sLine = scanner.next().trim();
                if (nLine++ % 100 == 0) {
                    DeepEdit.updateProgressFrame();
                }
                while (!sLine.contains(SCHEMATICFILE_END_DESCRIBE) && scanner.hasNext()) {
                    String[] lCompLine = StringUtil.SplitLineWhitespace(sLine.trim());
                    String sParameter = lCompLine[0];
                    int posPoly = 1;
                    if ("pos".equalsIgnoreCase(sParameter) && lCompLine.length >= 3) {
                        p.setProperty("Xpos", lCompLine[1]);
                        p.setProperty("Ypos", lCompLine[2]);
                    } else if ("pos2".equalsIgnoreCase(sParameter) && lCompLine.length >= 3) {
                        p.setProperty("Xpos2", lCompLine[1]);
                        p.setProperty("Ypos2", lCompLine[2]);
                    } else if ("pospoly".equalsIgnoreCase(sParameter) && lCompLine.length >= 3) {
                        p.setProperty("pospolyx" + posPoly, lCompLine[1]);
                        p.setProperty("pospolyy" + posPoly, lCompLine[2]);
                        p.setProperty("numpoly", String.valueOf(posPoly));
                        ++posPoly;
                    } else {
                        String sDataLine = sLine.replaceFirst(sParameter, "");
                        String sValue = sDataLine.trim();
                        p.setProperty(sParameter, sValue);
                    }
                    sLine = scanner.next().trim();
                    if (nLine++ % 100 != 0) continue;
                    DeepEdit.updateProgressFrame();
                }
                if (this.loadComponent(PinGrid, sClassName, p)) continue;
                System.out.println("Warning: " + sClassName + " class object couldn't be instanteated. Make sure this is a valid schematic file");
                continue;
            }
            throw new ExceptionInInitializerError("Unsupported line entry '" + sLine + "'. Expected 'version' or 'description' \nFile '" + fileName + "' couldn't be parsed or loaded");
        }
        this.updateConstraintCoefficients();
        this.FileName = f.getName();
        this.FileDir = f.getParent() + File.separator;
        scanner.close();
    }

    private boolean loadComponent(Pin[][] PinGrid, String className, Properties p) throws NumberFormatException {
        if ("System".equalsIgnoreCase(className)) {
            this.setSystemParameter(p);
            return true;
        }
        comp tempComp = null;
        int x = 1;
        int y = 1;
        if (p.getProperty("Xpos") != null && p.getProperty("Ypos") != null) {
            x = (int)Double.parseDouble(p.getProperty("Xpos"));
            y = (int)Double.parseDouble(p.getProperty("Ypos"));
        }
        if ("hdbaffl".equalsIgnoreCase(className)) {
            className = "hdb_affl";
        } else if ("hdbirr".equalsIgnoreCase(className)) {
            className = "hdb_irr";
        } else if ("hdblink".equalsIgnoreCase(className)) {
            className = "hdb_link";
        } else if ("hdbpaspur".equalsIgnoreCase(className)) {
            className = "hdb_paspur";
        } else if ("hdbres".equalsIgnoreCase(className)) {
            className = "hdb_res";
        } else if ("hdbser".equalsIgnoreCase(className)) {
            className = "hdb_ser";
        } else if ("mdbcust".equalsIgnoreCase(className)) {
            className = "mdb_cust";
        } else if ("mdbinv".equalsIgnoreCase(className)) {
            className = "mdb_inv";
        } else if ("mdbiso".equalsIgnoreCase(className)) {
            className = "mdb_iso";
        } else if ("mdbowner".equalsIgnoreCase(className)) {
            className = "mdb_owner";
        } else if ("mdbsup".equalsIgnoreCase(className)) {
            className = "mdb_sup";
        } else if ("mdbwheel".equalsIgnoreCase(className)) {
            className = "mdb_wheel";
        }
        String sName = p.getProperty("Name");
        if ("Simulation".equalsIgnoreCase(className)) {
            tempComp = new Simulation(sName);
        } else if ("Busbar".equalsIgnoreCase(className)) {
            tempComp = new Busbar(PinGrid, (int)Double.parseDouble(p.getProperty("num")), x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("Caption".equalsIgnoreCase(className)) {
            tempComp = new Caption(x, y, sName, this.iniperiod, this.endperiod, this.inimonth, this.endmonth, p.getProperty("owner"));
        } else if ("Constraint".equalsIgnoreCase(className)) {
            tempComp = new Constraint(sName, this.iniperiod, this.endperiod);
        } else if ("ConstraintRecord".equalsIgnoreCase(className)) {
            comp c = this.getComponent(p.getProperty("constraintname"), "Constraint");
            if (c != null) {
                return ((Constraint)c).setCoefficient(p);
            }
        } else if ("Generator".equalsIgnoreCase(className)) {
            tempComp = new Generator(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("GeneratorCHP".equalsIgnoreCase(className)) {
            tempComp = new GeneratorCHP(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("GeneratorDG".equalsIgnoreCase(className)) {
            tempComp = new GeneratorDG(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("GeneratorEO".equalsIgnoreCase(className)) {
            tempComp = new GeneratorEO(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("GeneratorPV".equalsIgnoreCase(className)) {
            tempComp = new GeneratorPV(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("Injection".equalsIgnoreCase(className)) {
            tempComp = new Injection(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("Line".equalsIgnoreCase(className)) {
            tempComp = new Line(PinGrid, x, y, (int)Double.parseDouble(p.getProperty("Xpos2")), (int)Double.parseDouble(p.getProperty("Ypos2")), this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("LineDC".equalsIgnoreCase(className)) {
            tempComp = new LineDC(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("Load".equalsIgnoreCase(className)) {
            tempComp = new Load(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("Probe".equalsIgnoreCase(className)) {
            tempComp = new Probe(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("SVC".equalsIgnoreCase(className)) {
            tempComp = new SVC(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("ThreeWindingTrafo".equalsIgnoreCase(className)) {
            tempComp = new ThreeWindingTrafo(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("Trafo".equalsIgnoreCase(className)) {
            tempComp = new Trafo(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("Upfc".equalsIgnoreCase(className)) {
            tempComp = new Upfc(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("agreement".equalsIgnoreCase(className)) {
            tempComp = new agreement(x, y, sName, this.iniperiod, this.endperiod, this.inimonth, this.endmonth, p.getProperty("owner"));
        } else if ("hdb_affl".equalsIgnoreCase(className)) {
            tempComp = new hdb_affl(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
            if (p.containsKey("Q")) {
                p.setProperty("Caudal", p.remove("Q").toString());
            }
        } else if ("hdb_irr".equalsIgnoreCase(className)) {
            tempComp = new hdb_irr(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("hdb_link".equalsIgnoreCase(className)) {
            tempComp = new hdb_link(PinGrid, x, y, (int)Double.parseDouble(p.getProperty("Xpos2")), (int)Double.parseDouble(p.getProperty("Ypos2")), this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("hdb_paspur".equalsIgnoreCase(className)) {
            tempComp = new hdb_paspur(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("hdb_res".equalsIgnoreCase(className)) {
            tempComp = new hdb_res(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
            if (p.containsKey("AvfiltFact")) {
                p.setProperty("avfiltf", p.remove("AvfiltFact").toString());
            }
        } else if ("hdb_ser".equalsIgnoreCase(className)) {
            tempComp = new hdb_ser(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("mdb_cust".equalsIgnoreCase(className)) {
            tempComp = new mdb_cust(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("mdb_inv".equalsIgnoreCase(className)) {
            tempComp = new mdb_inv(PinGrid, (int)Double.parseDouble(p.getProperty("num")), x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("mdb_iso".equalsIgnoreCase(className)) {
            tempComp = new mdb_iso(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("mdb_owner".equalsIgnoreCase(className)) {
            tempComp = new mdb_owner(PinGrid, x, y, (int)Double.parseDouble(p.getProperty("Xpos2")), (int)Double.parseDouble(p.getProperty("Ypos2")), this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("mdb_sup".equalsIgnoreCase(className)) {
            tempComp = new mdb_sup(PinGrid, x, y, this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("mdb_wheel".equalsIgnoreCase(className)) {
            tempComp = new mdb_wheel(PinGrid, x, y, (int)Double.parseDouble(p.getProperty("Xpos2")), (int)Double.parseDouble(p.getProperty("Ypos2")), this.iniperiod, this.endperiod, this.inimonth, this.endmonth);
        } else if ("planpro".equalsIgnoreCase(className)) {
            tempComp = new Caption(x, y, sName, this.iniperiod, this.endperiod, this.inimonth, this.endmonth, p.getProperty("owner"));
        } else {
            try {
                Class<?> clazz = Class.forName("de.core." + className);
                Constructor<?> constructor = clazz.getConstructor(String.class, Integer.class, Integer.class);
                Object newobj = constructor.newInstance(p.getProperty("Name"), Integer.parseInt(p.getProperty("entryperiod")), Integer.parseInt(p.getProperty("exitperiod")));
                for (String key : p.stringPropertyNames()) {
                    ParameterData pData = DeepEdit.getDefaultParameterInfo(className, key);
                    pData.setValue(p.getProperty(key));
                    ((comp)newobj).setParameterInfo(key, pData);
                }
                this.addComponent((comp)newobj);
                return true;
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Schematic.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Schematic.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Schematic.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(Schematic.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(Schematic.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(Schematic.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(Schematic.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
        if (tempComp != null) {
            for (String key : p.stringPropertyNames()) {
                ParameterData pData = DeepEdit.getDefaultParameterInfo(className, key);
                if (pData != null) {
                    pData.setValue(p.getProperty(key));
                    tempComp.setParameterInfo(key, pData);
                    continue;
                }
                System.out.println("Invalid Key entry '" + key + "' for '" + className + "-class object '" + sName + "'. Key will be ignored when saved");
            }
            this.addComponent(tempComp);
            return true;
        }
        return false;
    }

    public boolean setSystemParameter(String name, String sValue) {
        try {
            DE_ClassEnums.System d = DE_ClassEnums.System.valueOf(name);
            return this.setSystemParameter(d, sValue);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid Key entry '" + name + "' for System-class object. Key will be ignored when saved");
            return false;
        }
    }

    private boolean setSystemParameter(DE_ClassEnums.System eName, String sValue) {
        switch (eName) {
            case actday: {
                this.setactday(sValue);
                return true;
            }
            case actdaytype: {
                this.setactdaytype(sValue);
                return true;
            }
            case acthour: {
                this.setacthour(sValue);
                return true;
            }
            case actmonth: {
                this.setactmonth(Integer.parseInt(sValue));
                return true;
            }
            case actperiod: {
                this.setactperiod(Integer.parseInt(sValue));
                return true;
            }
            case co2price: {
                this.setCo2price(Double.parseDouble(sValue));
                return true;
            }
            case customsim: {
                this.setcustomsim(Boolean.parseBoolean(sValue));
                return true;
            }
            case endmonth: {
                this.setendmonth(Integer.parseInt(sValue));
                return true;
            }
            case endperiod: {
                this.setendperiod(Integer.parseInt(sValue));
                return true;
            }
            case flow2volume: {
                this.setFlow2volume(Double.parseDouble(sValue));
                return true;
            }
            case frequence: {
                this.setFrequence(Double.parseDouble(sValue));
                return true;
            }
            case inimonth: {
                this.setinimonth(Integer.parseInt(sValue));
                return true;
            }
            case iniperiod: {
                this.setiniperiod(Integer.parseInt(sValue));
                return true;
            }
            case intrate: {
                this.setintrate(Double.parseDouble(sValue));
                return true;
            }
            case loadfac1: {
                this.setloadfac1(Double.parseDouble(sValue));
                return true;
            }
            case loadfac2: {
                this.setloadfac2(Double.parseDouble(sValue));
                return true;
            }
            case lowsim: {
                this.setlowsim(Boolean.parseBoolean(sValue));
                return true;
            }
            case maxuse: {
                this.setMaxuse(Double.parseDouble(sValue));
                return true;
            }
            case meansim: {
                this.setmeansim(Boolean.parseBoolean(sValue));
                return true;
            }
            case minreserve: {
                this.setMinreserve(Double.parseDouble(sValue));
                return true;
            }
            case peaksim: {
                this.setpeaksim(Boolean.parseBoolean(sValue));
                return true;
            }
            case reservevioprice: {
                this.setReservevioprice(Double.parseDouble(sValue));
                return true;
            }
            case sref: {
                this.setsref(Double.parseDouble(sValue));
                return true;
            }
            case stepperiod: {
                this.setstepperiod(Integer.parseInt(sValue));
                return true;
            }
            case sysname: {
                this.setsysname(sValue);
                return true;
            }
            case zoom: {
                return false;
            }
        }
        assert (false) : "Are you sure this version is compatible with the class Enums auto-generarted file??";
        return false;
    }

    private void setSystemParameter(Properties p) {
        for (Map.Entry<Object, Object> o : p.entrySet()) {
            this.setSystemParameter(o.getKey().toString(), o.getValue().toString());
        }
    }

    public String getSystemParameterValue(String name) {
        try {
            DE_ClassEnums.System d = DE_ClassEnums.System.valueOf(name);
            return this.getSystemParameterValue(d);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Are you sure this version is compatible with the class Enums auto-generarted file??" + e.getMessage();
            return null;
        }
    }

    private String getSystemParameterValue(DE_ClassEnums.System eName) {
        switch (eName) {
            case actday: {
                return this.getactday();
            }
            case actdaytype: {
                return this.getactdaytype();
            }
            case acthour: {
                return this.getacthour();
            }
            case actmonth: {
                return String.valueOf(this.getactmonth());
            }
            case actperiod: {
                return String.valueOf(this.getactperiod());
            }
            case co2price: {
                return String.valueOf(this.getCo2price());
            }
            case customsim: {
                return String.valueOf(this.getcustomsim());
            }
            case endmonth: {
                return String.valueOf(this.getendmonth());
            }
            case endperiod: {
                return String.valueOf(this.getendperiod());
            }
            case flow2volume: {
                return String.valueOf(this.getFlow2volume());
            }
            case frequence: {
                return String.valueOf(this.getFrequence());
            }
            case inimonth: {
                return String.valueOf(this.getinimonth());
            }
            case iniperiod: {
                return String.valueOf(this.getiniperiod());
            }
            case intrate: {
                return String.valueOf(this.getintrate());
            }
            case loadfac1: {
                return String.valueOf(this.getloadfac1());
            }
            case loadfac2: {
                return String.valueOf(this.getloadfac2());
            }
            case lowsim: {
                return String.valueOf(this.getlowsim());
            }
            case maxuse: {
                return String.valueOf(this.getMaxuse());
            }
            case meansim: {
                return String.valueOf(this.getmeansim());
            }
            case minreserve: {
                return String.valueOf(this.getMinreserve());
            }
            case peaksim: {
                return String.valueOf(this.getpeaksim());
            }
            case reservevioprice: {
                return String.valueOf(this.getReservevioprice());
            }
            case sref: {
                return String.valueOf(this.getsref());
            }
            case stepperiod: {
                return String.valueOf(this.getstepperiod());
            }
            case sysname: {
                return String.valueOf(this.getsysname());
            }
            case zoom: {
                return "1";
            }
        }
        assert (false) : "Are you sure this version is compatible with the class Enums auto-generarted file??";
        return null;
    }

    private Properties getSystemParameter() {
        Properties p = new Properties();
        for (DE_ClassEnums.System d : DE_ClassEnums.System.values()) {
            String sValue = this.getSystemParameterValue(d);
            if (sValue == null) continue;
            p.setProperty(d.name(), this.getSystemParameterValue(d));
        }
        return p;
    }

    /*
     * Unable to fully structure code
     */
    public boolean verifyresult(InputStream iss) throws IOException, FileFormatException {
        is = new BufferedReader(new InputStreamReader(iss));
        st = new StreamTokenizer(is);
        this.OSName = System.getProperty("os.name");
        st.eolIsSignificant(true);
        block4: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("Error".equals(st.sval)) ** break;
                    continue block4;
                    DlgButtons = new String[]{"OK"};
                    this.message = "Error during simulation: please check isolated system, parameter, ...";
                    ExceptionDialog = new SimpleDialog(DeepEdit.frame, "In Simulation Tool (External call)", this.message, DlgButtons, 1, 0, 0, 2);
                    iss.close();
                    return false;
                }
            }
            break;
        }
        iss.close();
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
        return true;
    }

    public void DoStatistic(FileOutputStream os) throws IOException, FileFormatException {
        Load TempLoad;
        SVC TempSVC;
        Generator TempGenerator;
        String owner = "";
        String linea = "";
        int ix = 0;
        int numnod = 0;
        int numlin = 0;
        int numtran = 0;
        int numgen = 0;
        int numload = 0;
        int numcontract = 0;
        int numinj = 0;
        int numsup = 0;
        int numcust = 0;
        int numlinedc = 0;
        int numfacts = 0;
        int numupfc = 0;
        int numtranthree = 0;
        int numtranthree2 = 0;
        double totdemini = 0.0;
        double totdemq = 0.0;
        double totdeminiq = 0.0;
        double maxgen = 0.0;
        double maxgenq = 0.0;
        int numnod2 = 0;
        int numlin2 = 0;
        int numtran2 = 0;
        int numgen2 = 0;
        int numload2 = 0;
        int numinj2 = 0;
        int numfacts2 = 0;
        int numupfc2 = 0;
        int numlinedc2 = 0;
        double totdem2 = 0.0;
        double totdemini2 = 0.0;
        double totdemq2 = 0.0;
        double totdeminiq2 = 0.0;
        double maxgen2 = 0.0;
        double maxgenq2 = 0.0;
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("--------------------------------");
        myPrintStream.println("Deep-Edit System Statistics:");
        myPrintStream.println("-------------------------------");
        myPrintStream.println("System Name             : " + this.sysname);
        myPrintStream.println("Reference Power (MVA)   : " + sref);
        myPrintStream.println("Time Horizon from       : " + this.iniperiod + " --> " + this.endperiod);
        myPrintStream.println("                (month) : " + this.inimonth + " --> " + this.endmonth);
        myPrintStream.println("Current Year            : " + this.actperiod);
        myPrintStream.println("Current Month           : " + this.actmonth);
        myPrintStream.println("Current Date            : " + this.actday);
        myPrintStream.println("Current Hour            : " + this.acthour);
        myPrintStream.println("Current Date Type       : " + this.actdaytype);
        myPrintStream.println("Number of Objects       : " + this.Components.size());
        myPrintStream.println("----------------------------------");
        myPrintStream.println("Results from the last simulation:");
        myPrintStream.println("(Units not specified!!)");
        myPrintStream.println("-----------------------------------");
        myPrintStream.println("Objective Function      = " + this.fitnes);
        myPrintStream.println("Total Costs             = " + this.totcost);
        myPrintStream.println("Total Generation        = " + this.totgen);
        myPrintStream.println("Total Unserved Energy   = " + this.totunser);
        myPrintStream.println("Total Losses            = " + this.totloss);
        myPrintStream.println("Total Demand            = " + this.totdem);
        this.totdem = 0.0;
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (this.TempComponent instanceof ndb_comp) {
                ndb_comp TempElComponent = (ndb_comp)this.TempComponent;
                owner = TempElComponent.getinv_owner();
            }
            if (this.TempComponent instanceof Busbar) {
                if (this.focusowner.equals(owner)) {
                    ++numnod2;
                }
                ++numnod;
            }
            if (this.TempComponent instanceof Line) {
                if (this.focusowner.equals(owner)) {
                    ++numlin2;
                }
                ++numlin;
            }
            if (this.TempComponent instanceof Trafo) {
                if (this.focusowner.equals(owner)) {
                    ++numtran2;
                }
                ++numtran;
            }
            if (this.TempComponent instanceof ThreeWindingTrafo) {
                if (this.focusowner.equals(owner)) {
                    ++numtranthree2;
                }
                ++numtranthree;
            }
            if (this.TempComponent instanceof LineDC) {
                if (this.focusowner.equals(owner)) {
                    ++numlinedc2;
                }
                ++numlinedc;
            }
            if (this.TempComponent instanceof Upfc) {
                if (this.focusowner.equals(owner)) {
                    ++numupfc2;
                }
                ++numupfc;
            }
            if (this.TempComponent instanceof Generator) {
                TempGenerator = (Generator)this.TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numgen2;
                    maxgen2 += TempGenerator.getpmax();
                    maxgenq2 += TempGenerator.getqmax();
                }
                ++numgen;
                maxgen += TempGenerator.getpmax();
                maxgenq += TempGenerator.getqmax();
            }
            if (this.TempComponent instanceof SVC) {
                TempSVC = (SVC)this.TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numfacts2;
                    maxgenq2 += TempSVC.getqmax();
                }
                ++numfacts;
                maxgenq += TempSVC.getqmax();
            }
            if (this.TempComponent instanceof Injection) {
                Injection TempInjection = (Injection)this.TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numinj2;
                    maxgen2 += TempInjection.getpmax();
                    maxgenq2 += TempInjection.getqmax();
                }
                ++numinj;
                maxgen += TempInjection.getpmax();
                maxgenq += TempInjection.getqmax();
            }
            if (this.TempComponent instanceof Load) {
                TempLoad = (Load)this.TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numload2;
                    totdem2 += TempLoad.getp();
                    totdemq2 += TempLoad.getq();
                    totdemini2 += TempLoad.getpini();
                    totdeminiq2 += TempLoad.getqini();
                }
                ++numload;
                this.totdem += TempLoad.getp();
                totdemq += TempLoad.getq();
                totdemini += TempLoad.getpini();
                totdeminiq += TempLoad.getqini();
            }
            if (this.TempComponent instanceof mdb_wheel) {
                ++numcontract;
            }
            if (this.TempComponent instanceof mdb_sup) {
                ++numsup;
            }
            if (this.TempComponent instanceof mdb_inv) {
                ++numsup;
            }
            if (!(this.TempComponent instanceof mdb_cust)) continue;
            ++numcust;
        }
        myPrintStream.println("Number of nodes         : " + numnod);
        myPrintStream.println("Number of lines         : " + numlin);
        myPrintStream.println("Number of transformers  : " + numtran);
        myPrintStream.println("Number of UPFC \t\t\t: " + numupfc);
        myPrintStream.println("Number of Generators    : " + numgen);
        myPrintStream.println("Number of Injections    : " + numinj);
        myPrintStream.println("Number of FACTS         : " + numfacts);
        myPrintStream.println("Number of Loads         : " + numload);
        myPrintStream.println("  ");
        myPrintStream.println("Number of Suppliers     : " + numsup);
        myPrintStream.println("Number of Customers     : " + numcust);
        myPrintStream.println("Number of Contracts     : " + numcontract);
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        myPrintStream.println("Total Demand (p)    [MW]   : " + this.totdem);
        myPrintStream.println("Total Demand (q)    [MVAr] : " + totdemq);
        myPrintStream.println("Total Demand (pini) [MW]   : " + totdemini);
        myPrintStream.println("Total Demand (qini) [MVAr] : " + totdeminiq);
        myPrintStream.println("Maximal Generation  [MW]   : " + maxgen);
        myPrintStream.println("Maximal Generation  [MVAr] : " + maxgenq);
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("Power System Information:");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("  ");
        myPrintStream.println("BUSBAR INFORMATION:");
        myPrintStream.println("--------------------------------");
        myPrintStream.println(" Node      Node   Nomimal V.    ");
        myPrintStream.println("  Nr.      Name     (KV)        ");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("  ");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Busbar)) continue;
            Busbar TempBusbar = (Busbar)this.TempComponent;
            linea = TempBusbar.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("  ");
        myPrintStream.println("---------------------  ");
        myPrintStream.println("LINE INFORMATION:");
        myPrintStream.println("---------------------  ");
        myPrintStream.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        linea = StringUtil.printf("Node", 4) + " " + StringUtil.printf("Line", 40) + " " + StringUtil.printf("Node 1", 20) + " " + StringUtil.printf("Node 2", 20) + " " + StringUtil.printf("Inv. Cost", 10) + " " + StringUtil.printf("Op. Cost", 10) + " " + StringUtil.printf("inv_type", 10) + " " + StringUtil.printf("inv_owner", 10) + " " + StringUtil.printf("life", 4) + " " + StringUtil.printf("entry", 5) + " " + StringUtil.printf("sn", 10) + " " + StringUtil.printf("smax", 10) + " " + StringUtil.printf("sc", 10) + " " + StringUtil.printf("smax", 10) + " " + StringUtil.printf("Voltage", 10) + " " + StringUtil.printf("R1", 10) + " " + StringUtil.printf("X1", 10) + " " + StringUtil.printf("g1", 12) + " " + StringUtil.printf("b1", 12) + " " + StringUtil.printf("Lenght", 10) + " " + StringUtil.printf("R1", 10) + " " + StringUtil.printf("X1", 10);
        myPrintStream.println(linea);
        linea = StringUtil.printf("Nr.", 4) + " " + StringUtil.printf("Name", 40) + " " + StringUtil.printf("Name", 20) + " " + StringUtil.printf("Name", 20) + " " + StringUtil.printf("(US$)", 10) + " " + StringUtil.printf("(US$)", 10) + " " + StringUtil.printf("Type", 10) + " " + StringUtil.printf("Name", 10) + " " + StringUtil.printf("year", 4) + " " + StringUtil.printf("year", 5) + " " + StringUtil.printf("MVA", 10) + " " + StringUtil.printf("MVA", 10) + " " + StringUtil.printf("fac", 10) + " " + StringUtil.printf("MVA", 10) + " " + StringUtil.printf("KV", 10) + " " + StringUtil.printf("Ohm/km", 10) + " " + StringUtil.printf("Ohm/km", 10) + " " + StringUtil.printf("microS/km", 12) + " " + StringUtil.printf("microS/km", 12) + " " + StringUtil.printf("Km", 10) + " " + StringUtil.printf("pu", 10) + " " + StringUtil.printf("pu", 10);
        myPrintStream.println(linea);
        myPrintStream.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Line)) continue;
            Line TempLine = (Line)this.TempComponent;
            TempLine.InformAllComponents();
            linea = TempLine.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("---------------------  ");
        myPrintStream.println("TRAFO INFORMATION:");
        myPrintStream.println("---------------------  ");
        myPrintStream.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        linea = StringUtil.printf("Node", 4) + " " + StringUtil.printf("Trafo", 40) + " " + StringUtil.printf("Node 1", 20) + " " + StringUtil.printf("Node 2", 20) + " " + StringUtil.printf("Inv. Cost", 10) + " " + StringUtil.printf("Op. Cost", 10) + " " + StringUtil.printf("inv_type", 10) + " " + StringUtil.printf("inv_owner", 10) + " " + StringUtil.printf("life", 4) + " " + StringUtil.printf("entry", 5) + " " + StringUtil.printf("sn", 10) + " " + StringUtil.printf("smax", 10) + " " + StringUtil.printf("sc", 10) + " " + StringUtil.printf("Imax", 10) + " " + StringUtil.printf("Voltage", 10) + " " + StringUtil.printf("R1", 10) + " " + StringUtil.printf("X1", 10) + " " + StringUtil.printf("b1", 12);
        myPrintStream.println(linea);
        linea = StringUtil.printf("Nr.", 4) + " " + StringUtil.printf("Name", 40) + " " + StringUtil.printf("Name", 20) + " " + StringUtil.printf("Name", 20) + " " + StringUtil.printf("(US$)", 10) + " " + StringUtil.printf("(US$)", 10) + " " + StringUtil.printf("Type", 10) + " " + StringUtil.printf("Owner", 10) + " " + StringUtil.printf("year", 4) + " " + StringUtil.printf("year", 5) + " " + StringUtil.printf("MVA", 10) + " " + StringUtil.printf("MVA", 10) + " " + StringUtil.printf("fac", 10) + " " + StringUtil.printf("A", 10) + " " + StringUtil.printf("kV", 10) + " " + StringUtil.printf("pu", 10) + " " + StringUtil.printf("pu", 10) + " " + StringUtil.printf("pu", 12);
        myPrintStream.println(linea);
        myPrintStream.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)this.TempComponent;
            linea = TempTrafo.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("---------------------  ");
        myPrintStream.println("THREE WINDING TRAFO INFORMATION:");
        myPrintStream.println("---------------------  ");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ThreeWindingTrafo)) continue;
            ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)this.TempComponent;
            linea = TempThreeWindingTrafo.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("---------------------  ");
        myPrintStream.println("UPFC INFORMATION:");
        myPrintStream.println("---------------------  ");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Upfc)) continue;
            Upfc TempUpfc = (Upfc)this.TempComponent;
            linea = TempUpfc.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("---------------------  ");
        myPrintStream.println("GENERATOR INFORMATION:");
        myPrintStream.println("---------------------  ");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Generator)) continue;
            TempGenerator = (Generator)this.TempComponent;
            linea = TempGenerator.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("---------------------  ");
        myPrintStream.println("LOAD INFORMATION:");
        myPrintStream.println("---------------------  ");
        myPrintStream.println("-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        myPrintStream.println("Load                              P         Q      Pini       Qini    Entry");
        myPrintStream.println("[Name]                         [MW]     [MVAr]     [MW]     [MVAr]   [year]");
        myPrintStream.println("------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Load)) continue;
            TempLoad = (Load)this.TempComponent;
            linea = TempLoad.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("---------------------  ");
        myPrintStream.println("FACTS INFORMATION:");
        myPrintStream.println("---------------------  ");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof SVC)) continue;
            TempSVC = (SVC)this.TempComponent;
            linea = TempSVC.Statistic(ix, sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        myPrintStream.println("---------------------  ");
        if (this.focusowner.equals("NO FOCUS")) {
            myPrintStream.println("------------------------------------");
            myPrintStream.println("--- NO FOCUS OWNER WAS SELECTED ---");
            myPrintStream.println("------------------------------------");
        } else {
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Statistic Information for owner \"" + this.focusowner + "\":");
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("  ");
            myPrintStream.println("  ");
            myPrintStream.println("Number of nodes         : " + numnod2);
            myPrintStream.println("Number of lines         : " + numlin2);
            myPrintStream.println("Number of transformers  : " + numtran2);
            myPrintStream.println("Number of UPFC\t\t  : " + numupfc2);
            myPrintStream.println("Number of Generators    : " + numgen2);
            myPrintStream.println("Number of Injections    : " + numinj2);
            myPrintStream.println("Number of FACTS         : " + numfacts2);
            myPrintStream.println("Number of Loads         : " + numload2);
            myPrintStream.println("  ");
            myPrintStream.println("  ");
            myPrintStream.println("Total Demand (p)    [MW]   : " + totdem2);
            myPrintStream.println("Total Demand (q)    [MVAr] : " + totdemq2);
            myPrintStream.println("Total Demand (pini) [MW]   : " + totdemini2);
            myPrintStream.println("Total Demand (qini) [MVAr] : " + totdeminiq2);
            myPrintStream.println("Maximal Generation  [MW]   : " + maxgen2);
            myPrintStream.println("Maximal Generation  [MVAr] : " + maxgenq2);
        }
    }

    public void OPF(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        try {
            Process p;
            Runtime r = Runtime.getRuntime();
            if (this.OSName.startsWith("Windows")) {
                p = r.exec(DeepEdit.PathDOS + "OPF.bat");
            } else {
                String[] commando = new String[]{"xterm", "-e", DeepEdit.PathUNIX + "OPF.bat"};
                p = r.exec(commando);
            }
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in OPF" + e);
        }
    }

    public void SQPV(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        String commando = this.tiposimula == 0 ? "xterm -e ./SQPV0.bat" : "xterm -e ./SQPV1.bat";
        try {
            Runtime r = Runtime.getRuntime();
            Process p = this.OSName.startsWith("Windows") ? (this.tiposimula == 0 ? r.exec(DeepEdit.PathDOS + "SQPV0.bat") : r.exec(DeepEdit.PathDOS + "SQPV1.bat")) : r.exec(commando);
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in SQPV" + e);
        }
    }

    public void ECD(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        try {
            Process p;
            Runtime r = Runtime.getRuntime();
            if (this.OSName.startsWith("Windows")) {
                p = r.exec(DeepEdit.PathDOS + "ECD.bat");
            } else {
                String[] commando = new String[]{"xterm", "-e", DeepEdit.PathUNIX + "ECD.bat"};
                p = r.exec(commando);
            }
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in ECD" + e);
        }
    }

    public void ECD_SQP(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        String commando = this.tiposimula == 0 ? "xterm -e ./ECD_SQP0.bat" : "xterm -e ./ECD_SQP1.bat";
        try {
            Runtime r = Runtime.getRuntime();
            Process p = this.OSName.startsWith("Windows") ? (this.tiposimula == 0 ? r.exec(DeepEdit.PathDOS + "ECD_SQP0.bat") : r.exec(DeepEdit.PathDOS + "ECD_SQP1.bat")) : r.exec(commando);
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in ECD_SQP" + e);
        }
    }

    public void Save(FileOutputStream os) throws IOException, FileFormatException {
        int ix = 0;
        int count = 0;
        int ixx = 0;
        LaunchProgressFrame saveLaunchFrame = null;
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("# DeepEdit file");
        myPrintStream.println("version 1 0");
        myPrintStream.println("describe component System");
        myPrintStream.println(" sysname       " + this.sysname);
        myPrintStream.println(" sref          " + sref);
        myPrintStream.println(" iniperiod     " + this.iniperiod);
        myPrintStream.println(" endperiod     " + this.endperiod);
        myPrintStream.println(" actperiod     " + this.actperiod);
        myPrintStream.println(" inimonth     " + this.inimonth);
        myPrintStream.println(" endmonth     " + this.endmonth);
        myPrintStream.println(" actmonth     " + this.actmonth);
        myPrintStream.println(" actday " + this.actday);
        myPrintStream.println(" actdaytype " + this.actdaytype);
        myPrintStream.println(" acthour " + this.acthour);
        myPrintStream.println(" stepperiod    " + this.stepperiod);
        myPrintStream.println(" peaksim       " + this.peaksim);
        myPrintStream.println(" customsim     " + this.customsim);
        myPrintStream.println(" meansim       " + this.meansim);
        myPrintStream.println(" lowsim        " + this.lowsim);
        myPrintStream.println(" intrate       " + this.intrate);
        myPrintStream.println(" loadfac1      " + this.loadfac1);
        myPrintStream.println(" loadfac2      " + this.loadfac2);
        myPrintStream.println(SCHEMATICFILE_END_DESCRIBE);
        count = this.Components.size() >= 100 ? 100 : this.Components.size();
        saveLaunchFrame = new LaunchProgressFrame("Saving File: ", count);
        saveLaunchFrame.setVisible(true);
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_comp)) continue;
            this.TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof hdb_comp)) continue;
            this.TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof mdb_comp)) continue;
            this.TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (this.TempComponent instanceof ndb_comp || this.TempComponent instanceof hdb_comp || this.TempComponent instanceof mdb_comp) continue;
            this.TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        saveLaunchFrame.dispose();
        saveLaunchFrame = null;
        os.close();
    }

    public void saveToFile(String fileName, boolean displayProgressBar) throws FileNotFoundException, IOException, InvalidFormatException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.saveToFile(ps, displayProgressBar);
        if (ExcelUtil.isExcel2007FileType(fileName)) {
            String sSch = new String(baos.toByteArray(), Charset.defaultCharset());
            String[] lines = sSch.split("\\r?\\n");
            String[][] sData = new String[lines.length][1];
            for (int i = 0; i < lines.length; ++i) {
                sData[i][0] = lines[i];
            }
            ExcelUtil.clearContentExcel(fileName, "Schematic", 1, 1, -1, 1);
            ExcelUtil.writeExcel2007Data(fileName, "Schematic", 1, 1, sData);
        } else {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(baos.toByteArray());
            os.close();
        }
        ps.close();
        baos.close();
        File f = new File(fileName);
        this.FileName = f.getName();
        this.FileDir = f.getParent() + File.separator;
    }

    public void saveToFile(PrintStream ps, boolean displayProgressBar) {
        if (ps == null) {
            return;
        }
        ps.println("version 3 4");
        ps.println("describe component System");
        Properties p = this.getSystemParameter();
        for (Map.Entry<Object, Object> s : p.entrySet()) {
            ps.println(" " + s.getKey() + " " + s.getValue());
        }
        ps.println("end describe component");
        ArrayList<comp> lcomp = new ArrayList<comp>(this.getComponents());
        Utils.sortCompListByClass(lcomp);
        for (comp c : lcomp) {
            c.saveToFile(ps);
        }
    }

    public void saveToExcelFile(PrintStream ps, boolean displayProgressBar) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveDatabase() throws SQLException {
        int x = 0;
        int ixx = 0;
        int count = 0;
        Window saveLaunchFrame = null;
        Statement stmt = DeepEditFrame.con.createStatement();
        try {
            String query = "DELETE FROM System";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Probe";
            x = stmt.executeUpdate(query);
            query = "INSERT INTO System (sysname,sref,iniperiod,endperiod,actperiod,inimonth,endmonth,actmonth,actday,actdaytype,acthour,stepperiod,peaksim,customsim,meansim,lowsim,intrate,loadfac1,loadfac2) VALUES ('" + this.sysname + "'," + sref + "," + this.iniperiod + "," + this.endperiod + "," + this.actperiod + "," + this.inimonth + "," + this.endmonth + "," + this.actmonth + ",'" + this.actday + "','" + this.actdaytype + "','" + this.acthour + "'," + this.stepperiod + "," + (this.peaksim ? 1 : 0) + "," + (this.customsim ? 1 : 0) + "," + (this.meansim ? 1 : 0) + "," + (this.lowsim ? 1 : 0) + "," + this.intrate + "," + this.loadfac1 + "," + this.loadfac2 + ")";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Busbar";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Caption";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM planpro";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM agreement";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Generator";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM GeneratorPV";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM GeneratorDG";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM GeneratorEO";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM GeneratorCHP";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Injection";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Line";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM LineDC";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Load";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM mdb_cust";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM mdb_inv";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM mdb_iso";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM mdb_sup";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM mdb_wheel";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM mdb_owner";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Trafo";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM ThreeWindingTrafo";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM Upfc";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM hdb_affl";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM hdb_paspur";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM hdb_ser";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM hdb_irr";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM hdb_res";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM hdb_link";
            x = stmt.executeUpdate(query);
            query = "DELETE FROM SVC";
            x = stmt.executeUpdate(query);
            count = this.Components.size() >= 100 ? 100 : this.Components.size();
            if (DeepEdit.isGUI) {
                saveLaunchFrame = new LaunchProgressFrame("Saving Database: ", count);
                saveLaunchFrame.setVisible(true);
            }
            for (int ix = 0; ix < this.Components.size(); ++ix) {
                this.TempComponent = (comp)this.Components.elementAt(ix);
                this.TempComponent.SaveDatabase();
                if (!DeepEdit.isGUI || saveLaunchFrame == null || ++ixx >= 100) continue;
                ((LaunchProgressFrame)saveLaunchFrame).updateProgress();
            }
        }
        finally {
            if (DeepEdit.isGUI) {
                if (saveLaunchFrame != null) {
                    saveLaunchFrame.dispose();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    public boolean PlaceJunction(Pin[][] PinGrid, int x, int y, int gs) {
        boolean JunctionPlaced = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            hdb_link TempLink;
            Line TempWire;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (this.TempComponent instanceof Line && (TempWire = (Line)this.TempComponent).TryPlaceJunction(this, PinGrid, x, y, gs)) {
                JunctionPlaced = true;
            }
            if (!(this.TempComponent instanceof hdb_link) || !(TempLink = (hdb_link)this.TempComponent).TryPlaceJunction(this, PinGrid, x, y, gs)) continue;
            JunctionPlaced = true;
        }
        return JunctionPlaced;
    }

    public Vector getProbes() {
        Vector<comp> v = new Vector<comp>();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Probe)) continue;
            v.addElement(this.TempComponent);
        }
        return v;
    }

    public void SwapComponents(comp c1, comp c2) {
        int ix1 = this.Components.indexOf(c1);
        int ix2 = this.Components.indexOf(c2);
        if (ix1 == -1 || ix2 == -1) {
            return;
        }
        this.Components.setElementAt(c1, ix2);
        this.Components.setElementAt(c2, ix1);
    }

    public void BringToFront(comp c) {
        int ix1 = this.Components.indexOf(c);
        if (ix1 == -1 || ix1 == this.Components.size() - 1) {
            return;
        }
        for (int ix = ix1 + 1; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.Components.setElementAt(this.TempComponent, ix - 1);
        }
        this.Components.setElementAt(c, this.Components.size() - 1);
    }

    public void updateload() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Load)) continue;
            Load Tempload = (Load)this.TempComponent;
            Tempload.updateload(sref, this.actperiod, this.actmonth, this.loadfac1, this.loadfac2);
        }
    }

    public void updatehdbunit() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof hdb_unit)) continue;
            hdb_unit Tempunit = (hdb_unit)this.TempComponent;
            Tempunit.setgrounded(true);
            for (int ixx = 0; ixx < this.Components.size(); ++ixx) {
                comp TempComponent1 = (comp)this.Components.elementAt(ixx);
                if (!(TempComponent1 instanceof ndb_inj)) continue;
                ndb_inj Tempinj = (ndb_inj)TempComponent1;
                if (!Tempunit.getName().equals(Tempinj.getName())) continue;
                Tempunit.setgrounded(false);
            }
        }
    }

    public void updateMarketOwnerships() {
        for (comp c : this.getComponents("mdb_cust")) {
            ((mdb_cust)c).removeAllComponents();
        }
        for (comp c : this.getComponents("mdb_sup")) {
            ((mdb_sup)c).removeAllComponents();
        }
        for (comp c : this.getComponents()) {
            comp oOwner;
            String sOwner = c.getinv_owner();
            if (c instanceof Load) {
                oOwner = this.getComponent(sOwner, "mdb_cust");
                if (oOwner == null) continue;
                ((mdb_cust)oOwner).addComponent(c);
                continue;
            }
            if (!(c instanceof Generator) || (oOwner = this.getComponent(sOwner, "mdb_sup")) == null) continue;
            ((mdb_sup)oOwner).addComponent(c);
        }
    }

    public void SendToBack(comp c) {
        int ix1 = this.Components.indexOf(c);
        if (ix1 == -1 || ix1 == 0) {
            return;
        }
        for (int ix = ix1 - 1; ix > -1; --ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            this.Components.setElementAt(this.TempComponent, ix + 1);
        }
        this.Components.setElementAt(c, 0);
    }

    public boolean ProbesInSchematic() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof Probe)) continue;
            return true;
        }
        return false;
    }

    public void changeInServiceStatus() {
        if (DeepEdit.ViewMode) {
            return;
        }
        for (comp c : this.getComponents()) {
            if (!c.isSelected()) continue;
            if (c.getinservice()) {
                c.setinservice(false);
                continue;
            }
            c.setinservice(true);
        }
    }

    public static boolean isSupportedVersion(String MajorRevision, String MinorRevision) {
        try {
            int dFileMajorVersion = Integer.parseInt(MajorRevision);
            int dFileMinorVersion = Integer.parseInt(MinorRevision);
            if (dFileMajorVersion > 3) {
                return false;
            }
            return dFileMajorVersion != 3 || dFileMinorVersion <= 4;
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing version: " + e);
            return false;
        }
    }

    public static boolean upgradeRequired(String MajorRevision, String MinorRevision) {
        try {
            int dFileMajorVersion = Integer.parseInt(MajorRevision);
            int dFileMinorVersion = Integer.parseInt(MinorRevision);
            return dFileMajorVersion != 3 || dFileMinorVersion != 4;
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing version: " + e);
            return false;
        }
    }

    private void updateConstraintCoefficients() {
        for (comp c : this.getComponents("Constraint")) {
            Constraint cc = (Constraint)c;
            for (int id : cc.getAllCoefficientIDs()) {
                comp compCoeff;
                double d = cc.getCoefficientValue(id);
                DE_VariableEnums.DE_Variable v = cc.getCoefficientVariable(id);
                String compName = cc.getCoefficientCompName(id);
                String className = cc.getCoefficientCompClassName(id);
                cc.removeCoefficient(id);
                if (compName == null || className == null || (compCoeff = this.getComponent(compName, className)) == null) continue;
                cc.setCoefficient(d, v, compCoeff);
            }
        }
    }

    public void showParameterGUI() {
        Properties p = this.getSystemParameter();
        ArrayList<ParameterData> lData = new ArrayList<ParameterData>();
        for (Map.Entry<Object, Object> o : p.entrySet()) {
            ParameterData pdata = DeepEdit.getDefaultParameterInfo("System", o.getKey().toString());
            assert (pdata != null) : "why parameter " + o.getKey() + " couldn't be mapped to DeepEdit parameter xml?";
            if (pdata == null) continue;
            pdata.setValue(o.getValue().toString());
            lData.add(pdata);
        }
        final JXTreeTable jxtretbl = DeepEditMainPane.createParameterTable("System", null, lData);
        jxtretbl.getTreeTableModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                if (e.getSource() instanceof TreeTableModel) {
                    int c = jxtretbl.getSelectedColumn();
                    int r = jxtretbl.getSelectedRow();
                    String strName = jxtretbl.getValueAt(r, 0).toString();
                    String strVal = jxtretbl.getValueAt(r, 1).toString();
                    Properties p = new Properties();
                    p.setProperty(strName, strVal);
                    Schematic.this.setSystemParameter(p);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        JDialog w = new JDialog(DeepEdit.frame);
        jxtretbl.setPreferredScrollableViewportSize(new Dimension(250, 400));
        w.add(new JScrollPane((Component)jxtretbl));
        w.setTitle("Active Schematic Parameters");
        w.pack();
        w.setLocationRelativeTo(DeepEdit.frame);
        w.setVisible(true);
        w.setDefaultCloseOperation(2);
    }

    public void UpdateTreeView(JTree mytree) {
        DefaultTreeModel model = (DefaultTreeModel)mytree.getModel();
        mytree.setEditable(false);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        for (Object o : this.Components) {
            comp TempComp = (comp)o;
            Schematic.addComponentTreeView(mytree, TempComp);
        }
        ArrayList<TreeNode> list = Collections.list(root.children());
        Utils.sortCompListByName(list);
        model.reload();
    }

    public static void addComponentTreeView(JTree mytree, comp newComp) {
        DefaultMutableTreeNode nodeComp;
        DefaultMutableTreeNode nodeClass;
        DefaultTreeModel model = (DefaultTreeModel)mytree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        String strClassName = newComp.getClassName();
        int nClasses = model.getChildCount(root);
        boolean bClassExists = false;
        for (int i = 0; i < nClasses; ++i) {
            String classNode = model.getChild(root, i).toString();
            if (!classNode.equals(strClassName)) continue;
            bClassExists = true;
            nodeClass = (DefaultMutableTreeNode)model.getChild(root, i);
            int nObjects = model.getChildCount(nodeClass);
            boolean bObjectExists = false;
            for (int k = 0; k < nObjects; ++k) {
                comp oCompNode;
                nodeComp = (DefaultMutableTreeNode)model.getChild(nodeClass, k);
                Object tempObject = nodeComp.getUserObject();
                if (!(tempObject instanceof comp) || !(oCompNode = (comp)tempObject).equals(newComp)) continue;
                bObjectExists = true;
                break;
            }
            if (bObjectExists) break;
            nodeComp = new DefaultMutableTreeNode(newComp);
            nodeClass.add(nodeComp);
            break;
        }
        if (!bClassExists) {
            nodeClass = new DefaultMutableTreeNode(strClassName);
            nodeComp = new DefaultMutableTreeNode(newComp);
            nodeClass.add(nodeComp);
            root.add(nodeClass);
        }
        model.reload();
    }

    public static boolean removeComponentTreeView(JTree mytree, comp newComp) {
        DefaultTreeModel model = (DefaultTreeModel)mytree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        String strClassName = newComp.getClassName();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode classnodes = (DefaultMutableTreeNode)model.getChild(root, i);
            if (!classnodes.toString().equals(strClassName)) continue;
            for (int k = 0; k < classnodes.getChildCount(); ++k) {
                comp oCompNode;
                DefaultMutableTreeNode nodeComp = (DefaultMutableTreeNode)model.getChild(classnodes, k);
                Object tempObject = nodeComp.getUserObject();
                if (!(tempObject instanceof comp) || !(oCompNode = (comp)tempObject).equals(newComp)) continue;
                classnodes.remove(k);
                model.reload();
                return true;
            }
        }
        assert (false) : "Why are you trying to delete component " + newComp.getName() + " if it didn't exist in tree?";
        return false;
    }
}

