/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.GraphicsUtil;
import de.core.OutputPin;
import de.core.Pin;
import de.core.comp;
import de.core.ndb_inj;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

class SVC
extends ndb_inj {
    public SVC(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.OPin[0] = new OutputPin("SVC", 3, 8, 0, -3, 0, 0, 2);
        this.setName("SVC");
        this.ClassName = "SVC";
        this.inv_type = "Compensation";
        this.inv_owner = "None";
        this.RegisterPins(PinGrid, x, y);
    }

    public SVC(Pin[][] PinGrid, int x, int y, String Name, String type, String owner, String ctrla, double cost, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double qqmin, double qqmax, double qq0, double aalpha, double bbeta, double ggamma, double sn, double st, int lftype, int lftypes, double uus, double latitude, double longitude) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, Name, type, owner, ctrla, cost, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, 0.0, 0.0, qqmin, qqmax, aalpha, bbeta, ggamma, sn, st, latitude, longitude);
        this.p0 = 0.0;
        this.q0 = qq0;
        this.us = uus;
        this.lf_type = lftype;
        this.lf_type_s = lftypes;
        this.OPin[0] = new OutputPin(Name, 3, 8, 0, -3, 0, 0, 2);
        this.ClassName = "SVC";
        this.RegisterPins(PinGrid, x, y);
    }

    public SVC(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    @Override
    public comp Copy(int xo, int yo) {
        SVC NewComponent = new SVC(this, xo, yo);
        NewComponent.setsn(this.getsn());
        NewComponent.setlf_type(this.getlf_type());
        NewComponent.setlf_type_s(this.getlf_type_s());
        NewComponent.setun1(this.getun1());
        NewComponent.setus(this.getus());
        NewComponent.setst(this.getst());
        NewComponent.setsmax(this.getsmax());
        NewComponent.setalpha(this.getalpha());
        NewComponent.setbeta(this.getbeta());
        NewComponent.setgamma(this.getgamma());
        NewComponent.setpmax(this.getpmax());
        NewComponent.setp0(this.getp0());
        NewComponent.setq0(this.getq0());
        NewComponent.setpmin(this.getpmin());
        NewComponent.setqmax(this.getqmax());
        NewComponent.setqmin(this.getqmin());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner("None");
        NewComponent.setlatitude(this.getlatitude());
        NewComponent.setlongitude(this.getlongitude());
        NewComponent.setctrla(this.getctrla());
        return NewComponent;
    }

    @Override
    public void SimulateSetUpFlows(double sref) {
        double belastung = Math.sqrt(Math.abs(this.p) * Math.abs(this.p) + Math.abs(this.q) * Math.abs(this.q));
        if (this.getsmax() > 0.0) {
            belastung = this.q != 0.0 ? (belastung /= this.getsmax()) : (belastung /= this.getpmax());
        } else {
            return;
        }
        this.auxcolor = belastung >= 0.9 ? Color.red : (belastung >= 0.5 ? Color.orange : Color.green);
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate, boolean Simulate, boolean cycle, double sref, int actperiod, int actmonth, int typsim) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        if (!Simulate) {
            g.setColor(TextColor2);
            if (gs > 2 && gs < 4) {
                g.setFont(Font8);
                g.drawString("C", (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
            } else if (gs >= 4 && gs < 8) {
                g.setFont(Font9);
                g.drawString("C", (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
                g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
            } else if (gs >= 8 && gs < 10) {
                g.setFont(Font11);
                g.drawString("C", (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
                g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
            } else if (gs >= 10 && gs < 14) {
                g.setFont(Font12);
                g.drawString("C", (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
                g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
            } else if (gs >= 14 && gs < 18) {
                g.setFont(Font16);
                g.drawString("C", (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
                g.drawString(this.ComponentName, (x + 1) * gs, y * gs);
            }
            if (gs >= 6 && !Modifiedstate) {
                if (gs >= 12) {
                    g.setFont(Font10);
                } else {
                    g.setFont(Font9);
                }
                g.setColor(Color1);
                g.drawString(StringUtil.printf(this.p, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.75) * (double)gs));
                if (typsim != 1 && typsim != 2 && typsim != 6 && typsim != 7) {
                    g.setColor(TextColor1);
                    g.drawString(StringUtil.printf(this.q, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.75) * (double)gs));
                }
            }
            g.setColor(this.getkv_color1());
            g.drawRect((x + 1) * gs, (y + 1) * gs, 4 * gs, 4 * gs);
            this.DrawOutputPins(g, x, y, gs);
        } else if (this.p > 0.0) {
            g.setColor(this.auxcolor);
            if (cycle) {
                GraphicsUtil.drawArrow(g, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.25) * (double)gs), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.5) * (double)gs), 1, (int)((double)gs * 1.5));
            } else {
                GraphicsUtil.drawArrow(g, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.5) * (double)gs), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 10.5) * (double)gs), 1, (int)((double)gs * 1.5));
            }
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component " + this.ClassName);
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" cost " + this.inv_cost);
        myPrintStream.println(" un1 " + this.un[0]);
        myPrintStream.println(" us  " + this.us);
        myPrintStream.println(" smax " + this.smax);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" qmin " + this.qmin);
        myPrintStream.println(" qmax " + this.qmax);
        myPrintStream.println(" q0 " + this.q0);
        myPrintStream.println(" alpha " + this.alpha);
        myPrintStream.println(" beta " + this.beta);
        myPrintStream.println(" gamma " + this.gamma);
        myPrintStream.println(" sn  " + this.sn);
        myPrintStream.println(" st  " + this.st);
        myPrintStream.println(" lftype  " + this.lf_type);
        myPrintStream.println(" lftypes  " + this.lf_type_s);
        myPrintStream.println(" latitude  " + this.latitude);
        myPrintStream.println(" longitude  " + this.longitude);
        myPrintStream.println(" ctrla " + this.ctrla);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO SVC (XPos,YPos,Name,type,owner,ctrla,cost,un1,smax,lifetime,entryperiod,exitperiod,entrymonth,exitmonth,qmin,qmax,q0,alpha,beta,gamma,sn,st,lftype,lftypes,us,latitude,longitude,U,delta,p,q,spotp,spotq,con2) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.inv_owner + "','" + this.ctrla + "'," + String.valueOf(this.inv_cost) + "," + String.valueOf(this.un[0]) + "," + String.valueOf(this.smax) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.qmin) + "," + String.valueOf(this.qmax) + "," + String.valueOf(this.q0) + "," + String.valueOf(this.alpha) + "," + String.valueOf(this.beta) + "," + String.valueOf(this.gamma) + "," + String.valueOf(this.sn) + "," + String.valueOf(this.st) + "," + String.valueOf(this.lf_type) + "," + String.valueOf(this.lf_type_s) + "," + String.valueOf(this.us) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.getun2()) + "," + String.valueOf(this.getdelta2()) + "," + String.valueOf(this.p) + "," + String.valueOf(this.q) + "," + String.valueOf(this.spot_p) + "," + String.valueOf(this.spot_q) + ",'" + this.con2 + "')";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public String Statistic(int ix, double sref) {
        this.InformAllComponents();
        return " ";
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p")) {
            sValue = String.valueOf(this.getp());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q")) {
            sValue = String.valueOf(this.getq());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q0")) {
            sValue = String.valueOf(this.getq0());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("us")) {
            sValue = String.valueOf(this.getus());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("smax")) {
            sValue = String.valueOf(this.getsmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qmin")) {
            sValue = String.valueOf(this.getqmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qmax")) {
            sValue = String.valueOf(this.getqmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sn")) {
            sValue = String.valueOf(this.getsn());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("st")) {
            sValue = String.valueOf(this.getst());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("lftype")) {
            sValue = String.valueOf(this.getlf_type());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("lftypes")) {
            sValue = String.valueOf(this.getlf_type_s());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U")) {
            sValue = String.valueOf(this.getun2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta")) {
            sValue = String.valueOf(this.getdelta2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotp")) {
            sValue = String.valueOf(this.getspot_p());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotq")) {
            sValue = String.valueOf(this.getspot_q());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getinv_cost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("alpha")) {
            sValue = String.valueOf(this.getalpha());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("beta")) {
            sValue = String.valueOf(this.getbeta());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("gamma")) {
            sValue = String.valueOf(this.getgamma());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("ctrla")) {
            sValue = this.getctrla();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p")) {
            this.setp(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q")) {
            this.setq(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q0")) {
            this.setq0(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("us")) {
            this.setus(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("smax")) {
            this.setsmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qmin")) {
            this.setqmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qmax")) {
            this.setqmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sn")) {
            this.setsn(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("st")) {
            this.setst(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lftype")) {
            this.setlf_type((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lftypes")) {
            this.setlf_type_s((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U")) {
            this.setun2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta")) {
            this.setdelta2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotp")) {
            this.setspot_p(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotq")) {
            this.setspot_q(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setinv_cost((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alpha")) {
            this.setalpha(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("beta")) {
            this.setbeta(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("gamma")) {
            this.setgamma(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ctrla")) {
            this.setctrla(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

