/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.SQPGL;
import de.core.SwingWorker;
import java.awt.BorderLayout;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

class SQPGLFrame
extends JDialog
implements KeyListener,
ActionListener {
    private SQPGL Myequiv;
    private String ctrla;
    private JComboBox MyChoiceCtrla = null;
    private JComboBox chSolver = null;
    private JComboBox chMaxIter = null;
    private JComboBox chMaxRHSTol = null;
    private JComboBox chMaxCostTol = null;
    private JComboBox chTimeFrame = null;
    private JRadioButton chbCuadLoss = null;
    private JRadioButton chbCoseLoss = null;
    private JRadioButton chbWithoutLoss = null;
    private CheckboxGroup chbgLossMod = null;
    private JCheckBox lin;
    private JCheckBox incremental;
    protected JCheckBox printTxInfo;
    private JButton buttonCalc;
    private JButton buttonCancel;
    private SwingWorker worker = null;
    private Vector dialogJComps2disable = null;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;

    SQPGLFrame(SQPGL ms) {
        super(DeepEdit.frame, "SQPGL Calculation Options", true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.Myequiv = ms;
        this.TextDialogFont = DeepEdit.TextFont;
        JPanel opModelPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        this.dialogJComps2disable = new Vector(20);
        c1.gridheight = 1;
        c1.gridwidth = 1;
        c1.anchor = 17;
        c2.gridheight = 1;
        c2.gridwidth = 0;
        c2.fill = 2;
        c2.insets = new Insets(1, 1, 1, 1);
        opModelPanel.setLayout(gridbag);
        this.MyChoiceCtrla = new JComboBox();
        this.dialogJComps2disable.add(this.MyChoiceCtrla);
        this.MyChoiceCtrla.setFont(this.TextDialogFont);
        this.ctrla = "ALL CONTROL AREAS";
        Choice auxChoice = new Choice();
        this.MyChoiceCtrla.addItem(this.ctrla);
        this.Myequiv.ActSchematic.LoadCtrla(auxChoice);
        for (int i = 0; i < auxChoice.getItemCount(); ++i) {
            this.MyChoiceCtrla.addItem(auxChoice.getItem(i));
        }
        JLabel auxLab = new JLabel(" Control Area ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opModelPanel.add(auxLab);
        opModelPanel.add((Component)this.MyChoiceCtrla, c2);
        auxLab = new JLabel(" Losses Model ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opModelPanel.add(auxLab);
        ButtonGroup chbgLossMod = new ButtonGroup();
        this.chbCuadLoss = new JRadioButton("R\u2219I\u00b2", true);
        this.dialogJComps2disable.add(this.chbCuadLoss);
        this.chbCuadLoss.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbCuadLoss, c1);
        chbgLossMod.add(this.chbCuadLoss);
        this.chbCoseLoss = new JRadioButton("2G\u2219Cos(\u2206\u03b4)", false);
        this.dialogJComps2disable.add(this.chbCoseLoss);
        this.chbCoseLoss.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbCoseLoss, c1);
        chbgLossMod.add(this.chbCoseLoss);
        this.chbWithoutLoss = new JRadioButton("r=0", false);
        this.dialogJComps2disable.add(this.chbWithoutLoss);
        this.chbWithoutLoss.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbWithoutLoss, c2);
        chbgLossMod.add(this.chbWithoutLoss);
        auxLab = new JLabel(" Aditional Constraints    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.lin = new JCheckBox(" Line Limits", true);
        this.dialogJComps2disable.add(this.lin);
        this.lin.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.lin, c2);
        opModelPanel.add(this.lin);
        JLabel auxLab1 = new JLabel("      ", 2);
        this.dialogJComps2disable.add(auxLab1);
        auxLab1.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab1, c1);
        this.incremental = new JCheckBox(" Incremental Opt.", this.Myequiv.incremental);
        this.dialogJComps2disable.add(this.incremental);
        this.incremental.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.incremental, c2);
        opModelPanel.add(this.incremental);
        TitledBorder inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "MODEL'S PARAMETERS", 2, 2, this.TextDialogFont, Color.blue);
        opModelPanel.setBorder(inB);
        this.getContentPane().add((Component)opModelPanel, "North");
        JPanel opSolverPanel = new JPanel(){
            Insets inSet = new Insets(20, 0, 15, 0);

            @Override
            public Insets getInsets() {
                return this.inSet;
            }
        };
        gridbag = new GridBagLayout();
        opSolverPanel.setLayout(gridbag);
        auxLab = new JLabel(" Subproblems Solver    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chSolver = new JComboBox();
        this.dialogJComps2disable.add(this.chSolver);
        this.chSolver.addItem(SQPGL.solverOptions[0] + "                ");
        this.chSolver.addItem(SQPGL.solverOptions[1]);
        this.chSolver.setFont(this.TextDialogFont);
        opSolverPanel.add((Component)this.chSolver, c2);
        auxLab = new JLabel(" Maximum Iterations", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxIter = new JComboBox<String>(SQPGL.maxIterOptions);
        this.dialogJComps2disable.add(this.chMaxIter);
        this.chMaxIter.setFont(this.TextDialogFont);
        this.chMaxIter.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chMaxIter, c2);
        auxLab = new JLabel(" RHS Tolerance [%]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxRHSTol = new JComboBox<String>(SQPGL.maxRHSTolOptions);
        this.dialogJComps2disable.add(this.chMaxRHSTol);
        this.chMaxRHSTol.setFont(this.TextDialogFont);
        this.chMaxRHSTol.setSelectedIndex(2);
        opSolverPanel.add((Component)this.chMaxRHSTol, c2);
        auxLab = new JLabel(" Cost Tolerance [%]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxCostTol = new JComboBox<String>(SQPGL.maxCostTolOptions);
        this.dialogJComps2disable.add(this.chMaxCostTol);
        this.chMaxCostTol.setFont(this.TextDialogFont);
        this.chMaxCostTol.setSelectedIndex(4);
        opSolverPanel.add((Component)this.chMaxCostTol, c2);
        auxLab = new JLabel(" Time frame (Gradients) [Minutes]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chTimeFrame = new JComboBox<String>(SQPGL.TimeFrameOptions);
        this.dialogJComps2disable.add(this.chTimeFrame);
        this.chTimeFrame.setFont(this.TextDialogFont);
        this.chTimeFrame.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chTimeFrame, c2);
        inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "SOLVER PARAMETERS", 2, 2, this.TextDialogFont, Color.blue);
        opSolverPanel.setBorder(inB);
        this.getContentPane().add((Component)opSolverPanel, "Center");
        JPanel controlP = new JPanel();
        controlP.setLayout(new BorderLayout());
        this.printTxInfo = new JCheckBox("Export Transmission Matrices", false);
        controlP.add("North", this.printTxInfo);
        this.buttonCalc = new JButton("Calculate");
        this.dialogJComps2disable.add(this.buttonCalc);
        this.buttonCalc.setFont(this.TextDialogFont);
        controlP.add("West", this.buttonCalc);
        this.buttonCalc.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.setFont(this.TextDialogFont);
        controlP.add("East", this.buttonCancel);
        this.buttonCancel.addActionListener(this);
        this.getContentPane().add((Component)controlP, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        this.buttonCancel.addKeyListener(this);
        DeepEdit cfr_ignored_0 = ms.applet;
        this.setLocationRelativeTo(DeepEdit.frame);
        this.setLocation(200, 50);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.Myequiv.MySQPGLFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj == this.buttonCalc) {
            try {
                this.disableComponents();
                this.setDefaultCloseOperation(0);
                this.runSolver();
            }
            catch (Exception e) {
                this.setVisible(false);
                JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SQPGL Error", 0);
                this.endDialog();
            }
        }
        if (obj == this.buttonCancel) {
            try {
                if (this.worker != null) {
                    this.worker.interrupt();
                }
                this.endDialog();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SQPGL Error", 0);
                e.printStackTrace();
            }
            this.endDialog();
        }
    }

    private void disableComponents() {
        for (int i = 0; i < this.dialogJComps2disable.size(); ++i) {
            ((JComponent)this.dialogJComps2disable.elementAt(i)).setEnabled(false);
        }
    }

    private void runSolver() {
        int nL = 0;
        if (this.chbCuadLoss.isSelected()) {
            nL = 1;
        } else if (this.chbCoseLoss.isSelected()) {
            nL = 2;
        } else if (this.chbWithoutLoss.isSelected()) {
            nL = 0;
        }
        this.Myequiv.setParameters(this.chSolver.getSelectedIndex(), this.chMaxIter.getSelectedIndex(), this.chMaxRHSTol.getSelectedIndex(), this.chMaxCostTol.getSelectedIndex(), this.lin.isSelected(), nL, this.incremental.isSelected(), this.chTimeFrame.getSelectedIndex(), this.printTxInfo.isSelected());
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                SQPGLFrame.this.Myequiv.Calculate(true, 1);
                return new Object();
            }

            @Override
            public void finished() {
                SQPGLFrame.this.endDialog();
            }
        };
        this.worker.start();
    }

    private void endDialog() {
        this.dispose();
        this.Myequiv.MySQPGLFrame = null;
        Runtime.getRuntime().gc();
    }
}

