/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.SQPGLAI;
import de.core.SQPGLAIBarFrame;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_comp;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class SQPGLAIVisualFrame
extends Frame
implements KeyListener,
ActionListener {
    SQPGLAI MyStat;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    Choice MyChoiceBranch = null;
    int i;
    int j;

    public SQPGLAIVisualFrame(SQPGLAI ms) {
        super("SQPGAI Graphic Options");
        this.MyStat = ms;
        this.setBackground(Color.lightGray);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        Panel P = new Panel();
        P.setLayout(new GridLayout(4, 1));
        Label titel = new Label("Graphic Options");
        titel.setForeground(Color.blue);
        Button buttonShow = new Button("Show Graphic");
        buttonShow.setActionCommand("Show Graphic");
        buttonShow.addActionListener(this);
        Button buttonPaint = new Button("Paint Network");
        buttonPaint.setActionCommand("Paint Network");
        buttonPaint.addActionListener(this);
        Button buttonExit = new Button("Exit");
        buttonExit.setActionCommand("Exit");
        buttonExit.addActionListener(this);
        P.add(titel);
        P.add(buttonShow);
        P.add(buttonPaint);
        P.add(buttonExit);
        this.add(P);
        this.setBounds(550, 50, 150, 150);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SQPGLAIVisualFrame.this.setVisible(false);
                SQPGLAIVisualFrame.this.dispose();
            }
        });
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        double[] PC = new double[this.MyStat.numbran];
        this.i = 0;
        while (this.i < this.MyStat.numbran) {
            PC[this.i] = Math.abs(this.MyStat.Flujo[this.i] / (this.MyStat.PGMax * 0.9 / this.MyStat.getSref()) * 100.0);
            ++this.i;
        }
        if (obj instanceof Button) {
            if (label.equals("Show Graphic")) {
                String titulo = "Porcentajes de Flujos por Rama";
                SQPGLAIBarFrame MySQPGLAIBarFrame = new SQPGLAIBarFrame(titulo, this.MyStat.numbran, this.MyStat.NomBra, PC);
                MySQPGLAIBarFrame.setVisible(true);
            }
            if (label.equals("Paint Network")) {
                int countBranch = 0;
                int countBus = 0;
                int countGen = 0;
                for (int ix = 0; ix < this.MyStat.ActSchematic.Components.size(); ++ix) {
                    comp TempComponent = (comp)this.MyStat.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
                    ndb_comp Tempndb = (ndb_comp)TempComponent;
                    ndb_comp.CaptionColor = Color.gray;
                    ndb_comp.TextColor1 = Color.gray;
                    ndb_comp.TextColor2 = Color.gray;
                    ndb_comp.TextColor3 = Color.gray;
                    ndb_comp.Color1 = Color.darkGray;
                    ndb_comp.Color2 = Color.darkGray;
                    ndb_comp.Color3 = Color.darkGray;
                    if (TempComponent instanceof Line || TempComponent instanceof Trafo) {
                        Tempndb.lw = (int)(PC[countBranch] / 10.0 + 1.0);
                        Tempndb.setAlternatekv_Color(this.floatToColor(PC[countBranch]));
                        ++countBranch;
                        continue;
                    }
                    if (TempComponent instanceof Generator) {
                        if (TempComponent.getName().equals(this.MyStat.GenAI)) {
                            Tempndb.setAlternatekv_Color(Color.red);
                        } else {
                            Tempndb.setAlternatekv_Color(Color.darkGray);
                        }
                        ++countGen;
                        continue;
                    }
                    if (TempComponent instanceof Busbar) {
                        if (TempComponent.getName().equals(this.MyStat.SEBE)) {
                            Tempndb.setAlternatekv_Color(Color.red);
                        } else {
                            Tempndb.setAlternatekv_Color(Color.darkGray);
                        }
                        ++countBus;
                        continue;
                    }
                    Tempndb.setAlternatekv_Color(Color.darkGray);
                }
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            }
            if (label.equals("Exit")) {
                this.setVisible(false);
                this.dispose();
                this.MyStat.MySQPGLAIVisualFrame = null;
                this.MyStat.MyColorSpec = null;
            }
        }
    }

    public Color floatToColor(double f) {
        int elec = (int)(f / 10.0 + 1.0);
        Color acolor = Color.darkGray;
        switch (elec) {
            case 0: {
                acolor = Color.darkGray;
                break;
            }
            case 1: {
                acolor = Color.white;
                break;
            }
            case 2: {
                acolor = Color.cyan;
                break;
            }
            case 3: {
                acolor = Color.green;
                break;
            }
            case 4: {
                acolor = Color.yellow;
                break;
            }
            case 5: {
                acolor = Color.pink;
                break;
            }
            case 6: {
                acolor = Color.blue;
                break;
            }
            case 7: {
                acolor = Color.magenta;
                break;
            }
            case 8: {
                acolor = Color.orange;
                break;
            }
            case 9: {
                acolor = new Color(204, 136, 0);
                break;
            }
            case 10: {
                acolor = Color.red;
            }
        }
        if (elec > 10 && elec <= 11) {
            acolor = Color.red;
        }
        if (elec > 11) {
            acolor = Color.black;
        }
        if (f <= 1.0) {
            acolor = Color.darkGray;
        }
        return acolor;
    }
}

