/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.ColorSpec;
import de.core.DeepEdit;
import de.core.Line;
import de.core.Load;
import de.core.SQPGLAIFrame;
import de.core.SQPGLAIVisualFrame;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class SQPGLAI
extends AnalysisTool {
    SQPGLAIFrame MySQPGLAIFrame = null;
    SQPGLAIVisualFrame MySQPGLAIVisualFrame = null;
    ColorSpec MyColorSpec = null;
    double[][] MatG;
    double[][] MatX;
    protected Vector BusbarVectorI;
    int numbran = 0;
    int numnod = 0;
    int numgen = 0;
    int numtrafo = 0;
    int numlast = 0;
    int numvar = 0;
    int numres = 0;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    boolean overiter = false;
    double mean_c = 1000000.0;
    double[] vec_xminabs;
    double[] vec_xmaxabs;
    double[] vec_xmin;
    double[] vec_xmax;
    double[] vec_xtemp;
    double[] vec_xtempabs;
    double[] vec_xant;
    double[] vec_c;
    double[] vec_RHS;
    double[] vec_OBJ;
    double[] vec_lam;
    double[] DiagMat_Q;
    double[] node_p;
    int[] vec_clave;
    double totcost = 0.0;
    double totgen = 0.0;
    double totunser = 0.0;
    double totloss = 0.0;
    double totdem = 0.0;
    double totincome = 0.0;
    double totsales = 0.0;
    int iteraciones;
    double tolerancia;
    double tolcost;
    double tolfeas;
    int metodo = 1;
    double[][] mat_W;
    double[][] mat_A;
    DeepEdit applet;
    PrintStream myPPrintStream;
    int tapito = 0;
    Complex[][] MatY;
    boolean linres = true;
    String SEBE;
    String GenAI;
    double PGMax;
    double[] Flujo;
    String[] NomBra;
    private double sref = 100.0;

    public SQPGLAI(Schematic sch) {
        super(sch);
        System.out.println("---------- In SQPGLAI Calculation Tool ------------");
        this.sref = this.getSref();
        if (this.MySQPGLAIFrame == null) {
            this.MySQPGLAIFrame = new SQPGLAIFrame(this);
        } else {
            this.MySQPGLAIFrame.setVisible(true);
        }
    }

    public void Calculate(boolean sino, int modelo) {
        FileOutputStream os;
        boolean konv = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        double cost3 = 0.0;
        double tol = 0.0;
        FileInputStream is1 = null;
        int iteration = 0;
        int i = 0;
        int j = 0;
        String SQPGLAIdat = "./results/SQPGLAI.dat";
        try {
            os = new FileOutputStream(SQPGLAIdat);
            this.initNetwork(os);
            System.out.println("a");
            this.startPoint();
            System.out.println("b");
            this.make_vec_c();
            System.out.println("c");
            this.make_DiagMat_Q();
            System.out.println("d");
            this.make_mat_Afix();
            System.out.println("e");
            this.make_vec_clave();
            System.out.println("f");
            cost2 = this.make_cost();
            System.out.println("g");
            cost1 = cost2;
            System.out.println("11");
            for (i = 0; i < this.numvar; ++i) {
                this.vec_xtemp[i] = 0.0;
            }
            for (i = 0; i < this.numres; ++i) {
                this.vec_lam[i] = 0.0;
            }
            while (!konv && iteration < this.iteraciones) {
                System.out.println("SQPGLAI-iteration... " + ++iteration);
                this.make_vec_OBJ();
                System.out.println(" Armado A ");
                this.make_mat_A();
                this.make_vec_RHS();
                System.out.println(" Armado W ");
                this.make_mat_W();
                this.update_vec_xlimits();
                this.myPPrintStream.println("ITERACION: " + iteration);
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("Vector absoluto");
                SQPGLAI.printVector(this.myPPrintStream, this.vec_xtempabs, this.numvar);
                this.myPPrintStream.println("Vector OBJ");
                SQPGLAI.printVector(this.myPPrintStream, this.vec_OBJ, this.numvar);
                this.myPPrintStream.println("Matriz A");
                SQPGLAI.printMatrix(this.myPPrintStream, this.mat_A, this.numres, this.numvar);
                this.myPPrintStream.println("Matriz W");
                SQPGLAI.printMatrix(this.myPPrintStream, this.mat_W, this.numvar, this.numvar);
                this.myPPrintStream.println("- RHS");
                SQPGLAI.printVector(this.myPPrintStream, this.vec_RHS, this.numres);
                if (this.metodo == 1 || this.metodo == 2 || this.metodo == 3 || this.metodo == 4) {
                    SimpleDialog ExceptionDialog;
                    String message;
                    PrintStream myPrintStream;
                    BufferedOutputStream bos;
                    try {
                        os = new FileOutputStream("./economic.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        System.out.println("Escritura de economic.dat");
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        myPrintStream.println(this.numres);
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_OBJ[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_RHS[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                myPrintStream.println(this.mat_A[i][j]);
                            }
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_clave[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmin[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmax[i]);
                        }
                        myPrintStream.println(" ");
                        myPrintStream.println("min");
                        myPrintStream.println("Ergebnisse aus SQP");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-economic.dat", message + " C1", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    try {
                        os = new FileOutputStream("./matw.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                myPrintStream.println(this.mat_W[i][j]);
                            }
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-Matw", message + " C2", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("Call Solver");
                    try {
                        SQPGLAI.Dorun(DeepEdit.PathDOS + "cuadra.bat", DeepEdit.PathUNIX + "cuadra.bat");
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Call Cuadra", message + " C3", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("End Solver");
                    try {
                        String ln;
                        is1 = new FileInputStream("./soluci.dat");
                        i = 0;
                        BufferedReader is = new BufferedReader(new InputStreamReader(is1));
                        while ((ln = is.readLine()) != null) {
                            if (i != 0) {
                                if (i <= this.numvar) {
                                    this.vec_xtemp[i - 1] = Double.valueOf(ln);
                                    int n = i - 1;
                                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i - 1];
                                } else {
                                    this.vec_lam[i - this.numvar - 1] = Double.valueOf(ln);
                                }
                            } else {
                                cost3 = Double.valueOf(ln);
                            }
                            ++i;
                        }
                        is.close();
                        is = null;
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB, reading soluci.dat", message + " C4", DlgButtons, 1, 0, 0, 1);
                    }
                }
                cost2 = this.make_cost();
                tol = ((cost2 += cost3) - cost1) * (cost2 - cost1);
                double feasIndex = 0.0;
                double maxModRHS = 0.0;
                for (i = 0; i < this.numnod; ++i) {
                    feasIndex += this.vec_RHS[i] * this.vec_RHS[i];
                    if (!(Math.abs(this.vec_RHS[i]) > maxModRHS)) continue;
                    maxModRHS = Math.abs(this.vec_RHS[i]);
                }
                feasIndex = Math.sqrt(feasIndex);
                System.out.println(" ----------------------------------------------");
                System.out.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem));
                System.out.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                System.out.println(" ----------------------------------------------");
                System.out.println(" Feasibility         = " + feasIndex);
                System.out.println(" Max corrimiento     = " + maxModRHS);
                System.out.println(" ----------------------------------------------");
                System.out.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                System.out.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                System.out.println(" ----------------------------------------------");
                System.out.println(" ----------------------------------------------");
                System.out.println(" Fun Ob [$]          = " + cost2);
                System.out.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem));
                this.myPPrintStream.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Feasibility         = " + feasIndex);
                this.myPPrintStream.println(" Max corrimiento     = " + maxModRHS);
                this.myPPrintStream.println(" SP Result [$]       = " + cost3);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                this.myPPrintStream.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Fun Ob [$]          = " + cost2);
                this.myPPrintStream.println(" ----------------------------------------------");
                if (feasIndex <= this.tolfeas * Math.sqrt(this.totdem * this.totdem) / 100.0 && Math.abs(cost2 - cost1) <= this.tolcost * (cost2 + cost1) / 2.0 / 100.0) {
                    System.out.println("   ");
                    System.out.println("          *************************  ");
                    System.out.println("          *Convergencia Encontrada*  ");
                    System.out.println("          *************************  ");
                    System.out.println("   ");
                    this.myPPrintStream.println("   ");
                    this.myPPrintStream.println("          *************************  ");
                    this.myPPrintStream.println("          *Convergencia Encontrada*  ");
                    this.myPPrintStream.println("          *************************  ");
                    this.myPPrintStream.println("   ");
                    konv = true;
                }
                this.myPPrintStream.println("Vector incremental");
                SQPGLAI.printVector(this.myPPrintStream, this.vec_xtemp, this.numvar);
                this.myPPrintStream.println("Vector de Costos");
                SQPGLAI.printVector(this.myPPrintStream, this.vec_c, this.numvar);
                this.myPPrintStream.println("Vector absoluto");
                SQPGLAI.printVector(this.myPPrintStream, this.vec_xtempabs, this.numvar);
                this.myPPrintStream.println("Multiplicadores");
                SQPGLAI.printVector(this.myPPrintStream, this.vec_lam, this.numres);
                this.myPPrintStream.println("Matriz X");
                SQPGLAI.printMatrix(this.myPPrintStream, this.MatX, this.numnod, this.numnod);
                this.myPPrintStream.println("Matriz G");
                SQPGLAI.printMatrix(this.myPPrintStream, this.MatG, this.numnod, this.numnod);
                cost1 = cost2;
                if (iteration == 1) {
                    konv = false;
                }
                if (iteration <= this.iteraciones) continue;
                this.overiter = true;
            }
            this.ActSchematic.setfitnes(-cost2);
            this.totcost = cost2;
            this.ActSchematic.settotcost(this.totcost);
            this.WriteResults();
            this.ActSchematic.settotgen(this.totgen);
            this.ActSchematic.settotunser(this.totunser);
            this.totloss = this.totgen - this.totdem;
            this.ActSchematic.settotloss(this.totloss);
            this.ActSchematic.settotdem(this.totdem);
            this.totincome = 0.0;
            this.totsales = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                this.totsales += -this.node_p[i] * this.vec_lam[i];
            }
            for (i = 0; i < this.numgen; ++i) {
                this.totincome += this.vec_lam[this.VarNode[i]] * this.vec_xtempabs[i];
            }
            System.out.println("************************************************************");
            System.out.println(" Optimization Results");
            System.out.println(" Objective Function  [$]  = " + cost2);
            System.out.println("************************************************************");
            System.out.println(" Operation costs          = " + this.totcost + " [$]");
            System.out.println(" Active Generation        = " + this.totgen + " [MW]");
            System.out.println(" Load Unserved            = " + this.totunser + " [MW]");
            System.out.println(" Total Active Loss        = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            System.out.println(" Total Active Demand      = " + this.totdem + " [MW]");
            System.out.println(" Total Load Sales         = " + this.totsales + " [$]");
            System.out.println(" Total Generator Income   = " + this.totincome + " [$]");
            System.out.println("************************************************************");
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Optimization Results");
            this.myPPrintStream.println(" Objective Function  [$]  = " + cost2);
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Operation costs          = " + this.totcost + " [$]");
            this.myPPrintStream.println(" Active Generation        = " + this.totgen + " [MW]");
            this.myPPrintStream.println(" Load Unserved            = " + this.totunser + " [MW]");
            this.myPPrintStream.println(" Total Active Loss        = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            this.myPPrintStream.println(" Total Active Demand      = " + this.totdem + " [MW]");
            this.myPPrintStream.println(" Total Load Sales         = " + this.totsales + " [$]");
            this.myPPrintStream.println(" Total Generator Income   = " + this.totincome + " [$]");
            this.myPPrintStream.println("************************************************************");
            this.ActSchematic.Modified = false;
            this.ActSchematic.Modifiedstate = false;
            this.ActSchematic.changeGIS = true;
            DeepEdit.MySchematicPanel.repaint();
            os.close();
            this.IdidntRealize();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPGLAI", message + " C5", DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            this.myPPrintStream.close();
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.MySQPGLAIVisualFrame == null) {
            this.MySQPGLAIVisualFrame = new SQPGLAIVisualFrame(this);
        } else {
            this.MySQPGLAIVisualFrame.setVisible(true);
        }
        if (this.MyColorSpec == null) {
            this.MyColorSpec = new ColorSpec("SQPGL Color Definition");
        } else {
            this.MyColorSpec.setVisible(true);
        }
    }

    public void initNetwork(FileOutputStream os) {
        ndb_inj TempInj;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        this.myPPrintStream = new PrintStream(os);
        this.myPPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        int i = 0;
        int j = 0;
        int count = 0;
        int count1 = 0;
        boolean count2 = false;
        int count3 = 0;
        int count4 = 0;
        boolean count5 = false;
        int con1 = 10000;
        int con2 = 10000;
        this.BusbarVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        this.totdem = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                TempBusbar = (Busbar)TempComponent;
                this.myPPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Considerada");
                ++this.numnod;
                this.BusbarVectorI.addElement(TempComponent);
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtran;
                }
                ++this.numbran;
            }
            if (TempComponent instanceof ndb_inj) {
                TempComponent.InformAllComponents();
                if (this.GenAI.equals(TempComponent.getName())) {
                    TempInj = (ndb_inj)TempComponent;
                    this.PGMax = TempInj.getpmax();
                }
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            Load TempLoad = (Load)TempComponent;
            ++this.numlast;
            this.totdem += TempLoad.getp();
        }
        this.numgen = 1;
        this.numlast = 1;
        this.numvar = 2 + this.numnod;
        this.numres = this.linres ? this.numnod + 2 * this.numbran : this.numnod;
        System.out.println("a0");
        System.out.println("numvar= " + this.numvar);
        System.out.println("numres= " + this.numres);
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.VarNode = new int[this.numvar];
        this.vec_clave = new int[this.numres];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_xant = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[this.numvar];
        this.vec_RHS = new double[this.numres];
        this.vec_OBJ = new double[this.numvar];
        this.DiagMat_Q = new double[this.numvar];
        this.node_p = new double[this.numnod];
        this.MatG = new double[this.numnod][this.numnod];
        this.MatX = new double[this.numnod][this.numnod];
        this.mat_A = new double[this.numres][this.numvar];
        this.mat_W = new double[this.numvar][this.numvar];
        this.MatY = new Complex[this.numnod][this.numnod];
        this.Flujo = new double[this.numbran];
        this.NomBra = new String[this.numbran];
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.MatY[i][j] = new Complex();
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Complex auxc2;
            Complex auxc1;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                System.out.println("Line " + TempComponent.getName() + " ----");
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.sref * (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = auxc2.divide(auxc1);
                auxc2 = new Complex(0.0, this.BranchB[count]);
                System.out.println("auxc1 " + auxc1.toString());
                System.out.println("auxc2 " + auxc2.toString());
                System.out.println("branchi " + this.BranchI[count]);
                System.out.println("branchj " + this.BranchJ[count]);
                System.out.println("aa J:" + this.BranchJ[count] + " I:" + this.BranchI[count]);
                this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.NomBra[count] = TempLine.getName();
                ++count;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                TempTrafo.sett_re_old(TempTrafo.gett_re());
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 != 10000 && (con2 = this.numbus(TempTrafo.getcon2())) != 10000) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                    b = TempTrafo.geti0() * 0.01 * 0.5 / this.sref * TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.BranchB[count] = b;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(TempTrafo.gett_re() * TempTrafo.gett_re()));
                    this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    this.NomBra[count] = TempTrafo.getName();
                    ++count;
                    ++count3;
                }
            }
            if (TempComponent instanceof ndb_inj && this.GenAI.equals((TempInj = (ndb_inj)TempComponent).getName()) && count1 < 1) {
                this.vec_xminabs[0] = TempInj.getpmin() / this.sref;
                this.vec_xmaxabs[0] = TempInj.getpmax() / this.sref;
                this.vec_xtempabs[0] = Math.max(this.vec_xminabs[0], TempInj.getp() / this.sref);
                ++count1;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.vec_xminabs[count4 + this.numgen + this.numlast] = -3.0;
            this.vec_xmaxabs[count4 + this.numgen + this.numlast] = 3.0;
            if (this.SEBE.equals(TempBusbar.getName())) {
                this.vec_xminabs[1] = 0.0;
                this.vec_xmaxabs[1] = this.PGMax * 0.9 / this.sref;
            }
            ++count4;
        }
        double are = 0.0;
        double aim = 0.0;
        Complex aco = new Complex();
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                if (Complex.abs((Complex)this.MatY[i][j]) > 1.0E-6 && i != j) {
                    aco = new Complex(1.0, 0.0);
                    aco = Complex.negate((Complex)Complex.divide((Complex)aco, (Complex)this.MatY[i][j]));
                    are = aco.re;
                    aim = aco.im;
                    this.MatG[i][j] = are / (are * are + aim * aim);
                    this.MatX[i][j] = aim;
                    continue;
                }
                this.MatG[i][j] = 0.0;
                this.MatX[i][j] = 0.0;
            }
        }
    }

    public static void printMatrix(PrintStream myPrintStream, Complex[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(PrintStream myPrintStream, double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                System.out.print(m[i][j] + "\t ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(PrintStream myPrintStream, Complex[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(PrintStream myPrintStream, double[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(int[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i] + "\t");
            System.out.println();
        }
        System.out.println();
    }

    public void update_vec_xlimits() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i] - this.vec_xtempabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i] - this.vec_xtempabs[i];
        }
    }

    public void make_vec_c() {
        int i = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.vec_c[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            ndb_inj TempInj;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj && this.GenAI.equals((TempInj = (ndb_inj)TempComponent).getName()) && count < 1) {
                this.VarNode[count] = this.numbus(TempInj.getcon2());
                ++count;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            ++count1;
        }
        this.vec_c[0] = 1.0;
        this.vec_c[1] = 100.0;
        this.VarNode[1] = this.numbus(this.SEBE);
        this.node_p[this.VarNode[1]] = -this.PGMax * 0.9 / this.sref;
    }

    public void make_mat_Afix() {
        boolean i = false;
        boolean j = false;
        int count = 0;
        this.mat_A[this.VarNode[0]][0] = 1.0;
        this.mat_A[this.VarNode[1]][1] = 1.0;
        if (this.linres) {
            int ix = 0;
            count = 0;
            int con1 = 10000;
            int con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Trafo TempTrafo;
                double xij;
                Complex yij;
                Complex auxc2;
                Complex auxc1;
                Line TempLine;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                ndb_branch Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    if (Math.abs(xij) > 1.0E-7) {
                        this.mat_A[this.numnod + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                        this.mat_A[this.numnod + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                        this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                        this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                    } else {
                        System.out.println("ERROR: Too low reactance");
                    }
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                if (Math.abs(xij) > 1.0E-7) {
                    this.mat_A[this.numnod + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                    this.mat_A[this.numnod + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                    this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                    this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                } else {
                    System.out.println("ERROR: Too low reactance");
                }
                ++count;
            }
        }
    }

    public void make_mat_W() {
        int j;
        int i;
        int nn = this.numnod;
        int off = this.numgen + this.numlast;
        for (i = 0; i < this.numvar; ++i) {
            for (j = 0; j < this.numvar; ++j) {
                this.mat_W[i][j] = 0.0;
            }
        }
        for (i = 0; i < off; ++i) {
            this.mat_W[i][i] = this.DiagMat_Q[i];
        }
        for (int k = 0; k < nn; ++k) {
            for (i = 0; i < nn; ++i) {
                for (j = 0; j < nn; ++j) {
                    if (i == j && k == i) {
                        for (int v = 0; v < nn; ++v) {
                            if (!(Math.abs(this.MatG[i][v]) > 1.0E-6)) continue;
                            double[] dArray = this.mat_W[i + off];
                            int n = j + off;
                            dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[i][v] * Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + v]);
                        }
                    }
                    if (i == j && k != i && Math.abs(this.MatG[k][i]) > 1.0E-6) {
                        double[] dArray = this.mat_W[i + off];
                        int n = j + off;
                        dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][i] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + i]);
                        double[] dArray2 = this.mat_W[j + off];
                        int n2 = i + off;
                        dArray2[n2] = dArray2[n2] + this.vec_lam[k] * this.MatG[k][i] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + i]);
                    }
                    if (i == j || k != i || !(Math.abs(this.MatG[k][j]) > 1.0E-6)) continue;
                    double[] dArray = this.mat_W[i + off];
                    int n = j + off;
                    dArray[n] = dArray[n] - this.vec_lam[k] * this.MatG[i][j] * Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]);
                    double[] dArray3 = this.mat_W[j + off];
                    int n3 = i + off;
                    dArray3[n3] = dArray3[n3] - this.vec_lam[k] * this.MatG[i][j] * Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]);
                }
            }
        }
    }

    public void make_DiagMat_Q() {
        int i = 0;
        boolean ix = false;
        boolean count = false;
        boolean count1 = false;
        for (i = 0; i < this.numvar; ++i) {
            this.DiagMat_Q[i] = 0.0;
        }
    }

    public void startPoint() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xtempabs[i] = 0.0;
        }
    }

    public double make_cost() {
        double cost = 0.0;
        for (int i = 0; i < 2; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        return cost;
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void make_vec_OBJ() {
        int i = 0;
        boolean ix = false;
        boolean count = false;
        for (i = 0; i < 2; ++i) {
            this.vec_OBJ[i] = this.vec_c[i] + this.DiagMat_Q[i] * this.vec_xtempabs[i];
        }
    }

    public void make_mat_A() {
        boolean count = false;
        boolean count1 = false;
        int off = this.numgen + this.numlast;
        for (int row = 0; row < this.numnod; ++row) {
            for (int col = 2; col < 2 + this.numnod; ++col) {
                this.mat_A[row][col] = 0.0;
            }
        }
        for (int i = 0; i < this.numnod; ++i) {
            for (int k = 0; k < this.numnod; ++k) {
                if (i == k) {
                    for (int v = 0; v < this.numnod; ++v) {
                        if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-6)) continue;
                        double[] dArray = this.mat_A[i];
                        int n = off + k;
                        dArray[n] = dArray[n] - (this.MatG[k][v] * Math.sin(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + v]) + 1.0 / this.MatX[k][v]);
                    }
                }
                if (k == i || !(Math.abs(this.MatX[i][k]) > 1.0E-6)) continue;
                this.mat_A[i][off + k] = this.MatG[i][k] * Math.sin(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + k]) + 1.0 / this.MatX[i][k];
            }
        }
    }

    public void make_vec_RHS() {
        int i = 0;
        int j = 0;
        double tempa = 0.0;
        int off = 2;
        for (i = 0; i < this.numres; ++i) {
            this.vec_RHS[i] = 0.0;
        }
        for (i = 0; i < this.numnod; ++i) {
            this.vec_RHS[i] = -this.node_p[i];
        }
        int n = this.VarNode[0];
        this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[0];
        int n2 = this.VarNode[1];
        this.vec_RHS[n2] = this.vec_RHS[n2] - this.vec_xtempabs[1];
        i = 0;
        while (i < this.numnod) {
            tempa = 0.0;
            for (j = 0; j < this.numnod; ++j) {
                if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                tempa += this.MatG[i][j] * (1.0 - Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j])) + (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) / this.MatX[i][j];
            }
            int n3 = i++;
            this.vec_RHS[n3] = this.vec_RHS[n3] + tempa;
        }
        if (this.linres) {
            int ix = 0;
            int count = 0;
            int con1 = 10000;
            int con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Trafo TempTrafo;
                double xij;
                Complex yij;
                Complex auxc2;
                Complex auxc1;
                Line TempLine;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                ndb_branch Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    this.vec_RHS[this.numnod + count] = -TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                    this.vec_RHS[this.numnod + this.numbran + count] = TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                this.vec_RHS[this.numnod + count] = -TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                this.vec_RHS[this.numnod + this.numbran + count] = TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                ++count;
            }
        }
    }

    public void make_vec_clave() {
        int i;
        for (i = 0; i < this.numnod; ++i) {
            this.vec_clave[i] = 1;
        }
        if (this.linres) {
            for (i = this.numnod; i < this.numnod + this.numbran; ++i) {
                this.vec_clave[i] = 3;
            }
            for (i = this.numnod + this.numbran; i < this.numnod + 2 * this.numbran; ++i) {
                this.vec_clave[i] = 2;
            }
        }
    }

    public void WriteResults() {
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        boolean i = false;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        int count3 = 0;
        int con1 = 10000;
        int con2 = 10000;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        boolean rama = false;
        this.totgen = 0.0;
        this.totdem = 0.0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Trafo TempTrafo;
            double f21;
            double gmula;
            double f12;
            Line TempLine;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                TempLoad.setunser_p(0.0);
                if (this.SEBE.equals(TempLoad.getcon2()) && count2 < 1) {
                    if (Math.abs(this.vec_xtempabs[1] * this.sref) < 0.001) {
                        TempLoad.setunser_p(0.0);
                    } else {
                        TempLoad.setunser_p(this.vec_xtempabs[1] * this.sref);
                    }
                    this.totunser += this.vec_xtempabs[1] * this.sref;
                    this.totdem += this.PGMax * 0.9;
                    ++count2;
                }
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                TempInj.setp(0.0);
                if (this.GenAI.equals(TempInj.getName()) && potas < 1) {
                    if (Math.abs(this.vec_xtempabs[0] * this.sref) < 0.001) {
                        TempInj.setp(0.0);
                    } else {
                        TempInj.setp(this.vec_xtempabs[0] * this.sref);
                    }
                    this.totgen += this.vec_xtempabs[0] * this.sref;
                    ++potas;
                }
            }
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                double angulin = this.vec_xtempabs[this.numgen + this.numlast + nodo] * 180.0 / Math.PI;
                TempBusbar.setdelta2(angulin);
                double spotin = this.vec_lam[nodo] / this.sref;
                TempBusbar.setspot_p(spotin);
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                f12 = 0.0;
                gmula = 0.0;
                if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                    gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                    f12 = (this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                    TempLine.setp12(f12);
                    this.Flujo[count] = f12;
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    f12 = 0.0;
                }
                f21 = 0.0;
                if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                    gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                    f21 = (this.vec_xtempabs[this.numgen + this.numlast + con2] - this.vec_xtempabs[this.numgen + this.numlast + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                    TempLine.setp21(f21);
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    f21 = 0.0;
                }
                ++count;
            }
            if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
            f12 = 0.0;
            gmula = 0.0;
            if (TempTrafo.gett_re() > 1.0E-6) {
                this.BranchX[count] = this.BranchX[count] * TempTrafo.gett_re();
                this.BranchR[count] = this.BranchR[count] * TempTrafo.gett_re();
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                this.Flujo[count] = f12 = (this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                TempTrafo.setp12(f12);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
            }
            f21 = 0.0;
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f21 = (this.vec_xtempabs[this.numgen + this.numlast + con2] - this.vec_xtempabs[this.numgen + this.numlast + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                TempTrafo.setp21(f21);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f21 = 0.0;
            }
            ++count;
            ++count3;
        }
    }

    public void setParameters(String solver, String iteras, String tolera1, String tolera2, boolean linr, String genai, String loadCenter) {
        if (solver.equals("Minos            ")) {
            this.metodo = 1;
        } else if (solver.equals("Zoutendijk       ")) {
            this.metodo = 1;
        } else if (solver.equals("Rosen            ")) {
            this.metodo = 1;
        } else if (solver.equals("Cplex            ")) {
            this.metodo = 4;
        }
        if (iteras == "10               ") {
            this.iteraciones = 10;
        }
        if (iteras == "15               ") {
            this.iteraciones = 15;
        }
        if (iteras == "20               ") {
            this.iteraciones = 20;
        }
        if (iteras == "25               ") {
            this.iteraciones = 25;
        }
        if (iteras == "30               ") {
            this.iteraciones = 30;
        }
        if (iteras == "60               ") {
            this.iteraciones = 60;
        }
        if (iteras == "100              ") {
            this.iteraciones = 100;
        }
        if (tolera1 == "0.5          ") {
            this.tolfeas = 0.5;
        }
        if (tolera1 == "0.0001       ") {
            this.tolfeas = 1.0E-4;
        }
        if (tolera1 == "0.001        ") {
            this.tolfeas = 0.001;
        }
        if (tolera1 == "0.01         ") {
            this.tolfeas = 0.01;
        }
        if (tolera1 == "0.1          ") {
            this.tolfeas = 0.1;
        }
        if (tolera1 == "1            ") {
            this.tolfeas = 1.0;
        }
        if (tolera1 == "5            ") {
            this.tolfeas = 5.0;
        }
        if (tolera1 == "10           ") {
            this.tolfeas = 10.0;
        }
        if (tolera2 == "0.0001       ") {
            this.tolcost = 1.0E-4;
        }
        if (tolera2 == "0.001        ") {
            this.tolcost = 0.001;
        }
        if (tolera2 == "0.01         ") {
            this.tolcost = 0.01;
        }
        if (tolera2 == "0.1          ") {
            this.tolcost = 0.1;
        }
        if (tolera2 == "0.5          ") {
            this.tolcost = 0.5;
        }
        if (tolera2 == "1            ") {
            this.tolcost = 1.0;
        }
        if (tolera2 == "5            ") {
            this.tolcost = 5.0;
        }
        if (tolera2 == "10           ") {
            this.tolcost = 10.0;
        }
        this.linres = linr;
        this.SEBE = loadCenter;
        this.GenAI = genai;
    }

    public void IdidntRealize() {
        this.MySQPGLAIFrame = null;
        this.MatG = null;
        this.MatX = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchB = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.VarNode = null;
        this.vec_xminabs = null;
        this.vec_xmaxabs = null;
        this.vec_xmin = null;
        this.vec_xmax = null;
        this.vec_xtemp = null;
        this.vec_xtempabs = null;
        this.vec_xant = null;
        this.vec_c = null;
        this.vec_RHS = null;
        this.vec_OBJ = null;
        this.vec_lam = null;
        this.DiagMat_Q = null;
        this.node_p = null;
        this.vec_clave = null;
        this.mat_W = null;
        this.mat_A = null;
    }
}

