/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.SQPGLFrame;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloRange;
import ilog.cplex.IloCplex;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public final class SQPGL
extends AnalysisTool {
    SQPGLFrame MySQPGLFrame = null;
    double[][] MatG;
    double[][] MatX;
    double[][] MatFmax;
    protected Vector BusbarVectorI;
    int numbran = 0;
    int numnod = 0;
    int numgen = 0;
    int numtrafo = 0;
    int numlast = 0;
    int numvar = 0;
    int numres = 0;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    boolean overiter = false;
    double mean_c = 1000000.0;
    double[] vec_xminabs;
    double[] vec_xmaxabs;
    double[] vec_xmin;
    double[] vec_xmax;
    double[] vec_xtemp;
    double[] vec_xtempabs;
    double[] vec_xant;
    double[] vec_c;
    double[] vec_RHS;
    double[] vec_OBJ;
    double[] vec_lam;
    double[] DiagMat_Q;
    double[] node_p;
    int[] vec_clave;
    double totcost = 0.0;
    double totgen = 0.0;
    double totunser = 0.0;
    double totloss = 0.0;
    double totdem = 0.0;
    double totincome = 0.0;
    double totsales = 0.0;
    double totit = 0.0;
    double totunsercost = 0.0;
    int iteraciones;
    double tolerancia;
    double tolcost;
    double tolfeas;
    int metodo = 1;
    double[][] mat_W;
    double[][] mat_A;
    DeepEdit applet;
    PrintStream myPPrintStream;
    int tapito = 0;
    Complex[][] MatY;
    public boolean linres = true;
    public boolean incremental = false;
    double nummin = 1.0;
    int LossModel = 0;
    boolean exportTxData = false;
    static final String[] solverOptions = new String[]{"Minos SQP", "Cplex SQP"};
    static final String[] maxIterOptions = new String[]{"10", "15", "20", "25", "30", "60", "100"};
    static final String[] maxRHSTolOptions = new String[]{"0.0001", "0.001", "0.01", "0.1", "1", "5", "10"};
    static final String[] maxCostTolOptions = new String[]{"0.0001", "0.001", "0.01", "0.1", "0.5", "1", "5", "10"};
    static final String[] TimeFrameOptions = new String[]{"1", "5", "10", "15", "30", "60"};
    double[] Flujo;
    String[] NomBra;
    private double sref = this.getSref();

    SQPGL(Schematic sch) {
        super(sch);
        System.out.println("---------- In SQPGL Calculation Tool ------------ 1");
        if (this.MySQPGLFrame == null) {
            this.MySQPGLFrame = new SQPGLFrame(this);
        } else {
            this.MySQPGLFrame.setVisible(true);
        }
    }

    SQPGL(Schematic sch, int opt, String s) {
        super(sch);
        System.out.println("---------- In SQPGL Calculation Tool ------------ 2");
        int auxopt = 1;
        boolean auxfr = true;
        if (opt == 1) {
            auxopt = 1;
            auxfr = false;
        } else {
            auxopt = 4;
            auxfr = true;
        }
    }

    SQPGL(Schematic sch, int opt) {
        super(sch);
        System.out.println("---------- In SQPGL Calculation Tool ------------ 2");
        int auxopt = 1;
        int auxfr = 1;
        if (opt == 1) {
            auxopt = 1;
            auxfr = 0;
        } else {
            auxopt = 4;
            auxfr = 1;
        }
        this.setParameters(auxfr, 6, 0, 0, true, 1, false, 1, false);
        this.Calculate(true, auxopt);
    }

    public void Calculate(boolean sino, int modelo) {
        FileOutputStream os;
        boolean konv = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        double cost3 = 0.0;
        double tol = 0.0;
        FileInputStream is1 = null;
        int iteration = 0;
        int i = 0;
        int j = 0;
        try {
            String SQPGLdat = "./results/SQPGL.dat";
            os = new FileOutputStream(SQPGLdat);
            if (this.metodo == 5) {
                this.initNetwork(os);
                this.make_vec_c();
                this.make_DiagMat_Q();
                this.make_mat_Afix();
                IloCplex cplex = new IloCplex();
                cplex.setOut(null);
                cplex.setWarning(null);
            } else {
                this.initNetwork(os);
                this.startPoint();
                this.make_vec_c();
                this.make_DiagMat_Q();
                this.make_mat_Afix();
                this.make_vec_clave();
                cost1 = cost2 = this.make_cost();
                for (i = 0; i < this.numvar; ++i) {
                    this.vec_xtemp[i] = 0.0;
                }
                for (i = 0; i < this.numres; ++i) {
                    this.vec_lam[i] = 0.0;
                }
                while (!konv && iteration < this.iteraciones) {
                    System.out.println("SQPGL-iteration... " + ++iteration);
                    this.make_vec_OBJ();
                    this.make_mat_A();
                    this.make_vec_RHS();
                    this.make_mat_W();
                    this.update_vec_xlimits();
                    this.myPPrintStream.println("ITERACION: " + iteration);
                    this.myPPrintStream.println(" ");
                    this.myPPrintStream.println("Vector absoluto");
                    SQPGL.printVector(this.myPPrintStream, this.vec_xtempabs, this.numvar);
                    this.myPPrintStream.println("Vector OBJ");
                    SQPGL.printVector(this.myPPrintStream, this.vec_OBJ, this.numvar);
                    this.myPPrintStream.println("Matriz A");
                    SQPGL.printMatrix(this.myPPrintStream, this.mat_A, this.numres, this.numvar);
                    this.myPPrintStream.println("Matriz W");
                    SQPGL.printMatrix(this.myPPrintStream, this.mat_W, this.numvar, this.numvar);
                    this.myPPrintStream.println("- RHS");
                    SQPGL.printVector(this.myPPrintStream, this.vec_RHS, this.numres);
                    if (this.metodo == 1 || this.metodo == 2 || this.metodo == 3) {
                        SimpleDialog ExceptionDialog;
                        String message;
                        PrintStream myPrintStream;
                        BufferedOutputStream bos;
                        try {
                            os = new FileOutputStream("./economic.dat");
                            bos = new BufferedOutputStream(os, 32768);
                            myPrintStream = new PrintStream(bos, false);
                            System.out.println("Escritura de economic.dat");
                            myPrintStream.println(this.numvar);
                            myPrintStream.println(" ");
                            myPrintStream.println(this.numres);
                            myPrintStream.println(" ");
                            for (i = 0; i < this.numvar; ++i) {
                                myPrintStream.println(this.vec_OBJ[i]);
                            }
                            myPrintStream.println(" ");
                            for (i = 0; i < this.numres; ++i) {
                                myPrintStream.println(this.vec_RHS[i]);
                            }
                            myPrintStream.println(" ");
                            for (i = 0; i < this.numres; ++i) {
                                for (j = 0; j < this.numvar; ++j) {
                                    myPrintStream.println(this.mat_A[i][j]);
                                }
                                myPrintStream.println(" ");
                            }
                            myPrintStream.println(" ");
                            for (i = 0; i < this.numres; ++i) {
                                myPrintStream.println(this.vec_clave[i]);
                            }
                            myPrintStream.println(" ");
                            for (i = 0; i < this.numvar; ++i) {
                                myPrintStream.println(this.vec_xmin[i]);
                            }
                            myPrintStream.println(" ");
                            for (i = 0; i < this.numvar; ++i) {
                                myPrintStream.println(this.vec_xmax[i]);
                            }
                            myPrintStream.println(" ");
                            myPrintStream.println("min");
                            myPrintStream.println("Ergebnisse aus SQP");
                            myPrintStream.close();
                        }
                        catch (Exception e) {
                            message = e.toString();
                            String[] DlgButtons = new String[]{"OK"};
                            ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-economic.dat", message + " C1", DlgButtons, 1, 0, 0, 1);
                            return;
                        }
                        try {
                            os = new FileOutputStream("./matw.dat");
                            bos = new BufferedOutputStream(os, 32768);
                            myPrintStream = new PrintStream(bos, false);
                            myPrintStream.println(this.numvar);
                            myPrintStream.println(" ");
                            for (i = 0; i < this.numvar; ++i) {
                                for (j = 0; j < this.numvar; ++j) {
                                    myPrintStream.println(this.mat_W[i][j]);
                                }
                                myPrintStream.println(" ");
                            }
                            myPrintStream.println(" ");
                            myPrintStream.close();
                        }
                        catch (Exception e) {
                            message = e.toString();
                            String[] DlgButtons = new String[]{"OK"};
                            ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-Matw", message + " C2", DlgButtons, 1, 0, 0, 1);
                            return;
                        }
                        System.out.println("Call Solver");
                        try {
                            SQPGL.Dorun("cmd /C " + DeepEdit.PathDOS + "cuadra.exe>sys.log", DeepEdit.PathUNIX + "cuadra > sys.log", false);
                        }
                        catch (Exception e) {
                            message = e.toString();
                            String[] DlgButtons = new String[]{"OK"};
                            ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Call Cuadra", message + " C3", DlgButtons, 1, 0, 0, 1);
                            return;
                        }
                        System.out.println("End Solver");
                        try {
                            String ln;
                            is1 = new FileInputStream("./soluci.dat");
                            i = 0;
                            BufferedReader is = new BufferedReader(new InputStreamReader(is1));
                            while ((ln = is.readLine()) != null) {
                                if (i != 0) {
                                    if (i <= this.numvar) {
                                        this.vec_xtemp[i - 1] = Double.valueOf(ln);
                                        int n = i - 1;
                                        this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i - 1];
                                    } else {
                                        this.vec_lam[i - this.numvar - 1] = Double.valueOf(ln);
                                    }
                                } else {
                                    cost3 = Double.valueOf(ln);
                                }
                                ++i;
                            }
                            is.close();
                            is = null;
                        }
                        catch (Exception e) {
                            message = e.toString();
                            String[] DlgButtons = new String[]{"OK"};
                            ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB, reading soluci.dat", message + " C4", DlgButtons, 1, 0, 0, 1);
                        }
                    } else if (this.metodo == 4) {
                        try {
                            double[] coef;
                            IloCplex cplex = new IloCplex();
                            cplex.setOut(null);
                            cplex.setWarning(null);
                            IloCplex qp = cplex;
                            IloNumVar[] var = qp.numVarArray(this.numvar, this.vec_xmin, this.vec_xmax);
                            IloLinearNumExpr lin = cplex.scalProd(this.vec_OBJ, var);
                            IloNumExpr aux3 = cplex.constant(0);
                            for (j = 0; j < this.numvar; ++j) {
                                for (i = 0; i < this.numvar; ++i) {
                                    IloNumExpr aux2;
                                    if (this.mat_W[i][j] == 0.0) continue;
                                    if (i == j) {
                                        aux2 = cplex.prod(this.mat_W[i][j] / 2.0, cplex.square(var[i]));
                                        aux3 = cplex.sum(aux3, aux2);
                                        continue;
                                    }
                                    IloNumExpr aux1 = cplex.prod(this.mat_W[i][j] / 2.0, (IloNumExpr)var[j]);
                                    aux2 = cplex.prod(aux1, (IloNumExpr)var[i]);
                                    aux3 = cplex.sum(aux3, aux2);
                                }
                            }
                            IloNumExpr obj = cplex.sum((IloNumExpr)lin, aux3);
                            qp.addMinimize(obj);
                            int numCRest = this.linres ? this.numnod + 2 * this.numbran : this.numnod;
                            IloRange[] res = new IloRange[numCRest];
                            for (i = 0; i < this.numnod; ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addEq(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                            if (this.linres) {
                                for (i = this.numnod; i < this.numnod + this.numbran; ++i) {
                                    coef = this.mat_A[i];
                                    res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                                    coef = this.mat_A[i + this.numbran];
                                    res[i + this.numbran] = cplex.addGe(this.vec_RHS[i + this.numbran], (IloNumExpr)cplex.scalProd(coef, var));
                                }
                            }
                            if (cplex.solve()) {
                                System.out.println("");
                                System.out.println("Optimal Solution Founded");
                                cost3 = cplex.getObjValue();
                                this.vec_xtemp = cplex.getValues(var);
                                for (i = 0; i < this.numvar; ++i) {
                                    int n = i;
                                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i];
                                }
                                for (i = 0; i < numCRest; ++i) {
                                    this.vec_lam[i] = cplex.getDual(res[i]);
                                }
                                System.out.println(" ");
                            } else {
                                System.out.println("");
                                System.out.println("  No Optimal Solution Founded");
                                System.out.println("   Some problems in problem definition ");
                            }
                            cplex.end();
                        }
                        catch (IloException e) {
                            System.err.println(" Concert exception caugth : " + e);
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                    cost2 = this.make_cost();
                    tol = ((cost2 += cost3) - cost1) * (cost2 - cost1);
                    double feasIndex = 0.0;
                    double maxModRHS = 0.0;
                    for (i = 0; i < this.numnod; ++i) {
                        feasIndex += this.vec_RHS[i] * this.vec_RHS[i];
                        if (!(Math.abs(this.vec_RHS[i]) > maxModRHS)) continue;
                        maxModRHS = Math.abs(this.vec_RHS[i]);
                    }
                    feasIndex = Math.sqrt(feasIndex);
                    System.out.println(" ----------------------------------------------");
                    System.out.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem));
                    System.out.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                    System.out.println(" ----------------------------------------------");
                    System.out.println(" Feasibility         = " + feasIndex);
                    System.out.println(" Max corrimiento     = " + maxModRHS);
                    System.out.println(" ----------------------------------------------");
                    System.out.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                    System.out.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                    System.out.println(" ----------------------------------------------");
                    System.out.println(" ----------------------------------------------");
                    System.out.println(" Fun Ob [$]          = " + cost2);
                    System.out.println(" ----------------------------------------------");
                    this.myPPrintStream.println(" ----------------------------------------------");
                    this.myPPrintStream.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem));
                    this.myPPrintStream.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                    this.myPPrintStream.println(" ----------------------------------------------");
                    this.myPPrintStream.println(" Feasibility         = " + feasIndex);
                    this.myPPrintStream.println(" Max corrimiento     = " + maxModRHS);
                    this.myPPrintStream.println(" SP Result [$]       = " + cost3);
                    this.myPPrintStream.println(" ----------------------------------------------");
                    this.myPPrintStream.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                    this.myPPrintStream.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                    this.myPPrintStream.println(" ----------------------------------------------");
                    this.myPPrintStream.println(" ----------------------------------------------");
                    this.myPPrintStream.println(" Fun Ob [$]          = " + cost2);
                    this.myPPrintStream.println(" ----------------------------------------------");
                    if (feasIndex <= this.tolfeas * Math.sqrt(this.totdem * this.totdem) / 100.0 && Math.abs(cost2 - cost1) <= this.tolcost * (cost2 + cost1) / 2.0 / 100.0) {
                        System.out.println("   ");
                        System.out.println("          *************************  ");
                        System.out.println("          *Convergencia Encontrada*  ");
                        System.out.println("          *************************  ");
                        System.out.println("   ");
                        this.myPPrintStream.println("   ");
                        this.myPPrintStream.println("          *************************  ");
                        this.myPPrintStream.println("          *Convergencia Encontrada*  ");
                        this.myPPrintStream.println("          *************************  ");
                        this.myPPrintStream.println("   ");
                        konv = true;
                    }
                    this.myPPrintStream.println("Vector incremental");
                    SQPGL.printVector(this.myPPrintStream, this.vec_xtemp, this.numvar);
                    this.myPPrintStream.println("Vector de Costos");
                    SQPGL.printVector(this.myPPrintStream, this.vec_c, this.numvar);
                    this.myPPrintStream.println("Vector absoluto");
                    SQPGL.printVector(this.myPPrintStream, this.vec_xtempabs, this.numvar);
                    this.myPPrintStream.println("Multiplicadores");
                    SQPGL.printVector(this.myPPrintStream, this.vec_lam, this.numres);
                    this.myPPrintStream.println("Matriz X");
                    SQPGL.printMatrix(this.myPPrintStream, this.MatX, this.numnod, this.numnod);
                    this.myPPrintStream.println("Matriz G");
                    SQPGL.printMatrix(this.myPPrintStream, this.MatG, this.numnod, this.numnod);
                    cost1 = cost2;
                    if (iteration == 1) {
                        konv = false;
                    }
                    if (iteration <= this.iteraciones) continue;
                    this.overiter = true;
                }
            }
            this.ActSchematic.setfitnes(-cost2);
            this.totcost = cost2;
            this.ActSchematic.settotcost(this.totcost);
            this.WriteResults();
            this.ActSchematic.settotgen(this.totgen);
            this.ActSchematic.settotunser(this.totunser);
            this.totloss = this.totgen + this.totunser - this.totdem;
            this.ActSchematic.settotloss(this.totloss);
            this.ActSchematic.settotdem(this.totdem);
            System.out.println("************************************************************");
            System.out.println(" Optimization Results");
            System.out.println(" Objective Function  [$]  = " + cost2);
            System.out.println("************************************************************");
            System.out.println(" Operation costs             = " + this.totcost + " [$]");
            System.out.println(" Active Generation           = " + this.totgen + " [MW]");
            System.out.println(" Load Unserved               = " + this.totunser + " [MW]");
            System.out.println(" Total Active Loss           = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            System.out.println(" Total Active Demand         = " + this.totdem + " [MW]");
            System.out.println(" Total Load Sales            = " + this.totsales + " [$]");
            System.out.println(" Total Generator Income      = " + this.totincome + " [$]");
            System.out.println(" Total Unserved Energy Costs = " + this.totunsercost + " [$]");
            System.out.println(" Total Marginal Income       = " + -this.totit + " [$]");
            System.out.println("************************************************************");
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Optimization Results");
            this.myPPrintStream.println(" Objective Function  [$]  = " + cost2);
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Operation costs             = " + this.totcost + " [$]");
            this.myPPrintStream.println(" Active Generation           = " + this.totgen + " [MW]");
            this.myPPrintStream.println(" Load Unserved               = " + this.totunser + " [MW]");
            this.myPPrintStream.println(" Total Active Loss           = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            this.myPPrintStream.println(" Total Active Demand         = " + this.totdem + " [MW]");
            this.myPPrintStream.println(" Total Load Sales            = " + this.totsales + " [$]");
            this.myPPrintStream.println(" Total Generator Income      = " + this.totincome + " [$]");
            this.myPPrintStream.println(" Total Unserved Energy Costs = " + this.totunsercost + " [$]");
            this.myPPrintStream.println(" Total Marginal Income       = " + -this.totit + " [$]");
            this.myPPrintStream.println("************************************************************");
            this.ActSchematic.Modified = false;
            this.ActSchematic.Modifiedstate = false;
            this.ActSchematic.changeGIS = true;
            DeepEdit.MySchematicPanel.repaint();
            os.close();
            this.IdidntRealize();
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPGL", message + " C5", DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            this.myPPrintStream.close();
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void initNetwork(FileOutputStream os) {
        Load TempLoad;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        this.myPPrintStream = new PrintStream(os);
        this.myPPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        int i = 0;
        int j = 0;
        int count = 0;
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        boolean count5 = false;
        int con1 = 10000;
        int con2 = 10000;
        this.BusbarVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        this.totdem = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                TempBusbar = (Busbar)TempComponent;
                this.myPPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Considerada");
                ++this.numnod;
                this.BusbarVectorI.addElement(TempComponent);
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtran;
                }
                ++this.numbran;
            }
            if (TempComponent instanceof ndb_inj) {
                TempComponent.InformAllComponents();
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            TempLoad = (Load)TempComponent;
            ++this.numlast;
            this.totdem += TempLoad.getp();
        }
        this.numvar = this.numgen + this.numlast + this.numnod;
        this.numres = this.linres ? this.numnod + 2 * this.numbran : this.numnod;
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.VarNode = new int[this.numvar];
        this.vec_clave = new int[this.numres];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_xant = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[this.numvar];
        this.vec_RHS = new double[this.numres];
        this.vec_OBJ = new double[this.numvar];
        this.DiagMat_Q = new double[this.numvar];
        this.node_p = new double[this.numnod];
        this.MatG = new double[this.numnod][this.numnod];
        this.MatX = new double[this.numnod][this.numnod];
        this.MatFmax = new double[this.numnod][this.numnod];
        this.mat_A = new double[this.numres][this.numvar];
        this.mat_W = new double[this.numvar][this.numvar];
        this.MatY = new Complex[this.numnod][this.numnod];
        this.Flujo = new double[this.numbran];
        this.NomBra = new String[this.numbran];
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.MatY[i][j] = new Complex();
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Complex auxc2;
            Complex auxc1;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.sref * (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = auxc2.divide(auxc1);
                this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                double[] dArray = this.MatFmax[this.BranchI[count]];
                int n = this.BranchJ[count];
                dArray[n] = dArray[n] + TempLine.getsmax();
                double[] dArray2 = this.MatFmax[this.BranchJ[count]];
                int n2 = this.BranchI[count];
                dArray2[n2] = dArray2[n2] + TempLine.getsmax();
                ++count;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                TempTrafo.sett_re_old(TempTrafo.gett_re());
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 != 10000 && (con2 = this.numbus(TempTrafo.getcon2())) != 10000) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                    b = TempTrafo.geti0() * 0.01 * 0.5 / this.sref * TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.BranchB[count] = b;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(TempTrafo.gett_re() * TempTrafo.gett_re()));
                    this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    double[] dArray = this.MatFmax[this.BranchI[count]];
                    int n = this.BranchJ[count];
                    dArray[n] = dArray[n] + TempTrafo.getsmax();
                    double[] dArray3 = this.MatFmax[this.BranchJ[count]];
                    int n3 = this.BranchI[count];
                    dArray3[n3] = dArray3[n3] + TempTrafo.getsmax();
                    ++count;
                    ++count3;
                }
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (this.incremental && TempComponent instanceof Generator) {
                    Generator TempGen = (Generator)TempComponent;
                    this.vec_xminabs[count1] = Math.max(TempGen.getpmin() / this.sref, TempGen.getp() / this.sref - TempGen.getgradD() / this.sref * this.nummin);
                    this.vec_xmaxabs[count1] = Math.min(TempGen.getpmax() / this.sref, TempGen.getp() / this.sref + TempGen.getgradU() / this.sref * this.nummin);
                } else {
                    this.vec_xminabs[count1] = TempInj.getpmin() / this.sref;
                    this.vec_xmaxabs[count1] = TempInj.getpmax() / this.sref;
                }
                this.vec_xtempabs[count1] = Math.max(this.vec_xminabs[count1], TempInj.getp() / this.sref);
                ++count1;
            }
            if (TempComponent instanceof Load) {
                TempLoad = (Load)TempComponent;
                this.vec_xminabs[count2 + this.numgen] = 0.0;
                this.vec_xmaxabs[count2 + this.numgen] = TempLoad.getp() / this.sref;
                ++count2;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.vec_xminabs[count4 + this.numgen + this.numlast] = -3.0;
            this.vec_xmaxabs[count4 + this.numgen + this.numlast] = 3.0;
            ++count4;
        }
        double are = 0.0;
        double aim = 0.0;
        Complex aco = new Complex();
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                if (Complex.abs((Complex)this.MatY[i][j]) > 1.0E-9 && i != j) {
                    aco = new Complex(1.0, 0.0);
                    aco = Complex.negate((Complex)Complex.divide((Complex)aco, (Complex)this.MatY[i][j]));
                    are = aco.re;
                    aim = aco.im;
                    this.MatG[i][j] = are / (are * are + aim * aim);
                    this.MatX[i][j] = aim;
                    continue;
                }
                this.MatG[i][j] = 0.0;
                this.MatX[i][j] = 0.0;
            }
        }
        if (this.exportTxData) {
            try {
                PrintWriter pw1 = new PrintWriter(new FileWriter(RESULT_FOLDER + File.separator + "Matrix_Reactances.csv"));
                PrintWriter pw2 = new PrintWriter(new FileWriter(RESULT_FOLDER + File.separator + "Matrix_Resistances.csv"));
                PrintWriter pw3 = new PrintWriter(new FileWriter(RESULT_FOLDER + File.separator + "Matrix_MaxCapacities.csv"));
                String st1 = "Reactances";
                String st2 = "Resistances";
                String st3 = "MaxCapacities";
                for (i = 0; i < this.numnod; ++i) {
                    st1 = st1 + "," + ((Busbar)this.BusbarVectorI.elementAt(i)).getName();
                }
                pw1.println(st1);
                pw2.println(st1);
                pw3.println(st1);
                for (i = 0; i < this.numnod; ++i) {
                    st2 = st3 = (st1 = ((Busbar)this.BusbarVectorI.elementAt(i)).getName());
                    for (j = 0; j < this.numnod; ++j) {
                        st1 = st1 + "," + this.MatX[i][j];
                        st2 = st2 + "," + this.MatG[i][j];
                        st3 = st3 + "," + this.MatFmax[i][j];
                    }
                    pw1.println(st1);
                    pw2.println(st2);
                    pw3.println(st3);
                }
                pw1.close();
                pw2.close();
                pw3.close();
            }
            catch (Exception e) {
                System.out.println("Currently Transmission data files are opened");
            }
        }
    }

    public static void printMatrix(PrintStream myPrintStream, Complex[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(PrintStream myPrintStream, double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                System.out.print(m[i][j] + "\t ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(PrintStream myPrintStream, Complex[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(PrintStream myPrintStream, double[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(int[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i] + "\t");
            System.out.println();
        }
        System.out.println();
    }

    public void update_vec_xlimits() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i] - this.vec_xtempabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i] - this.vec_xtempabs[i];
        }
    }

    public void make_vec_c() {
        int i = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.vec_c[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                this.vec_c[count] = TempInj.getbeta() * this.sref;
                this.VarNode[count] = this.numbus(TempInj.getcon2());
                ++count;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.vec_c[count1 + this.numgen] = TempLoad.getbeta() * this.sref;
            this.VarNode[count1 + this.numgen] = this.numbus(TempLoad.getcon2());
            int n = this.VarNode[count1 + this.numgen];
            this.node_p[n] = this.node_p[n] - TempLoad.getp0() / this.sref;
            ++count1;
        }
    }

    public void make_mat_Afix() {
        int i = 0;
        boolean j = false;
        int count = 0;
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.VarNode[i]][i] = 1.0;
        }
        for (i = 0; i < this.numlast; ++i) {
            this.mat_A[this.VarNode[i + this.numgen]][this.numgen + i] = 1.0;
        }
        if (this.linres) {
            int ix = 0;
            count = 0;
            int con1 = 10000;
            int con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Trafo TempTrafo;
                double xij;
                Complex yij;
                Complex auxc2;
                Complex auxc1;
                Line TempLine;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                ndb_branch Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    if (Math.abs(xij) > 1.0E-9) {
                        this.mat_A[this.numnod + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                        this.mat_A[this.numnod + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                        this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                        this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                    } else {
                        System.out.println("ERROR: Too low reactance in " + Tempbran.getName());
                    }
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                if (Math.abs(xij) > 1.0E-9) {
                    this.mat_A[this.numnod + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                    this.mat_A[this.numnod + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                    this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con1] = -1.0 / xij;
                    this.mat_A[this.numnod + this.numbran + count][this.numgen + this.numlast + con2] = 1.0 / xij;
                } else {
                    System.out.println("ERROR: Too low reactance in " + Tempbran.getName());
                }
                ++count;
            }
        }
    }

    public void make_mat_W() {
        block10: {
            int i;
            int off;
            int nn;
            block9: {
                nn = this.numnod;
                off = this.numgen + this.numlast;
                this.mat_W = new double[this.numvar][this.numvar];
                for (i = 0; i < off; ++i) {
                    this.mat_W[i][i] = this.DiagMat_Q[i];
                }
                if (this.LossModel != 1) break block9;
                for (int k = 0; k < nn; ++k) {
                    for (i = 0; i < nn; ++i) {
                        for (int j = 0; j < nn; ++j) {
                            if (i == j && k != i && Math.abs(this.MatG[k][i]) > 1.0E-9) {
                                double[] dArray = this.mat_W[i + off];
                                int n = j + off;
                                dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][i];
                                double[] dArray2 = this.mat_W[j + off];
                                int n2 = i + off;
                                dArray2[n2] = dArray2[n2] + this.vec_lam[k] * this.MatG[k][i];
                                double[] dArray3 = this.mat_W[i + off];
                                int n3 = i + off;
                                dArray3[n3] = dArray3[n3] - this.vec_lam[k] * this.MatG[k][i];
                                double[] dArray4 = this.mat_W[j + off];
                                int n4 = j + off;
                                dArray4[n4] = dArray4[n4] - this.vec_lam[k] * this.MatG[k][i];
                            }
                            if (i == j || k != i || !(Math.abs(this.MatG[k][j]) > 1.0E-9)) continue;
                            double[] dArray = this.mat_W[i + off];
                            int n = j + off;
                            dArray[n] = dArray[n] - this.vec_lam[k] * this.MatG[i][j];
                            double[] dArray5 = this.mat_W[j + off];
                            int n5 = i + off;
                            dArray5[n5] = dArray5[n5] - this.vec_lam[k] * this.MatG[i][j];
                            double[] dArray6 = this.mat_W[i + off];
                            int n6 = i + off;
                            dArray6[n6] = dArray6[n6] + this.vec_lam[k] * this.MatG[i][j];
                            double[] dArray7 = this.mat_W[j + off];
                            int n7 = j + off;
                            dArray7[n7] = dArray7[n7] + this.vec_lam[k] * this.MatG[i][j];
                        }
                    }
                }
                break block10;
            }
            if (this.LossModel != 2) break block10;
            for (int k = 0; k < nn; ++k) {
                for (i = 0; i < nn; ++i) {
                    for (int j = 0; j < nn; ++j) {
                        if (i == j && k != i && Math.abs(this.MatG[k][i]) > 1.0E-9) {
                            double[] dArray = this.mat_W[i + off];
                            int n = j + off;
                            dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][i] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + i]);
                            double[] dArray8 = this.mat_W[j + off];
                            int n8 = i + off;
                            dArray8[n8] = dArray8[n8] + this.vec_lam[k] * this.MatG[k][i] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + i]);
                            double[] dArray9 = this.mat_W[i + off];
                            int n9 = i + off;
                            dArray9[n9] = dArray9[n9] - this.vec_lam[k] * this.MatG[k][i] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + i]);
                            double[] dArray10 = this.mat_W[j + off];
                            int n10 = j + off;
                            dArray10[n10] = dArray10[n10] - this.vec_lam[k] * this.MatG[k][i] * Math.cos(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + i]);
                        }
                        if (i == j || k != i || !(Math.abs(this.MatG[k][j]) > 1.0E-9)) continue;
                        double[] dArray = this.mat_W[i + off];
                        int n = j + off;
                        dArray[n] = dArray[n] - this.vec_lam[k] * this.MatG[i][j] * Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]);
                        double[] dArray11 = this.mat_W[j + off];
                        int n11 = i + off;
                        dArray11[n11] = dArray11[n11] - this.vec_lam[k] * this.MatG[i][j] * Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]);
                        double[] dArray12 = this.mat_W[i + off];
                        int n12 = i + off;
                        dArray12[n12] = dArray12[n12] + this.vec_lam[k] * this.MatG[i][j] * Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]);
                        double[] dArray13 = this.mat_W[j + off];
                        int n13 = j + off;
                        dArray13[n13] = dArray13[n13] + this.vec_lam[k] * this.MatG[i][j] * Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]);
                    }
                }
            }
        }
    }

    public void make_DiagMat_Q() {
        int i = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.DiagMat_Q[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                this.DiagMat_Q[count] = 2.0 * TempInj.getgamma() * this.sref * this.sref;
                ++count;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.DiagMat_Q[count1 + this.numgen] = 2.0 * TempLoad.getgamma() * this.sref * this.sref;
            ++count1;
        }
    }

    public void startPoint() {
        int i = 0;
        int ix = 0;
        int count = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.vec_xtempabs[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.vec_xtempabs[count] = TempInj.getp0();
            ++count;
        }
    }

    public double make_cost() {
        double cost = 0.0;
        for (int i = 0; i < this.numgen + this.numlast; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        return cost;
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void make_vec_OBJ() {
        int i = 0;
        boolean ix = false;
        boolean count = false;
        for (i = 0; i < this.numgen + this.numlast; ++i) {
            this.vec_OBJ[i] = this.vec_c[i] + this.DiagMat_Q[i] * this.vec_xtempabs[i];
        }
    }

    public void make_mat_A() {
        block15: {
            int off;
            block16: {
                block14: {
                    boolean count = false;
                    boolean count1 = false;
                    off = this.numgen + this.numlast;
                    for (int row = 0; row < this.numnod; ++row) {
                        for (int col = this.numgen + this.numlast; col < this.numgen + this.numlast + this.numnod; ++col) {
                            this.mat_A[row][col] = 0.0;
                        }
                    }
                    if (this.LossModel != 1) break block14;
                    for (int i = 0; i < this.numnod; ++i) {
                        for (int k = 0; k < this.numnod; ++k) {
                            if (i == k) {
                                for (int v = 0; v < this.numnod; ++v) {
                                    if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-9)) continue;
                                    double[] dArray = this.mat_A[i];
                                    int n = off + k;
                                    dArray[n] = dArray[n] - (this.MatG[k][v] * (this.vec_xtempabs[off + k] - this.vec_xtempabs[off + v]) + 1.0 / this.MatX[k][v]);
                                }
                                continue;
                            }
                            if (!(Math.abs(this.MatX[i][k]) > 1.0E-9)) continue;
                            this.mat_A[i][off + k] = this.MatG[i][k] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + k]) + 1.0 / this.MatX[i][k];
                        }
                    }
                    break block15;
                }
                if (this.LossModel != 2) break block16;
                for (int i = 0; i < this.numnod; ++i) {
                    for (int k = 0; k < this.numnod; ++k) {
                        if (i == k) {
                            for (int v = 0; v < this.numnod; ++v) {
                                if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-9)) continue;
                                double[] dArray = this.mat_A[i];
                                int n = off + k;
                                dArray[n] = dArray[n] - (this.MatG[k][v] * Math.sin(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + v]) + 1.0 / this.MatX[k][v]);
                            }
                            continue;
                        }
                        if (!(Math.abs(this.MatX[i][k]) > 1.0E-9)) continue;
                        this.mat_A[i][off + k] = this.MatG[i][k] * Math.sin(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + k]) + 1.0 / this.MatX[i][k];
                    }
                }
                break block15;
            }
            if (this.LossModel != 0) break block15;
            for (int i = 0; i < this.numnod; ++i) {
                for (int k = 0; k < this.numnod; ++k) {
                    if (i == k) {
                        for (int v = 0; v < this.numnod; ++v) {
                            if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-9)) continue;
                            double[] dArray = this.mat_A[i];
                            int n = off + k;
                            dArray[n] = dArray[n] - 1.0 / this.MatX[k][v];
                        }
                        continue;
                    }
                    if (!(Math.abs(this.MatX[i][k]) > 1.0E-9)) continue;
                    this.mat_A[i][off + k] = 1.0 / this.MatX[i][k];
                }
            }
        }
    }

    public void make_vec_RHS() {
        int i = 0;
        int j = 0;
        double tempa = 0.0;
        int off = this.numgen + this.numlast;
        for (i = 0; i < this.numres; ++i) {
            this.vec_RHS[i] = 0.0;
        }
        for (i = 0; i < this.numnod; ++i) {
            this.vec_RHS[i] = -this.node_p[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
        }
        for (i = 0; i < this.numlast; ++i) {
            int n = this.VarNode[i + this.numgen];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i + this.numgen];
        }
        if (this.LossModel == 1) {
            i = 0;
            while (i < this.numnod) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-8) || j == i) continue;
                    tempa += this.MatG[i][j] / 2.0 * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) / this.MatX[i][j];
                }
                int n = i++;
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        } else if (this.LossModel == 2) {
            i = 0;
            while (i < this.numnod) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-8) || j == i) continue;
                    tempa += this.MatG[i][j] * (1.0 - Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j])) + (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) / this.MatX[i][j];
                }
                int n = i++;
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        } else if (this.LossModel == 0) {
            i = 0;
            while (i < this.numnod) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-8) || j == i) continue;
                    tempa += (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) / this.MatX[i][j];
                }
                int n = i++;
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        }
        if (this.linres) {
            int ix = 0;
            int count = 0;
            int con1 = 10000;
            int con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Trafo TempTrafo;
                double xij;
                Complex yij;
                Complex auxc2;
                Complex auxc1;
                Line TempLine;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                ndb_branch Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    this.vec_RHS[this.numnod + count] = -TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                    this.vec_RHS[this.numnod + this.numbran + count] = TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                this.vec_RHS[this.numnod + count] = -TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                this.vec_RHS[this.numnod + this.numbran + count] = TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                ++count;
            }
        }
    }

    public void make_vec_clave() {
        int i;
        for (i = 0; i < this.numnod; ++i) {
            this.vec_clave[i] = 1;
        }
        if (this.linres) {
            for (i = this.numnod; i < this.numnod + this.numbran; ++i) {
                this.vec_clave[i] = 3;
            }
            for (i = this.numnod + this.numbran; i < this.numnod + 2 * this.numbran; ++i) {
                this.vec_clave[i] = 2;
            }
        }
    }

    public void WriteResults() {
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        boolean i = false;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        int count3 = 0;
        int con1 = 10000;
        int con2 = 10000;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        boolean rama = false;
        this.totincome = 0.0;
        this.totsales = 0.0;
        this.totunsercost = 0.0;
        this.totit = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Trafo TempTrafo;
            double f21;
            double gmula;
            double f12;
            Line TempLine;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                if (Math.abs(this.vec_xtempabs[this.numgen + count2] * this.sref) < 0.001) {
                    TempLoad.setunser_p(0.0);
                } else {
                    TempLoad.setunser_p(this.vec_xtempabs[this.numgen + count2] * this.sref);
                }
                this.totsales += TempLoad.getp() * this.vec_lam[this.numbus(TempLoad.getcon2())] / this.sref;
                this.totunsercost += this.vec_xtempabs[this.numgen + count2] * this.sref * this.vec_lam[this.numbus(TempLoad.getcon2())] / this.sref;
                this.totunser += this.vec_xtempabs[this.numgen + count2] * this.sref;
                this.totdem += TempLoad.getp();
                ++count2;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (Math.abs(this.vec_xtempabs[potas] * this.sref) < 0.001) {
                    TempInj.setp(0.0);
                } else {
                    TempInj.setp(this.vec_xtempabs[potas] * this.sref);
                }
                this.totincome += this.vec_xtempabs[potas] * this.sref * this.vec_lam[this.numbus(TempInj.getcon2())] / this.sref;
                this.totgen += this.vec_xtempabs[potas] * this.sref;
                ++potas;
            }
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                double angulin = this.vec_xtempabs[this.numgen + this.numlast + nodo] * 180.0 / Math.PI;
                TempBusbar.setdelta2(angulin);
                double spotin = this.vec_lam[nodo] / this.sref;
                TempBusbar.setspot_p(spotin);
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                f12 = 0.0;
                gmula = 0.0;
                if (Math.abs(this.BranchX[count]) > 1.0E-8) {
                    gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                    f12 = (this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                    TempLine.setp12(f12);
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    f12 = 0.0;
                }
                f21 = 0.0;
                if (Math.abs(this.BranchX[count]) > 1.0E-8) {
                    gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                    f21 = (this.vec_xtempabs[this.numgen + this.numlast + con2] - this.vec_xtempabs[this.numgen + this.numlast + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                    TempLine.setp21(f21);
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    f21 = 0.0;
                }
                if (Math.abs(this.BranchX[count]) > 1.0E-8) {
                    this.Flujo[count] = (this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]) / this.BranchX[count];
                    this.NomBra[count] = TempLine.getName();
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    this.Flujo[count] = 0.0;
                    this.NomBra[count] = TempLine.getName();
                }
                this.totit += f12 * this.vec_lam[con1] + f21 * this.vec_lam[con2];
                ++count;
            }
            if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
            f12 = 0.0;
            gmula = 0.0;
            if (TempTrafo.gett_re() > 1.0E-8) {
                this.BranchX[count] = this.BranchX[count] * TempTrafo.gett_re();
                this.BranchR[count] = this.BranchR[count] * TempTrafo.gett_re();
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-8) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f12 = (this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                TempTrafo.setp12(f12);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
            }
            f21 = 0.0;
            if (Math.abs(this.BranchX[count]) > 1.0E-8) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f21 = (this.vec_xtempabs[this.numgen + this.numlast + con2] - this.vec_xtempabs[this.numgen + this.numlast + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]));
                TempTrafo.setp21(f21);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f21 = 0.0;
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-8) {
                this.Flujo[count] = (this.vec_xtempabs[this.numgen + this.numlast + con1] - this.vec_xtempabs[this.numgen + this.numlast + con2]) / this.BranchX[count];
                this.NomBra[count] = TempTrafo.getName();
            } else {
                System.out.println("Reactancia muy baja!!!");
                this.Flujo[count] = 0.0;
                this.NomBra[count] = TempTrafo.getName();
            }
            this.totit += f12 * this.vec_lam[con1] + f21 * this.vec_lam[con2];
            ++count;
            ++count3;
        }
    }

    public void setParameters(int solverOpIndex, int iterOpIndex, int tolRHSIndex, int tolCostOpIndex, boolean linr, int lossMod, boolean iincremental, int TimeFrameIndex, boolean expTxData) {
        this.exportTxData = expTxData;
        if (solverOpIndex == 0) {
            this.metodo = 1;
        } else if (solverOpIndex == 1) {
            this.metodo = 4;
        } else if (solverOpIndex == 2) {
            this.metodo = 5;
        }
        this.iteraciones = Integer.parseInt(maxIterOptions[iterOpIndex]);
        this.tolfeas = Double.parseDouble(maxRHSTolOptions[tolRHSIndex]);
        this.tolcost = Double.parseDouble(maxRHSTolOptions[tolCostOpIndex]);
        this.nummin = Double.parseDouble(TimeFrameOptions[TimeFrameIndex]);
        this.linres = linr;
        this.incremental = iincremental;
        this.LossModel = lossMod;
    }

    public void setParameters(int solverOpIndex, int iterOpIndex, int tolRHSIndex, int tolCostOpIndex, boolean linr, boolean lossMod, boolean iincremental, int TimeFrameIndex) {
        this.setParameters(solverOpIndex, iterOpIndex, tolRHSIndex, tolCostOpIndex, linr, lossMod ? 1 : 2, iincremental, TimeFrameIndex, false);
    }

    public void IdidntRealize() {
        this.MySQPGLFrame = null;
        this.MatG = null;
        this.MatX = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchB = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.VarNode = null;
        this.vec_xminabs = null;
        this.vec_xmaxabs = null;
        this.vec_xmin = null;
        this.vec_xmax = null;
        this.vec_xtemp = null;
        this.vec_xtempabs = null;
        this.vec_xant = null;
        this.vec_c = null;
        this.vec_RHS = null;
        this.vec_OBJ = null;
        this.vec_lam = null;
        this.DiagMat_Q = null;
        this.node_p = null;
        this.vec_clave = null;
        this.mat_W = null;
        this.mat_A = null;
    }
}

