/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.SQPB;
import de.core.SimpleDialog;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextField;

class SQPBOptionsFrame
extends Frame {
    SQPB appl;
    String nitera;
    String converg;
    int tiposimula;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    boolean alter1;
    boolean alter2;
    Checkbox alter1Checkbox;
    Checkbox alter2Checkbox;
    TextField MyTextField1 = null;
    TextField MyTextField2 = null;

    public SQPBOptionsFrame(SQPB app) {
        super("DeepEdit SQP Economic Dispatch Options");
        this.appl = app;
        this.setBackground(Color.lightGray);
        this.nitera = String.valueOf(this.appl.ActSchematic.getnitera());
        this.converg = String.valueOf(this.appl.ActSchematic.getconvergence());
        this.tiposimula = this.appl.ActSchematic.gettiposimula();
        if (this.tiposimula == 0) {
            this.alter1 = true;
            this.alter2 = false;
        } else {
            this.alter1 = false;
            this.alter2 = true;
        }
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "ECONOMIC DISPATCH (SQP) OPTIONS", gridbag, c, Color.blue);
        c.gridwidth = 4;
        c.anchor = 17;
        Utils.makeLabel(this, "Max. Number of iterations:", gridbag, c);
        this.MyTextField1 = Utils.makeTField(this, this.nitera, gridbag, c, 10);
        Utils.makeLabel(this, "Convergence limit", gridbag, c);
        c.gridwidth = 0;
        this.MyTextField2 = Utils.makeTField(this, this.converg, gridbag, c, 10);
        c.gridwidth = 0;
        Utils.makeLabel(this, "Ohmic Losses Model:", gridbag, c);
        c.gridwidth = 4;
        c.anchor = 17;
        Utils.makeLabel(this, "", gridbag, c);
        CheckboxGroup myCheckboxgroup = new CheckboxGroup();
        this.alter1Checkbox = new Checkbox("r f^2          ", myCheckboxgroup, this.alter1);
        this.add(this.alter1Checkbox);
        this.alter2Checkbox = new Checkbox("2 G cos(f x)   ", myCheckboxgroup, this.alter2);
        this.add(this.alter2Checkbox);
        Utils.makeLabel(this, "", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, "", gridbag, c);
        c.gridwidth = 4;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 4;
        Utils.makeButton(this, "OK", gridbag, c);
        c.gridwidth = 0;
        Utils.makeButton(this, "Cancel", gridbag, c);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public boolean handleEvent(Event ev) {
        if (ev.id == 201) {
            this.setVisible(false);
            this.appl.MySQPBOptionsFrame = null;
            return true;
        }
        return super.handleEvent(ev);
    }

    public void SetNewValues() {
        try {
            this.appl.ActSchematic.setnitera(Integer.parseInt(this.MyTextField1.getText()));
            this.appl.ActSchematic.setconvergence(Double.valueOf(this.MyTextField2.getText()));
            if (this.alter1Checkbox.getState()) {
                this.appl.ActSchematic.settiposimula(0);
            } else {
                this.appl.ActSchematic.settiposimula(1);
            }
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading SQP information", message, DlgButtons, 1, 0, 0, 1);
        }
        this.repaint();
    }

    @Override
    public boolean action(Event ev, Object arg) {
        if (ev.target instanceof Button) {
            String label = (String)arg;
            if (arg.equals("Cancel")) {
                this.setVisible(false);
                this.appl.MySQPBOptionsFrame = null;
                return true;
            }
            if (arg.equals("OK")) {
                this.SetNewValues();
                this.setVisible(false);
                DeepEdit.MySchematicPanel.repaint();
                this.appl.Calculate(true);
                this.appl.MySQPBOptionsFrame = null;
                return true;
            }
        }
        return false;
    }
}

