/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Line;
import de.core.Load;
import de.core.SQPBOptionsFrame;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class SQPB
extends AnalysisTool {
    protected Vector BusbarVector;
    SQPBOptionsFrame MySQPBOptionsFrame = null;
    String ctrla = null;
    DeepEdit applet;
    int numnod = 0;
    int numgen = 0;
    int numbran = 0;
    int numtrafo = 0;
    int numlast = 0;
    int numvar = 0;
    int numres = 0;
    boolean overiter = false;
    double mean_c = 1000000.0;
    double[] BranchR;
    double[] BranchX;
    double[] vec_xminabs;
    double[] vec_xmaxabs;
    double[] vec_xmin;
    double[] vec_xmax;
    double[] vec_xtemp;
    double[] vec_xtempabs;
    double[] vec_xtempabs_old;
    double[] vec_c;
    double[] vec_RHS;
    double[] vec_OBJ;
    double[] vec_lam;
    double[] DiagMat_Q;
    double[] node_p;
    double[] node_pl;
    double[] node_pg;
    double[] DCflow;
    double[] Nodeloss;
    double[] penalty;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    int[] vec_clave;
    double totcost = 0.0;
    double totgen = 0.0;
    double totunser = 0.0;
    double totloss = 0.0;
    double totdem = 0.0;
    private double sref = 100.0;
    DoubleMatrix GSDF;
    DoubleMatrix GGDF;
    DoubleMatrix mat_A;
    DoubleSquareMatrix mat_W;
    DoubleSquareMatrix MatX;

    public SQPB(DeepEdit app, Schematic sch) {
        super(sch);
        this.sref = this.getSref();
        System.out.println("---------- In SQPB ------------ 0");
        this.applet = app;
        if (this.MySQPBOptionsFrame == null) {
            this.MySQPBOptionsFrame = new SQPBOptionsFrame(this);
        } else {
            this.MySQPBOptionsFrame.setVisible(true);
        }
    }

    public SQPB(DeepEdit app, Schematic sch, boolean sino) {
        super(sch);
        this.applet = app;
        this.sref = this.getSref();
        System.out.println("---------- In SQPB ------------ 1");
        this.Calculate(sino);
    }

    public void Calculate(boolean sino) {
        int i = 0;
        int j = 0;
        int iteration = 0;
        double loss = 0.0;
        double cost1 = 0.0;
        double cost2 = 0.0;
        double cost3 = 0.0;
        double tol = 0.0;
        boolean konv = false;
        FileInputStream is1 = null;
        boolean newggdf = false;
        this.InitNetwork();
        this.StartPoint();
        this.update_vec_xlimits();
        this.make_vec_c();
        this.make_DiagMat_Q();
        this.build_Injection();
        loss = this.node_loss();
        this.build_GGDF(loss);
        this.make_mat_Afix();
        cost1 = cost2 = this.make_cost();
        for (i = 0; i < this.numvar; ++i) {
            this.vec_xtemp[i] = 0.0;
        }
        for (i = 0; i < this.numres; ++i) {
            this.vec_lam[i] = 0.0;
        }
        this.vec_lam[this.numres - 1] = this.mean_c;
        for (i = 0; i < this.numnod; ++i) {
            this.penalty[i] = this.mean_c;
        }
        while (!konv && iteration <= this.ActSchematic.getnitera()) {
            SimpleDialog ExceptionDialog;
            String[] DlgButtons;
            String message;
            PrintStream myPrintStream;
            BufferedOutputStream bos;
            FileOutputStream os;
            System.out.println("OPF-iteration... " + ++iteration);
            this.build_Injection();
            if (newggdf) {
                this.build_Flows();
                loss = this.node_loss();
                this.build_GGDF(loss);
                this.calc_penalty();
                this.mat_W = (DoubleSquareMatrix)this.mat_W.scalarMultiply(0.0);
                this.make_mat_Afix();
            }
            this.build_Flows();
            this.make_vec_OBJ();
            this.make_mat_A();
            this.make_vec_RHS();
            this.make_vec_clave();
            this.make_mat_W();
            this.update_vec_xlimits();
            for (i = 0; i < this.numvar; ++i) {
                this.vec_xtempabs_old[i] = this.vec_xtempabs[i];
            }
            try {
                os = new FileOutputStream("./economic.dat");
                bos = new BufferedOutputStream(os, 32768);
                myPrintStream = new PrintStream(bos, false);
                System.out.println("Schreiben der economic.dat");
                myPrintStream.println(this.numvar);
                myPrintStream.println(" ");
                myPrintStream.println(this.numres);
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    myPrintStream.println(this.vec_OBJ[i]);
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numres; ++i) {
                    myPrintStream.println(-this.vec_RHS[i]);
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numres; ++i) {
                    for (j = 0; j < this.numvar; ++j) {
                        myPrintStream.println(this.mat_A.getElement(i, j));
                    }
                    myPrintStream.println(" ");
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numres; ++i) {
                    myPrintStream.println(this.vec_clave[i]);
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    myPrintStream.println(this.vec_xmin[i]);
                }
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    myPrintStream.println(this.vec_xmax[i]);
                }
                myPrintStream.println(" ");
                myPrintStream.println("min");
                myPrintStream.println("Ergebnisse aus SQP");
                myPrintStream.close();
            }
            catch (Exception e) {
                message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-economic.dat", message, DlgButtons, 1, 0, 0, 1);
                return;
            }
            try {
                os = new FileOutputStream("./matw.dat");
                bos = new BufferedOutputStream(os, 32768);
                myPrintStream = new PrintStream(bos, false);
                myPrintStream.println(this.numvar);
                myPrintStream.println(" ");
                for (i = 0; i < this.numvar; ++i) {
                    for (j = 0; j < this.numvar; ++j) {
                        myPrintStream.println(this.mat_W.getElement(i, j));
                    }
                    myPrintStream.println(" ");
                }
                myPrintStream.println(" ");
                myPrintStream.close();
            }
            catch (Exception e) {
                message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-Matw", message, DlgButtons, 1, 0, 0, 1);
                return;
            }
            System.out.println("Call Minos");
            try {
                SQPB.Dorun(DeepEdit.PathDOS + "cuadra.bat", DeepEdit.PathUNIX + "cuadra.bat");
            }
            catch (Exception e) {
                message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Call Cuadra", message, DlgButtons, 1, 0, 0, 1);
                return;
            }
            System.out.println("End Minos");
            try {
                String ln;
                is1 = new FileInputStream("./soluci.dat");
                i = 0;
                BufferedReader is = new BufferedReader(new InputStreamReader(is1));
                while ((ln = is.readLine()) != null) {
                    if (i != 0) {
                        if (i <= this.numvar) {
                            this.vec_xtemp[i - 1] = Double.valueOf(ln);
                            int n = i - 1;
                            this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i - 1];
                        } else {
                            this.vec_lam[i - this.numvar - 1] = Double.valueOf(ln);
                        }
                    } else {
                        cost3 = Double.valueOf(ln);
                    }
                    ++i;
                }
                is.close();
                is = null;
            }
            catch (Exception e) {
                message = e.toString();
                DlgButtons = new String[]{"OK"};
                ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB, reading soluci.dat", message, DlgButtons, 1, 0, 0, 1);
            }
            cost2 = this.make_cost();
            tol = ((cost2 += cost3) - cost1) * (cost2 - cost1);
            System.out.println(" Toleranz= " + tol + " ,valor absoluto=" + Math.abs(cost2 - cost1));
            cost1 = cost2;
            newggdf = true;
            if (tol <= this.ActSchematic.getconvergence()) {
                konv = true;
            }
            if (iteration != 1) continue;
            konv = false;
        }
        if (iteration > this.ActSchematic.getnitera()) {
            this.overiter = true;
        }
        this.ActSchematic.setfitnes(-cost2);
        this.operation_cost();
        this.ActSchematic.settotcost(this.totcost);
        this.WriteResults();
        this.ActSchematic.settotgen(this.totgen);
        this.ActSchematic.settotunser(this.totunser);
        this.ActSchematic.settotloss(this.totloss);
        this.ActSchematic.settotdem(this.totdem);
        System.out.println("Optimization Results:");
        System.out.println("Objective Function  [$]=  " + cost2);
        System.out.println("  ");
        System.out.println("totcost, operation costs = " + this.totcost);
        System.out.println("totgen                   = " + this.totgen);
        System.out.println("totunser                 = " + this.totunser);
        System.out.println("totloss                  = " + this.totloss);
        System.out.println("totdem                   = " + this.totdem);
        this.ActSchematic.Modified = false;
        this.ActSchematic.Modifiedstate = false;
        this.ActSchematic.changeGIS = true;
        DeepEdit.MySchematicPanel.repaint();
    }

    public void WriteResults() {
        comp TempComponent;
        Busbar TempBusbar;
        int i = 0;
        boolean j = false;
        int ix = 0;
        int count = 0;
        double yy = 0.0;
        double refdelta = 0.0;
        double lloss = 0.0;
        double res = 0.0;
        double reac = 0.0;
        this.calc_penalty();
        for (i = 0; i < this.numnod; ++i) {
            this.penalty[i] = this.penalty[i] / this.sref;
        }
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            TempBusbar = (Busbar)this.BusbarVector.elementAt(ix);
            TempBusbar.setun2(TempBusbar.getun1());
            TempBusbar.setdelta2(0.0);
            for (i = 0; i < this.numnod; ++i) {
                yy = this.MatX.getElement(ix, i);
                TempBusbar.setdelta2(TempBusbar.getdelta2() + yy * (this.node_p[i] - this.Nodeloss[i]));
            }
        }
        TempBusbar = (Busbar)this.BusbarVector.elementAt(0);
        refdelta = TempBusbar.getdelta2();
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            TempBusbar = (Busbar)this.BusbarVector.elementAt(ix);
            TempBusbar.setdelta2((TempBusbar.getdelta2() - refdelta) * 180.0 / Math.PI);
            TempBusbar.setspot_p(this.penalty[ix]);
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            TempInj.setspot_p(this.penalty[this.VarNode[count]]);
            TempInj.setspot_q(0.0);
            TempInj.setp(this.vec_xtempabs[count] * this.sref);
            TempInj.setp0(this.vec_xtempabs[count] * this.sref);
            TempInj.setq(0.0);
            this.totgen += this.vec_xtempabs[count] * this.sref;
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            TempLoad.setspot_p(this.penalty[this.VarNode[count]]);
            TempLoad.setspot_q(0.0);
            TempLoad.setunser_p(this.vec_xtempabs[count] * this.sref);
            TempLoad.setunser_q(0.0);
            TempLoad.setp(TempLoad.getp0() - this.vec_xtempabs[count] * this.sref);
            this.totunser += this.vec_xtempabs[count] * this.sref;
            this.totdem += TempLoad.getp();
            ++count;
        }
        count = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_branch Tempbran = (ndb_branch)TempComponent;
            res = this.BranchR[count];
            reac = this.BranchX[count];
            if (this.ActSchematic.gettiposimula() == 0) {
                lloss = res * reac * reac / (res * res + reac * reac) * this.DCflow[count] * this.DCflow[count];
                this.totloss += lloss * this.sref;
            } else {
                lloss = 2.0 * res / (res * res + reac * reac) * (1.0 - Math.cos(reac * this.DCflow[count]));
                this.totloss += lloss * this.sref;
            }
            Tempbran.setp12(this.DCflow[count] + lloss / 2.0);
            Tempbran.setp21(-this.DCflow[count] + lloss / 2.0);
            Tempbran.setq12(0.0);
            Tempbran.setq21(0.0);
            if (this.DCflow[count] >= 0.0) {
                Tempbran.setm_incomep(this.penalty[this.BranchI[count]] * (this.DCflow[count] - lloss / 2.0) - this.penalty[this.BranchJ[count]] * (this.DCflow[count] + lloss / 2.0));
            } else {
                Tempbran.setm_incomep(this.penalty[this.BranchJ[count]] * (this.DCflow[count] - lloss / 2.0) - this.penalty[this.BranchI[count]] * (this.DCflow[count] + lloss / 2.0));
            }
            ++count;
        }
    }

    public void InitNetwork() {
        Line TempLine;
        comp TempComponent;
        int ix = 0;
        int i = 0;
        int j = 0;
        int count = 0;
        int count1 = 0;
        if (this.BusbarVector != null) {
            this.BusbarVector = null;
        }
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                this.BusbarVector.addElement(TempComponent);
                ++this.numnod;
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                } else {
                    TempComponent.InformAllComponents();
                }
                ++this.numbran;
            }
            if (TempComponent instanceof Trafo) {
                TempComponent.InformAllComponents();
                ++this.numtrafo;
            }
            if (TempComponent instanceof ndb_inj) {
                TempComponent.InformAllComponents();
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numlast;
        }
        this.numvar = this.numgen + this.numlast;
        this.numres = 2 * this.numbran + 1;
        System.out.println("numvar= " + this.numvar);
        System.out.println("numres= " + this.numres);
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.VarNode = new int[this.numvar];
        this.vec_clave = new int[this.numres];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_xtempabs_old = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[this.numvar];
        this.vec_RHS = new double[this.numres];
        this.vec_OBJ = new double[this.numvar];
        this.DiagMat_Q = new double[this.numvar];
        this.node_p = new double[this.numnod];
        this.node_pl = new double[this.numnod];
        this.node_pg = new double[this.numnod];
        this.Nodeloss = new double[this.numnod];
        this.DCflow = new double[this.numbran];
        this.penalty = new double[this.numnod];
        this.MatX = new DoubleSquareMatrix(this.numnod);
        DoubleSquareMatrix MatY = new DoubleSquareMatrix(this.numnod);
        DoubleSquareMatrix MatXX = new DoubleSquareMatrix(this.numnod - 1);
        this.GSDF = new DoubleMatrix(this.numbran, this.numnod);
        this.GGDF = new DoubleMatrix(this.numbran, this.numnod);
        this.mat_A = new DoubleMatrix(this.numres, this.numvar);
        this.mat_W = new DoubleSquareMatrix(this.numvar);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.DCflow[count] = TempLine.getp12() - (TempLine.getp12() + TempLine.getp21()) / 2.0;
                ++count;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                reac = Math.sqrt(z * z - res * res);
                this.BranchX[count] = reac / TempTrafo.gett_re();
                this.BranchR[count] = res / TempTrafo.gett_re();
                this.BranchI[count] = this.numbus(TempTrafo.getcon1());
                this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
                yy = 1.0 / this.BranchX[count];
                MatY.setElement(this.BranchJ[count], this.BranchI[count], MatY.getElement(this.BranchJ[count], this.BranchI[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchJ[count], MatY.getElement(this.BranchI[count], this.BranchJ[count]) - yy);
                MatY.setElement(this.BranchI[count], this.BranchI[count], MatY.getElement(this.BranchI[count], this.BranchI[count]) + yy);
                MatY.setElement(this.BranchJ[count], this.BranchJ[count], MatY.getElement(this.BranchJ[count], this.BranchJ[count]) + yy);
                this.DCflow[count] = TempTrafo.getp12() - (TempTrafo.getp12() + TempTrafo.getp21()) / 2.0;
                ++count;
            }
            if (!(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.vec_xminabs[count1] = TempInj.getpmin() / this.sref;
            this.vec_xmaxabs[count1] = TempInj.getpmax() / this.sref;
            this.vec_xtempabs[count1] = Math.max(this.vec_xminabs[count1], TempInj.getp() / this.sref);
            this.mean_c = Math.min(this.mean_c, TempInj.getspot_p() * this.sref);
            ++count1;
        }
        for (i = 0; i < this.numnod - 1; ++i) {
            for (j = 0; j < this.numnod - 1; ++j) {
                MatXX.setElement(i, j, MatY.getElement(i, j));
            }
        }
        MatXX = (DoubleSquareMatrix)MatXX.inverse();
        for (i = 0; i < this.numnod - 1; ++i) {
            for (j = 0; j < this.numnod - 1; ++j) {
                this.MatX.setElement(i, j, MatXX.getElement(i, j));
            }
        }
        count = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                reac = this.BranchX[count];
                for (i = 0; i < this.numnod - 1; ++i) {
                    y1 = this.MatX.getElement(this.BranchI[count], i);
                    y2 = this.MatX.getElement(this.BranchJ[count], i);
                    this.GSDF.setElement(count, i, (y1 - y2) / reac);
                }
                ++count;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.vec_xminabs[count1] = 0.0;
            this.vec_xmaxabs[count1] = TempLoad.getp() / this.sref;
            ++count1;
        }
    }

    public void update_vec_xlimits() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i] - this.vec_xtempabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i] - this.vec_xtempabs[i];
        }
    }

    public void make_vec_c() {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int count = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.vec_c[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.vec_c[count] = TempInj.getbeta() * this.sref;
            this.VarNode[count] = this.numbus(TempInj.getcon2());
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.vec_c[count] = TempLoad.getbeta() * this.sref;
            this.VarNode[count] = this.numbus(TempLoad.getcon2());
            ++count;
        }
    }

    public void make_mat_Afix() {
        int i = 0;
        int j = 0;
        boolean count = false;
        this.mat_A = (DoubleMatrix)this.mat_A.scalarMultiply(0.0);
        for (i = 0; i < this.numvar; ++i) {
            for (j = 0; j < this.numbran; ++j) {
                this.mat_A.setElement(j, i, this.GGDF.getElement(j, this.VarNode[i]));
                this.mat_A.setElement(this.numbran + j, i, -this.GGDF.getElement(j, this.VarNode[i]));
            }
        }
    }

    public void make_mat_W() {
        int i = 0;
        int j = 0;
        int k = 0;
        double res = 0.0;
        double reac = 0.0;
        double raux = 0.0;
        for (i = 0; i < this.numbran; ++i) {
            res = this.BranchR[i];
            reac = this.BranchX[i];
            for (j = 0; j < this.numvar; ++j) {
                for (k = 0; k < this.numvar; ++k) {
                    raux = this.ActSchematic.gettiposimula() == 0 ? 2.0 * res * reac * reac / (res * res + reac * reac) * this.GGDF.getElement(i, this.VarNode[j]) * this.GGDF.getElement(i, this.VarNode[k]) * this.vec_lam[2 * this.numbran] : 2.0 * res * reac * reac / (res * res + reac * reac) * Math.cos(reac * this.DCflow[i]) * this.GGDF.getElement(i, this.VarNode[j]) * this.GGDF.getElement(i, this.VarNode[k]) * this.vec_lam[2 * this.numbran];
                    this.mat_W.setElement(j, k, this.mat_W.getElement(j, k) + raux);
                }
            }
        }
        for (i = 0; i < this.numvar; ++i) {
            this.mat_W.setElement(i, i, this.mat_W.getElement(i, i) + this.DiagMat_Q[i]);
        }
    }

    public void make_DiagMat_Q() {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int count = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.DiagMat_Q[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.DiagMat_Q[count] = 2.0 * TempInj.getgamma() * this.sref * this.sref;
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.DiagMat_Q[count] = 2.0 * TempLoad.getgamma() * this.sref * this.sref;
            ++count;
        }
    }

    public void build_Injection() {
        boolean i = false;
        int ix = 0;
        int count = 0;
        for (ix = 0; ix < this.numnod; ++ix) {
            this.node_p[ix] = 0.0;
            this.node_pl[ix] = 0.0;
            this.node_pg[ix] = 0.0;
        }
        count = this.numgen;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            int n = this.VarNode[count];
            this.node_pl[n] = this.node_pl[n] + TempLoad.getp0() / this.sref;
            int n2 = this.VarNode[count];
            this.node_p[n2] = this.node_p[n2] - TempLoad.getp0() / this.sref;
            ++count;
        }
        for (ix = 0; ix < this.numgen; ++ix) {
            int n = this.VarNode[ix];
            this.node_p[n] = this.node_p[n] + this.vec_xtempabs[ix];
            int n3 = this.VarNode[ix];
            this.node_pg[n3] = this.node_pg[n3] + this.vec_xtempabs[ix];
        }
        for (ix = this.numgen; ix < this.numvar; ++ix) {
            int n = this.VarNode[ix];
            this.node_p[n] = this.node_p[n] + this.vec_xtempabs[ix];
        }
    }

    public void build_GGDF(double loss) {
        int i = 0;
        int j = 0;
        double Pges = 0.0;
        double[] vec_Dref = new double[this.numbran];
        for (i = 0; i < this.numnod; ++i) {
            Pges += this.node_pl[i];
        }
        Pges += loss;
        i = 0;
        while (i < this.numbran) {
            vec_Dref[i] = 0.0;
            for (j = 0; j < this.numnod - 1; ++j) {
                int n = i;
                vec_Dref[n] = vec_Dref[n] - this.GSDF.getElement(i, j) * (this.node_pl[j] + this.Nodeloss[j]);
            }
            int n = i++;
            vec_Dref[n] = vec_Dref[n] / Pges;
        }
        for (i = 0; i < this.numbran; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.GGDF.setElement(i, j, this.GSDF.getElement(i, j) + vec_Dref[i]);
            }
        }
    }

    public void StartPoint() {
        for (int i = this.numgen; i < this.numgen + this.numlast; ++i) {
            this.vec_xtempabs[i] = 0.0;
        }
    }

    public double make_cost() {
        double cost = 0.0;
        for (int i = 0; i < this.numvar; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        return cost;
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return 0;
    }

    public void build_Flows() {
        int i = 0;
        int j = 0;
        for (i = 0; i < this.numbran; ++i) {
            this.DCflow[i] = 0.0;
            for (j = 0; j < this.numnod; ++j) {
                int n = i;
                this.DCflow[n] = this.DCflow[n] + this.GGDF.getElement(i, j) * (this.node_p[j] + this.node_pl[j]);
            }
        }
    }

    public double node_loss() {
        int i = 0;
        double reac = 0.0;
        double res = 0.0;
        double lloss = 0.0;
        for (i = 0; i < this.numnod; ++i) {
            this.Nodeloss[i] = 0.0;
        }
        for (i = 0; i < this.numbran; ++i) {
            res = this.BranchR[i];
            reac = this.BranchX[i];
            if (this.ActSchematic.gettiposimula() == 0) {
                int n = this.BranchI[i];
                this.Nodeloss[n] = this.Nodeloss[n] + res * reac * reac / (res * res + reac * reac) * this.DCflow[i] * this.DCflow[i] / 2.0;
                int n2 = this.BranchJ[i];
                this.Nodeloss[n2] = this.Nodeloss[n2] + res * reac * reac / (res * res + reac * reac) * this.DCflow[i] * this.DCflow[i] / 2.0;
                lloss += res * reac * reac / (res * res + reac * reac) * this.DCflow[i] * this.DCflow[i];
                continue;
            }
            int n = this.BranchI[i];
            this.Nodeloss[n] = this.Nodeloss[n] + res / (res * res + reac * reac) * (1.0 - Math.cos(reac * this.DCflow[i]));
            int n3 = this.BranchJ[i];
            this.Nodeloss[n3] = this.Nodeloss[n3] + res / (res * res + reac * reac) * (1.0 - Math.cos(reac * this.DCflow[i]));
            lloss += 2.0 * res / (res * res + reac * reac) * (1.0 - Math.cos(reac * this.DCflow[i]));
        }
        return lloss;
    }

    public void calc_penalty() {
        int i = 0;
        int j = 0;
        double zz = 0.0;
        double yy = 0.0;
        double res = 0.0;
        double reac = 0.0;
        for (i = 0; i < this.numnod; ++i) {
            zz = 0.0;
            yy = 0.0;
            for (j = 0; j < this.numbran; ++j) {
                res = this.BranchR[j];
                reac = this.BranchX[j];
                if (this.ActSchematic.gettiposimula() == 0) {
                    yy += 2.0 * res * reac * reac / (res * res + reac * reac) * this.DCflow[j] * this.GGDF.getElement(j, i);
                    zz += -this.GSDF.getElement(j, i) - 1.0;
                    continue;
                }
                yy += 2.0 * res * reac / (res * res + reac * reac) * Math.sin(reac * this.DCflow[j]) * this.GGDF.getElement(j, i);
                zz += -this.GSDF.getElement(j, i) - 1.0;
            }
            this.penalty[i] = yy;
            zz /= this.total_loss();
        }
        for (i = 0; i < this.numnod; ++i) {
            this.penalty[i] = this.vec_lam[2 * this.numbran] * (1.0 - this.penalty[i]);
        }
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numbran; ++j) {
                int n = i;
                this.penalty[n] = this.penalty[n] + this.vec_lam[j] * this.GGDF.getElement(j, i);
                int n2 = i;
                this.penalty[n2] = this.penalty[n2] - this.vec_lam[j + this.numbran] * this.GGDF.getElement(j, i);
            }
        }
    }

    public void make_vec_OBJ() {
        comp TempComponent;
        int i = 0;
        int ix = 0;
        int count = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.vec_OBJ[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.vec_OBJ[count] = this.vec_xtempabs[count] * 2.0 * TempInj.getgamma() * this.sref + TempInj.getbeta() * this.sref;
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.vec_OBJ[count] = this.vec_xtempabs[count] * 2.0 * TempLoad.getgamma() * this.sref + TempLoad.getbeta() * this.sref;
            ++count;
        }
    }

    public void make_mat_A() {
        int i = 0;
        int j = 0;
        double res = 0.0;
        double reac = 0.0;
        for (i = 0; i < this.numvar; ++i) {
            this.mat_A.setElement(2 * this.numbran, i, 1.0);
        }
        for (i = 0; i < this.numvar; ++i) {
            for (j = 0; j < this.numbran; ++j) {
                res = this.BranchR[j];
                reac = this.BranchX[j];
                if (this.ActSchematic.gettiposimula() == 0) {
                    this.mat_A.setElement(2 * this.numbran, i, this.mat_A.getElement(2 * this.numbran, i) - 2.0 * res * reac * reac / (res * res + reac * reac) * this.DCflow[j] * this.GGDF.getElement(j, this.VarNode[i]));
                    continue;
                }
                this.mat_A.setElement(2 * this.numbran, i, this.mat_A.getElement(2 * this.numbran, i) - 2.0 * res * reac / (res * res + reac * reac) * Math.sin(reac * this.DCflow[j]) * this.GGDF.getElement(j, this.VarNode[i]));
            }
        }
    }

    public void make_vec_RHS() {
        int i = 0;
        boolean j = false;
        int count = 0;
        int ix = 0;
        double Pges = 0.0;
        for (i = 0; i < this.numres; ++i) {
            this.vec_RHS[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
            ndb_branch Tempbran = (ndb_branch)TempComponent;
            this.vec_RHS[count] = this.DCflow[count] - Tempbran.getsmax() / this.sref;
            this.vec_RHS[this.numbran + count] = -this.DCflow[count] - Tempbran.getsmax() / this.sref;
            ++count;
        }
        for (i = 0; i < this.numnod; ++i) {
            Pges += this.node_pl[i];
        }
        this.vec_RHS[2 * this.numbran] = -this.total_loss() - Pges;
        for (i = 0; i < this.numvar; ++i) {
            int n = 2 * this.numbran;
            this.vec_RHS[n] = this.vec_RHS[n] + this.vec_xtempabs[i];
        }
    }

    public double total_loss() {
        int i = 0;
        boolean j = false;
        boolean count = false;
        boolean ix = false;
        double lloss = 0.0;
        double res = 0.0;
        double reac = 0.0;
        for (i = 0; i < this.numbran; ++i) {
            res = this.BranchR[i];
            reac = this.BranchX[i];
            if (this.ActSchematic.gettiposimula() == 0) {
                lloss += res * reac * reac / (res * res + reac * reac) * this.DCflow[i] * this.DCflow[i];
                continue;
            }
            lloss += 2.0 * res / (res * res + reac * reac) * (1.0 - Math.cos(reac * this.DCflow[i]));
        }
        return lloss;
    }

    public boolean getoveriter() {
        return this.overiter;
    }

    public void make_vec_clave() {
        for (int i = 0; i < 2 * this.numbran; ++i) {
            this.vec_clave[i] = 2;
        }
        this.vec_clave[2 * this.numbran] = 3;
    }

    public void operation_cost() {
        comp TempComponent;
        boolean i = false;
        int ix = 0;
        int count = 0;
        this.totcost = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.totcost += TempInj.getalpha() + this.vec_xtempabs[count] * this.sref * (TempInj.getbeta() + this.vec_xtempabs[count] * this.sref * TempInj.getgamma());
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.totcost += this.vec_xtempabs[count] * this.sref * (TempLoad.getbeta() + this.vec_xtempabs[count] * this.sref * TempLoad.getgamma());
            ++count;
        }
    }
}

