/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.CalendarTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.LaunchProgressFrame;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.mdb_iso;
import de.core.ndb_comp;
import de.core.ndb_inj;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.Statement;

public class SFT
extends AnalysisTool {
    LaunchProgressFrame loadLaunchFrame = null;
    FileOutputStream os;
    FileOutputStream os1;
    FileOutputStream os2;
    String FileName = "./results/SFT.dat";
    String FileName1 = WORK_FOLDER + File.separator + "time.dat";
    String FileName2 = WORK_FOLDER + File.separator + "maxlin.dat";
    String FileName3 = WORK_FOLDER + File.separator + "maxtran.dat";
    String FileName4 = "./copyUDL.bat";
    PrintStream myPrintStream;
    PrintStream myPrintStream2;
    PrintStream myPrintStream3;
    comp TempComponent;
    Load TempLoad = null;
    Line TempLine = null;
    Trafo TempTrafo = null;
    ndb_inj TempInj = null;
    mdb_iso TempIso = null;
    String query;
    Statement stmt;
    Statement stmt1;
    ResultSet rs;
    boolean more;
    CalendarTool caltool;

    public SFT(Schematic sch, DeepEditFrame DF, int Monat, int Tag2, String TN, String LLoad, String GGenerator) {
        super(sch, DF);
        SimpleDialog ExceptionDialog;
        int fx;
        boolean foundl = false;
        boolean foundg = false;
        try {
            AnalysisTool.CreateDirectory(WORK_FOLDER);
            this.os1 = new FileOutputStream(this.FileName2);
            this.myPrintStream2 = new PrintStream(this.os1);
            this.os2 = new FileOutputStream(this.FileName3);
            this.myPrintStream3 = new PrintStream(this.os2);
        }
        catch (Exception e) {
            System.out.println("Error in File time.dat!" + e);
        }
        this.myPrintStream2.println("Line Capacity [MW]");
        this.myPrintStream3.println("Transformer Capacity [MW]");
        for (int ix = 0; ix < this.ActSchematic.getcomponents().size(); ++ix) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(ix);
            if (this.TempComponent instanceof ndb_inj && this.TempComponent.getName().equals(GGenerator)) {
                this.TempInj = (ndb_inj)this.TempComponent;
                foundg = true;
            }
            if (this.TempComponent instanceof Load && this.TempComponent.getName().equals(LLoad)) {
                this.TempLoad = (Load)this.TempComponent;
                foundl = true;
            }
            if (this.TempComponent instanceof Line) {
                this.TempLine = (Line)this.TempComponent;
                this.myPrintStream2.println(this.TempLine.getsmax() * this.TempLine.getsc());
            }
            if (!(this.TempComponent instanceof Trafo)) continue;
            this.TempTrafo = (Trafo)this.TempComponent;
            this.myPrintStream3.println(this.TempTrafo.getsmax() * this.TempTrafo.getsc());
        }
        try {
            if (this.os1 != null) {
                this.os1.close();
            }
            if (this.os2 != null) {
                this.os2.close();
            }
        }
        catch (Exception e) {
            System.out.println("<<<<<<<< Error in os.close() >>>>>>>>>" + e);
            System.out.println("Error in os.close() " + e);
        }
        if (!foundl || !foundg) {
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog2 = new SimpleDialog(DeepEdit.frame, "Load or Generator not found", GGenerator + " or " + LLoad, DlgButtons, 1, 0, 0, 1);
            return;
        }
        for (fx = 0; fx < this.ActSchematic.Components.size(); ++fx) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx);
            if (!(this.TempComponent instanceof mdb_iso)) continue;
            this.TempIso = (mdb_iso)this.TempComponent;
            this.TempIso.clearVector();
        }
        for (fx = 0; fx < this.ActSchematic.Components.size(); ++fx) {
            this.TempComponent = (comp)this.ActSchematic.getcomponents().elementAt(fx);
            if (!(this.TempComponent instanceof ndb_comp)) continue;
            if (this.TempIso != null) {
                this.TempIso.setNetworkElement(this.TempComponent);
                continue;
            }
            this.myPrintStream.println("******** There is no ISO in the Schematic!");
            System.out.println("There is no ISO in the Schematic !!!");
        }
        this.caltool = new CalendarTool("ECT");
        this.caltool.setcurdate(this.ActSchematic.actperiod, Monat + 1, Tag2);
        this.ActSchematic.setactdaytype(this.caltool.getDayType());
        this.ActSchematic.setactday(this.caltool.getMonthName() + "," + Tag2);
        try {
            this.os = new FileOutputStream(this.FileName);
            this.myPrintStream = new PrintStream(this.os);
        }
        catch (Exception e) {
            System.out.println("Error in PrintStream initialization!" + e);
        }
        this.loadLaunchFrame = new LaunchProgressFrame("Schedule Feasibility Tool (SFT)", 100L);
        this.loadLaunchFrame.show();
        if (this.loadLaunchFrame != null) {
            this.loadLaunchFrame.updateProgress();
        }
        System.out.println("---------- In SFT ------------");
        this.myPrintStream.println("==============================================================");
        this.myPrintStream.println("*                                                            *");
        this.myPrintStream.println("*       Documentation of the simulation-tool for the         *");
        this.myPrintStream.println("*                Schedule Feasibility Tool (SFT)             *");
        this.myPrintStream.println("*                                                            *");
        this.myPrintStream.println("==============================================================");
        this.myPrintStream.println("");
        this.loadLaunchFrame.WindowLabel.setText("Loading System Information: ");
        if (this.loadLaunchFrame != null) {
            this.loadLaunchFrame.updateProgress();
        }
        try {
            this.myPrintStream.println("++++++++     getdemand   -->   TLC-Database");
            this.loadLaunchFrame.WindowLabel.setText("Loading Scenario: ");
            if (this.loadLaunchFrame != null) {
                this.loadLaunchFrame.updateProgress();
            }
            this.stmt = DeepEditFrame.conFP.createStatement();
            for (int i = 18; i < 19; ++i) {
                for (int j = 2; j < 3; ++j) {
                    this.assigncase(i, j, TN, Tag2 + this.caltool.getMonthNameG(), Tag2, Monat);
                    DF.updatecomponent();
                    if (this.TempIso != null) {
                        if (this.TempIso.checkfeasible(this, i, j)) {
                            System.out.println("Result not feasible for hour: " + i);
                            this.myPrintStream.println("******** Result not feasible for hour: " + i);
                        } else {
                            try {
                                this.os1 = new FileOutputStream(this.FileName4);
                                this.myPrintStream2 = new PrintStream(this.os1);
                            }
                            catch (Exception e) {
                                System.out.println("Error in File time.dat!" + e);
                            }
                            this.myPrintStream2.println("copy .\\results\\facA.htm c:\\jsdk2.1\\docs\\DAWlecke\\zustandUDL\\" + Tag2 + "-" + (Monat + 1) + "\\facA" + i + "-" + j * 15 + ".htm");
                            this.myPrintStream2.println("copy .\\results\\facGGDF.htm c:\\jsdk2.1\\docs\\DAWlecke\\zustandUDL\\" + Tag2 + "-" + (Monat + 1) + "\\facGGDF" + i + "-" + j * 15 + ".htm");
                            this.myPrintStream2.println("copy .\\results\\facGLDF.htm c:\\jsdk2.1\\docs\\DAWlecke\\zustandUDL\\" + Tag2 + "-" + (Monat + 1) + "\\facGLDF" + i + "-" + j * 15 + ".htm");
                            try {
                                if (this.os1 != null) {
                                    this.os1.close();
                                }
                            }
                            catch (Exception e) {
                                System.out.println("<<<<<<<< Error in os1.close() >>>>>>>>>" + e);
                                System.out.println("Error in os1.close() " + e);
                            }
                            SFT.Dorun(DeepEdit.PathDOS + "copyUDL.bat", DeepEdit.PathUNIX + "copyUDL.bat");
                        }
                    } else {
                        System.out.println("******* There is no ISO in the Schematic !!!");
                    }
                    this.loadLaunchFrame.WindowLabel.setText("Simulate Hour " + i + " Minute " + j * 15);
                    if (this.loadLaunchFrame == null) continue;
                    this.loadLaunchFrame.updateProgress();
                }
            }
            this.stmt.close();
        }
        catch (Exception e) {
            this.message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SFT set demand and dispatch", this.message, DlgButtons, 1, 0, 0, 1);
        }
        this.loadLaunchFrame.WindowLabel.setText("End Simulation");
        if (this.loadLaunchFrame != null) {
            this.loadLaunchFrame.updateProgress();
        }
        this.loadLaunchFrame.dispose();
        this.loadLaunchFrame = null;
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("<<<<<<<< Error in os.close() >>>>>>>>>" + e);
            System.out.println("Error in os.close() " + e);
        }
        try {
            if (this.FileName != null) {
                this.DoListResults(this.FileName);
            }
        }
        catch (Exception e) {
            this.message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Error in DoListResults", this.message, DlgButtons, 1, 0, 0, 1);
        }
        try {
            DeepEditFrame.conTGD.commit();
            DeepEditFrame.conTGD.close();
            DeepEditFrame.conTLC.commit();
            DeepEditFrame.conTLC.close();
            DeepEditFrame.conFP.commit();
            DeepEditFrame.conFP.close();
        }
        catch (Exception e) {
            System.out.println("<<<<<<<< Error closing SFT-DAtabases  >>>>>>>>>" + e);
        }
    }

    public void assigncase(int hour, int minute, String TN, String Qday, int Tag2, int Monat) throws Exception {
        int hour2 = hour + 1;
        String shour = null;
        Object shour2 = null;
        Object shour3 = null;
        String smin = null;
        double auxf = 0.0;
        if (minute == 0) {
            smin = "00";
        }
        if (minute == 1) {
            smin = "15";
        }
        if (minute == 2) {
            smin = "30";
        }
        if (minute == 3) {
            smin = "45";
        }
        shour = hour < 10 ? "0" + hour + ":" : hour + ":";
        try {
            this.os1 = new FileOutputStream(this.FileName1);
            this.myPrintStream2 = new PrintStream(this.os1);
        }
        catch (Exception e) {
            System.out.println("Error in File time.dat!" + e);
        }
        this.myPrintStream2.println(Tag2 + "." + (Monat + 1) + "." + this.ActSchematic.actperiod);
        this.myPrintStream2.println(shour + smin);
        try {
            if (this.os1 != null) {
                this.os1.close();
            }
        }
        catch (Exception e) {
            System.out.println("<<<<<<<< Error in os1.close() >>>>>>>>>" + e);
            System.out.println("Error in os1.close() " + e);
        }
        this.ActSchematic.setacthour(shour + smin);
        this.ActSchematic.LoadTLC(this.caltool.getDayType(), shour + smin, "ALL LOADS", "ALL CONTROL AREAS");
        this.ActSchematic.LoadTGD(this.caltool.getDayType(), shour + smin, "ALL GENERATORS", "ALL CONTROL AREAS");
        this.query = "SELECT [" + shour + smin + "] FROM [" + Qday + "] WHERE [Trans-NR] = " + TN;
        this.rs = this.stmt.executeQuery(this.query);
        this.more = this.rs.next();
        if (!this.more) {
            System.out.println("No Transaction in hour: " + shour + smin + " in FP for " + TN);
        }
        System.out.println("Caution: Load only valid if initial year = current year !!!!");
        auxf = Double.valueOf(this.rs.getString(shour + smin));
        auxf /= 1000.0;
        if (this.TempLoad.getpini() != 0.0) {
            this.TempLoad.setqini(this.TempLoad.getqini() / this.TempLoad.getpini() * auxf);
        } else {
            System.out.println("Caution!!: for Load " + this.TempLoad.getName() + "cos(phi)=0");
        }
        this.TempLoad.setpini(auxf);
        this.TempLoad.updateload(Schematic.sref, this.ActSchematic.actperiod, this.ActSchematic.actmonth, this.ActSchematic.loadfac1, this.ActSchematic.loadfac2);
        this.TempInj.setp0(auxf);
        this.rs.close();
    }
}

