/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.SCED;
import de.core.SQPGL;
import de.core.Schematic;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;

public class SCEDServer {
    public double dp;
    public String sp;
    public String sp2;
    public String sp3;
    public int ip;
    public WebServer server;
    public Schematic mySchematic;
    public SQPGL mySQPGL;
    public SCED mySCED;
    public Hashtable myHashtable;
    public Hashtable Opts;
    public int Ncall = 0;
    public int Trip;
    public int Reqprimaryup;
    public int Reqprimarydn;
    public String[] GCod;
    public String[] LCod;
    public String[] GenCon;
    public String[] LoadCon;
    public String[] GenName;
    public double[] Rupp;
    public double[] Rdnp;
    public double[] Rups;
    public double[] Rdns;
    public double[] CMgs;
    public double[] Gen;
    public double[] TotCost;
    public double[] State;
    public double[] Po;
    public double[] Pb;
    public double[] Paux;
    public double[] UPb;
    public double[] DPb;
    public double[] Uepf;
    public double[] Depf;
    public double[] Pmin;
    public double[] Pmax;
    public double[] GradD;
    public double[] GradU;
    public double[] Alpha;
    public double[] Beta;
    public double[] Gamma;
    public double[] DistLoad;
    public double[] GenSpot;
    public double[] LoadSpot;
    public double[] UnsLoad;
    public double[] distLFactors;
    public double[][] distFactors;
    public double[] Generation;
    public double[] Generators;
    public double TotUnsLoad;
    public double TotLoss;
    public double TotLossPer;
    public double SCEDEstLoad;
    public double SchWritLoad;
    public double LoadError;
    public double LoadAfterBp;
    public double LoadAfterUepf;
    public double LoadAfterDepf;
    public double UsedLossFac = 0.04;
    public double NewLossFac = 0.04;
    public boolean fstDisp;
    public long T1;
    public long T2;
    public double Td;
    public double TdD;
    public double TdU;
    public double totdem;

    public SCEDServer(Schematic mmySchematic) {
        this.mySchematic = mmySchematic;
    }

    public SCEDServer(int puerto, Schematic mmySchematic) {
        try {
            this.server = new WebServer(puerto);
            this.server.addHandler("myHandler", (Object)new SCEDServer(mmySchematic));
            System.out.println("SCEDServer: Listening ...");
        }
        catch (IOException exception) {
            if (!exception.toString().equals("java.io.IOException: Address already in use: JVM_Bind")) {
                System.err.println("JavaClient: " + exception.toString());
            } else {
                System.out.println("SCEDServer: Listening ...");
            }
        }
        catch (Exception exception) {
            System.err.println("SCEDServer: " + exception.toString());
        }
    }

    public Hashtable ecDispatch(Vector GGCod, Hashtable OOpts, Vector SState, Vector PPo, Vector PPmin, Vector PPmax, Vector GGradD, Vector GGradU, Vector AAlpha, Vector BBeta, Vector GGamma) {
        int i;
        System.out.println("SCEDServer : Client call received...");
        Hashtable<String, Serializable> resultado = new Hashtable<String, Serializable>();
        this.Opts = OOpts;
        this.GCod = SCEDServer.toStringArray(GGCod);
        this.State = SCEDServer.todoubleArray(SState);
        this.Po = SCEDServer.todoubleArray(PPo);
        this.Pmin = SCEDServer.todoubleArray(PPmin);
        this.Pmax = SCEDServer.todoubleArray(PPmax);
        this.GradD = SCEDServer.todoubleArray(GGradD);
        this.GradU = SCEDServer.todoubleArray(GGradU);
        this.Alpha = SCEDServer.todoubleArray(AAlpha);
        this.Beta = SCEDServer.todoubleArray(BBeta);
        this.Gamma = SCEDServer.todoubleArray(GGamma);
        System.out.println("SCEDServer : Initializing new base power calculation:");
        this.mySQPGL = new SQPGL(this.mySchematic, 1, "SCED");
        System.out.println("SCEDServer : Setting first dispatch values... ");
        boolean a1 = this.fstDisp = ((Boolean)this.Opts.get("fstDisp")).booleanValue();
        int b1 = this.Ncall;
        if (this.fstDisp) {
            this.NewLossFac = 0.04;
            this.Ncall = 0;
            System.out.println("          : Setting generation costs ...");
            this.setGenCosts(this.GCod, this.Alpha, this.Beta, this.Gamma);
            System.out.println("          : Setting generation gradient limits ...");
            this.setGenGrad();
            this.fstDisp = false;
        }
        ++this.Ncall;
        boolean a2 = this.fstDisp;
        int b2 = this.Ncall;
        System.out.println("SCEDServer : Setting current generation...");
        this.setGen(this.GCod, this.Po);
        System.out.println("SCEDServer : Estimating total load...");
        this.SCEDEstLoad = (1.0 - this.NewLossFac) * SCEDServer.sum(this.Po);
        System.out.println("SCEDServer : Setting load...");
        System.out.println("            Llamando setDistLoad..");
        this.setDistTotLoad(this.SCEDEstLoad, (Integer)this.Opts.get("hour"));
        this.SchWritLoad = this.getTotLoad();
        this.LoadError = Math.abs((this.SCEDEstLoad - this.SchWritLoad) / this.SCEDEstLoad * 100.0);
        System.out.println("SCEDServer : Setting parameters...");
        int solver = (Integer)this.Opts.get("solver");
        int maxIter = (Integer)this.Opts.get("maxIter");
        int maxRHSTol = (Integer)this.Opts.get("maxRHSTol");
        int maxCostTol = (Integer)this.Opts.get("maxCostTol");
        boolean linRestr = (Boolean)this.Opts.get("linRestr");
        boolean lossMod = (Boolean)this.Opts.get("lossMod");
        boolean incr = (Boolean)this.Opts.get("incr");
        int minutes = (Integer)this.Opts.get("minutes");
        this.mySQPGL.setParameters(solver, maxIter, maxRHSTol, maxCostTol, linRestr, lossMod, incr, minutes);
        System.out.println("SCEDServer : Calculating base power...");
        this.T1 = System.currentTimeMillis();
        this.mySQPGL.Calculate(true, 1);
        this.getCon();
        this.T2 = System.currentTimeMillis();
        this.Td = SCEDServer.todouble(this.T2 - this.T1) / 1000.0;
        this.Pb = this.getGen(this.GCod);
        this.TotLoss = this.getTotLoss();
        this.UsedLossFac = this.NewLossFac;
        this.NewLossFac = this.TotLoss / SCEDServer.sum(this.Pb);
        this.TotUnsLoad = this.getTotUnsLoad();
        this.LoadAfterBp = this.getTotLoad();
        this.UnsLoad = this.getUnsLoad();
        System.out.println("SCEDServer : Base power calculation OK...");
        System.out.println("SCEDServer : Getting generation spot prices...");
        this.getGenSpot();
        System.out.println("SCEDServer : Getting load spot prices...");
        System.out.println("SCEDServer : Calculating Upward EPFs...");
        this.Uepf = new double[this.Pb.length];
        this.mySQPGL = new SQPGL(this.mySchematic, 1, "SCED");
        this.setGen(this.GCod, this.Pb);
        this.setDistTotLoad(this.SCEDEstLoad * 1.01, (Integer)this.Opts.get("hour"));
        incr = true;
        this.mySQPGL.setParameters(solver, maxIter, maxRHSTol, maxCostTol, linRestr, lossMod, incr, minutes);
        this.T1 = System.currentTimeMillis();
        this.mySQPGL.Calculate(true, 1);
        this.T2 = System.currentTimeMillis();
        this.TdU = SCEDServer.todouble(this.T2 - this.T1) / 1000.0;
        this.UPb = this.getGen(this.GCod);
        if (SCEDServer.sum(this.UPb) - SCEDServer.sum(this.Pb) == 0.0) {
            for (i = 0; i < this.Pb.length; ++i) {
                this.Uepf[i] = 0.0;
            }
        } else {
            for (i = 0; i < this.Pb.length; ++i) {
                this.Uepf[i] = (this.UPb[i] - this.Pb[i]) / (SCEDServer.sum(this.UPb) - SCEDServer.sum(this.Pb));
            }
        }
        this.LoadAfterUepf = this.getTotLoad();
        System.out.println("SCEDServer : Calculating Downward EPFs...");
        this.Depf = new double[this.Pb.length];
        this.mySQPGL = new SQPGL(this.mySchematic, 1, "SCED");
        this.setGen(this.GCod, this.Pb);
        this.setDistTotLoad(this.SCEDEstLoad * 0.99, (Integer)this.Opts.get("hour"));
        incr = true;
        this.mySQPGL.setParameters(solver, maxIter, maxRHSTol, maxCostTol, linRestr, lossMod, incr, minutes);
        this.T1 = System.currentTimeMillis();
        this.mySQPGL.Calculate(true, 1);
        this.T2 = System.currentTimeMillis();
        this.TdD = SCEDServer.todouble(this.T2 - this.T1) / 1000.0;
        this.DPb = this.getGen(this.GCod);
        if (SCEDServer.sum(this.DPb) - SCEDServer.sum(this.Pb) == 0.0) {
            for (i = 0; i < this.Pb.length; ++i) {
                this.Depf[i] = 0.0;
            }
        } else {
            for (i = 0; i < this.Po.length; ++i) {
                this.Depf[i] = (this.DPb[i] - this.Pb[i]) / (SCEDServer.sum(this.DPb) - SCEDServer.sum(this.Pb));
            }
        }
        this.LoadAfterDepf = this.getTotLoad();
        this.setDistTotLoad(this.SCEDEstLoad, (Integer)this.Opts.get("hour"));
        int dec = 3;
        System.out.println("SCEDServer : Dispatch calculation ended");
        System.out.println("SCEDServer : Answering to client...");
        System.out.println("SCEDServer : Call #                : " + this.Ncall);
        System.out.println("SCEDServer : Total cost            : $ " + SCEDServer.truncate(this.mySQPGL.totcost, dec));
        System.out.println("SCEDServer : SCED estimated load    : " + SCEDServer.truncate(this.SCEDEstLoad, dec));
        System.out.println("SCEDServer : Sch written load      : " + SCEDServer.truncate(this.SchWritLoad, dec));
        System.out.println("SCEDServer : Error [%]             : " + SCEDServer.truncate(this.LoadError, dec));
        System.out.println("SCEDServer : Losses                : " + SCEDServer.truncate(this.TotLoss, dec));
        System.out.println("SCEDServer : Losses [%]            : " + SCEDServer.truncate(this.NewLossFac * 100.0, dec));
        System.out.println("SCEDServer : Estimated losses [%]  : " + SCEDServer.truncate(this.UsedLossFac * 100.0, dec));
        System.out.println("SCEDServer : Downward EPFs         : " + SCEDServer.toString(SCEDServer.truncate(this.Depf, dec)));
        System.out.println("SCEDServer : Upward EPFs           : " + SCEDServer.toString(SCEDServer.truncate(this.Uepf, dec)));
        System.out.println("SCEDServer : Disp. calc. time (D)  : " + SCEDServer.truncate(this.TdD, 3) + " [s]");
        System.out.println("SCEDServer : Disp. calc. time      : " + SCEDServer.truncate(this.Td, 3) + " [s]");
        System.out.println("SCEDServer : Disp. calc. time (U)  : " + SCEDServer.truncate(this.TdU, 3) + " [s]");
        System.out.println("Extras:                 ");
        System.out.println("Load after base power : " + SCEDServer.truncate(this.LoadAfterBp, dec));
        System.out.println("Load after Uepf       : " + SCEDServer.truncate(this.LoadAfterUepf, dec));
        System.out.println("Load after Depf       : " + SCEDServer.truncate(this.LoadAfterDepf, dec));
        System.out.println(this.dp);
        resultado.put("Ncall", Integer.valueOf(this.Ncall));
        resultado.put("TotalCost", new Double(this.mySQPGL.totcost));
        resultado.put("SCEDEstLoad", new Double(this.SCEDEstLoad));
        resultado.put("SchWritLoad", Double.valueOf(this.SchWritLoad));
        resultado.put("LoadError", new Double(Math.abs((this.SCEDEstLoad - this.SchWritLoad) / this.SCEDEstLoad * 100.0)));
        resultado.put("GCod", SCEDServer.toVector(this.GCod));
        resultado.put("Po", SCEDServer.toVector(this.Po));
        resultado.put("Pmin", SCEDServer.toVector(this.Pmin));
        resultado.put("DPb", SCEDServer.toVector(this.DPb));
        resultado.put("Pb", SCEDServer.toVector(this.Pb));
        resultado.put("UPb", SCEDServer.toVector(this.UPb));
        resultado.put("Pmax", SCEDServer.toVector(this.Pmax));
        resultado.put("TotUnsLoad", Double.valueOf(this.TotUnsLoad));
        resultado.put("TotLoss", Double.valueOf(this.TotLoss));
        resultado.put("UsedLossFac", Double.valueOf(this.UsedLossFac));
        resultado.put("NewLossFac", Double.valueOf(this.NewLossFac));
        resultado.put("Depf", SCEDServer.toVector(this.Depf));
        resultado.put("Uepf", SCEDServer.toVector(this.Uepf));
        resultado.put("TdD", Double.valueOf(this.TdD));
        resultado.put("Td", Double.valueOf(this.Td));
        resultado.put("TdU", Double.valueOf(this.TdU));
        resultado.put("LoadAfterBp", Double.valueOf(this.LoadAfterBp));
        resultado.put("LoadAfterUepf", Double.valueOf(this.LoadAfterUepf));
        resultado.put("LoadAfterDepf", Double.valueOf(this.LoadAfterDepf));
        resultado.put("LCod", SCEDServer.toVector(this.LCod));
        resultado.put("DistLoad", SCEDServer.toVector(this.DistLoad));
        resultado.put("GenCon", SCEDServer.toVector(this.GenCon));
        resultado.put("GenSpot", SCEDServer.toVector(this.GenSpot));
        resultado.put("LoadCon", SCEDServer.toVector(this.LoadCon));
        resultado.put("LoadSpot", SCEDServer.toVector(this.LoadSpot));
        resultado.put("UnsLoad", SCEDServer.toVector(this.UnsLoad));
        System.out.println(resultado);
        System.out.println("Hola");
        System.out.println();
        return resultado;
    }

    public String setGrowthRate(double ggr) {
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)this.mySchematic.Components.elementAt(ix);
            TempLoad.setgrate(ggr);
        }
        return "OK";
    }

    public String setDistTotLoadFactors(Vector LLCod, Vector ddistFactors) {
        System.out.println(" Seteando LCod");
        this.LCod = SCEDServer.toStringArray(LLCod);
        System.out.println(" Llamando todoubleM");
        this.distFactors = SCEDServer.todoubleM(ddistFactors);
        System.out.println(" Inicializando DistLoad" + this.LCod.length);
        this.DistLoad = new double[this.LCod.length];
        System.out.println("OK");
        return "OK";
    }

    public String setTrip(int TTrip) {
        String TripCod = this.GCod[TTrip];
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || !(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName()).equals(TripCod)) continue;
            TempGenerator.setactive(false);
        }
        return "OK";
    }

    public Vector getLCod(String s) {
        return SCEDServer.toVector(this.LCod);
    }

    public double getTotLoss() {
        return SCEDServer.sum(this.getGen(this.GCod)) - this.getTotLoad() + this.getTotUnsLoad();
    }

    public double getTotUnsLoad() {
        double unserved = 0.0;
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)this.mySchematic.Components.elementAt(ix);
            unserved += TempLoad.getunser_p();
        }
        return unserved;
    }

    public double getTotLoad() {
        double demanda = 0.0;
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)this.mySchematic.Components.elementAt(ix);
            demanda += TempLoad.getp();
        }
        return demanda;
    }

    public void setTotLoad(double targetLoad) {
        double writtenLoad = this.getTotLoad();
        while (Math.abs((targetLoad - writtenLoad) / targetLoad * 100.0) > 0.005 && targetLoad != writtenLoad) {
            if (targetLoad > writtenLoad) {
                this.mySchematic.LoadScaling(100.002f, "ALL LOADS", "ALL LOADS");
            } else {
                this.mySchematic.LoadScaling(99.998f, "ALL LOADS", "ALL LOADS");
            }
            writtenLoad = this.getTotLoad();
        }
    }

    public void setDistTotLoad(double targetLoad, int hour) {
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Load TempLoad;
            String myName;
            int k;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load) || (k = SCEDServer.indexOf(myName = (TempLoad = (Load)this.mySchematic.Components.elementAt(ix)).getName(), this.LCod)) == -1) continue;
            TempLoad.setp0((float)(this.distFactors[hour][k] * targetLoad));
            TempLoad.setp((float)(this.distFactors[hour][k] * targetLoad));
            this.DistLoad[k] = this.distFactors[hour][k] * targetLoad;
        }
    }

    public void getCon() {
        this.GenCon = new String[this.GCod.length];
        this.LoadCon = new String[this.LCod.length];
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Load TempLoad;
            int j;
            String myName;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (TempComponent.getactive() && TempComponent.getvalid() && TempComponent.getinservice() && TempComponent instanceof Generator) {
                Generator TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix);
                myName = TempGenerator.getName();
                this.sp = TempGenerator.getName();
                j = SCEDServer.indexOf(myName, this.GCod);
                this.ip = SCEDServer.indexOf(myName, this.GCod);
                if (j != -1) {
                    this.GenCon[j] = TempGenerator.getcon2();
                    this.sp2 = TempGenerator.getcon2();
                }
            }
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load) || (j = SCEDServer.indexOf(myName = (TempLoad = (Load)this.mySchematic.Components.elementAt(ix)).getName(), this.LCod)) == -1) continue;
            this.LoadCon[j] = TempLoad.getcon2();
        }
    }

    public void getGenSpot() {
        this.GenSpot = new double[this.GCod.length];
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Busbar TempBusbar;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Busbar) || (j = SCEDServer.indexOf(myName = (TempBusbar = (Busbar)this.mySchematic.Components.elementAt(ix)).getName(), this.GenCon)) == -1) continue;
            this.GenSpot[j] = TempBusbar.getspot_p();
            this.sp3 = this.GenCon[j];
            if (j != 6) continue;
            this.dp = TempBusbar.getspot_p();
        }
    }

    public double[] getUnsLoad() {
        this.UnsLoad = new double[this.LCod.length];
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Load TempLoad;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load) || (j = SCEDServer.indexOf(myName = (TempLoad = (Load)this.mySchematic.Components.elementAt(ix)).getName(), this.LoadCon)) == -1) continue;
            this.UnsLoad[j] = TempLoad.getunser_p();
        }
        return this.UnsLoad;
    }

    public void setGen(String[] GGCod, double[] PP) {
        Hashtable myHashtable = SCEDServer.toHashtable(GGCod, PP);
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), GGCod)) == -1) continue;
            TempGenerator.setp((Double)myHashtable.get(myName));
            TempGenerator.setpmin(new Double(this.Pmin[j]));
            TempGenerator.setpmax(new Double(this.Pmax[j]));
        }
    }

    public void setGenGrad() {
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), this.GCod)) == -1) continue;
            TempGenerator.setgradD((float)this.GradD[j]);
            TempGenerator.setgradU((float)this.GradU[j]);
        }
    }

    public void setGenCosts(String[] GGCod, double[] a, double[] b, double[] c) {
        Hashtable myHashtableA = SCEDServer.toHashtable(GGCod, a);
        Hashtable myHashtableB = SCEDServer.toHashtable(GGCod, b);
        Hashtable myHashtableC = SCEDServer.toHashtable(GGCod, c);
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), GGCod)) == -1) continue;
            TempGenerator.setalpha((Double)myHashtableA.get(myName));
            TempGenerator.setbeta((Double)myHashtableB.get(myName));
            TempGenerator.setgamma((Double)myHashtableC.get(myName));
        }
    }

    public String reset(String useless) {
        this.UsedLossFac = 0.02;
        this.NewLossFac = 0.02;
        this.fstDisp = true;
        return "Resetting OK..";
    }

    public static double todouble(float f) {
        return new Float(f).doubleValue();
    }

    public static double[] todouble(float[] f) {
        double[] resultado = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            resultado[i] = f[i];
        }
        return resultado;
    }

    public static double[] todouble(double[] f) {
        double[] resultado = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            resultado[i] = f[i];
        }
        return resultado;
    }

    public static double todouble(long l) {
        return new Long(l).doubleValue();
    }

    public static String toString(String[] miString) {
        String s = "";
        for (int i = 0; i < miString.length; ++i) {
            s = miString[i] + ", ";
        }
        return s;
    }

    public static String[] toStringArray(Vector Vect) {
        String[] resultado = new String[Vect.size()];
        for (int i = 0; i < Vect.size(); ++i) {
            resultado[i] = (String)Vect.get(i);
        }
        return resultado;
    }

    public static double[] todoubleArray(Vector Vect) {
        double[] resultado = new double[Vect.size()];
        for (int i = 0; i < Vect.size(); ++i) {
            resultado[i] = (Double)Vect.get(i);
        }
        return resultado;
    }

    public static double todouble(Vector Vect) {
        double resultado = 0.0;
        resultado = (Double)Vect.get(0);
        return resultado;
    }

    public static String toString(double[] d) {
        String s = "";
        for (int i = 0; i < d.length - 1; ++i) {
            s = s + d[i] + ", ";
        }
        s = s + d[d.length - 1] + " ";
        return s;
    }

    public static Vector toVector(double[] doub) {
        Vector<Double> resultado = new Vector<Double>(doub.length, 1);
        for (int i = 0; i < doub.length; ++i) {
            resultado.add(new Double(doub[i]));
        }
        return resultado;
    }

    public static Vector toVector(String[] s) {
        Vector<String> resultado = new Vector<String>(s.length, 1);
        for (int i = 0; i < s.length; ++i) {
            resultado.add(s[i]);
        }
        return resultado;
    }

    public static double[][] todoubleM(Vector V) {
        System.out.println(" todoubleM ");
        int rows = (Integer)V.get(V.size() - 2);
        int columns = (Integer)V.get(V.size() - 1);
        double[][] d = new double[rows][columns];
        Vector myRow = (Vector)V.get(0);
        for (int i = 0; i < rows; ++i) {
            myRow = (Vector)V.get(i);
            for (int j = 0; j < columns; ++j) {
                d[i][j] = (Double)myRow.get(j);
            }
        }
        System.out.println(" ");
        System.out.println(" ");
        return d;
    }

    public static Hashtable toHashtable(String[] s, double[] d) {
        Hashtable<String, Double> myHashtable = new Hashtable<String, Double>();
        for (int i = 0; i < d.length; ++i) {
            myHashtable.put(s[i], new Double(d[i]));
        }
        return myHashtable;
    }

    public static Hashtable toHashtable(String[] s, int[] k) {
        Hashtable<String, Integer> myHashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < s.length; ++i) {
            myHashtable.put(s[i], new Integer(k[i]));
        }
        return myHashtable;
    }

    public static int indexOf(String s, String[] sA) {
        for (int i = 0; i < sA.length; ++i) {
            if (!s.equals(sA[i])) continue;
            return i;
        }
        return -1;
    }

    public static double sum(double[] d) {
        double suma = 0.0;
        for (int i = 0; i < d.length; ++i) {
            suma += d[i];
        }
        return suma;
    }

    public static double[] truncate(double[] d, int n) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = SCEDServer.truncate(d[i], n);
        }
        return d;
    }

    public static double truncate(double d, int n) {
        if (n == -1) {
            return d;
        }
        double dec = Math.pow(10.0, n);
        return Math.floor(d * dec + 0.5) / dec;
    }

    public void printDistFactors(int rows, int columns) {
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                System.out.println("Fila:" + i + " Columna:" + j + " " + this.distFactors[i][j]);
            }
        }
    }

    public Hashtable suma(Vector dem, Vector pot) {
        Hashtable<String, Double> resultado = new Hashtable<String, Double>();
        double[] P = new double[pot.size()];
        double suma = 0.0;
        for (int i = 0; i < pot.size(); ++i) {
            suma += ((Double)pot.get(i)).doubleValue();
        }
        System.out.println("SCEDServer: Respuesta a cliente OK...");
        System.out.println("SCEDServer: Fin despacho");
        resultado.put("suma", new Double(suma));
        return resultado;
    }

    public static void miMetodo() {
        double[] P = new double[]{2.0, 10.0, 6.0};
        System.out.println(P[1]);
        Double d1 = new Double(2.0);
        Double d2 = new Double(3.0);
        double dd1 = d1;
        double dd2 = d2;
        System.out.println(dd1 + dd2);
    }

    public String envioPrueba(String LLCod) {
        System.out.println("Dato Recibido:" + LLCod);
        System.out.println("Conexion Establecida... OK");
        String estado = "1";
        return estado;
    }

    public Hashtable SCEDDispatch(Hashtable OOpts, Vector RReserves) {
        System.out.println("SCEDServer : Client call received...");
        Hashtable<String, Vector> resultado = new Hashtable<String, Vector>();
        this.Opts = OOpts;
        System.out.println("SCEDServer : Initializing new base power calculation:");
        this.mySCED = new SCED(this.mySchematic, 4, "SCED");
        System.out.println("SCEDServer : Setting parameters...");
        int solver = (Integer)this.Opts.get("solver");
        int maxIter = (Integer)this.Opts.get("maxIter");
        int maxRHSTol = (Integer)this.Opts.get("maxRHSTol");
        int maxCostTol = (Integer)this.Opts.get("maxCostTol");
        boolean linRestr = (Boolean)this.Opts.get("linRestr");
        boolean lossMod = (Boolean)this.Opts.get("lossMod");
        boolean incr = (Boolean)this.Opts.get("incr");
        int minutes = (Integer)this.Opts.get("minutes");
        int Requp = (Integer)this.Opts.get("Reqprimaryup");
        int Reqdn = (Integer)this.Opts.get("Reqprimarydn");
        int Reqdemup = (Integer)this.Opts.get("Reqsecdemup");
        int Reqdemdn = (Integer)this.Opts.get("Reqsecdemdn");
        boolean centr = (Boolean)this.Opts.get("Centralized");
        boolean partDem = (Boolean)this.Opts.get("partDem");
        this.mySCED.setParameters(solver, maxIter, maxRHSTol, maxCostTol, linRestr, lossMod, incr, minutes, Requp, Reqdn, Reqdemup, Reqdemdn, centr, partDem);
        double[] Req = SCEDServer.todoubleArray(RReserves);
        this.mySCED.setRequirements(Req[0], Req[1], Req[2], Req[3]);
        System.out.println("SCEDServer : Calculating base power...");
        this.mySCED.Calculate(true, 1);
        System.out.println("SCEDServer : Simulacion Finalizada...");
        this.Gen = this.getGen();
        this.GenName = this.getnameGen();
        this.Rupp = this.getRequp();
        this.Rdnp = this.getReqdn();
        this.Rups = this.getReqsecup();
        this.Rdns = this.getReqsecdn();
        this.CMgs = this.getCMgs();
        this.TotCost = new double[1];
        this.TotCost[0] = this.getTotalCost();
        System.out.println("SCEDServer : Informacion de reservas adquirida...");
        resultado.put("Gen", SCEDServer.toVector(this.Gen));
        resultado.put("GenName", SCEDServer.toVector(this.GenName));
        resultado.put("Rupp", SCEDServer.toVector(this.Rupp));
        resultado.put("Rdnp", SCEDServer.toVector(this.Rdnp));
        resultado.put("Rups", SCEDServer.toVector(this.Rups));
        resultado.put("Rdns", SCEDServer.toVector(this.Rdns));
        resultado.put("CMgs", SCEDServer.toVector(this.CMgs));
        resultado.put("TotCost", SCEDServer.toVector(this.TotCost));
        System.out.println("SCEDServer : Informacion compilada. Enviando...");
        return resultado;
    }

    public String setDemand(Vector LLCod, Vector ddistFactors, Vector ttotdem) {
        System.out.println("SCED Server: Recibiendo instruccion de seteo demanda por barra...");
        this.LCod = SCEDServer.toStringArray(LLCod);
        System.out.println("SCED Server: Nombre de las barras a asignar recibido...");
        this.distLFactors = SCEDServer.todoubleArray(ddistFactors);
        System.out.println("SCED Server: Factores de distribucion recibidos...");
        double[] demanda = SCEDServer.todoubleArray(ttotdem);
        this.totdem = demanda[0];
        System.out.println("SCED Server: Demanda total proyectada recibida...");
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Load TempLoad;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load) || (j = SCEDServer.indexOf(myName = (TempLoad = (Load)this.mySchematic.Components.elementAt(ix)).getName(), this.LCod)) == -1) continue;
            TempLoad.setp0((float)(this.distLFactors[j] * demanda[0]));
        }
        System.out.println("SCED Server: Carga asignada a cada consumo correctamente...");
        return "OK";
    }

    public double[] getGen(String[] GGCod) {
        double[] Gen = new double[GGCod.length];
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), GGCod)) == -1) continue;
            Gen[j] = TempGenerator.getp();
        }
        return Gen;
    }

    public String setReq(Vector RReq) {
        double[] Req = SCEDServer.todoubleArray(RReq);
        double Requpp = Req[0];
        double Reqdnp = Req[1];
        double Requps = Req[2];
        double Reqdns = Req[3];
        System.out.println("SCEDServer: Seteando requerimientos de regulaci\u00f3n...");
        this.mySCED.setRequirements(Requpp, Reqdnp, Requps, Reqdns);
        System.out.println("SCEDServer: Ok...");
        return "OK";
    }

    public double[] getGen(Vector GGGCod) {
        String[] GGCod = SCEDServer.toStringArray(GGGCod);
        double[] Gen = new double[GGCod.length];
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), GGCod)) == -1) continue;
            Gen[j] = TempGenerator.getp();
        }
        return Gen;
    }

    public String setGeneration(Vector GGCod, Vector GGeneration) {
        System.out.println("SCED Server: Recibiendo instruccion de seteo generacion...");
        this.GCod = SCEDServer.toStringArray(GGCod);
        System.out.println("SCED Server: Nombre de los generadores a asignar recibido...");
        this.Generation = SCEDServer.todoubleArray(GGeneration);
        System.out.println("SCED Server: Potencia de generacion recibida...");
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), this.GCod)) == -1) continue;
            TempGenerator.setp((float)this.Generation[j]);
        }
        System.out.println("SCED Server: Potencia asignada a cada generador correctamente...");
        return "OK";
    }

    public String setPmax(Vector GGCod, Vector PPmax) {
        System.out.println("SCED Server: Recibiendo instruccion de seteo generacion...");
        this.GCod = SCEDServer.toStringArray(GGCod);
        System.out.println("SCED Server: Nombre de los generadores a asignar recibido...");
        this.Pmax = SCEDServer.todoubleArray(PPmax);
        System.out.println("SCED Server: Potencia maxima recibida...");
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), this.GCod)) == -1) continue;
            TempGenerator.setpmax((float)this.Pmax[j]);
        }
        System.out.println("SCED Server: Potencia maxima asignada correctamente...");
        return "OK";
    }

    public String setPmin(Vector GGCod, Vector PPmin) {
        System.out.println("SCED Server: Recibiendo instruccion de seteo generacion...");
        this.GCod = SCEDServer.toStringArray(GGCod);
        System.out.println("SCED Server: Nombre de los generadores a asignar recibido...");
        this.Pmin = SCEDServer.todoubleArray(PPmin);
        System.out.println("SCED Server: Potencia minima recibida...");
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), this.GCod)) == -1) continue;
            TempGenerator.setpmin((float)this.Pmin[j]);
        }
        System.out.println("SCED Server: Potencia maxima asignada correctamente...");
        return "OK";
    }

    public String setTmax(Vector GGCod, Vector PPmax) {
        System.out.println("SCED Server: Recibiendo instruccion de seteo transmision...");
        this.GCod = SCEDServer.toStringArray(GGCod);
        System.out.println("SCED Server: Nombre de tramos a asignar recibido...");
        this.Pmax = SCEDServer.todoubleArray(PPmax);
        System.out.println("SCED Server: Potencia maxima recibida...");
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Line TempBranch;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || (j = SCEDServer.indexOf(myName = (TempBranch = (Line)this.mySchematic.Components.elementAt(ix)).getName(), this.GCod)) == -1) continue;
            TempBranch.setsmax((float)this.Pmax[0]);
        }
        System.out.println("SCED Server: Potencia maxima a linea asignada correctamente...");
        return "OK";
    }

    public String setBeta(Vector GGCod, Vector Bbeta) {
        System.out.println("SCED Server: Recibiendo instruccion de seteo de costos variables...");
        this.GCod = SCEDServer.toStringArray(GGCod);
        System.out.println("SCED Server: Nombre de los generadores a asignar recibido...");
        this.Beta = SCEDServer.todoubleArray(Bbeta);
        System.out.println("SCED Server: Costos variables recibidos...");
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), this.GCod)) == -1) continue;
            TempGenerator.setbeta((float)this.Beta[j]);
        }
        System.out.println("SCED Server: Costos variables asignados correctamente...");
        return "OK";
    }

    public String setGenerators(Vector GGCod, Vector GGenerators) {
        System.out.println("SCED Server: Recibiendo instruccion de seteo generacion...");
        this.GCod = SCEDServer.toStringArray(GGCod);
        System.out.println("SCED Server: Nombre de los generadores a asignar recibido...");
        this.Generators = SCEDServer.todoubleArray(GGenerators);
        System.out.println("SCED Server: Predespacho recibido...");
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Generator TempGenerator;
            String myName;
            int j;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !(TempComponent instanceof ndb_inj) || (j = SCEDServer.indexOf(myName = (TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix)).getName(), this.GCod)) == -1) continue;
            if (this.Generators[j] == 1.0) {
                TempGenerator.setinservice(true);
                continue;
            }
            TempGenerator.setinservice(false);
        }
        System.out.println("SCED Server: Unidades consideradas en el despacho asignadas correctamente...");
        return "OK";
    }

    public double[] getGen() {
        double[] Gen = new double[this.mySCED.numgen];
        int k = 0;
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            Generator TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix);
            Gen[k] = TempGenerator.getp();
            ++k;
        }
        return Gen;
    }

    public String[] getnameGen() {
        String[] Gen = new String[this.mySCED.numgen];
        int k = 0;
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            Generator TempGenerator = (Generator)this.mySchematic.Components.elementAt(ix);
            Gen[k] = TempGenerator.getName();
            ++k;
        }
        return Gen;
    }

    public double[] getRequp() {
        double[] Requp = new double[this.mySCED.numgen];
        for (int i = 0; i < this.mySCED.numgen; ++i) {
            Requp[i] = this.mySCED.Rupp[i] * this.mySCED.getSref();
        }
        return Requp;
    }

    public double[] getReqdn() {
        double[] Reqdn = new double[this.mySCED.numgen];
        for (int i = 0; i < this.mySCED.numgen; ++i) {
            Reqdn[i] = this.mySCED.Rdnp[i] * this.mySCED.getSref();
        }
        return Reqdn;
    }

    public double[] getReqsecup() {
        double[] Reqsecup = new double[this.mySCED.numgen];
        for (int i = 0; i < this.mySCED.numgen; ++i) {
            Reqsecup[i] = this.mySCED.Rups[i] * this.mySCED.getSref();
        }
        return Reqsecup;
    }

    public double[] getReqsecdn() {
        double[] Reqsecdn = new double[this.mySCED.numgen];
        for (int i = 0; i < this.mySCED.numgen; ++i) {
            Reqsecdn[i] = -(this.mySCED.Rdns[i] * this.mySCED.getSref());
        }
        return Reqsecdn;
    }

    public double[] getCMgs() {
        double[] CMMgs = new double[4];
        for (int i = 0; i < 4; ++i) {
            CMMgs[i] = Math.rint(this.mySCED.CMgs[i] * 100.0) / 100.0;
        }
        return CMMgs;
    }

    public double getBarraSpot(String nombarra) {
        double SpotBarra = 0.0;
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Busbar TempBusbar;
            String myName;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Busbar) || !(myName = (TempBusbar = (Busbar)this.mySchematic.Components.elementAt(ix)).getName()).equals(nombarra)) continue;
            SpotBarra = TempBusbar.getspot_p();
        }
        return SpotBarra;
    }

    public double getPUtotal(String nombreBarra) {
        double PUtotal = this.mySCED.totunser;
        return PUtotal;
    }

    public double getTotalCost() {
        double TotalCost = this.mySCED.totcost;
        return TotalCost;
    }

    public double getFlujo(String nombarra) {
        double SpotBarra = 0.0;
        for (int ix = 0; ix < this.mySchematic.size(); ++ix) {
            Line TempBusbar;
            String myName;
            comp TempComponent = (comp)this.mySchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Line) || !(myName = (TempBusbar = (Line)this.mySchematic.Components.elementAt(ix)).getName()).equals(nombarra)) continue;
            SpotBarra = TempBusbar.getp12();
        }
        return SpotBarra;
    }
}

