/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.Load;
import de.core.SCED;
import de.core.SCEDContingencyEditor;
import de.core.SCEDDatos;
import de.core.SwingWorker;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import java.awt.BorderLayout;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

class SCEDFrame
extends JDialog
implements KeyListener,
ActionListener {
    private SCED Myequiv;
    private SCED MyequivAux;
    SCEDContingencyEditor MySCEDContingencyEditor;
    private String ctrla;
    private JComboBox MyChoiceCtrla;
    private JComboBox chSolver;
    private JComboBox chMaxIter;
    private JComboBox chMaxRHSTol;
    private JComboBox chMaxCostTol;
    private JComboBox chTimeFrame;
    private JComboBox chRequp;
    private JComboBox chReqdn;
    private JComboBox chReqdemup;
    private JComboBox chReqdemdn;
    private JRadioButton chbCuadLoss;
    private JRadioButton chbCoseLoss;
    private CheckboxGroup chbgLossMod;
    private JCheckBox lin;
    private JCheckBox centralized;
    private JCheckBox incremental;
    private JCheckBox partDem;
    private JButton buttonCalc;
    private JButton buttonCancel;
    private JButton buttonDisplay;
    private JButton buttonEditor;
    private SwingWorker worker;
    private Vector dialogJComps2disable;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;

    SCEDFrame(SCED ms) {
        DeepEdit cfr_ignored_0 = ms.applet;
        super(DeepEdit.frame, "SCED Calculation Options", false);
        this.MySCEDContingencyEditor = null;
        this.MyChoiceCtrla = null;
        this.chSolver = null;
        this.chMaxIter = null;
        this.chMaxRHSTol = null;
        this.chMaxCostTol = null;
        this.chTimeFrame = null;
        this.chRequp = null;
        this.chReqdn = null;
        this.chReqdemup = null;
        this.chReqdemdn = null;
        this.chbCuadLoss = null;
        this.chbCoseLoss = null;
        this.chbgLossMod = null;
        this.worker = null;
        this.dialogJComps2disable = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.Myequiv = ms;
        this.MyequivAux = ms;
        this.TextDialogFont = DeepEdit.TextFont;
        JPanel Union = new JPanel();
        JPanel Analysis = new JPanel();
        JPanel opModelPanel = new JPanel();
        BorderLayout bl = new BorderLayout();
        Union.setLayout(bl);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        this.dialogJComps2disable = new Vector(20);
        c1.gridheight = 1;
        c1.gridwidth = 1;
        c1.anchor = 17;
        c2.gridheight = 1;
        c2.gridwidth = 0;
        c2.fill = 2;
        c2.insets = new Insets(1, 1, 1, 1);
        opModelPanel.setLayout(gridbag);
        this.MyChoiceCtrla = new JComboBox();
        this.dialogJComps2disable.add(this.MyChoiceCtrla);
        this.MyChoiceCtrla.setFont(this.TextDialogFont);
        this.ctrla = "ALL CONTROL AREAS";
        Choice auxChoice = new Choice();
        this.MyChoiceCtrla.addItem(this.ctrla);
        this.Myequiv.ActSchematic.LoadCtrla(auxChoice);
        for (int i = 0; i < auxChoice.getItemCount(); ++i) {
            this.MyChoiceCtrla.addItem(auxChoice.getItem(i));
        }
        JLabel auxLab = new JLabel(" Control Area ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opModelPanel.add(auxLab);
        opModelPanel.add((Component)this.MyChoiceCtrla, c2);
        auxLab = new JLabel(" Losses Model ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opModelPanel.add(auxLab);
        ButtonGroup chbgLossMod = new ButtonGroup();
        this.chbCuadLoss = new JRadioButton("R\u2219I\u00b2", true);
        this.dialogJComps2disable.add(this.chbCuadLoss);
        this.chbCuadLoss.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbCuadLoss, c1);
        chbgLossMod.add(this.chbCuadLoss);
        this.chbCoseLoss = new JRadioButton("2G\u2219Cos(\u2206\u03b4)", false);
        this.dialogJComps2disable.add(this.chbCoseLoss);
        this.chbCoseLoss.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbCoseLoss, c2);
        chbgLossMod.add(this.chbCoseLoss);
        auxLab = new JLabel(" Aditional Constraints    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.lin = new JCheckBox(" Line Limits", true);
        this.dialogJComps2disable.add(this.lin);
        this.lin.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.lin, c2);
        opModelPanel.add(this.lin);
        JLabel auxLab1 = new JLabel("      ", 2);
        this.dialogJComps2disable.add(auxLab1);
        auxLab1.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab1, c1);
        this.incremental = new JCheckBox(" Incremental Opt.", this.Myequiv.incremental);
        this.dialogJComps2disable.add(this.incremental);
        this.incremental.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.incremental, c2);
        opModelPanel.add(this.incremental);
        auxLab = new JLabel(" Cost Options    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.centralized = new JCheckBox(" Centralized Model", false);
        this.dialogJComps2disable.add(this.centralized);
        this.centralized.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.centralized, c2);
        opModelPanel.add(this.centralized);
        auxLab = new JLabel(" Dem. Options    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.partDem = new JCheckBox(" Load Participation", true);
        this.dialogJComps2disable.add(this.partDem);
        this.partDem.setFont(this.TextDialogFont);
        gridbag.setConstraints(this.partDem, c2);
        opModelPanel.add(this.partDem);
        TitledBorder inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "MODEL PARAMETERS", 2, 2, this.TextDialogFont, Color.blue);
        opModelPanel.setBorder(inB);
        gridbag = new GridBagLayout();
        Analysis.setLayout(gridbag);
        JLabel auxLab2 = new JLabel("Display Contingency Elements:   ", 2);
        this.dialogJComps2disable.add(auxLab2);
        auxLab2.setFont(this.TextDialogFont);
        Analysis.add((Component)auxLab2, c1);
        this.buttonDisplay = new JButton("Display");
        this.dialogJComps2disable.add(this.buttonDisplay);
        this.buttonDisplay.setFont(this.TextDialogFont);
        Analysis.add((Component)this.buttonDisplay, c2);
        this.buttonDisplay.addActionListener(this);
        auxLab2 = new JLabel("Contingency Editor:   ", 2);
        this.dialogJComps2disable.add(auxLab2);
        auxLab2.setFont(this.TextDialogFont);
        Analysis.add((Component)auxLab2, c1);
        this.buttonEditor = new JButton("Editor");
        this.dialogJComps2disable.add(this.buttonEditor);
        this.buttonEditor.setFont(this.TextDialogFont);
        Analysis.add((Component)this.buttonEditor, c2);
        this.buttonEditor.addActionListener(this);
        inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "CONTINGENCY EDITOR", 2, 2, this.TextDialogFont, Color.blue);
        Analysis.setBorder(inB);
        Union.add((Component)opModelPanel, "North");
        Union.add((Component)Analysis, "Center");
        this.getContentPane().add((Component)Union, "West");
        JPanel opSolverPanel = new JPanel(){
            Insets inSet = new Insets(20, 10, 15, 10);

            @Override
            public Insets getInsets() {
                return this.inSet;
            }
        };
        gridbag = new GridBagLayout();
        opSolverPanel.setLayout(gridbag);
        auxLab = new JLabel(" Subproblems Solver    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chSolver = new JComboBox();
        this.dialogJComps2disable.add(this.chSolver);
        this.chSolver.addItem(SCED.solverOptions[0] + "                ");
        this.chSolver.addItem(SCED.solverOptions[1]);
        this.chSolver.setFont(this.TextDialogFont);
        this.chSolver.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chSolver, c2);
        auxLab = new JLabel(" Maximum Iterations", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxIter = new JComboBox<String>(SCED.maxIterOptions);
        this.dialogJComps2disable.add(this.chMaxIter);
        this.chMaxIter.setFont(this.TextDialogFont);
        this.chMaxIter.setSelectedIndex(2);
        opSolverPanel.add((Component)this.chMaxIter, c2);
        auxLab = new JLabel(" RHS Tolerance [%]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxRHSTol = new JComboBox<String>(SCED.maxRHSTolOptions);
        this.dialogJComps2disable.add(this.chMaxRHSTol);
        this.chMaxRHSTol.setFont(this.TextDialogFont);
        this.chMaxRHSTol.setSelectedIndex(2);
        opSolverPanel.add((Component)this.chMaxRHSTol, c2);
        auxLab = new JLabel(" Cost Tolerance [%]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chMaxCostTol = new JComboBox<String>(SCED.maxCostTolOptions);
        this.dialogJComps2disable.add(this.chMaxCostTol);
        this.chMaxCostTol.setFont(this.TextDialogFont);
        this.chMaxCostTol.setSelectedIndex(4);
        opSolverPanel.add((Component)this.chMaxCostTol, c2);
        auxLab = new JLabel(" Time frame (Gradients) [Min]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chTimeFrame = new JComboBox<String>(SCED.TimeFrameOptions);
        this.dialogJComps2disable.add(this.chTimeFrame);
        this.chTimeFrame.setFont(this.TextDialogFont);
        this.chTimeFrame.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chTimeFrame, c2);
        auxLab = new JLabel(" Up Service Req. [MW]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chRequp = new JComboBox<String>(SCED.Reqprimaryup);
        this.dialogJComps2disable.add(this.chRequp);
        this.chRequp.setFont(this.TextDialogFont);
        this.chRequp.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chRequp, c2);
        auxLab = new JLabel(" Down Service Req. [MW]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chReqdn = new JComboBox<String>(SCED.Reqprimarydn);
        this.dialogJComps2disable.add(this.chReqdn);
        this.chReqdn.setFont(this.TextDialogFont);
        this.chReqdn.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chReqdn, c2);
        auxLab = new JLabel(" Up Demand Variation [MW]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chReqdemup = new JComboBox<String>(SCED.Reqsecdemup);
        this.dialogJComps2disable.add(this.chReqdemup);
        this.chReqdemup.setFont(this.TextDialogFont);
        this.chReqdemup.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chReqdemup, c2);
        auxLab = new JLabel(" Down Demand Variation [MW]", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        gridbag.setConstraints(auxLab, c1);
        opSolverPanel.add(auxLab);
        this.chReqdemdn = new JComboBox<String>(SCED.Reqsecdemdn);
        this.dialogJComps2disable.add(this.chReqdemdn);
        this.chReqdemdn.setFont(this.TextDialogFont);
        this.chReqdemdn.setSelectedIndex(0);
        opSolverPanel.add((Component)this.chReqdemdn, c2);
        inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "SOLVER PARAMETERS", 2, 2, this.TextDialogFont, Color.blue);
        opSolverPanel.setBorder(inB);
        this.getContentPane().add((Component)opSolverPanel, "East");
        JPanel controlP = new JPanel();
        controlP.setLayout(new FlowLayout());
        this.buttonCalc = new JButton("Calculate");
        this.dialogJComps2disable.add(this.buttonCalc);
        this.buttonCalc.setFont(this.TextDialogFont);
        controlP.add(this.buttonCalc);
        this.buttonCalc.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.setFont(this.TextDialogFont);
        controlP.add(this.buttonCancel);
        this.buttonCancel.addActionListener(this);
        this.getContentPane().add((Component)controlP, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        this.buttonCancel.addKeyListener(this);
        DeepEdit cfr_ignored_1 = ms.applet;
        this.setLocationRelativeTo(DeepEdit.frame);
        this.setLocation(200, 100);
        this.setResizable(false);
        this.pack();
        this.show();
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.Myequiv.MySCEDFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj == this.buttonEditor) {
            System.out.println("Editing contingency....");
            if (this.MySCEDContingencyEditor == null) {
                this.MySCEDContingencyEditor = new SCEDContingencyEditor(this.Myequiv);
                this.MySCEDContingencyEditor = null;
            } else {
                this.MySCEDContingencyEditor.show();
            }
        }
        if (obj == this.buttonCalc) {
            try {
                this.disableComponents();
                this.setDefaultCloseOperation(0);
                this.setVisible(false);
                this.runSolver();
                this.dispose();
                this.Myequiv.MySCEDFrame = null;
            }
            catch (Exception e) {
                this.setVisible(false);
                JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SCED Error", 0);
                this.endDialog();
            }
        }
        if (obj == this.buttonCancel) {
            try {
                if (this.worker != null) {
                    this.worker.interrupt();
                }
                this.endDialog();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SCED Error", 0);
                e.printStackTrace();
            }
            this.endDialog();
        }
        if (obj == this.buttonDisplay) {
            System.out.println("SCEDFrame: Displaying contingency elements...");
            try {
                comp TempComponent;
                Load TempLoad = null;
                Object TempGenerator = null;
                boolean counterL = false;
                boolean counterT = false;
                boolean counterB = false;
                int ix = 0;
                FileOutputStream os = new FileOutputStream("./results/SCEDFrame.dat");
                SCEDDatos datosSCED = new SCEDDatos();
                datosSCED.loaddatafromfile();
                int datofile = 0;
                int contingencia = 12;
                int numcon = 0;
                int count6 = 0;
                for (ix = 0; ix < this.Myequiv.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) && !(TempComponent instanceof ndb_inj) && !(TempComponent instanceof Load) || (datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName)) != 1) continue;
                    ++numcon;
                }
                String[][] Conting = new String[numcon][2];
                for (ix = 0; ix < this.Myequiv.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
                    if (TempComponent instanceof ndb_branch && (datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName)) == 1) {
                        Conting[count6][0] = TempComponent.ComponentName;
                        Conting[count6][1] = "Rama";
                        ++count6;
                    }
                    if (TempComponent instanceof ndb_inj && (datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName)) == 1) {
                        Conting[count6][0] = TempComponent.ComponentName;
                        Conting[count6][1] = "Generador";
                        ++count6;
                    }
                    if (!(TempComponent instanceof Load)) continue;
                    datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName);
                    TempLoad = (Load)TempComponent;
                    if (datofile != 1) continue;
                    Conting[count6][0] = TempComponent.ComponentName;
                    Conting[count6][1] = "Consumo";
                    ++count6;
                }
                System.out.println("--------------------------------------------------");
                System.out.println("       Elementos modelados con contingencia");
                System.out.println("--------------------------------------------------");
                for (ix = 0; ix < this.Myequiv.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
                    ndb_comp Tempndb = (ndb_comp)TempComponent;
                    Tempndb.setAlternatekv_Color(Color.darkGray);
                    for (int k = 0; k < numcon; ++k) {
                        if (TempComponent.getName() != Conting[k][0]) continue;
                        System.out.println("Tipo: " + Conting[k][1] + "\t" + "\t" + "Nombre:" + Conting[k][0]);
                        Tempndb.lw = 2;
                        Tempndb.setAlternatekv_Color(Color.red);
                    }
                }
                System.out.println("--------------------------------------------------");
                os.close();
                this.Myequiv.IdidntRealize();
                DeepEdit.MySchematicPanel.repaint();
                this.repaint();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SCED Error", 0);
                e.printStackTrace();
            }
        }
    }

    private void disableComponents() {
        for (int i = 0; i < this.dialogJComps2disable.size(); ++i) {
            ((JComponent)this.dialogJComps2disable.elementAt(i)).setEnabled(false);
        }
    }

    private void runSolver() {
        this.Myequiv.setParameters(this.chSolver.getSelectedIndex(), this.chMaxIter.getSelectedIndex(), this.chMaxRHSTol.getSelectedIndex(), this.chMaxCostTol.getSelectedIndex(), this.lin.isSelected(), this.chbCuadLoss.isSelected(), this.incremental.isSelected(), this.chTimeFrame.getSelectedIndex(), this.chRequp.getSelectedIndex(), this.chReqdn.getSelectedIndex(), this.chReqdemup.getSelectedIndex(), this.chReqdemdn.getSelectedIndex(), this.centralized.isSelected(), this.partDem.isSelected());
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                SCEDFrame.this.Myequiv.Calculate(true, 1);
                return new Object();
            }

            @Override
            public void finished() {
                SCEDFrame.this.endDialog();
            }
        };
        this.worker.start();
    }

    private void endDialog() {
        this.restorecolor();
        this.dispose();
        this.Myequiv.MySCEDFrame = null;
        Runtime.getRuntime().gc();
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }
}

