/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class SCEDClient {
    public double[] P;
    public double[] Pmax;
    public double[] Pmin;
    public double[] Rupp;
    public double[] Rdnp;
    public double[] Rups;
    public double[] Rdns;
    public double[] Rdn;
    public double[] CMgs;
    public double Spotbarra;
    public double PUTotal;
    public String[] Pnames;
    public int Ncall;
    public XmlRpcClient server;
    public Hashtable resultado;
    public Vector datos;
    public PrintWriter WriteRes;
    public int estado = 0;
    public int dec;
    public int dig;

    public SCEDClient(String web_url) throws IOException {
        System.out.println("Creando Objeto...");
        try {
            this.server = new XmlRpcClient(web_url);
        }
        catch (Exception exception) {
            System.err.println("AGCClient: " + exception.toString());
        }
        this.WriteRes = new PrintWriter(new BufferedWriter(new FileWriter("Client.txt")));
    }

    public void callSCED(Hashtable OOpts, double[] RReserves) {
        System.out.println("SCEDClient : Initializing Security Constrained Economic Dispatch call...");
        int Nargs = 2;
        this.resultado = new Hashtable();
        this.datos = new Vector(Nargs);
        for (int i = 0; i < Nargs; ++i) {
            this.datos.add(null);
        }
        this.datos.setElementAt(OOpts, 0);
        this.datos.setElementAt(SCEDClient.toVector(RReserves), 1);
        try {
            System.out.println("SCEDClient : Calling economic dispatch...");
            this.resultado = (Hashtable)this.server.execute("myHandler.SCEDDispatch", this.datos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : Server response OK...");
        this.Pnames = SCEDClient.toStringArray((Vector)this.resultado.get("GenName"));
        this.P = SCEDClient.todoubleArray((Vector)this.resultado.get("Gen"));
        this.Rupp = SCEDClient.todoubleArray((Vector)this.resultado.get("Rupp"));
        this.Rdnp = SCEDClient.todoubleArray((Vector)this.resultado.get("Rdnp"));
        this.Rups = SCEDClient.todoubleArray((Vector)this.resultado.get("Rups"));
        this.Rdns = SCEDClient.todoubleArray((Vector)this.resultado.get("Rdns"));
        this.CMgs = SCEDClient.todoubleArray((Vector)this.resultado.get("CMgs"));
        System.out.println("SCED Client : Informacion recibida desde servidor...");
    }

    public void setDemand(String[] LLCod, double[] ddistFactors, double[] ttotdem) {
        Vector<Vector> misDatos = new Vector<Vector>(3);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(LLCod), 0);
        misDatos.setElementAt(SCEDClient.toVector(ddistFactors), 1);
        misDatos.setElementAt(SCEDClient.toVector(ttotdem), 2);
        try {
            System.out.println("SCEDClient : Seteando demanda por barra para realizar despacho economico...");
            String resultado = (String)this.server.execute("myHandler.setDemand", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void setGeneration(String[] GGCod, double[] GGeneration) {
        Vector<Vector> misDatos = new Vector<Vector>(2);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(GGCod), 0);
        misDatos.setElementAt(SCEDClient.toVector(GGeneration), 1);
        try {
            System.out.println("SCEDClient : Seteando punto actual de generacion para realizar despacho economico...");
            String resultado = (String)this.server.execute("myHandler.setGeneration", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void setPmax(String[] GGCod, double[] PPmax) {
        Vector<Vector> misDatos = new Vector<Vector>(2);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(GGCod), 0);
        misDatos.setElementAt(SCEDClient.toVector(PPmax), 1);
        try {
            System.out.println("SCEDClient : Seteando potencia maxima de generacion...");
            String resultado = (String)this.server.execute("myHandler.setPmax", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void setPmin(String[] GGCod, double[] PPmin) {
        Vector<Vector> misDatos = new Vector<Vector>(2);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(GGCod), 0);
        misDatos.setElementAt(SCEDClient.toVector(PPmin), 1);
        try {
            System.out.println("SCEDClient : Seteando potencia minima de generacion...");
            String resultado = (String)this.server.execute("myHandler.setPmin", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void setTmax(String[] TTCod, double[] PPmax) {
        Vector<Vector> misDatos = new Vector<Vector>(2);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(TTCod), 0);
        misDatos.setElementAt(SCEDClient.toVector(PPmax), 1);
        try {
            System.out.println("SCEDClient : Seteando potencia maxima de transmision...");
            String resultado = (String)this.server.execute("myHandler.setTmax", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void setBeta(String[] GGCod, double[] Bbeta) {
        Vector<Vector> misDatos = new Vector<Vector>(2);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(GGCod), 0);
        misDatos.setElementAt(SCEDClient.toVector(Bbeta), 1);
        try {
            System.out.println("SCEDClient : Seteando costo variable a unidades generadoras...");
            String resultado = (String)this.server.execute("myHandler.setBeta", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void setGenerators(String[] GGCod, double[] GGenerators) {
        Vector<Vector> misDatos = new Vector<Vector>(2);
        misDatos.add(null);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(GGCod), 0);
        misDatos.setElementAt(SCEDClient.toVector(GGenerators), 1);
        try {
            System.out.println("SCEDClient : Generadores considerados para realizar el despacho economico...");
            String resultado = (String)this.server.execute("myHandler.setGenerators", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void setReq(double[] Req) {
        Vector<Vector> misDatos = new Vector<Vector>(1);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(Req), 0);
        try {
            System.out.println("SCEDClient : Estableciendo requerimientos de reserva...");
            String resultado = (String)this.server.execute("myHandler.setReq", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
    }

    public void envioPrueba(String NombreA) {
        String resultado = "0";
        Vector<String> misDatos = new Vector<String>(1);
        misDatos.add(null);
        String miD = new String(NombreA);
        misDatos.setElementAt(miD, 0);
        try {
            System.out.println("SCEDClient : Enviando Datos a DeepEdit...");
            resultado = (String)this.server.execute("myHandler.envioPrueba", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (IOException e) {
            System.err.println("SCEDClient : Operation Timed Out");
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        this.estado = Integer.valueOf(resultado);
        System.out.println("SCEDClient : OK...");
    }

    public double getBarraSpot(String nombarra) {
        double resultado = 0.0;
        Vector<String> misDatos = new Vector<String>(1);
        misDatos.add(null);
        String miD = new String(nombarra);
        misDatos.setElementAt(miD, 0);
        try {
            System.out.println("SCEDClient : Enviando Datos a DeepEdit...");
            resultado = (Double)this.server.execute("myHandler.getBarraSpot", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (IOException e) {
            System.err.println("SCEDClient : Operation Timed Out");
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
        return resultado;
    }

    public double getPUtotal(String nombarra) {
        double resultado = 0.0;
        Vector<String> misDatos = new Vector<String>(1);
        misDatos.add(null);
        String miD = new String(nombarra);
        misDatos.setElementAt(miD, 0);
        try {
            System.out.println("SCEDClient : Enviando Datos a DeepEdit...");
            resultado = (Double)this.server.execute("myHandler.getPUtotal", misDatos);
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (IOException e) {
            System.err.println("SCEDClient : Operation Timed Out");
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
        return resultado;
    }

    public double[] getGen(String[] GGen) {
        double[] resultado = new double[GGen.length];
        Vector<Vector> misDatos = new Vector<Vector>(1);
        misDatos.add(null);
        misDatos.setElementAt(SCEDClient.toVector(GGen), 0);
        try {
            System.out.println("SCEDClient : Enviando Datos a DeepEdit...");
            resultado = SCEDClient.todoubleArray((Vector)this.server.execute("myHandler.getGen", misDatos));
        }
        catch (XmlRpcException exception) {
            System.err.println("SCEDClient : XML-RPC Fault #" + Integer.toString(exception.code) + ": ");
            System.err.println(exception.toString());
        }
        catch (IOException e) {
            System.err.println("SCEDClient : Operation Timed Out");
        }
        catch (Exception exception) {
            System.err.println("SCEDClient : " + exception.toString());
        }
        System.out.println("SCEDClient : OK...");
        return resultado;
    }

    public void getestado() {
        if (this.estado == 1) {
            System.out.println("DeepEdit Server Status: Connected ");
        } else {
            System.out.println("DeepEdit Server Status: Not Connected");
        }
    }

    public int getNcall() {
        return this.Ncall;
    }

    public double[] getP() {
        return this.P;
    }

    public String[] getPnames() {
        return this.Pnames;
    }

    public double[] getRupp() {
        return this.Rupp;
    }

    public double[] getRdnp() {
        return this.Rdnp;
    }

    public double[] getRups() {
        return this.Rups;
    }

    public double[] getRdns() {
        return this.Rdns;
    }

    public double[] getCMgs() {
        return this.CMgs;
    }

    public static double sum(double[] d) {
        double suma = 0.0;
        for (int i = 0; i < d.length; ++i) {
            suma += d[i];
        }
        return suma;
    }

    public static double[] truncate(double[] d, int n) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = SCEDClient.truncate(d[i], (double)n);
        }
        return d;
    }

    public static double truncate(double d, double n) {
        if (n == -1.0) {
            return d;
        }
        double dec = Math.pow(10.0, n);
        return Math.floor(d * dec + 0.5) / dec;
    }

    public static String fill(String s, String auxs, int l) {
        if (s.length() >= l) {
            return s;
        }
        while (s.length() < l) {
            s = s + auxs;
        }
        return s;
    }

    public static String toString(double[] d, String auxs, int l) {
        String s = "";
        for (int i = 0; i < d.length; ++i) {
            s = s + SCEDClient.fill(Double.toString(d[i]), auxs, l) + ", ";
        }
        return s;
    }

    public static String toString(String[] miString, String auxs, int l) {
        String s = "";
        for (int i = 0; i < miString.length; ++i) {
            s = s + SCEDClient.fill(miString[i], auxs, l) + ", ";
        }
        return s;
    }

    public static String toString(double d, String auxs, int l) {
        return SCEDClient.fill(Double.toString(d), auxs, l);
    }

    public static double[] todoubleArray(Vector Vect) {
        double[] resultado = new double[Vect.size()];
        for (int i = 0; i < Vect.size(); ++i) {
            resultado[i] = (Double)Vect.get(i);
        }
        return resultado;
    }

    public static String[] toStringArray(Vector Vect) {
        String[] resultado = new String[Vect.size()];
        for (int i = 0; i < Vect.size(); ++i) {
            resultado[i] = (String)Vect.get(i);
        }
        return resultado;
    }

    public static Vector toVector(double[] doub) {
        Vector<Double> resultado = new Vector<Double>(doub.length, 1);
        for (int i = 0; i < doub.length; ++i) {
            resultado.add(new Double(doub[i]));
        }
        return resultado;
    }

    public static Vector toVector(double doub) {
        Vector<Double> resultado = new Vector<Double>(1);
        resultado.add(0, new Double(doub));
        return resultado;
    }

    public static Vector toVector(String[] s) {
        Vector<String> resultado = new Vector<String>(s.length, 1);
        for (int i = 0; i < s.length; ++i) {
            resultado.add(s[i]);
        }
        return resultado;
    }

    public static Vector toVector(int rows, int columns, double[][] d) {
        Vector<Serializable> resultado = new Vector<Serializable>(rows + 2);
        for (int i = 0; i < rows; ++i) {
            Vector<Double> myRow = new Vector<Double>(columns);
            for (int j = 0; j < columns; ++j) {
                myRow.add(new Double(d[i][j]));
            }
            resultado.add(myRow);
        }
        resultado.add(new Integer(rows));
        resultado.add(new Integer(columns));
        return resultado;
    }

    public static double[][] todoubleM(Vector V) {
        int rows = (Integer)V.get(V.size() - 2);
        int columns = (Integer)V.get(V.size() - 1);
        double[][] d = new double[rows][columns];
        Vector myRow = (Vector)V.get(0);
        for (int i = 0; i < rows; ++i) {
            myRow = (Vector)V.get(i);
            for (int j = 0; j < columns; ++j) {
                d[i][j] = (Double)myRow.get(j);
            }
        }
        return d;
    }
}

