/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import com.objectplanet.chart.BarChart;
import de.core.DeepEdit;
import de.core.Load;
import de.core.SCED;
import de.core.SCEDDatos;
import de.core.SCEDShowResults;
import de.core.SwingWorker;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import java.awt.BorderLayout;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

class SCEDAnalysisFrame
extends JDialog
implements KeyListener,
ActionListener {
    private SCED Myequiv;
    private SCED MyequivAux;
    private String ctrla;
    private JComboBox MyChoiceCtrla = null;
    private JComboBox chSolver = null;
    private JComboBox chMaxIter = null;
    private JComboBox chMaxRHSTol = null;
    private JComboBox chMaxCostTol = null;
    private JComboBox chTimeFrame = null;
    private JComboBox chRequp = null;
    private JComboBox chReqdn = null;
    private JComboBox chReqdemup = null;
    SCEDShowResults MySCEDShowResults = null;
    private JComboBox chContingency = null;
    private JRadioButton chbRegSecUp = null;
    private JRadioButton chbRegSecDn = null;
    private JRadioButton chbPreConti = null;
    private JRadioButton chbPostConti = null;
    private CheckboxGroup chbgLossMod = null;
    private JCheckBox lin;
    private JCheckBox incremental;
    private JButton buttonCalc;
    private JButton buttonCancel;
    private JButton buttonDisplay;
    private JButton buttonView;
    private JButton buttonShow;
    private JButton buttonOppC;
    private SwingWorker worker = null;
    private Vector dialogJComps2disable = null;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;

    SCEDAnalysisFrame(SCED ms) {
        super(DeepEdit.frame, "SCED Analysis Tools", false);
        int i;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.Myequiv = ms;
        this.MyequivAux = ms;
        this.TextDialogFont = DeepEdit.TextFont;
        JPanel Union = new JPanel();
        JPanel Analysis = new JPanel();
        JPanel opModelPanel = new JPanel();
        BorderLayout bl = new BorderLayout();
        Union.setLayout(bl);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        this.dialogJComps2disable = new Vector(20);
        c1.gridheight = 1;
        c1.gridwidth = 1;
        c1.anchor = 17;
        c2.gridheight = 1;
        c2.gridwidth = 0;
        c2.fill = 2;
        c2.insets = new Insets(1, 1, 1, 1);
        opModelPanel.setLayout(gridbag);
        JLabel auxLab = new JLabel(" Select a Flow    ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        ButtonGroup chbgLossMod = new ButtonGroup();
        this.chbPreConti = new JRadioButton("PreContingency", true);
        this.dialogJComps2disable.add(this.chbPreConti);
        this.chbPreConti.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbPreConti, c2);
        chbgLossMod.add(this.chbPreConti);
        auxLab = new JLabel("      ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.chbRegSecUp = new JRadioButton("Secundary Up", false);
        this.dialogJComps2disable.add(this.chbRegSecUp);
        this.chbRegSecUp.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbRegSecUp, c2);
        chbgLossMod.add(this.chbRegSecUp);
        auxLab = new JLabel("             ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.chbRegSecDn = new JRadioButton("Secundary Down", false);
        this.dialogJComps2disable.add(this.chbRegSecDn);
        this.chbRegSecDn.setFont(this.TextDialogFont);
        opModelPanel.add((Component)this.chbRegSecDn, c2);
        chbgLossMod.add(this.chbRegSecDn);
        if (this.Myequiv.numcon > 0) {
            auxLab = new JLabel("                    ", 2);
            this.dialogJComps2disable.add(auxLab);
            auxLab.setFont(this.TextDialogFont);
            gridbag.setConstraints(auxLab, c1);
            opModelPanel.add(auxLab);
            this.chbPostConti = new JRadioButton("PostContingency  ", false);
            this.dialogJComps2disable.add(this.chbPostConti);
            this.chbPostConti.setFont(this.TextDialogFont);
            opModelPanel.add((Component)this.chbPostConti, c1);
            chbgLossMod.add(this.chbPostConti);
            String[] Contingencias = new String[this.Myequiv.numcon];
            for (int i2 = 0; i2 < this.Myequiv.numcon; ++i2) {
                Contingencias[i2] = this.Myequiv.Conting[i2][0] + " " + this.Myequiv.Conting[i2][1];
            }
            this.chContingency = new JComboBox<String>(Contingencias);
            this.dialogJComps2disable.add(this.chContingency);
            this.chContingency.setFont(this.TextDialogFont);
            this.chContingency.setSelectedIndex(0);
            opModelPanel.add((Component)this.chContingency, c2);
        } else {
            this.chbPostConti = new JRadioButton("PostContingency  ", false);
        }
        auxLab = new JLabel("             ", 2);
        this.dialogJComps2disable.add(auxLab);
        auxLab.setFont(this.TextDialogFont);
        opModelPanel.add((Component)auxLab, c1);
        this.buttonView = new JButton("View");
        this.dialogJComps2disable.add(this.buttonView);
        this.buttonView.setFont(this.TextDialogFont);
        opModelPanel.add(this.buttonView);
        this.buttonView.addActionListener(this);
        TitledBorder inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "FLOWS VISUALIZATION", 2, 2, this.TextDialogFont, Color.blue);
        opModelPanel.setBorder(inB);
        gridbag = new GridBagLayout();
        Analysis.setLayout(gridbag);
        JLabel auxLab2 = new JLabel("Display Contingency Elements:   ", 2);
        this.dialogJComps2disable.add(auxLab2);
        auxLab2.setFont(this.TextDialogFont);
        Analysis.add((Component)auxLab2, c1);
        this.buttonDisplay = new JButton("Display");
        this.dialogJComps2disable.add(this.buttonDisplay);
        this.buttonDisplay.setFont(this.TextDialogFont);
        Analysis.add((Component)this.buttonDisplay, c2);
        this.buttonDisplay.addActionListener(this);
        auxLab2 = new JLabel("Show Results:   ", 2);
        this.dialogJComps2disable.add(auxLab2);
        auxLab2.setFont(this.TextDialogFont);
        Analysis.add((Component)auxLab2, c1);
        this.buttonShow = new JButton("Show!");
        this.dialogJComps2disable.add(this.buttonShow);
        this.buttonShow.setFont(this.TextDialogFont);
        Analysis.add((Component)this.buttonShow, c2);
        this.buttonShow.addActionListener(this);
        inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "OTHER TOOLS", 2, 2, this.TextDialogFont, Color.blue);
        Analysis.setBorder(inB);
        Union.add((Component)opModelPanel, "North");
        Union.add((Component)Analysis, "Center");
        this.getContentPane().add((Component)Union, "West");
        JPanel opGraph = new JPanel();
        gridbag = new GridBagLayout();
        opGraph.setLayout(gridbag);
        double Rps = 0.0;
        double Rpb = 0.0;
        double Rss = 0.0;
        double Rsb = 0.0;
        for (i = 0; i < this.Myequiv.numgen; ++i) {
            Rps += this.Myequiv.Rupp[i];
            Rpb += this.Myequiv.Rdnp[i];
        }
        for (i = 0; i < this.Myequiv.numlast; ++i) {
            Rps += this.Myequiv.vec_xtempabs[this.Myequiv.numcon * (this.Myequiv.numgen + this.Myequiv.numlast + this.Myequiv.numnod) + 5 * this.Myequiv.numgen + 3 * this.Myequiv.numnod + i];
        }
        for (i = 0; i < this.Myequiv.numgen; ++i) {
            Rss += this.Myequiv.Rups[i];
            Rsb += this.Myequiv.Rdns[i];
        }
        double[] values = new double[]{Rps * this.Myequiv.getSref(), Rpb * this.Myequiv.getSref(), Rss * this.Myequiv.getSref(), -Rsb * this.Myequiv.getSref()};
        String[] barLabels = new String[]{"Reg. Prim. Up", "Reg. Prim. Dn", "Reg. Sec. Up", "Reg. Sec. Dn"};
        String[] sampleLabels = new String[]{values[0] + "\nMW", values[1] + "\nMW", values[2] + "\nMW", values[3] + "\nMW"};
        Color[] c = new Color[]{new Color(362457)};
        BarChart chart = new BarChart();
        chart.setSampleCount(4);
        chart.setSampleValues(0, values);
        chart.setSampleColors(c);
        chart.setSampleLabels(sampleLabels);
        chart.setBackground(Color.white);
        chart.set3DModeOn(true);
        chart.set3DDepth(5);
        chart.setBarWidth(0.6);
        chart.setBarOutlineOn(true);
        chart.setRangeLabelsOn(true);
        chart.setRange(0, Math.max(Math.max(values[0], values[1]), Math.max(values[2], values[3])));
        chart.setBarLabels(barLabels);
        chart.setBarLabelsOn(true);
        chart.setLabelAngle("barLabelAngle", 330);
        chart.setLabel("rangeAxisLabel", "[MW]");
        chart.setLabelAngle("rangeAxisLabel", 180);
        chart.setValueLabelsOn(true);
        chart.setValueLinesOn(true);
        opGraph.setSize(300, 220);
        opGraph.add(chart);
        inB = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "POWER RESERVE CHART", 2, 2, this.TextDialogFont, Color.blue);
        opGraph.setBorder(inB);
        this.getContentPane().add((Component)opGraph, "East");
        JPanel controlP = new JPanel();
        controlP.setLayout(new FlowLayout());
        this.buttonCancel = new JButton("Close");
        this.buttonCancel.setFont(this.TextDialogFont);
        controlP.add(this.buttonCancel);
        this.buttonCancel.addActionListener(this);
        this.getContentPane().add((Component)controlP, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        this.buttonCancel.addKeyListener(this);
        DeepEdit cfr_ignored_0 = ms.applet;
        this.setLocationRelativeTo(DeepEdit.frame);
        this.setLocation(200, 100);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
            this.Myequiv.MySCEDAnalysisFrame = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        block30: {
            Object obj = ev.getSource();
            String label = ev.getActionCommand();
            if (obj == this.buttonShow) {
                try {
                    System.out.println("Showing reserve results...");
                    if (this.MySCEDShowResults == null) {
                        this.MySCEDShowResults = new SCEDShowResults(this.Myequiv);
                        this.MySCEDShowResults = null;
                        break block30;
                    }
                    this.MySCEDShowResults.setVisible(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SCED Analysis Frame Error", 0);
                    e.printStackTrace();
                }
            } else if (obj == this.buttonView) {
                try {
                    System.out.println("Showing flow results...");
                    if (this.chbPreConti.isSelected()) {
                        System.out.println("   - Resultados en Precontingencia...");
                        this.Myequiv.WriteResultsPreCon();
                        System.out.println("   - Finalizando metodo...");
                        this.restorecolor();
                        this.Myequiv.ActSchematic.Modified = false;
                        this.Myequiv.ActSchematic.Modifiedstate = false;
                        this.Myequiv.ActSchematic.changeGIS = true;
                        DeepEdit.MySchematicPanel.repaint();
                        this.Myequiv = this.MyequivAux;
                    } else if (this.chbRegSecUp.isSelected()) {
                        this.Myequiv.WriteResultsSecUp();
                        System.out.println("   - Finalizando metodo...");
                        this.restorecolor();
                        this.Myequiv.ActSchematic.Modified = false;
                        this.Myequiv.ActSchematic.Modifiedstate = false;
                        this.Myequiv.ActSchematic.changeGIS = true;
                        DeepEdit.MySchematicPanel.repaint();
                    } else if (this.chbRegSecDn.isSelected()) {
                        this.Myequiv.WriteResultsSecDn();
                        System.out.println("   - Finalizando metodo...");
                        this.restorecolor();
                        this.Myequiv.ActSchematic.Modified = false;
                        this.Myequiv.ActSchematic.Modifiedstate = false;
                        this.Myequiv.ActSchematic.changeGIS = true;
                        DeepEdit.MySchematicPanel.repaint();
                    } else if (this.chbPostConti.isSelected()) {
                        int k = this.chContingency.getSelectedIndex();
                        System.out.println("   - Resultados Contingencia #" + (k + 1) + ": " + this.Myequiv.Conting[k][0]);
                        this.Myequiv.WriteResultsConting(k, this.Myequiv.Conting[k][0]);
                        this.Myequiv.ActSchematic.Modified = false;
                        this.Myequiv.ActSchematic.Modifiedstate = false;
                        this.Myequiv.ActSchematic.changeGIS = true;
                        DeepEdit.MySchematicPanel.repaint();
                    }
                }
                catch (Exception e) {
                    this.setVisible(false);
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SCED Analysis Frame Error", 0);
                    this.endDialog();
                }
            } else if (obj == this.buttonCancel) {
                this.Myequiv.WriteResultsPreCon();
                this.Myequiv.IdidntRealize();
                try {
                    if (this.worker != null) {
                        this.worker.interrupt();
                    }
                    this.endDialog();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SCED Analysis Frame Error", 0);
                    e.printStackTrace();
                }
                this.endDialog();
            } else if (obj == this.buttonDisplay) {
                System.out.println("SCEDAnalysisFrame: Displaying contingency elements...");
                try {
                    comp TempComponent;
                    Load TempLoad = null;
                    Object TempGenerator = null;
                    boolean counterL = false;
                    boolean counterT = false;
                    boolean counterB = false;
                    int ix = 0;
                    FileOutputStream os = new FileOutputStream("./results/SCEDAnalysisFrame.dat");
                    SCEDDatos datosSCED = new SCEDDatos();
                    datosSCED.loaddatafromfile();
                    int datofile = 0;
                    int contingencia = 12;
                    int numcon = 0;
                    int count6 = 0;
                    for (ix = 0; ix < this.Myequiv.ActSchematic.Components.size(); ++ix) {
                        TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(ix);
                        if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) && !(TempComponent instanceof ndb_inj) && !(TempComponent instanceof Load) || (datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName)) != 1) continue;
                        ++numcon;
                    }
                    String[][] Conting = new String[numcon][2];
                    for (ix = 0; ix < this.Myequiv.ActSchematic.Components.size(); ++ix) {
                        TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(ix);
                        if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
                        if (TempComponent instanceof ndb_branch && (datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName)) == 1) {
                            Conting[count6][0] = TempComponent.ComponentName;
                            Conting[count6][1] = "Rama";
                            ++count6;
                        }
                        if (TempComponent instanceof ndb_inj && (datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName)) == 1) {
                            Conting[count6][0] = TempComponent.ComponentName;
                            Conting[count6][1] = "Generador";
                            ++count6;
                        }
                        if (!(TempComponent instanceof Load)) continue;
                        datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName);
                        TempLoad = (Load)TempComponent;
                        if (datofile != 1) continue;
                        Conting[count6][0] = TempComponent.ComponentName;
                        Conting[count6][1] = "Consumo";
                        ++count6;
                    }
                    System.out.println("--------------------------------------------------");
                    System.out.println("       Elementos modelados con contingencia");
                    System.out.println("--------------------------------------------------");
                    for (ix = 0; ix < this.Myequiv.ActSchematic.Components.size(); ++ix) {
                        TempComponent = (comp)this.Myequiv.ActSchematic.Components.elementAt(ix);
                        if (!TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_comp)) continue;
                        ndb_comp Tempndb = (ndb_comp)TempComponent;
                        Tempndb.setAlternatekv_Color(Color.darkGray);
                        for (int k = 0; k < numcon; ++k) {
                            if (TempComponent.getName() != Conting[k][0]) continue;
                            System.out.println("Tipo: " + Conting[k][1] + "\t" + "\t" + "Nombre:" + Conting[k][0]);
                            Tempndb.lw = 2;
                            Tempndb.setAlternatekv_Color(Color.red);
                        }
                    }
                    System.out.println("--------------------------------------------------");
                    os.close();
                    DeepEdit.MySchematicPanel.repaint();
                    this.repaint();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(DeepEdit.frame, e.toString(), "SCED Analysis Frame Error", 0);
                    e.printStackTrace();
                }
            }
        }
    }

    private void disableComponents() {
        for (int i = 0; i < this.dialogJComps2disable.size(); ++i) {
            ((JComponent)this.dialogJComps2disable.elementAt(i)).setEnabled(false);
        }
    }

    private void runSolver() {
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                SCEDAnalysisFrame.this.Myequiv.Calculate(true, 1);
                return new Object();
            }

            @Override
            public void finished() {
                SCEDAnalysisFrame.this.endDialog();
            }
        };
        this.worker.start();
    }

    private void endDialog() {
        this.restorecolor();
        this.dispose();
        this.Myequiv.MySCEDAnalysisFrame = null;
        Runtime.getRuntime().gc();
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }
}

