/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.SCEDAnalysisFrame;
import de.core.SCEDDatos;
import de.core.SCEDFrame;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloRange;
import ilog.cplex.IloCplex;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class SCED
extends AnalysisTool {
    SCEDFrame MySCEDFrame = null;
    SCEDAnalysisFrame MySCEDAnalysisFrame = null;
    double[][] MatG;
    double[][] MatX;
    protected Vector BusbarVectorI;
    int numbran = 0;
    int numnod = 0;
    int numgen = 0;
    int numtrafo = 0;
    int numlast = 0;
    int numvar = 0;
    int numres = 0;
    int numcon = 0;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    boolean overiter = false;
    double mean_c = 1000000.0;
    double[] vec_xminabs;
    double[] vec_xmaxabs;
    double[] vec_xmin;
    double[] vec_xmax;
    double[] vec_xtemp;
    double[] vec_xtempabs;
    double[] vec_xant;
    double[] vec_c;
    double[] vec_RHS;
    double[] vec_OBJ;
    double[] vec_lam;
    double[] DiagMat_Q;
    double[] node_p;
    double[] Requpserver;
    int[] vec_clave;
    double totcost = 0.0;
    double totgen = 0.0;
    double totunser = 0.0;
    double totloss = 0.0;
    double totdem = 0.0;
    double totincome = 0.0;
    double totsales = 0.0;
    double totit = 0.0;
    double totunsercost = 0.0;
    int iteraciones;
    double tolerancia;
    double tolcost;
    double tolfeas;
    int metodo = 1;
    double[][] mat_W;
    double[][] mat_A;
    DeepEdit applet;
    PrintStream myPPrintStream;
    int tapito = 0;
    Complex[][] MatY;
    public boolean linres = true;
    public boolean incremental = false;
    public boolean centralized = false;
    public boolean partDem = true;
    double nummin = 1.0;
    boolean cuadLossModel = false;
    String[][] Conting;
    String[][] GenName;
    String[][] LoadName;
    String[][] BranName;
    double[] Rpdn;
    double[] Pmax;
    double[] Pmin;
    double[] Rupp;
    double[] Rdnp;
    double[] Rups;
    double[] Rdns;
    double[] CMgs;
    double[][] COgen;
    double[] COload;
    int llamada = 0;
    int Requp = 0;
    int Reqdn = 0;
    int Reqdemup = 0;
    int Reqdemdn = 0;
    double dRequp = 0.0;
    double dReqdn = 0.0;
    double dReqdemup = 0.0;
    double dReqdemdn = 0.0;
    String status = " ";
    static final String[] solverOptions = new String[]{"Minos", "Cplex"};
    static final String[] maxIterOptions = new String[]{"10", "15", "20", "25", "30", "60", "100", "1000"};
    static final String[] maxRHSTolOptions = new String[]{"0.00001", "0.0001", "0.001", "0.01", "0.1", "1", "5", "10"};
    static final String[] maxCostTolOptions = new String[]{"0.00001", "0.0001", "0.001", "0.01", "0.1", "0.5", "1", "5", "10"};
    static final String[] TimeFrameOptions = new String[]{"1", "5", "10", "15", "30", "60"};
    static final String[] Reqprimaryup = new String[]{"0", "10", "20", "30", "40", "50", "100", "150", "200", "250"};
    static final String[] Reqprimarydn = new String[]{"0", "10", "20", "30", "40", "50", "100", "150", "200", "250"};
    static final String[] Reqsecdemup = new String[]{"0", "10", "20", "30", "40", "50", "100", "150", "200", "250"};
    static final String[] Reqsecdemdn = new String[]{"0", "10", "20", "30", "40", "50", "100", "150", "200", "250"};
    double[] Flujo;
    String[] NomBra;
    private double sref = 100.0;

    public SCED(Schematic sch) {
        super(sch);
        this.sref = this.getSref();
        System.out.println("---------- In SCED Calculation Tool ------------ *");
        if (this.MySCEDFrame == null) {
            this.MySCEDFrame = new SCEDFrame(this);
        } else {
            this.MySCEDFrame.show();
        }
    }

    public SCED(Schematic sch, int opt, String s) {
        super(sch);
        this.llamada = 2;
        System.out.println("---------- In SCED Calculation Tool ------------ 2");
        int auxopt = 1;
        boolean auxfr = true;
        this.sref = this.getSref();
        if (opt == 1) {
            auxopt = 1;
            auxfr = false;
        } else {
            auxopt = 4;
            auxfr = true;
        }
    }

    public SCED(Schematic sch, int opt) {
        super(sch);
        System.out.println("---------- In SCED Calculation Tool ------------ 3");
        this.llamada = 2;
        int auxopt = 1;
        int auxfr = 1;
        this.sref = this.getSref();
        if (opt == 1) {
            auxopt = 1;
            auxfr = 0;
        } else {
            auxopt = 4;
            auxfr = 1;
        }
        auxopt = 1;
        auxfr = 0;
        this.setParameters(auxfr, 6, 0, 0, true, false, false, 1, 30, 50, 10, 10, false, true);
        this.Calculate(true, auxopt);
    }

    public void Calculate(boolean sino, int modelo) {
        FileOutputStream os;
        boolean konv = false;
        double cost1 = 0.0;
        double cost2 = 0.0;
        double cost3 = 0.0;
        double tol = 0.0;
        FileInputStream is1 = null;
        int iteration = 0;
        int i = 0;
        int j = 0;
        String SCEDdat = "./results/SCED.dat";
        try {
            SimpleDialog ExceptionDialog;
            os = new FileOutputStream(SCEDdat);
            this.initNetwork(os);
            System.out.println("a. Definiendo punto de partida optimizacion...");
            this.startPoint();
            System.out.println("b. Escribiendo vector de costos...");
            this.make_vec_c();
            System.out.println("c. Escribiendo matriz de costos cuadr\u0087ticos...");
            this.make_DiagMat_Q();
            System.out.println("d. Armado de parte fija de Matriz de Restricciones A...");
            this.make_mat_Afix();
            System.out.println("e. Definicion del tipo de restricciones...");
            this.make_vec_clave();
            System.out.println("f. Determinacion Costo inicial del Sistema...");
            cost2 = this.make_cost();
            System.out.println("g. Igualacion de Costos.");
            cost1 = cost2;
            System.out.println("h. Requerimiento Subida : " + String.valueOf(this.Requp) + " [MW]");
            System.out.println("i. Requerimiento Bajada : " + String.valueOf(this.Reqdn) + " [MW]");
            System.out.println("j. Variacion Dda. Subida: " + String.valueOf(this.Reqdemup) + " [MW]");
            System.out.println("k. Variacion Dda. Bajada: " + String.valueOf(this.Reqdemdn) + " [MW]");
            System.out.println("   Fin Armado Matrices y Vectores - Comienzo Iteraciones");
            for (i = 0; i < this.numvar; ++i) {
                this.vec_xtemp[i] = 0.0;
            }
            for (i = 0; i < this.numres; ++i) {
                this.vec_lam[i] = 0.0;
            }
            System.out.println("------------ R E S O L V I E N D O ---------------");
            while (!konv && iteration < this.iteraciones) {
                System.out.println("SCED-ITERATION... : " + ++iteration);
                this.make_vec_OBJ();
                System.out.println("   a. Armando Matriz A... ");
                this.make_mat_A();
                this.make_vec_RHS();
                System.out.println("   b. Armando Matriz W... ");
                this.make_mat_W();
                this.update_vec_xlimits();
                this.myPPrintStream.println("Limites Inferiores Vector de Estado: ");
                this.myPPrintStream.println(" ");
                SCED.printVector(this.myPPrintStream, this.vec_xminabs, this.numvar);
                this.myPPrintStream.println("Limites Superiores Vector de Estado: ");
                this.myPPrintStream.println(" ");
                SCED.printVector(this.myPPrintStream, this.vec_xmaxabs, this.numvar);
                this.myPPrintStream.println("ITERACION: " + iteration);
                this.myPPrintStream.println(" ");
                this.myPPrintStream.println("Vector absoluto");
                SCED.printVector(this.myPPrintStream, this.vec_xtempabs, this.numvar);
                this.myPPrintStream.println("Vector OBJ");
                SCED.printVector(this.myPPrintStream, this.vec_OBJ, this.numvar);
                this.myPPrintStream.println("Matriz A");
                SCED.printMatrix(this.myPPrintStream, this.mat_A, this.numres, this.numvar);
                this.myPPrintStream.println("Matriz W");
                SCED.printMatrix(this.myPPrintStream, this.mat_W, this.numvar, this.numvar);
                this.myPPrintStream.println("- RHS");
                SCED.printVector(this.myPPrintStream, this.vec_RHS, this.numres);
                if (this.metodo == 1 || this.metodo == 2 || this.metodo == 3) {
                    String message;
                    PrintStream myPrintStream;
                    BufferedOutputStream bos;
                    try {
                        os = new FileOutputStream("./economic.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        System.out.println("   Escritura de economic.dat");
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        myPrintStream.println(this.numres);
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_OBJ[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_RHS[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                myPrintStream.println(this.mat_A[i][j]);
                            }
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numres; ++i) {
                            myPrintStream.println(this.vec_clave[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmin[i]);
                        }
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            myPrintStream.println(this.vec_xmax[i]);
                        }
                        myPrintStream.println(" ");
                        myPrintStream.println("min");
                        myPrintStream.println("Ergebnisse aus SQP");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-economic.dat", message + " C1", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    try {
                        os = new FileOutputStream("./matw.dat");
                        bos = new BufferedOutputStream(os, 32768);
                        myPrintStream = new PrintStream(bos, false);
                        myPrintStream.println(this.numvar);
                        myPrintStream.println(" ");
                        for (i = 0; i < this.numvar; ++i) {
                            for (j = 0; j < this.numvar; ++j) {
                                myPrintStream.println(this.mat_W[i][j]);
                            }
                            myPrintStream.println(" ");
                        }
                        myPrintStream.println(" ");
                        myPrintStream.close();
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB-Matw", message + " C2", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("   Call Solver");
                    try {
                        SCED.Dorun("cmd /C " + DeepEdit.PathDOS + "cuadra.exe>sys.log", "./cuadra >sys.log", false);
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Call Cuadra", message + " C3", DlgButtons, 1, 0, 0, 1);
                        return;
                    }
                    System.out.println("   End Solver");
                    try {
                        String ln;
                        is1 = new FileInputStream("./soluci.dat");
                        i = 0;
                        BufferedReader is = new BufferedReader(new InputStreamReader(is1));
                        while ((ln = is.readLine()) != null) {
                            if (i != 0) {
                                if (i <= this.numvar) {
                                    this.vec_xtemp[i - 1] = Double.valueOf(ln);
                                    int n = i - 1;
                                    this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i - 1];
                                } else {
                                    this.vec_lam[i - this.numvar - 1] = Double.valueOf(ln);
                                }
                            } else {
                                cost3 = Double.valueOf(ln);
                            }
                            ++i;
                        }
                        is.close();
                        is = null;
                    }
                    catch (Exception e) {
                        message = e.toString();
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SQPB, reading soluci.dat", message + " C4", DlgButtons, 1, 0, 0, 1);
                    }
                } else if (this.metodo == 4) {
                    try {
                        double[] coef;
                        IloCplex cplex;
                        IloCplex qp = cplex = new IloCplex();
                        String[] Variables = new String[this.numvar];
                        int aux = 0;
                        for (i = 0; i < this.numgen; ++i) {
                            aux = i + 1;
                            Variables[i] = "P" + aux;
                        }
                        for (j = 0; j < this.numcon; ++j) {
                            aux = 0;
                            for (i = 0; i < this.numgen; ++i) {
                                aux = i + 1;
                                Variables[i + this.numgen * (1 + j)] = "dP" + aux + "," + (j + 1);
                            }
                        }
                        aux = 0;
                        for (i = 0; i < this.numgen; ++i) {
                            aux = i + 1;
                            Variables[i + this.numgen * (this.numcon + 1)] = "P" + aux + ",up";
                        }
                        aux = 0;
                        for (i = 0; i < this.numgen; ++i) {
                            aux = i + 1;
                            Variables[i + this.numgen * (this.numcon + 2)] = "P" + aux + ",dn";
                        }
                        for (j = 0; j < this.numcon; ++j) {
                            aux = 0;
                            for (i = 0; i < this.numlast; ++i) {
                                aux = i + 1;
                                Variables[i + this.numgen * (this.numcon + 3) + this.numlast * j] = "dD" + aux + "," + (j + 1);
                            }
                        }
                        aux = 0;
                        for (i = 0; i < this.numnod; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast) + 3 * this.numgen] = "\u00f0" + aux;
                        }
                        for (j = 0; j < this.numcon; ++j) {
                            aux = 0;
                            for (i = 0; i < this.numnod; ++i) {
                                aux = i + 1;
                                Variables[i + this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod + j * this.numnod] = "\u00f0" + aux + "," + (j + 1);
                            }
                        }
                        aux = 0;
                        for (i = 0; i < this.numnod; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod] = "\u00f0" + aux + ",up";
                        }
                        aux = 0;
                        for (i = 0; i < this.numnod; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod] = "\u00f0" + aux + ",dn";
                        }
                        aux = 0;
                        for (i = 0; i < this.numgen; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] = "Rp" + aux + ",up";
                        }
                        aux = 0;
                        for (i = 0; i < this.numgen; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] = "Rp" + aux + ",dn";
                        }
                        aux = 0;
                        for (i = 0; i < this.numlast; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod] = "Rd" + aux + ",Load";
                        }
                        aux = 0;
                        for (i = 0; i < this.numcon; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + this.numlast] = "df" + aux;
                        }
                        aux = 0;
                        for (i = 0; i < this.numlast; ++i) {
                            aux = i + 1;
                            Variables[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + this.numlast + this.numcon] = "PU" + aux;
                        }
                        IloNumVar[] var = cplex.numVarArray(this.numvar, this.vec_xmin, this.vec_xmax, Variables);
                        IloLinearNumExpr lin = cplex.scalProd(this.vec_OBJ, var);
                        IloNumExpr aux3 = cplex.sum(0.0, (IloNumExpr)var[0]);
                        for (j = 0; j < this.numvar; ++j) {
                            for (i = 0; i < this.numvar; ++i) {
                                IloNumExpr aux2;
                                if (this.mat_W[i][j] == 0.0) continue;
                                if (i == j) {
                                    aux2 = cplex.prod(this.mat_W[i][j] / 2.0 + 0.0, cplex.square(var[i]));
                                    aux3 = cplex.sum(aux3, aux2);
                                    continue;
                                }
                                IloNumExpr aux1 = cplex.prod(this.mat_W[i][j] / 2.0, (IloNumExpr)var[j]);
                                aux2 = cplex.prod(aux1, (IloNumExpr)var[i]);
                                aux3 = cplex.sum(aux3, aux2);
                            }
                        }
                        IloNumExpr obj = cplex.sum((IloNumExpr)lin, aux3);
                        cplex.addMinimize(obj);
                        int numCRest = this.linres ? (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 8 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran + (this.numgen + 1) * this.numcon : (this.numcon + 1) * this.numnod + this.numcon * (4 * this.numgen + 3 * this.numlast) + 8 * this.numgen + 2 * this.numnod + 4 + (this.numgen + 1) * this.numcon;
                        IloRange[] res = new IloRange[numCRest];
                        for (i = 0; i < this.numnod * (this.numcon + 3); ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addEq(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                        }
                        for (i = this.numnod * (this.numcon + 3); i < this.numnod * (this.numcon + 3) + 2; ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                        }
                        for (i = this.numnod * (this.numcon + 3) + 2; i < this.numnod * (this.numcon + 3) + 4; ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                        }
                        if (this.linres) {
                            for (i = this.numnod * (this.numcon + 3) + 4; i < this.numnod * (this.numcon + 3) + 4 + this.numbran; ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                                coef = this.mat_A[i + this.numbran];
                                res[i + this.numbran] = cplex.addGe(this.vec_RHS[i + this.numbran], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran; i < this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + 2); ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                                coef = this.mat_A[i + this.numcon * this.numbran];
                                res[i + this.numbran * this.numcon] = cplex.addGe(this.vec_RHS[i + this.numbran * this.numcon], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1); i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen; ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addGe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * 2 * this.numgen; ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * 2 * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast); ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addEq(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                            for (i = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4; i < (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + this.numbran; ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                                coef = this.mat_A[i + this.numbran];
                                res[i + this.numbran] = cplex.addGe(this.vec_RHS[i + this.numbran], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                            for (i = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran; i < (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 3 * this.numbran; ++i) {
                                coef = this.mat_A[i];
                                res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                                coef = this.mat_A[i + this.numbran];
                                res[i + this.numbran] = cplex.addGe(this.vec_RHS[i + this.numbran], (IloNumExpr)cplex.scalProd(coef, var));
                            }
                        }
                        for (i = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; i < (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 5 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addGe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            System.out.println("Requp" + i);
                        }
                        for (i = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 5 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; i < (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 6 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addGe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                            System.out.println("Reqdn" + i);
                        }
                        for (i = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 6 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; i < (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 7 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addGe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                        }
                        for (i = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 7 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; i < (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 8 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; ++i) {
                            coef = this.mat_A[i];
                            res[i] = cplex.addLe(this.vec_RHS[i], (IloNumExpr)cplex.scalProd(coef, var));
                        }
                        cplex.exportModel("SCED.lp");
                        System.out.println("   c. Resolviendo el subproblema cuadtr\u00e1tico #" + iteration);
                        if (cplex.solve()) {
                            cost3 = cplex.getObjValue();
                            this.vec_xtemp = cplex.getValues(var);
                            for (i = 0; i < this.numvar; ++i) {
                                int n = i;
                                this.vec_xtempabs[n] = this.vec_xtempabs[n] + this.vec_xtemp[i];
                            }
                            for (i = 0; i < (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 8 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran; ++i) {
                                this.vec_lam[i] = cplex.getDual(res[i]);
                            }
                            System.out.println(" ");
                            for (i = 0; i < this.numgen; ++i) {
                                this.COgen[i][0] = Math.rint(-cplex.getReducedCost(var[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod]) / this.sref * 100.0) / 100.0;
                                this.COgen[i][1] = Math.rint(-cplex.getReducedCost(var[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod]) / this.sref * 100.0) / 100.0;
                                this.COgen[i][2] = Math.rint(-cplex.getReducedCost(var[i + this.numgen * (this.numcon + 1)]) / this.sref * 100.0) / 100.0;
                                this.COgen[i][3] = Math.rint(-cplex.getReducedCost(var[i + this.numgen * (this.numcon + 2)]) / this.sref * 100.0) / 100.0;
                            }
                            for (i = 0; i < this.numlast; ++i) {
                                this.COload[i] = Math.rint(-cplex.getReducedCost(var[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod]) * this.sref * 100.0) / 100.0;
                            }
                        } else {
                            this.status = cplex.getStatus().toString();
                            System.out.println(cplex.getStatus());
                            System.out.println("");
                            System.out.println("   No Optimal Solution Founded");
                            System.out.println("   Some problems in problem definition. ");
                        }
                        cplex.end();
                    }
                    catch (IloException e) {
                        System.err.println("   Concert exception caugth : " + e);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                cost2 = this.make_cost();
                tol = ((cost2 += cost3) - cost1) * (cost2 - cost1);
                double feasIndex = 0.0;
                double maxModRHS = 0.0;
                for (i = 0; i < this.numnod; ++i) {
                    feasIndex += this.vec_RHS[i] * this.vec_RHS[i];
                    if (!(Math.abs(this.vec_RHS[i]) > maxModRHS)) continue;
                    maxModRHS = Math.abs(this.vec_RHS[i]);
                }
                feasIndex = Math.sqrt(feasIndex);
                System.out.println(" ----------------------------------------------");
                System.out.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem));
                System.out.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                System.out.println(" ----------------------------------------------");
                System.out.println(" Feasibility         = " + feasIndex);
                System.out.println(" Max corrimiento     = " + maxModRHS);
                System.out.println(" ----------------------------------------------");
                System.out.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                System.out.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                System.out.println(" ----------------------------------------------");
                System.out.println(" ----------------------------------------------");
                System.out.println(" Fun Ob [$]          = " + cost2);
                System.out.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" RHS TOL [%]         = " + feasIndex * 100.0 / Math.sqrt(this.totdem * this.totdem));
                this.myPPrintStream.println(" COS TOL [%]         = " + Math.abs(cost2 - cost1) * 200.0 / (cost2 + cost1));
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Feasibility         = " + feasIndex);
                this.myPPrintStream.println(" Max corrimiento     = " + maxModRHS);
                this.myPPrintStream.println(" SP Result [$]       = " + cost3);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Valor Absoluto      = " + Math.abs(cost2 - cost1));
                this.myPPrintStream.println(" 0.5 [%] costo medio = " + 0.005 * (cost2 + cost1) / 2.0);
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" ----------------------------------------------");
                this.myPPrintStream.println(" Fun Ob [$]          = " + cost2);
                this.myPPrintStream.println(" ----------------------------------------------");
                if (feasIndex <= this.tolfeas * Math.sqrt(this.totdem * this.totdem) / 100.0 && Math.abs(cost2 - cost1) <= this.tolcost * (cost2 + cost1) / 2.0 / 100.0) {
                    System.out.println("   ");
                    System.out.println("          -------------------------  ");
                    System.out.println("           Convergencia Encontrada   ");
                    System.out.println("          -------------------------  ");
                    System.out.println("   ");
                    this.myPPrintStream.println("   ");
                    this.myPPrintStream.println("          *************************  ");
                    this.myPPrintStream.println("          *Convergencia Encontrada*  ");
                    this.myPPrintStream.println("          *************************  ");
                    this.myPPrintStream.println("   ");
                    konv = true;
                }
                this.myPPrintStream.println("Vector incremental");
                SCED.printVector(this.myPPrintStream, this.vec_xtemp, this.numvar);
                this.myPPrintStream.println("Vector de Costos");
                SCED.printVector(this.myPPrintStream, this.vec_c, this.numvar);
                this.myPPrintStream.println("Vector absoluto");
                SCED.printVector(this.myPPrintStream, this.vec_xtempabs, this.numvar);
                this.myPPrintStream.println("Multiplicadores");
                SCED.printVector(this.myPPrintStream, this.vec_lam, this.numres);
                this.myPPrintStream.println("Matriz X");
                SCED.printMatrix(this.myPPrintStream, this.MatX, this.numnod, this.numnod);
                this.myPPrintStream.println("Matriz G");
                SCED.printMatrix(this.myPPrintStream, this.MatG, this.numnod, this.numnod);
                cost1 = cost2;
                if (iteration == 1) {
                    konv = false;
                }
                if (iteration <= this.iteraciones) continue;
                this.overiter = true;
            }
            this.ActSchematic.setfitnes(-cost2);
            this.totcost = cost2;
            this.ActSchematic.settotcost(this.totcost);
            this.WriteResults();
            this.ActSchematic.settotgen(this.totgen);
            this.ActSchematic.settotunser(this.totunser);
            this.totloss = this.totgen + this.totunser - this.totdem;
            this.ActSchematic.settotloss(this.totloss);
            this.ActSchematic.settotdem(this.totdem);
            System.out.println("------------------------------------------------------------");
            System.out.println(" Optimization Results");
            System.out.println(" Objective Function  [$]  = " + cost2);
            System.out.println("------------------------------------------------------------");
            System.out.println(" Operation costs             = " + this.totcost + " [$]");
            System.out.println(" Active Generation           = " + this.totgen + " [MW]");
            System.out.println(" Load Unserved               = " + this.totunser + " [MW]");
            System.out.println(" Total Active Loss           = " + this.totloss + " <=> " + 100.0 * (this.totgen - this.totdem) / this.totgen + " [%]");
            System.out.println(" Total Active Demand         = " + this.totdem + " [MW]");
            System.out.println(" Total Load Sales            = " + this.totsales + " [$]");
            System.out.println(" Total Generator Income      = " + this.totincome + " [$]");
            System.out.println(" Total Unserved Energy Costs = " + this.totunsercost + " [$]");
            System.out.println(" Total Marginal Income       = " + -this.totit + " [$]");
            System.out.println("------------------------------------------------------------");
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Optimization Results");
            this.myPPrintStream.println(" Objective Function  [$]  = " + cost2);
            this.myPPrintStream.println("************************************************************");
            this.myPPrintStream.println(" Operation costs             = " + this.totcost + " [$]");
            this.myPPrintStream.println(" Active Generation           = " + this.totgen + " [MW]");
            this.myPPrintStream.println(" Load Unserved               = " + this.totunser + " [MW]");
            this.myPPrintStream.println(" Total Active Loss           = " + this.totloss + " <=> " + 100.0 * this.totloss / this.totdem + " [%]");
            this.myPPrintStream.println(" Total Active Demand         = " + this.totdem + " [MW]");
            this.myPPrintStream.println(" Total Load Sales            = " + this.totsales + " [$]");
            this.myPPrintStream.println(" Total Generator Income      = " + this.totincome + " [$]");
            this.myPPrintStream.println(" Total Unserved Energy Costs = " + this.totunsercost + " [$]");
            this.myPPrintStream.println(" Total Marginal Income       = " + -this.totit + " [$]");
            this.myPPrintStream.println("************************************************************");
            this.Rupp = new double[this.numgen];
            this.Rdnp = new double[this.numgen];
            this.Rups = new double[this.numgen];
            this.Rdns = new double[this.numgen];
            for (i = 0; i < this.numgen; ++i) {
                this.Rupp[i] = 0.0;
                this.Rdnp[i] = 0.0;
                this.Rups[i] = this.vec_xtempabs[this.numgen * (this.numcon + 1) + i];
                this.Rdns[i] = this.vec_xtempabs[this.numgen * (this.numcon + 2) + i];
                this.Rupp[i] = this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod + i];
                this.Rdnp[i] = this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod + i];
            }
            double[] CMgRup = new double[this.numgen];
            for (i = 0; i < this.numgen; ++i) {
                CMgRup[i] = this.vec_lam[this.numnod * (this.numcon + 3)];
            }
            for (i = 0; i < this.numgen; ++i) {
                for (int k = 0; k < this.numcon; ++k) {
                    int n = i;
                    CMgRup[n] = CMgRup[n] + this.vec_lam[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + i * this.numcon + k];
                }
            }
            int auxi = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran;
            this.CMgs = new double[4];
            this.CMgs[0] = this.vec_lam[this.numnod * (this.numcon + 3)] / this.sref;
            this.CMgs[1] = this.vec_lam[this.numnod * (this.numcon + 3) + 1] / this.sref;
            for (i = 0; i < this.numnod; ++i) {
                this.CMgs[2] = this.CMgs[2] + this.vec_lam[this.numnod * (this.numcon + 1) + i] * -this.node_p[i] / this.totdem;
                this.CMgs[3] = this.CMgs[3] - this.vec_lam[this.numnod * (this.numcon + 2) + i] * -this.node_p[i] / this.totdem;
            }
            this.ActSchematic.Modified = false;
            this.ActSchematic.Modifiedstate = false;
            this.ActSchematic.changeGIS = true;
            DeepEdit.MySchematicPanel.repaint();
            os.close();
            System.out.println(this.metodo);
            if (this.llamada != 2) {
                if (this.metodo == 4) {
                    if (this.status != "Infeasible" && this.status != "InfeasibleOrUnbounded") {
                        if (this.MySCEDAnalysisFrame == null) {
                            this.MySCEDAnalysisFrame = new SCEDAnalysisFrame(this);
                        } else {
                            this.MySCEDAnalysisFrame.setVisible(true);
                        }
                    } else {
                        String[] DlgButtons = new String[]{"OK"};
                        ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SCED Calculate", "No Optimal Solution Founded. Problem " + this.status, DlgButtons, 1, 0, 0, 1);
                    }
                } else if (this.MySCEDAnalysisFrame == null) {
                    this.MySCEDAnalysisFrame = new SCEDAnalysisFrame(this);
                } else {
                    this.MySCEDAnalysisFrame.setVisible(true);
                }
            }
            System.out.println("M\u00e9todo Finalizado...");
            this.status = " ";
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "SCED Calculate", message + " C5", DlgButtons, 1, 0, 0, 1);
            e.printStackTrace();
            return;
        }
        try {
            this.myPPrintStream.close();
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void initNetwork(FileOutputStream os) {
        Load TempLoad;
        Line TempLine;
        Busbar TempBusbar;
        comp TempComponent;
        this.myPPrintStream = new PrintStream(os);
        this.myPPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        int count = 0;
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        boolean count5 = false;
        int count6 = 0;
        int con1 = 10000;
        int con2 = 10000;
        int contingencia = 12;
        int respdn = 13;
        int probab = 14;
        this.BusbarVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        this.totdem = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                TempBusbar = (Busbar)TempComponent;
                this.myPPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Considerada");
                ++this.numnod;
                this.BusbarVectorI.addElement(TempComponent);
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtran;
                }
                ++this.numbran;
            }
            if (TempComponent instanceof ndb_inj) {
                TempComponent.InformAllComponents();
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            TempLoad = (Load)TempComponent;
            ++this.numlast;
            this.totdem += TempLoad.getp0();
        }
        System.out.println("Variables de la red...");
        System.out.println("   Generadores     numgen   = " + this.numgen);
        System.out.println("   Cargas          numlast  = " + this.numlast);
        System.out.println("   Ramas           numbran  = " + this.numbran);
        System.out.println(" ");
        SCEDDatos datosSCED = new SCEDDatos();
        datosSCED.loaddatafromfile();
        int datofile = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) && !(TempComponent instanceof ndb_inj) && !(TempComponent instanceof Load) || (datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName)) != 1) continue;
            ++this.numcon;
        }
        this.Conting = new String[this.numcon][2];
        this.GenName = new String[this.numgen][2];
        this.LoadName = new String[this.numlast][4];
        this.BranName = new String[this.numbran][4];
        this.Rpdn = new double[this.numgen];
        this.Pmax = new double[this.numgen];
        this.Pmin = new double[this.numgen];
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName);
                this.BranName[count][0] = TempComponent.ComponentName;
                this.BranName[count][1] = "" + this.numbus(TempComponent.getcon1());
                this.BranName[count][2] = "" + this.numbus(TempComponent.getcon2());
                this.BranName[count][3] = "" + datosSCED.getparameter(probab, TempComponent.ComponentName);
                if (datofile == 1) {
                    this.Conting[count6][0] = TempComponent.ComponentName;
                    this.Conting[count6][1] = "Rama";
                    ++count6;
                }
                ++count;
            }
            if (TempComponent instanceof ndb_inj) {
                this.Rpdn[count1] = datosSCED.getparameter(respdn, TempComponent.ComponentName);
                datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName);
                this.GenName[count1][0] = TempComponent.ComponentName;
                this.GenName[count1][1] = "" + datosSCED.getparameter(probab, TempComponent.ComponentName);
                if (datofile == 1) {
                    this.Conting[count6][0] = TempComponent.ComponentName;
                    this.Conting[count6][1] = "Generador";
                    ++count6;
                }
                ++count1;
            }
            if (!(TempComponent instanceof Load)) continue;
            datofile = (int)datosSCED.getparameter(contingencia, TempComponent.ComponentName);
            TempLoad = (Load)TempComponent;
            this.LoadName[count2][0] = TempComponent.ComponentName;
            this.LoadName[count2][1] = "" + this.numbus(TempLoad.getcon2());
            this.LoadName[count2][2] = "" + TempLoad.getp0();
            this.LoadName[count2][3] = "" + datosSCED.getparameter(probab, TempComponent.ComponentName);
            if (datofile == 1) {
                this.Conting[count6][0] = TempComponent.ComponentName;
                this.Conting[count6][1] = "Consumo";
                ++count6;
            }
            ++count2;
        }
        count = 0;
        count1 = 0;
        count2 = 0;
        this.numvar = this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 2 * this.numlast + this.numcon;
        this.numres = this.linres ? (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 8 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran + this.numcon * (this.numgen + 1) : (this.numcon + 1) * this.numnod + this.numcon * (4 * this.numgen + 3 * this.numlast) + 8 * this.numgen + 2 * this.numnod + 4 + this.numcon * (this.numgen + 1);
        System.out.println("Variables y Restricciones del Problema de Optimizacion...");
        System.out.println("   Variables     numvar   = " + this.numvar);
        System.out.println("   Restricciones numres   = " + this.numres);
        System.out.println("   Contingencias modeladas= " + this.numcon);
        System.out.println(" ");
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.VarNode = new int[this.numvar];
        this.vec_clave = new int[this.numres];
        this.vec_xminabs = new double[this.numvar];
        this.vec_xmaxabs = new double[this.numvar];
        this.vec_xmin = new double[this.numvar];
        this.vec_xmax = new double[this.numvar];
        this.vec_xtemp = new double[this.numvar];
        this.vec_xtempabs = new double[this.numvar];
        this.vec_xant = new double[this.numvar];
        this.vec_lam = new double[this.numres];
        this.vec_c = new double[this.numvar];
        this.vec_RHS = new double[this.numres];
        this.vec_OBJ = new double[this.numvar];
        this.DiagMat_Q = new double[this.numvar];
        this.node_p = new double[this.numnod];
        this.MatG = new double[this.numnod][this.numnod];
        this.MatX = new double[this.numnod][this.numnod];
        this.mat_A = new double[this.numres][this.numvar];
        this.mat_W = new double[this.numvar][this.numvar];
        this.MatY = new Complex[this.numnod][this.numnod];
        this.COgen = new double[this.numgen][4];
        this.COload = new double[this.numlast];
        this.Flujo = new double[this.numbran];
        this.NomBra = new String[this.numbran];
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.MatY[i][j] = new Complex();
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            int datomax;
            Complex auxc2;
            Complex auxc1;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.sref / (TempLine.getun1() * TempLine.getun1());
                this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.sref * (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = auxc2.divide(auxc1);
                auxc2 = new Complex(0.0, this.BranchB[count]);
                this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                ++count;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                TempTrafo.sett_re_old(TempTrafo.gett_re());
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 != 10000 && (con2 = this.numbus(TempTrafo.getcon2())) != 10000) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.sref / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.sref / TempTrafo.getsn();
                    b = TempTrafo.geti0() * 0.01 * 0.5 / this.sref * TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.BranchB[count] = b;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (double)TempTrafo.gett_re())));
                    this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(TempTrafo.gett_re() * TempTrafo.gett_re()));
                    this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    ++count;
                    ++count3;
                }
            }
            if (TempComponent instanceof ndb_inj) {
                boolean enconting;
                ndb_inj TempInj = (ndb_inj)TempComponent;
                datomax = 11;
                int datomaxdn = 13;
                Generator TempGen = (Generator)TempComponent;
                if (this.incremental && TempComponent instanceof Generator) {
                    TempGen = (Generator)TempComponent;
                    this.Pmax[count1] = TempGen.getpmax() / this.sref;
                    this.Pmin[count1] = TempGen.getpmin() / this.sref;
                    this.vec_xminabs[count1] = Math.max(TempGen.getpmin() / this.sref, TempGen.getp() / this.sref - TempGen.getgradD() / this.sref * this.nummin);
                    this.vec_xmaxabs[count1] = Math.min(TempGen.getpmax() / this.sref, TempGen.getp() / this.sref + TempGen.getgradU() / this.sref * this.nummin);
                    enconting = false;
                    for (k = 0; k < this.numcon; ++k) {
                        if (TempGen.getName() == this.Conting[k][0]) {
                            enconting = true;
                        }
                        if (enconting) {
                            this.vec_xminabs[count1 + this.numgen * (k + 1)] = 0.0;
                            this.vec_xmaxabs[count1 + this.numgen * (k + 1)] = 0.0;
                        } else {
                            this.vec_xminabs[count1 + this.numgen * (k + 1)] = -(datosSCED.getparameter(datomaxdn, TempComponent.ComponentName) / this.sref);
                            this.vec_xmaxabs[count1 + this.numgen * (k + 1)] = datosSCED.getparameter(datomax, TempComponent.ComponentName) / this.sref;
                        }
                        enconting = false;
                    }
                    this.vec_xminabs[count1 + this.numgen * (this.numcon + 1)] = 0.0;
                    this.vec_xmaxabs[count1 + this.numgen * (this.numcon + 1)] = TempGen.getgradU() / this.sref * this.nummin;
                    this.vec_xminabs[count1 + this.numgen * (this.numcon + 2)] = -TempGen.getgradD() / this.sref * this.nummin;
                    this.vec_xmaxabs[count1 + this.numgen * (this.numcon + 2)] = 0.0;
                } else {
                    TempGen = (Generator)TempComponent;
                    this.Pmax[count1] = TempGen.getpmax() / this.sref;
                    this.Pmin[count1] = TempGen.getpmin() / this.sref;
                    this.vec_xminabs[count1] = TempInj.getpmin() / this.sref;
                    this.vec_xmaxabs[count1] = TempInj.getpmax() / this.sref;
                    enconting = false;
                    for (k = 0; k < this.numcon; ++k) {
                        if (TempGen.getName() == this.Conting[k][0]) {
                            enconting = true;
                        }
                        if (enconting) {
                            this.vec_xminabs[count1 + this.numgen * (k + 1)] = 0.0;
                            this.vec_xmaxabs[count1 + this.numgen * (k + 1)] = 0.0;
                        } else {
                            this.vec_xminabs[count1 + this.numgen * (k + 1)] = -(datosSCED.getparameter(datomaxdn, TempComponent.ComponentName) / this.sref);
                            this.vec_xmaxabs[count1 + this.numgen * (k + 1)] = datosSCED.getparameter(datomax, TempComponent.ComponentName) / this.sref;
                        }
                        enconting = false;
                    }
                    this.vec_xminabs[count1 + this.numgen * (this.numcon + 1)] = 0.0;
                    this.vec_xmaxabs[count1 + this.numgen * (this.numcon + 1)] = TempInj.getpmax() / this.sref - TempInj.getpmin() / this.sref;
                    this.vec_xminabs[count1 + this.numgen * (this.numcon + 2)] = -TempInj.getpmax() / this.sref + TempInj.getpmin() / this.sref;
                    this.vec_xmaxabs[count1 + this.numgen * (this.numcon + 2)] = 0.0;
                }
                this.vec_xminabs[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] = 0.0;
                this.vec_xmaxabs[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] = datosSCED.getparameter(datomax, TempComponent.ComponentName) / this.sref;
                this.vec_xminabs[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] = 0.0;
                this.vec_xmaxabs[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] = datosSCED.getparameter(datomaxdn, TempComponent.ComponentName) / this.sref;
                this.vec_xtempabs[count1] = Math.max(this.vec_xminabs[count1], TempInj.getp() / this.sref);
                ++count1;
            }
            if (TempComponent instanceof Load) {
                TempLoad = (Load)TempComponent;
                for (k = 0; k < this.numcon; ++k) {
                    if (TempLoad.getName() == this.Conting[k][0]) {
                        System.out.println("Carga " + TempLoad.getName() + " con limite 0 en contingencia #" + k);
                        this.vec_xminabs[count2 + this.numgen * (this.numcon + 3) + k * this.numlast] = 0.0;
                        this.vec_xmaxabs[count2 + this.numgen * (this.numcon + 3) + k * this.numlast] = 0.0;
                        continue;
                    }
                    this.vec_xminabs[count2 + this.numgen * (this.numcon + 3) + k * this.numlast] = 0.0;
                    this.vec_xmaxabs[count2 + this.numgen * (this.numcon + 3) + k * this.numlast] = 0.0;
                    if (!this.partDem) continue;
                    this.vec_xminabs[count2 + this.numgen * (this.numcon + 3) + k * this.numlast] = -TempLoad.getp0() / this.sref;
                }
                datomax = 11;
                this.vec_xminabs[count2 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod] = 0.0;
                this.vec_xmaxabs[count2 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod] = 0.0;
                if (this.partDem) {
                    this.vec_xmaxabs[count2 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod] = TempLoad.getp0() / this.sref;
                }
                this.vec_xminabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count2] = 0.0;
                this.vec_xmaxabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count2] = TempLoad.getp0() / this.sref;
                ++count2;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.vec_xminabs[count4 + this.numcon * (this.numgen + this.numlast) + 3 * this.numgen] = 0.0;
            this.vec_xmaxabs[count4 + this.numcon * (this.numgen + this.numlast) + 3 * this.numgen] = 6.0;
            for (i = 0; i < this.numcon; ++i) {
                this.vec_xminabs[count4 + this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (i + 1) * this.numnod] = 0.0;
                this.vec_xmaxabs[count4 + this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (i + 1) * this.numnod] = 6.0;
            }
            this.vec_xminabs[count4 + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod] = 0.0;
            this.vec_xmaxabs[count4 + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod] = 6.0;
            this.vec_xminabs[count4 + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod] = 0.0;
            this.vec_xmaxabs[count4 + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod] = 6.0;
            ++count4;
        }
        for (i = 0; i < this.numcon; ++i) {
            this.vec_xminabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + i] = -5.0;
            this.vec_xmaxabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + i] = 5.0;
        }
        double are = 0.0;
        double aim = 0.0;
        Complex aco = new Complex();
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                if (Complex.abs((Complex)this.MatY[i][j]) > 1.0E-6 && i != j) {
                    aco = new Complex(1.0, 0.0);
                    aco = Complex.negate((Complex)Complex.divide((Complex)aco, (Complex)this.MatY[i][j]));
                    are = aco.re;
                    aim = aco.im;
                    this.MatG[i][j] = are / (are * are + aim * aim);
                    this.MatX[i][j] = aim;
                    continue;
                }
                this.MatG[i][j] = 0.0;
                this.MatX[i][j] = 0.0;
            }
        }
    }

    public static void printMatrix(PrintStream myPrintStream, Complex[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(PrintStream myPrintStream, double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t ");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix(double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                System.out.print(Math.rint(m[i][j] * 100.0) / 100.0 + "\t ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(PrintStream myPrintStream, Complex[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(PrintStream myPrintStream, double[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVector(int[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i] + "\t");
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(String[][] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i][0] + "\t" + v[i][1]);
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector3(String[][] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i][0] + "\t" + v[i][1] + "\t" + v[i][2]);
            System.out.println();
        }
        System.out.println();
    }

    public static void printVector(double[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            System.out.print(i + "\t" + v[i] + "\t");
            System.out.println();
        }
        System.out.println();
    }

    public void update_vec_xlimits() {
        for (int i = 0; i < this.numvar; ++i) {
            this.vec_xmin[i] = this.vec_xminabs[i] - this.vec_xtempabs[i];
            this.vec_xmax[i] = this.vec_xmaxabs[i] - this.vec_xtempabs[i];
        }
    }

    public void make_vec_c() {
        int i = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        int dato1 = 1;
        int dato2 = 2;
        int dato3 = 3;
        int dato7 = 7;
        int dato8 = 8;
        int dato14 = 14;
        SCEDDatos datosSCED = new SCEDDatos();
        datosSCED.loaddatafromfile();
        for (i = 0; i < this.numvar; ++i) {
            this.vec_c[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                this.vec_c[count] = TempInj.getbeta() * this.sref;
                if (!this.centralized) {
                    this.vec_c[count + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] = datosSCED.getparameter(dato1, TempComponent.ComponentName) * this.sref;
                    this.vec_c[count + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] = datosSCED.getparameter(dato2, TempComponent.ComponentName) * this.sref;
                    this.vec_c[count + this.numgen * (this.numcon + 1)] = datosSCED.getparameter(dato7, TempComponent.ComponentName) * this.sref;
                    this.vec_c[count + this.numgen * (this.numcon + 2)] = datosSCED.getparameter(dato8, TempComponent.ComponentName) * this.sref;
                }
                this.VarNode[count] = this.numbus(TempInj.getcon2());
                ++count;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.vec_c[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod] = !this.centralized ? TempLoad.getbeta() * this.sref : 0.0;
            this.VarNode[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod] = this.numbus(TempLoad.getcon2());
            int n = this.VarNode[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod];
            this.node_p[n] = this.node_p[n] - TempLoad.getp0() / this.sref;
            this.vec_c[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count1] = TempLoad.getbeta() * this.sref;
            if (this.centralized) {
                for (int k = 0; k < this.numcon; ++k) {
                    this.vec_c[count1 + this.numgen * (this.numcon + 3) + k * this.numlast] = -datosSCED.getparameter(dato14, this.Conting[k][0]) * this.sref * TempLoad.getbeta();
                }
            }
            ++count1;
        }
    }

    public void make_mat_Afix() {
        int i = 0;
        boolean j = false;
        int k = 0;
        int count = 0;
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.VarNode[i]][i] = 1.0;
        }
        for (i = 0; i < this.numlast; ++i) {
            this.mat_A[Integer.parseInt((String)this.LoadName[i][1])][this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i] = 1.0;
        }
        for (k = 0; k < this.numcon; ++k) {
            if (this.Conting[k][1].equals("Generador")) {
                for (i = 0; i < this.numgen; ++i) {
                    if (this.GenName[i][0] != this.Conting[k][0]) {
                        this.mat_A[this.numnod * (k + 1) + this.VarNode[i]][i] = 1.0;
                        this.mat_A[this.numnod * (k + 1) + this.VarNode[i]][i + this.numgen * (k + 1)] = 1.0;
                        continue;
                    }
                    System.out.println("  -  " + this.GenName[i][0] + " no agregado a Matriz A, pues esta asociado a contingencia " + k);
                }
                for (i = 0; i < this.numlast; ++i) {
                    this.mat_A[this.numnod * (k + 1) + Integer.parseInt((String)this.LoadName[i][1])][i + this.numgen * (this.numcon + 3) + this.numlast * k] = -1.0;
                    this.mat_A[this.numnod * (k + 1) + Integer.parseInt((String)this.LoadName[i][1])][i + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon] = 1.0;
                }
            }
            if (this.Conting[k][1].equals("Consumo")) {
                for (i = 0; i < this.numgen; ++i) {
                    this.mat_A[this.numnod * (k + 1) + this.VarNode[i]][i] = 1.0;
                    this.mat_A[this.numnod * (k + 1) + this.VarNode[i]][i + this.numgen * (k + 1)] = 1.0;
                }
                for (i = 0; i < this.numlast; ++i) {
                    if (this.LoadName[i][0] != this.Conting[k][0]) {
                        this.mat_A[this.numnod * (k + 1) + Integer.parseInt((String)this.LoadName[i][1])][i + this.numgen * (this.numcon + 3) + this.numlast * k] = -1.0;
                        this.mat_A[this.numnod * (k + 1) + Integer.parseInt((String)this.LoadName[i][1])][i + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon] = 1.0;
                        continue;
                    }
                    System.out.println("  -  " + this.LoadName[i][0] + " no agregado a Matriz A, pues esta asociado a contingencia " + k);
                }
            }
            if (!this.Conting[k][1].equals("Rama")) continue;
            for (i = 0; i < this.numgen; ++i) {
                this.mat_A[this.numnod * (k + 1) + this.VarNode[i]][i] = 1.0;
                this.mat_A[this.numnod * (k + 1) + this.VarNode[i]][i + this.numgen * (k + 1)] = 1.0;
            }
            for (i = 0; i < this.numlast; ++i) {
                this.mat_A[this.numnod * (k + 1) + Integer.parseInt((String)this.LoadName[i][1])][i + this.numgen * (this.numcon + 3) + this.numlast * k] = -1.0;
                this.mat_A[this.numnod * (k + 1) + Integer.parseInt((String)this.LoadName[i][1])][i + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon] = 1.0;
            }
        }
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.VarNode[i] + this.numnod * (this.numcon + 1)][i] = 1.0;
            this.mat_A[this.VarNode[i] + this.numnod * (this.numcon + 1)][i + this.numgen * (this.numcon + 1)] = 1.0;
            this.mat_A[this.VarNode[i] + this.numnod * (this.numcon + 2)][i] = 1.0;
            this.mat_A[this.VarNode[i] + this.numnod * (this.numcon + 2)][i + this.numgen * (this.numcon + 2)] = 1.0;
        }
        for (i = 0; i < this.numlast; ++i) {
            this.mat_A[Integer.parseInt((String)this.LoadName[i][1]) + this.numnod * (this.numcon + 1)][this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i] = 1.0;
            this.mat_A[Integer.parseInt((String)this.LoadName[i][1]) + this.numnod * (this.numcon + 2)][this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i] = 1.0;
        }
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.numnod * (this.numcon + 3)][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod + i] = 1.0;
        }
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.numnod * (this.numcon + 3) + 1][this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod + i] = 1.0;
        }
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.numnod * (this.numcon + 3) + 2][this.numgen * (this.numcon + 1) + i] = 0.0;
        }
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[this.numnod * (this.numcon + 3) + 3][this.numgen * (this.numcon + 2) + i] = 0.0;
        }
        if (this.linres) {
            Trafo TempTrafo;
            double xij;
            Complex yij;
            Line TempLine;
            ndb_branch Tempbran;
            comp TempComponent;
            int ix = 0;
            count = 0;
            int con1 = 10000;
            int con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Complex auxc2;
                Complex auxc1;
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    if (Math.abs(xij) > 1.0E-7) {
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] = -1.0 / xij;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] = 1.0 / xij;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] = -1.0 / xij;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] = 1.0 / xij;
                    } else {
                        System.out.println("ERROR: Too low reactance");
                    }
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                if (Math.abs(xij) > 1.0E-7) {
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] = -1.0 / xij;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] = 1.0 / xij;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] = -1.0 / xij;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] = 1.0 / xij;
                } else {
                    System.out.println("ERROR: Too low reactance");
                }
                ++count;
            }
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            for (k = 0; k < this.numcon; ++k) {
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    Complex auxc2;
                    Complex auxc1;
                    TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                    Tempbran = (ndb_branch)TempComponent;
                    if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                        auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        yij = new Complex(0.0, 0.0);
                        yij.add(auxc1);
                        xij = this.BranchX[count];
                        if (Math.abs(xij) > 1.0E-7) {
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con1] = -1.0 / xij;
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con2] = 1.0 / xij;
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con1] = -1.0 / xij;
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con2] = 1.0 / xij;
                        } else {
                            System.out.println("ERROR: Too low reactance");
                        }
                        ++count;
                    }
                    if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    if (Math.abs(xij) > 1.0E-7) {
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con1] = -1.0 / xij;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con2] = 1.0 / xij;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con1] = -1.0 / xij;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con2] = 1.0 / xij;
                    } else {
                        System.out.println("ERROR: Too low reactance");
                    }
                    ++count;
                }
                count = 0;
                con1 = 10000;
                con2 = 10000;
                int conex1 = 0;
                int conex2 = 0;
                if (this.Conting[k][1] == "Rama") {
                    for (ix = 0; ix < this.numbran; ++ix) {
                        if (this.Conting[k][0] != this.BranName[ix][0]) continue;
                        con1 = Integer.parseInt(this.BranName[ix][1]);
                        con2 = Integer.parseInt(this.BranName[ix][2]);
                    }
                    for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                        TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                        if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                        conex1 = this.numbus(TempComponent.getcon1());
                        conex2 = this.numbus(TempComponent.getcon2());
                        if ((conex1 == con1 && conex2 == con2 || conex2 == con1 && conex1 == con2) && TempComponent.getName() == this.Conting[k][0]) {
                            System.out.println("  -  " + this.BranName[count][0] + " eliminada de Matriz A, pues esta asociado a contingencia " + k + ". Indices (i,j) = (" + con1 + "," + con2 + ")");
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con1] = 0.0;
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con2] = 0.0;
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con1] = 0.0;
                            this.mat_A[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count][this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + (k + 1) * this.numnod + con2] = 0.0;
                        }
                        ++count;
                    }
                }
                count = 0;
                con1 = 10000;
                con2 = 10000;
            }
            for (k = 0; k < this.numcon; ++k) {
                for (i = 0; i < this.numgen; ++i) {
                    if (this.Conting[k][0] != this.GenName[i][0]) {
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + k * this.numgen + i][i] = 1.0;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + k * this.numgen + i][i + this.numgen * (k + 1)] = 1.0;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + (k + this.numcon) * this.numgen + i][i] = -1.0;
                        this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + (k + this.numcon) * this.numgen + i][i + this.numgen * (k + 1)] = -1.0;
                        continue;
                    }
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + k * this.numgen + i][i] = 0.0;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + k * this.numgen + i][i + this.numgen * (k + 1)] = 0.0;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + (k + this.numcon) * this.numgen + i][i] = 0.0;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + (k + this.numcon) * this.numgen + i][i + this.numgen * (k + 1)] = 0.0;
                }
            }
            for (k = 0; k < this.numcon; ++k) {
                for (i = 0; i < this.numlast; ++i) {
                }
            }
            for (i = 0; i < this.numgen; ++i) {
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + i][i] = 1.0;
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + i][i + this.numgen * (this.numcon + 1)] = 1.0;
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + this.numgen + i][i] = -1.0;
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + this.numgen + i][i + this.numgen * (this.numcon + 1)] = -1.0;
            }
            for (i = 0; i < this.numgen; ++i) {
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 2 * this.numgen + i][i] = 1.0;
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 2 * this.numgen + i][i + this.numgen * (this.numcon + 2)] = 1.0;
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + i][i] = -1.0;
                this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + i][i + this.numgen * (this.numcon + 2)] = -1.0;
            }
            for (i = 0; i < this.numgen; ++i) {
                for (k = 0; k < this.numcon; ++k) {
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + i * this.numcon + k][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod + i] = 1.0;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + i * this.numcon + k][this.numgen * (k + 1) + i] = -1.0;
                }
            }
            for (i = 0; i < this.numgen; ++i) {
                for (k = 0; k < this.numcon; ++k) {
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numgen * this.numcon + i * this.numcon + k][this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod + i] = 1.0;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numgen * this.numcon + i * this.numcon + k][this.numgen * (k + 1) + i] = 1.0;
                }
            }
            for (k = 0; k < this.numcon; ++k) {
                SCEDDatos datosSCED = new SCEDDatos();
                datosSCED.loaddatafromfile();
                int probab = 14;
                for (i = 0; i < this.numlast; ++i) {
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + 2 * this.numgen * this.numcon + i][this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + i] = 1.0;
                    this.mat_A[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + 2 * this.numgen * this.numcon + i][i + this.numgen * (3 + this.numcon) + this.numlast * k] = datosSCED.getparameter(probab, this.Conting[k][0]);
                }
            }
            if (this.linres) {
                ix = 0;
                count = 0;
                con1 = 10000;
                con2 = 10000;
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    Complex auxc2;
                    Complex auxc1;
                    TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                    Tempbran = (ndb_branch)TempComponent;
                    if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                        auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        yij = new Complex(0.0, 0.0);
                        yij.add(auxc1);
                        xij = this.BranchX[count];
                        if (Math.abs(xij) > 1.0E-7) {
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con1] = -1.0 / xij;
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con2] = 1.0 / xij;
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con1] = -1.0 / xij;
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con2] = 1.0 / xij;
                        } else {
                            System.out.println("ERROR: Too low reactance");
                        }
                        ++count;
                    }
                    if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    if (Math.abs(xij) > 1.0E-7) {
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con1] = -1.0 / xij;
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con2] = 1.0 / xij;
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con1] = -1.0 / xij;
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con2] = 1.0 / xij;
                    } else {
                        System.out.println("ERROR: Too low reactance");
                    }
                    ++count;
                }
                ix = 0;
                count = 0;
                con1 = 10000;
                con2 = 10000;
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    Complex auxc2;
                    Complex auxc1;
                    TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                    Tempbran = (ndb_branch)TempComponent;
                    if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                        auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        yij = new Complex(0.0, 0.0);
                        yij.add(auxc1);
                        xij = this.BranchX[count];
                        if (Math.abs(xij) > 1.0E-7) {
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod + con1] = -1.0 / xij;
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod + con2] = 1.0 / xij;
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod + con1] = -1.0 / xij;
                            this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod + con2] = 1.0 / xij;
                        } else {
                            System.out.println("ERROR: Too low reactance");
                        }
                        ++count;
                    }
                    if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    if (Math.abs(xij) > 1.0E-7) {
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con1] = -1.0 / xij;
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + this.numnod + con2] = 1.0 / xij;
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod + con1] = -1.0 / xij;
                        this.mat_A[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + this.numbran + count][this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 2 * this.numnod + con2] = 1.0 / xij;
                    } else {
                        System.out.println("ERROR: Too low reactance");
                    }
                    ++count;
                }
            }
            this.myPPrintStream.println("Matriz de Coeficientes Fijos");
            SCED.printMatrix(this.myPPrintStream, this.mat_A, this.numres, this.numvar);
        }
        int auxi = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran;
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[auxi + i][i] = 1.0;
            this.mat_A[auxi + i][i + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] = 1.0;
            this.mat_A[auxi + this.numgen + i][i] = -1.0;
            this.mat_A[auxi + this.numgen + i][i + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] = 1.0;
        }
        auxi = (this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 6 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran;
        for (i = 0; i < this.numgen; ++i) {
            this.mat_A[auxi + i][i] = 1.0;
            this.mat_A[auxi + i][i + this.numgen * (this.numcon + 1)] = 1.0;
            this.mat_A[auxi + i][i + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] = 1.0;
            this.mat_A[auxi + this.numgen + i][i] = 1.0;
            this.mat_A[auxi + this.numgen + i][i + this.numgen * (this.numcon + 2)] = -1.0;
            this.mat_A[auxi + this.numgen + i][i + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] = -1.0;
        }
    }

    public void make_mat_W() {
        int k;
        int j;
        int i;
        int nn = this.numnod;
        int off = this.numcon * (this.numgen + this.numlast) + 3 * this.numgen;
        for (i = 0; i < this.numvar; ++i) {
            for (j = 0; j < this.numvar; ++j) {
                this.mat_W[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numvar; ++i) {
            this.mat_W[i][i] = this.DiagMat_Q[i];
        }
        System.out.println("   - Flujos en Precontingencia");
        for (k = 0; k < nn; ++k) {
            for (j = 0; j < nn; ++j) {
                if (k == j || !(Math.abs(this.MatG[k][j]) > 0.0)) continue;
                double[] dArray = this.mat_W[k + off];
                int n = k + off;
                dArray[n] = dArray[n] + this.vec_lam[k] * this.MatG[k][j];
                double[] dArray2 = this.mat_W[j + off];
                int n2 = j + off;
                dArray2[n2] = dArray2[n2] + this.vec_lam[k] * this.MatG[k][j];
                double[] dArray3 = this.mat_W[k + off];
                int n3 = j + off;
                dArray3[n3] = dArray3[n3] - this.vec_lam[k] * this.MatG[k][j];
                double[] dArray4 = this.mat_W[j + off];
                int n4 = k + off;
                dArray4[n4] = dArray4[n4] - this.vec_lam[k] * this.MatG[k][j];
            }
        }
        System.out.println("   - Flujos en Postcontingencia");
        boolean contador = false;
        int con1 = 10000;
        int con2 = 10000;
        if (this.cuadLossModel) {
            for (int count = 0; count < this.numcon; ++count) {
                if (this.Conting[count][1] == "Rama") {
                    for (int ix = 0; ix < this.numbran; ++ix) {
                        if (this.Conting[count][0] != this.BranName[ix][0]) continue;
                        con1 = Integer.parseInt(this.BranName[ix][1]);
                        con2 = Integer.parseInt(this.BranName[ix][2]);
                    }
                } else {
                    con1 = 10000;
                    con2 = 10000;
                }
                for (i = 0; i < nn; ++i) {
                    for (j = 0; j < nn; ++j) {
                        if (i == j) {
                            for (k = 0; k < nn; ++k) {
                                if (Math.abs(this.MatG[i][k]) < 1.0E-6 || i == con1 && k == con2 || k == con1 && i == con2) continue;
                                double[] dArray = this.mat_W[i + (count + 1) * this.numnod + off];
                                int n = i + (count + 1) * this.numnod + off;
                                dArray[n] = dArray[n] - this.MatG[i][k] * (this.vec_lam[i + (count + 1) * this.numnod] + this.vec_lam[k + (count + 1) * this.numnod]);
                            }
                        }
                        if (i == j || Math.abs(this.MatG[i][j]) < 1.0E-6 || i == con1 && j == con2 || j == con1 && i == con2) continue;
                        this.mat_W[i + (count + 1) * this.numnod + off][j + (count + 1) * this.numnod + off] = this.MatG[i][j] * (this.vec_lam[i + (count + 1) * this.numnod] + this.vec_lam[j + (count + 1) * this.numnod]);
                    }
                }
            }
        }
        System.out.println("   - Flujos en Regulacion secundaria de subida");
        for (k = 0; k < nn; ++k) {
            for (j = 0; j < nn; ++j) {
                if (k == j || !(Math.abs(this.MatG[k][j]) > 0.0)) continue;
                double[] dArray = this.mat_W[k + (this.numcon + 1) * this.numnod + off];
                int n = k + (this.numcon + 1) * this.numnod + off;
                dArray[n] = dArray[n] + this.vec_lam[k + (this.numcon + 1) * this.numnod] * this.MatG[k][j];
                double[] dArray5 = this.mat_W[j + (this.numcon + 1) * this.numnod + off];
                int n5 = j + (this.numcon + 1) * this.numnod + off;
                dArray5[n5] = dArray5[n5] + this.vec_lam[k + (this.numcon + 1) * this.numnod] * this.MatG[k][j];
                double[] dArray6 = this.mat_W[k + (this.numcon + 1) * this.numnod + off];
                int n6 = j + (this.numcon + 1) * this.numnod + off;
                dArray6[n6] = dArray6[n6] - this.vec_lam[k + (this.numcon + 1) * this.numnod] * this.MatG[k][j];
                double[] dArray7 = this.mat_W[j + (this.numcon + 1) * this.numnod + off];
                int n7 = k + (this.numcon + 1) * this.numnod + off;
                dArray7[n7] = dArray7[n7] - this.vec_lam[k + (this.numcon + 1) * this.numnod] * this.MatG[k][j];
            }
        }
        System.out.println("   - Flujos en Regulacion secundaria de bajada");
        for (k = 0; k < nn; ++k) {
            for (j = 0; j < nn; ++j) {
                if (k == j || !(Math.abs(this.MatG[k][j]) > 0.0)) continue;
                double[] dArray = this.mat_W[k + (this.numcon + 2) * this.numnod + off];
                int n = k + (this.numcon + 2) * this.numnod + off;
                dArray[n] = dArray[n] + this.vec_lam[k + (this.numcon + 2) * this.numnod] * this.MatG[k][j];
                double[] dArray8 = this.mat_W[j + (this.numcon + 2) * this.numnod + off];
                int n8 = j + (this.numcon + 2) * this.numnod + off;
                dArray8[n8] = dArray8[n8] + this.vec_lam[k + (this.numcon + 2) * this.numnod] * this.MatG[k][j];
                double[] dArray9 = this.mat_W[k + (this.numcon + 2) * this.numnod + off];
                int n9 = j + (this.numcon + 2) * this.numnod + off;
                dArray9[n9] = dArray9[n9] - this.vec_lam[k + (this.numcon + 2) * this.numnod] * this.MatG[k][j];
                double[] dArray10 = this.mat_W[j + (this.numcon + 2) * this.numnod + off];
                int n10 = k + (this.numcon + 2) * this.numnod + off;
                dArray10[n10] = dArray10[n10] - this.vec_lam[k + (this.numcon + 2) * this.numnod] * this.MatG[k][j];
            }
        }
    }

    public void make_DiagMat_Q() {
        int i = 0;
        int ix = 0;
        int count = 0;
        int count1 = 0;
        int dato4 = 4;
        int dato5 = 5;
        int dato9 = 9;
        int dato10 = 10;
        SCEDDatos datosSCED = new SCEDDatos();
        datosSCED.loaddatafromfile();
        for (i = 0; i < this.numvar; ++i) {
            this.DiagMat_Q[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                this.DiagMat_Q[count] = 2.0 * TempInj.getgamma() * this.sref * this.sref;
                if (!this.centralized) {
                    this.DiagMat_Q[count + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] = 2.0 * datosSCED.getparameter(dato4, TempComponent.ComponentName) * this.sref * this.sref;
                    this.DiagMat_Q[count + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] = 2.0 * datosSCED.getparameter(dato5, TempComponent.ComponentName) * this.sref * this.sref;
                    this.DiagMat_Q[count + this.numgen * (this.numcon + 1)] = 2.0 * datosSCED.getparameter(dato9, TempComponent.ComponentName) * this.sref * this.sref;
                    this.DiagMat_Q[count + this.numgen * (this.numcon + 2)] = 2.0 * datosSCED.getparameter(dato10, TempComponent.ComponentName) * this.sref * this.sref;
                }
                ++count;
            }
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            this.DiagMat_Q[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod] = 2.0 * TempLoad.getgamma() * this.sref * this.sref;
            this.DiagMat_Q[count1 + this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon] = 2.0 * TempLoad.getgamma() * this.sref * this.sref;
            ++count1;
        }
    }

    public void startPoint() {
        int i = 0;
        int ix = 0;
        int count = 0;
        for (i = 0; i < this.numvar; ++i) {
            this.vec_xtempabs[i] = 0.0;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            this.vec_xtempabs[count] = TempInj.getp0() / this.sref;
            ++count;
        }
    }

    public double make_cost() {
        double cost = 0.0;
        for (int i = 0; i < this.numvar; ++i) {
            cost += this.vec_xtempabs[i] * (this.vec_c[i] + this.DiagMat_Q[i] / 2.0 * this.vec_xtempabs[i]);
        }
        return cost;
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void make_vec_OBJ() {
        int i = 0;
        boolean ix = false;
        boolean count = false;
        for (i = 0; i < this.numvar; ++i) {
            this.vec_OBJ[i] = this.vec_c[i] + this.DiagMat_Q[i] * this.vec_xtempabs[i];
        }
    }

    public void make_mat_A() {
        int k;
        int col;
        int row;
        int count = 0;
        boolean count1 = false;
        int off = this.numcon * (this.numgen + this.numlast) + 3 * this.numgen;
        for (row = 0; row < this.numnod; ++row) {
            for (col = off; col < off + this.numnod; ++col) {
                this.mat_A[row][col] = 0.0;
            }
        }
        for (k = 0; k < this.numcon; ++k) {
            for (row = this.numnod + k * this.numnod; row < this.numnod + (k + 1) * this.numnod; ++row) {
                for (col = off + this.numnod + k * this.numnod; col < off + this.numnod + (k + 1) * this.numnod; ++col) {
                    this.mat_A[row][col] = 0.0;
                }
            }
        }
        for (row = this.numnod * (this.numcon + 1); row < this.numnod * (this.numcon + 2); ++row) {
            for (col = off + this.numnod * (this.numcon + 1); col < off + this.numnod * (this.numcon + 2); ++col) {
                this.mat_A[row][col] = 0.0;
            }
        }
        for (row = this.numnod * (this.numcon + 2); row < this.numnod * (this.numcon + 3); ++row) {
            for (col = off + this.numnod * (this.numcon + 2); col < off + this.numnod * (this.numcon + 3); ++col) {
                this.mat_A[row][col] = 0.0;
            }
        }
        if (this.cuadLossModel) {
            int v;
            int i;
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numnod; ++k) {
                    if (i == k) {
                        for (v = 0; v < this.numnod; ++v) {
                            if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-6)) continue;
                            double[] dArray = this.mat_A[i];
                            int n = off + k;
                            dArray[n] = dArray[n] - (this.MatG[k][v] * (this.vec_xtempabs[off + k] - this.vec_xtempabs[off + v]) + 1.0 / this.MatX[k][v]);
                        }
                        continue;
                    }
                    if (!(Math.abs(this.MatX[i][k]) > 1.0E-6)) continue;
                    this.mat_A[i][off + k] = this.MatG[i][k] * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + k]) + 1.0 / this.MatX[i][k];
                }
            }
            count = 0;
            int con1 = 10000;
            int con2 = 10000;
            for (k = 0; k < this.numcon; ++k) {
                if (this.Conting[k][1] == "Rama") {
                    for (int ix = 0; ix < this.numbran; ++ix) {
                        if (this.Conting[k][0] != this.BranName[ix][0]) continue;
                        con1 = Integer.parseInt(this.BranName[ix][1]);
                        con2 = Integer.parseInt(this.BranName[ix][2]);
                    }
                } else {
                    con1 = 100000;
                    con2 = 100000;
                }
                for (i = 0; i < this.numnod; ++i) {
                    for (int j = 0; j < this.numnod; ++j) {
                        double rr;
                        double xx;
                        Line TempLinex;
                        comp TempComponentx;
                        int ixx;
                        if (i == j) {
                            for (v = 0; v < this.numnod; ++v) {
                                if (j == v || !(Math.abs(this.MatX[j][v]) > 1.0E-6)) continue;
                                if ((j == con1 && v == con2 || v == con1 && j == con2) && this.Conting[k][1] == "Rama") {
                                    for (ixx = 0; ixx < this.ActSchematic.Components.size(); ++ixx) {
                                        TempComponentx = (comp)this.ActSchematic.Components.elementAt(ixx);
                                        if (!TempComponentx.getactive() || !TempComponentx.getvalid() || !TempComponentx.getinservice() || !(TempComponentx instanceof ndb_branch) || !(TempComponentx instanceof Line) || TempComponentx.getName() == this.Conting[k][0] || (this.numbus((TempLinex = (Line)TempComponentx).getcon1()) != con1 || this.numbus(TempLinex.getcon2()) != con2) && (this.numbus(TempLinex.getcon2()) != con1 || this.numbus(TempLinex.getcon1()) != con2)) continue;
                                        xx = TempLinex.getxx1() * TempLinex.getlen() * this.sref / (TempLinex.getun1() * TempLinex.getun1());
                                        rr = TempLinex.getr1() * TempLinex.getlen() * this.sref / (TempLinex.getun1() * TempLinex.getun1());
                                        double[] dArray = this.mat_A[this.numnod * (k + 1) + i];
                                        int n = off + this.numnod * (k + 1) + j;
                                        dArray[n] = dArray[n] - (rr / (rr * rr + xx * xx) * (this.vec_xtempabs[off + this.numnod * (k + 1) + j] - this.vec_xtempabs[off + this.numnod * (k + 1) + v]) + 1.0 / xx);
                                    }
                                    continue;
                                }
                                double[] dArray = this.mat_A[this.numnod * (k + 1) + i];
                                int n = off + this.numnod * (k + 1) + j;
                                dArray[n] = dArray[n] - (this.MatG[j][v] * (this.vec_xtempabs[off + this.numnod * (k + 1) + j] - this.vec_xtempabs[off + this.numnod * (k + 1) + v]) + 1.0 / this.MatX[j][v]);
                            }
                            continue;
                        }
                        if (!(Math.abs(this.MatX[i][j]) > 1.0E-6)) continue;
                        if ((j == con1 && i == con2 || i == con1 && j == con2) && this.Conting[k][1] == "Rama") {
                            for (ixx = 0; ixx < this.ActSchematic.Components.size(); ++ixx) {
                                TempComponentx = (comp)this.ActSchematic.Components.elementAt(ixx);
                                if (!TempComponentx.getactive() || !TempComponentx.getvalid() || !TempComponentx.getinservice() || !(TempComponentx instanceof ndb_branch) || !(TempComponentx instanceof Line) || TempComponentx.getName() == this.Conting[k][0] || (this.numbus((TempLinex = (Line)TempComponentx).getcon1()) != con1 || this.numbus(TempLinex.getcon2()) != con2) && (this.numbus(TempLinex.getcon2()) != con1 || this.numbus(TempLinex.getcon1()) != con2)) continue;
                                xx = TempLinex.getxx1() * TempLinex.getlen() * this.sref / (TempLinex.getun1() * TempLinex.getun1());
                                rr = TempLinex.getr1() * TempLinex.getlen() * this.sref / (TempLinex.getun1() * TempLinex.getun1());
                                double[] dArray = this.mat_A[this.numnod * (k + 1) + i];
                                int n = off + this.numnod * (k + 1) + j;
                                dArray[n] = dArray[n] + (rr / (rr * rr + xx * xx) * (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) + 1.0 / xx);
                            }
                            continue;
                        }
                        this.mat_A[this.numnod * (k + 1) + i][off + this.numnod * (k + 1) + j] = this.MatG[i][j] * (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) + 1.0 / this.MatX[i][j];
                    }
                }
                if (this.Conting[k][1] != "Rama") continue;
                ++count;
            }
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numnod; ++k) {
                    if (i == k) {
                        for (v = 0; v < this.numnod; ++v) {
                            if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-6)) continue;
                            double[] dArray = this.mat_A[this.numnod * (this.numcon + 1) + i];
                            int n = off + this.numnod * (this.numcon + 1) + k;
                            dArray[n] = dArray[n] - (this.MatG[k][v] * (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + k] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + v]) + 1.0 / this.MatX[k][v]);
                        }
                        continue;
                    }
                    if (!(Math.abs(this.MatX[i][k]) > 1.0E-6)) continue;
                    this.mat_A[this.numnod * (this.numcon + 1) + i][off + this.numnod * (this.numcon + 1) + k] = this.MatG[i][k] * (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + k]) + 1.0 / this.MatX[i][k];
                }
            }
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numnod; ++k) {
                    if (i == k) {
                        for (v = 0; v < this.numnod; ++v) {
                            if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-6)) continue;
                            double[] dArray = this.mat_A[this.numnod * (this.numcon + 2) + i];
                            int n = off + this.numnod * (this.numcon + 2) + k;
                            dArray[n] = dArray[n] - (this.MatG[k][v] * (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + k] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + v]) + 1.0 / this.MatX[k][v]);
                        }
                        continue;
                    }
                    if (!(Math.abs(this.MatX[i][k]) > 1.0E-6)) continue;
                    this.mat_A[this.numnod * (this.numcon + 2) + i][off + this.numnod * (this.numcon + 2) + k] = this.MatG[i][k] * (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + k]) + 1.0 / this.MatX[i][k];
                }
            }
        } else {
            int v;
            int i;
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numnod; ++k) {
                    if (i == k) {
                        for (v = 0; v < this.numnod; ++v) {
                            if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-6)) continue;
                            double[] dArray = this.mat_A[i];
                            int n = off + k;
                            dArray[n] = dArray[n] - (this.MatG[k][v] * Math.sin(this.vec_xtempabs[off + k] - this.vec_xtempabs[off + v]) + 1.0 / this.MatX[k][v]);
                        }
                        continue;
                    }
                    if (!(Math.abs(this.MatX[i][k]) > 1.0E-6)) continue;
                    this.mat_A[i][off + k] = this.MatG[i][k] * Math.sin(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + k]) + 1.0 / this.MatX[i][k];
                }
            }
            count = 0;
            int con1 = 10000;
            int con2 = 10000;
            for (k = 0; k < this.numcon; ++k) {
                if (this.Conting[k][1] == "Rama") {
                    for (int ix = 0; ix < this.numbran; ++ix) {
                        if (this.Conting[k][0] != this.BranName[ix][0]) continue;
                        con1 = Integer.parseInt(this.BranName[ix][1]);
                        con2 = Integer.parseInt(this.BranName[ix][2]);
                    }
                } else {
                    con1 = 100000;
                    con2 = 100000;
                }
                System.out.println("(con1,con2)=(" + con1 + "," + con2 + ")");
                for (i = 0; i < this.numnod; ++i) {
                    for (int j = 0; j < this.numnod; ++j) {
                        if (i == j) {
                            for (v = 0; v < this.numnod; ++v) {
                                if (j == v || !(Math.abs(this.MatX[j][v]) > 1.0E-6) || (j == con1 && v == con2 || v == con1 && j == con2) && this.Conting[k][1] == "Rama") continue;
                                double[] dArray = this.mat_A[this.numnod * (k + 1) + i];
                                int n = off + this.numnod * (k + 1) + j;
                                dArray[n] = dArray[n] - (this.MatG[j][v] * Math.sin(this.vec_xtempabs[off + this.numnod * (k + 1) + j] - this.vec_xtempabs[off + this.numnod * (k + 1) + v]) + 1.0 / this.MatX[j][v]);
                            }
                            continue;
                        }
                        if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || (j == con1 && i == con2 || i == con1 && j == con2) && this.Conting[k][1] == "Rama") continue;
                        this.mat_A[this.numnod * (k + 1) + i][off + this.numnod * (k + 1) + j] = this.MatG[i][j] * Math.sin(this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) + 1.0 / this.MatX[i][j];
                    }
                }
                if (this.Conting[k][1] != "Rama") continue;
                ++count;
            }
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numnod; ++k) {
                    if (i == k) {
                        for (v = 0; v < this.numnod; ++v) {
                            if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-6)) continue;
                            double[] dArray = this.mat_A[this.numnod * (this.numcon + 1) + i];
                            int n = off + this.numnod * (this.numcon + 1) + k;
                            dArray[n] = dArray[n] - (this.MatG[k][v] * Math.sin(this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + k] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + v]) + 1.0 / this.MatX[k][v]);
                        }
                        continue;
                    }
                    if (!(Math.abs(this.MatX[i][k]) > 1.0E-6)) continue;
                    this.mat_A[this.numnod * (this.numcon + 1) + i][off + this.numnod * (this.numcon + 1) + k] = this.MatG[i][k] * Math.sin(this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + k]) + 1.0 / this.MatX[i][k];
                }
            }
            for (i = 0; i < this.numnod; ++i) {
                for (k = 0; k < this.numnod; ++k) {
                    if (i == k) {
                        for (v = 0; v < this.numnod; ++v) {
                            if (k == v || !(Math.abs(this.MatX[k][v]) > 1.0E-6)) continue;
                            double[] dArray = this.mat_A[this.numnod * (this.numcon + 2) + i];
                            int n = off + this.numnod * (this.numcon + 2) + k;
                            dArray[n] = dArray[n] - (this.MatG[k][v] * Math.sin(this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + k] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + v]) + 1.0 / this.MatX[k][v]);
                        }
                        continue;
                    }
                    if (!(Math.abs(this.MatX[i][k]) > 1.0E-6)) continue;
                    this.mat_A[this.numnod * (this.numcon + 2) + i][off + this.numnod * (this.numcon + 2) + k] = this.MatG[i][k] * Math.sin(this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + k]) + 1.0 / this.MatX[i][k];
                }
            }
        }
    }

    public void make_vec_RHS() throws IOException {
        Trafo TempTrafo;
        double xij;
        Line TempLine;
        ndb_branch Tempbran;
        comp TempComponent;
        int ix;
        int i = 0;
        int j = 0;
        int k = 0;
        boolean v = false;
        int con1 = 0;
        int con2 = 0;
        int count = 0;
        boolean count1 = false;
        double tempa = 0.0;
        int off = this.numcon * (this.numgen + this.numlast) + 3 * this.numgen;
        for (i = 0; i < this.numres; ++i) {
            this.vec_RHS[i] = 0.0;
        }
        for (i = 0; i < this.numnod; ++i) {
            this.vec_RHS[i] = -this.node_p[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i];
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
        }
        for (i = 0; i < this.numlast; ++i) {
            int n = Integer.parseInt(this.LoadName[i][1]);
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i];
        }
        if (this.cuadLossModel) {
            i = 0;
            while (i < this.numnod) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    tempa += this.MatG[i][j] / 2.0 * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) * (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) + (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) / this.MatX[i][j];
                }
                int n = i++;
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        } else {
            i = 0;
            while (i < this.numnod) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    tempa += this.MatG[i][j] * (1.0 - Math.cos(this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j])) + (this.vec_xtempabs[off + i] - this.vec_xtempabs[off + j]) / this.MatX[i][j];
                }
                int n = i++;
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        }
        for (k = 0; k < this.numcon; ++k) {
            if (this.Conting[k][1].equals("Generador")) {
                for (i = 0; i < this.numgen; ++i) {
                    if (this.GenName[i][0] == this.Conting[k][0]) continue;
                    int n = this.numnod * (k + 1) + this.VarNode[i];
                    this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
                    int n2 = this.numnod * (k + 1) + this.VarNode[i];
                    this.vec_RHS[n2] = this.vec_RHS[n2] - this.vec_xtempabs[i + this.numgen * (k + 1)];
                }
                for (i = 0; i < this.numlast; ++i) {
                    int n = this.numnod * (k + 1) + Integer.parseInt(this.LoadName[i][1]);
                    this.vec_RHS[n] = this.vec_RHS[n] + this.vec_xtempabs[i + this.numgen * (this.numcon + 3) + this.numlast * k];
                    int n3 = this.numnod * (k + 1) + Integer.parseInt(this.LoadName[i][1]);
                    this.vec_RHS[n3] = this.vec_RHS[n3] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i];
                }
                for (i = 0; i < this.numnod; ++i) {
                    int n = this.numnod * (k + 1) + i;
                    this.vec_RHS[n] = this.vec_RHS[n] + -this.node_p[i];
                }
            }
            if (this.Conting[k][1].equals("Consumo")) {
                for (i = 0; i < this.numgen; ++i) {
                    int n = this.numnod * (k + 1) + this.VarNode[i];
                    this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
                    int n4 = this.numnod * (k + 1) + this.VarNode[i];
                    this.vec_RHS[n4] = this.vec_RHS[n4] - this.vec_xtempabs[i + this.numgen * (k + 1)];
                }
                for (i = 0; i < this.numlast; ++i) {
                    if (this.LoadName[i][0] != this.Conting[k][0]) {
                        int n = this.numnod * (k + 1) + Integer.parseInt(this.LoadName[i][1]);
                        this.vec_RHS[n] = this.vec_RHS[n] + this.vec_xtempabs[i + this.numgen * (this.numcon + 3) + this.numlast * k];
                        int n5 = this.numnod * (k + 1) + Integer.parseInt(this.LoadName[i][1]);
                        this.vec_RHS[n5] = this.vec_RHS[n5] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i];
                        continue;
                    }
                    int n = this.numnod * (k + 1) + Integer.parseInt(this.LoadName[i][1]);
                    this.vec_RHS[n] = this.vec_RHS[n] - Double.valueOf(this.LoadName[i][2]) / this.sref;
                }
                for (i = 0; i < this.numnod; ++i) {
                    int n = this.numnod * (k + 1) + i;
                    this.vec_RHS[n] = this.vec_RHS[n] + -this.node_p[i];
                }
            }
            if (!this.Conting[k][1].equals("Rama")) continue;
            for (i = 0; i < this.numgen; ++i) {
                int n = this.numnod * (k + 1) + this.VarNode[i];
                this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
                int n6 = this.numnod * (k + 1) + this.VarNode[i];
                this.vec_RHS[n6] = this.vec_RHS[n6] - this.vec_xtempabs[i + this.numgen * (k + 1)];
            }
            for (i = 0; i < this.numlast; ++i) {
                int n = this.numnod * (k + 1) + Integer.parseInt(this.LoadName[i][1]);
                this.vec_RHS[n] = this.vec_RHS[n] + this.vec_xtempabs[i + this.numgen * (this.numcon + 3) + this.numlast * k];
                int n7 = this.numnod * (k + 1) + Integer.parseInt(this.LoadName[i][1]);
                this.vec_RHS[n7] = this.vec_RHS[n7] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i];
            }
            for (i = 0; i < this.numnod; ++i) {
                int n = this.numnod * (k + 1) + i;
                this.vec_RHS[n] = this.vec_RHS[n] + -this.node_p[i];
            }
        }
        if (this.cuadLossModel) {
            count = 0;
            for (k = 0; k < this.numcon; ++k) {
                if (this.Conting[k][1] == "Rama") {
                    for (ix = 0; ix < this.numbran; ++ix) {
                        if (this.Conting[k][0] != this.BranName[ix][0]) continue;
                        con1 = Integer.parseInt(this.BranName[ix][1]);
                        con2 = Integer.parseInt(this.BranName[ix][2]);
                    }
                } else {
                    con1 = 100000;
                    con2 = 100000;
                }
                for (i = 0; i < this.numnod; ++i) {
                    tempa = 0.0;
                    for (j = 0; j < this.numnod; ++j) {
                        if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                        if ((j == con1 && i == con2 || i == con1 && j == con2) && this.Conting[k][1] == "Rama") {
                            for (int ixx = 0; ixx < this.ActSchematic.Components.size(); ++ixx) {
                                Line TempLinex;
                                comp TempComponentx = (comp)this.ActSchematic.Components.elementAt(ixx);
                                if (!TempComponentx.getactive() || !TempComponentx.getvalid() || !TempComponentx.getinservice() || !(TempComponentx instanceof ndb_branch) || !(TempComponentx instanceof Line) || TempComponentx.getName() == this.Conting[k][0] || (this.numbus((TempLinex = (Line)TempComponentx).getcon1()) != con1 || this.numbus(TempLinex.getcon2()) != con2) && (this.numbus(TempLinex.getcon2()) != con1 || this.numbus(TempLinex.getcon1()) != con2)) continue;
                                double xx = TempLinex.getxx1() * TempLinex.getlen() * this.sref / (TempLinex.getun1() * TempLinex.getun1());
                                double rr = TempLinex.getr1() * TempLinex.getlen() * this.sref / (TempLinex.getun1() * TempLinex.getun1());
                                tempa += rr / (rr * rr + xx * xx) / 2.0 * (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) * (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) + (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) / xx;
                            }
                            continue;
                        }
                        tempa += this.MatG[i][j] / 2.0 * (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) * (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) + (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) / this.MatX[i][j];
                    }
                    int n = i + this.numnod * (k + 1);
                    this.vec_RHS[n] = this.vec_RHS[n] + tempa;
                }
            }
        } else {
            count = 0;
            for (k = 0; k < this.numcon; ++k) {
                if (this.Conting[k][1] == "Rama") {
                    for (ix = 0; ix < this.numbran; ++ix) {
                        if (this.Conting[k][0] != this.BranName[ix][0]) continue;
                        con1 = Integer.parseInt(this.BranName[ix][1]);
                        con2 = Integer.parseInt(this.BranName[ix][2]);
                    }
                } else {
                    con1 = 100000;
                    con2 = 100000;
                }
                for (i = 0; i < this.numnod; ++i) {
                    tempa = 0.0;
                    for (j = 0; j < this.numnod; ++j) {
                        if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i || (j == con1 && i == con2 || i == con1 && j == con2) && this.Conting[k][1] == "Rama") continue;
                        tempa += this.MatG[i][j] * (1.0 - Math.cos(this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j])) + (this.vec_xtempabs[off + this.numnod * (k + 1) + i] - this.vec_xtempabs[off + this.numnod * (k + 1) + j]) / this.MatX[i][j];
                    }
                    int n = i + this.numnod * (k + 1);
                    this.vec_RHS[n] = this.vec_RHS[n] + tempa;
                }
            }
        }
        for (i = 0; i < this.numgen; ++i) {
            int n = this.VarNode[i] + this.numnod * (this.numcon + 1);
            this.vec_RHS[n] = this.vec_RHS[n] - (this.vec_xtempabs[i] + this.vec_xtempabs[i + this.numgen * (this.numcon + 1)]);
            int n8 = this.VarNode[i] + this.numnod * (this.numcon + 2);
            this.vec_RHS[n8] = this.vec_RHS[n8] - (this.vec_xtempabs[i] + this.vec_xtempabs[i + this.numgen * (this.numcon + 2)]);
        }
        if (this.cuadLossModel) {
            for (i = 0; i < this.numnod; ++i) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    tempa += this.MatG[i][j] / 2.0 * (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + j]) * (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + j]) + (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + j]) / this.MatX[i][j];
                }
                int n = i + this.numnod * (this.numcon + 1);
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        } else {
            for (i = 0; i < this.numnod; ++i) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    tempa += this.MatG[i][j] * (1.0 - Math.cos(this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + j])) + (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + j]) / this.MatX[i][j];
                }
                int n = i + this.numnod * (this.numcon + 1);
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        }
        if (this.cuadLossModel) {
            for (i = 0; i < this.numnod; ++i) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    tempa += this.MatG[i][j] / 2.0 * (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + j]) * (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + j]) + (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + j]) / this.MatX[i][j];
                }
                int n = i + this.numnod * (this.numcon + 2);
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        } else {
            for (i = 0; i < this.numnod; ++i) {
                tempa = 0.0;
                for (j = 0; j < this.numnod; ++j) {
                    if (!(Math.abs(this.MatX[i][j]) > 1.0E-6) || j == i) continue;
                    tempa += this.MatG[i][j] * (1.0 - Math.cos(this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + j])) + (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + i] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + j]) / this.MatX[i][j];
                }
                int n = i + this.numnod * (this.numcon + 2);
                this.vec_RHS[n] = this.vec_RHS[n] + tempa;
            }
        }
        count1 = false;
        for (i = 0; i < this.numnod; ++i) {
            int n = i + this.numnod * (this.numcon + 1);
            this.vec_RHS[n] = this.vec_RHS[n] + -this.node_p[i];
            int n9 = i + this.numnod * (this.numcon + 2);
            this.vec_RHS[n9] = this.vec_RHS[n9] + -this.node_p[i];
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            if (this.llamada == 2) {
                int n = this.numnod * (this.numcon + 1) + this.numbus(TempLoad.getcon2());
                this.vec_RHS[n] = this.vec_RHS[n] + this.dReqdemup / this.sref * (TempLoad.getp0() / this.totdem);
                int n10 = this.numnod * (this.numcon + 2) + this.numbus(TempLoad.getcon2());
                this.vec_RHS[n10] = this.vec_RHS[n10] - this.dReqdemdn / this.sref * (TempLoad.getp0() / this.totdem);
                continue;
            }
            int n = this.numnod * (this.numcon + 1) + this.numbus(TempLoad.getcon2());
            this.vec_RHS[n] = this.vec_RHS[n] + (double)this.Reqdemup / this.sref * (TempLoad.getp0() / this.totdem);
            int n11 = this.numnod * (this.numcon + 2) + this.numbus(TempLoad.getcon2());
            this.vec_RHS[n11] = this.vec_RHS[n11] - (double)this.Reqdemdn / this.sref * (TempLoad.getp0() / this.totdem);
        }
        for (i = 0; i < this.numlast; ++i) {
            int n = Integer.parseInt(this.LoadName[i][1]) + this.numnod * (this.numcon + 1);
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i];
            int n12 = Integer.parseInt(this.LoadName[i][1]) + this.numnod * (this.numcon + 2);
            this.vec_RHS[n12] = this.vec_RHS[n12] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + i];
        }
        this.vec_RHS[this.numnod * (this.numcon + 3)] = (double)this.Requp / this.sref;
        if (this.llamada == 2) {
            this.vec_RHS[this.numnod * (this.numcon + 3)] = this.dRequp / this.sref;
        }
        for (i = this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod; i < this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod; ++i) {
            int n = this.numnod * (this.numcon + 3);
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
        }
        this.vec_RHS[this.numnod * (this.numcon + 3) + 1] = (double)this.Reqdn / this.sref;
        if (this.llamada == 2) {
            this.vec_RHS[this.numnod * (this.numcon + 3) + 1] = this.dReqdn / this.sref;
        }
        for (i = this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod; i < this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod; ++i) {
            int n = this.numnod * (this.numcon + 3) + 1;
            this.vec_RHS[n] = this.vec_RHS[n] - this.vec_xtempabs[i];
        }
        this.vec_RHS[this.numnod * (this.numcon + 3) + 2] = 0.0;
        for (i = this.numgen * (this.numcon + 1); i < this.numgen * (this.numcon + 2); ++i) {
        }
        this.vec_RHS[this.numnod * (this.numcon + 3) + 3] = 0.0;
        for (i = this.numgen * (this.numcon + 2); i < this.numgen * (this.numcon + 3); ++i) {
        }
        off = this.numcon * (this.numgen + this.numlast) + 3 * this.numgen;
        if (this.linres) {
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Complex yij;
                Complex auxc2;
                Complex auxc1;
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + count] = -TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                    this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran + count] = TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + count] = -TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran + count] = TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + con1] - this.vec_xtempabs[off + con2]) / xij;
                ++count;
            }
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            for (k = 0; k < this.numcon; ++k) {
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    Complex yij;
                    Complex auxc2;
                    Complex auxc1;
                    TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                    Tempbran = (ndb_branch)TempComponent;
                    if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                        auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        yij = new Complex(0.0, 0.0);
                        yij.add(auxc1);
                        xij = this.BranchX[count];
                        if (Math.abs(xij) > 1.0E-7) {
                            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count] = -TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + (k + 1) * this.numnod + con1] - this.vec_xtempabs[off + (k + 1) * this.numnod + con2]) / xij;
                            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count] = TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + (k + 1) * this.numnod + con1] - this.vec_xtempabs[off + (k + 1) * this.numnod + con2]) / xij;
                        } else {
                            System.out.println("ERROR: Too low reactance");
                        }
                        ++count;
                    }
                    if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    if (Math.abs(xij) > 1.0E-7) {
                        this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count] = -TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + (k + 1) * this.numnod + con1] - this.vec_xtempabs[off + (k + 1) * this.numnod + con2]) / xij;
                        this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count] = TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + (k + 1) * this.numnod + con1] - this.vec_xtempabs[off + (k + 1) * this.numnod + con2]) / xij;
                    } else {
                        System.out.println("ERROR: Too low reactance");
                    }
                    ++count;
                }
                count = 0;
                con1 = 10000;
                con2 = 10000;
                if (this.Conting[k][1] == "Rama") {
                    for (ix = 0; ix < this.numbran; ++ix) {
                        if (this.Conting[k][0] != this.BranName[ix][0]) continue;
                        con1 = Integer.parseInt(this.BranName[ix][1]);
                        con2 = Integer.parseInt(this.BranName[ix][2]);
                    }
                    int conex1 = 10000;
                    int conex2 = 10000;
                    for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                        TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                        if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                        conex1 = this.numbus(TempComponent.getcon1());
                        conex2 = this.numbus(TempComponent.getcon2());
                        if ((conex1 == con1 && conex2 == con2 || conex2 == con1 && conex1 == con2) && TempComponent.getName() == this.Conting[k][0]) {
                            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran * (k + 2) + count] = 0.0;
                            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + this.numbran * (this.numcon + k + 2) + count] = 0.0;
                        }
                        ++count;
                    }
                }
                count = 0;
                con1 = 10000;
                con2 = 10000;
            }
        }
        for (k = 0; k < this.numcon; ++k) {
            for (i = 0; i < this.numgen; ++i) {
                if (this.Conting[k][0] != this.GenName[i][0]) {
                    this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + k * this.numgen + i] = this.Pmax[i] - this.vec_xtempabs[i] - this.vec_xtempabs[i + this.numgen * (k + 1)];
                    this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + (k + this.numcon) * this.numgen + i] = -this.Pmin[i] + this.vec_xtempabs[i] + this.vec_xtempabs[i + this.numgen * (k + 1)];
                    continue;
                }
                this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + k * this.numgen + i] = 0.0;
                this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + (k + this.numcon) * this.numgen + i] = 0.0;
            }
        }
        count1 = false;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            Load load = (Load)TempComponent;
        }
        for (i = 0; i < this.numgen; ++i) {
            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + i] = this.Pmax[i] - this.vec_xtempabs[i] - this.vec_xtempabs[i + this.numgen * (this.numcon + 1)];
            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + this.numgen + i] = -this.Pmin[i] + this.vec_xtempabs[i] + this.vec_xtempabs[i + this.numgen * (this.numcon + 1)];
        }
        for (i = 0; i < this.numgen; ++i) {
            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 2 * this.numgen + i] = this.Pmax[i] - this.vec_xtempabs[i] - this.vec_xtempabs[i + this.numgen * (this.numcon + 2)];
            this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + i] = -this.Pmin[i] + this.vec_xtempabs[i] + this.vec_xtempabs[i + this.numgen * (this.numcon + 2)];
        }
        for (i = 0; i < this.numgen; ++i) {
            for (k = 0; k < this.numcon; ++k) {
                this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + i * this.numcon + k] = this.vec_xtempabs[this.numgen * (k + 1) + i] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod + i];
            }
        }
        for (i = 0; i < this.numgen; ++i) {
            for (k = 0; k < this.numcon; ++k) {
                this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numgen * this.numcon + i * this.numcon + k] = -this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod + i] - this.vec_xtempabs[this.numgen * (k + 1) + i];
            }
        }
        for (k = 0; k < this.numcon; ++k) {
            SCEDDatos datosSCED = new SCEDDatos();
            datosSCED.loaddatafromfile();
            int probab = 14;
            for (i = 0; i < this.numlast; ++i) {
                this.vec_RHS[this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + 2 * this.numgen * this.numcon + i] = -this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + i];
                int n = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + 2 * this.numgen * this.numcon + i;
                this.vec_RHS[n] = this.vec_RHS[n] - datosSCED.getparameter(probab, this.Conting[k][0]) * this.vec_xtempabs[i + this.numgen * (3 + this.numcon) + this.numlast * k];
            }
        }
        if (this.linres) {
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Complex yij;
                Complex auxc2;
                Complex auxc1;
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + count] = -TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con2]) / xij;
                    this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + this.numbran + count] = TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con2]) / xij;
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + count] = -TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con2]) / xij;
                this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + this.numbran + count] = TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 1) + con2]) / xij;
                ++count;
            }
            ix = 0;
            count = 0;
            con1 = 10000;
            con2 = 10000;
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                Complex yij;
                Complex auxc2;
                Complex auxc1;
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch)) continue;
                Tempbran = (ndb_branch)TempComponent;
                if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)Tempbran).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    yij = new Complex(0.0, 0.0);
                    yij.add(auxc1);
                    xij = this.BranchX[count];
                    this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + count] = -TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con2]) / xij;
                    this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 3 * this.numbran + count] = TempLine.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con2]) / xij;
                    ++count;
                }
                if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)Tempbran).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                yij = new Complex(0.0, 0.0);
                yij.add(auxc1);
                xij = this.BranchX[count];
                this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 2 * this.numbran + count] = -TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con2]) / xij;
                this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 3 * this.numbran + count] = TempTrafo.getsmax() / this.sref + (this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[off + this.numnod * (this.numcon + 2) + con2]) / xij;
                ++count;
            }
        }
        for (i = 0; i < this.numgen; ++i) {
            this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 4 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran + i] = -this.vec_xtempabs[i] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod + i] + this.Pmax[i];
            this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 5 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran + i] = this.vec_xtempabs[i] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod + i] - this.Pmin[i];
        }
        for (i = 0; i < this.numgen; ++i) {
            this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 6 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran + i] = -this.vec_xtempabs[i] - this.vec_xtempabs[i + this.numgen * (this.numcon + 1)] - this.vec_xtempabs[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod] + this.Pmax[i];
            this.vec_RHS[(this.numcon + 1) * (this.numnod + 2 * this.numbran) + this.numcon * (4 * this.numgen + 3 * this.numlast) + 7 * this.numgen + 2 * this.numnod + 4 + 4 * this.numbran + i] = -this.vec_xtempabs[i] + this.vec_xtempabs[i + this.numgen * (this.numcon + 2)] + this.vec_xtempabs[i + this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod] + this.Pmin[i];
        }
    }

    public void make_vec_clave() {
        int i;
        for (i = 0; i < this.numnod * (this.numcon + 3); ++i) {
            this.vec_clave[i] = 1;
        }
        for (i = this.numnod * (this.numcon + 3); i < this.numnod * (this.numcon + 3) + 2; ++i) {
            this.vec_clave[i] = 3;
        }
        for (i = this.numnod * (this.numcon + 3) + 2; i < this.numnod * (this.numcon + 3) + 4; ++i) {
            this.vec_clave[i] = 3;
        }
        if (this.linres) {
            for (i = this.numnod * (this.numcon + 3) + 4; i < this.numnod * (this.numcon + 3) + 4 + this.numbran; ++i) {
                this.vec_clave[i] = 3;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran + this.numcon * this.numbran; ++i) {
                this.vec_clave[i] = 3;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran + this.numcon * this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1); ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1); i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + this.numcon * this.numgen; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + this.numcon * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * this.numgen; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * this.numgen + this.numcon * this.numlast; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * this.numgen + this.numcon * this.numlast; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast); ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast); i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + this.numgen; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 2 * this.numgen; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 2 * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 3 * this.numgen; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 3 * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * 2 * this.numgen; ++i) {
                this.vec_clave[i] = 3;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * 2 * this.numgen; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast); ++i) {
                this.vec_clave[i] = 1;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast); i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + this.numbran; ++i) {
                this.vec_clave[i] = 3;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 2 * this.numbran; ++i) {
                this.vec_clave[i] = 2;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 2 * this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 3 * this.numbran; ++i) {
                this.vec_clave[i] = 3;
            }
            for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 3 * this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran; ++i) {
                this.vec_clave[i] = 2;
            }
        }
        for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 4 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 5 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran; ++i) {
            this.vec_clave[i] = 2;
        }
        for (i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 5 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran; i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 6 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran; ++i) {
            this.vec_clave[i] = 2;
        }
        i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 6 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran;
        while (i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 7 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran) {
            this.vec_clave[i] = 2;
            ++i;
        }
        i = this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 7 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran;
        while (i < this.numnod * (this.numcon + 3) + 4 + 2 * this.numbran * (this.numcon + 1) + 2 * this.numcon * (this.numgen + this.numlast) + 8 * this.numgen + this.numcon * (2 * this.numgen + this.numlast) + 4 * this.numbran) {
            this.vec_clave[i] = 3;
            ++i;
        }
    }

    public void WriteResults() {
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        int i = 0;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        int count3 = 0;
        int con1 = 10000;
        int con2 = 10000;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        boolean rama = false;
        this.totincome = 0.0;
        this.totsales = 0.0;
        this.totunsercost = 0.0;
        this.totit = 0.0;
        this.Requpserver = new double[this.numgen];
        for (i = 0; i < this.numgen; ++i) {
            this.Requpserver[i] = this.vec_xtempabs[i + this.numgen + this.numnod] * this.sref;
        }
        this.totgen = 0.0;
        this.totdem = 0.0;
        this.totunser = 0.0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Trafo TempTrafo;
            double f21;
            double gmula;
            double f12;
            Line TempLine;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                if (Math.abs(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count2] * this.sref) < 0.001) {
                    TempLoad.setunser_p(0.0);
                } else {
                    TempLoad.setunser_p(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count2] * this.sref);
                }
                this.totsales += TempLoad.getp() * this.vec_lam[this.numbus(TempLoad.getcon2())] / this.sref;
                this.totunsercost += this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count2] * this.sref * this.sref * this.vec_lam[this.numbus(TempLoad.getcon2())] / this.sref;
                this.totunser += this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count2] * this.sref;
                this.totdem += TempLoad.getp0();
                ++count2;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (Math.abs(this.vec_xtempabs[potas] * this.sref) < 0.001) {
                    TempInj.setp(0.0);
                } else {
                    TempInj.setp(this.vec_xtempabs[potas] * this.sref);
                }
                this.totincome += this.vec_xtempabs[potas] * this.sref * this.vec_lam[this.numbus(TempInj.getcon2())] / this.sref;
                this.totgen += this.vec_xtempabs[potas] * this.sref;
                ++potas;
            }
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                double angulin = this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + nodo] * 180.0 / Math.PI;
                TempBusbar.setdelta2(angulin);
                double aux = this.vec_lam[nodo];
                for (int k = 0; k < this.numcon; ++k) {
                    aux += this.vec_lam[this.numnod * (k + 1) + nodo];
                }
                aux += this.vec_lam[this.numnod * (this.numcon + 1) + nodo];
                double spotin = (aux += this.vec_lam[this.numnod * (this.numcon + 2) + nodo]) / this.sref;
                TempBusbar.setspot_p(spotin);
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                f12 = 0.0;
                gmula = 0.0;
                if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                    gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                    f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                    TempLine.setp12(f12);
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    f12 = 0.0;
                }
                f21 = 0.0;
                if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                    gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                    f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                    TempLine.setp21(f21);
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    f21 = 0.0;
                }
                if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                    this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count];
                    this.NomBra[count] = TempLine.getName();
                } else {
                    System.out.println("Reactancia muy baja!!!");
                    this.Flujo[count] = 0.0;
                    this.NomBra[count] = TempLine.getName();
                }
                this.totit += f12 * this.vec_lam[con1] + f21 * this.vec_lam[con2];
                ++count;
            }
            if (!(TempComponent instanceof Trafo) || (con1 = this.numbus((TempTrafo = (Trafo)TempComponent).getcon1())) == 10000 || (con2 = this.numbus(TempTrafo.getcon2())) == 10000) continue;
            f12 = 0.0;
            gmula = 0.0;
            if (TempTrafo.gett_re() > 1.0E-6) {
                this.BranchX[count] = this.BranchX[count] * TempTrafo.gett_re();
                this.BranchR[count] = this.BranchR[count] * TempTrafo.gett_re();
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                TempTrafo.setp12(f12);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
            }
            f21 = 0.0;
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                TempTrafo.setp21(f21);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f21 = 0.0;
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count];
                this.NomBra[count] = TempTrafo.getName();
            } else {
                System.out.println("Reactancia muy baja!!!");
                this.Flujo[count] = 0.0;
                this.NomBra[count] = TempTrafo.getName();
            }
            this.totit += f12 * this.vec_lam[con1] + f21 * this.vec_lam[con2];
            ++count;
            ++count3;
        }
    }

    public void WriteResultsPreCon() {
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        int i = 0;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        int count3 = 0;
        int con1 = 10000;
        int con2 = 10000;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        boolean rama = false;
        this.totincome = 0.0;
        this.totsales = 0.0;
        this.totunsercost = 0.0;
        this.totit = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        this.totunser = 0.0;
        count = 0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            double f21;
            double gmula;
            double f12;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                for (i = 0; i < this.numlast; ++i) {
                    if (this.LoadName[i][0] != TempLoad.getName()) continue;
                    TempLoad.setp0(Double.valueOf(this.LoadName[i][2]));
                    TempLoad.setunser_p(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + 1 * this.numlast + this.numcon + count2] * this.sref);
                }
                ++count2;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (Math.abs(this.vec_xtempabs[potas] * this.sref) < 0.001) {
                    TempInj.setp(0.0);
                } else {
                    TempInj.setp(this.vec_xtempabs[potas] * this.sref);
                }
                this.totgen += this.vec_xtempabs[potas] * this.sref;
                ++potas;
            }
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                double angulin = this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + nodo] * 180.0 / Math.PI;
                TempBusbar.setdelta2(angulin);
                double aux = this.vec_lam[nodo];
                for (int k = 0; k < this.numcon; ++k) {
                    aux += this.vec_lam[this.numnod * (k + 1) + nodo];
                }
                aux += this.vec_lam[this.numnod * (this.numcon + 1) + nodo];
                double spotin = (aux += this.vec_lam[this.numnod * (this.numcon + 2) + nodo]) / this.sref;
                TempBusbar.setspot_p(spotin);
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                for (i = 0; i < this.numbran; ++i) {
                    if (TempLine.getName() != this.BranName[i][0]) continue;
                    con1 = Integer.parseInt(this.BranName[i][1]);
                    con2 = Integer.parseInt(this.BranName[i][2]);
                }
                if (con1 != 10000 && con2 != 10000) {
                    f12 = 0.0;
                    gmula = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                        TempLine.setp12(f12);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f12 = 0.0;
                    }
                    f21 = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                        TempLine.setp21(f21);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f21 = 0.0;
                    }
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count];
                        this.NomBra[count] = TempLine.getName();
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        this.Flujo[count] = 0.0;
                        this.NomBra[count] = TempLine.getName();
                    }
                    this.totit += f12 * this.vec_lam[con1] + f21 * this.vec_lam[con2];
                    ++count;
                }
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            for (i = 0; i < this.numbran; ++i) {
                if (TempTrafo.getName() != this.BranName[i][0]) continue;
                con1 = Integer.parseInt(this.BranName[i][1]);
                con2 = Integer.parseInt(this.BranName[i][2]);
            }
            if (con1 == 10000 || con2 == 10000) continue;
            f12 = 0.0;
            gmula = 0.0;
            if (TempTrafo.gett_re() > 1.0E-6) {
                this.BranchX[count] = this.BranchX[count] * TempTrafo.gett_re();
                this.BranchR[count] = this.BranchR[count] * TempTrafo.gett_re();
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                TempTrafo.setp12(f12);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
            }
            f21 = 0.0;
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]));
                TempTrafo.setp21(f21);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f21 = 0.0;
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + con2]) / this.BranchX[count];
                this.NomBra[count] = TempTrafo.getName();
            } else {
                System.out.println("Reactancia muy baja!!!");
                this.Flujo[count] = 0.0;
                this.NomBra[count] = TempTrafo.getName();
            }
            this.totit += f12 * this.vec_lam[con1] + f21 * this.vec_lam[con2];
            ++count;
            ++count3;
        }
    }

    public void WriteResultsSecUp() {
        this.WriteResultsPreCon();
        System.out.println("   - Resultados Regulacion Secundaria de Subida...");
        System.out.println("   - Variacion total de la demanda: " + this.Reqdemup + " [MW]");
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        int i = 0;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        int count3 = 0;
        int con1 = 10000;
        int con2 = 10000;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        boolean rama = false;
        this.totincome = 0.0;
        this.totsales = 0.0;
        this.totunsercost = 0.0;
        this.totit = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        this.totunser = 0.0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            double f21;
            double gmula;
            double f12;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                TempLoad.setp0(TempLoad.getp0() + (double)(this.Reqdemup / this.numlast));
                TempLoad.setunser_p(0.0);
                ++count2;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (Math.abs((this.vec_xtempabs[potas] + this.vec_xtempabs[potas + this.numgen * (this.numcon + 1)]) * this.sref) < 0.001) {
                    TempInj.setp(0.0);
                } else {
                    TempInj.setp((this.vec_xtempabs[potas] + this.vec_xtempabs[potas + this.numgen * (this.numcon + 1)]) * this.sref);
                }
                ++potas;
            }
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                double angulin = this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + nodo] * 180.0 / Math.PI;
                TempBusbar.setdelta2(angulin);
                double spotin = this.vec_lam[nodo + this.numnod * (this.numcon + 1)] / this.sref;
                TempBusbar.setspot_p(spotin);
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                for (i = 0; i < this.numbran; ++i) {
                    if (TempLine.getName() != this.BranName[i][0]) continue;
                    con1 = Integer.parseInt(this.BranName[i][1]);
                    con2 = Integer.parseInt(this.BranName[i][2]);
                }
                if (con1 != 10000 && con2 != 10000) {
                    f12 = 0.0;
                    gmula = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]));
                        TempLine.setp12(f12);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f12 = 0.0;
                    }
                    f21 = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]));
                        TempLine.setp21(f21);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f21 = 0.0;
                    }
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]) / this.BranchX[count];
                        this.NomBra[count] = TempLine.getName();
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        this.Flujo[count] = 0.0;
                        this.NomBra[count] = TempLine.getName();
                    }
                    ++count;
                }
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            for (i = 0; i < this.numbran; ++i) {
                if (TempTrafo.getName() != this.BranName[i][0]) continue;
                con1 = Integer.parseInt(this.BranName[i][1]);
                con2 = Integer.parseInt(this.BranName[i][2]);
            }
            if (con1 == 10000 || con2 == 10000) continue;
            f12 = 0.0;
            gmula = 0.0;
            if (TempTrafo.gett_re() > 1.0E-6) {
                this.BranchX[count] = this.BranchX[count] * TempTrafo.gett_re();
                this.BranchR[count] = this.BranchR[count] * TempTrafo.gett_re();
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]));
                TempTrafo.setp12(f12);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
            }
            f21 = 0.0;
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]));
                TempTrafo.setp21(f21);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f21 = 0.0;
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 1) + con2]) / this.BranchX[count];
                this.NomBra[count] = TempTrafo.getName();
            } else {
                System.out.println("Reactancia muy baja!!!");
                this.Flujo[count] = 0.0;
                this.NomBra[count] = TempTrafo.getName();
            }
            ++count;
            ++count3;
        }
    }

    public void WriteResultsSecDn() {
        this.WriteResultsPreCon();
        System.out.println("   - Resultados Regulacion Secundaria de Bajada...");
        System.out.println("   - Variacion total de la demanda: " + this.Reqdemdn + " [MW]");
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        int i = 0;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        int count3 = 0;
        int con1 = 10000;
        int con2 = 10000;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        boolean rama = false;
        this.totincome = 0.0;
        this.totsales = 0.0;
        this.totunsercost = 0.0;
        this.totit = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        this.totunser = 0.0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            double f21;
            double gmula;
            double f12;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                TempLoad.setp0(TempLoad.getp0() - (double)(this.Reqdemdn / this.numlast));
                TempLoad.setunser_p(0.0);
                ++count2;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (Math.abs((this.vec_xtempabs[potas] + this.vec_xtempabs[potas + this.numgen * (this.numcon + 2)]) * this.sref) < 0.001) {
                    TempInj.setp(0.0);
                } else {
                    TempInj.setp((this.vec_xtempabs[potas] + this.vec_xtempabs[potas + this.numgen * (this.numcon + 2)]) * this.sref);
                }
                ++potas;
            }
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                double angulin = this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + nodo] * 180.0 / Math.PI;
                TempBusbar.setdelta2(angulin);
                double spotin = this.vec_lam[nodo + this.numnod * (this.numcon + 2)] / this.sref;
                TempBusbar.setspot_p(spotin);
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                for (i = 0; i < this.numbran; ++i) {
                    if (TempLine.getName() != this.BranName[i][0]) continue;
                    con1 = Integer.parseInt(this.BranName[i][1]);
                    con2 = Integer.parseInt(this.BranName[i][2]);
                }
                if (con1 != 10000 && con2 != 10000) {
                    f12 = 0.0;
                    gmula = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]));
                        TempLine.setp12(f12);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f12 = 0.0;
                    }
                    f21 = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]));
                        TempLine.setp21(f21);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f21 = 0.0;
                    }
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]) / this.BranchX[count];
                        this.NomBra[count] = TempLine.getName();
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        this.Flujo[count] = 0.0;
                        this.NomBra[count] = TempLine.getName();
                    }
                    ++count;
                }
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            for (i = 0; i < this.numbran; ++i) {
                if (TempTrafo.getName() != this.BranName[i][0]) continue;
                con1 = Integer.parseInt(this.BranName[i][1]);
                con2 = Integer.parseInt(this.BranName[i][2]);
            }
            if (con1 == 10000 || con2 == 10000) continue;
            f12 = 0.0;
            gmula = 0.0;
            if (TempTrafo.gett_re() > 1.0E-6) {
                this.BranchX[count] = this.BranchX[count] * TempTrafo.gett_re();
                this.BranchR[count] = this.BranchR[count] * TempTrafo.gett_re();
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]));
                TempTrafo.setp12(f12);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
            }
            f21 = 0.0;
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]));
                TempTrafo.setp21(f21);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f21 = 0.0;
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (this.numcon + 2) + con2]) / this.BranchX[count];
                this.NomBra[count] = TempTrafo.getName();
            } else {
                System.out.println("Reactancia muy baja!!!");
                this.Flujo[count] = 0.0;
                this.NomBra[count] = TempTrafo.getName();
            }
            ++count;
            ++count3;
        }
    }

    public void WriteResultsConting(int k, String nombre) {
        comp TempComponent;
        System.out.println("   - Desviacion frecuencia   #" + (k + 1) + ": " + Math.rint(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + this.numlast + k] * 1000.0 * 100.0) / 100.0 + " [mHz]");
        this.WriteResultsPreCon();
        this.restorecolor();
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            ndb_comp Tempndb;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(Tempndb = (ndb_comp)TempComponent).getactive() || !Tempndb.getvalid() || !TempComponent.getinservice() || nombre != TempComponent.getName()) continue;
            Tempndb.lw = 2;
            ndb_comp.CaptionColor = Color.lightGray;
            ndb_comp.TextColor1 = Color.lightGray;
            ndb_comp.TextColor2 = Color.lightGray.darker();
            ndb_comp.TextColor3 = Color.green;
            ndb_comp.Color1 = Color.red;
            ndb_comp.Color2 = Color.orange;
            ndb_comp.Color3 = Color.green;
            Tempndb.setAlternatekv_Color(Color.black);
        }
        DeepEdit.MySchematicPanel.repaint();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        int i = 0;
        boolean j = false;
        int ix = 0;
        int count = 0;
        boolean count1 = false;
        int count2 = 0;
        int count3 = 0;
        int con1 = 10000;
        int con2 = 10000;
        double refdelta = 0.0;
        double lloss = 0.0;
        int nodo = 0;
        boolean linea = false;
        boolean trans = false;
        boolean carga = false;
        boolean rama = false;
        this.totincome = 0.0;
        this.totsales = 0.0;
        this.totunsercost = 0.0;
        this.totit = 0.0;
        this.totgen = 0.0;
        this.totdem = 0.0;
        this.totunser = 0.0;
        int potas = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            double f21;
            double gmula;
            double f12;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Load) {
                Load TempLoad = (Load)TempComponent;
                if (TempLoad.getName() == nombre) {
                    TempLoad.setp0(0.0);
                    TempLoad.setunser_p(0.0);
                } else if (Math.abs(this.vec_xtempabs[this.numgen * (this.numcon + 3) + k * this.numlast + count2] * this.sref) < 0.001) {
                    TempLoad.setunser_p(0.0);
                } else {
                    double Paux = TempLoad.getp0();
                    TempLoad.setp0(Paux + this.vec_xtempabs[this.numgen * (this.numcon + 3) + k * this.numlast + count2] * this.sref);
                }
                ++count2;
            }
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                if (Math.abs((this.vec_xtempabs[potas] + this.vec_xtempabs[potas + this.numgen * (k + 1)]) * this.sref) < 0.001) {
                    TempInj.setp(0.0);
                } else {
                    TempInj.setp((this.vec_xtempabs[potas] + this.vec_xtempabs[potas + this.numgen * (k + 1)]) * this.sref);
                }
                if (TempComponent.getName() == nombre) {
                    TempInj.setp(0.0);
                }
                ++potas;
            }
            if (TempComponent instanceof Busbar) {
                Busbar TempBusbar = (Busbar)TempComponent;
                double angulin = this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + nodo] * 180.0 / Math.PI;
                TempBusbar.setdelta2(angulin);
                double spotin = this.vec_lam[nodo + this.numnod * (k + 1)] / this.sref;
                TempBusbar.setspot_p(spotin);
                ++nodo;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                for (i = 0; i < this.numbran; ++i) {
                    if (TempLine.getName() != this.BranName[i][0]) continue;
                    con1 = Integer.parseInt(this.BranName[i][1]);
                    con2 = Integer.parseInt(this.BranName[i][2]);
                }
                if (con1 != 10000 && con2 != 10000) {
                    f12 = 0.0;
                    gmula = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]));
                        TempLine.setp12(f12);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f12 = 0.0;
                    }
                    f21 = 0.0;
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                        f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]));
                        TempLine.setp21(f21);
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        f21 = 0.0;
                    }
                    if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                        this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]) / this.BranchX[count];
                        this.NomBra[count] = TempLine.getName();
                    } else {
                        System.out.println("Reactancia muy baja!!!");
                        this.Flujo[count] = 0.0;
                        this.NomBra[count] = TempLine.getName();
                    }
                    if (TempLine.getName() == nombre) {
                        this.Flujo[count] = 0.0;
                        this.NomBra[count] = TempLine.getName();
                        TempLine.setp12(0.0);
                        TempLine.setp21(0.0);
                    }
                    ++count;
                }
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            for (i = 0; i < this.numbran; ++i) {
                if (TempTrafo.getName() != this.BranName[i][0]) continue;
                con1 = Integer.parseInt(this.BranName[i][1]);
                con2 = Integer.parseInt(this.BranName[i][2]);
            }
            if (con1 == 10000 || con2 == 10000) continue;
            f12 = 0.0;
            gmula = 0.0;
            if (TempTrafo.gett_re() > 1.0E-6) {
                this.BranchX[count] = this.BranchX[count] * TempTrafo.gett_re();
                this.BranchR[count] = this.BranchR[count] * TempTrafo.gett_re();
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f12 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]));
                TempTrafo.setp12(f12);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f12 = 0.0;
            }
            f21 = 0.0;
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                gmula = this.BranchR[count] / (this.BranchR[count] * this.BranchR[count] + this.BranchX[count] * this.BranchX[count]);
                f21 = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1]) / this.BranchX[count] + gmula * (1.0 - Math.cos(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]));
                TempTrafo.setp21(f21);
            } else {
                System.out.println("Reactancia muy baja!!!");
                f21 = 0.0;
            }
            if (Math.abs(this.BranchX[count]) > 1.0E-6) {
                this.Flujo[count] = (this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con1] - this.vec_xtempabs[this.numcon * (this.numgen + this.numlast) + 3 * this.numgen + this.numnod * (k + 1) + con2]) / this.BranchX[count];
                this.NomBra[count] = TempTrafo.getName();
            } else {
                System.out.println("Reactancia muy baja!!!");
                this.Flujo[count] = 0.0;
                this.NomBra[count] = TempTrafo.getName();
            }
            if (TempTrafo.getName() == nombre) {
                this.Flujo[count] = 0.0;
                this.NomBra[count] = TempTrafo.getName();
                TempTrafo.setp12(0.0);
                TempTrafo.setp21(0.0);
            }
            ++count;
            ++count3;
        }
    }

    private void restorecolor() {
        DeepEdit.MySchematic.restoreColor();
    }

    public void setParameters(int solverOpIndex, int iterOpIndex, int tolRHSIndex, int tolCostOpIndex, boolean linr, boolean lossMod, boolean iincremental, int TimeFrameIndex, int RRequp, int RReqdn, int RReqdemup, int RReqdemdn, boolean ccentralized, boolean ppartDem) {
        if (solverOpIndex == 0) {
            this.metodo = 1;
        } else if (solverOpIndex == 1) {
            this.metodo = 4;
        }
        this.iteraciones = Integer.parseInt(maxIterOptions[iterOpIndex]);
        this.tolfeas = Double.parseDouble(maxRHSTolOptions[tolRHSIndex]);
        this.tolcost = Double.parseDouble(maxRHSTolOptions[tolCostOpIndex]);
        this.nummin = Double.parseDouble(TimeFrameOptions[TimeFrameIndex]);
        this.linres = linr;
        this.incremental = iincremental;
        this.centralized = ccentralized;
        this.cuadLossModel = lossMod;
        this.partDem = ppartDem;
        this.Requp = Integer.parseInt(Reqprimaryup[RRequp]);
        this.Reqdn = Integer.parseInt(Reqprimarydn[RReqdn]);
        this.Reqdemup = Integer.parseInt(Reqsecdemup[RReqdemup]);
        this.Reqdemdn = Integer.parseInt(Reqsecdemdn[RReqdemdn]);
    }

    public void setRequirements(double Requpp, double Reqdnp, double Requps, double Reqdns) {
        this.dRequp = Requpp;
        this.dReqdn = Reqdnp;
        this.dReqdemup = Requps;
        this.dReqdemdn = Reqdns;
        System.out.println("Requerimientos seteados...");
    }

    public void IdidntRealize() {
        this.MySCEDFrame = null;
        this.MatG = null;
        this.MatX = null;
        this.BranchR = null;
        this.BranchX = null;
        this.BranchB = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.VarNode = null;
        this.vec_xminabs = null;
        this.vec_xmaxabs = null;
        this.vec_xmin = null;
        this.vec_xmax = null;
        this.vec_xtemp = null;
        this.vec_xtempabs = null;
        this.vec_xant = null;
        this.vec_c = null;
        this.vec_RHS = null;
        this.vec_OBJ = null;
        this.vec_lam = null;
        this.DiagMat_Q = null;
        this.node_p = null;
        this.vec_clave = null;
        this.mat_W = null;
        this.mat_A = null;
    }

    public void printReservas() {
        comp TempComponent;
        int ix = 0;
        boolean i = false;
        boolean j = false;
        int count = 0;
        int count1 = 0;
        int count2 = 0;
        double requpg = 0.0;
        double reqdng = 0.0;
        double requpl = 0.0;
        int con1 = 10000;
        int con2 = 10000;
        this.BusbarVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        this.totdem = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            System.out.println("Reserva Subida " + TempComponent.getName() + " :" + String.valueOf(Math.rint(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod + count] * this.sref * 1000.0) / 1000.0) + " [MW]");
            requpg += this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 3 * this.numgen + 3 * this.numnod + count] * this.sref;
            ++count;
        }
        System.out.println("RESERVA SUBIDA GENERADOR: " + String.valueOf(Math.rint(requpg * 1000.0) / 1000.0) + " [MW]");
        System.out.println("-----------------------------------------------");
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_inj)) continue;
            System.out.println("Reserva Bajada " + TempComponent.getName() + " :" + String.valueOf(Math.rint(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod + count1] * this.sref * 1000.0) / 1000.0) + " [MW]");
            reqdng += this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 4 * this.numgen + 3 * this.numnod + count1] * this.sref;
            ++count1;
        }
        System.out.println("RESERVA BAJADA TOTAL \t: " + String.valueOf(Math.rint(reqdng * 1000.0) / 1000.0) + " [MW]");
        System.out.println("-----------------------------------------------");
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof Load)) continue;
            System.out.println("Reserva Subida (Unserved) " + TempComponent.getName() + " :" + String.valueOf(Math.rint(this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + count2] * this.sref * 1000.0) / 1000.0) + " [MW]");
            requpl += this.vec_xtempabs[this.numcon * (this.numgen + this.numlast + this.numnod) + 5 * this.numgen + 3 * this.numnod + count2] * this.sref;
            ++count2;
        }
        System.out.println("RESERVA SUBIDA CARGAS\t: " + String.valueOf(Math.rint(requpl * 1000.0) / 1000.0) + " [MW]");
        System.out.println("RESERVA SUBIDA TOTAL \t: " + String.valueOf(Math.rint((requpl + requpg) * 1000.0) / 1000.0) + " [MW]");
        System.out.println("-----------------------------------------------");
        System.out.println("---------COSTOS MARGINALES DE RESERVA----------");
        System.out.println("Costo Marginal Reserva Primaria Subida\t    : " + String.valueOf(Math.rint(this.vec_lam[this.numnod * (this.numcon + 3)] * 1000.0 / this.sref) / 1000.0) + " [US$/MW]");
        System.out.println("Costo Marginal Reserva Primaria Bajada  \t: " + String.valueOf(Math.rint(this.vec_lam[this.numnod * (this.numcon + 3) + 1] * 1000.0 / this.sref) / 1000.0) + " [US$/MW]");
        System.out.println("Costo Marginal Reserva Secundaria Subida\t: " + String.valueOf(Math.rint(this.vec_lam[this.numnod * (this.numcon + 3) + 2] * 1000.0 / this.sref) / 1000.0) + " [US$/MW]");
        System.out.println("Costo Marginal Reserva Secundaria Bajada\t: " + String.valueOf(Math.rint(this.vec_lam[this.numnod * (this.numcon + 3) + 3] * 1000.0 / this.sref) / 1000.0) + " [US$/MW]");
    }
}

