/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.GAResult;
import de.core.NoFlickerCanvas;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

class ResultsCanvas
extends NoFlickerCanvas {
    double bestX;
    double bestY;
    int bestGen;
    long bestgenes;
    int genNum;
    double fitness;
    double improvement;

    public ResultsCanvas() {
        this.setSize(600, 50);
        this.bestX = 0.0;
        this.bestY = -1.0E20;
        this.bestGen = 0;
        this.bestgenes = 0L;
        this.genNum = 0;
        this.fitness = -1.0E20;
        this.improvement = 0.0;
        this.color = Color.lightGray;
    }

    public void setResults(GAResult results) {
        this.bestX = results.bestX;
        this.bestY = results.bestY;
        this.bestGen = results.bestGen;
        this.bestgenes = results.bestgenes;
        this.genNum = results.genNum;
        this.fitness = results.fitness;
        this.improvement = results.improvement;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int startY = 20;
        FontMetrics fm = g.getFontMetrics();
        int height = fm.getHeight();
        int incY = height + 2;
        int col1 = 125;
        int col2 = 200;
        int col3 = 282;
        int col4 = 380;
        boolean maxStrWidth = false;
        boolean curStrWidth = false;
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        g.drawString("Best Gen# ", col1, startY);
        g.drawString(new Integer(this.bestGen).toString(), col2, startY);
        g.drawString("Best gene ", col1, startY + incY);
        g.drawString(StringUtil.printf(this.bestX, 9, 1), col2, startY + incY);
        g.drawString("Best Answer ", col1, startY + 2 * incY);
        g.drawString(StringUtil.printf(-this.bestY, 9, 1), col2, startY + 2 * incY);
        g.drawString("Cur Gen# ", col3, startY);
        g.drawString(new Integer(this.genNum).toString(), col4, startY);
        g.drawString("Fitness ", col3, startY + incY);
        g.drawString(StringUtil.printf(-this.fitness, 9, 1), col4, startY + incY);
        g.drawString("Promedio ", col3, startY + 2 * incY);
        g.drawString(StringUtil.printf(this.improvement, 9, 1), col4, startY + 2 * incY);
    }
}

