/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

public class ProgressLabel
extends Canvas {
    private long TotalItems;
    private long Count;
    private int BaseX;
    private int BaseY;
    private int Percent;
    private Dimension ProgressLabelSize;
    private Image offImage;
    private Graphics offGraphics;
    private FontMetrics theFontMetrics;
    private Font theFont;

    public ProgressLabel(long NumberOfItems) {
        this.TotalItems = NumberOfItems;
        this.Count = 0L;
        this.Percent = 0;
        this.ProgressLabelSize = new Dimension(150, 15);
        this.setSize(this.ProgressLabelSize);
        this.setPreferredSize(this.ProgressLabelSize);
        this.theFont = new Font("Helvetica", 0, 10);
        this.theFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.theFont);
        this.BaseY = this.theFontMetrics.getMaxAscent();
        this.BaseX = this.ProgressLabelSize.width / 2 - this.theFontMetrics.stringWidth(" 0 Percent finished") / 2;
    }

    @Override
    public void show() {
        super.show();
    }

    public synchronized void updateProgress() {
        ++this.Count;
        this.Percent = (int)((double)this.Count / (double)this.TotalItems * 100.0);
        this.repaint();
    }

    public synchronized void updateProgress(long increment) {
        this.Count = increment;
        this.Percent = (int)((double)this.Count / (double)this.TotalItems * 100.0);
        this.repaint();
    }

    public void Reset() {
        this.Count = 0L;
        this.Percent = (int)((double)this.Count / (double)this.TotalItems * 100.0);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void repaint() {
        this.update(this.getGraphics());
    }

    @Override
    public void setFont(Font textFont) {
        this.theFont = textFont;
        this.theFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.theFont);
        this.BaseY = this.theFontMetrics.getMaxAscent();
        this.BaseX = this.ProgressLabelSize.width / 2 - this.theFontMetrics.stringWidth(" 0 Percent finished") / 2;
    }

    @Override
    public void update(Graphics g) {
        this.offImage = this.createImage(this.ProgressLabelSize.width, this.ProgressLabelSize.height);
        this.offGraphics = this.offImage.getGraphics();
        this.offGraphics.setColor(Color.black);
        this.offGraphics.setFont(this.theFont);
        this.offGraphics.drawString(this.Percent + " Percent finished", this.BaseX, this.BaseY);
        g.drawImage(this.offImage, 0, 0, this);
    }

    public int getPercent() {
        return this.Percent;
    }
}

