/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class ProgressBar
extends Canvas {
    private long TotalItems;
    private long Count;
    private int BarWidth;
    private double Percent;
    private Dimension ProgressBarSize;
    private Image offImage;
    private Graphics offGraphics;
    private Color barColor;

    public ProgressBar(long NumberOfItems) {
        this.TotalItems = NumberOfItems;
        this.Count = 0L;
        this.Percent = 0.0;
        this.ProgressBarSize = new Dimension(150, 15);
        this.resize(this.ProgressBarSize);
        this.barColor = this.getBackground();
    }

    public ProgressBar(long NumberOfItems, Color bCol, Dimension barDim) {
        this.TotalItems = NumberOfItems;
        this.Count = 0L;
        this.Percent = 0.0;
        this.ProgressBarSize = barDim;
        this.resize(this.ProgressBarSize);
        this.barColor = bCol;
    }

    @Override
    public void show() {
        super.show();
    }

    public synchronized void updateProgress() {
        ++this.Count;
        this.Percent = (double)this.Count / (double)this.TotalItems * 100.0;
        this.BarWidth = (int)(this.Percent / 100.0 * (double)(this.size().width - 1));
        this.repaint();
    }

    public synchronized void updateProgress(long increment) {
        this.Count = increment;
        this.Percent = (double)this.Count / (double)this.TotalItems * 100.0;
        this.BarWidth = (int)(this.Percent / 100.0 * (double)(this.size().width - 1));
        this.repaint();
    }

    public void Reset() {
        this.Count = 0L;
        this.Percent = (double)this.Count / (double)this.TotalItems * 100.0;
        this.BarWidth = (int)(this.Percent / 100.0 * (double)(this.size().width - 1));
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void repaint() {
        this.update(this.getGraphics());
    }

    @Override
    public void update(Graphics g) {
        this.offImage = this.createImage(this.ProgressBarSize.width, this.ProgressBarSize.height);
        this.offGraphics = this.offImage.getGraphics();
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fill3DRect(0, 0, this.ProgressBarSize.width - 1, this.ProgressBarSize.height - 1, false);
        this.offGraphics.setColor(this.barColor);
        this.offGraphics.fill3DRect(0, 0, this.BarWidth, this.ProgressBarSize.height - 1, true);
        g.drawImage(this.offImage, 0, 0, this);
    }

    public int getPercent() {
        return (int)this.Percent;
    }
}

