/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.InputPin;
import de.core.Pin;
import de.core.comp;
import de.core.ndb_comp;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

class Probe
extends ndb_comp {
    Point ChannelPos;
    Dimension ChannelDim;
    int[] LevelHistory;
    static final int MAX_HISTORY = 100;
    static int numProbes = 1;
    boolean clockup_probe = false;
    boolean clockdn_probe = false;
    int OldLevel;
    public boolean inServiceP;
    public boolean inServiceQ;
    public boolean inServiceV;
    public boolean fromLFP;
    public boolean fromLFQ;
    public boolean fromLFV;
    public double value1P;
    public double value1Q;
    public double value1V;
    public double value2P;
    public double value2Q;
    public double value2V;

    public Probe(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 3, 3, 0, 0, 3, 3, 1, 0, entryperiod, exitperiod, entrymonth, exitmonth);
        this.ChannelPos = new Point(0, 0);
        this.ChannelDim = new Dimension(0, 0);
        Integer auxx = new Integer(numProbes);
        this.setName("Probe" + auxx.toString());
        ++numProbes;
        this.ClassName = "Probe";
        this.IPin[0] = new InputPin("Probe", 0, 3, 2, -2, 0, -1, 0);
        this.RegisterPins(PinGrid, x, y);
        this.inServiceV = true;
        this.inServiceP = true;
        this.inServiceQ = true;
        this.inservice = true;
        this.fromLFV = true;
        this.fromLFP = true;
        this.fromLFQ = true;
        this.value1V = 1.0;
        this.value1P = 1.0;
        this.value1Q = 1.0;
        this.value2V = 1.0;
        this.value2P = 1.0;
        this.value2Q = 1.0;
    }

    public Probe(Pin[][] PinGrid, int x, int y, String text, boolean up, boolean dn, int entryperiod, int exitperiod, int entrymonth, int exitmonth, boolean inServiceVx, boolean inServicePx, boolean inServiceQx, boolean fromLFVx, boolean fromLFPx, boolean fromLFQx, double value1Vx, double value1Px, double value1Qx, double value2Vx, double value2Px, double value2Qx) {
        super(x, y, 3, 3, 0, 0, 3, 3, 1, 0, entryperiod, exitperiod, entrymonth, exitmonth);
        this.clockup_probe = up;
        this.clockdn_probe = dn;
        this.ChannelPos = new Point(0, 0);
        this.ChannelDim = new Dimension(0, 0);
        this.LevelHistory = new int[100];
        this.setName(text);
        this.ClassName = "Probe";
        this.IPin[0] = new InputPin(text, 0, 3, 2, -2, 0, -1, 0);
        this.RegisterPins(PinGrid, x, y);
        this.inServiceV = inServiceVx;
        this.inServiceP = inServicePx;
        this.inServiceQ = inServiceQx;
        this.inservice = this.inServiceV || this.inServiceP || this.inServiceQ;
        this.fromLFV = fromLFVx;
        this.fromLFP = fromLFPx;
        this.fromLFQ = fromLFQx;
        this.value1V = value1Vx;
        this.value1P = value1Px;
        this.value1Q = value1Qx;
        this.value2V = value2Vx;
        this.value2P = value2Px;
        this.value2Q = value2Qx;
    }

    public Probe(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.ChannelPos = new Point(0, 0);
        this.ChannelDim = new Dimension(0, 0);
    }

    @Override
    public comp Copy(int xo, int yo) {
        Probe NewComponent = new Probe(this, xo, yo);
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setexit_month(this.getexit_month());
        NewComponent.setexit_month(this.getexit_month());
        return NewComponent;
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        g.setColor(this.ProbeColor);
        if (!(this.inServiceV || this.inServiceP || this.inServiceQ)) {
            g.setColor(Color.gray);
            g.drawOval((int)(((double)x + 1.9) * (double)gs), (int)(((double)y + 0.1) * (double)gs), gs, gs);
            g.drawRect((int)(((double)x + 1.9) * (double)gs), (int)(((double)y + 0.1) * (double)gs), gs, gs);
        }
        this.DrawInputPins(g, x, y, gs);
        if (this.inServiceV) {
            g.drawOval((int)(((double)x + 1.9) * (double)gs), (int)(((double)y + 0.1) * (double)gs), gs, gs);
            g.drawOval((int)(((double)x + 1.9) * (double)gs), (int)(((double)y + 0.1) * (double)gs), gs, gs);
        }
        if (this.inServiceP || this.inServiceQ) {
            g.drawRect((int)(((double)x + 1.9) * (double)gs), (int)(((double)y + 0.1) * (double)gs), gs, gs);
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component Probe");
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.getName());
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod\t" + this.exit_period);
        myPrintStream.println(" entrymonth\t" + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" inServiceVPQ " + this.inServiceV + " " + this.inServiceP + " " + this.inServiceQ);
        myPrintStream.println(" fromLFVPQ " + this.fromLFV + " " + this.fromLFP + " " + this.fromLFQ);
        myPrintStream.println(" value1VPQ " + this.value1V + " " + this.value1P + " " + this.value1Q);
        myPrintStream.println(" value2VPQ " + this.value2V + " " + this.value2P + " " + this.value2Q);
        myPrintStream.println("end\tdescribe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO Probe (XPos, YPos, Name, entryperiod, exitperiod, entrymonth, exitmonth, inServiceV, inServiceP, inServiceQ, fromLFV, fromLFP, fromLFQ, value1V, value1P, value1Q, value2V, value2P, value2Q) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "'," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.inServiceV) + "," + String.valueOf(this.inServiceP) + "," + String.valueOf(this.inServiceQ) + "," + String.valueOf(this.fromLFV) + "," + String.valueOf(this.fromLFP) + "," + String.valueOf(this.fromLFQ) + "," + String.valueOf(this.value1V) + "," + String.valueOf(this.value1P) + "," + String.valueOf(this.value1Q) + "," + String.valueOf(this.value2V) + "," + String.valueOf(this.value2P) + "," + String.valueOf(this.value2Q) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    @Override
    public void InformConnectedComponents(int id) {
        this.con1 = " ";
        this.con2 = " ";
        for (int ii = 0; ii < this.IPin[0].ConnComps.size(); ++ii) {
            comp ConnectedComponent = (comp)this.IPin[0].ConnComps.elementAt(ii);
            if (ConnectedComponent instanceof Busbar) {
                this.setcon1(ConnectedComponent.getName());
                continue;
            }
            if (ConnectedComponent instanceof Busbar || ConnectedComponent instanceof Probe) continue;
            this.setcon2(ConnectedComponent.getName());
        }
    }

    public comp getcon2Comp() {
        comp ConnectedComponent = null;
        comp ReturnComponent = null;
        for (int ii = 0; ii < this.IPin[0].ConnComps.size(); ++ii) {
            ConnectedComponent = (comp)this.IPin[0].ConnComps.elementAt(ii);
            if (ConnectedComponent instanceof Busbar || ConnectedComponent instanceof Probe) continue;
            ReturnComponent = ConnectedComponent;
        }
        return ReturnComponent;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inServiceV")) {
            sValue = String.valueOf(this.inServiceV);
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inServiceP")) {
            sValue = String.valueOf(this.inServiceP);
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inServiceQ")) {
            sValue = String.valueOf(this.inServiceQ);
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("fromLFV")) {
            sValue = String.valueOf(this.fromLFV);
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("fromLFP")) {
            sValue = String.valueOf(this.fromLFP);
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("fromLFQ")) {
            sValue = String.valueOf(this.fromLFQ);
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("value1V")) {
            sValue = String.valueOf(this.value1V);
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("value1P")) {
            sValue = String.valueOf(this.value1P);
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("value1Q")) {
            sValue = String.valueOf(this.value1Q);
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("value2V")) {
            sValue = String.valueOf(this.value2V);
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("value2P")) {
            sValue = String.valueOf(this.value2P);
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("value2Q")) {
            sValue = String.valueOf(this.value2Q);
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inServiceV")) {
            this.inServiceV = Boolean.parseBoolean(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inServiceP")) {
            this.inServiceP = Boolean.parseBoolean(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inServiceQ")) {
            this.inServiceQ = Boolean.parseBoolean(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("fromLFV")) {
            this.fromLFV = Boolean.parseBoolean(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("fromLFP")) {
            this.fromLFV = Boolean.parseBoolean(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("fromLFQ")) {
            this.fromLFQ = Boolean.parseBoolean(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("value1V")) {
            this.value1V = Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("value1P")) {
            this.value1P = Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("value1Q")) {
            this.value1Q = Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("value2V")) {
            this.value2V = Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("value2P")) {
            this.value2P = Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("value2Q")) {
            this.value2Q = Double.parseDouble(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

