/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.PietEditFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class PietZoomFrame
extends Frame
implements AdjustmentListener {
    PietEditFrame applet;
    Scrollbar slider;
    static final int MIN_ZOOM = 1;
    static final int MAX_ZOOM = 16;
    static final int PAGE_SIZE = 1;

    public PietZoomFrame(PietEditFrame app) {
        super("Piet Zoom Control");
        this.setBackground(Color.lightGray);
        this.applet = app;
        this.setLayout(new GridLayout(1, 1));
        int SliderVal = app.getGridStep();
        this.slider = new Scrollbar(0, SliderVal, 1, 1, 16);
        this.slider.addAdjustmentListener(this);
        Panel SliderPanel = new Panel();
        SliderPanel.setLayout(new BorderLayout());
        SliderPanel.add("Center", new Label("Zoom Level", 1));
        SliderPanel.add("West", new Label("min", 0));
        SliderPanel.add("East", new Label("max", 2));
        SliderPanel.add("South", this.slider);
        this.add(SliderPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PietZoomFrame.this.setVisible(false);
                PietZoomFrame.this.applet.MyZoomFrame = null;
            }
        });
        this.setSize(200, 70);
        this.setVisible(true);
        this.setSize(200, 70);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        int GridStep = this.slider.getValue();
        this.SetNewValues(GridStep);
    }

    public void updatevalue(int grilla) {
        this.slider.setValue(grilla);
    }

    public void SetNewValues(int GridStep) {
        this.applet.setGridStep(GridStep);
        this.applet.updateZoom();
    }
}

