/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.Line;
import de.core.PietEditFrame;
import de.core.PietSchematic;
import de.core.Pin;
import de.core.comp;
import de.core.fdb_comp;
import de.core.fdb_cust;
import de.core.fdb_custFrame;
import de.core.fdb_injection;
import de.core.fdb_injectionFrame;
import de.core.fdb_link;
import de.core.fdb_linkFrame;
import de.core.fdb_storage;
import de.core.fdb_storageFrame;
import de.core.ndb_comp;
import de.core.tdb_arc;
import de.core.tdb_arcFrame;
import de.core.tdb_centroid;
import de.core.tdb_centroidFrame;
import de.core.tdb_comp;
import de.core.tdb_node;
import de.core.tdb_nodeFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

class PietSchematicPanel
extends Panel
implements AdjustmentListener {
    protected Scrollbar myHorizontal;
    protected Scrollbar myVertical;
    DeepEdit applet;
    PietEditFrame papplet;
    int GridStep;
    int hgs;
    tdb_arc NewArc = null;
    fdb_link NewLink = null;
    boolean LinkDrawing = false;
    boolean ArcDrawing = false;
    comp ComponentPressed = null;
    comp PrevSelectedComponent = null;
    int OldMouseX = 0;
    int OldMouseY = 0;
    int UOldMouseX = 0;
    int UOldMouseY = 0;
    boolean JunctionDrawing = false;
    public boolean Short = false;
    public int undox = 0;
    public int undoy = 0;
    protected Font SchematicFont;
    protected FontMetrics SchematicFontMetrics;
    static final Color BorderColor = Color.darkGray;
    public int GridXOffset = 0;
    public int GridYOffset = 0;
    public int GridXOffsetPower = 0;
    public int GridYOffsetPower = 0;
    public int GridXOffsetMarket = 0;
    public int GridYOffsetMarket = 0;
    public int GridXOffsetHydro = 0;
    public int GridYOffsetHydro = 0;
    boolean SelectBox = false;
    int SelectBoxX1;
    int SelectBoxY1;
    int SelectBoxX2;
    int SelectBoxY2;
    PietSchematic SelectSchematic;
    PietSchematic CopySchematic = null;
    public PietSchematic UndoSchematic = null;
    static final Color JunctionColor = Color.lightGray;
    boolean AutoJunction = true;
    boolean accuse = true;

    public PietSchematicPanel(PietEditFrame piet) {
        this.papplet = piet;
        this.applet = this.papplet.applet;
        this.SelectSchematic = new PietSchematic();
        this.setLayout(new BorderLayout());
        this.SchematicFont = new Font("TimesRoman", 0, 16);
        this.SchematicFontMetrics = this.getFontMetrics(this.SchematicFont);
        this.setFont(this.SchematicFont);
        super.setLayout(new BorderLayout());
        this.myVertical = new Scrollbar(1);
        this.myVertical.addAdjustmentListener(this);
        this.add("East", this.myVertical);
        this.myHorizontal = new Scrollbar(0);
        this.myHorizontal.addAdjustmentListener(this);
        this.add("South", this.myHorizontal);
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseMotionListener());
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        this.repaint();
    }

    public void Cut() {
        this.papplet.MyPietSchematic.RemoveSameElements(PietEditFrame.PinGrid, this.SelectSchematic);
        this.CopySchematic = new PietSchematic(this.SelectSchematic);
        this.SelectSchematic.RemoveAllComponents();
        this.repaint();
    }

    public void AdjustPosition(Point ppoint) {
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        int VisibleXGridPoints = this.getSize().width / this.GridStep - 1;
        int VisibleYGridPoints = this.getSize().height / this.GridStep - 1;
        int maxy = this.papplet.MaxYPoints - VisibleYGridPoints;
        int maxx = this.papplet.MaxXPoints - VisibleXGridPoints;
        this.myVertical.setValues(ppoint.y, VisibleYGridPoints, 0, DeepEdit.getMaxYPoints() + 1);
        this.myHorizontal.setValues(ppoint.x, VisibleXGridPoints, 0, DeepEdit.getMaxXPoints() + 1);
        this.CheckDimensions();
        this.repaint();
    }

    public void SendToBackComponent() {
        if (this.PrevSelectedComponent != null) {
            this.papplet.MyPietSchematic.SendToBack(this.PrevSelectedComponent);
            PietEditFrame.MyPietSchematicPanel.repaint();
        }
    }

    public void BringToFrontComponent() {
        if (this.PrevSelectedComponent != null) {
            this.papplet.MyPietSchematic.BringToFront(this.PrevSelectedComponent);
            PietEditFrame.MyPietSchematicPanel.repaint();
        }
    }

    public void EditComponent() {
        if (DeepEdit.ViewMode) {
            return;
        }
        if (this.PrevSelectedComponent != null) {
            if (this.PrevSelectedComponent instanceof tdb_node) {
                tdb_node Changetdb_node = (tdb_node)this.PrevSelectedComponent;
                if (this.papplet.MyTexttdb_nodeChangeFrame == null) {
                    this.papplet.MyTexttdb_nodeChangeFrame = new tdb_nodeFrame(this.papplet, Changetdb_node);
                }
            }
            if (this.PrevSelectedComponent instanceof tdb_centroid) {
                tdb_centroid Changetdb_centroid = (tdb_centroid)this.PrevSelectedComponent;
                if (this.papplet.MyTexttdb_centroidChangeFrame == null) {
                    this.papplet.MyTexttdb_centroidChangeFrame = new tdb_centroidFrame(this.papplet, Changetdb_centroid, this.papplet.MyPietSchematic.getactperiod(), this.papplet);
                }
            }
            if (this.PrevSelectedComponent instanceof tdb_arc) {
                tdb_arc Changetdb_arc = (tdb_arc)this.PrevSelectedComponent;
                if (this.papplet.MyTexttdb_arcChangeFrame == null) {
                    this.papplet.MyTexttdb_arcChangeFrame = new tdb_arcFrame(this.papplet, Changetdb_arc, this.papplet.MyPietSchematic.getactperiod(), this.papplet);
                }
            }
            if (this.PrevSelectedComponent instanceof fdb_injection) {
                fdb_injection Changefdb_injection = (fdb_injection)this.PrevSelectedComponent;
                if (this.papplet.MyTextfdb_injectionChangeFrame == null) {
                    this.papplet.MyTextfdb_injectionChangeFrame = new fdb_injectionFrame(this.papplet, Changefdb_injection, this.papplet.MyPietSchematic.getactperiod(), this.papplet);
                }
            }
            if (this.PrevSelectedComponent instanceof fdb_cust) {
                fdb_cust Changefdb_cust = (fdb_cust)this.PrevSelectedComponent;
                if (this.papplet.MyTextfdb_custChangeFrame == null) {
                    this.papplet.MyTextfdb_custChangeFrame = new fdb_custFrame(this.papplet, Changefdb_cust, this.papplet.MyPietSchematic.getactperiod(), this.papplet);
                }
            }
            if (this.PrevSelectedComponent instanceof fdb_link) {
                fdb_link Changefdb_link = (fdb_link)this.PrevSelectedComponent;
                if (this.papplet.MyTextfdb_linkChangeFrame == null) {
                    this.papplet.MyTextfdb_linkChangeFrame = new fdb_linkFrame(this.papplet, Changefdb_link);
                }
            }
            if (this.PrevSelectedComponent instanceof fdb_storage) {
                fdb_storage Changefdb_storage = (fdb_storage)this.PrevSelectedComponent;
                if (this.papplet.MyTextfdb_storageChangeFrame == null) {
                    this.papplet.MyTextfdb_storageChangeFrame = new fdb_storageFrame(this.papplet, Changefdb_storage, this.papplet.MyPietSchematic.getactperiod(), this.papplet);
                }
            }
        }
    }

    public void Copy() {
        this.CopySchematic = new PietSchematic(this.SelectSchematic);
    }

    public void Paste() {
        if (this.CopySchematic != null) {
            this.SelectSchematic.RemoveAllComponents();
            this.SelectSchematic = this.papplet.MyPietSchematic.PasteSchematic(PietEditFrame.PinGrid, this.CopySchematic, this.GridXOffset, this.GridYOffset);
            this.papplet.CutMenuItem.setEnabled(true);
            this.papplet.CopyMenuItem.setEnabled(true);
            if (this.papplet.EnableFileOperations) {
                this.papplet.CopyDiskMenuItem.setEnabled(true);
            }
            PietEditFrame.MyPietControlPanel.EnableButton("Cut");
            PietEditFrame.MyPietControlPanel.EnableButton("Copy");
            this.repaint();
        }
    }

    public void CopyTo() {
        this.papplet.DoFileSaveDialog(this.SelectSchematic, true, "Copy to");
    }

    public void PasteFrom() {
        PietSchematic LoadSchematic = this.papplet.DoFileOpenDialog(null, "Paste from");
        if (LoadSchematic != null) {
            LoadSchematic.setactperiod(this.papplet.MyPietSchematic.getactperiod());
            this.SelectSchematic.RemoveAllComponents();
            this.SelectSchematic = this.papplet.MyPietSchematic.PasteSchematic(PietEditFrame.PinGrid, LoadSchematic, this.GridXOffset, this.GridYOffset);
            this.papplet.MyPietSchematic.setEditor(this.papplet.getEditor());
            this.papplet.CutMenuItem.setEnabled(true);
            this.papplet.CopyMenuItem.setEnabled(true);
            if (this.papplet.EnableFileOperations) {
                this.papplet.CopyDiskMenuItem.setEnabled(true);
            }
            PietEditFrame.MyPietControlPanel.EnableButton("Cut");
            PietEditFrame.MyPietControlPanel.EnableButton("Copy");
            this.repaint();
        }
    }

    public void SelectAll() {
        this.SelectSchematic = new PietSchematic(this.papplet.MyPietSchematic);
        if (this.SelectSchematic.size() > 0) {
            this.SelectSchematic.SetAllComponentsSelected();
            this.papplet.CutMenuItem.setEnabled(true);
            this.papplet.CopyMenuItem.setEnabled(true);
            this.papplet.PasteMenuItem.setEnabled(true);
            if (this.papplet.EnableFileOperations) {
                this.papplet.CopyDiskMenuItem.setEnabled(true);
            }
            PietEditFrame.MyPietControlPanel.EnableButton("Cut");
            PietEditFrame.MyPietControlPanel.EnableButton("Copy");
            PietEditFrame.MyPietControlPanel.EnableButton("Paste");
        } else {
            this.papplet.CutMenuItem.setEnabled(false);
            this.papplet.CopyMenuItem.setEnabled(false);
            this.papplet.PasteMenuItem.setEnabled(false);
            if (this.papplet.EnableFileOperations) {
                this.papplet.CopyDiskMenuItem.setEnabled(false);
            }
            PietEditFrame.MyPietControlPanel.DisableButton("Cut");
            PietEditFrame.MyPietControlPanel.DisableButton("Copy");
            PietEditFrame.MyPietControlPanel.DisableButton("Paste");
        }
        this.repaint();
    }

    public void CheckDimensions() {
        int width = this.getSize().width;
        int height = this.getSize().height;
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        int VisibleXGridPoints = width / PietEditFrame.GridStep - 1;
        int VisibleYGridPoints = height / PietEditFrame.GridStep - 1;
        int XOverlap = VisibleXGridPoints + this.GridXOffset - this.papplet.MaxXPoints - 1;
        int YOverlap = VisibleYGridPoints + this.GridYOffset - this.papplet.MaxYPoints - 1;
        if (XOverlap > 0) {
            this.GridXOffset -= XOverlap;
            if (this.GridXOffset < 0) {
                this.GridXOffset = 0;
            }
            this.myHorizontal.setValue(this.GridXOffset);
        }
        if (YOverlap > 0) {
            this.GridYOffset -= YOverlap;
            if (this.GridYOffset < 0) {
                this.GridYOffset = 0;
            }
            this.myVertical.setValue(this.GridYOffset);
        }
    }

    public void LinkMouseDown(int x, int y) {
        this.StatusMessage("Move to the desired end position and release the mouse button.");
        this.NewLink = new fdb_link(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y), this.papplet.MyPietSchematic.getactperiod(), this.papplet.MyPietSchematic.getendperiod());
        this.NewLink.Set2ndCoord(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y));
    }

    public void LinkMouseDrag(int x, int y) {
        this.StatusMessage("Release mouse button to add the Link here.");
        if (this.NewLink != null) {
            this.NewLink.Set2ndCoord(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y));
            this.repaint();
        }
    }

    public void LinkMouseUp(int x, int y) {
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        if (this.NewLink != null) {
            if (this.NewLink.x1 == this.GetXCoord(x) && this.NewLink.y1 == this.GetYCoord(y)) {
                this.StatusMessage("Sorry - can't place a Link. Length must be minimal one gridpoint.");
                this.NewLink = null;
                return;
            }
            this.StatusMessage("Choose a position for the next link and press the mouse button.");
            this.NewLink.Set2ndCoord(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y));
            this.papplet.addComponent(this.NewLink);
            this.NewLink.CheckPosition(this.papplet);
            this.NewLink.PlacePinsHere(PietEditFrame.PinGrid);
            if (this.AutoJunction) {
                this.papplet.MyPietSchematic.PlaceJunction(PietEditFrame.PinGrid, this.NewLink.x1, this.NewLink.y1, this.GridStep);
                this.papplet.MyPietSchematic.PlaceJunction(PietEditFrame.PinGrid, this.NewLink.x2, this.NewLink.y2, this.GridStep);
            }
            this.NewLink = null;
            this.repaint();
        }
    }

    public void AdjustScrollbars() {
        this.GridXOffset = this.myHorizontal.getValue();
        this.GridYOffset = this.myVertical.getValue();
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        int VisibleXGridPoints = this.getSize().width / this.GridStep - 1;
        int VisibleYGridPoints = this.getSize().height / this.GridStep - 1;
        int maxy = this.papplet.MaxYPoints - VisibleYGridPoints;
        int maxx = this.papplet.MaxXPoints - VisibleXGridPoints;
        if (maxx < 0) {
            maxx = 0;
        }
        if (maxy < 0) {
            maxy = 0;
        }
        this.myVertical.setValues(this.GridYOffset, VisibleYGridPoints, 0, this.papplet.MaxYPoints + 1);
        this.myHorizontal.setValues(this.GridXOffset, VisibleXGridPoints, 0, this.papplet.MaxXPoints + 1);
    }

    public void DrawBorder(Graphics g) {
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        g.setColor(BorderColor);
        g.drawRect(-this.GridXOffset * this.GridStep + this.GridStep / 2, -this.GridYOffset * this.GridStep + this.GridStep / 2, (this.papplet.MaxXPoints - 1) * this.GridStep, (this.papplet.MaxYPoints - 1) * this.GridStep);
        g.setColor(this.papplet.BackGroundColor);
        g.drawLine((this.papplet.MaxXPoints - this.GridXOffset) * this.GridStep, 0, (this.papplet.MaxXPoints - this.GridXOffset) * this.GridStep, (this.papplet.MaxYPoints - this.GridYOffset) * this.GridStep);
        g.drawLine(0, (this.papplet.MaxYPoints - this.GridYOffset) * this.GridStep, (this.papplet.MaxXPoints - this.GridXOffset) * this.GridStep, (this.papplet.MaxYPoints - this.GridYOffset) * this.GridStep);
    }

    public void FillRect(Graphics g) {
        String auxs = String.valueOf(this.papplet.MyPietSchematic.getactperiod()) + "| " + this.papplet.MyPietSchematic.getactday() + "| " + this.papplet.MyPietSchematic.getacthour() + " hr";
        g.setFont(PietEditFrame.Font9);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.papplet.BackGroundColor);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.lightGray);
        g.fill3DRect(8, 8, fm.stringWidth(auxs) + 4, 16, true);
        g.setColor(Color.blue);
        g.drawString(auxs, 10, 20);
        g.setColor(Color.lightGray);
    }

    public void TellNotReady(Graphics g) {
        int cx = this.getSize().width - 15;
        int cy = this.getSize().height - 15;
        int px = cx > 500 ? (cx - 500) / 2 : 0;
        int py = cy > 500 ? (cy - 500) / 2 : 0;
        String msg = "Loading ...";
        if (this.papplet.yainit) {
            msg = "Ready ...";
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.drawImage(PietEditFrame.ImageBuffer1, px, py, Color.green, this);
        g.setColor(Color.blue);
        g.drawString(msg, 10, this.getSize().height - 30);
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (DeepEdit.ViewMode) {
            this.SelectSchematic.RemoveAllComponents();
            this.PrevSelectedComponent = null;
        }
        this.CheckDimensions();
        if (this.papplet.OffScreenWidth < this.getSize().width || this.papplet.OffScreenHeight < this.getSize().height) {
            this.update(g);
        }
        if (this.papplet.ImagesReady()) {
            g.drawImage(PietEditFrame.ImageBuffer, 0, 0, this);
        } else {
            this.TellNotReady(g);
        }
    }

    @Override
    public synchronized void update(Graphics g) {
        this.CheckDimensions();
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        if (this.applet.MyGIS != null) {
            this.applet.MyGIS.canvasMap.repaint();
        }
        if (this.papplet.OffScreenWidth < this.getSize().width || this.papplet.OffScreenHeight < this.getSize().height) {
            this.papplet.OffScreenHeight = this.getSize().height;
            this.papplet.OffScreenWidth = this.getSize().width;
            this.papplet.SetUpImages(this.GridStep);
        }
        if (!PietEditFrame.MyPietStatusPanel.SimulationRunning) {
            this.AdjustScrollbars();
        }
        if (this.papplet.ImagesReady()) {
            if (!this.SelectBox) {
                this.papplet.ibg.drawImage(PietEditFrame.ImageBuffer1, 0, 0, this);
                if (!this.Short) {
                    if (this.papplet.ShowGrid) {
                        this.papplet.ibg.drawImage(PietEditFrame.GridImage, 0, 0, this);
                    } else if (this.papplet.ShowMap && this.GridStep == 2) {
                        this.papplet.ibg.setColor(Color.lightGray);
                        this.papplet.ibg.fill3DRect(8, 8, 32, 15, true);
                        this.papplet.ibg.setFont(PietEditFrame.Font9);
                        this.papplet.ibg.setColor(Color.blue);
                        this.papplet.ibg.drawString(String.valueOf(this.papplet.MyPietSchematic.getactperiod()), 10, 20);
                        this.papplet.ibg.setColor(Color.lightGray);
                        this.Short = false;
                    } else {
                        this.FillRect(this.papplet.ibg);
                    }
                    this.DrawBorder(this.papplet.ibg);
                } else {
                    this.papplet.ibg.drawImage(PietEditFrame.ImageBuffer1, 0, 0, this);
                }
            }
            if (this.SelectBox) {
                this.papplet.ibg.drawImage(PietEditFrame.ImageBuffer1, 0, 0, this);
                this.Short = true;
                this.DrawSelectBox();
            } else {
                this.papplet.MyPietSchematic.draw((Graphics2D)this.papplet.ibg, this.GridXOffset, this.GridYOffset, this.GridXOffset + this.getSize().width / this.GridStep, this.GridYOffset + this.getSize().height / this.GridStep, this.GridStep, this.Short, PietEditFrame.MyPietStatusPanel.SimulationRunning, this.PrevSelectedComponent);
            }
            if (this.NewArc != null) {
                this.NewArc.draw((Graphics2D)this.papplet.ibg, this.GridXOffset, this.GridYOffset, this.GridStep, this.papplet.MyPietSchematic.Modifiedstate);
            }
            if (this.NewLink != null) {
                this.NewLink.draw((Graphics2D)this.papplet.ibg, this.GridXOffset, this.GridYOffset, this.GridStep, this.papplet.MyPietSchematic.Modifiedstate);
            }
            g.drawImage(PietEditFrame.ImageBuffer, 0, 0, this);
        } else {
            this.TellNotReady(g);
        }
    }

    public void DrawJunctions(Pin[][] PinGrid, Graphics g, int xo, int yo, int gs) {
        int xe = this.getSize().width / PietEditFrame.GridStep + xo - 1;
        int ye = this.getSize().height / PietEditFrame.GridStep + yo - 1;
        if (xe >= this.papplet.MaxXPoints) {
            xe = this.papplet.MaxXPoints - 1;
        }
        if (ye >= this.papplet.MaxYPoints) {
            ye = this.papplet.MaxYPoints - 1;
        }
        g.setColor(JunctionColor);
        for (int x = xo; x < xe; ++x) {
            for (int y = yo; y < ye; ++y) {
                int cCnt = PinGrid[x][y].ComponentsSize();
                if (cCnt == 2 && PinGrid[x][y].GetComponent(0) instanceof tdb_arc && PinGrid[x][y].GetComponent(1) instanceof tdb_arc || cCnt > 2) {
                    g.drawLine((x - xo) * gs - 1, (y - yo) * gs, (x - xo) * gs + 1, (y - yo) * gs);
                    g.drawLine((x - xo) * gs, (y - yo) * gs - 1, (x - xo) * gs, (y - yo) * gs + 1);
                }
                if ((cCnt != 2 || !(PinGrid[x][y].GetComponent(0) instanceof fdb_link) || !(PinGrid[x][y].GetComponent(1) instanceof fdb_link)) && cCnt <= 2) continue;
                g.drawLine((x - xo) * gs - 1, (y - yo) * gs, (x - xo) * gs + 1, (y - yo) * gs);
                g.drawLine((x - xo) * gs, (y - yo) * gs - 1, (x - xo) * gs, (y - yo) * gs + 1);
            }
        }
    }

    public void DrawSelectBox() {
        int w = Math.abs(this.SelectBoxX2 - this.SelectBoxX1);
        int h = Math.abs(this.SelectBoxY2 - this.SelectBoxY1);
        int x = this.SelectBoxX1 < this.SelectBoxX2 ? this.SelectBoxX1 : this.SelectBoxX2;
        int y = this.SelectBoxY1 < this.SelectBoxY2 ? this.SelectBoxY1 : this.SelectBoxY2;
        this.papplet.ibg.setColor(Color.lightGray);
        this.papplet.ibg.drawRect(x, y, w, h);
    }

    public int GetXCoord(int x) {
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        int xc = (x + this.hgs) / this.GridStep + this.GridXOffset;
        if (xc < 1) {
            xc = 1;
        }
        if (xc >= this.papplet.MaxXPoints) {
            xc = this.papplet.MaxXPoints - 1;
        }
        return xc;
    }

    public int GetYCoord(int y) {
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        int yc = (y + this.hgs) / this.GridStep + this.GridYOffset;
        if (yc < 1) {
            yc = 1;
        }
        if (yc >= this.papplet.MaxYPoints) {
            yc = this.papplet.MaxYPoints - 1;
        }
        return yc;
    }

    public void ArcMouseDown(int x, int y) {
        this.StatusMessage("Move to the desired end position and release the mouse button.");
        this.papplet.MyPietSchematic.Modifiedstate = true;
        this.NewArc = new tdb_arc(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y), this.papplet.MyPietSchematic.getactperiod(), this.papplet.MyPietSchematic.getendperiod());
        this.NewArc.Set2ndCoord(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y));
    }

    public void JunctionMouseDown(int x, int y) {
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        this.hgs = this.GridStep / 2;
        if (!this.papplet.MyPietSchematic.PlaceJunction(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y), this.GridStep)) {
            this.StatusMessage("Sorry, can't place a junction here. Try again.");
        } else {
            this.StatusMessage("Click again to add another junction.");
            this.repaint();
        }
    }

    public void ArcMouseDrag(int x, int y) {
        this.StatusMessage("Release mouse button to add the Arc here.");
        if (this.NewArc != null) {
            this.NewArc.Set2ndCoord(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y));
            this.repaint();
        }
    }

    public void ArcMouseUp(int x, int y) {
        if (this.NewArc != null) {
            if (this.NewArc.x1 == this.GetXCoord(x) && this.NewArc.y1 == this.GetYCoord(y)) {
                this.StatusMessage("Sorry - can't place a Arc. Length must be minimal one gridpoint.");
                this.NewArc = null;
                return;
            }
            this.StatusMessage("Choose a position for the next Arc and press the mouse button.");
            this.NewArc.Set2ndCoord(PietEditFrame.PinGrid, this.GetXCoord(x), this.GetYCoord(y));
            this.papplet.addComponent(this.NewArc);
            this.NewArc.CheckPosition(this.papplet);
            this.NewArc.PlacePinsHere(PietEditFrame.PinGrid);
            if (this.AutoJunction) {
                this.papplet.MyPietSchematic.PlaceJunction(PietEditFrame.PinGrid, this.NewArc.x1, this.NewArc.y1, this.GridStep);
                this.papplet.MyPietSchematic.PlaceJunction(PietEditFrame.PinGrid, this.NewArc.x2, this.NewArc.y2, this.GridStep);
            }
            this.NewArc = null;
            this.repaint();
        }
    }

    public void MouseDownSimulateRunning(int x, int y) {
        this.ComponentPressed = this.papplet.MyPietSchematic.CheckIfComponentClicked(this.GetXCoord(x), this.GetYCoord(y));
        if (this.ComponentPressed != null) {
            if (!this.ComponentPressed.SimMouseDown()) {
                this.StatusMessage("Sorry, cannot move component while simulating. Press 'simulate' again to stop");
            }
        } else {
            this.StatusMessage("Can't find a component here. Try again please.");
        }
    }

    public void MouseUpSimulateRunning(int x, int y) {
        if (this.ComponentPressed != null) {
            this.ComponentPressed.SimMouseUp();
        }
    }

    public void MouseDragSimulateRunning(int x, int y) {
    }

    public void DoUndoSchematic() {
        PietSchematicPanel pietSchematicPanel = this;
        this.GridStep = pietSchematicPanel.papplet.getGridStep();
        if (this.UndoSchematic != null) {
            this.papplet.MyPietSchematic = new PietSchematic(this.UndoSchematic);
        }
        if (this.SelectSchematic.size() > 0) {
            int xChange = (this.UOldMouseX - this.undox) / this.GridStep;
            int yChange = (this.UOldMouseY - this.undoy) / this.GridStep;
            if (xChange != 0 || yChange != 0) {
                this.SelectSchematic.AdjustPosition(PietEditFrame.PinGrid, xChange, yChange);
                this.papplet.MyPietSchematic.Modified = true;
                this.papplet.MyPietSchematic.Modifiedstate = true;
                DeepEdit.MySchematic.changeGIS = true;
            }
        }
    }

    public void StatusMessage(String msg) {
        this.papplet.StatusMessage(msg);
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            if (PietSchematicPanel.this.papplet.MyPietSchematic == null) {
                return;
            }
            PietEditFrame cfr_ignored_0 = PietSchematicPanel.this.papplet;
            if (PietEditFrame.MyPietStatusPanel != null) {
                PietEditFrame cfr_ignored_1 = PietSchematicPanel.this.papplet;
                PietEditFrame.MyPietStatusPanel.setposx(PietSchematicPanel.this.GetXCoord(evt.getX()));
                PietEditFrame cfr_ignored_2 = PietSchematicPanel.this.papplet;
                PietEditFrame.MyPietStatusPanel.setposy(PietSchematicPanel.this.GetYCoord(evt.getY()));
                PietEditFrame cfr_ignored_3 = PietSchematicPanel.this.papplet;
                PietEditFrame.MyPietStatusPanel.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (DeepEdit.ViewMode) {
                return;
            }
            if (PietSchematicPanel.this.papplet.MyPietSchematic == null) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            int mods = evt.getModifiers();
            if ((mods & 8) == 0 && (mods & 4) == 0) {
                PietSchematicPanel pietSchematicPanel = PietSchematicPanel.this;
                PietSchematicPanel.this.GridStep = pietSchematicPanel.papplet.getGridStep();
                PietSchematicPanel.this.hgs = PietSchematicPanel.this.GridStep / 2;
                if (x == -1 || y == -1) {
                    return;
                }
                if (PietSchematicPanel.this.ArcDrawing) {
                    PietSchematicPanel.this.ArcMouseDrag(x, y);
                    return;
                }
                if (PietSchematicPanel.this.LinkDrawing) {
                    PietSchematicPanel.this.LinkMouseDrag(x, y);
                    return;
                }
                if (PietSchematicPanel.this.JunctionDrawing) {
                    return;
                }
                if (PietSchematicPanel.this.SelectSchematic.size() > 0) {
                    int xChange = (x - PietSchematicPanel.this.OldMouseX) / PietSchematicPanel.this.GridStep;
                    int yChange = (y - PietSchematicPanel.this.OldMouseY) / PietSchematicPanel.this.GridStep;
                    if (xChange != 0 || yChange != 0) {
                        PietSchematicPanel.this.OldMouseX = x - (x - PietSchematicPanel.this.OldMouseX) % PietSchematicPanel.this.GridStep;
                        PietSchematicPanel.this.OldMouseY = y - (y - PietSchematicPanel.this.OldMouseY) % PietSchematicPanel.this.GridStep;
                        PietEditFrame cfr_ignored_0 = PietSchematicPanel.this.papplet;
                        PietSchematicPanel.this.SelectSchematic.AdjustPosition(PietEditFrame.PinGrid, xChange, yChange);
                        PietSchematicPanel.this.papplet.MyPietSchematic.Modified = true;
                        PietSchematicPanel.this.papplet.MyPietSchematic.Modifiedstate = true;
                        if (PietSchematicPanel.this.SelectSchematic.size() == 1) {
                            PietSchematicPanel.this.Short = true;
                        }
                        PietSchematicPanel.this.repaint();
                    }
                } else if (PietSchematicPanel.this.SelectBox) {
                    PietSchematicPanel.this.SelectBoxX2 = x;
                    PietSchematicPanel.this.SelectBoxY2 = y;
                    PietSchematicPanel.this.repaint();
                }
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (PietSchematicPanel.this.papplet.MyPietSchematic == null) {
                return;
            }
            int mods = evt.getModifiers();
            Point position = new Point();
            comp SelectedComponent = null;
            int x = evt.getX();
            int y = evt.getY();
            double auxr = 0.0;
            double ueb = 0.0;
            double res = 0.0;
            double z = 0.0;
            double reac = 0.0;
            double sref = 0.0;
            double b = 0.0;
            double rserie = 0.0;
            double xserie = 0.0;
            double gshunt = 0.0;
            double bshunt = 0.0;
            PietSchematicPanel.this.SelectBox = false;
            PietSchematicPanel.this.UndoSchematic = new PietSchematic(PietSchematicPanel.this.papplet.MyPietSchematic);
            PietEditFrame cfr_ignored_0 = PietSchematicPanel.this.papplet;
            PietEditFrame cfr_ignored_1 = PietSchematicPanel.this.papplet;
            PietSchematicPanel.this.papplet.gg.drawImage(PietEditFrame.ImageBuffer, 0, 0, PietEditFrame.MyPietSchematicPanel);
            if (PietSchematicPanel.this.ArcDrawing) {
                PietSchematicPanel.this.ArcMouseDown(x, y);
                return;
            }
            if (PietSchematicPanel.this.LinkDrawing) {
                PietSchematicPanel.this.LinkMouseDown(x, y);
                return;
            }
            if (PietSchematicPanel.this.JunctionDrawing) {
                PietSchematicPanel.this.JunctionMouseDown(x, y);
                return;
            }
            SelectedComponent = PietSchematicPanel.this.papplet.MyPietSchematic.CheckIfComponentClicked(PietSchematicPanel.this.GetXCoord(x), PietSchematicPanel.this.GetYCoord(y));
            if (SelectedComponent != null && SelectedComponent instanceof tdb_comp) {
                DeepEdit cfr_ignored_2 = PietSchematicPanel.this.applet;
                DeepEdit.MySchematic.changeGIS = true;
            }
            if (SelectedComponent != null && SelectedComponent instanceof fdb_comp) {
                DeepEdit cfr_ignored_3 = PietSchematicPanel.this.applet;
                DeepEdit.MySchematic.changeGIS = true;
            }
            if ((mods & 4) != 0 && PietSchematicPanel.this.GridStep < 16) {
                SelectedComponent = null;
                position.x = PietSchematicPanel.this.GetXCoord(x);
                position.y = PietSchematicPanel.this.GetYCoord(y);
                PietSchematicPanel pietSchematicPanel = PietSchematicPanel.this;
                PietSchematicPanel.this.papplet.setGridStep(pietSchematicPanel.papplet.getGridStep() + 1);
                PietSchematicPanel pietSchematicPanel2 = PietSchematicPanel.this;
                int auxint1 = PietSchematicPanel.this.getSize().width / pietSchematicPanel2.papplet.getGridStep() / 2;
                PietSchematicPanel pietSchematicPanel3 = PietSchematicPanel.this;
                int auxint2 = PietSchematicPanel.this.getSize().height / pietSchematicPanel3.papplet.getGridStep() / 2;
                if (evt.getClickCount() == 2) {
                    PietSchematicPanel.this.papplet.setGridStep(14);
                    auxint1 = PietSchematicPanel.this.getSize().width / 56;
                    auxint2 = PietSchematicPanel.this.getSize().height / 56;
                }
                position.x -= auxint1;
                position.y -= auxint2;
                PietSchematicPanel.this.AdjustPosition(position);
                if (PietSchematicPanel.this.papplet.MyZoomFrame != null) {
                    PietSchematicPanel pietSchematicPanel4 = PietSchematicPanel.this;
                    PietSchematicPanel.this.papplet.MyZoomFrame.SetNewValues(pietSchematicPanel4.papplet.getGridStep());
                }
                return;
            }
            if ((mods & 8) != 0 && PietSchematicPanel.this.GridStep > 1) {
                SelectedComponent = null;
                position.x = PietSchematicPanel.this.GetXCoord(x);
                position.y = PietSchematicPanel.this.GetYCoord(y);
                PietSchematicPanel pietSchematicPanel = PietSchematicPanel.this;
                PietSchematicPanel.this.papplet.setGridStep(pietSchematicPanel.papplet.getGridStep() - 1);
                if (evt.getClickCount() == 2) {
                    PietSchematicPanel.this.papplet.setGridStep(2);
                }
                PietSchematicPanel pietSchematicPanel5 = PietSchematicPanel.this;
                int auxint1 = PietSchematicPanel.this.getSize().width / pietSchematicPanel5.papplet.getGridStep() / 2;
                PietSchematicPanel pietSchematicPanel6 = PietSchematicPanel.this;
                int auxint2 = PietSchematicPanel.this.getSize().height / pietSchematicPanel6.papplet.getGridStep() / 2;
                position.x -= auxint1;
                position.y -= auxint2;
                PietSchematicPanel.this.AdjustPosition(position);
                if (PietSchematicPanel.this.papplet.MyZoomFrame != null) {
                    PietSchematicPanel pietSchematicPanel7 = PietSchematicPanel.this;
                    PietSchematicPanel.this.papplet.MyZoomFrame.SetNewValues(pietSchematicPanel7.papplet.getGridStep());
                }
                return;
            }
            if (SelectedComponent != null && (mods & 0x10) != 0) {
                if (evt.getClickCount() == 2 && SelectedComponent instanceof tdb_arc && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    tdb_arc Changetdb_arc = (tdb_arc)PietSchematicPanel.this.PrevSelectedComponent;
                    if (PietSchematicPanel.this.papplet.MyTexttdb_arcChangeFrame == null) {
                        PietSchematicPanel.this.papplet.MyTexttdb_arcChangeFrame = new tdb_arcFrame(PietSchematicPanel.this.papplet, Changetdb_arc, PietSchematicPanel.this.papplet.MyPietSchematic.getactperiod(), PietSchematicPanel.this.papplet);
                    }
                }
                if (evt.getClickCount() == 2 && SelectedComponent instanceof tdb_node && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    tdb_node Changetdb_node = (tdb_node)PietSchematicPanel.this.PrevSelectedComponent;
                    if (PietSchematicPanel.this.papplet.MyTexttdb_nodeChangeFrame == null) {
                        PietSchematicPanel.this.papplet.MyTexttdb_nodeChangeFrame = new tdb_nodeFrame(PietSchematicPanel.this.papplet, Changetdb_node);
                    }
                }
                if (evt.getClickCount() == 2 && SelectedComponent instanceof tdb_centroid && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    tdb_centroid Changetdb_centroid = (tdb_centroid)PietSchematicPanel.this.PrevSelectedComponent;
                    if (PietSchematicPanel.this.papplet.MyTexttdb_centroidChangeFrame == null) {
                        PietSchematicPanel.this.papplet.MyTexttdb_centroidChangeFrame = new tdb_centroidFrame(PietSchematicPanel.this.papplet, Changetdb_centroid, PietSchematicPanel.this.papplet.MyPietSchematic.getactperiod(), PietSchematicPanel.this.papplet);
                    }
                }
                if (evt.getClickCount() == 2 && SelectedComponent instanceof fdb_injection && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    fdb_injection Changefdb_injection = (fdb_injection)PietSchematicPanel.this.PrevSelectedComponent;
                    if (PietSchematicPanel.this.papplet.MyTextfdb_injectionChangeFrame == null) {
                        PietSchematicPanel.this.papplet.MyTextfdb_injectionChangeFrame = new fdb_injectionFrame(PietSchematicPanel.this.papplet, Changefdb_injection, PietSchematicPanel.this.papplet.MyPietSchematic.getactperiod(), PietSchematicPanel.this.papplet);
                    }
                }
                if (evt.getClickCount() == 2 && SelectedComponent instanceof fdb_link && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    fdb_link Changefdb_link = (fdb_link)PietSchematicPanel.this.PrevSelectedComponent;
                    if (PietSchematicPanel.this.papplet.MyTextfdb_linkChangeFrame == null) {
                        PietSchematicPanel.this.papplet.MyTextfdb_linkChangeFrame = new fdb_linkFrame(PietSchematicPanel.this.papplet, Changefdb_link);
                    }
                }
                if (evt.getClickCount() == 2 && SelectedComponent instanceof fdb_cust && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    fdb_cust Changefdb_cust = (fdb_cust)PietSchematicPanel.this.PrevSelectedComponent;
                    if (PietSchematicPanel.this.papplet.MyTextfdb_custChangeFrame == null) {
                        PietSchematicPanel.this.papplet.MyTextfdb_custChangeFrame = new fdb_custFrame(PietSchematicPanel.this.papplet, Changefdb_cust, PietSchematicPanel.this.papplet.MyPietSchematic.getactperiod(), PietSchematicPanel.this.papplet);
                    }
                }
                if (evt.getClickCount() == 2 && SelectedComponent instanceof fdb_storage && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    fdb_storage Changefdb_storage = (fdb_storage)PietSchematicPanel.this.PrevSelectedComponent;
                    if (PietSchematicPanel.this.papplet.MyTextfdb_storageChangeFrame == null) {
                        PietSchematicPanel.this.papplet.MyTextfdb_storageChangeFrame = new fdb_storageFrame(PietSchematicPanel.this.papplet, Changefdb_storage, PietSchematicPanel.this.papplet.MyPietSchematic.getactperiod(), PietSchematicPanel.this.papplet);
                    }
                }
                if (evt.getClickCount() == 2 && SelectedComponent == PietSchematicPanel.this.PrevSelectedComponent) {
                    PietSchematicPanel.this.EditComponent();
                }
                PietSchematicPanel.this.PrevSelectedComponent = SelectedComponent;
                PietSchematicPanel.this.PrevSelectedComponent = SelectedComponent;
                if (PietSchematicPanel.this.SelectSchematic.size() > 0 && !PietSchematicPanel.this.SelectSchematic.InSchematic(SelectedComponent)) {
                    if (evt.isShiftDown()) {
                        SelectedComponent.setSelected(true);
                        PietSchematicPanel.this.SelectSchematic.addComponent(SelectedComponent);
                        if (SelectedComponent instanceof Line) {
                            Line templine = (Line)SelectedComponent;
                            PietSchematicPanel pietSchematicPanel = PietSchematicPanel.this;
                            PietEditFrame cfr_ignored_4 = PietSchematicPanel.this.papplet;
                            templine.draw((Graphics2D)PietSchematicPanel.this.papplet.ibg, PietSchematicPanel.this.GridXOffset, PietSchematicPanel.this.GridYOffset, pietSchematicPanel.papplet.getGridStep(), PietSchematicPanel.this.papplet.MyPietSchematic.Modifiedstate, PietEditFrame.MyPietStatusPanel.SimulationRunning, PietSchematicPanel.this.papplet.MyPietSchematic.cycle, PietSchematicPanel.this.papplet.MyPietSchematic.ShowReactive, PietSchematicPanel.this.papplet.MyPietSchematic.getsref(), PietSchematicPanel.this.papplet.MyPietSchematic.getactperiod(), PietSchematicPanel.this.papplet.MyPietSchematic.getactmonth(), PietSchematicPanel.this.papplet.MyPietSchematic.gettypsim());
                        } else if (SelectedComponent instanceof tdb_arc) {
                            tdb_arc temptdb_arc = (tdb_arc)SelectedComponent;
                            PietSchematicPanel pietSchematicPanel = PietSchematicPanel.this;
                            temptdb_arc.draw((Graphics2D)PietSchematicPanel.this.papplet.ibg, PietSchematicPanel.this.GridXOffset, PietSchematicPanel.this.GridYOffset, pietSchematicPanel.papplet.getGridStep(), PietSchematicPanel.this.papplet.MyPietSchematic.Modifiedstate);
                        } else if (SelectedComponent instanceof fdb_link) {
                            fdb_link tempfdb_link = (fdb_link)SelectedComponent;
                            PietSchematicPanel pietSchematicPanel = PietSchematicPanel.this;
                            tempfdb_link.draw((Graphics2D)PietSchematicPanel.this.papplet.ibg, PietSchematicPanel.this.GridXOffset, PietSchematicPanel.this.GridYOffset, pietSchematicPanel.papplet.getGridStep(), PietSchematicPanel.this.papplet.MyPietSchematic.Modifiedstate);
                        } else {
                            PietSchematicPanel pietSchematicPanel = PietSchematicPanel.this;
                            SelectedComponent.draw((Graphics2D)PietSchematicPanel.this.papplet.ibg, PietSchematicPanel.this.GridXOffset, PietSchematicPanel.this.GridYOffset, pietSchematicPanel.papplet.getGridStep());
                        }
                    } else {
                        PietSchematicPanel.this.SelectSchematic.RemoveAllComponents();
                    }
                }
                if (PietSchematicPanel.this.SelectSchematic.size() > 0) {
                    PietEditFrame cfr_ignored_5 = PietSchematicPanel.this.papplet;
                    PietSchematicPanel.this.SelectSchematic.RemovePinsGrid(PietEditFrame.PinGrid);
                    if (PietSchematicPanel.this.SelectSchematic.size() > 1) {
                        PietSchematicPanel.this.StatusMessage("Move all components to the desired position and release the mouse button.");
                    } else {
                        comp TempComponent = (comp)PietSchematicPanel.this.SelectSchematic.Components.elementAt(0);
                        PietSchematicPanel.this.StatusMessage("Move this " + TempComponent.getName() + " to the desired position and release the mouse button.");
                    }
                } else {
                    SelectedComponent.setSelected(true);
                    PietSchematicPanel.this.SelectSchematic.addComponent(SelectedComponent);
                    if (!(SelectedComponent instanceof ndb_comp)) {
                        PietSchematicPanel.this.StatusMessage("Move this " + SelectedComponent.getName() + " to the desired position and release the mouse button.");
                    }
                    PietEditFrame cfr_ignored_6 = PietSchematicPanel.this.papplet;
                    SelectedComponent.RemovePinsGrid(PietEditFrame.PinGrid);
                }
                PietSchematicPanel.this.OldMouseX = x;
                PietSchematicPanel.this.OldMouseY = y;
                PietSchematicPanel.this.UOldMouseX = x;
                PietSchematicPanel.this.UOldMouseY = y;
            } else {
                PietSchematicPanel.this.SelectSchematic.RemoveAllComponents();
                PietSchematicPanel.this.SelectBox = true;
                PietSchematicPanel.this.SelectBoxX1 = PietSchematicPanel.this.SelectBoxX2 = x;
                PietSchematicPanel.this.SelectBoxY1 = PietSchematicPanel.this.SelectBoxY2 = y;
                if (PietSchematicPanel.this.PrevSelectedComponent != null) {
                    PietSchematicPanel.this.repaint();
                }
                PietSchematicPanel.this.PrevSelectedComponent = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (PietSchematicPanel.this.papplet.MyPietSchematic == null) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            if (PietSchematicPanel.this.papplet.UndoMenuItem != null) {
                PietSchematicPanel.this.papplet.UndoMenuItem.setEnabled(true);
                PietSchematicPanel.this.undox = x;
                PietSchematicPanel.this.undoy = y;
            }
            if (PietSchematicPanel.this.papplet.HelpWanted) {
                comp HelpComponent = PietSchematicPanel.this.papplet.MyPietSchematic.CheckIfComponentClicked(PietSchematicPanel.this.GetXCoord(x), PietSchematicPanel.this.GetYCoord(y));
                if (HelpComponent != null) {
                    // empty if block
                }
                return;
            }
            if (PietSchematicPanel.this.ArcDrawing) {
                PietSchematicPanel.this.ArcMouseUp(x, y);
                return;
            }
            if (PietSchematicPanel.this.LinkDrawing) {
                PietSchematicPanel.this.LinkMouseUp(x, y);
                return;
            }
            if (PietSchematicPanel.this.JunctionDrawing) {
                return;
            }
            if (PietSchematicPanel.this.SelectBox) {
                PietSchematicPanel.this.Short = false;
                PietSchematicPanel.this.SelectBox = false;
                PietSchematicPanel.this.repaint();
                PietSchematicPanel.this.papplet.MyPietSchematic.CheckIfComponentsInSelectBox(PietSchematicPanel.this.SelectSchematic, PietSchematicPanel.this.GetXCoord(PietSchematicPanel.this.SelectBoxX1), PietSchematicPanel.this.GetYCoord(PietSchematicPanel.this.SelectBoxY1), PietSchematicPanel.this.GetXCoord(PietSchematicPanel.this.SelectBoxX2), PietSchematicPanel.this.GetYCoord(PietSchematicPanel.this.SelectBoxY2));
            }
            if (PietSchematicPanel.this.SelectSchematic.size() > 0) {
                PietSchematicPanel.this.SelectSchematic.CheckPosition(PietSchematicPanel.this.papplet);
                PietEditFrame cfr_ignored_0 = PietSchematicPanel.this.papplet;
                PietSchematicPanel.this.SelectSchematic.PlacePinsHere(PietEditFrame.PinGrid);
                if (PietSchematicPanel.this.SelectSchematic.size() == 1) {
                    PietSchematicPanel.this.Short = false;
                }
                PietSchematicPanel.this.papplet.CutMenuItem.setEnabled(true);
                PietSchematicPanel.this.papplet.CopyMenuItem.setEnabled(true);
                if (PietSchematicPanel.this.papplet.EnableFileOperations) {
                    PietSchematicPanel.this.papplet.CopyDiskMenuItem.setEnabled(true);
                }
                PietEditFrame cfr_ignored_1 = PietSchematicPanel.this.papplet;
                PietEditFrame.MyPietControlPanel.EnableButton("Cut");
                PietEditFrame cfr_ignored_2 = PietSchematicPanel.this.papplet;
                PietEditFrame.MyPietControlPanel.EnableButton("Copy");
            } else {
                PietSchematicPanel.this.papplet.CutMenuItem.setEnabled(false);
                PietSchematicPanel.this.papplet.CopyMenuItem.setEnabled(false);
                if (PietSchematicPanel.this.papplet.EnableFileOperations) {
                    PietSchematicPanel.this.papplet.CopyDiskMenuItem.setEnabled(false);
                }
                PietEditFrame cfr_ignored_3 = PietSchematicPanel.this.papplet;
                PietEditFrame.MyPietControlPanel.DisableButton("Cut");
                PietEditFrame cfr_ignored_4 = PietSchematicPanel.this.papplet;
                PietEditFrame.MyPietControlPanel.DisableButton("Copy");
            }
            PietSchematicPanel.this.repaint();
        }
    }
}

