/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.Caption;
import de.core.DeepEdit;
import de.core.FileFormatException;
import de.core.Ga;
import de.core.Generator;
import de.core.Injection;
import de.core.JMapObject;
import de.core.LaunchProgressFrame;
import de.core.Line;
import de.core.Load;
import de.core.PietEditFrame;
import de.core.Pin;
import de.core.SVC;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.fdb_Probe;
import de.core.fdb_comp;
import de.core.fdb_cust;
import de.core.fdb_custDialog;
import de.core.fdb_injection;
import de.core.fdb_link;
import de.core.fdb_storage;
import de.core.ndb_1pol;
import de.core.ndb_comp;
import de.core.ndb_inj;
import de.core.planpro;
import de.core.tdb_Probe;
import de.core.tdb_arc;
import de.core.tdb_centroid;
import de.core.tdb_comp;
import de.core.tdb_node;
import de.utils.StringUtil;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.List;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class PietSchematic {
    boolean accuse1 = false;
    static BufferedReader din = new BufferedReader(new InputStreamReader(System.in));
    protected Vector Components = new Vector();
    protected Vector OptimizationComponents;
    public boolean Modified = false;
    public boolean Modifiedstate = true;
    public boolean cycle = false;
    public boolean changeGIS = false;
    public int count = 0;
    boolean ShowReactive = true;
    String focusowner = "NO FOCUS";
    public String FileDir = null;
    public String state = "------";
    String message = null;
    public String FileName = "untitled";
    int SimulateCycleID = 0;
    comp TempComponent;
    String OSName;
    private static final long BITMASK = (long)Math.pow(2.0, 64.0) - 1L;
    protected double sref = 100.0;
    protected double intrate = 10.0;
    protected double convergence = 0.01;
    protected double loadfac1 = 0.0;
    protected double loadfac2 = 1.0;
    protected String sysname = "New_Name";
    protected String actday = "___";
    protected String actdaytype = "___";
    protected String acthour = "___";
    protected int iniperiod = 2001;
    protected int endperiod = 2010;
    protected int actperiod = 2001;
    protected int inimonth = 1;
    protected int endmonth = 12;
    protected int actmonth = 1;
    protected int stepperiod = 1;
    protected int stepmonth = 1;
    protected int nitera = 40;
    protected int tiposimula = 0;
    protected int typsim = 0;
    protected boolean customsim = false;
    protected boolean peaksim = true;
    protected boolean meansim = false;
    protected boolean lowsim = false;
    protected int codebit = 0;
    protected int numoptimize = 0;
    protected double fitnes = 0.0;
    protected double totcost = 0.0;
    protected double totgen = 0.0;
    protected double totunser = 0.0;
    protected double totloss = 0.0;
    protected double totdem = 0.0;

    public PietSchematic() {
        this.sref = 100.0;
        this.intrate = 10.0;
        this.loadfac1 = 0.0;
        this.loadfac2 = 1.0;
        this.sysname = null;
        this.iniperiod = 2001;
        this.endperiod = 2010;
        this.actperiod = 2001;
        this.actday = "___";
        this.actdaytype = "___";
        this.acthour = "___";
        this.stepperiod = 1;
        this.customsim = false;
        this.peaksim = true;
        this.meansim = false;
        this.lowsim = false;
        this.nitera = 40;
        this.tiposimula = 0;
        this.typsim = 0;
        this.codebit = 0;
        this.numoptimize = 0;
        this.fitnes = 0.0;
        this.focusowner = "NO FOCUS";
    }

    public PietSchematic(PietSchematic SchematicToCopy) {
        for (int ix = 0; ix < SchematicToCopy.size(); ++ix) {
            comp TempComponent = (comp)SchematicToCopy.Components.elementAt(ix);
            this.Components.addElement(TempComponent);
        }
    }

    public String getsysname() {
        return this.sysname;
    }

    public double getsref() {
        return this.sref;
    }

    public double getloadfac1() {
        return this.loadfac1;
    }

    public double getloadfac2() {
        return this.loadfac2;
    }

    public double getintrate() {
        return this.intrate;
    }

    public int getiniperiod() {
        return this.iniperiod;
    }

    public int getendperiod() {
        return this.endperiod;
    }

    public int getactperiod() {
        return this.actperiod;
    }

    public int getstepperiod() {
        return this.stepperiod;
    }

    public int getinimonth() {
        return this.inimonth;
    }

    public int getendmonth() {
        return this.endmonth;
    }

    public int getactmonth() {
        return this.actmonth;
    }

    public int getstepmonth() {
        return this.stepmonth;
    }

    public boolean getpeaksim() {
        return this.peaksim;
    }

    public boolean getcustomsim() {
        return this.customsim;
    }

    public boolean getmeansim() {
        return this.meansim;
    }

    public boolean getlowsim() {
        return this.lowsim;
    }

    public int getnitera() {
        return this.nitera;
    }

    public double getconvergence() {
        return this.convergence;
    }

    public int gettiposimula() {
        return this.tiposimula;
    }

    public int gettypsim() {
        return this.typsim;
    }

    public int getcodebit() {
        return this.codebit;
    }

    public int getnumoptimize() {
        return this.numoptimize;
    }

    public double getfitnes() {
        return this.fitnes;
    }

    public double gettotcost() {
        return this.totcost;
    }

    public double gettotgen() {
        return this.totgen;
    }

    public double gettotunser() {
        return this.totunser;
    }

    public double gettotloss() {
        return this.totloss;
    }

    public double gettotdem() {
        return this.totdem;
    }

    public String getfocusowner() {
        return this.focusowner;
    }

    public String getactday() {
        return this.actday;
    }

    public String getactdaytype() {
        return this.actdaytype;
    }

    public String getacthour() {
        return this.acthour;
    }

    public Vector getcomponents() {
        return this.Components;
    }

    public void setsref(double n) {
        this.sref = n;
    }

    public void setloadfac1(double n) {
        this.loadfac1 = n;
    }

    public void setloadfac2(double n) {
        this.loadfac2 = n;
    }

    public void setintrate(double n) {
        this.intrate = n;
    }

    public void setsysname(String n) {
        this.sysname = n;
    }

    public void setactday(String n) {
        this.actday = n;
    }

    public void setactdaytype(String n) {
        this.actdaytype = n;
    }

    public void setacthour(String n) {
        this.acthour = n;
    }

    public void setiniperiod(int n) {
        this.iniperiod = n;
    }

    public void setendperiod(int n) {
        this.endperiod = n;
    }

    public void setactperiod(int n) {
        this.actperiod = n;
    }

    public void setstepperiod(int n) {
        this.stepperiod = n;
    }

    public void setinimonth(int n) {
        this.inimonth = n;
    }

    public void setendmonth(int n) {
        this.endmonth = n;
    }

    public void setactmonth(int n) {
        this.actmonth = n;
    }

    public void setstepmonth(int n) {
        this.stepmonth = n;
    }

    public void setpeaksim(boolean n) {
        this.peaksim = n;
    }

    public void setcustomsim(boolean n) {
        this.customsim = n;
    }

    public void setmeansim(boolean n) {
        this.meansim = n;
    }

    public void setlowsim(boolean n) {
        this.lowsim = n;
    }

    public void setnitera(int n) {
        this.nitera = n;
    }

    public void setconvergence(double n) {
        this.convergence = n;
    }

    public void settiposimula(int n) {
        this.tiposimula = n;
    }

    public void settypsim(int n) {
        this.typsim = n;
    }

    public void setcodebit(int n) {
        this.codebit = n;
    }

    public void setnumoptimize(int n) {
        this.numoptimize = n;
    }

    public void setfitnes(double n) {
        this.fitnes = n;
    }

    public void settotgen(double n) {
        this.totgen = n;
    }

    public void settotcost(double n) {
        this.totcost = n;
    }

    public void settotunser(double n) {
        this.totunser = n;
    }

    public void settotloss(double n) {
        this.totloss = n;
    }

    public void settotdem(double n) {
        this.totdem = n;
    }

    public void setfocusowner(String n) {
        this.focusowner = n;
    }

    public Vector getProbes() {
        Vector<comp> v = new Vector<comp>();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (TempComponent instanceof tdb_Probe) {
                v.addElement(TempComponent);
            }
            if (!(TempComponent instanceof fdb_Probe)) continue;
            v.addElement(TempComponent);
        }
        return v;
    }

    public PietSchematic PasteSchematic(Pin[][] PinGrid, PietSchematic CopySchematic, int Xoff, int Yoff) {
        comp TempComponent;
        int ix;
        PietSchematic NewSelectSchematic = new PietSchematic();
        int MinX = -1;
        int MinY = -1;
        this.Modified = true;
        this.Modifiedstate = true;
        for (ix = 0; ix < CopySchematic.size(); ++ix) {
            int WireYMin;
            int WireXMin;
            TempComponent = (comp)CopySchematic.Components.elementAt(ix);
            if (TempComponent instanceof fdb_link) {
                fdb_link TempLink = (fdb_link)TempComponent;
                WireXMin = Math.min(TempLink.x1, TempLink.x2);
                WireYMin = Math.min(TempLink.y1, TempLink.y2);
                if (MinX == -1 || WireXMin < MinX) {
                    MinX = WireXMin - 1;
                }
                if (MinY != -1 && WireYMin >= MinY) continue;
                MinY = WireYMin - 1;
                continue;
            }
            if (TempComponent instanceof tdb_arc) {
                tdb_arc TempArc = (tdb_arc)TempComponent;
                WireXMin = Math.min(TempArc.x1, TempArc.x2);
                WireYMin = Math.min(TempArc.y1, TempArc.y2);
                if (MinX == -1 || WireXMin < MinX) {
                    MinX = WireXMin - 1;
                }
                if (MinY != -1 && WireYMin >= MinY) continue;
                MinY = WireYMin - 1;
                continue;
            }
            if (MinX == -1 || TempComponent.Pos.x < MinX) {
                MinX = TempComponent.Pos.x;
            }
            if (MinY != -1 && TempComponent.Pos.y >= MinY) continue;
            MinY = TempComponent.Pos.y;
        }
        for (ix = 0; ix < CopySchematic.size(); ++ix) {
            TempComponent = (comp)CopySchematic.Components.elementAt(ix);
            comp NewComponent = TempComponent.Copy(MinX - Xoff, MinY - Yoff);
            NewComponent.PlacePinsHere(PinGrid);
            TempComponent.setSelected(false);
            NewComponent.setSelected(true);
            if (TempComponent instanceof fdb_link) {
                fdb_link fdb_link2 = (fdb_link)NewComponent;
            }
            if (TempComponent instanceof tdb_arc) {
                tdb_arc tdb_arc2 = (tdb_arc)NewComponent;
            }
            this.addComponent(NewComponent);
            NewSelectSchematic.addComponent(NewComponent);
        }
        return NewSelectSchematic;
    }

    public void SetAllComponentsSelected() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.setSelected(true);
            if (!(TempComponent instanceof fdb_link)) continue;
            fdb_link TempContract = (fdb_link)TempComponent;
            TempContract.ChangingWire = 3;
        }
    }

    public void CodeSchematic(Ga ga, PrintStream report) {
        int numbit = 0;
        this.OptimizationComponents = new Vector();
        this.setcodebit(0);
        this.setnumoptimize(0);
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof planpro)) continue;
            planpro Tempplanpro = (planpro)TempComponent;
            ++this.numoptimize;
            this.OptimizationComponents.addElement(Tempplanpro);
        }
        double raux = Math.log(this.endperiod - this.iniperiod + 1) / Math.log(2.0);
        this.codebit = (int)Math.ceil(raux);
        numbit = this.numoptimize * this.codebit;
        System.out.println("Periodos      : " + (this.endperiod - this.iniperiod + 1));
        System.out.println("Codebit       : " + this.codebit);
        System.out.println("Numoptimize   : " + this.numoptimize);
        System.out.println("Numbit        : " + numbit);
        report.println("Periodos      : " + (this.endperiod - this.iniperiod + 1));
        report.println("Codebit       : " + this.codebit);
        report.println("Numoptimize   : " + this.numoptimize);
        report.println("Numbit        : " + numbit);
    }

    public void EvalSchematic(long genes, PrintStream report, int[] estadoenperiodo) {
        long bitmask = BITMASK << this.getcodebit() - 1;
        bitmask ^= 0xFFFFFFFFFFFFFFFFL;
        for (int ip = 0; ip < this.getendperiod() - this.getiniperiod() + 1; ++ip) {
            estadoenperiodo[ip] = 0;
        }
        for (int ix = 0; ix < this.OptimizationComponents.size(); ++ix) {
            planpro Tempplanpro = (planpro)this.OptimizationComponents.elementAt(ix);
            int auxint = (int)(genes & bitmask);
            if (auxint != 0) {
                int ip = auxint - 1;
                while (ip < this.getendperiod() - this.getiniperiod() + 1) {
                    int n = ip++;
                    estadoenperiodo[n] = estadoenperiodo[n] + (int)Math.pow(2.0, ix);
                }
            }
            Tempplanpro.setentry(auxint, this.getiniperiod(), this.getendperiod());
            genes >>= this.getcodebit();
        }
    }

    public void EvalSchematic(long genes, PrintStream report) {
        long bitmask = BITMASK << this.getcodebit() - 1;
        bitmask ^= 0xFFFFFFFFFFFFFFFFL;
        for (int ix = 0; ix < this.OptimizationComponents.size(); ++ix) {
            planpro Tempplanpro = (planpro)this.OptimizationComponents.elementAt(ix);
            int auxint = (int)(genes & bitmask);
            Tempplanpro.setentry(auxint, this.getiniperiod(), this.getendperiod());
            genes >>= this.getcodebit();
        }
    }

    public void drawBestGene(Graphics g, Dimension d, long genes, Point orig) {
        double ytickStep = orig.y / (this.numoptimize + 1);
        double x = orig.x;
        double y = 0.0;
        double xtickStep = ((double)d.width - (double)orig.x) / (double)(this.endperiod - this.iniperiod);
        long bitmask = BITMASK << this.getcodebit() - 1;
        bitmask ^= 0xFFFFFFFFFFFFFFFFL;
        for (int ix = 0; ix < this.OptimizationComponents.size(); ++ix) {
            planpro Tempplanpro = (planpro)this.OptimizationComponents.elementAt(ix);
            int auxint = (int)(genes & bitmask);
            if (auxint != 0) {
                g.setColor(Color.black);
                g.drawString(Tempplanpro.getText(), 4, (int)((double)(ix + 1) * ytickStep));
                g.setColor(Color.red);
                g.fillRect((int)((double)orig.x + (double)(auxint - 1) * xtickStep), (int)((double)(ix + 1) * ytickStep - ytickStep / 3.0), (int)((double)orig.x + (double)(Math.min(Tempplanpro.getexit_period(), this.endperiod) - (this.getiniperiod() + auxint - 1)) * xtickStep), (int)(ytickStep / 3.0 * 2.0));
                g.setColor(Color.black);
                g.drawRect((int)((double)orig.x + (double)(auxint - 1) * xtickStep), (int)((double)(ix + 1) * ytickStep - ytickStep / 3.0), (int)((double)orig.x + (double)(Math.min(Tempplanpro.getexit_period(), this.endperiod) - (this.getiniperiod() + auxint - 1)) * xtickStep), (int)(ytickStep / 3.0 * 2.0));
            }
            genes >>= this.getcodebit();
        }
    }

    public void RemoveSameElements(Pin[][] PinGrid, PietSchematic ActSchematic) {
        this.Modified = true;
        this.Modifiedstate = true;
        for (int ix = 0; ix < ActSchematic.size(); ++ix) {
            comp TempComponent = (comp)ActSchematic.Components.elementAt(ix);
            if (!this.Components.contains(TempComponent)) continue;
            TempComponent.RemovePinsGrid(PinGrid);
            this.Components.removeElement(TempComponent);
        }
    }

    public void DestroyComponents(Pin[][] PinGrid) {
        this.Modified = true;
        this.Modifiedstate = true;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.RemovePinsGrid(PinGrid);
        }
        this.Components.removeAllElements();
    }

    public double EvalInvest() {
        double sum = 0.0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
        }
        return sum;
    }

    public Point AdjustTopLeft() {
        Point ret = new Point(10000, 10000);
        Point PosCom = new Point();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid()) continue;
            if (TempComponent instanceof fdb_link) {
                fdb_link Tempfdb_link = (fdb_link)TempComponent;
                PosCom.x = Math.min(Tempfdb_link.x1, Tempfdb_link.x2);
                PosCom.y = Math.min(Tempfdb_link.y1, Tempfdb_link.y2);
            } else {
                PosCom.x = TempComponent.Pos.x;
                PosCom.y = TempComponent.Pos.y;
            }
            if (PosCom.x < ret.x) {
                ret.x = PosCom.x;
            }
            if (PosCom.y >= ret.y) continue;
            ret.y = PosCom.y;
        }
        return ret;
    }

    public Point AdjustSearchName(String searchname) {
        Point ret = new Point(100000, 100000);
        Point PosCom = new Point();
        int fin = this.Components.size();
        for (int ix = 0; ix < fin; ++ix) {
            String string2;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            String string1 = this.TempComponent.getName();
            if (!string1.equalsIgnoreCase(string2 = searchname) || !this.TempComponent.getvalid()) continue;
            this.TempComponent.setSelected(true);
            return PosCom;
        }
        return ret;
    }

    public boolean check_ndb_inj(String injname) {
        for (int ixx = 0; ixx < this.Components.size(); ++ixx) {
            tdb_comp Tempunit;
            comp TempComponent = (comp)this.Components.elementAt(ixx);
            if (!(TempComponent instanceof tdb_comp) || !(Tempunit = (tdb_comp)TempComponent).getName().equals(injname)) continue;
            return false;
        }
        return true;
    }

    public void LoadOwner(List MyList, String oowner, fdb_custDialog mydialog) {
        int selec = 0;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            Load TempLoad;
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Load) || ((TempLoad = (Load)TempComponent).getinv_owner().hashCode() != oowner.hashCode() || !TempLoad.getinv_owner().equals(oowner)) && (TempLoad.getinv_owner().hashCode() != "Power".hashCode() || !TempLoad.getinv_owner().equals("None"))) continue;
            ++selec;
            MyList.addItem(TempLoad.getName());
            mydialog.v.addElement(TempLoad);
            if (!TempLoad.getinv_owner().equals(oowner)) continue;
            MyList.select(selec - 1);
        }
    }

    public void tdb_loads(List MyList) {
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Load)) continue;
            Load TempLoad = (Load)TempComponent;
            compare = false;
            for (int iv = 0; iv < this.Components.size(); ++iv) {
                comp TempComponent2 = (comp)this.Components.elementAt(iv);
                if (!(TempComponent2 instanceof tdb_comp)) continue;
                tdb_comp TempTDB = (tdb_comp)TempComponent2;
                if (!TempLoad.getName().equals(TempTDB.getmy_e_consumption())) continue;
                iv = this.Components.size();
                compare = true;
            }
            if (compare) continue;
            MyList.addItem(TempLoad.getName());
        }
    }

    public void addComponent(comp NewComponent) {
        this.Modified = true;
        this.Modifiedstate = true;
        this.Components.addElement(NewComponent);
    }

    public void fdb_Generator(List MyList) {
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Generator)) continue;
            Generator TempGx = (Generator)TempComponent;
            compare = false;
            for (int iv = 0; iv < this.Components.size(); ++iv) {
                comp TempComponent2 = (comp)this.Components.elementAt(iv);
                if (!(TempComponent2 instanceof fdb_cust)) continue;
                fdb_cust TempFDB = (fdb_cust)TempComponent2;
                if (!TempGx.getName().equals(TempFDB.getcon_object())) continue;
                iv = this.Components.size();
                compare = true;
            }
            if (compare) continue;
            MyList.addItem(TempGx.getName());
        }
    }

    public void fdb_Centroid(List MyList) {
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            tdb_centroid TempCe = (tdb_centroid)TempComponent;
            compare = false;
            for (int iv = 0; iv < this.Components.size(); ++iv) {
                comp TempComponent2 = (comp)this.Components.elementAt(iv);
                if (!(TempComponent2 instanceof fdb_cust)) continue;
                fdb_cust TempFDB = (fdb_cust)TempComponent2;
                if (!TempCe.getName().equals(TempFDB.getcon_object())) continue;
                iv = this.Components.size();
                compare = true;
            }
            if (compare) continue;
            MyList.addItem(TempCe.getName());
        }
    }

    public void fdb_Node(List MyList) {
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_node)) continue;
            tdb_node TempNo = (tdb_node)TempComponent;
            compare = false;
            for (int iv = 0; iv < this.Components.size(); ++iv) {
                comp TempComponent2 = (comp)this.Components.elementAt(iv);
                if (!(TempComponent2 instanceof fdb_cust)) continue;
                fdb_cust TempFDB = (fdb_cust)TempComponent2;
                if (!TempNo.getName().equals(TempFDB.getcon_object())) continue;
                iv = this.Components.size();
                compare = true;
            }
            if (compare) continue;
            MyList.addItem(TempNo.getName());
        }
    }

    public void fdb_Arc(List MyList) {
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_arc)) continue;
            tdb_arc TempAr = (tdb_arc)TempComponent;
            compare = false;
            for (int iv = 0; iv < this.Components.size(); ++iv) {
                comp TempComponent2 = (comp)this.Components.elementAt(iv);
                if (!(TempComponent2 instanceof fdb_cust)) continue;
                fdb_cust TempFDB = (fdb_cust)TempComponent2;
                if (!TempAr.getName().equals(TempFDB.getcon_object())) continue;
                iv = this.Components.size();
                compare = true;
            }
            if (compare) continue;
            MyList.addItem(TempAr.getName());
        }
    }

    public String getTdbLoad(String loadname) {
        if (loadname.equals("NONE")) {
            return "NONE";
        }
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            Load TempLoad;
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Load) || !(TempLoad = (Load)TempComponent).getName().equals(loadname)) continue;
            return loadname;
        }
        return "NONE";
    }

    public void AllOwner(Choice MyChoice) {
        Vector<ndb_comp> v = new Vector<ndb_comp>();
        boolean compare = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp)) continue;
            ndb_comp TempElComponent = (ndb_comp)TempComponent;
            compare = false;
            for (int iv = 0; iv < v.size(); ++iv) {
                ndb_comp TempElComponentb = (ndb_comp)v.elementAt(iv);
                if (!TempElComponent.getinv_owner().equals(TempElComponentb.getinv_owner())) continue;
                compare = true;
            }
            if (compare) continue;
            v.addElement(TempElComponent);
            MyChoice.addItem(TempElComponent.getinv_owner());
        }
    }

    public void RepeatName(FileOutputStream os) throws IOException, FileFormatException {
        comp TempComponentb;
        comp TempComponent;
        int ix = 0;
        int iv = 0;
        Vector<comp> v = new Vector<comp>();
        Vector<comp> vv = new Vector<comp>();
        boolean compare = false;
        boolean correct = true;
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        myPrintStream.println("---------------------------");
        myPrintStream.println("Looking for doubled names: ");
        myPrintStream.println("---------------------------");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_comp)) continue;
            compare = false;
            for (iv = 0; iv < v.size(); ++iv) {
                TempComponentb = (comp)v.elementAt(iv);
                if (!TempComponent.getName().equalsIgnoreCase(TempComponentb.getName())) continue;
                myPrintStream.println("Double Name by Transport-Component: " + TempComponent.getName());
                compare = true;
                correct = false;
            }
            if (compare) continue;
            v.addElement(TempComponent);
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_comp)) continue;
            compare = false;
            for (iv = 0; iv < vv.size(); ++iv) {
                TempComponentb = (comp)vv.elementAt(iv);
                if (!TempComponent.getName().equalsIgnoreCase(TempComponentb.getName())) continue;
                myPrintStream.println("Double Name by Fuel-Component: " + TempComponent.getName());
                compare = true;
                correct = false;
            }
            if (compare) continue;
            vv.addElement(TempComponent);
        }
        if (correct) {
            myPrintStream.println("--- No double names in the System ---");
        }
        myPrintStream.println("--------------------------------");
        myPrintStream.println("End Statistics:");
        myPrintStream.println("-------------------------------");
        os.close();
    }

    public fdb_injection replaceFInjection(fdb_injection Actfdb_injection, int newpines, PietEditFrame papplet) {
        fdb_injection NewComponent = new fdb_injection(PietEditFrame.PinGrid, newpines, Actfdb_injection.Pos.x, Actfdb_injection.Pos.y, Actfdb_injection.getName(), Actfdb_injection.getinv_type(), Actfdb_injection.getinv_owner(), Actfdb_injection.getinv_cost(), Actfdb_injection.getlife_time(), Actfdb_injection.getentry_period(), Actfdb_injection.getexit_period(), Actfdb_injection.getLatitude(), Actfdb_injection.getLongitude(), Actfdb_injection.getorigin(), Actfdb_injection.getf_capacity(), Actfdb_injection.getmy_f_modes(), Actfdb_injection.getf_capacity_unit(), Actfdb_injection.getf_mode_capacity(), Actfdb_injection.get_f_inj_emissions());
        this.Components.addElement(NewComponent);
        Actfdb_injection.RemovePinsGrid(PietEditFrame.PinGrid);
        this.Components.removeElement(Actfdb_injection);
        return NewComponent;
    }

    public fdb_cust replaceFCust(fdb_cust Actfdb_cust, int newpines, PietEditFrame papplet) {
        fdb_cust NewComponent = new fdb_cust(PietEditFrame.PinGrid, newpines, Actfdb_cust.Pos.x, Actfdb_cust.Pos.y, Actfdb_cust.getName(), Actfdb_cust.getinv_type(), Actfdb_cust.getinv_owner(), Actfdb_cust.getinv_cost(), Actfdb_cust.getlife_time(), Actfdb_cust.getentry_period(), Actfdb_cust.getexit_period(), Actfdb_cust.getLatitude(), Actfdb_cust.getLongitude(), Actfdb_cust.getmy_f_zone(), Actfdb_cust.getconsumption_grate2(), Actfdb_cust.getconsumption_ini2(), Actfdb_cust.getmy_f_modes(), Actfdb_cust.getnetwork_flag(), Actfdb_cust.getcon_object(), Actfdb_cust.get_f_cus_emissions());
        this.Components.addElement(NewComponent);
        Actfdb_cust.RemovePinsGrid(PietEditFrame.PinGrid);
        this.Components.removeElement(Actfdb_cust);
        return NewComponent;
    }

    public void draw(Graphics2D g, int x, int y, int x2, int y2, int GridStep, boolean Short2, boolean Simulate, comp PrevSelectedComponent) {
        comp TempComponent = PrevSelectedComponent;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!TempComponent.CheckIfComponentInDrawArea(x, y, x2, y2) || !TempComponent.getactive() || !TempComponent.getvalid()) continue;
            TempComponent.draw(g, x, y, GridStep, this.Modifiedstate);
        }
    }

    public int size() {
        return this.Components.size();
    }

    public void RemoveAllComponents() {
        this.Modified = true;
        this.Modifiedstate = true;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.setSelected(false);
        }
        this.Components.removeAllElements();
    }

    public boolean InSchematic(comp ActComponent) {
        return this.Components.contains(ActComponent);
    }

    public void CheckIfComponentsInSelectBox(PietSchematic SelectSchematic, int x1, int y1, int x2, int y2) {
        int swap;
        if (x1 > x2) {
            swap = x1;
            x1 = x2;
            x2 = swap;
        }
        if (y1 > y2) {
            swap = y1;
            y1 = y2;
            y2 = swap;
        }
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.CheckIfComponentInSelectBox(x1, y1, x2, y2)) continue;
            SelectSchematic.addComponent(TempComponent);
        }
    }

    public void AdjustPosition(Pin[][] PinGrid, int x, int y) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.AdjustPosition(PinGrid, x, y);
        }
    }

    public void RemovePinsGrid(Pin[][] PinGrid) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.RemovePinsGrid(PinGrid);
        }
    }

    public void CheckPosition(PietEditFrame app) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.CheckPosition(app);
        }
    }

    public void CheckActive() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.CheckActive(this.getactperiod(), this.getactmonth());
        }
    }

    public boolean assignJMap(JMapObject mo) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            fdb_link TempLink;
            tdb_arc TempArc;
            Line TempLine;
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (TempComponent instanceof Line && mo.getObjType().equals("line") && (TempLine = (Line)TempComponent).getName().equals(mo.getLabel())) {
                TempLine.setmo(mo);
                return true;
            }
            if (TempComponent instanceof tdb_arc && mo.getObjType().equals("tdbarc") && (TempArc = (tdb_arc)TempComponent).getName().equals(mo.getLabel())) {
                TempArc.setmo(mo);
                return true;
            }
            if (!(TempComponent instanceof fdb_link) || !mo.getObjType().equals("fdblink") || !(TempLink = (fdb_link)TempComponent).getName().equals(mo.getLabel())) continue;
            TempLink.setmo(mo);
            return true;
        }
        return false;
    }

    public void setEditor(int n) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.setvalid(false);
            if (n == 1) {
                if (!(TempComponent instanceof tdb_comp)) continue;
                TempComponent.setvalid(true);
                continue;
            }
            if (!(TempComponent instanceof fdb_comp)) continue;
            TempComponent.setvalid(true);
        }
    }

    public void PlacePinsHere(Pin[][] PinGrid) {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.PlacePinsHere(PinGrid);
        }
    }

    public comp CheckIfComponentClicked(int x, int y) {
        for (int ix = this.Components.size() - 1; ix > -1; --ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.CheckIfComponentClicked(x, y)) continue;
            return TempComponent;
        }
        return null;
    }

    public void SimulateSetUpFlows() {
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.SimulateSetUpFlows(this.sref);
        }
    }

    protected Color StringToColor(String clr) {
        if ("red".hashCode() == clr.hashCode() && "red".equals(clr)) {
            return Color.red;
        }
        if ("green".hashCode() == clr.hashCode() && "green".equals(clr)) {
            return Color.green;
        }
        if ("blue".hashCode() == clr.hashCode() && "blue".equals(clr)) {
            return Color.blue;
        }
        if ("yellow".hashCode() == clr.hashCode() && "yellow".equals(clr)) {
            return Color.yellow;
        }
        if ("pink".hashCode() == clr.hashCode() && "pink".equals(clr)) {
            return Color.pink;
        }
        if ("black".hashCode() == clr.hashCode() && "black".equals(clr)) {
            return Color.black;
        }
        if ("lightGray".hashCode() == clr.hashCode() && "lightGray".equals(clr)) {
            return Color.lightGray;
        }
        if ("gray".hashCode() == clr.hashCode() && "gray".equals(clr)) {
            return Color.gray;
        }
        return Color.red;
    }

    protected String NsrToPiet(String clr) {
        if ("NDB_gen".equals(clr)) {
            clr = "ndb_inj";
            return clr;
        }
        if ("NDB_node".equals(clr)) {
            clr = "Busbar";
            return clr;
        }
        if ("NDB_load".equals(clr)) {
            clr = "Load";
            return clr;
        }
        if ("NDB_line".equals(clr)) {
            clr = "Line";
            return clr;
        }
        if ("NDB_tran".equals(clr)) {
            clr = "Trafo";
            return clr;
        }
        if ("NDB_wheel".equals(clr)) {
            clr = "fdb_link";
            return clr;
        }
        if ("System".equals(clr)) {
            clr = "System";
            return clr;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean LoadComponent(Pin[][] PinGrid, LineNumberReader is, StreamTokenizer st) throws IOException, FileFormatException {
        XPos = 0;
        YPos = 0;
        XPos2 = 0;
        YPos2 = 0;
        xpoly = new int[32];
        ypoly = new int[32];
        ComponentName = st.sval;
        Text = " ";
        type = "None";
        owner = "None";
        ctrla = " ";
        place = " ";
        AuxText = " ";
        project = "NONE";
        alternative = "NONE";
        un1 = 0.0;
        un2 = 0.0;
        ur1 = 0.0;
        ur2 = 0.0;
        umin = 0.9;
        umax = 1.1;
        sn = 0.0;
        us = 1.0;
        latitude = 0.0;
        longitude = 0.0;
        sst = 0.0;
        smax = 0.0;
        sc = 1.0;
        cost = 0.0;
        alpha = 0.0;
        beta = 0.0;
        gamma = 0.0;
        verhor = true;
        swapPS = false;
        suggest = false;
        lifetime = 0;
        lftype = 1;
        lftypes = 1;
        entryperiod = this.iniperiod;
        exitperiod = this.endperiod;
        entrymonth = 1;
        exitmonth = 12;
        num = 2;
        prio = 0;
        planning = 0;
        maxt = 0;
        sollt = 0;
        pmax = 0.0;
        pmin = 0.0;
        qmax = 0.0;
        qmin = 0.0;
        p0 = 0.0;
        q0 = 0.0;
        pini = 0.0;
        qini = 0.0;
        r1 = 0.0;
        xx1 = 0.0;
        b1 = 0.0;
        g1 = 0.0;
        len = 0.0;
        incomep = 0.0;
        incomeq = 0.0;
        uk = 0.0;
        pcu = 0.0;
        pfe = 0.0;
        i0 = 0.0;
        z0z1 = 0.0;
        r0x0 = 0.0;
        pwheel = 0.0;
        qwheel = 0.0;
        energy = 0.0;
        ldc_T = 0.0;
        ldc_pmin = 0.0;
        ldc_pmax = 0.0;
        grate = 0.0;
        pcontract = 0.0;
        qcontract = 0.0;
        zsl = 0.0;
        inj = " ";
        load = " ";
        currency = " ";
        npoly = 0;
        nmodes = 0;
        fmc = 0;
        cgr = 0;
        ci = 0;
        fmf = false;
        ngemissions = 0;
        g_emissions = new double[9];
        p_fuel = 0.0;
        mytmodes = new int[7];
        tdbcapacity = 0.0;
        tdblength = 0.0;
        tdbflujo = 0.0;
        tdbvelocidad = 0.0;
        tdbload = " ";
        f_arc_emissions = new double[9];
        nfarcemissions = 0;
        region = "none";
        f_cent_emissions = new double[9];
        nfcentemissions = 0;
        gentravelini = 0.0;
        arrivtravelini = 0.0;
        grategen = 0.0;
        gratearriv = 0.0;
        f_capacity = 0.0;
        f_unit = "m3";
        my_f_modes = 1;
        numpines = 26;
        length = 0.0;
        flow = 0.0;
        f_inj_emissions = new double[9];
        f_cus_emissions = new double[9];
        f_link_emissions = new double[9];
        f_sto_emissions = new double[9];
        nfinjemissions = 0;
        nfcusemissions = 0;
        nflinkemissions = 0;
        nfstoemissions = 0;
        my_f_zone = "NONE";
        network_flag = "NONE";
        con_object = "NONE";
        origin = "NONE";
        f_capacity_unit = "m3";
        f_mode_capacity = new double[26];
        f_mode_flow = new double[26];
        consumption_grate = new double[26];
        consumption_ini = new double[26];
        sto_capacity = 0.0;
        sto_capacity_unit = "m3";
        fuel_type = "Crudo";
        ini_state = 0.0;
        state = 0.0;
        this.OSName = System.getProperty("os.name");
        block4: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("pos".equals(st.sval) && "pos".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            XPos = (int)st.nval;
                            if (st.nextToken() == -2) {
                                YPos = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("pospoly".equals(st.sval) && "pospoly".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            xpoly[++npoly - 1] = (int)st.nval;
                            if (st.nextToken() == -2) {
                                ypoly[npoly - 1] = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("Name".hashCode() == st.sval.hashCode() && "Name".equals(st.sval)) {
                        Text = is.readLine();
                        continue block4;
                    }
                    if ("sysname".hashCode() == st.sval.hashCode() && "sysname".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        this.setsysname(String.valueOf(st.sval));
                        continue block4;
                    }
                    if ("project".hashCode() == st.sval.hashCode() && "project".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        project = String.valueOf(st.sval);
                        continue block4;
                    }
                    if ("alternative".hashCode() == st.sval.hashCode() && "alternative".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        alternative = String.valueOf(st.sval);
                        continue block4;
                    }
                    if ("sref".hashCode() == st.sval.hashCode() && "sref".equals(st.sval)) {
                        AuxText = is.readLine();
                        this.sref = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("loadfac1".hashCode() == st.sval.hashCode() && "loadfac1".equals(st.sval)) {
                        AuxText = is.readLine();
                        this.loadfac1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("loadfac2".hashCode() == st.sval.hashCode() && "loadfac2".equals(st.sval)) {
                        AuxText = is.readLine();
                        this.loadfac2 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("intrate".hashCode() == st.sval.hashCode() && "intrate".equals(st.sval)) {
                        AuxText = is.readLine();
                        this.intrate = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("iniperiod".hashCode() == st.sval.hashCode() && "iniperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.iniperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("planning".hashCode() == st.sval.hashCode() && "planning".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            planning = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("endperiod".hashCode() == st.sval.hashCode() && "endperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.endperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("actperiod".hashCode() == st.sval.hashCode() && "actperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.actperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("actday".hashCode() == st.sval.hashCode() && "actday".equals(st.sval)) {
                        this.setactday(String.valueOf(is.readLine()));
                        continue block4;
                    }
                    if ("actdaytype".hashCode() == st.sval.hashCode() && "actdaytype".equals(st.sval)) {
                        this.setactdaytype(String.valueOf(is.readLine()));
                        continue block4;
                    }
                    if ("acthour".hashCode() == st.sval.hashCode() && "acthour".equals(st.sval)) {
                        this.setacthour(String.valueOf(is.readLine()));
                        continue block4;
                    }
                    if ("stepperiod".hashCode() == st.sval.hashCode() && "stepperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            this.stepperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("peaksim".hashCode() == st.sval.hashCode() && "peaksim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        this.peaksim = Boolean.valueOf(st.sval);
                        continue block4;
                    }
                    if ("meansim".hashCode() == st.sval.hashCode() && "meansim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        this.meansim = Boolean.valueOf(st.sval);
                        continue block4;
                    }
                    if ("lowsim".hashCode() == st.sval.hashCode() && "lowsim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        this.lowsim = Boolean.valueOf(st.sval);
                        continue block4;
                    }
                    if ("customsim".hashCode() == st.sval.hashCode() && "customsim".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        this.customsim = Boolean.valueOf(st.sval);
                        continue block4;
                    }
                    if ("load".hashCode() == st.sval.hashCode() && "load".equals(st.sval)) {
                        load = is.readLine();
                        continue block4;
                    }
                    if ("inj".hashCode() == st.sval.hashCode() && "inj".equals(st.sval)) {
                        inj = is.readLine();
                        continue block4;
                    }
                    if ("type".hashCode() == st.sval.hashCode() && "type".equals(st.sval)) {
                        type = is.readLine();
                        continue block4;
                    }
                    if ("owner".hashCode() == st.sval.hashCode() && "owner".equals(st.sval)) {
                        owner = is.readLine();
                        if (!owner.equals("null")) continue block4;
                        owner = "None";
                        continue block4;
                    }
                    if ("ctrla".hashCode() == st.sval.hashCode() && "ctrla".equals(st.sval)) {
                        ctrla = is.readLine();
                        continue block4;
                    }
                    if ("place".hashCode() == st.sval.hashCode() && "place".equals(st.sval)) {
                        place = is.readLine();
                        continue block4;
                    }
                    if ("currency".hashCode() == st.sval.hashCode() && "currency".equals(st.sval)) {
                        currency = is.readLine();
                        continue block4;
                    }
                    if ("ldc_T".hashCode() == st.sval.hashCode() && "ldc_T".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_T = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("ldc_pmax".hashCode() == st.sval.hashCode() && "ldc_pmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_pmax = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("ldc_pmin".hashCode() == st.sval.hashCode() && "ldc_pmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_pmin = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("un1".hashCode() == st.sval.hashCode() && "un1".equals(st.sval)) {
                        AuxText = is.readLine();
                        un1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("ur1".hashCode() == st.sval.hashCode() && "ur1".equals(st.sval)) {
                        AuxText = is.readLine();
                        ur1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("ur2".hashCode() == st.sval.hashCode() && "ur2".equals(st.sval)) {
                        AuxText = is.readLine();
                        ur2 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("latitude".hashCode() == st.sval.hashCode() && "latitude".equals(st.sval)) {
                        AuxText = is.readLine();
                        latitude = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("longitude".hashCode() == st.sval.hashCode() && "longitude".equals(st.sval)) {
                        AuxText = is.readLine();
                        longitude = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("us".hashCode() == st.sval.hashCode() && "us".equals(st.sval)) {
                        AuxText = is.readLine();
                        us = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("un2".hashCode() == st.sval.hashCode() && "un2".equals(st.sval)) {
                        AuxText = is.readLine();
                        un2 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("umin".hashCode() == st.sval.hashCode() && "umin".equals(st.sval)) {
                        AuxText = is.readLine();
                        umin = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("umax".hashCode() == st.sval.hashCode() && "umax".equals(st.sval)) {
                        AuxText = is.readLine();
                        umax = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("sn".hashCode() == st.sval.hashCode() && "sn".equals(st.sval)) {
                        AuxText = is.readLine();
                        sn = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("st".hashCode() == st.sval.hashCode() && "st".equals(st.sval)) {
                        AuxText = is.readLine();
                        sst = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("smax".hashCode() == st.sval.hashCode() && "smax".equals(st.sval)) {
                        AuxText = is.readLine();
                        smax = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("sc".hashCode() == st.sval.hashCode() && "sc".equals(st.sval)) {
                        AuxText = is.readLine();
                        sc = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("energy".hashCode() == st.sval.hashCode() && "energy".equals(st.sval)) {
                        AuxText = is.readLine();
                        energy = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("pwheel".hashCode() == st.sval.hashCode() && "pwheel".equals(st.sval)) {
                        AuxText = is.readLine();
                        pwheel = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("qwheel".hashCode() == st.sval.hashCode() && "qwheel".equals(st.sval)) {
                        AuxText = is.readLine();
                        qwheel = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("pcontract".hashCode() == st.sval.hashCode() && "pcontract".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcontract = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("qcontract".hashCode() == st.sval.hashCode() && "qcontract".equals(st.sval)) {
                        AuxText = is.readLine();
                        qcontract = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("cost".hashCode() == st.sval.hashCode() && "cost".equals(st.sval)) {
                        AuxText = is.readLine();
                        cost = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("verhor".hashCode() == st.sval.hashCode() && "verhor".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        verhor = Boolean.valueOf(st.sval);
                        continue block4;
                    }
                    if ("suggest".hashCode() == st.sval.hashCode() && "suggest".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        suggest = Boolean.valueOf(st.sval);
                        continue block4;
                    }
                    if ("swapPS".hashCode() == st.sval.hashCode() && "swapPS".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block4;
                        swapPS = Boolean.valueOf(st.sval);
                        continue block4;
                    }
                    if ("gemissions".equals(st.sval) && "gemissions".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            g_emissions[++ngemissions - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("pfuel".hashCode() == st.sval.hashCode() && "pfuel".equals(st.sval)) {
                        AuxText = is.readLine();
                        p_fuel = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("alpha".hashCode() == st.sval.hashCode() && "alpha".equals(st.sval)) {
                        AuxText = is.readLine();
                        alpha = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("beta".hashCode() == st.sval.hashCode() && "beta".equals(st.sval)) {
                        AuxText = is.readLine();
                        beta = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("gamma".hashCode() == st.sval.hashCode() && "gamma".equals(st.sval)) {
                        AuxText = is.readLine();
                        gamma = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("grate".hashCode() == st.sval.hashCode() && "grate".equals(st.sval)) {
                        AuxText = is.readLine();
                        grate = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("pmax".hashCode() == st.sval.hashCode() && "pmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        pmax = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("pmin".hashCode() == st.sval.hashCode() && "pmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        pmin = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("p0".hashCode() == st.sval.hashCode() && "p0".equals(st.sval)) {
                        AuxText = is.readLine();
                        p0 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("q0".hashCode() == st.sval.hashCode() && "q0".equals(st.sval)) {
                        AuxText = is.readLine();
                        q0 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("qmax".hashCode() == st.sval.hashCode() && "qmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        qmax = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("qmin".hashCode() == st.sval.hashCode() && "qmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        qmin = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("r1".hashCode() == st.sval.hashCode() && "r1".equals(st.sval)) {
                        AuxText = is.readLine();
                        r1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("xx1".hashCode() == st.sval.hashCode() && "xx1".equals(st.sval)) {
                        AuxText = is.readLine();
                        xx1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("b1".hashCode() == st.sval.hashCode() && "b1".equals(st.sval)) {
                        AuxText = is.readLine();
                        b1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("g1".hashCode() == st.sval.hashCode() && "g1".equals(st.sval)) {
                        AuxText = is.readLine();
                        g1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("pini".hashCode() == st.sval.hashCode() && "pini".equals(st.sval)) {
                        AuxText = is.readLine();
                        pini = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("incomep".hashCode() == st.sval.hashCode() && "incomep".equals(st.sval)) {
                        AuxText = is.readLine();
                        incomep = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("incomeq".hashCode() == st.sval.hashCode() && "incomeq".equals(st.sval)) {
                        AuxText = is.readLine();
                        incomeq = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("uk".hashCode() == st.sval.hashCode() && "uk".equals(st.sval)) {
                        AuxText = is.readLine();
                        uk = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("pcu".hashCode() == st.sval.hashCode() && "pcu".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcu = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("pfe".hashCode() == st.sval.hashCode() && "pfe".equals(st.sval)) {
                        AuxText = is.readLine();
                        pfe = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("i0".hashCode() == st.sval.hashCode() && "i0".equals(st.sval)) {
                        AuxText = is.readLine();
                        i0 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("z0z1".hashCode() == st.sval.hashCode() && "z0z1".equals(st.sval)) {
                        AuxText = is.readLine();
                        z0z1 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("r0x0".hashCode() == st.sval.hashCode() && "r0x0".equals(st.sval)) {
                        AuxText = is.readLine();
                        r0x0 = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("qini".hashCode() == st.sval.hashCode() && "qini".equals(st.sval)) {
                        AuxText = is.readLine();
                        qini = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("len".hashCode() == st.sval.hashCode() && "len".equals(st.sval)) {
                        AuxText = is.readLine();
                        len = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("lifetime".hashCode() == st.sval.hashCode() && "lifetime".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            lifetime = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("lftype".hashCode() == st.sval.hashCode() && "lftype".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            lftype = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("lftypes".hashCode() == st.sval.hashCode() && "lftypes".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            lftypes = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("prio".hashCode() == st.sval.hashCode() && "prio".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            prio = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("num".hashCode() == st.sval.hashCode() && "num".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            num = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("zsl".hashCode() == st.sval.hashCode() && "zsl".equals(st.sval)) {
                        AuxText = is.readLine();
                        zsl = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("maxt".hashCode() == st.sval.hashCode() && "maxt".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            maxt = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("sollt".hashCode() == st.sval.hashCode() && "sollt".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            sollt = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("entryperiod".hashCode() == st.sval.hashCode() && "entryperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            entryperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("exitperiod".hashCode() == st.sval.hashCode() && "exitperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            exitperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("entrymonth".hashCode() == st.sval.hashCode() && "entrymonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            entrymonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("exitmonth".hashCode() == st.sval.hashCode() && "exitmonth".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            exitmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("entrymon".hashCode() == st.sval.hashCode() && "entrymon".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            entrymonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("exitmon".hashCode() == st.sval.hashCode() && "exitmon".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            exitmonth = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("pos2".hashCode() == st.sval.hashCode() && "pos2".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            XPos2 = (int)st.nval;
                            if (st.nextToken() == -2) {
                                YPos2 = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("region".hashCode() == st.sval.hashCode() && "region".equals(st.sval)) {
                        region = is.readLine();
                        continue block4;
                    }
                    if ("tdbcapacity".hashCode() == st.sval.hashCode() && "tdbcapacity".equals(st.sval)) {
                        AuxText = is.readLine();
                        tdbcapacity = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("tdblength".hashCode() == st.sval.hashCode() && "tdblength".equals(st.sval)) {
                        AuxText = is.readLine();
                        tdblength = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("tdbload".hashCode() == st.sval.hashCode() && "tdbload".equals(st.sval)) {
                        tdbload = is.readLine();
                        continue block4;
                    }
                    if ("mytmodes".equals(st.sval) && "mytmodes".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            mytmodes[++nmodes - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("gentravelini".hashCode() == st.sval.hashCode() && "gentravelini".equals(st.sval)) {
                        AuxText = is.readLine();
                        gentravelini = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("arrivtravelini".hashCode() == st.sval.hashCode() && "arrivtravelini".equals(st.sval)) {
                        AuxText = is.readLine();
                        arrivtravelini = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("grategen".hashCode() == st.sval.hashCode() && "grategen".equals(st.sval)) {
                        AuxText = is.readLine();
                        grategen = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("gratearriv".hashCode() == st.sval.hashCode() && "gratearriv".equals(st.sval)) {
                        AuxText = is.readLine();
                        gratearriv = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("tdbflujo".hashCode() == st.sval.hashCode() && "tdbflujo".equals(st.sval)) {
                        AuxText = is.readLine();
                        tdbflujo = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("tdbvelocidad".hashCode() == st.sval.hashCode() && "tdbvelocidad".equals(st.sval)) {
                        AuxText = is.readLine();
                        tdbvelocidad = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("farcemissions".equals(st.sval) && "farcemissions".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            f_arc_emissions[++nfarcemissions - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("fcentemissions".equals(st.sval) && "fcentemissions".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            f_cent_emissions[++nfcentemissions - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("fcapacity".hashCode() == st.sval.hashCode() && "fcapacity".equals(st.sval)) {
                        AuxText = is.readLine();
                        f_capacity = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("funit".hashCode() == st.sval.hashCode() && "funit".equals(st.sval)) {
                        if (st.nextToken() != -2) continue block4;
                        f_unit = st.sval;
                        continue block4;
                    }
                    if ("myfmodes".hashCode() == st.sval.hashCode() && "myfmodes".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            my_f_modes = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("numpines".hashCode() == st.sval.hashCode() && "numpines".equals(st.sval)) {
                        AuxText = is.readLine();
                        numpines = (int)st.nval;
                        continue block4;
                    }
                    if ("length".hashCode() == st.sval.hashCode() && "length".equals(st.sval)) {
                        AuxText = is.readLine();
                        length = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("flow".hashCode() == st.sval.hashCode() && "flow".equals(st.sval)) {
                        AuxText = is.readLine();
                        flow = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("fueltype".hashCode() == st.sval.hashCode() && "fueltype".equals(st.sval)) {
                        fuel_type = is.readLine();
                        continue block4;
                    }
                    if ("myfzone".hashCode() == st.sval.hashCode() && "myfzone".equals(st.sval)) {
                        my_f_zone = is.readLine();
                        continue block4;
                    }
                    if ("networkflag".hashCode() == st.sval.hashCode() && "networkflag".equals(st.sval)) {
                        network_flag = is.readLine();
                        continue block4;
                    }
                    if ("conobject".hashCode() == st.sval.hashCode() && "conobject".equals(st.sval)) {
                        con_object = is.readLine();
                        continue block4;
                    }
                    if ("origin".hashCode() == st.sval.hashCode() && "origin".equals(st.sval)) {
                        if (st.nextToken() != -2) continue block4;
                        origin = st.sval;
                        continue block4;
                    }
                    if ("fcapacityunit".hashCode() == st.sval.hashCode() && "fcapacityunit".equals(st.sval)) {
                        f_capacity_unit = is.readLine();
                        continue block4;
                    }
                    if ("fmodecapacity".equals(st.sval) && "fmodecapacity".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            f_mode_capacity[++fmc - 1] = st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("consumptiongrate".hashCode() == st.sval.hashCode() && "consumptiongrate".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            consumption_grate[++cgr - 1] = st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("consumptionini".equals(st.sval) && "consumptionini".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            consumption_ini[++ci - 1] = st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("stocapacity".hashCode() == st.sval.hashCode() && "stocapacity".equals(st.sval)) {
                        AuxText = is.readLine();
                        sto_capacity = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("stocapacityunit".hashCode() == st.sval.hashCode() && "stocapacityunit".equals(st.sval)) {
                        sto_capacity_unit = is.readLine();
                        continue block4;
                    }
                    if ("inistate".hashCode() == st.sval.hashCode() && "inistate".equals(st.sval)) {
                        AuxText = is.readLine();
                        ini_state = Double.valueOf(AuxText);
                        continue block4;
                    }
                    if ("finjemissions".equals(st.sval) && "finjemissions".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            f_inj_emissions[++nfinjemissions - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("fcusemissions".equals(st.sval) && "fcusemissions".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            f_cus_emissions[++nfcusemissions - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("flinkemissions".equals(st.sval) && "flinkemissions".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            f_link_emissions[++nflinkemissions - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("fstoemissions".equals(st.sval) && "fstoemissions".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            f_sto_emissions[++nfstoemissions - 1] = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("end".hashCode() == st.sval.hashCode() && "end".equals(st.sval) && st.nextToken() == -3 && "describe".hashCode() == st.sval.hashCode() && "describe".equals(st.sval)) ** break;
                    continue block4;
                    if ("System".hashCode() != ComponentName.hashCode() || !"System".equals(ComponentName)) {
                        if ("fdblink".hashCode() == ComponentName.hashCode() && "fdblink".equals(ComponentName)) {
                            this.addComponent(new fdb_link(PinGrid, XPos, YPos, XPos2, YPos2, Text, type, owner, cost, lifetime, entryperiod, exitperiod, xpoly, ypoly, npoly, f_capacity, f_unit, my_f_modes, length, fuel_type, f_link_emissions));
                        } else if ("fdbcust".hashCode() == ComponentName.hashCode() && "fdbcust".equals(ComponentName)) {
                            this.addComponent(new fdb_cust(PinGrid, this.mispines(my_f_modes), XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude, my_f_zone, consumption_grate, consumption_ini, my_f_modes, network_flag, con_object, f_cus_emissions));
                        } else if ("fdbinjection".hashCode() == ComponentName.hashCode() && "fdbinjection".equals(ComponentName)) {
                            this.addComponent(new fdb_injection(PinGrid, this.mispines(my_f_modes), XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude, origin, f_capacity, my_f_modes, f_capacity_unit, f_mode_capacity, f_inj_emissions));
                        } else if ("fdbstorage".hashCode() == ComponentName.hashCode() && "fdbstorage".equals(ComponentName)) {
                            this.addComponent(new fdb_storage(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude, sto_capacity, sto_capacity_unit, fuel_type, ini_state, f_sto_emissions));
                        } else if ("tdbarc".hashCode() == ComponentName.hashCode() && "tdbarc".equals(ComponentName)) {
                            this.addComponent(new tdb_arc(PinGrid, XPos, YPos, XPos2, YPos2, Text, type, owner, cost, lifetime, entryperiod, exitperiod, xpoly, ypoly, npoly, tdbcapacity, mytmodes, tdblength, this.getTdbLoad(tdbload), tdbflujo, tdbvelocidad, f_arc_emissions));
                        } else if ("tdbnode".hashCode() == ComponentName.hashCode() && "tdbnode".equals(ComponentName)) {
                            this.addComponent(new tdb_node(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude, this.getTdbLoad(tdbload)));
                        } else if ("tdbcentroid".hashCode() == ComponentName.hashCode() && "tdbcentroid".equals(ComponentName)) {
                            this.addComponent(new tdb_centroid(PinGrid, XPos, YPos, Text, type, owner, cost, lifetime, entryperiod, exitperiod, latitude, longitude, this.getTdbLoad(tdbload), gentravelini, arrivtravelini, grategen, gratearriv, f_cent_emissions, region));
                        } else if ("Caption".hashCode() == ComponentName.hashCode() && "Caption".equals(ComponentName)) {
                            this.addComponent(new Caption(XPos, YPos, Text, entryperiod, exitperiod, entrymonth, exitmonth, owner));
                        } else {
                            System.out.println("@: Possible Error with Component Name: " + ComponentName + "(" + st.sval + ")");
                            return false;
                        }
                    }
                    return true;
                }
            }
            break;
        }
        return true;
    }

    public int mispines(int fmodes) {
        int pins = 0;
        for (int i = 0; i < 26; ++i) {
            int aux = fmodes & (int)Math.pow(2.0, i);
            if (aux == 0) continue;
            ++pins;
        }
        return pins;
    }

    /*
     * Unable to fully structure code
     */
    public boolean ModComponent(BufferedReader is, StreamTokenizer st, String ClassName, String ComponentName) throws IOException, FileFormatException {
        Text = "";
        type = "";
        owner = "";
        AuxText = "";
        ldc_T = 0.0;
        ldc_pmin = 0.0;
        ldc_pmax = 0.0;
        un1 = 0.0;
        un2 = 0.0;
        un3 = 0.0;
        smax = 0.0;
        sc = 1.0;
        cost = 0.0;
        alpha = 0.0;
        beta = 0.0;
        gamma = 0.0;
        verhor = true;
        swapPS = false;
        lifetime = 0;
        entryperiod = 0;
        num = 0;
        pmax = 0.0;
        pmin = 0.0;
        qmax = 0.0;
        qmin = 0.0;
        p0 = 0.0;
        q0 = 0.0;
        p = 0.0;
        q = 0.0;
        r1 = 0.0;
        xx1 = 0.0;
        b1 = 0.0;
        g1 = 0.0;
        len = 0.0;
        spotp = 0.0;
        spotq = 0.0;
        incomep = 0.0;
        incomeq = 0.0;
        uk = 0.0;
        pcu = 0.0;
        pfe = 0.0;
        i0 = 0.0;
        z0z1 = 0.0;
        r0x0 = 0.0;
        pwheel = 0.0;
        qwheel = 0.0;
        pcontract = 0.0;
        qcontract = 0.0;
        unserp = 0.0;
        unserq = 0.0;
        p12 = 0.0;
        q12 = 0.0;
        p21 = 0.0;
        q21 = 0.0;
        price = 0.0;
        delta1 = 0.0;
        delta2 = 0.0;
        delta3 = 0.0;
        ffitnes = 0.0;
        inj = "";
        load = "";
        ActInj = null;
        ActLine = null;
        ActContract = null;
        npoly = false;
        nmodes = false;
        this.OSName = System.getProperty("os.name");
        ClassName = this.NsrToPiet(ClassName);
        block6: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block6;
                }
                case -3: {
                    if ("load".equals(st.sval)) {
                        load = is.readLine();
                        continue block6;
                    }
                    if ("inj".equals(st.sval)) {
                        inj = is.readLine();
                        continue block6;
                    }
                    if ("type".equals(st.sval)) {
                        type = is.readLine();
                        continue block6;
                    }
                    if ("owner".equals(st.sval)) {
                        owner = is.readLine();
                        continue block6;
                    }
                    if ("u1".equals(st.sval)) {
                        AuxText = is.readLine();
                        un2 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("u2".equals(st.sval)) {
                        AuxText = is.readLine();
                        un3 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("delta1".equals(st.sval)) {
                        AuxText = is.readLine();
                        delta2 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("delta2".equals(st.sval)) {
                        AuxText = is.readLine();
                        delta3 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("U".equals(st.sval)) {
                        AuxText = is.readLine();
                        un2 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("delta".equals(st.sval)) {
                        AuxText = is.readLine();
                        delta2 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("smax".equals(st.sval)) {
                        AuxText = is.readLine();
                        smax = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("pwheel".equals(st.sval)) {
                        AuxText = is.readLine();
                        pwheel = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("qwheel".equals(st.sval)) {
                        AuxText = is.readLine();
                        qwheel = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("pcontract".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcontract = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("qcontract".equals(st.sval)) {
                        AuxText = is.readLine();
                        qcontract = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("cost".equals(st.sval)) {
                        AuxText = is.readLine();
                        cost = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("price".equals(st.sval)) {
                        AuxText = is.readLine();
                        price = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("verhor".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block6;
                        verhor = Boolean.valueOf(st.sval);
                        continue block6;
                    }
                    if ("swapPS".equals(st.sval)) {
                        if (st.nextToken() != -3) continue block6;
                        swapPS = Boolean.valueOf(st.sval);
                        continue block6;
                    }
                    if ("ldc_T".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_T = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("ldc_pmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        ldc_pmax = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("ldc_pmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        continue block6;
                    }
                    if ("alpha".equals(st.sval)) {
                        AuxText = is.readLine();
                        alpha = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("beta".equals(st.sval)) {
                        AuxText = is.readLine();
                        beta = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("gamma".equals(st.sval)) {
                        AuxText = is.readLine();
                        gamma = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("pmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        pmax = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("pmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        pmin = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("qmax".equals(st.sval)) {
                        AuxText = is.readLine();
                        qmax = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("unser_p".equals(st.sval)) {
                        AuxText = is.readLine();
                        unserp = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("unser_q".equals(st.sval)) {
                        AuxText = is.readLine();
                        unserq = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("qmin".equals(st.sval)) {
                        AuxText = is.readLine();
                        qmin = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("p12".equals(st.sval)) {
                        AuxText = is.readLine();
                        p12 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("q12".equals(st.sval)) {
                        AuxText = is.readLine();
                        q12 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("p21".equals(st.sval)) {
                        AuxText = is.readLine();
                        p21 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("q21".equals(st.sval)) {
                        AuxText = is.readLine();
                        q21 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("r1".equals(st.sval)) {
                        AuxText = is.readLine();
                        r1 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("xx1".equals(st.sval)) {
                        AuxText = is.readLine();
                        xx1 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("b1".equals(st.sval)) {
                        AuxText = is.readLine();
                        b1 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("g1".equals(st.sval)) {
                        AuxText = is.readLine();
                        g1 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("p0".equals(st.sval)) {
                        AuxText = is.readLine();
                        p0 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("q0".equals(st.sval)) {
                        AuxText = is.readLine();
                        q0 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("p".equals(st.sval)) {
                        AuxText = is.readLine();
                        p = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("q".equals(st.sval)) {
                        AuxText = is.readLine();
                        q = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("incomep".equals(st.sval)) {
                        AuxText = is.readLine();
                        incomep = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("incomeq".equals(st.sval)) {
                        AuxText = is.readLine();
                        incomeq = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("spotp".equals(st.sval)) {
                        AuxText = is.readLine();
                        spotp = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("spotq".equals(st.sval)) {
                        AuxText = is.readLine();
                        spotq = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("uk".equals(st.sval)) {
                        AuxText = is.readLine();
                        uk = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("pcu".equals(st.sval)) {
                        AuxText = is.readLine();
                        pcu = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("pfe".equals(st.sval)) {
                        AuxText = is.readLine();
                        pfe = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("i0".equals(st.sval)) {
                        AuxText = is.readLine();
                        i0 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("z0z1".equals(st.sval)) {
                        AuxText = is.readLine();
                        z0z1 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("r0x0".equals(st.sval)) {
                        AuxText = is.readLine();
                        r0x0 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("q0".equals(st.sval)) {
                        AuxText = is.readLine();
                        q0 = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("fitnes".equals(st.sval)) {
                        AuxText = is.readLine();
                        ffitnes = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("len".equals(st.sval)) {
                        AuxText = is.readLine();
                        len = Double.valueOf(AuxText);
                        continue block6;
                    }
                    if ("lifetime".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            lifetime = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block6;
                            st.nextToken();
                        }
                    }
                    if ("num".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            num = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block6;
                            st.nextToken();
                        }
                    }
                    if ("entryperiod".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            entryperiod = (int)st.nval;
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block6;
                            st.nextToken();
                        }
                    }
                    if ("END".equals(st.sval)) ** break;
                    continue block6;
                    if (ClassName.equals("System")) {
                        this.setfitnes(-ffitnes);
                    } else if (this.TempComponent instanceof ndb_inj) {
                        ActInj = (ndb_inj)this.TempComponent;
                        try {
                            ActInj.setun2(un2 * ActInj.getun1());
                            ActInj.setdelta2(delta2);
                            ActInj.setp(p * this.sref);
                            ActInj.setq(q * this.sref);
                            ActInj.setspot_p(spotp);
                            ActInj.setspot_q(spotq);
                        }
                        catch (Exception e) {
                            this.message = e.toString();
                            DlgButtons = new String[]{"OK"};
                            ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading Injection information", this.message, DlgButtons, 1, 0, 0, 1);
                        }
                    } else {
                        return false;
                    }
                    return true;
                }
            }
            break;
        }
        return true;
    }

    PietSchematic(Pin[][] PinGrid) throws Exception {
        this();
        LaunchProgressFrame loadLaunchFrame = null;
        boolean SchematicCorrupt = false;
        loadLaunchFrame = new LaunchProgressFrame("Loading ODBC Database: ", 16L);
        loadLaunchFrame.show();
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        String query = "SELECT  * FROM System";
        this.selectDB(PinGrid, "System", query);
        loadLaunchFrame.WindowLabel.setText("Loading System Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM Caption";
        this.selectDB(PinGrid, "Caption", query);
        loadLaunchFrame.WindowLabel.setText("Loading Comments Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM fdb_injection";
        this.selectDB(PinGrid, "fdb_injection", query);
        loadLaunchFrame.WindowLabel.setText("Loading Fuel Injection Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM fdb_cust";
        this.selectDB(PinGrid, "fdb_cust", query);
        loadLaunchFrame.WindowLabel.setText("Loading Fuel Customer Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM fdb_storage";
        this.selectDB(PinGrid, "fdb_storage", query);
        loadLaunchFrame.WindowLabel.setText("Loading Fuel Storage Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM fdb_link";
        this.selectDB(PinGrid, "fdb_link", query);
        loadLaunchFrame.WindowLabel.setText("Loading Fuel Link Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM tdb_arc";
        this.selectDB(PinGrid, "tdb_arc", query);
        loadLaunchFrame.WindowLabel.setText("Loading Arc Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM tdb_node";
        this.selectDB(PinGrid, "tdb_node", query);
        loadLaunchFrame.WindowLabel.setText("Loading  Transport Node Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        query = "SELECT  * FROM tdb_centroid";
        this.selectDB(PinGrid, "tdb_centroid", query);
        loadLaunchFrame.WindowLabel.setText("Loading Transport Centroid Information: ");
        if (loadLaunchFrame != null) {
            loadLaunchFrame.updateProgress();
        }
        loadLaunchFrame.dispose();
        loadLaunchFrame = null;
        this.Modified = false;
        this.Modifiedstate = true;
        this.changeGIS = true;
        this.CheckActive();
        if (SchematicCorrupt) {
            String[] DlgButtons = new String[]{"OK"};
            if (this.accuse1) {
                System.out.println("@say: #3");
            }
            this.message = "Unknown data in schematic. Schematic could be corrupt.";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading Database schematic", this.message, DlgButtons, 1, 0, 0, 2);
        }
    }

    void selectDB(Pin[][] PinGrid, String ComponentName, String query) throws SQLException {
        int[] xpoly = new int[32];
        int[] ypoly = new int[32];
        int npoly = 0;
        int ix = 0;
        int[] mytmodes = new int[7];
        double[] gemissions = new double[9];
        double[] finjemissions = new double[9];
        double[] fcusemissions = new double[9];
        double[] flinkemissions = new double[9];
        double[] fstoemissions = new double[9];
        double[] farcemissions = new double[9];
        double[] fcentemissions = new double[9];
        double[] consumption_grate = new double[26];
        double[] consumption_ini = new double[26];
        double[] fmodecapacity = new double[26];
        Statement stmt = PietEditFrame.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        boolean more = rs.next();
        if (!more) {
            System.out.println("No " + ComponentName + " found.");
            return;
        }
        while (more) {
            int i;
            int i2;
            int fmodsI;
            String Name;
            if ("fdb_injection".equals(ComponentName)) {
                Name = this.nb(rs.getString("Name"));
                fmodsI = rs.getInt("myfmodes");
                for (i2 = 0; i2 > 26; ++i2) {
                    fmodecapacity[i2] = rs.getDouble("fmodecapacity" + String.valueOf(i2 + 1));
                }
                for (i2 = 0; i2 < 9; ++i2) {
                    finjemissions[i2] = rs.getDouble("finjemissions" + String.valueOf(i2 + 1));
                }
                this.addComponent(new fdb_injection(PinGrid, this.mispines(fmodsI), rs.getInt("XPos"), rs.getInt("YPos"), Name, this.nb(rs.getString("type")), this.nb(rs.getString("owner")), rs.getDouble("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("latitude"), rs.getInt("longitude"), this.nb(rs.getString("origin")), rs.getDouble("fcapacity"), fmodsI, this.nb(rs.getString("fcapacityunit")), fmodecapacity, finjemissions));
            }
            if ("fdb_storage".equals(ComponentName)) {
                Name = this.nb(rs.getString("Name"));
                for (i = 0; i < 9; ++i) {
                    fstoemissions[i] = rs.getDouble("fstoemissions" + String.valueOf(i + 1));
                }
                this.addComponent(new fdb_storage(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, this.nb(rs.getString("type")), this.nb(rs.getString("owner")), rs.getDouble("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("latitude"), rs.getInt("longitude"), rs.getDouble("stocapacity"), this.nb(rs.getString("stocapacityunit")), this.nb(rs.getString("fueltype")), rs.getDouble("inistate"), fstoemissions));
            }
            if ("fdb_cust".equals(ComponentName)) {
                Name = this.nb(rs.getString("Name"));
                fmodsI = rs.getInt("myfmodes");
                for (i2 = 0; i2 < 26; ++i2) {
                    consumption_grate[i2] = rs.getDouble("consumptiongrate" + String.valueOf(i2 + 1));
                    consumption_ini[i2] = rs.getDouble("consumptionini" + String.valueOf(i2 + 1));
                }
                for (i2 = 0; i2 < 9; ++i2) {
                    fcusemissions[i2] = rs.getDouble("fcusemissions" + String.valueOf(i2 + 1));
                }
                this.addComponent(new fdb_cust(PinGrid, this.mispines(fmodsI), rs.getInt("XPos"), rs.getInt("YPos"), Name, this.nb(rs.getString("type")), this.nb(rs.getString("owner")), rs.getDouble("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getInt("latitude"), rs.getInt("longitude"), this.nb(rs.getString("myfzone")), consumption_grate, consumption_ini, fmodsI, this.nb(rs.getString("networkflag")), this.nb(rs.getString("conobjet")), fcusemissions));
            }
            if ("tdb_node".equals(ComponentName)) {
                Name = rs.getString("Name");
                this.addComponent(new tdb_node(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, this.nb(rs.getString("type")), this.nb(rs.getString("owner")), rs.getDouble("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getDouble("latitude"), rs.getDouble("longitude"), this.getTdbLoad(this.nb(rs.getString("tdbload")))));
            }
            if ("tdb_centroid".equals(ComponentName)) {
                Name = this.nb(rs.getString("Name"));
                for (i = 0; i < 9; ++i) {
                    fcentemissions[i] = rs.getDouble("fcentemissions" + String.valueOf(i + 1));
                }
                this.addComponent(new tdb_centroid(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), Name, this.nb(rs.getString("type")), this.nb(rs.getString("owner")), rs.getDouble("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), rs.getDouble("latitude"), rs.getDouble("longitude"), this.getTdbLoad(this.nb(rs.getString("tdbload"))), rs.getDouble("gentravelini"), rs.getDouble("arrivtravelini"), rs.getDouble("grategen"), rs.getDouble("gratearriv"), fcentemissions, rs.getString("region")));
            }
            if ("fdb_link".equals(ComponentName)) {
                npoly = rs.getInt("numpoly");
                Name = this.nb(rs.getString("Name"));
                for (ix = 0; ix < npoly; ++ix) {
                    xpoly[ix] = rs.getInt("pospolyx" + String.valueOf(ix + 1));
                    ypoly[ix] = rs.getInt("pospolyy" + String.valueOf(ix + 1));
                }
                for (i = 0; i < 9; ++i) {
                    flinkemissions[i] = rs.getDouble("flinkemissions" + String.valueOf(i + 1));
                }
                this.addComponent(new fdb_link(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), rs.getInt("XPos2"), rs.getInt("YPos2"), Name, this.nb(rs.getString("type")), this.nb(rs.getString("owner")), rs.getDouble("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), xpoly, ypoly, npoly, rs.getDouble("fcapacity"), this.nb(rs.getString("funit")), rs.getInt("myfmodes"), rs.getDouble("length"), this.nb(rs.getString("fueltype")), flinkemissions));
            }
            if ("tdb_arc".equals(ComponentName)) {
                npoly = rs.getInt("numpoly");
                Name = this.nb(rs.getString("Name"));
                for (ix = 0; ix < npoly; ++ix) {
                    xpoly[ix] = rs.getInt("pospolyx" + String.valueOf(ix + 1));
                    ypoly[ix] = rs.getInt("pospolyy" + String.valueOf(ix + 1));
                }
                for (ix = 0; ix < 7; ++ix) {
                    mytmodes[ix] = rs.getInt("mytmodes" + String.valueOf(ix + 1));
                }
                for (i = 0; i < 9; ++i) {
                    farcemissions[i] = rs.getDouble("farcemissions" + String.valueOf(i + 1));
                }
                this.addComponent(new tdb_arc(PinGrid, rs.getInt("XPos"), rs.getInt("YPos"), rs.getInt("XPos2"), rs.getInt("YPos2"), Name, this.nb(rs.getString("type")), this.nb(rs.getString("owner")), rs.getDouble("cost"), rs.getInt("lifetime"), rs.getInt("entryperiod"), rs.getInt("exitperiod"), xpoly, ypoly, npoly, rs.getDouble("tdbcapacity"), mytmodes, rs.getDouble("tdblength"), this.getTdbLoad(this.nb(rs.getString("tdbload"))), rs.getDouble("tdbflujo"), rs.getDouble("tdbvelocidad"), farcemissions));
            }
            more = rs.next();
        }
        rs.close();
        stmt.close();
    }

    public String nb(String TS) {
        int in = TS.indexOf(" ");
        if (TS.length() > 0 && TS != null && in >= 0) {
            return TS.substring(0, in);
        }
        return TS;
    }

    PietSchematic(Pin[][] PinGrid, InputStream iss, long linenumero) throws IOException, FileFormatException {
        this();
        int FileVersionHigh = 0;
        int FileVersionLow = 0;
        boolean SchematicCorrupt = false;
        LaunchProgressFrame loadLaunchFrame = null;
        LineNumberReader is = new LineNumberReader(new InputStreamReader(iss));
        StreamTokenizer st = new StreamTokenizer(is);
        loadLaunchFrame = new LaunchProgressFrame("Loading File: ", linenumero);
        loadLaunchFrame.show();
        st.eolIsSignificant(true);
        st.commentChar(35);
        st.ordinaryChar(95);
        st.ordinaryChar(47);
        st.wordChars(95, 95);
        st.wordChars(58, 58);
        st.wordChars(45, 45);
        st.wordChars(48, 57);
        st.eolIsSignificant(true);
        st.parseNumbers();
        block4: while (true) {
            if (loadLaunchFrame != null) {
                loadLaunchFrame.updateProgress(is.getLineNumber());
            }
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("version".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            FileVersionHigh = (int)st.nval;
                            if (st.nextToken() == -2) {
                                FileVersionLow = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("describe".equals(st.sval)) {
                        if (st.nextToken() != -3 || !"component".equals(st.sval) || st.nextToken() != -3 || this.LoadComponent(PinGrid, is, st)) continue block4;
                        SchematicCorrupt = true;
                        continue block4;
                    }
                    SchematicCorrupt = true;
                    continue block4;
                }
            }
            break;
        }
        is.close();
        loadLaunchFrame.dispose();
        loadLaunchFrame = null;
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
        this.Modified = false;
        this.Modifiedstate = true;
        this.changeGIS = true;
        this.CheckActive();
        if (SchematicCorrupt) {
            String[] DlgButtons = new String[]{"OK"};
            if (this.accuse1) {
                System.out.println("@say: #1");
            }
            this.message = "@: Unknown data in schematic. Schematic could be corrupt.";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading schematic", this.message, DlgButtons, 1, 0, 0, 2);
        }
    }

    PietSchematic(Pin[][] PinGrid, InputStream iss) throws IOException, FileFormatException {
        this();
        int FileVersionHigh = 0;
        int FileVersionLow = 0;
        boolean SchematicCorrupt = false;
        LineNumberReader is = new LineNumberReader(new InputStreamReader(iss));
        StreamTokenizer st = new StreamTokenizer(is);
        st.commentChar(35);
        st.ordinaryChar(95);
        st.ordinaryChar(47);
        st.wordChars(95, 95);
        st.wordChars(45, 45);
        st.wordChars(58, 58);
        st.wordChars(48, 57);
        st.eolIsSignificant(true);
        st.parseNumbers();
        block4: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("version".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            FileVersionHigh = (int)st.nval;
                            if (st.nextToken() == -2) {
                                FileVersionLow = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("describe".equals(st.sval)) {
                        if (st.nextToken() != -3 || !"component".equals(st.sval) || st.nextToken() != -3 || this.LoadComponent(PinGrid, is, st)) continue block4;
                        SchematicCorrupt = true;
                        continue block4;
                    }
                    SchematicCorrupt = true;
                    continue block4;
                }
            }
            break;
        }
        is.close();
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
        this.Modified = false;
        this.Modifiedstate = true;
        this.changeGIS = true;
        this.CheckActive();
        if (SchematicCorrupt) {
            String[] DlgButtons = new String[]{"OK"};
            if (this.accuse1) {
                System.out.println("@say: #2");
            }
            this.message = "Unknown data in schematic. Schematic could be corrupt.";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading schematic", this.message, DlgButtons, 1, 0, 0, 2);
        }
    }

    public void ModSchematic(InputStream iss) throws IOException, FileFormatException {
        int FileVersionHigh = 0;
        int FileVersionLow = 0;
        String ClassName = null;
        String ComponentName = null;
        boolean SchematicCorrupt = false;
        String Text = "";
        BufferedReader is = new BufferedReader(new InputStreamReader(iss));
        StreamTokenizer st = new StreamTokenizer(is);
        this.OSName = System.getProperty("os.name");
        st.ordinaryChar(95);
        st.ordinaryChar(45);
        st.ordinaryChar(47);
        st.wordChars(45, 45);
        st.wordChars(58, 58);
        st.wordChars(95, 95);
        st.commentChar(35);
        st.eolIsSignificant(true);
        block4: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("version".equals(st.sval)) {
                        if (st.nextToken() == -2) {
                            FileVersionHigh = (int)st.nval;
                            if (st.nextToken() == -2) {
                                FileVersionLow = (int)st.nval;
                            }
                        }
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("OBJECT".equals(st.sval)) {
                        int c;
                        if (st.nextToken() == -3) {
                            ClassName = st.sval;
                        }
                        ComponentName = "";
                        while ((c = is.read()) != 10) {
                            ComponentName = ComponentName + (char)c;
                        }
                        if (this.OSName.equals("Windows 95") || this.OSName.equals("Windows NT")) {
                            ComponentName = ComponentName.substring(0, ComponentName.length() - 1);
                        }
                        if (this.ModComponent(is, st, ClassName, ComponentName)) continue block4;
                        System.out.println(" SchematicCorrupt a: " + ClassName + " " + ComponentName);
                        SchematicCorrupt = true;
                        continue block4;
                    }
                    System.out.println(" SchematicCorrupt b: " + ClassName + " " + ComponentName);
                    SchematicCorrupt = true;
                    continue block4;
                }
            }
            break;
        }
        iss.close();
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
        this.Modified = false;
        this.Modifiedstate = false;
        this.changeGIS = true;
        if (SchematicCorrupt) {
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Unknown data in uod file. Schematic could be corrupt.";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading schematic", this.message, DlgButtons, 1, 0, 0, 2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean verifyresult(InputStream iss) throws IOException, FileFormatException {
        is = new BufferedReader(new InputStreamReader(iss));
        st = new StreamTokenizer(is);
        this.OSName = System.getProperty("os.name");
        st.eolIsSignificant(true);
        block4: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("Error".equals(st.sval)) ** break;
                    continue block4;
                    DlgButtons = new String[]{"OK"};
                    this.message = "Error during simulation: please check isolated system, parameter, ...";
                    ExceptionDialog = new SimpleDialog(DeepEdit.frame, "In Simulation Tool (External call)", this.message, DlgButtons, 1, 0, 0, 2);
                    iss.close();
                    return false;
                }
            }
            break;
        }
        iss.close();
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
        return true;
    }

    public void DoStatistic(FileOutputStream os) throws IOException, FileFormatException {
        int i;
        fdb_storage TempSto;
        fdb_cust TempCustomer;
        fdb_injection TempInj;
        fdb_link TempLink;
        tdb_arc TempArc;
        tdb_centroid TempCentroid;
        Load TempLoad;
        SVC TempSVC;
        Generator TempGenerator;
        comp TempComponent;
        String owner = "";
        String linea = "";
        int ix = 0;
        int numnod = 0;
        int numlin = 0;
        int numtran = 0;
        int numgen = 0;
        int numload = 0;
        int numinj = 0;
        int numfacts = 0;
        int totdemini = 0;
        int numnod2 = 0;
        int numlin2 = 0;
        int numtran2 = 0;
        int numgen2 = 0;
        int numload2 = 0;
        int numinj2 = 0;
        int numfacts2 = 0;
        double totdemq = 0.0;
        double totdeminiq = 0.0;
        double maxgen = 0.0;
        double maxgenq = 0.0;
        double totdem2 = 0.0;
        double totdemini2 = 0.0;
        double totdemq2 = 0.0;
        double totdeminiq2 = 0.0;
        double maxgen2 = 0.0;
        double maxgenq2 = 0.0;
        double[] Eemissions = new double[9];
        double[] Gx_emissions = new double[9];
        int nnodes = 0;
        int ncentroids = 0;
        int narcs = 0;
        int ntobj = 0;
        double totalGxTravels = 0.0;
        double totalArrivTravels = 0.0;
        double tKm = 0.0;
        double trenKm = 0.0;
        double carreteraKm = 0.0;
        double[] Temissions = new double[9];
        double[] Cent_emissions = new double[9];
        double[] Arcs_emissions = new double[9];
        int ninj = 0;
        int nstorage = 0;
        int nlinks = 0;
        int ncust = 0;
        int nfobj = 0;
        String Fowner = "None";
        double Crudo = 0.0;
        double GCiud = 0.0;
        double GLic = 0.0;
        double GNat = 0.0;
        double GasOil = 0.0;
        double GasRef = 0.0;
        double Gaso81 = 0.0;
        double Gaso86 = 0.0;
        double Gaso91 = 0.0;
        double Gaso93_ = 0.0;
        double Gaso93sp = 0.0;
        double Gaso95sp = 0.0;
        double Gaso97sp = 0.0;
        double GasoAv = 0.0;
        double KerAv = 0.0;
        double KeroDom = 0.0;
        double NaftaLiv = 0.0;
        double Ifo180 = 0.0;
        double Ifo380 = 0.0;
        double PCNo5 = 0.0;
        double PCNo6 = 0.0;
        double DieselA1 = 0.0;
        double DieselB = 0.0;
        double DieselBESC = 0.0;
        double DieselENAP2 = 0.0;
        double DieselInv = 0.0;
        double TotStorage = 0.0;
        double[] Femissions = new double[9];
        double[] Inj_emissions = new double[9];
        double[] Sto_emissions = new double[9];
        double[] Cust_emissions = new double[9];
        double[] Link_emissions = new double[9];
        double TotCo = 0.0;
        double TotHC = 0.0;
        double TotNOx = 0.0;
        double TotMP19 = 0.0;
        double TotSO2 = 0.0;
        double TotCH4 = 0.0;
        double TotN20 = 0.0;
        double TotNH3 = 0.0;
        double TotCO2 = 0.0;
        double[] Totemissions = new double[9];
        PrintStream myPrintStream = new PrintStream(os);
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (TempComponent instanceof ndb_comp) {
                ndb_comp TempElComponent = (ndb_comp)TempComponent;
                owner = TempElComponent.getinv_owner();
            }
            if (TempComponent instanceof Busbar) {
                if (this.focusowner.equals(owner)) {
                    ++numnod2;
                }
                ++numnod;
            }
            if (TempComponent instanceof Line) {
                if (this.focusowner.equals(owner)) {
                    ++numlin2;
                }
                ++numlin;
            }
            if (TempComponent instanceof Trafo) {
                if (this.focusowner.equals(owner)) {
                    ++numtran2;
                }
                ++numtran;
            }
            if (TempComponent instanceof Generator) {
                TempGenerator = (Generator)TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numgen2;
                    maxgen2 += TempGenerator.getpmax();
                    maxgenq2 += TempGenerator.getqmax();
                }
                ++numgen;
                maxgen += TempGenerator.getpmax();
                maxgenq += TempGenerator.getqmax();
            }
            if (TempComponent instanceof SVC) {
                TempSVC = (SVC)TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numfacts2;
                    maxgenq2 += TempSVC.getqmax();
                }
                ++numfacts;
                maxgenq += TempSVC.getqmax();
            }
            if (TempComponent instanceof Injection) {
                Injection TempInjection = (Injection)TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numinj2;
                    maxgen2 += TempInjection.getpmax();
                    maxgenq2 += TempInjection.getqmax();
                }
                ++numinj;
                maxgen += TempInjection.getpmax();
                maxgenq += TempInjection.getqmax();
            }
            if (TempComponent instanceof Load) {
                TempLoad = (Load)TempComponent;
                if (this.focusowner.equals(owner)) {
                    ++numload2;
                    totdem2 += TempLoad.getp();
                    totdemq2 += TempLoad.getq();
                    totdemini2 += TempLoad.getpini();
                    totdeminiq2 += TempLoad.getqini();
                }
                ++numload;
                this.totdem += TempLoad.getp();
                totdemq += TempLoad.getq();
                totdemini = (int)((double)totdemini + TempLoad.getpini());
                totdeminiq += TempLoad.getqini();
            }
            if (TempComponent instanceof tdb_node) {
                ++nnodes;
                ++ntobj;
            }
            if (TempComponent instanceof tdb_centroid) {
                TempCentroid = (tdb_centroid)TempComponent;
                ++ncentroids;
                ++ntobj;
                totalGxTravels += TempCentroid.getgen_travel_ini();
                totalArrivTravels += TempCentroid.getarriv_travel_ini();
            }
            if (TempComponent instanceof tdb_arc) {
                TempArc = (tdb_arc)TempComponent;
                ++narcs;
                ++ntobj;
                if (TempArc.getmy_t_modesB(0) || TempArc.getmy_t_modesB(1)) {
                    trenKm += TempArc.getlength();
                    tKm += TempArc.getlength();
                } else if (TempArc.getmy_t_modesB(2) || TempArc.getmy_t_modesB(3) || TempArc.getmy_t_modesB(4)) {
                    carreteraKm = trenKm + TempArc.getlength();
                    tKm += TempArc.getlength();
                }
            }
            if (TempComponent instanceof fdb_comp) {
                fdb_comp TempFxComponent = (fdb_comp)TempComponent;
                Fowner = TempFxComponent.getinv_owner();
            }
            if (TempComponent instanceof fdb_link) {
                TempLink = (fdb_link)TempComponent;
                ++nlinks;
                ++nfobj;
            }
            if (TempComponent instanceof fdb_injection) {
                TempInj = (fdb_injection)TempComponent;
                ++ninj;
                ++nfobj;
            }
            if (TempComponent instanceof fdb_cust) {
                TempCustomer = (fdb_cust)TempComponent;
                ++ncust;
                ++nfobj;
            }
            if (!(TempComponent instanceof fdb_storage)) continue;
            TempSto = (fdb_storage)TempComponent;
            ++nstorage;
            ++nfobj;
        }
        myPrintStream.println("--------------------------------------");
        myPrintStream.println("PIET - EDIT SYSTEM STATISTICS:");
        myPrintStream.println("--------------------------------------");
        myPrintStream.println("System Name             : " + this.sysname);
        myPrintStream.println("Time Horizon from       : " + this.iniperiod + " --> " + this.endperiod);
        myPrintStream.println("Current Period          : " + this.actperiod);
        myPrintStream.println("Current Date            : " + this.actday);
        myPrintStream.println("Current Hour            : " + this.acthour);
        myPrintStream.println("Current Date Type       : " + this.actdaytype);
        myPrintStream.println("Number of Objects       : " + this.Components.size());
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("TRANSPORT NETWORK STATISTICS:");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("    Number of Centroids     = " + ncentroids);
        myPrintStream.println("    Number of Nodes         = " + nnodes);
        myPrintStream.println("    Number of Arcs          = " + narcs);
        myPrintStream.println("    Total Objects Number    = " + ntobj);
        myPrintStream.println("");
        myPrintStream.println("----Centroids Information--------------------------------------------------------------------------------");
        myPrintStream.println("      Nr. Name         Entry  Exit   Life   Inv.   Owner  Lat    Lon    Electric     Initial    Initial  ");
        myPrintStream.println("                       Period Period Time   Cost                        Asociated    Generated  Arrived  ");
        myPrintStream.println("                                                                        Load Name    Travels    Travels                                                              ");
        myPrintStream.println(".........................................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            TempCentroid = (tdb_centroid)TempComponent;
            linea = "   " + StringUtil.printf(ix, 6) + " " + StringUtil.printf(TempCentroid.getName(), 12) + " " + StringUtil.printf(String.valueOf(TempCentroid.getentry_period()), 6) + " " + StringUtil.printf(String.valueOf(TempCentroid.getexit_period()), 6) + " " + StringUtil.printf(String.valueOf(TempCentroid.getlife_time()), 6) + " " + StringUtil.printf(String.valueOf(TempCentroid.getinv_cost()), 6) + " " + StringUtil.printf(String.valueOf(TempCentroid.getinv_owner()), 6) + " " + StringUtil.printf(String.valueOf(TempCentroid.getLatitude()), 6) + " " + StringUtil.printf(String.valueOf(TempCentroid.getLongitude()), 6) + " " + StringUtil.printf(String.valueOf(TempCentroid.getmy_e_consumption()), 12) + " " + StringUtil.printf(String.valueOf(TempCentroid.getgen_travel_ini()), 10) + " " + StringUtil.printf(String.valueOf(TempCentroid.getarriv_travel_ini()), 9) + " ";
            myPrintStream.println(linea);
        }
        myPrintStream.println("");
        myPrintStream.println("----Nodes Information:-----------------------------------------------------------");
        myPrintStream.println("       Nr. Name         Entry  Exit   Life   Inv.   Owner  Lat   Lon    Electric");
        myPrintStream.println("                        Period Period Time   Cost                       Asociated");
        myPrintStream.println("                                                                        Load Name");
        myPrintStream.println(".................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_node)) continue;
            tdb_node TempNode = (tdb_node)TempComponent;
            linea = "    " + StringUtil.printf(ix, 6) + " " + StringUtil.printf(TempNode.getName(), 12) + " " + StringUtil.printf(String.valueOf(TempNode.getentry_period()), 6) + " " + StringUtil.printf(String.valueOf(TempNode.getexit_period()), 6) + " " + StringUtil.printf(String.valueOf(TempNode.getlife_time()), 6) + " " + StringUtil.printf(String.valueOf(TempNode.getinv_cost()), 6) + " " + StringUtil.printf(String.valueOf(TempNode.getinv_owner()), 6) + " " + StringUtil.printf(String.valueOf(TempNode.getLatitude()), 6) + " " + StringUtil.printf(String.valueOf(TempNode.getLongitude()), 6) + " " + StringUtil.printf(String.valueOf(TempNode.getmy_e_consumption()), 6);
            myPrintStream.println(linea);
        }
        myPrintStream.println("");
        myPrintStream.println("----Transport Arcs Information------------------------------------------------------------------------------------");
        myPrintStream.println("   Arc    Arc          Extrem1      Extrem2      Inv.   Entry  Exit   Owner   Type   Electric   Capacity  Length");
        myPrintStream.println("   Nr.    Name                                   Cost   Period Period Name           Asociated                  ");
        myPrintStream.println("                                                                                     Load Name                  ");
        myPrintStream.println("..................................................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_arc)) continue;
            TempArc = (tdb_arc)TempComponent;
            linea = TempArc.Statistic(ix);
            myPrintStream.println(linea);
        }
        myPrintStream.println("");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("ELECTRIC NETWORK STATISTICS:");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("   Number of nodes         : " + numnod);
        myPrintStream.println("   Number of lines         : " + numlin);
        myPrintStream.println("   Number of transformers  : " + numtran);
        myPrintStream.println("   Number of Generators    : " + numgen);
        myPrintStream.println("   Number of Injections    : " + numinj);
        myPrintStream.println("   Number of FACTS         : " + numfacts);
        myPrintStream.println("   Number of Loads         : " + numload);
        myPrintStream.println("   ");
        myPrintStream.println("   ");
        myPrintStream.println("   Total Demand (p)    [MW]   : " + this.totdem);
        myPrintStream.println("   Total Demand (q)    [MVAr] : " + totdemq);
        myPrintStream.println("   Total Demand (pini) [MW]   : " + totdemini);
        myPrintStream.println("   Total Demand (qini) [MVAr] : " + totdeminiq);
        myPrintStream.println("   Maximal Generation  [MW]   : " + maxgen);
        myPrintStream.println("   Maximal Generation  [MVAr] : " + maxgenq);
        myPrintStream.println("  ");
        myPrintStream.println("    Busbar Information:");
        myPrintStream.println("    Busbar Information:-------------");
        myPrintStream.println("    Node      Node   Nomimal V.     ");
        myPrintStream.println("    Nr.      Name     (KV)          ");
        myPrintStream.println("    ................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Busbar)) continue;
            Busbar TempBusbar = (Busbar)TempComponent;
            linea = StringUtil.printf(ix, 4) + StringUtil.printf(TempBusbar.getName(), 12) + StringUtil.printf(TempBusbar.getun1(), 10, 2);
            myPrintStream.println("        " + linea);
        }
        myPrintStream.println("  ");
        myPrintStream.println("   Line Information:------------------------------------------------------------------------------------------------------------------------------------------------------------------");
        myPrintStream.println("   Node     Line     Node 1     Node 2    Inv. Cost      Inv.    Inv.  Life T. Entry P.  SN        Smax       Sc     Imax      UN        RES        REAC          G          B         LEN");
        myPrintStream.println("    Nr.     Name      Name       Name       (US$)        Type   Owner  (year)  (year)   (MVA)      (MVA)     (fac)   (pu)      (KV)     (Ohm/km)   (Ohm/km)   (microS/km) (microS/km)   (km)");
        myPrintStream.println("  ....................................................................................................................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Line)) continue;
            Line TempLine = (Line)TempComponent;
            linea = TempLine.Statistic(ix, this.sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("  ");
        myPrintStream.println("   Trafo Information:");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            linea = TempTrafo.Statistic(ix, this.sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("   Generator Information:");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Generator)) continue;
            TempGenerator = (Generator)TempComponent;
            linea = TempGenerator.Statistic(ix, this.sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("   Load Information:");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof Load)) continue;
            TempLoad = (Load)TempComponent;
            linea = TempLoad.Statistic(ix, this.sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println(" Facts Information:");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof SVC)) continue;
            TempSVC = (SVC)TempComponent;
            linea = TempSVC.Statistic(ix, this.sref);
            myPrintStream.println(linea);
        }
        myPrintStream.println("  ");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("FUEL NETWORK STATISTICS:");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("");
        myPrintStream.println("    Number of Fuel Injections        = " + ninj);
        myPrintStream.println("    Number of Fuel Storages Centers  = " + nstorage);
        myPrintStream.println("    Number of Fuel Links             = " + nlinks);
        myPrintStream.println("    Number of Fuel Customers Centers = " + ncust);
        myPrintStream.println("    Total Fuel Objects Number        = " + nfobj);
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        myPrintStream.println("Injections Information-----------------------------------------------------------------------------------------------");
        myPrintStream.println("  Nr.   Name           Entry  Exit    Inv.   Owner        Lat   Lon    Fuel    Fuel     |                                                                      Fuel Modes Capacity List                                                          |");
        myPrintStream.println("                       Period Period  Cost                             Origin  Capacity |         GAS                     |                 Liquid Fuels                                    |       Petroleum        |          Diessel          |");
        myPrintStream.println("                                                                                         Cr    GC    GL    GN    GO    GR   G81   G86   G91   G93   G93S  G95S G97S   GA    KA      KD   NL   I180  I380  PC#5  PC#6   DA1   DB   DBESC DENAP2 DI");
        myPrintStream.println(".....................................................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_injection)) continue;
            TempInj = (fdb_injection)TempComponent;
            myPrintStream.println(TempInj.Statistics(ix));
        }
        myPrintStream.println("  ");
        myPrintStream.println("Storages Centers Information----------------------------------------------------");
        myPrintStream.println("  Nr.   Name           Entry  Exit    Inv.   Owner        Lat   Lon    Fuel     ");
        myPrintStream.println("                       Period Period  Cost                             Capacity ");
        myPrintStream.println("................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_storage)) continue;
            TempSto = (fdb_storage)TempComponent;
            myPrintStream.println(TempSto.Statistics(ix));
        }
        myPrintStream.println("  ");
        myPrintStream.println("Customers Information----------------------------------------------------------------------------------------------------------------");
        myPrintStream.println("  Nr.   Name           Entry  Exit    Inv.   Owner        Lat   Lon    Interdependence                  |                                                                      Fuel Consumption Grouth                                                           |");
        myPrintStream.println("                       Period Period  Cost                             Conection                        |         GAS                     |                 Liquid Fuels                                    |       Petroleum        |          Diessel          |");
        myPrintStream.println("                                                                                                          Cr    GC    GL    GN    GO    GR   G81   G86   G91   G93   G93S  G95S G97S   GA    KA      KD   NL   I180  I380  PC#5  PC#6   DA1   DB   DBESC DENAP2 DI");
        myPrintStream.println(".....................................................................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_cust)) continue;
            TempCustomer = (fdb_cust)TempComponent;
            myPrintStream.println(TempCustomer.Statistics(ix));
        }
        myPrintStream.println("  ");
        myPrintStream.println("Fuel Links Information--------------------------------------------------------------------------------------");
        myPrintStream.println("   Link   Link         Extrem1      Extrem2      Inv.   Entry  Exit   Owner   Type   Fuel   Capacity  Length");
        myPrintStream.println("   Nr.    Name                                   Cost   Period Period Name           Type                   ");
        myPrintStream.println("............................................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_link)) continue;
            TempLink = (fdb_link)TempComponent;
            myPrintStream.println(TempLink.Statistics(ix));
        }
        myPrintStream.println("  ");
        myPrintStream.println("  ");
        myPrintStream.println("--------------------------------");
        myPrintStream.println("ENVIRONMENTAL INFORMATION:");
        myPrintStream.println("--------------------------------");
        myPrintStream.println(" ");
        myPrintStream.println(" Atmospheric Emissions Per Object------------------------------------------------------");
        myPrintStream.println("    Object    CO      HC      NOx     MP10    SO2     CH4     N2O     NH3     CO2      ");
        myPrintStream.println(" ......................................................................................");
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_arc)) continue;
            TempArc = (tdb_arc)TempComponent;
            linea = "    " + StringUtil.printf(String.valueOf(TempArc.getName()), 10) + "   ";
            for (i = 0; i < 9; ++i) {
                linea = linea + StringUtil.printf(String.valueOf(TempArc.get_f_arc_emissions_at(i)), 7) + " ";
                Arcs_emissions[i] = Arcs_emissions[i] + TempArc.get_f_arc_emissions_at(i);
                Temissions[i] = Temissions[i] + TempArc.get_f_arc_emissions_at(i);
                Totemissions[i] = Totemissions[i] + TempArc.get_f_arc_emissions_at(i);
            }
            myPrintStream.println(linea);
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_centroid)) continue;
            TempCentroid = (tdb_centroid)TempComponent;
            linea = "    " + StringUtil.printf(String.valueOf(TempCentroid.getName()), 10) + "   ";
            for (i = 0; i < 9; ++i) {
                linea = linea + StringUtil.printf(String.valueOf(TempCentroid.get_f_cent_emissions_at(i)), 7) + " ";
                Cent_emissions[i] = Cent_emissions[i] + TempCentroid.get_f_cent_emissions_at(i);
                Temissions[i] = Temissions[i] + TempCentroid.get_f_cent_emissions_at(i);
                Totemissions[i] = Totemissions[i] + TempCentroid.get_f_cent_emissions_at(i);
            }
            myPrintStream.println(linea);
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_link)) continue;
            TempLink = (fdb_link)TempComponent;
            linea = "    " + StringUtil.printf(String.valueOf(TempLink.getName()), 10) + "   ";
            for (i = 0; i < 9; ++i) {
                linea = linea + StringUtil.printf(String.valueOf(TempLink.get_f_link_emissions_at(i)), 7) + " ";
                Link_emissions[i] = Link_emissions[i] + TempLink.get_f_link_emissions_at(i);
                Temissions[i] = Temissions[i] + TempLink.get_f_link_emissions_at(i);
                Totemissions[i] = Totemissions[i] + TempLink.get_f_link_emissions_at(i);
            }
            myPrintStream.println(linea);
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_injection)) continue;
            TempInj = (fdb_injection)TempComponent;
            linea = "    " + StringUtil.printf(String.valueOf(TempInj.getName()), 10) + "   ";
            for (i = 0; i < 9; ++i) {
                linea = linea + StringUtil.printf(String.valueOf(TempInj.get_f_inj_emissions_at(i)), 7) + " ";
                Inj_emissions[i] = Inj_emissions[i] + TempInj.get_f_inj_emissions_at(i);
                Temissions[i] = Temissions[i] + TempInj.get_f_inj_emissions_at(i);
                Totemissions[i] = Totemissions[i] + TempInj.get_f_inj_emissions_at(i);
            }
            myPrintStream.println(linea);
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_cust)) continue;
            TempCustomer = (fdb_cust)TempComponent;
            linea = "    " + StringUtil.printf(String.valueOf(TempCustomer.getName()), 10) + "   ";
            for (i = 0; i < 9; ++i) {
                linea = linea + StringUtil.printf(String.valueOf(TempCustomer.get_f_cus_emissions_at(i)), 7) + " ";
                Cust_emissions[i] = Cust_emissions[i] + TempCustomer.get_f_cus_emissions_at(i);
                Temissions[i] = Temissions[i] + TempCustomer.get_f_cus_emissions_at(i);
                Totemissions[i] = Totemissions[i] + TempCustomer.get_f_cus_emissions_at(i);
            }
            myPrintStream.println(linea);
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_storage)) continue;
            TempSto = (fdb_storage)TempComponent;
            linea = "    " + StringUtil.printf(String.valueOf(TempSto.getName()), 10) + "   ";
            for (i = 0; i < 9; ++i) {
                linea = linea + StringUtil.printf(String.valueOf(TempSto.get_f_sto_emissions_at(i)), 7) + " ";
                Sto_emissions[i] = Sto_emissions[i] + TempSto.get_f_sto_emissions_at(i);
                Temissions[i] = Temissions[i] + TempSto.get_f_sto_emissions_at(i);
                Totemissions[i] = Totemissions[i] + TempSto.get_f_sto_emissions_at(i);
            }
            myPrintStream.println(linea);
        }
        myPrintStream.println("  ");
        myPrintStream.println(" --------------------------------");
        myPrintStream.println(" Environmental Summarize");
        myPrintStream.println(" ................................");
        myPrintStream.println(" ");
        myPrintStream.println(" Atmospheric Emissions Per Network---------------------------------------------------------------");
        myPrintStream.println(" Network    Object    CO      HC      NOx     MP10    SO2     CH4     N2O     NH3     CO2");
        myPrintStream.println(" ................................................................................................");
        linea = " Electric   Generators   ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Gx_emissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
        linea = " Transport  Centroids    ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Cent_emissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
        linea = " Transport  Arcs         ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Arcs_emissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
        linea = " Fuel       Injections   ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Inj_emissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
        linea = " Fuel       Storages     ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Sto_emissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
        linea = " Fuel       Customers    ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Cust_emissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
        linea = " Fuel       Links        ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Link_emissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
        myPrintStream.println(" Total Atmospheric Emissions---------------------------------------------------------------------");
        linea = "                         ";
        for (i = 0; i < 9; ++i) {
            linea = linea + StringUtil.printf(String.valueOf(Totemissions[i]), 7) + " ";
        }
        myPrintStream.println(linea);
    }

    public synchronized void LoadFlow(String NodName, String ModName) {
        this.OSName = System.getProperty("os.name");
        int i = 20;
        try {
            Process p;
            Runtime r = Runtime.getRuntime();
            if (this.OSName.equals("Windows 95") || this.OSName.equals("Windows NT")) {
                p = r.exec(DeepEdit.PathDOS + "deluod.bat");
                p = r.exec(DeepEdit.PathDOS + "LoadFlow.bat");
            } else {
                String[] commando = new String[]{"xterm", "-e", DeepEdit.PathUNIX + "LoadFlow.bat"};
                p = r.exec(commando);
            }
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in Load Flow" + e);
        }
    }

    public void OPF(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        try {
            Process p;
            Runtime r = Runtime.getRuntime();
            if (this.OSName.equals("Windows 95") || this.OSName.equals("Windows NT")) {
                p = r.exec(DeepEdit.PathDOS + "OPF.bat");
            } else {
                String[] commando = new String[]{"xterm", "-e", DeepEdit.PathUNIX + "OPF.bat"};
                p = r.exec(commando);
            }
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in OPF" + e);
        }
    }

    public void SQPV(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        String commando = this.tiposimula == 0 ? "xterm -e ./SQPV0.bat" : "xterm -e ./SQPV1.bat";
        try {
            Runtime r = Runtime.getRuntime();
            Process p = this.OSName.equals("Windows 95") || this.OSName.equals("Windows NT") ? (this.tiposimula == 0 ? r.exec(DeepEdit.PathDOS + "SQPV0.bat") : r.exec(DeepEdit.PathDOS + "SQPV1.bat")) : r.exec(commando);
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in SQPV" + e);
        }
    }

    public void ECD(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        try {
            Process p;
            Runtime r = Runtime.getRuntime();
            if (this.OSName.equals("Windows 95") || this.OSName.equals("Windows NT")) {
                p = r.exec(DeepEdit.PathDOS + "ECD.bat");
            } else {
                String[] commando = new String[]{"xterm", "-e", DeepEdit.PathUNIX + "ECD.bat"};
                p = r.exec(commando);
            }
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in ECD" + e);
        }
    }

    public void ECD_SQP(String NodName, String ModName) {
        int i = 20;
        this.OSName = System.getProperty("os.name");
        String commando = this.tiposimula == 0 ? "xterm -e ./ECD_SQP0.bat" : "xterm -e ./ECD_SQP1.bat";
        try {
            Runtime r = Runtime.getRuntime();
            Process p = this.OSName.equals("Windows 95") || this.OSName.equals("Windows NT") ? (this.tiposimula == 0 ? r.exec(DeepEdit.PathDOS + "ECD_SQP0.bat") : r.exec(DeepEdit.PathDOS + "ECD_SQP1.bat")) : r.exec(commando);
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("Error in ECD_SQP" + e);
        }
    }

    public void Save(FileOutputStream os) throws IOException, FileFormatException {
        comp TempComponent;
        int ix = 0;
        int count = 0;
        int ixx = 0;
        LaunchProgressFrame saveLaunchFrame = null;
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("# PietEdit file");
        myPrintStream.println("version 1 0");
        myPrintStream.println("describe component System");
        myPrintStream.println(" sysname       " + this.sysname);
        myPrintStream.println(" sref          " + this.sref);
        myPrintStream.println(" iniperiod     " + this.iniperiod);
        myPrintStream.println(" endperiod     " + this.endperiod);
        myPrintStream.println(" actperiod     " + this.actperiod);
        myPrintStream.println(" actday " + this.actday);
        myPrintStream.println(" actdaytype " + this.actdaytype);
        myPrintStream.println(" acthour " + this.acthour);
        myPrintStream.println(" stepperiod    " + this.stepperiod);
        myPrintStream.println(" peaksim       " + this.peaksim);
        myPrintStream.println(" customsim     " + this.customsim);
        myPrintStream.println(" meansim       " + this.meansim);
        myPrintStream.println(" lowsim        " + this.lowsim);
        myPrintStream.println(" intrate       " + this.intrate);
        myPrintStream.println(" loadfac1      " + this.loadfac1);
        myPrintStream.println(" loadfac2      " + this.loadfac2);
        myPrintStream.println("end describe");
        count = this.Components.size() >= 100 ? 100 : this.Components.size();
        saveLaunchFrame = new LaunchProgressFrame("Saving File: ", count);
        saveLaunchFrame.show();
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp)) continue;
            TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof tdb_comp)) continue;
            TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (!(TempComponent instanceof fdb_comp)) continue;
            TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        for (ix = 0; ix < this.Components.size(); ++ix) {
            TempComponent = (comp)this.Components.elementAt(ix);
            if (TempComponent instanceof ndb_comp || TempComponent instanceof tdb_comp || TempComponent instanceof fdb_comp) continue;
            TempComponent.Save(myPrintStream);
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        saveLaunchFrame.dispose();
        saveLaunchFrame = null;
        os.close();
    }

    public void SaveDatabase() throws SQLException {
        int x = 0;
        int ixx = 0;
        int count = 0;
        LaunchProgressFrame saveLaunchFrame = null;
        Statement stmt = PietEditFrame.con.createStatement();
        String query = "DELETE * FROM System";
        x = stmt.executeUpdate(query);
        query = "INSERT INTO System (sysname,sref,iniperiod,endperiod,actperiod,actday,actdaytype,acthour,stepperiod,peaksim,customsim,meansim,lowsim,intrate,loadfac1,loadfac2) VALUES ('" + this.sysname + "'," + String.valueOf(this.sref) + "," + String.valueOf(this.iniperiod) + "," + String.valueOf(this.endperiod) + "," + String.valueOf(this.actperiod) + ",'" + String.valueOf(this.actday) + "','" + String.valueOf(this.actdaytype) + "','" + String.valueOf(this.acthour) + "'," + String.valueOf(this.stepperiod) + "," + String.valueOf(this.peaksim) + "," + String.valueOf(this.customsim) + "," + String.valueOf(this.meansim) + "," + String.valueOf(this.lowsim) + "," + String.valueOf(this.intrate) + "," + String.valueOf(this.loadfac1) + "," + String.valueOf(this.loadfac2) + ")";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM Busbar";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM Caption";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM planpro";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM Generator";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM Injection";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM Line";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM Load";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM fdb_cust";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM fdb_storage";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM fdb_injection";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM fdb_link";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM Trafo";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM tdb_node";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM tdb_centroid";
        x = stmt.executeUpdate(query);
        query = "DELETE * FROM tdb_arc";
        x = stmt.executeUpdate(query);
        count = this.Components.size() >= 100 ? 100 : this.Components.size();
        saveLaunchFrame = new LaunchProgressFrame("Saving Database: ", count);
        saveLaunchFrame.show();
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            TempComponent.SaveDatabase();
            if (saveLaunchFrame == null || ++ixx > 100) continue;
            saveLaunchFrame.updateProgress();
        }
        saveLaunchFrame.dispose();
        saveLaunchFrame = null;
        stmt.close();
    }

    public boolean PlaceJunction(Pin[][] PinGrid, int x, int y, int gs) {
        boolean JunctionPlaced = false;
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            fdb_link TempfLink;
            tdb_arc TemptLink;
            comp TempComponent = (comp)this.Components.elementAt(ix);
            if (TempComponent instanceof tdb_arc && (TemptLink = (tdb_arc)TempComponent).TryPlaceJunction(this, PinGrid, x, y, gs)) {
                JunctionPlaced = true;
            }
            if (!(TempComponent instanceof fdb_link) || !(TempfLink = (fdb_link)TempComponent).TryPlaceJunction(this, PinGrid, x, y, gs)) continue;
            JunctionPlaced = true;
        }
        return JunctionPlaced;
    }

    public void SwapComponents(comp c1, comp c2) {
        int ix1 = this.Components.indexOf(c1);
        int ix2 = this.Components.indexOf(c2);
        if (ix1 == -1 || ix2 == -1) {
            return;
        }
        this.Components.setElementAt(c1, ix2);
        this.Components.setElementAt(c2, ix1);
    }

    public void BringToFront(comp c) {
        int ix1 = this.Components.indexOf(c);
        if (ix1 == -1 || ix1 == this.Components.size() - 1) {
            return;
        }
        for (int ix = ix1 + 1; ix < this.Components.size(); ++ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            this.Components.setElementAt(TempComponent, ix - 1);
        }
        this.Components.setElementAt(c, this.Components.size() - 1);
    }

    public void SlackFirst() {
        System.out.println("In SlackFirst");
        for (int ix = 0; ix < this.Components.size(); ++ix) {
            ndb_1pol Temp1pol;
            this.TempComponent = (comp)this.Components.elementAt(ix);
            if (!(this.TempComponent instanceof ndb_1pol) || !this.TempComponent.getactive() || !this.TempComponent.getinservice() || (Temp1pol = (ndb_1pol)this.TempComponent).getlf_type_s() != 3) continue;
            System.out.println("In SlackFirst " + this.TempComponent.getName());
            this.SendToBack(this.TempComponent);
            return;
        }
        System.out.println("Caution: No slack type in the system!!");
    }

    public void SendToBack(comp c) {
        int ix1 = this.Components.indexOf(c);
        if (ix1 == -1 || ix1 == 0) {
            return;
        }
        for (int ix = ix1 - 1; ix > -1; --ix) {
            comp TempComponent = (comp)this.Components.elementAt(ix);
            this.Components.setElementAt(TempComponent, ix + 1);
        }
        this.Components.setElementAt(c, 0);
    }

    static void waits(String mess) {
        int aux = 0;
        if (!mess.equals(" ")) {
            System.out.println(mess);
        }
        try {
            aux = Integer.parseInt(din.readLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

