/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.Load;
import de.core.PIETException;
import de.core.PietMECSEFrame;
import de.core.Schematic;
import de.core.comp;
import java.awt.Choice;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public final class PietMECSE
extends AnalysisTool {
    public static int NOTEPAD = 1;
    public static int ZFILEVIWER = 0;
    String seedsExeFile = "..\\run\\plpfiles\\plposl.exe";
    String seedsWorkPath = "..\\run\\plpfiles";
    String seedsTempPath = "..\\run\\plpfiles";
    Connection dbConn = null;
    DeepEdit applet;
    PietMECSEFrame myPietMECSEFrame = null;
    String query;
    Statement stmt;
    ResultSet rs;
    boolean more;
    private OutputStream message_os;
    public PrintWriter message_pw;
    private Generator[][] genersArr = null;
    private Load[][] loadArr = null;
    private double[][][] anLoadPmed = null;
    private double[][] genersFPmed = null;
    private String[][] genersFuelS = null;
    private double[][][] genersCEmiF = null;
    private String[][] genersZones = null;
    private int[][] genersFuelI = null;
    private String[] allSystems = null;
    private Vector allFuels = null;
    private Vector allZones = null;
    private double[][][] anGenPmed = null;
    private int[][] anMgGenIx = null;
    private double[][][][] fuelCEmi = null;
    private String ctrlArea = "Todas";
    public int iniYear = 2003;
    public int endYear = 2015;
    private static String[] genConEmiKey = new String[]{"Consumo", "CO", "COV_HC", "NOX", "MP10", "SO2", "CH4", "N2O", "NH3", "CO2", "CO2Eq"};

    public PietMECSE(Schematic sch, DeepEdit app) {
        super(sch);
        this.applet = app;
        try {
            System.out.println("-------------------------------------------------------------------");
            System.out.println("INICIO: Modelo de Emisiones y Combustibles en Sistemas Electricos");
            System.out.println("-------------------------------------------------------------------");
            this.message_os = new FileOutputStream(new File("MECSE.log"));
            this.message_pw = new PrintWriter(this.message_os);
            PrintStream PS = new PrintStream(this.message_os);
            System.setErr(PS);
            this.dbConn = DeepEditFrame.conPIETDB;
            this.iniYear = this.getParam_Sim("Ano_Inicio");
            this.endYear = this.getParam_Sim("Ano_Fin");
            this.myPietMECSEFrame = new PietMECSEFrame(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkData() {
    }

    public void loadObjFromSchem() throws PIETException {
        int ix;
        if (this.ctrlArea.equals("Todas")) {
            Choice tempCh = new Choice();
            this.ActSchematic.LoadCtrla(tempCh);
            this.allSystems = new String[tempCh.getItemCount()];
            for (ix = 0; ix < this.allSystems.length; ++ix) {
                this.allSystems[ix] = tempCh.getItem(ix);
            }
        } else {
            this.allSystems = new String[1];
            this.allSystems[0] = this.ctrlArea;
        }
        this.genersArr = new Generator[this.allSystems.length][0];
        this.loadArr = new Load[this.allSystems.length][0];
        for (ix = 0; ix < this.allSystems.length; ++ix) {
            this.genersArr[ix] = this.getGenArr(this.allSystems[ix]);
            this.loadArr[ix] = this.getLoaArr(this.allSystems[ix]);
        }
    }

    public void loadDemFromDB() throws PIETException {
        int jx;
        this.anLoadPmed = new double[this.loadArr.length][0][0];
        for (jx = 0; jx < this.loadArr.length; ++jx) {
            this.anLoadPmed[jx] = new double[this.loadArr[jx].length][this.endYear - this.iniYear + 1];
        }
        try {
            this.stmt = this.dbConn.createStatement();
            for (int ix = 0; ix < this.loadArr.length; ++ix) {
                for (jx = 0; jx < this.loadArr[ix].length; ++jx) {
                    int from = Math.max(this.iniYear, this.loadArr[ix][jx].entry_period);
                    int to = Math.min(this.endYear, this.loadArr[ix][jx].exit_period);
                    this.rs = this.stmt.executeQuery("SELECT * FROM MECSE_Dem_An_Pmed WHERE (Nom_Carga='" + this.loadArr[ix][jx].getName() + "') AND (Ano>=" + from + ") AND (Ano<=" + to + ") ORDER BY Ano");
                    int countYear = from;
                    while (this.rs.next()) {
                        int currYear = this.rs.getInt("Ano");
                        double valPmed = this.rs.getDouble("Pmed");
                        if (countYear == currYear) {
                            this.anLoadPmed[ix][jx][countYear - this.iniYear] = valPmed;
                            ++countYear;
                            continue;
                        }
                        throw new PIETException("Informacion no encontrada, tabla 'MECSE_Dem_An_Pmed', Carga '" + this.loadArr[ix][jx].getName() + "', a\u00f1o " + countYear + ", PIETDB");
                    }
                    if (countYear - 1 == to) continue;
                    if (countYear == from) {
                        ++countYear;
                    }
                    throw new PIETException("Informacion no encontrada, tabla 'MECSE_Dem_An_Pmed', Carga '" + this.loadArr[ix][jx].getName() + "', a\u00f1o " + (countYear - 1) + ", PIETDB");
                }
            }
        }
        catch (SQLException e) {
            throw new PIETException("imposible leer tabla 'MECSE_Dem_An_Pmed', PIETDB");
        }
    }

    public void loadData() throws PIETException {
        int countreg;
        int jx;
        int ix;
        boolean sincro = false;
        System.out.println("Leyendo DB info...");
        this.loadObjFromSchem();
        this.loadDemFromDB();
        this.genersFPmed = new double[this.genersArr.length][0];
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            this.genersFPmed[ix] = new double[this.genersArr[ix].length];
        }
        try {
            for (ix = 0; ix < this.genersArr.length; ++ix) {
                for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                    this.rs = this.stmt.executeQuery("SELECT * FROM MECSE_Gen_FPlantaM WHERE (Nom_Gen='" + this.genersArr[ix][jx].getName() + "')");
                    countreg = 0;
                    while (this.rs.next()) {
                        if (countreg > 0) {
                            throw new PIETException("valor multiple, tabla 'MECSE_Gen_FPlantaM', Nom_Gen '" + this.genersArr[ix][jx].getName() + ", PIETDB");
                        }
                        this.genersFPmed[ix][jx] = this.rs.getDouble("FPlantaM") / 100.0;
                        ++countreg;
                    }
                    if (countreg == 1) continue;
                    throw new PIETException("valor no encontrado, tabla 'MECSE_Gen_FPlantaM', Nom_Gen '" + this.genersArr[ix][jx].getName() + ", PIETDB");
                }
            }
        }
        catch (SQLException e) {
            throw new PIETException("imposible leer tabla 'MECSE_Gen_FPlantaM', PIETDB");
        }
        this.genersZones = new String[this.genersArr.length][0];
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            this.genersZones[ix] = new String[this.genersArr[ix].length];
        }
        try {
            for (ix = 0; ix < this.genersArr.length; ++ix) {
                for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                    this.rs = this.stmt.executeQuery("SELECT * FROM MECSE_Gen_Zona WHERE (Nom_Gen='" + this.genersArr[ix][jx].getName() + "')");
                    countreg = 0;
                    while (this.rs.next()) {
                        if (countreg > 0) {
                            throw new PIETException("valor multiple, tabla 'MECSE_Gen_Zona', Nom_Gen '" + this.genersArr[ix][jx].getName() + ", PIETDB");
                        }
                        this.genersZones[ix][jx] = this.rs.getString("Zona");
                        ++countreg;
                    }
                    if (countreg == 1) continue;
                    throw new PIETException("valor no encontrado, tabla 'MECSE_Gen_Zona', Nom_Gen '" + this.genersArr[ix][jx].getName() + ", PIETDB");
                }
            }
        }
        catch (SQLException e) {
            throw new PIETException("imposible leer tabla 'MECSE_Gen_Zona', PIETDB");
        }
        this.genersFuelS = new String[this.genersArr.length][0];
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            this.genersFuelS[ix] = new String[this.genersArr[ix].length];
        }
        this.genersCEmiF = new double[this.genersArr.length][0][0];
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            this.genersCEmiF[ix] = new double[this.genersArr[ix].length][genConEmiKey.length];
        }
        try {
            for (ix = 0; ix < this.genersArr.length; ++ix) {
                for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                    if (!this.genersArr[ix][jx].getinv_type().equalsIgnoreCase("thermal")) {
                        this.genersFuelS[ix][jx] = "";
                        continue;
                    }
                    this.rs = this.stmt.executeQuery("SELECT * FROM MECSE_Gen_Comb_Emi WHERE (Nom_Gen='" + this.genersArr[ix][jx].getName() + "')");
                    countreg = 0;
                    while (this.rs.next()) {
                        if (countreg > 0) {
                            throw new PIETException("registro multiple, tabla 'MECSE_Gen_Comb_Emi', Nom_Gen '" + this.genersArr[ix][jx].getName() + ", PIETDB");
                        }
                        this.genersFuelS[ix][jx] = this.rs.getString("Combustible");
                        for (int kx = 0; kx < genConEmiKey.length; ++kx) {
                            this.genersCEmiF[ix][jx][kx] = this.rs.getDouble(genConEmiKey[kx]);
                        }
                        ++countreg;
                    }
                    if (countreg == 1) continue;
                    throw new PIETException("registro no encontrado, tabla 'MECSE_Gen_Comb_Emi', Nom_Gen '" + this.genersArr[ix][jx].getName() + ", PIETDB");
                }
            }
        }
        catch (SQLException e) {
            throw new PIETException("imposible leer tabla 'MECSE_Gen_Comb_Emi', PIETDB");
        }
        System.out.println("DB info cargada.");
    }

    public void calculate(String pctrla) throws Exception {
        int jxt;
        int jx;
        int kx;
        int ix;
        this.ctrlArea = pctrla;
        this.loadData();
        int nyears = this.endYear - this.iniYear + 1;
        double[][] annDmed = new double[this.loadArr.length][nyears];
        for (ix = 0; ix < this.loadArr.length; ++ix) {
            for (kx = 0; kx < nyears; ++kx) {
                for (jx = 0; jx < this.anLoadPmed[ix].length; ++jx) {
                    if (this.loadArr[ix][jx].entry_period > this.iniYear + ix || this.loadArr[ix][jx].exit_period < this.iniYear + ix) continue;
                    double factor = 1.0;
                    if (this.loadArr[ix][jx].entry_period == this.iniYear + ix) {
                        factor = (13 - this.loadArr[ix][jx].entry_month) / 12;
                    } else if (this.loadArr[ix][jx].exit_period == this.iniYear + ix) {
                        factor = (this.loadArr[ix][jx].exit_month - 1) / 12;
                    }
                    double[] dArray = annDmed[ix];
                    int n = kx;
                    dArray[n] = dArray[n] + factor * this.anLoadPmed[ix][jx][kx];
                }
            }
        }
        int[][] genL2HCostListIx = new int[this.genersArr.length][0];
        this.anMgGenIx = new int[this.genersArr.length][nyears];
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            genL2HCostListIx[ix] = new int[this.genersArr[ix].length];
        }
        this.anGenPmed = new double[this.genersArr.length][0][0];
        for (jx = 0; jx < this.genersArr.length; ++jx) {
            this.anGenPmed[jx] = new double[this.genersArr[jx].length][this.endYear - this.iniYear + 1];
        }
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                genL2HCostListIx[ix][jx] = jx;
            }
        }
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                int minIx = jx;
                for (kx = jx + 1; kx < this.genersArr[ix].length; ++kx) {
                    if (!(this.genersArr[ix][genL2HCostListIx[ix][kx]].getbeta() < this.genersArr[ix][genL2HCostListIx[ix][minIx]].getbeta())) continue;
                    minIx = kx;
                }
                jxt = genL2HCostListIx[ix][jx];
                genL2HCostListIx[ix][jx] = genL2HCostListIx[ix][minIx];
                genL2HCostListIx[ix][minIx] = jxt;
            }
        }
        this.message_pw.println("Generator Minimum Cost Order");
        for (ix = 0; ix < genL2HCostListIx.length; ++ix) {
            for (jx = 0; jx < genL2HCostListIx[ix].length; ++jx) {
                this.message_pw.println("'" + jx + ": '" + this.genersArr[ix][genL2HCostListIx[ix][jx]].getName() + "'\t\t\t ," + this.genersArr[ix][genL2HCostListIx[ix][jx]].getbeta());
            }
        }
        this.anGenPmed = new double[this.genersArr.length][0][0];
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            this.anGenPmed[ix] = new double[this.genersArr[ix].length][nyears];
        }
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            for (kx = 0; kx < nyears; ++kx) {
                double actMPower = annDmed[ix][kx];
                for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                    jxt = genL2HCostListIx[ix][jx];
                    if (this.genersArr[ix][jxt].entry_period > this.iniYear + kx || this.genersArr[ix][jxt].exit_period < this.iniYear + kx) continue;
                    if (!(actMPower > 0.0)) break;
                    this.anGenPmed[ix][jxt][kx] = Math.min(this.genersArr[ix][jxt].getpmax() * this.genersFPmed[ix][jxt], actMPower);
                    actMPower -= this.anGenPmed[ix][jxt][kx];
                    this.anMgGenIx[ix][kx] = jxt;
                }
                if (!(actMPower > 0.001)) continue;
                this.anMgGenIx[ix][kx] = -1;
            }
        }
        this.allFuels = new Vector(10);
        this.allZones = new Vector(50);
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                if (!this.genersFuelS[ix][jx].equals("") && this.allFuels.indexOf(this.genersFuelS[ix][jx]) < 0) {
                    this.allFuels.add(this.genersFuelS[ix][jx]);
                }
                if (this.allZones.indexOf(this.genersZones[ix][jx]) >= 0) continue;
                this.allZones.add(this.genersZones[ix][jx]);
            }
        }
        this.fuelCEmi = new double[this.allZones.size()][nyears][this.allFuels.size()][genConEmiKey.length];
        for (ix = 0; ix < this.anGenPmed.length; ++ix) {
            for (jx = 0; jx < this.anGenPmed[ix].length; ++jx) {
                if (this.genersFuelS[ix][jx].equals("")) continue;
                int zIx = this.allZones.indexOf(this.genersZones[ix][jx]);
                int fIx = this.allFuels.indexOf(this.genersFuelS[ix][jx]);
                if (zIx < 0 || fIx < 0) {
                    throw new PIETException("interno, no se puede encontrar \u00edndice de zona o combustible");
                }
                for (kx = 0; kx < this.anGenPmed[ix][jx].length; ++kx) {
                    for (int lx = 0; lx < genConEmiKey.length; ++lx) {
                        double[] dArray = this.fuelCEmi[zIx][kx][fIx];
                        int n = lx;
                        dArray[n] = dArray[n] + this.anGenPmed[ix][jx][kx] * this.genersCEmiF[ix][jx][lx] * 8.76;
                    }
                }
            }
        }
        System.out.print("Escribiendo Resultados en PIETDB... ");
        this.writeResults2DB(this.message_pw);
        System.out.println("OK !");
        this.message_pw.println("Marginal Prices");
        for (ix = 0; ix < this.anMgGenIx.length; ++ix) {
            for (jx = 0; jx < this.anMgGenIx[ix].length; ++jx) {
                if (this.anMgGenIx[ix][jx] > -1) {
                    this.message_pw.println("" + (this.iniYear + jx) + ": '" + this.genersArr[ix][this.anMgGenIx[ix][jx]].getName() + "' ," + this.genersArr[ix][this.anMgGenIx[ix][jx]].getbeta());
                    continue;
                }
                this.message_pw.println("" + (this.iniYear + jx) + ": Load Fault");
            }
        }
        try {
            this.message_pw.close();
            this.message_os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeResults2DB(PrintWriter message_pw) throws Exception {
        String vals;
        int kx;
        int jx;
        int ix;
        int lx;
        this.stmt = this.dbConn.createStatement();
        this.stmt.executeUpdate("DELETE * FROM MECSE_Res_CombEmi_Zona");
        String cols = "Zona, Combustible, Ano";
        for (lx = 0; lx < genConEmiKey.length; ++lx) {
            cols = cols + ", " + genConEmiKey[lx];
        }
        for (ix = 0; ix < this.fuelCEmi.length; ++ix) {
            for (jx = 0; jx < this.fuelCEmi[ix].length; ++jx) {
                for (kx = 0; kx < this.fuelCEmi[ix][jx].length; ++kx) {
                    vals = "'" + (String)this.allZones.elementAt(ix) + "', '" + this.allFuels.elementAt(kx) + "', " + (jx + this.iniYear);
                    boolean isZeroReg = true;
                    for (lx = 0; lx < genConEmiKey.length; ++lx) {
                        vals = vals + ", " + this.fuelCEmi[ix][jx][kx][lx];
                        if (!isZeroReg || !(this.fuelCEmi[ix][jx][kx][lx] > 0.0)) continue;
                        isZeroReg = false;
                    }
                    if (isZeroReg) continue;
                    this.stmt.executeUpdate("INSERT INTO MECSE_Res_CombEmi_Zona (" + cols + ")" + " VALUES (" + vals + ")");
                }
            }
        }
        this.stmt = this.dbConn.createStatement();
        this.stmt.executeUpdate("DELETE * FROM MECSE_Res_GenMed");
        cols = "Sistema, Ano, Nom_Gen, Pmed";
        for (ix = 0; ix < this.anGenPmed.length; ++ix) {
            for (jx = 0; jx < this.anGenPmed[ix].length; ++jx) {
                for (kx = 0; kx < this.anGenPmed[ix][jx].length; ++kx) {
                    vals = "'" + this.allSystems[ix] + "', " + (kx + this.iniYear) + ", '" + this.genersArr[ix][jx].getName() + "', " + this.anGenPmed[ix][jx][kx];
                    this.stmt.executeUpdate("INSERT INTO MECSE_Res_GenMed (" + cols + ")" + " VALUES (" + vals + ")");
                }
            }
        }
    }

    public Connection OpenDataBase(String DBName, String user, String password) throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println("Error: en Connection OpenDatabase " + message);
            return null;
        }
        String dsn = "jdbc:odbc:" + DBName;
        return DriverManager.getConnection(dsn, user, password);
    }

    public int getParam_Sim(String Prameter) throws PIETException {
        int value;
        try {
            this.stmt = this.dbConn.createStatement();
            this.rs = this.stmt.executeQuery("SELECT * FROM Param_Sim WHERE Parametro='" + Prameter + "'");
            value = -1;
            while (this.rs.next()) {
                value = this.rs.getInt("Valor");
            }
            this.stmt.close();
        }
        catch (SQLException e) {
            throw new PIETException("Problemas al leer tabla 'Param_Sim', PIETDB");
        }
        if (value == -1) {
            throw new PIETException(" '" + Prameter + "' erroneo o no encontrado en tabla 'Param_Sim', PIETDB");
        }
        return value;
    }

    private Generator[] getGenArr(String ctrla) throws PIETException {
        int ix;
        Vector<Generator> genVec = new Vector<Generator>(60);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Generator tempGen;
            comp tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(tempcomp instanceof Generator) || !tempcomp.getinservice() || !(tempGen = (Generator)tempcomp).getctrla().equals(ctrla)) continue;
            genVec.add(tempGen);
        }
        Generator[] gArr = new Generator[genVec.size()];
        if (genVec.size() == 0) {
            throw new PIETException("Area de control '" + ctrla + "' sin generadores.");
        }
        for (ix = 0; ix < genVec.size(); ++ix) {
            gArr[ix] = (Generator)genVec.elementAt(ix);
        }
        return gArr;
    }

    private Load[] getLoaArr(String ctrla) throws PIETException {
        int ix;
        Vector<Load> loaVec = new Vector<Load>(60);
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Load tempLoad;
            comp tempcomp = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(tempcomp instanceof Load) || !tempcomp.getinservice() || !(tempLoad = (Load)tempcomp).getctrla().equals(ctrla)) continue;
            loaVec.add(tempLoad);
        }
        Load[] lArr = new Load[loaVec.size()];
        if (loaVec.size() == 0) {
            throw new PIETException("Area de control '" + ctrla + "' sin cargas.");
        }
        for (ix = 0; ix < loaVec.size(); ++ix) {
            lArr[ix] = (Load)loaVec.elementAt(ix);
        }
        return lArr;
    }

    public void loadGenResFromDB() throws PIETException {
        int jx;
        this.anGenPmed = new double[this.genersArr.length][0][0];
        for (jx = 0; jx < this.genersArr.length; ++jx) {
            this.anGenPmed[jx] = new double[this.genersArr[jx].length][this.endYear - this.iniYear + 1];
        }
        try {
            this.stmt = this.dbConn.createStatement();
            for (int ix = 0; ix < this.genersArr.length; ++ix) {
                for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                    int from = Math.max(this.iniYear, this.genersArr[ix][jx].entry_period);
                    int to = Math.min(this.endYear, this.genersArr[ix][jx].exit_period);
                    this.rs = this.stmt.executeQuery("SELECT * FROM MECSE_Res_GenMed WHERE (Nom_Gen='" + this.genersArr[ix][jx].getName() + "') AND (Ano>=" + from + ") AND (Ano<=" + to + ") ORDER BY Ano");
                    int countYear = from;
                    while (this.rs.next()) {
                        int currYear = this.rs.getInt("Ano");
                        double valPmed = this.rs.getDouble("Pmed");
                        if (countYear == currYear) {
                            this.anGenPmed[ix][jx][countYear - this.iniYear] = valPmed;
                            ++countYear;
                            continue;
                        }
                        throw new PIETException("resultado no encontrado para el Generador '" + this.genersArr[ix][jx].getName() + "', a\u00f1o " + countYear + ". Efectuar c\u00e1lculo para el sistema seleccionado o para todas los sistemas");
                    }
                    if (countYear - 1 == to) continue;
                    if (countYear == from) {
                        ++countYear;
                    }
                    throw new PIETException("resultado no encontrado para el Generador '" + this.genersArr[ix][jx].getName() + "', a\u00f1o " + (countYear - 1) + ". Efectuar c\u00e1lculo para el sistema seleccionado o para todas los sistemas");
                }
            }
        }
        catch (SQLException e) {
            throw new PIETException("imposible leer resultado 'MECSE_Res_GenMed', PIETDB");
        }
    }

    public void loadDisp2Schem(int year, String pctrla) throws PIETException {
        int jx;
        int ix;
        System.out.print("Cargando despacho uninodal medio para a\u00f1o " + year + " ...");
        if (!this.ctrlArea.equals(pctrla)) {
            this.ctrlArea = pctrla;
            this.allSystems = null;
        }
        if (this.allSystems == null) {
            this.loadObjFromSchem();
        }
        if (this.anLoadPmed == null) {
            this.loadDemFromDB();
        }
        if (this.anGenPmed == null) {
            this.loadGenResFromDB();
        }
        for (ix = 0; ix < this.loadArr.length; ++ix) {
            for (jx = 0; jx < this.loadArr[ix].length; ++jx) {
                this.loadArr[ix][jx].setp0(this.anLoadPmed[ix][jx][year - this.iniYear]);
                this.loadArr[ix][jx].setp(this.anLoadPmed[ix][jx][year - this.iniYear]);
            }
        }
        for (ix = 0; ix < this.genersArr.length; ++ix) {
            for (jx = 0; jx < this.genersArr[ix].length; ++jx) {
                this.genersArr[ix][jx].setp0(this.anGenPmed[ix][jx][year - this.iniYear]);
                this.genersArr[ix][jx].setp(this.anGenPmed[ix][jx][year - this.iniYear]);
            }
        }
        this.ActSchematic.settiposimula(6);
        PietMECSE pietMECSE = this;
        pietMECSE.applet.SimulateSetUp();
        this.ActSchematic.Modified = false;
        this.ActSchematic.Modifiedstate = false;
        this.ActSchematic.changeGIS = true;
        DeepEdit.MySchematicPanel.repaint();
        System.out.println(" hecho!");
    }
}

