/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.PietEditFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.ImageObserver;

class PietDialogPanel
extends Panel
implements ImageObserver {
    PietEditFrame frame = null;
    static final int HORIZONTAL_GAP = 50;
    protected Font SimpleDialogFont;
    protected FontMetrics SimpleDialogFontMetrics;
    String Capt;
    int CaptWidth;
    Image ImageToDisplay = null;
    int imgw = 0;
    int imgh = 0;
    static final long updateRate = 100L;

    public PietDialogPanel(PietEditFrame f, String capt, int ImageID) {
        this.frame = f;
        this.Capt = capt;
        this.getImage(ImageID);
        this.setLayout(new BorderLayout());
        this.SimpleDialogFont = PietEditFrame.TextFont;
        this.SimpleDialogFontMetrics = this.getFontMetrics(this.SimpleDialogFont);
        this.setFont(this.SimpleDialogFont);
        super.setLayout(new BorderLayout());
        this.CaptWidth = this.SimpleDialogFontMetrics.stringWidth(capt);
        this.repaint();
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(50 + this.CaptWidth, 145);
    }

    @Override
    public void paint(Graphics g) {
        if (this.ImageToDisplay != null) {
            g.drawImage(this.ImageToDisplay, 20, 10, this);
            g.setColor(Color.black);
            int x = (this.getSize().width - this.CaptWidth) / 2 + this.imgw + 20;
            if (x < this.imgw + 50) {
                x = this.imgw + 50;
            }
            g.drawString(this.Capt, x, 30);
        } else {
            g.setColor(Color.black);
            int x = (this.getSize().width - this.CaptWidth) / 2;
            g.drawString(this.Capt, x, 30);
        }
    }

    public void getImage(int ImageID) {
        String FileName = null;
        switch (ImageID) {
            case 1: {
                FileName = "images/stop.gif";
                break;
            }
            case 2: {
                FileName = "images/warning.gif";
                break;
            }
            case 3: {
                FileName = "images/switch.gif";
                break;
            }
            default: {
                return;
            }
        }
        if (this.frame != null) {
            this.ImageToDisplay = this.frame.applet.getImage(this.frame.applet.getDocumentBase(), FileName);
        }
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        boolean ret = true;
        boolean dopaint = false;
        long updatetime = 0L;
        if ((infoflags & 1) != 0) {
            this.imgw = w;
            dopaint = true;
        }
        if ((infoflags & 2) != 0) {
            this.imgh = h;
            dopaint = true;
        }
        if ((infoflags & 0x30) != 0) {
            dopaint = true;
            ret = false;
        } else if ((infoflags & 8) != 0) {
            dopaint = true;
            updatetime = 100L;
        }
        if ((infoflags & 0x40) != 0) {
            ret = false;
        }
        if (dopaint) {
            this.repaint(updatetime);
        }
        return ret;
    }
}

