/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.ImageButton;
import de.core.PietEditFrame;
import de.core.SimpleDialog;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.Vector;

class PietControlPanel
extends Canvas {
    Vector buttons;
    DeepEdit applet;
    PietEditFrame papplet;
    Image ImageBuffer = null;
    Image CopyImage = null;
    Graphics cig;
    int ButtonOffset = 0;
    ImageButton PressedButton = null;
    boolean ImageButtonsDisabled = false;
    int[] points = new int[]{0, 24, 48, 80, 104, 128, 160, 184, 208, 232, 264, 288, 312, 344, 368, 392, 416, 448};
    String[] botones = new String[]{"New", "Open", "Save", "Cut", "Copy", "Paste", "Pointer", "Simulate", "Junction", "Text", "Node", "Centroid", "Arc", "FInjection", "Customer", "Link", "Storage", "Help"};

    public PietControlPanel(PietEditFrame pef) {
        this.papplet = pef;
        this.applet = pef.applet;
        this.buttons = new Vector();
        this.LoadButtonsImage();
        for (int i = 0; i < 17; ++i) {
            this.buttons.addElement(new ImageButton(this.botones[i], this.points[i]));
        }
        if (this.ImageButtonsDisabled) {
            this.setSize(this.getSize().width, 36);
        } else {
            this.setSize(this.getSize().width, 4);
        }
    }

    @Override
    public Dimension preferredSize() {
        int w = DeepEdit.frame.getSize().width;
        if (this.ImageButtonsDisabled) {
            return new Dimension(w, 4);
        }
        return new Dimension(w, 36);
    }

    public ImageButton getButton(String Name) {
        for (int ix = 0; ix < this.buttons.size(); ++ix) {
            ImageButton TempButton = (ImageButton)this.buttons.elementAt(ix);
            if (!TempButton.getName().equals(Name)) continue;
            return TempButton;
        }
        return null;
    }

    public void EnableButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Enable();
        }
        this.repaint();
    }

    public void DisableButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Disable();
        }
        this.repaint();
    }

    public void SelectButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Select();
        }
        this.repaint();
    }

    public void UnselectButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Unselect();
        }
        this.repaint();
    }

    public void EnableAllButtons() {
        this.EnableButton("New");
        if (this.papplet.EnableFileOperations) {
            this.EnableButton("Open");
            this.EnableButton("Save");
        }
        this.EnableButton("Cut");
        this.EnableButton("Copy");
        this.EnableButton("Paste");
        this.EnableButton("Pointer");
        this.EnableButton("Simulate");
        this.EnableButton("Junction");
        this.EnableButton("Text");
        this.EnableButton("Arc");
        this.EnableButton("Node");
        this.EnableButton("Centroid");
        this.EnableButton("FInjection");
        this.EnableButton("Customer");
        this.EnableButton("Link");
        this.EnableButton("Storage");
        this.EnableButton("Help");
        this.SelectButton("Pointer");
    }

    public void DrawButtons(Graphics g) {
        this.ButtonOffset = (this.getSize().width - this.CopyImage.getWidth(this)) / 2;
        for (int ix = 0; ix < this.buttons.size(); ++ix) {
            ImageButton TempButton = (ImageButton)this.buttons.elementAt(ix);
            TempButton.Draw(this.cig);
        }
        Graphics ibg = this.ImageBuffer.getGraphics();
        ibg.drawImage(this.CopyImage, 0, 0, this);
        g.drawImage(this.ImageBuffer, this.ButtonOffset, 4, this);
    }

    @Override
    public boolean mouseDown(Event event, int x, int y) {
        x -= this.ButtonOffset;
        y -= 4;
        for (int ix = 0; ix < this.buttons.size(); ++ix) {
            ImageButton TempButton = (ImageButton)this.buttons.elementAt(ix);
            if (!TempButton.CheckIfPressed(x, y)) continue;
            this.PressedButton = TempButton;
            this.repaint();
            return true;
        }
        return true;
    }

    @Override
    public boolean mouseUp(Event event, int x, int y) {
        if (this.PressedButton != null) {
            this.PressedButton.Select();
            this.repaint();
            this.ButtonPressed(this.PressedButton.getName());
            this.PressedButton = null;
        }
        return true;
    }

    @Override
    public synchronized void update(Graphics g) {
        g.setColor(Color.gray);
        g.drawLine(0, 0, this.getSize().width, 0);
        if (!this.ImageButtonsDisabled) {
            g.drawLine(0, 30, this.getSize().width, 30);
        }
        g.setColor(Color.lightGray);
        g.drawLine(0, 1, this.getSize().width, 1);
        if (!this.ImageButtonsDisabled) {
            g.drawLine(0, 31, this.getSize().width, 31);
        }
        if (this.CopyImage != null && !this.ImageButtonsDisabled) {
            this.DrawButtons(g);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        this.update(g);
    }

    public void LoadButtonsImage() {
        Image ButtonsImage = this.applet.getImage(this.applet.getDocumentBase(), "images/allbuttonsp.gif");
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(ButtonsImage, 0);
        try {
            Thread.currentThread().setPriority(1);
            tracker.waitForAll();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading imagebuttons", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        if (tracker.isErrorAny()) {
            this.ImageButtonsDisabled = true;
            String message = "Can't read images/allbuttonsp.gif ImageButtons will be disabled";
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ErrorDialog = new SimpleDialog(DeepEdit.frame, "Error while reading imagebuttons", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        this.ImageBuffer = DeepEdit.frame.createImage(ButtonsImage.getWidth(this), 24);
        this.CopyImage = DeepEdit.frame.createImage(ButtonsImage.getWidth(this), ButtonsImage.getHeight(this));
        this.cig = this.CopyImage.getGraphics();
        this.cig.drawImage(ButtonsImage, 0, 0, this);
    }

    public void ButtonPressed(String PressedButton) {
        if (this.ImageButtonsDisabled) {
            return;
        }
        if (PressedButton.equals("New")) {
            this.papplet.UserWantsNewSchematic();
        } else if (PressedButton.equals("Open")) {
            this.papplet.UserWantsOpenSchematic();
        } else if (PressedButton.equals("Save")) {
            this.papplet.UserWantsSaveSchematic();
        } else if (PressedButton.equals("Cut")) {
            this.papplet.UserWantsCutSchematic();
        } else if (PressedButton.equals("Copy")) {
            this.papplet.UserWantsCopySchematic();
        } else if (PressedButton.equals("Paste")) {
            this.papplet.UserWantsPasteSchematic();
        } else if (PressedButton.equals("Pointer")) {
            this.papplet.UserWantsPointer();
        } else if (PressedButton.equals("Simulate")) {
            this.papplet.UserWantsSimulate();
        } else if (PressedButton.equals("Junction")) {
            this.papplet.UserWantsJunctionDrawing();
        } else if (PressedButton.equals("Text")) {
            this.papplet.UserWantsTextDrawing();
        } else if (PressedButton.equals("Node")) {
            this.papplet.UserWantstdb_nodeDrawing();
        } else if (PressedButton.equals("Centroid")) {
            this.papplet.UserWantstdb_centroidDrawing();
        } else if (PressedButton.equals("Arc")) {
            this.papplet.UserWantsArcDrawing();
        } else if (PressedButton.equals("FInjection")) {
            this.papplet.UserWantsfdb_injectionDrawing();
        } else if (PressedButton.equals("Customer")) {
            this.papplet.UserWantsfdb_custDrawing();
        } else if (PressedButton.equals("Link")) {
            this.papplet.UserWantsLinkDrawing();
        } else if (PressedButton.equals("Storage")) {
            this.papplet.UserWantsfdb_storageDrawing();
        } else if (PressedButton.equals("Help")) {
            this.papplet.UserWantsHelp();
        }
    }
}

