/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.PietEditFrame;
import de.core.SimpleDialog;
import de.core.fdb_Probe;
import de.core.tdb_Probe;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Vector;

class PietAnalyzerPanel
extends Panel {
    static final int CHANNEL_HEIGHT = 50;
    static final int DISPLAY_OFFSET = 5;
    static final int CLOCK_WIDTH = 10;
    static final int LINE_OFFSET = 5;
    static final int BUTTON_X_OFFSET = 5;
    static final int BUTTON_Y_OFFSET = 22;
    static final int BUTTON_CLOCK_NONE = 48;
    static final int BUTTON_CLOCK_NONE_PRESSED = 24;
    static final int BUTTON_CLOCK_UP_PRESSED = 72;
    static final int BUTTON_CLOCK_UP_SELECTED = 96;
    static final int BUTTON_CLOCK_DN_PRESSED = 120;
    static final int BUTTON_CLOCK_DN_SELECTED = 144;
    static final Color TextColor = Color.black;
    static final Color BackGroundColor = Color.black;
    protected Scrollbar myVertical;
    PietEditFrame applet;
    Image OffScreenImage = null;
    Image ImageBuffer = null;
    Image CopyImage = null;
    Graphics cig;
    int ButtonOffset = 0;
    Graphics og;
    Dimension ImageSize;
    protected Font AnalyzerFont;
    protected FontMetrics AnalyzerFontMetrics;
    Vector probes = null;
    boolean ImageButtonsDisabled = false;
    tdb_Probe Pressedtdb_Probe = null;
    tdb_Probe Dragtdb_Probe = null;
    fdb_Probe Pressedfdb_Probe = null;
    fdb_Probe Dragfdb_Probe = null;
    int CurrentCol = 0;
    boolean ImageUpdated = false;
    Frame frame;

    public PietAnalyzerPanel(PietEditFrame app, Frame f) {
        this.applet = app;
        this.frame = f;
        this.setLayout(new BorderLayout());
        this.AnalyzerFont = new Font("TimesRoman", 0, 14);
        this.AnalyzerFontMetrics = this.getFontMetrics(this.AnalyzerFont);
        super.setLayout(new BorderLayout());
        this.LoadButtonsImage();
        this.myVertical = new Scrollbar(1);
        this.add("East", this.myVertical);
        this.ImageSize = new Dimension(400, 250);
        this.CheckOffScreenImage();
        this.repaint();
    }

    public void AdjustScrollbar() {
        String OSName;
        int vis_height;
        if (this.probes == null) {
            return;
        }
        int ttl_height = 50 * this.probes.size();
        int max_offs = ttl_height - (vis_height = this.getSize().height);
        if (max_offs < 0) {
            max_offs = 0;
        }
        if ((OSName = System.getProperty("os.name")).equals("Windows 95") || OSName.equals("Windows NT")) {
            this.myVertical.setValues(this.myVertical.getValue(), vis_height, 0, max_offs + vis_height);
        } else {
            this.myVertical.setValues(this.myVertical.getValue(), vis_height, 0, max_offs);
        }
    }

    public void CheckOffScreenImage() {
        if (this.OffScreenImage == null) {
            this.PrepareOffScreenImage();
            return;
        }
        if (this.getSize().width > this.ImageSize.width || this.getSize().height > this.ImageSize.height) {
            this.ImageSize.width = this.getSize().width;
            this.ImageSize.height = this.getSize().height;
            this.PrepareOffScreenImage();
        }
    }

    public void PrepareOffScreenImage() {
        this.OffScreenImage = this.applet.createImage(this.ImageSize.width, this.ImageSize.height);
        this.og = this.OffScreenImage.getGraphics();
        this.og.setFont(this.AnalyzerFont);
        this.repaint();
    }

    public void SelectButton(int ButtonType) {
        this.cig.copyArea(0, ButtonType, 24, 24, 0, -ButtonType);
    }

    public void ButtonPressed(int b) {
        if (this.applet.getEditor() == 1) {
            tdb_Probe Acttdb_Probe;
            this.Pressedtdb_Probe = Acttdb_Probe = (tdb_Probe)this.probes.elementAt(b);
            if (Acttdb_Probe.clockup_probe) {
                Acttdb_Probe.clockup_probe = false;
                Acttdb_Probe.clockdn_probe = true;
            } else if (Acttdb_Probe.clockdn_probe) {
                Acttdb_Probe.clockup_probe = false;
                Acttdb_Probe.clockdn_probe = false;
            } else {
                Acttdb_Probe.clockup_probe = true;
                Acttdb_Probe.clockdn_probe = false;
            }
            for (int ix = 0; ix < this.probes.size(); ++ix) {
                if (b == ix) continue;
                Acttdb_Probe = (tdb_Probe)this.probes.elementAt(ix);
                Acttdb_Probe.clockup_probe = false;
                Acttdb_Probe.clockdn_probe = false;
            }
        } else {
            fdb_Probe Actfdb_Probe;
            this.Pressedfdb_Probe = Actfdb_Probe = (fdb_Probe)this.probes.elementAt(b);
            if (Actfdb_Probe.clockup_probe) {
                Actfdb_Probe.clockup_probe = false;
                Actfdb_Probe.clockdn_probe = true;
            } else if (Actfdb_Probe.clockdn_probe) {
                Actfdb_Probe.clockup_probe = false;
                Actfdb_Probe.clockdn_probe = false;
            } else {
                Actfdb_Probe.clockup_probe = true;
                Actfdb_Probe.clockdn_probe = false;
            }
            for (int ix = 0; ix < this.probes.size(); ++ix) {
                if (b == ix) continue;
                Actfdb_Probe = (fdb_Probe)this.probes.elementAt(ix);
                Actfdb_Probe.clockup_probe = false;
                Actfdb_Probe.clockdn_probe = false;
            }
        }
        this.repaint();
    }

    @Override
    public boolean mouseDown(Event event, int x, int y) {
        int ix;
        this.Pressedtdb_Probe = null;
        this.Dragtdb_Probe = null;
        this.Pressedfdb_Probe = null;
        this.Dragfdb_Probe = null;
        if (this.applet.getEditor() == 1) {
            int ix2;
            for (ix2 = 0; ix2 < this.probes.size(); ++ix2) {
                int yo = ix2 * 50 + 22 - this.myVertical.getValue();
                if (x < 5 || x > 29 || y < yo || y > yo + 24) continue;
                this.ButtonPressed(ix2);
            }
            for (ix2 = 0; ix2 < this.probes.size(); ++ix2) {
                tdb_Probe Acttdb_Probe = (tdb_Probe)this.probes.elementAt(ix2);
                if (x < Acttdb_Probe.ChannelPos.x || y < Acttdb_Probe.ChannelPos.y || x > Acttdb_Probe.ChannelPos.x + Acttdb_Probe.ChannelDim.width || y > Acttdb_Probe.ChannelPos.y + Acttdb_Probe.ChannelDim.height) continue;
                this.Dragtdb_Probe = Acttdb_Probe;
                this.repaint();
                return true;
            }
            return true;
        }
        for (ix = 0; ix < this.probes.size(); ++ix) {
            int yo = ix * 50 + 22 - this.myVertical.getValue();
            if (x < 5 || x > 29 || y < yo || y > yo + 24) continue;
            this.ButtonPressed(ix);
        }
        for (ix = 0; ix < this.probes.size(); ++ix) {
            fdb_Probe Actfdb_Probe = (fdb_Probe)this.probes.elementAt(ix);
            if (x < Actfdb_Probe.ChannelPos.x || y < Actfdb_Probe.ChannelPos.y || x > Actfdb_Probe.ChannelPos.x + Actfdb_Probe.ChannelDim.width || y > Actfdb_Probe.ChannelPos.y + Actfdb_Probe.ChannelDim.height) continue;
            this.Dragfdb_Probe = Actfdb_Probe;
            this.repaint();
            return true;
        }
        return true;
    }

    @Override
    public boolean mouseUp(Event event, int x, int y) {
        if (this.applet.getEditor() == 1) {
            if (this.Dragtdb_Probe != null) {
                this.Dragtdb_Probe = null;
                this.repaint();
            }
            if (this.Pressedtdb_Probe != null) {
                this.Pressedtdb_Probe = null;
                this.repaint();
            }
            return true;
        }
        if (this.Dragfdb_Probe != null) {
            this.Dragfdb_Probe = null;
            this.repaint();
        }
        if (this.Pressedfdb_Probe != null) {
            this.Pressedfdb_Probe = null;
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseDrag(Event evt, int x, int y) {
        if (this.applet.getEditor() == 1) {
            if (this.Dragtdb_Probe != null) {
                for (int ix = 0; ix < this.probes.size(); ++ix) {
                    tdb_Probe Acttdb_Probe = (tdb_Probe)this.probes.elementAt(ix);
                    if (x < Acttdb_Probe.ChannelPos.x || y < Acttdb_Probe.ChannelPos.y || x > Acttdb_Probe.ChannelPos.x + Acttdb_Probe.ChannelDim.width || y > Acttdb_Probe.ChannelPos.y + Acttdb_Probe.ChannelDim.height || Acttdb_Probe == this.Dragtdb_Probe) continue;
                    this.applet.MyPietSchematic.SwapComponents(Acttdb_Probe, this.Dragtdb_Probe);
                    this.repaint();
                    return true;
                }
            }
            return true;
        }
        if (this.Dragfdb_Probe != null) {
            for (int ix = 0; ix < this.probes.size(); ++ix) {
                fdb_Probe Actfdb_Probe = (fdb_Probe)this.probes.elementAt(ix);
                if (x < Actfdb_Probe.ChannelPos.x || y < Actfdb_Probe.ChannelPos.y || x > Actfdb_Probe.ChannelPos.x + Actfdb_Probe.ChannelDim.width || y > Actfdb_Probe.ChannelPos.y + Actfdb_Probe.ChannelDim.height || Actfdb_Probe == this.Dragfdb_Probe) continue;
                this.applet.MyPietSchematic.SwapComponents(Actfdb_Probe, this.Dragfdb_Probe);
                this.repaint();
                return true;
            }
        }
        return true;
    }

    public void Drawtdb_ProbeHistory(Graphics g, tdb_Probe ActProbe) {
        g.setColor(Color.green);
        int ix = 0;
        while (true) {
            if (ix >= 100) break;
            if (ix > 0 && ActProbe.LevelHistory[ix - 1] != ActProbe.LevelHistory[ix]) {
                this.og.drawLine(ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
            }
            if (ActProbe.LevelHistory[ix] == 5) {
                g.setColor(Color.green);
                g.drawLine(ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + (ix + 1) * 10, ActProbe.ChannelPos.y + 5);
            } else {
                g.setColor(Color.green);
                g.drawLine(ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5, ActProbe.ChannelPos.x + (ix + 1) * 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
            }
            ++ix;
        }
    }

    public void Drawfdb_ProbeHistory(Graphics g, fdb_Probe ActProbe) {
        g.setColor(Color.green);
        int ix = 0;
        while (true) {
            if (ix >= 100) break;
            if (ix > 0 && ActProbe.LevelHistory[ix - 1] != ActProbe.LevelHistory[ix]) {
                this.og.drawLine(ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
            }
            if (ActProbe.LevelHistory[ix] == 5) {
                g.setColor(Color.green);
                g.drawLine(ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + (ix + 1) * 10, ActProbe.ChannelPos.y + 5);
            } else {
                g.setColor(Color.green);
                g.drawLine(ActProbe.ChannelPos.x + ix * 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5, ActProbe.ChannelPos.x + (ix + 1) * 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
            }
            ++ix;
        }
    }

    public void DrawNoProbes(Graphics g) {
        String message = "There are no probes to display.";
        int StringWidth = this.AnalyzerFontMetrics.stringWidth(message);
        int x = (this.getSize().width - StringWidth) / 2;
        g.setColor(Color.black);
        g.drawString(message, x, this.getSize().height / 2);
    }

    public void DrawEmptyProbesT(Graphics g) {
        tdb_Probe ActProbe;
        int ix;
        this.probes = this.applet.MyPietSchematic.getProbes();
        int MaxTextWidth = 30;
        int SliderVal = this.myVertical.getValue();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.ImageSize.width, this.ImageSize.height);
        if (this.probes.size() == 0) {
            this.DrawNoProbes(g);
            return;
        }
        for (ix = 0; ix < this.probes.size(); ++ix) {
            ActProbe = (tdb_Probe)this.probes.elementAt(ix);
            int w = this.AnalyzerFontMetrics.stringWidth(ActProbe.IPin[0].getName());
            if (w <= MaxTextWidth) continue;
            MaxTextWidth = w;
        }
        for (ix = 0; ix < this.probes.size(); ++ix) {
            ActProbe = (tdb_Probe)this.probes.elementAt(ix);
            int yo = ix * 50 - SliderVal;
            g.setColor(TextColor);
            g.drawString(ActProbe.IPin[0].getName(), 5, yo + 16);
            g.setColor(Color.gray);
            g.drawLine(0, yo + 50 - 2, this.getSize().width, yo + 50 - 2);
            g.setColor(Color.lightGray);
            g.drawLine(0, yo + 50 - 1, this.getSize().width, yo + 50 - 1);
            ActProbe.ChannelPos.x = 5 + MaxTextWidth + 5;
            ActProbe.ChannelPos.y = 5 + yo;
            ActProbe.ChannelDim.width = this.getSize().width - (5 + MaxTextWidth + 20);
            ActProbe.ChannelDim.height = 40;
            g.setColor(BackGroundColor);
            g.fillRect(ActProbe.ChannelPos.x, ActProbe.ChannelPos.y + 1, ActProbe.ChannelDim.width, ActProbe.ChannelDim.height - 1);
            if (ActProbe.clockup_probe) {
                if (ActProbe == this.Pressedtdb_Probe) {
                    this.SelectButton(72);
                } else {
                    this.SelectButton(96);
                }
            } else if (ActProbe.clockdn_probe) {
                if (ActProbe == this.Pressedtdb_Probe) {
                    this.SelectButton(120);
                } else {
                    this.SelectButton(144);
                }
            } else if (ActProbe == this.Pressedtdb_Probe) {
                this.SelectButton(24);
            } else {
                this.SelectButton(48);
            }
            this.Drawtdb_ProbeHistory(g, ActProbe);
            Graphics ibg = this.ImageBuffer.getGraphics();
            ibg.drawImage(this.CopyImage, 0, 0, this);
            g.drawImage(this.ImageBuffer, 5, 22 + yo, this);
        }
        if (this.Dragtdb_Probe != null) {
            g.setColor(Color.red);
            g.drawRect(this.Dragtdb_Probe.ChannelPos.x, this.Dragtdb_Probe.ChannelPos.y, this.Dragtdb_Probe.ChannelDim.width, this.Dragtdb_Probe.ChannelDim.height);
        }
    }

    public void DrawEmptyProbesF(Graphics g) {
        fdb_Probe ActProbe;
        int ix;
        this.probes = this.applet.MyPietSchematic.getProbes();
        int MaxTextWidth = 30;
        int SliderVal = this.myVertical.getValue();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.ImageSize.width, this.ImageSize.height);
        if (this.probes.size() == 0) {
            this.DrawNoProbes(g);
            return;
        }
        for (ix = 0; ix < this.probes.size(); ++ix) {
            ActProbe = (fdb_Probe)this.probes.elementAt(ix);
            int w = this.AnalyzerFontMetrics.stringWidth(ActProbe.IPin[0].getName());
            if (w <= MaxTextWidth) continue;
            MaxTextWidth = w;
        }
        for (ix = 0; ix < this.probes.size(); ++ix) {
            ActProbe = (fdb_Probe)this.probes.elementAt(ix);
            int yo = ix * 50 - SliderVal;
            g.setColor(TextColor);
            g.drawString(ActProbe.IPin[0].getName(), 5, yo + 16);
            g.setColor(Color.gray);
            g.drawLine(0, yo + 50 - 2, this.getSize().width, yo + 50 - 2);
            g.setColor(Color.lightGray);
            g.drawLine(0, yo + 50 - 1, this.getSize().width, yo + 50 - 1);
            ActProbe.ChannelPos.x = 5 + MaxTextWidth + 5;
            ActProbe.ChannelPos.y = 5 + yo;
            ActProbe.ChannelDim.width = this.getSize().width - (5 + MaxTextWidth + 20);
            ActProbe.ChannelDim.height = 40;
            g.setColor(BackGroundColor);
            g.fillRect(ActProbe.ChannelPos.x, ActProbe.ChannelPos.y + 1, ActProbe.ChannelDim.width, ActProbe.ChannelDim.height - 1);
            if (ActProbe.clockup_probe) {
                if (ActProbe == this.Pressedfdb_Probe) {
                    this.SelectButton(72);
                } else {
                    this.SelectButton(96);
                }
            } else if (ActProbe.clockdn_probe) {
                if (ActProbe == this.Pressedfdb_Probe) {
                    this.SelectButton(120);
                } else {
                    this.SelectButton(144);
                }
            } else if (ActProbe == this.Pressedfdb_Probe) {
                this.SelectButton(24);
            } else {
                this.SelectButton(48);
            }
            this.Drawfdb_ProbeHistory(g, ActProbe);
            Graphics ibg = this.ImageBuffer.getGraphics();
            ibg.drawImage(this.CopyImage, 0, 0, this);
            g.drawImage(this.ImageBuffer, 5, 22 + yo, this);
        }
        if (this.Dragfdb_Probe != null) {
            g.setColor(Color.red);
            g.drawRect(this.Dragfdb_Probe.ChannelPos.x, this.Dragfdb_Probe.ChannelPos.y, this.Dragfdb_Probe.ChannelDim.width, this.Dragfdb_Probe.ChannelDim.height);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.OffScreenImage == null) {
            return;
        }
        this.AdjustScrollbar();
        if (this.probes != null && this.getSize().height >= 50 * this.probes.size()) {
            this.update(g);
            return;
        }
        if (!this.ImageUpdated) {
            this.update(g);
            return;
        }
        g.drawImage(this.OffScreenImage, 0, 0, this);
    }

    @Override
    public synchronized void update(Graphics g) {
        this.AdjustScrollbar();
        this.CheckOffScreenImage();
        if (this.OffScreenImage == null) {
            return;
        }
        if (this.applet.getEditor() == 1) {
            this.DrawEmptyProbesT(this.og);
        } else {
            this.DrawEmptyProbesF(this.og);
        }
        g.drawImage(this.OffScreenImage, 0, 0, this);
        this.ImageUpdated = true;
    }

    @Override
    public boolean handleEvent(Event ev) {
        if (ev.target instanceof Scrollbar) {
            this.repaint();
            return true;
        }
        return super.handleEvent(ev);
    }

    @Override
    public boolean action(Event ev, Object arg) {
        if (ev.target instanceof Button) {
            // empty if block
        }
        return false;
    }

    public void update(tdb_Probe ActProbe) {
        int x = this.CurrentCol * 10;
        if (x >= ActProbe.ChannelDim.width) {
            if (ActProbe.clockup_probe && ActProbe.OldLevel == 0 && ActProbe.IPin[0].getLevel() == 5) {
                this.CurrentCol = 0;
            } else if (ActProbe.clockdn_probe && ActProbe.OldLevel == 5 && ActProbe.IPin[0].getLevel() == 0) {
                this.CurrentCol = 0;
            }
        }
    }

    public void update(fdb_Probe ActProbe) {
        int x = this.CurrentCol * 10;
        if (x >= ActProbe.ChannelDim.width) {
            if (ActProbe.clockup_probe && ActProbe.OldLevel == 0 && ActProbe.IPin[0].getLevel() == 5) {
                this.CurrentCol = 0;
            } else if (ActProbe.clockdn_probe && ActProbe.OldLevel == 5 && ActProbe.IPin[0].getLevel() == 0) {
                this.CurrentCol = 0;
            }
        }
    }

    public void drawLevel(tdb_Probe ActProbe) {
        int x = this.CurrentCol * 10;
        if (x >= ActProbe.ChannelDim.width) {
            return;
        }
        if (this.CurrentCol == 0) {
            this.og.setColor(BackGroundColor);
            this.og.fillRect(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + 1, 11, ActProbe.ChannelDim.height - 1);
        }
        this.og.setColor(BackGroundColor);
        this.og.fillRect(ActProbe.ChannelPos.x + x + 1, ActProbe.ChannelPos.y + 1, 10, ActProbe.ChannelDim.height - 1);
        if (this.CurrentCol > 0 && ActProbe.IPin[0].getLevel() != ActProbe.OldLevel) {
            this.og.setColor(Color.green);
            this.og.drawLine(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
        }
        if (this.CurrentCol < 100) {
            ActProbe.LevelHistory[this.CurrentCol] = ActProbe.IPin[0].getLevel();
        }
        if (ActProbe.IPin[0].getLevel() == 5) {
            this.og.setColor(Color.green);
            this.og.drawLine(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + x + 10, ActProbe.ChannelPos.y + 5);
        } else {
            this.og.setColor(Color.green);
            this.og.drawLine(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5, ActProbe.ChannelPos.x + x + 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
        }
        this.paint(this.getGraphics());
    }

    public void drawLevel(fdb_Probe ActProbe) {
        int x = this.CurrentCol * 10;
        if (x >= ActProbe.ChannelDim.width) {
            return;
        }
        if (this.CurrentCol == 0) {
            this.og.setColor(BackGroundColor);
            this.og.fillRect(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + 1, 11, ActProbe.ChannelDim.height - 1);
        }
        this.og.setColor(BackGroundColor);
        this.og.fillRect(ActProbe.ChannelPos.x + x + 1, ActProbe.ChannelPos.y + 1, 10, ActProbe.ChannelDim.height - 1);
        if (this.CurrentCol > 0 && ActProbe.IPin[0].getLevel() != ActProbe.OldLevel) {
            this.og.setColor(Color.green);
            this.og.drawLine(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
        }
        if (this.CurrentCol < 100) {
            ActProbe.LevelHistory[this.CurrentCol] = ActProbe.IPin[0].getLevel();
        }
        if (ActProbe.IPin[0].getLevel() == 5) {
            this.og.setColor(Color.green);
            this.og.drawLine(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + 5, ActProbe.ChannelPos.x + x + 10, ActProbe.ChannelPos.y + 5);
        } else {
            this.og.setColor(Color.green);
            this.og.drawLine(ActProbe.ChannelPos.x + x, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5, ActProbe.ChannelPos.x + x + 10, ActProbe.ChannelPos.y + ActProbe.ChannelDim.height - 5);
        }
        this.paint(this.getGraphics());
    }

    public void update() {
        if (this.applet.getEditor() == 1) {
            tdb_Probe Acttdb_Probe;
            int ix;
            if (this.probes == null) {
                return;
            }
            for (ix = 0; ix < this.probes.size(); ++ix) {
                Acttdb_Probe = (tdb_Probe)this.probes.elementAt(ix);
                this.update(Acttdb_Probe);
            }
            for (ix = 0; ix < this.probes.size(); ++ix) {
                Acttdb_Probe = (tdb_Probe)this.probes.elementAt(ix);
                this.drawLevel(Acttdb_Probe);
                Acttdb_Probe.OldLevel = Acttdb_Probe.IPin[0].getLevel();
            }
            this.paint(this.getGraphics());
            ++this.CurrentCol;
        } else {
            fdb_Probe Actfdb_Probe;
            int ix;
            if (this.probes == null) {
                return;
            }
            for (ix = 0; ix < this.probes.size(); ++ix) {
                Actfdb_Probe = (fdb_Probe)this.probes.elementAt(ix);
                this.update(Actfdb_Probe);
            }
            for (ix = 0; ix < this.probes.size(); ++ix) {
                Actfdb_Probe = (fdb_Probe)this.probes.elementAt(ix);
                this.drawLevel(Actfdb_Probe);
                Actfdb_Probe.OldLevel = Actfdb_Probe.IPin[0].getLevel();
            }
            this.paint(this.getGraphics());
            ++this.CurrentCol;
        }
    }

    public void LoadButtonsImage() {
        MediaTracker tracker = new MediaTracker(this);
        Image ButtonsImage = this.applet.applet.getImage(this.applet.applet.getDocumentBase(), "images/all_analyzer.gif");
        tracker.addImage(ButtonsImage, 0);
        try {
            Thread.currentThread().setPriority(1);
            tracker.waitForAll();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(this.applet.dframe, "Reading imagebuttons", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        if (tracker.isErrorAny()) {
            this.ImageButtonsDisabled = true;
            String message = "Can't read images/all_analyzer.gif ImageButtons will be disabled";
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ErrorDialog = new SimpleDialog(this.applet.dframe, "Error while reading imagebuttons", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        this.ImageBuffer = this.applet.createImage(ButtonsImage.getWidth(this), 24);
        this.CopyImage = this.applet.createImage(ButtonsImage.getWidth(this), ButtonsImage.getHeight(this));
        this.cig = this.CopyImage.getGraphics();
        this.cig.drawImage(ButtonsImage, 0, 0, this);
    }
}

