/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.NonFlickerPanel;
import com.objectplanet.chart.PieChart;
import de.core.MMTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class PieChartFrame
extends JFrame
implements ActionListener {
    public String comentario;
    public double[][] valor;
    public double[] dvalor;
    public String[] leyenda;
    public String titulo;
    public PieChart chart;
    public String postfix = " ";

    public PieChartFrame(String ttitulo, double[][] vvalor, String[] lleyenda, String ccomentario) {
        super(ttitulo);
        this.valor = vvalor;
        this.leyenda = lleyenda;
        this.comentario = ccomentario;
        this.titulo = ttitulo;
        this.dvalor = new double[this.valor[0].length];
        this.chart = new PieChart();
        this.actualizar(vvalor, ccomentario);
        NonFlickerPanel p = new NonFlickerPanel(new BorderLayout());
        p.add("Center", this.chart);
        Panel f = new Panel();
        f.setLayout(new BorderLayout());
        f.add((Component)p, "Center");
        f.add((Component)new Label(this.comentario), "South");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.add(f);
        this.setDefaultCloseOperation(2);
        this.setLocation(200, 50);
        this.setSize(350, 250);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.dispose();
    }

    public void actualizar(double[][] vvalor, String ccomentario) {
        int i;
        this.valor = vvalor;
        this.comentario = ccomentario;
        for (i = 0; i < this.dvalor.length; ++i) {
            this.dvalor[i] = 0.0;
        }
        if (this.postfix.equals("MWh")) {
            for (i = 0; i < this.valor.length; ++i) {
                for (int j = 0; j < this.valor[0].length; ++j) {
                    int n = j;
                    this.dvalor[n] = this.dvalor[n] + Double.valueOf(this.valor[i][j]);
                }
            }
        } else {
            for (int j = 0; j < this.valor[0].length; ++j) {
                int n = j;
                this.dvalor[n] = this.dvalor[n] + Double.valueOf(this.valor[this.valor.length - 1][j]);
            }
        }
        for (i = 0; i < this.valor[0].length; ++i) {
            this.leyenda[i] = this.leyenda[i] + "\n";
        }
        int[][] pig = new int[this.valor[0].length][3];
        boolean aux_alfa = false;
        pig = MMTool.colores(this.valor[0].length);
        Color[] sampleColors = new Color[this.valor[0].length];
        for (int j = 0; j < this.valor[0].length; ++j) {
            sampleColors[j] = new Color(pig[j][0], pig[j][1], pig[j][2]);
        }
        this.chart.setTitleOn(true);
        this.chart.setTitle(this.titulo);
        this.chart.setFont("titleFont", new Font("Verdana", 0, 20));
        this.chart.setSampleCount(this.dvalor.length);
        this.chart.setSampleColors(sampleColors);
        this.chart.setSampleValues(0, this.dvalor);
        this.chart.setSampleLabels(this.leyenda);
        this.chart.setSampleLabelsOn(true);
        this.chart.setSampleLabelStyle(1);
        this.chart.setValueLabelsOn(true);
        this.chart.setValueLabelStyle(1);
        this.chart.setLabel("valueLabelPostfix", " " + this.postfix + "\n");
        this.chart.setPercentLabelsOn(true);
        this.chart.setPercentLabelStyle(1);
        this.chart.setSliceSeperatorOn(false);
        this.chart.setFont("insideLabelFont", new Font("Verdana", 1, 12));
        this.chart.setSelectionStyle(2);
        this.chart.setSliceSeperatorColor(Color.black);
        this.chart.setDepth(0.3);
        this.chart.setFont(new Font("Verdana", 0, 12));
        this.chart.set3DModeOn(true);
        this.chart.setBackground(Color.white);
    }

    public Chart getChart() {
        return this.chart;
    }
}

