/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Ga;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;

class ParamPanel
extends Panel {
    String title;
    TextField textField;
    Scrollbar slider;
    int min = 0;
    int max = 1000;
    double scale = 1000.0;
    Ga ga;

    ParamPanel(Ga genA, String myTitle, int minV, int maxV, int scaleV, double initValue) {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.ga = genA;
        this.title = myTitle;
        this.max = maxV;
        this.min = minV;
        this.scale = scaleV;
        c.fill = 2;
        Label label = new Label(this.title, 1);
        c.weightx = 0.0;
        c.gridwidth = 0;
        gridbag.setConstraints(label, c);
        this.add(label);
        this.textField = new TextField("0", 10);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridheight = -1;
        gridbag.setConstraints(this.textField, c);
        this.add(this.textField);
        this.textField.setEditable(true);
        this.slider = new Scrollbar(0, 0, 1, this.min, this.max);
        c.weightx = 0.0;
        c.gridheight = 1;
        c.gridwidth = 0;
        gridbag.setConstraints(this.slider, c);
        this.add(this.slider);
        this.setValue(initValue);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.size();
        g.drawRect(0, 0, d.width - 1, d.height - 1);
    }

    @Override
    public Insets insets() {
        return new Insets(5, 5, 5, 5);
    }

    double getValue() {
        double f;
        try {
            f = Double.valueOf(this.textField.getText());
        }
        catch (NumberFormatException e) {
            f = 0.0;
        }
        return f;
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.target instanceof Scrollbar) {
            this.textField.setText(String.valueOf((double)this.slider.getValue() / this.scale));
            this.ga.updateParam(this.title, Double.valueOf(this.textField.getText()));
            return true;
        }
        if (e.target instanceof TextField && (e.id == 1001 || e.id == 1005)) {
            this.setValue(this.getValue());
            this.ga.updateParam(this.title, Double.valueOf(this.textField.getText()));
            return true;
        }
        return false;
    }

    void setValue(double f) {
        this.setSliderValue(f * this.scale);
        if (f < (double)this.min / this.scale) {
            f = (double)this.min / this.scale;
        } else if (f > (double)this.max / this.scale) {
            f = (double)this.max / this.scale;
        }
        this.textField.setText(String.valueOf(f));
        this.ga.updateParam(this.title, Double.valueOf(this.textField.getText()));
    }

    void setSliderValue(double f) {
        int sliderValue = (int)f;
        if (sliderValue > this.max) {
            sliderValue = this.max;
        }
        if (sliderValue < this.min) {
            sliderValue = this.min;
        }
        this.slider.setValue(sliderValue);
    }
}

