/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Line;
import de.core.PLPException;
import de.core.PLPFrame;
import de.core.PLPUtils;
import de.core.Schematic;
import de.core.Trafo;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_unit;
import de.core.ndb_branch;
import de.utils.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public final class PLPtool
extends AnalysisTool {
    private static String ETAPAS = "PLPETA.DAT";
    private static String DEMANDA = "PLPDEM.DAT";
    private static String BARRAS = "PLPBAR.DAT";
    private static String CONFLIN = "PLPCNFLI.DAT";
    private static String CONFCEN = "PLPCNFCE.DAT";
    private static String COSTFUTEMB = "PLPPLAEM.DAT";
    private static String AFLCENT = "PLPAFLCE.DAT";
    private static String AFLCENTRes = "PLPAFLCERes.csv";
    private static String IDENSIM = "PLPIDSIM.DAT";
    private static String IDENSIMRes = "PLPIDSIMRes.csv";
    private static String IDENAPER = "PLPIDAPE.DAT";
    private static String MANTCENT = "PLPMANCE.DAT";
    private static String MANTEMB = "PLPMANEM.DAT";
    private static String MANTLIN = "PLPMANLI.DAT";
    private static String PATH = "PLPPATH.DAT";
    private static String FILTCENT = "PLPCENFI.DAT";
    private static String RENDCENT = "PLPCENRE.DAT";
    private static String CONVLAJA = "PLPLAJA.DAT";
    private static String CONVMAULE = "PLPMAULE.DAT";
    private static String MATPAR = "PLPMAT.DAT";
    private static String DEBUGPAR = "PLPDEB.DAT";
    private static String PARAM = "PLPPAR.DAT";
    public static int NOTEPAD = 1;
    public static int ZFILEVIWER = 0;
    public static String SIST = "T";
    public static String NOST = "F";
    String plpExeFile = "..\\run\\plpfiles\\plposl.exe";
    String plpWorkPath = "..\\run\\plpfiles";
    String plpTempPath = "..\\run\\plpfiles";
    Connection dbtrab;
    DeepEdit applet;
    PLPFrame myPLPFrame = null;
    PLPUtils mydbm;
    String query;
    Statement stmt;
    ResultSet rs;
    boolean more;
    FileOutputStream ActFOS;
    FileOutputStream ActFOS2;

    public PLPtool(Schematic sch, DeepEdit app) {
        super(sch);
        this.applet = app;
        this.ActSchematic = sch;
        this.plpWorkPath = sch.FileDir;
        System.out.println("Root Directory: " + this.plpWorkPath);
        try {
            this.myPLPFrame = DeepEdit.frame.MyPLPFrame;
            this.dbtrab = DeepEditFrame.conPLPDB;
            this.mydbm = new PLPUtils(this.ActSchematic, this.dbtrab, this.applet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void plpError(String mensaje) throws PLPException {
        throw new PLPException(mensaje);
    }

    public void loadExecFile() {
    }

    private PrintWriter openPWFile(String fname) throws Exception {
        this.ActFOS = new FileOutputStream(this.plpWorkPath + "\\" + fname);
        PrintWriter myWriter = new PrintWriter(this.ActFOS);
        if (this.ActSchematic.Modifiedstate) {
            this.mydbm = new PLPUtils(this.ActSchematic, this.dbtrab, this.applet);
        }
        return myWriter;
    }

    private PrintWriter openPWFile2(String fname) throws Exception {
        this.ActFOS2 = new FileOutputStream(new File("./PLPFiles/Resultados/" + fname));
        PrintWriter myWriter = new PrintWriter(this.ActFOS2);
        if (this.ActSchematic.Modifiedstate) {
            this.mydbm = new PLPUtils(this.ActSchematic, this.dbtrab, this.applet);
        }
        return myWriter;
    }

    private void closeActFOS() throws Exception {
        this.ActFOS.close();
    }

    private void closeActFOS2() throws Exception {
        this.ActFOS2.close();
    }

    public void update() {
        this.mydbm = new PLPUtils(this.ActSchematic, this.dbtrab, this.applet);
    }

    public void checkData() {
    }

    public void checkFiles() {
    }

    public void writeFilePATH() throws Exception {
        PrintWriter myPWriter = this.openPWFile(PATH);
        myPWriter.println("# Directorio de los datos");
        myPWriter.println("# PLPPATH.DAT en el ejecutable");
        myPWriter.println("# " + this.plpWorkPath);
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileETAPAS() throws Exception {
        int iniYear;
        PrintWriter myPWriter = new PrintWriter(this.openPWFile(ETAPAS));
        myPWriter.println("# Archivo con la duraci\u00f3n de las etapas");
        myPWriter.println("# Etapas");
        Vector stagedef = this.mydbm.getStageDef();
        int[] daysOnWeeks = this.mydbm.getWeeksDur();
        String[] blocksNames = this.mydbm.getBlocksNames();
        int[] indHydMonth = this.mydbm.getStageIndHydMonth();
        int[][] indHydYear = this.mydbm.getStageIndHydYear();
        int numBlocks = blocksNames.length;
        int[] actBlocksNH = new int[numBlocks];
        double[][] BlocksPDur = this.mydbm.getBlocksPDur();
        myPWriter.println("     " + stagedef.size() * numBlocks + "  'H'");
        myPWriter.println("# Ano  Mes  Etapa    NHoras    FactTasa    TipoEtapa");
        int cyear = 1;
        boolean cweek = true;
        double prevYDRate = 1.0;
        int actYear = iniYear = this.mydbm.getParam_Sim("A\u00f1o_Inicio");
        int actMonth = this.mydbm.getParam_Sim("Mes_Inicio");
        int actWeek = this.mydbm.getParam_Sim("Semana_Inicio");
        int iniWeek = actWeek += (actMonth - 1) * 4 - 1;
        double actRate = this.mydbm.getYearRate(actYear);
        for (int stage = 0; stage < stagedef.size(); ++stage) {
            int j;
            double stageDRate = actYear == iniYear ? (prevYDRate = Math.pow(1.0 + actRate / 100.0, (double)(actWeek - iniWeek) / 48.0)) : prevYDRate * Math.pow(1.0 + actRate / 100.0, (double)actWeek / 48.0);
            int dur = (Integer)stagedef.elementAt(stage);
            for (j = 0; j < numBlocks; ++j) {
                actBlocksNH[j] = 0;
            }
            int stageHours = 0;
            cyear = actYear - iniYear + 1;
            for (int i = 0; i < dur; ++i) {
                stageHours += daysOnWeeks[actWeek] * 24;
                for (j = 0; j < numBlocks; ++j) {
                    int n = j;
                    actBlocksNH[n] = (int)((long)actBlocksNH[n] + Math.round((double)daysOnWeeks[actWeek] * BlocksPDur[actWeek][j] * 0.24));
                }
                if (actWeek == 47) {
                    actWeek = 0;
                    prevYDRate = actYear == iniYear ? Math.pow(1.0 + actRate / 100.0, (48.0 - (double)iniWeek) / 48.0) : (prevYDRate *= 1.0 + actRate / 100.0);
                    actRate = this.mydbm.getYearRate(++actYear);
                    continue;
                }
                ++actWeek;
            }
            for (j = 0; j < numBlocks; ++j) {
                stageHours -= actBlocksNH[j];
            }
            int n = numBlocks - 1;
            actBlocksNH[n] = actBlocksNH[n] + stageHours;
            int aux = stage * numBlocks + 1;
            String st1 = StringUtil.numformat(indHydYear[stage][0] + 1, 5);
            String st2 = StringUtil.numformat(indHydMonth[stage], 5);
            String st3 = StringUtil.numformat(stageDRate, 12, 6);
            for (j = 0; j < numBlocks; ++j) {
                myPWriter.println(st1 + st2 + StringUtil.numformat(aux + j, 7) + StringUtil.numformat(actBlocksNH[j], 10) + st3 + "    '" + StringUtil.strformat(blocksNames[j], 12) + "'");
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileBARRAS() throws Exception {
        PrintWriter myPWriter = this.openPWFile(BARRAS);
        String[] busNames = this.mydbm.getBusNames();
        myPWriter.println("# Archivo con definicion de Barras (plpbar.dat)");
        myPWriter.println("# N\u00famero de Barras");
        myPWriter.println(StringUtil.numformat(busNames.length, 12));
        myPWriter.println("# N\u00famero       Nombre");
        for (int i = 0; i < busNames.length; ++i) {
            myPWriter.println(StringUtil.numformat(i + 1, 8) + "       '" + busNames[i] + "'");
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileDEMANDA() throws Exception {
        PrintWriter myPWriter = this.openPWFile(DEMANDA);
        myPWriter.println("# Archivo de demandas por barra (plpdem.dat)");
        String[] busNames = this.mydbm.getBusNames();
        myPWriter.println("# N\u00famero de Barras");
        myPWriter.println(StringUtil.numformat(busNames.length, 12));
        try {
            int iniY = this.mydbm.getParam_Sim("A\u00f1o_Inicio");
            int endY = this.mydbm.getParam_Sim("A\u00f1o_Fin");
            Vector auxVec = this.mydbm.getBloStagNumH();
            int[] bloStagYear = (int[])auxVec.elementAt(0);
            int[] bloStagMonth = (int[])auxVec.elementAt(1);
            int[] bloStagNumH = (int[])auxVec.elementAt(2);
            double[] StagBloqPEnergys = this.mydbm.getStagBlockPEn();
            double[] AnnEngy = this.mydbm.getAnnEngy(iniY, endY);
            for (int ibus = 0; ibus < busNames.length; ++ibus) {
                double[] busPLoad = this.mydbm.getBusPLoad(iniY, endY, ibus);
                myPWriter.println("# Nombre de la Barra");
                myPWriter.println("'" + busNames[ibus] + "'");
                myPWriter.println("# N\u00famero de Demandas");
                myPWriter.println(StringUtil.numformat(bloStagNumH.length, 8));
                myPWriter.println("# Mes  Etapa   Demanda");
                for (int stageb = 0; stageb < bloStagNumH.length; ++stageb) {
                    double engy = busPLoad[bloStagYear[stageb] - 1] * AnnEngy[bloStagYear[stageb] - 1] * StagBloqPEnergys[stageb] * 0.1;
                    if (bloStagNumH[stageb] <= 0) {
                        throw new PLPException("bloque de etapa con Duraci\u00f3n nula, PLPDB");
                    }
                    double power = engy / (double)bloStagNumH[stageb];
                    myPWriter.println(StringUtil.numformat(bloStagMonth[stageb], 5) + StringUtil.numformat(stageb + 1, 7) + StringUtil.numformat(power, 12, 4));
                }
            }
        }
        catch (Exception e) {
            myPWriter.flush();
            this.closeActFOS();
            throw e;
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileCONFLIN() throws Exception {
        PrintWriter myPWriter = this.openPWFile(CONFLIN);
        Line templine = null;
        Trafo temptrafo = null;
        String st2 = "";
        System.out.println("writing File: " + CONFLIN);
        Vector branchs = this.mydbm.getBranches();
        myPWriter.println("# Archivo de configuracion de lineas (plpcnfli.dat)");
        myPWriter.println("# Num.Lineas   Modela Perdidas  Perd.en.ERM   Ang. de Ref.");
        String st1 = this.mydbm.getParam_Sim("Modelo_Perdidas") > 0 ? SIST : NOST;
        switch (this.mydbm.getParam_Sim("Mod_Dist_Perdidas")) {
            case 0: {
                st2 = "'M'";
                break;
            }
            case 1: {
                st2 = "'E'";
                break;
            }
            case 2: {
                st2 = "'R'";
                break;
            }
            default: {
                PLPtool.plpError("valor desconocido en Mod_Dist_Perdidas, Param_Sim, PLPDB");
            }
        }
        int auxi = this.mydbm.getParam_Sim("Ang_Ref");
        String st3 = auxi + ".d0";
        String st = StringUtil.numformat(branchs.size(), 12) + StringUtil.strformat2(st1, 11) + StringUtil.strformat2(st2, 16) + StringUtil.strformat2(st3, 16);
        myPWriter.println(st);
        myPWriter.println("#\t\tCaracteristicas de las Lineas");
        myPWriter.println("#          Nombre   F.Max. A-B F.Max. B-A  Barra A  Barra B   Tension  R(Ohm)  X(ohm)   Mod.Perd.  Num.Tramos   Operativa");
        for (int ix = 0; ix < branchs.size(); ++ix) {
            double x;
            double r;
            ndb_branch tempbran = (ndb_branch)branchs.elementAt(ix);
            st = tempbran.getName();
            double[] plpCxInfo = this.mydbm.getCxParam(st);
            st = "'" + StringUtil.strformat(st, 15) + "'";
            st = st + StringUtil.numformat(plpCxInfo[0], 13, 1);
            st = st + StringUtil.numformat(plpCxInfo[1], 11, 1);
            auxi = this.mydbm.numbus(tempbran.getcon1());
            st = st + StringUtil.numformat(auxi + 1, 9);
            auxi = this.mydbm.numbus(tempbran.getcon2());
            st = st + StringUtil.numformat(auxi + 1, 9);
            st = st + StringUtil.numformat(tempbran.getun1(), 10, 1);
            if (tempbran instanceof Line) {
                templine = (Line)tempbran;
                r = templine.getr1() * templine.getlen();
                x = templine.getxx1() * templine.getlen();
            } else {
                temptrafo = (Trafo)tempbran;
                double ueb = temptrafo.getun1() / temptrafo.getun2() / (temptrafo.getur1() / temptrafo.getur2());
                double res = temptrafo.getpcu() * 0.001 * ueb * ueb / temptrafo.getsn() * this.getSref() / temptrafo.getsn();
                double z = temptrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / temptrafo.getsn();
                r = res * temptrafo.getun1() * temptrafo.getun1() / this.getSref() * temptrafo.gett_re() * temptrafo.gett_re();
                x = Math.sqrt(z * z - res * res) * temptrafo.getun1() * temptrafo.getun1() / this.getSref() * temptrafo.gett_re() * temptrafo.gett_re();
            }
            st = st + StringUtil.numformat(r, 8, 3);
            st = st + StringUtil.numformat(x, 8, 3);
            st1 = plpCxInfo[2] > 0.0 ? SIST : NOST;
            st = st + StringUtil.strformat2(st1, 7);
            auxi = (int)plpCxInfo[3];
            st = st + StringUtil.numformat(auxi, 12);
            st1 = tempbran.getinservice() ? SIST : NOST;
            st = st + StringUtil.strformat2(st1, 13);
            myPWriter.println(st);
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileCONFCEN() throws Exception {
        int NumGenTurb;
        int NumGenSpill;
        double rendi;
        double affmed;
        int numBarInj;
        double costvar;
        double pmax;
        double pmin;
        int ic;
        PrintWriter myPWriter = this.openPWFile(CONFCEN);
        int gencount = 0;
        System.out.println("writing File: " + CONFCEN);
        this.mydbm.loadHydroConnect();
        this.mydbm.loadFuncCotaVol();
        Vector busVec = this.mydbm.getBusVector();
        myPWriter.println("# Archivo de configuracion de las centrales (plpcnfce.dat)");
        myPWriter.println("# Num.Centrales  Num.Embalses Num.Serie Num.Fallas Num.Pas.Pur.");
        int numGenTot = this.mydbm.resHydGen.length + this.mydbm.serHydGen.length + this.mydbm.filHydGen.length + this.mydbm.irrigs.length + this.mydbm.ppHydGen.length + this.mydbm.thermalGen.length + busVec.size();
        String auxst = "" + StringUtil.numformat(numGenTot, 9);
        auxst = auxst + StringUtil.numformat(this.mydbm.resHydGen.length, 14) + StringUtil.numformat(this.mydbm.serHydGen.length + this.mydbm.filHydGen.length + this.mydbm.irrigs.length, 13);
        auxst = auxst + StringUtil.numformat(busVec.size(), 10) + StringUtil.numformat(this.mydbm.ppHydGen.length, 11);
        myPWriter.println(auxst);
        myPWriter.println("# Interm Min.Tec. Cos.Arr.Det. FFaseSinMT EtapaCambioFase");
        myPWriter.println("     F      F         F           F         00");
        myPWriter.println("# Caracteristicas Centrales");
        myPWriter.println("# Centrales de Embalse");
        for (ic = 0; ic < this.mydbm.resHydGen.length; ++ic) {
            double fesc;
            int expfesc;
            myPWriter.println("                   IPot MinTec  Inter   FCAD    Cen_MTTdHrz Cen_NEtaArr Cen_NEtaDet");
            auxst = "" + StringUtil.numformat(ic + 1, 5) + StringUtil.strformat(" '" + this.mydbm.resHydGen[ic].getName() + "'", 12);
            auxst = auxst + "  1    F       F       F       F           0           0";
            myPWriter.println(auxst);
            double[] resExtParam = this.mydbm.getResParam(this.mydbm.resHydGen[ic].getName());
            if (this.mydbm.resHydGen[ic].getgrounded()) {
                pmin = 0.0;
                pmax = 9000.0;
                costvar = 0.0;
                numBarInj = 0;
            } else {
                pmin = this.mydbm.resEleGen[ic].getpmin();
                pmax = this.mydbm.resEleGen[ic].getpmax();
                costvar = this.mydbm.resEleGen[ic].getCvPLP();
                numBarInj = this.mydbm.numbus(this.mydbm.resEleGen[ic].getcon2()) + 1;
            }
            affmed = this.mydbm.isHUnitWStochAff(this.mydbm.resHydGen[ic]) ? 0.0 : this.mydbm.getAffMed(this.mydbm.resHydGen[ic]);
            if (resExtParam[2] > 0.0) {
                costvar = 0.0;
            }
            rendi = this.mydbm.resHydGen[ic].getWat2PowRate();
            double volMax = this.mydbm.evalCota2Vol(resExtParam[1], ic);
            if (volMax > 0.0) {
                expfesc = (int)(Math.log(volMax) / Math.log(10.0));
                fesc = Math.pow(10.0, expfesc);
                expfesc += 6;
            } else {
                expfesc = 0;
                fesc = 1.0;
            }
            volMax /= fesc;
            double volMin = this.mydbm.evalCota2Vol(resExtParam[0], ic) / fesc;
            double volIni = this.mydbm.evalCota2Vol(resExtParam[4], ic) / fesc;
            double volFin = this.mydbm.evalCota2Vol(resExtParam[5], ic) / fesc;
            if (volIni < 0.0) {
                volIni = 0.0;
            }
            if (volFin < 0.0) {
                volFin = 0.0;
            }
            if (volMin < 0.0) {
                volMin = 0.0;
            }
            if (volMax < 0.0) {
                volMax = 0.0;
            }
            NumGenSpill = 0;
            NumGenTurb = 0;
            System.out.println(this.mydbm.resHydGen[ic].getName() + ": Vol Min:" + volMin);
            if (this.mydbm.resHydGen[ic].getTurbRecComp() != null) {
                NumGenTurb = 1 + this.mydbm.searchCompName(this.mydbm.resHydGen[ic].getTurbRecComp().getName(), this.mydbm.hydUnitsVec);
            }
            if (this.mydbm.resHydGen[ic].getSpilRecComp() != null) {
                NumGenSpill = 1 + this.mydbm.searchCompName(this.mydbm.resHydGen[ic].getSpilRecComp().getName(), this.mydbm.hydUnitsVec);
            }
            myPWriter.println("          PotMin PotMax VertMin VertMax");
            myPWriter.println(StringUtil.numformat(pmin, 16, 1) + StringUtil.numformat(pmax, 7, 1) + StringUtil.numformat(this.mydbm.resHydGen[ic].getSpillmin(), 8, 1) + StringUtil.numformat(this.mydbm.resHydGen[ic].getSpillmax(), 8, 1));
            myPWriter.println("           Start   Stop ON(t<0) NEta_OnOff");
            myPWriter.println("             0.0    0.0 F       0               Pot.           Volumen    Volumen    Volumen    Volumen  Factor");
            myPWriter.println("          CosVar  Rendi  Barra Genera Vertim    t<0  Afluen    Inicial      Final     Minimo     Maximo  Escala");
            auxst = StringUtil.numformat(costvar, 16, 1) + StringUtil.numformat(rendi, 7, 3) + StringUtil.numformat(numBarInj, 7) + StringUtil.numformat(NumGenTurb, 7);
            auxst = auxst + StringUtil.numformat(NumGenSpill, 7) + "    0.0" + StringUtil.numformat(affmed, 8, 1) + StringUtil.numformat(volIni, 11, 7) + StringUtil.numformat(volFin, 11, 7);
            auxst = auxst + StringUtil.numformat(volMin, 11, 7) + StringUtil.numformat(volMax, 11, 7) + StringUtil.strformat2("1.0E+" + expfesc, 8);
            myPWriter.println(auxst);
        }
        gencount += this.mydbm.resHydGen.length;
        myPWriter.println("# Centrales Serie Hidraulica");
        for (ic = 0; ic < this.mydbm.filHydGen.length; ++ic) {
            myPWriter.println("                   IPot MinTec  Inter   FCAD    Cen_MTTdHrz Cen_NEtaArr Cen_NEtaDet");
            auxst = "" + StringUtil.numformat(ic + 1 + gencount, 5) + StringUtil.strformat(" '" + this.mydbm.filHydGen[ic].getName() + "'", 12);
            auxst = auxst + "  1    F       F       F       F           0           0";
            myPWriter.println(auxst);
            pmin = 0.0;
            pmax = 9000.0;
            costvar = 0.0;
            numBarInj = 0;
            affmed = 0.0;
            rendi = 1.0;
            NumGenSpill = 0;
            NumGenTurb = 0;
            if (this.mydbm.filHydGen[ic].getTurbRecComp() != null) {
                NumGenTurb = 1 + this.mydbm.searchCompName(this.mydbm.filHydGen[ic].getTurbRecComp().getName(), this.mydbm.hydUnitsVec);
            }
            if (this.mydbm.filHydGen[ic].getSpilRecComp() != null) {
                NumGenSpill = 1 + this.mydbm.searchCompName(this.mydbm.filHydGen[ic].getSpilRecComp().getName(), this.mydbm.hydUnitsVec);
            }
            myPWriter.println("          PotMin PotMax VertMin VertMax");
            myPWriter.println(StringUtil.numformat(pmin, 16, 1) + StringUtil.numformat(pmax, 7, 1) + "     0.0  9000.0");
            myPWriter.println("           Start   Stop ON(t<0) NEta_OnOff");
            myPWriter.println("             0.0    0.0 F       0               Pot.");
            myPWriter.println("          CosVar  Rendi  Barra SerHid SerVer    t<0  Afluen");
            auxst = StringUtil.numformat(costvar, 16, 1) + StringUtil.numformat(rendi, 7, 3) + StringUtil.numformat(numBarInj, 7) + StringUtil.numformat(NumGenTurb, 7);
            auxst = auxst + StringUtil.numformat(NumGenSpill, 7) + "    0.0" + StringUtil.numformat(affmed, 8, 1);
            myPWriter.println(auxst);
        }
        gencount += this.mydbm.filHydGen.length;
        for (ic = 0; ic < this.mydbm.serHydGen.length; ++ic) {
            myPWriter.println("                   IPot MinTec  Inter   FCAD    Cen_MTTdHrz Cen_NEtaArr Cen_NEtaDet");
            auxst = "" + StringUtil.numformat(ic + 1 + gencount, 5) + StringUtil.strformat(" '" + this.mydbm.serHydGen[ic].getName() + "'", 12);
            auxst = auxst + "  1    F       F       F       F           0           0";
            myPWriter.println(auxst);
            if (this.mydbm.serHydGen[ic].getgrounded()) {
                pmin = this.mydbm.serHydGen[ic].getTurbmin();
                pmax = this.mydbm.serHydGen[ic].getTurbmax();
                costvar = 0.0;
                numBarInj = 0;
            } else {
                pmin = this.mydbm.serEleGen[ic].getpmin();
                pmax = this.mydbm.serEleGen[ic].getpmax();
                costvar = this.mydbm.serEleGen[ic].getCvPLP();
                numBarInj = this.mydbm.numbus(this.mydbm.serEleGen[ic].getcon2()) + 1;
            }
            affmed = this.mydbm.isHUnitWStochAff(this.mydbm.serHydGen[ic]) ? 0.0 : this.mydbm.getAffMed(this.mydbm.serHydGen[ic]);
            rendi = this.mydbm.serHydGen[ic].getWat2PowRate();
            NumGenSpill = 0;
            NumGenTurb = 0;
            if (this.mydbm.serHydGen[ic].getTurbRecComp() != null) {
                NumGenTurb = 1 + this.mydbm.searchCompName(this.mydbm.serHydGen[ic].getTurbRecComp().getName(), this.mydbm.hydUnitsVec);
            }
            if (this.mydbm.serHydGen[ic].getSpilRecComp() != null) {
                NumGenSpill = 1 + this.mydbm.searchCompName(this.mydbm.serHydGen[ic].getSpilRecComp().getName(), this.mydbm.hydUnitsVec);
            }
            myPWriter.println("          PotMin PotMax VertMin VertMax");
            myPWriter.println(StringUtil.numformat(pmin, 16, 1) + StringUtil.numformat(pmax, 7, 1) + StringUtil.numformat(this.mydbm.serHydGen[ic].getSpillmin(), 8, 1) + StringUtil.numformat(this.mydbm.serHydGen[ic].getSpillmax(), 8, 1));
            myPWriter.println("           Start   Stop ON(t<0) NEta_OnOff");
            myPWriter.println("             0.0    0.0 F       0               Pot.");
            myPWriter.println("          CosVar  Rendi  Barra SerHid SerVer    t<0  Afluen");
            auxst = StringUtil.numformat(costvar, 16, 1) + StringUtil.numformat(rendi, 7, 3) + StringUtil.numformat(numBarInj, 7) + StringUtil.numformat(NumGenTurb, 7);
            auxst = auxst + StringUtil.numformat(NumGenSpill, 7) + "    0.0" + StringUtil.numformat(affmed, 8, 1);
            myPWriter.println(auxst);
        }
        gencount += this.mydbm.serHydGen.length;
        for (ic = 0; ic < this.mydbm.irrigs.length; ++ic) {
            myPWriter.println("                   IPot MinTec  Inter   FCAD    Cen_MTTdHrz Cen_NEtaArr Cen_NEtaDet");
            auxst = "" + StringUtil.numformat(ic + 1 + gencount, 5) + StringUtil.strformat(" '" + this.mydbm.irrigs[ic].getName() + "'", 12);
            auxst = auxst + "  1    F       F       F       F           0           0";
            myPWriter.println(auxst);
            costvar = 0.0;
            numBarInj = 0;
            pmin = this.mydbm.irrigs[ic].getSpillmin();
            pmax = this.mydbm.irrigs[ic].getSpillmax();
            rendi = 1.0;
            affmed = this.mydbm.isHUnitWStochAff(this.mydbm.irrigs[ic]) ? 0.0 : this.mydbm.getAffMed(this.mydbm.irrigs[ic]);
            NumGenSpill = 0;
            NumGenTurb = 0;
            if (this.mydbm.irrigs[ic].getTurbRecComp() != null) {
                NumGenSpill = 1 + this.mydbm.searchCompName(this.mydbm.irrigs[ic].getTurbRecComp().getName(), this.mydbm.hydUnitsVec);
            }
            myPWriter.println("          PotMin PotMax VertMin VertMax");
            myPWriter.println(StringUtil.numformat(pmin, 16, 1) + StringUtil.numformat(pmax, 7, 1) + "     0.0  9000.0");
            myPWriter.println("           Start   Stop ON(t<0) NEta_OnOff");
            myPWriter.println("             0.0    0.0 F       0               Pot.");
            myPWriter.println("          CosVar  Rendi  Barra SerHid SerVer    t<0  Afluen");
            auxst = StringUtil.numformat(costvar, 16, 1) + StringUtil.numformat(rendi, 7, 3) + StringUtil.numformat(numBarInj, 7) + StringUtil.numformat(NumGenTurb, 7);
            auxst = auxst + StringUtil.numformat(NumGenSpill, 7) + "    0.0" + StringUtil.numformat(affmed, 8, 1);
            myPWriter.println(auxst);
        }
        myPWriter.println("# Centrales Pasada Puras");
        gencount += this.mydbm.irrigs.length;
        for (ic = 0; ic < this.mydbm.ppHydGen.length; ++ic) {
            myPWriter.println("                   IPot MinTec  Inter   FCAD    Cen_MTTdHrz Cen_NEtaArr Cen_NEtaDet");
            auxst = "" + StringUtil.numformat(ic + 1 + gencount, 5) + StringUtil.strformat(" '" + this.mydbm.ppHydGen[ic].getName() + "'", 12);
            auxst = auxst + "  1    F       F       F       F           0           0";
            myPWriter.println(auxst);
            pmin = 0.0;
            pmax = 9000.0;
            costvar = this.mydbm.ppEleGen[ic].getCvPLP();
            numBarInj = this.mydbm.numbus(this.mydbm.ppEleGen[ic].getcon2()) + 1;
            rendi = this.mydbm.ppHydGen[ic].getWat2PowRate();
            affmed = this.mydbm.isHUnitWStochAff(this.mydbm.ppHydGen[ic]) ? 0.0 : this.mydbm.getAffMed(this.mydbm.ppHydGen[ic]) * rendi;
            rendi = 1.0;
            NumGenSpill = 0;
            NumGenTurb = 0;
            myPWriter.println("          PotMin PotMax");
            myPWriter.println(StringUtil.numformat(pmin, 16, 1) + StringUtil.numformat(pmax, 7, 1));
            myPWriter.println("           Start   Stop ON(t<0) NEta_OnOff");
            myPWriter.println("             0.0    0.0 F       0               Pot.");
            myPWriter.println("          CosVar  Rendi  Barra SerHid SerVer    t<0  Afluen");
            auxst = StringUtil.numformat(costvar, 16, 1) + StringUtil.numformat(rendi, 7, 3) + StringUtil.numformat(numBarInj, 7) + StringUtil.numformat(NumGenTurb, 7);
            auxst = auxst + StringUtil.numformat(NumGenSpill, 7) + "    0.0" + StringUtil.numformat(affmed, 8, 1);
            myPWriter.println(auxst);
        }
        myPWriter.println("# Centrales Termicas o de Falla");
        gencount += this.mydbm.ppHydGen.length;
        for (ic = 0; ic < this.mydbm.thermalGen.length; ++ic) {
            myPWriter.println("                   IPot MinTec  Inter   FCAD    Cen_MTTdHrz Cen_NEtaArr Cen_NEtaDet");
            auxst = "" + StringUtil.numformat(ic + 1 + gencount, 5) + StringUtil.strformat(" '" + this.mydbm.thermalGen[ic].getName() + "'", 12);
            auxst = auxst + "  1    F       F       F       F           0           0";
            myPWriter.println(auxst);
            pmin = this.mydbm.thermalGen[ic].getpmin();
            pmax = this.mydbm.thermalGen[ic].getpmax();
            costvar = this.mydbm.thermalGen[ic].getCvPLP();
            numBarInj = this.mydbm.numbus(this.mydbm.thermalGen[ic].getcon2()) + 1;
            rendi = 1.0;
            NumGenSpill = 0;
            NumGenTurb = 0;
            myPWriter.println("          PotMin PotMax");
            myPWriter.println(StringUtil.numformat(pmin, 16, 1) + StringUtil.numformat(pmax, 7, 1));
            myPWriter.println("           Start   Stop ON(t<0) NEta_OnOff");
            myPWriter.println("             0.0    0.0 F       0               Pot.");
            myPWriter.println("          CosVar  Rendi  Barra SerHid SerVer    t<0");
            auxst = StringUtil.numformat(costvar, 16, 1) + StringUtil.numformat(rendi, 7, 3) + StringUtil.numformat(numBarInj, 7) + StringUtil.numformat(NumGenTurb, 7);
            auxst = auxst + StringUtil.numformat(NumGenSpill, 7) + "    0.0";
            myPWriter.println(auxst);
        }
        gencount += this.mydbm.thermalGen.length;
        double[] busFaultCost = this.mydbm.getBusFaultCost();
        for (ic = 0; ic < busVec.size(); ++ic) {
            myPWriter.println("                   IPot MinTec  Inter   FCAD    Cen_MTTdHrz Cen_NEtaArr Cen_NEtaDet");
            auxst = "" + StringUtil.numformat(ic + 1 + gencount, 5) + StringUtil.strformat(" 'FALLA" + (ic + 1) + "'", 12);
            auxst = auxst + "  1    F       F       F       F           0           0";
            myPWriter.println(auxst);
            pmin = 0.0;
            pmax = 9000.0;
            costvar = busFaultCost[ic];
            numBarInj = ic + 1;
            rendi = 1.0;
            NumGenSpill = 0;
            NumGenTurb = 0;
            myPWriter.println("          PotMin PotMax");
            myPWriter.println(StringUtil.numformat(pmin, 16, 1) + StringUtil.numformat(pmax, 7, 1));
            myPWriter.println("           Start   Stop ON(t<0) NEta_OnOff");
            myPWriter.println("             0.0    0.0 F       0               Pot.");
            myPWriter.println("          CosVar  Rendi  Barra SerHid SerVer    t<0");
            auxst = StringUtil.numformat(costvar, 16, 1) + StringUtil.numformat(rendi, 7, 3) + StringUtil.numformat(numBarInj, 7) + StringUtil.numformat(NumGenTurb, 7);
            auxst = auxst + StringUtil.numformat(NumGenSpill, 7) + "    0.0";
            myPWriter.println(auxst);
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileCOSTFUTEMB() throws Exception {
        hdb_res tempRes;
        int ix;
        PrintWriter myPWriter = this.openPWFile(COSTFUTEMB);
        int resWPl = 0;
        Vector resVec = this.mydbm.getReservoirs();
        double[][] resExtraData = new double[resVec.size()][0];
        for (ix = 0; ix < resVec.size(); ++ix) {
            tempRes = (hdb_res)resVec.elementAt(ix);
            resExtraData[ix] = this.mydbm.getResParam(tempRes.getName());
            if (!(resExtraData[ix][2] > 0.0)) continue;
            ++resWPl;
        }
        this.mydbm.loadFuncCotaVol();
        System.out.println("writing File: " + COSTFUTEMB);
        myPWriter.println("# Archivo con los planos de costo futuro (plpplaem.dat)");
        myPWriter.println("# N\u00famero de Embalses con costo futuro");
        myPWriter.println(resWPl);
        for (ix = 0; ix < resVec.size(); ++ix) {
            if (resExtraData[ix][2] < 0.9) continue;
            tempRes = (hdb_res)resVec.elementAt(ix);
            double maxvol = this.mydbm.evalCota2Vol(resExtraData[ix][1], ix);
            double fesc = Math.pow(10.0, (int)(Math.log(maxvol) / Math.log(10.0)));
            double[][] auxPlanEmb = this.mydbm.getPlanEmb(tempRes.getName());
            myPWriter.println("# Nombre del Embalse");
            myPWriter.println("'" + tempRes.getName() + "'");
            myPWriter.println("# N\u00famero de planos");
            myPWriter.println(auxPlanEmb.length);
            myPWriter.println("# Volumen      Costo");
            for (int interv = 0; interv < auxPlanEmb.length; ++interv) {
                myPWriter.println("" + StringUtil.numformat(this.mydbm.evalCota2Vol(auxPlanEmb[interv][0], ix) / fesc, 9, 7) + StringUtil.numformat(auxPlanEmb[interv][1], 11, 2));
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileAFLCENT() throws Exception {
        int indHyd;
        PrintWriter myPWriter = this.openPWFile(AFLCENT);
        PrintWriter myPWriterRes = this.openPWFile2(AFLCENTRes);
        System.out.println("writing File: " + AFLCENT);
        Vector cenWAffVec = this.mydbm.getStochAffHydUnits();
        int numStages = this.mydbm.getNumStages();
        int numBlocks = this.mydbm.getParam_Sim("Num_Bloques_CC");
        int endY = this.mydbm.getParam_Sim("Ultimo_A\u00f1o_Est_Hidro");
        int iniY = this.mydbm.getParam_Sim("Num_Hidrologias");
        int[] indHydMonth = this.mydbm.getStageIndHydMonth();
        iniY = endY - iniY + 1;
        myPWriter.println("# Archivo de caudales por etapa (plpaflce.dat)");
        myPWriter.println("# Nro. Cent. c/Caudales Estoc. (EstocNVar2) y Nro. Hidrologias (NClase)");
        myPWriter.println(StringUtil.numformat(cenWAffVec.size(), 8) + StringUtil.numformat(this.mydbm.getParam_Sim("Num_Hidrologias"), 8));
        myPWriterRes.print("Etapa,CenNom");
        String auxStr1 = "";
        hdb_unit tempHUnit = (hdb_unit)cenWAffVec.elementAt(0);
        double[][] auxAffCaud = this.mydbm.getCentAffCaud(iniY, endY, tempHUnit);
        for (indHyd = 0; indHyd < auxAffCaud[0].length; ++indHyd) {
            auxStr1 = auxStr1 + ",Hidro" + (indHyd + 1);
        }
        myPWriterRes.println(auxStr1);
        for (int ix = 0; ix < cenWAffVec.size(); ++ix) {
            int indBloq;
            String auxStr;
            int indSt;
            tempHUnit = (hdb_unit)cenWAffVec.elementAt(ix);
            auxAffCaud = this.mydbm.getCentAffCaud(iniY, endY, tempHUnit);
            myPWriter.println("# Nombre de la central");
            myPWriter.println("'" + tempHUnit.getName() + "'");
            myPWriter.println("#   Numero de etapas con caudales");
            myPWriter.println("" + numStages * numBlocks);
            myPWriter.println("# Mes   Etapa        Caudal");
            if (!(tempHUnit instanceof hdb_paspur) || !((hdb_paspur)tempHUnit).getIsRegulTank()) {
                for (indSt = 0; indSt < numStages; ++indSt) {
                    auxStr = "";
                    auxStr1 = "";
                    for (indHyd = 0; indHyd < auxAffCaud[0].length; ++indHyd) {
                        auxStr = auxStr + StringUtil.numformat(auxAffCaud[indSt][indHyd], 9, 2);
                        auxStr1 = auxStr1 + "," + StringUtil.numformat(auxAffCaud[indSt][indHyd], 9, 2);
                    }
                    for (indBloq = 0; indBloq < numBlocks; ++indBloq) {
                        myPWriter.println(StringUtil.numformat(indHydMonth[indSt], 5) + "    " + StringUtil.numformat(indSt * numBlocks + indBloq + 1, 4) + "\t" + auxStr);
                        myPWriterRes.println(StringUtil.numformat(indSt * numBlocks + indBloq + 1, 4) + "," + tempHUnit.getName() + auxStr1);
                    }
                }
                continue;
            }
            for (indSt = 0; indSt < numStages; ++indSt) {
                double[][] auxBAffcaud = this.mydbm.getModAdjCaud((hdb_paspur)tempHUnit, indSt, auxAffCaud[indSt]);
                for (indBloq = 0; indBloq < numBlocks; ++indBloq) {
                    auxStr = "";
                    auxStr1 = "";
                    for (indHyd = 0; indHyd < auxAffCaud[0].length; ++indHyd) {
                        auxStr = auxStr + StringUtil.numformat(auxBAffcaud[indBloq][indHyd], 9, 2);
                        auxStr1 = auxStr1 + "," + StringUtil.numformat(auxBAffcaud[indBloq][indHyd], 9, 2);
                    }
                    myPWriter.println(StringUtil.numformat(indHydMonth[indSt], 5) + "    " + StringUtil.numformat(indSt * numBlocks + indBloq + 1, 4) + "\t" + auxStr);
                    myPWriterRes.println(StringUtil.numformat(indSt * numBlocks + indBloq + 1, 4) + "," + tempHUnit.getName() + auxStr1);
                }
            }
        }
        myPWriter.flush();
        myPWriterRes.flush();
        this.closeActFOS();
        this.closeActFOS2();
    }

    public void writeFileIDENSIM() throws Exception {
        int block;
        int auxi;
        int stage;
        int nsim;
        PrintWriter myPWriter = this.openPWFile(IDENSIM);
        PrintWriter myPWriterRes = this.openPWFile2(IDENSIMRes);
        System.out.println("writing File: " + IDENSIM);
        int[][] stagNYear = this.mydbm.getStageIndHydYear();
        int[][] randSimYear = this.mydbm.getRandSimYear();
        myPWriter.println("# Archivo de caudales por etapa (plpidsim.dat)");
        myPWriter.println("# N\u00famero de simulaciones y etapas con caudales");
        int numSim = randSimYear[0].length;
        int numBlocks = this.mydbm.getParam_Sim("Num_Bloques_CC");
        int[] indHydMonth = this.mydbm.getStageIndHydMonth();
        myPWriter.println("   " + numSim + "   " + numBlocks * stagNYear.length);
        myPWriter.println("# Mes   Etapa  SimulInd(1,...,NSimul)");
        myPWriterRes.print("Etapa");
        for (nsim = 0; nsim < numSim; ++nsim) {
            myPWriterRes.print(",Sim" + (nsim + 1));
        }
        myPWriterRes.println("");
        for (stage = 0; stage < stagNYear.length; ++stage) {
            auxi = stage * numBlocks;
            for (block = 0; block < numBlocks; ++block) {
                myPWriter.print(StringUtil.numformat(indHydMonth[stage], 5));
                myPWriter.print(StringUtil.numformat(auxi + block + 1, 8));
                for (nsim = 0; nsim < numSim; ++nsim) {
                    myPWriter.print(StringUtil.numformat(randSimYear[stagNYear[stage][0]][nsim], 5));
                }
                myPWriter.println("");
            }
        }
        for (stage = 0; stage < stagNYear.length; ++stage) {
            auxi = stage * numBlocks;
            for (block = 0; block < numBlocks; ++block) {
                myPWriterRes.print(StringUtil.numformat(auxi + block + 1, 8));
                for (nsim = 0; nsim < numSim; ++nsim) {
                    myPWriterRes.print("," + StringUtil.numformat(randSimYear[stagNYear[stage][0]][nsim], 5));
                }
                myPWriterRes.println("");
            }
        }
        myPWriter.flush();
        myPWriterRes.flush();
        this.closeActFOS();
        this.closeActFOS2();
    }

    public void writeFileIDENAPER() throws Exception {
        PrintWriter myPWriter = this.openPWFile(IDENAPER);
        int[] aleatAper = null;
        boolean newAperArr = true;
        System.out.println("writing File: " + IDENAPER);
        int[][] stagNYear = this.mydbm.getStageIndHydYear();
        int[][] randSimYear = this.mydbm.getRandSimYear();
        myPWriter.println("# Archivo de caudales por etapa (plpidape.dat)");
        myPWriter.println("# N\u00famero de simulaciones y etapas con caudales");
        int numSim = randSimYear[0].length;
        int numApe = this.mydbm.getParam_Sim("Num_Aperturas");
        int numBlocks = this.mydbm.getParam_Sim("Num_Bloques_CC");
        int tipoApe = this.mydbm.getParam_Sim("Tipo_Apertura");
        int numHStat = this.mydbm.getParam_Sim("Num_Hidrologias");
        aleatAper = this.mydbm.getAperArray(numHStat, numApe);
        int[] indHydMonth = this.mydbm.getStageIndHydMonth();
        myPWriter.println("   " + numSim + "   " + numBlocks * stagNYear.length);
        for (int nsim = 0; nsim < numSim; ++nsim) {
            myPWriter.println("# Mes   Etapa  NApert ApertInd(1,...,NApert) - Simulacion=" + (nsim + 1));
            for (int stage = 0; stage < stagNYear.length; ++stage) {
                int block;
                int auxi = stage * numBlocks;
                newAperArr = stagNYear[stage][1] > 0 && tipoApe > 0;
                newAperArr = newAperArr || stage == 0 && stagNYear[stage][1] > 0;
                boolean bl = newAperArr = newAperArr || stage != 0 && randSimYear[stagNYear[stage][0]][nsim] != randSimYear[stagNYear[stage - 1][0]][nsim];
                if (newAperArr) {
                    aleatAper = this.mydbm.getAperArray(numHStat, numApe);
                }
                auxi = stage * numBlocks;
                if (stagNYear[stage][1] < 0) {
                    for (block = 0; block < numBlocks; ++block) {
                        myPWriter.print(StringUtil.numformat(indHydMonth[stage], 5));
                        myPWriter.print(StringUtil.numformat(auxi + block + 1, 8));
                        myPWriter.print(StringUtil.numformat(1, 6));
                        myPWriter.print(StringUtil.numformat(randSimYear[stagNYear[stage][0]][nsim], 5));
                        myPWriter.println("");
                    }
                    continue;
                }
                for (block = 0; block < numBlocks; ++block) {
                    myPWriter.print(StringUtil.numformat(indHydMonth[stage], 5));
                    myPWriter.print(StringUtil.numformat(auxi + block + 1, 8));
                    myPWriter.print(StringUtil.numformat(numApe, 6));
                    for (int nape = 0; nape < numApe; ++nape) {
                        myPWriter.print(StringUtil.numformat(aleatAper[nape], 5));
                    }
                    myPWriter.println("");
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileMANTCENT() throws Exception {
        PrintWriter myPWriter = this.openPWFile(MANTCENT);
        System.out.println("writing File: " + MANTCENT);
        Vector mantGenN = this.mydbm.getMantObjN(PLPUtils.mantGenSt);
        int numBlocks = this.mydbm.getParam_Sim("Num_Bloques_CC");
        int numStages = this.mydbm.getNumStages();
        myPWriter.println("# Archivo de mantenimientos de centrales (plpmance.dat)");
        myPWriter.println("# N\u00famero de centrales con matenimientos");
        myPWriter.println(mantGenN.size());
        for (int ix = 0; ix < mantGenN.size(); ++ix) {
            int jx;
            String generName = (String)mantGenN.elementAt(ix);
            double[][] redefGen = this.mydbm.getMantRedefObj(generName, PLPUtils.mantGenSt);
            int countmant = 0;
            for (jx = 0; jx < numStages; ++jx) {
                if (redefGen[jx].length <= 0) continue;
                ++countmant;
            }
            if (countmant <= 0) continue;
            myPWriter.println("# Nombre de la central");
            myPWriter.println("'" + generName + "'");
            myPWriter.println("#   N\u00famero de Etapas e Intervalos");
            myPWriter.println("    " + countmant * numBlocks + "                 01");
            myPWriter.println("#   Mes    Etapa  NIntPot   PotMin   PotMax");
            for (jx = 0; jx < numStages; ++jx) {
                if (redefGen[jx].length <= 0) continue;
                for (int kx = 0; kx < numBlocks; ++kx) {
                    myPWriter.println("     00" + StringUtil.numformat(jx * numBlocks + kx + 1, 9) + "        1" + StringUtil.numformat(redefGen[jx][0], 9, 1) + StringUtil.numformat(redefGen[jx][1], 9, 1));
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileMANTEMB() throws Exception {
        PrintWriter myPWriter = this.openPWFile(MANTEMB);
        System.out.println("writing File: " + MANTEMB);
        Vector mantResN = this.mydbm.getMantObjN(PLPUtils.mantResSt);
        int numBlocks = this.mydbm.getParam_Sim("Num_Bloques_CC");
        int numStages = this.mydbm.getNumStages();
        this.mydbm.loadFuncCotaVol();
        myPWriter.println("# Archivo de mantenimientos embalses (plpmanem.dat)");
        myPWriter.println("# N\u00famero de embalses con mantenimientos");
        myPWriter.println(mantResN.size());
        for (int ix = 0; ix < mantResN.size(); ++ix) {
            int jx;
            String reserName = (String)mantResN.elementAt(ix);
            double[][] redefRes = this.mydbm.getMantRedefObj(reserName, PLPUtils.mantResSt);
            double[] resExtParam = this.mydbm.getResParam(reserName);
            double volMax = this.mydbm.evalCota2Vol(resExtParam[1], reserName);
            double fesc = volMax > 0.0 ? Math.pow(10.0, (int)(Math.log(volMax) / Math.log(10.0))) : 1.0;
            int countmant = 0;
            for (jx = 0; jx < numStages; ++jx) {
                if (redefRes[jx].length <= 0) continue;
                ++countmant;
            }
            if (countmant <= 0) continue;
            myPWriter.println("# Nombre del embalse");
            myPWriter.println("'" + reserName + "'");
            myPWriter.println("# N\u00famero de etapas");
            myPWriter.println(countmant * numBlocks);
            myPWriter.println("# Mes   Etapa    VolMin     VolMax");
            for (jx = 0; jx < numStages; ++jx) {
                if (redefRes[jx].length <= 0) continue;
                double aux1 = this.mydbm.evalCota2Vol(redefRes[jx][0], reserName) / fesc;
                double aux2 = this.mydbm.evalCota2Vol(redefRes[jx][1], reserName) / fesc;
                for (int kx = 0; kx < numBlocks; ++kx) {
                    myPWriter.println("   00" + StringUtil.numformat(jx * numBlocks + kx + 1, 8) + StringUtil.numformat(aux1, 10, 5) + StringUtil.numformat(aux2, 11, 5));
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileMANTLIN() throws Exception {
        PrintWriter myPWriter = this.openPWFile(MANTLIN);
        System.out.println("writing File: " + MANTLIN);
        Vector mantCxN = this.mydbm.getMantObjN(PLPUtils.mantCxSt);
        int numBlocks = this.mydbm.getParam_Sim("Num_Bloques_CC");
        int numStages = this.mydbm.getNumStages();
        myPWriter.println("# Archivo de mantenimientos de lineas (plpmanli.dat)");
        myPWriter.println("# N\u00famero de lineas con mantenimientos");
        myPWriter.println(mantCxN.size());
        for (int ix = 0; ix < mantCxN.size(); ++ix) {
            int jx;
            String branName = (String)mantCxN.elementAt(ix);
            double[][] redefCx = this.mydbm.getMantRedefObj(branName, PLPUtils.mantCxSt);
            int countmant = 0;
            for (jx = 0; jx < numStages; ++jx) {
                if (redefCx[jx].length <= 0) continue;
                ++countmant;
            }
            if (countmant <= 0) continue;
            myPWriter.println("# Nombre de la linea");
            myPWriter.println("'" + branName + "'");
            myPWriter.println("# N\u00famero de etapas con mantenimiento");
            myPWriter.println(countmant * numBlocks);
            myPWriter.println("# N\u00fameroEtapa PotMaxAB   PotMaxBA     Operativa");
            for (jx = 0; jx < numStages; ++jx) {
                if (redefCx[jx].length <= 0) continue;
                String st = redefCx[jx][0] < 0.1 && redefCx[jx][1] < 0.1 ? NOST : SIST;
                for (int kx = 0; kx < numBlocks; ++kx) {
                    myPWriter.println(StringUtil.numformat(jx * numBlocks + kx + 1, 6) + StringUtil.numformat(redefCx[jx][0], 15, 0) + StringUtil.numformat(redefCx[jx][1], 10, 0) + StringUtil.strformat2(st, 10));
                }
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileFILTCENT() throws Exception {
        int i;
        PrintWriter myPWriter = this.openPWFile(FILTCENT);
        System.out.println("writing File: " + FILTCENT);
        int nResWFilt = 0;
        int filtcount = 0;
        this.mydbm.loadHydroConnect();
        double[][][] filtTang = new double[this.mydbm.resHydGen.length][0][0];
        for (i = 0; i < this.mydbm.resHydGen.length; ++i) {
            if (this.mydbm.resHydGen[i].getFiltType() <= 0) continue;
            ++nResWFilt;
            filtTang[i] = this.mydbm.getFilterTangents(i);
            if (filtTang[i] != null) continue;
            System.out.println("Error en tangentes de: " + this.mydbm.resHydGen[i].getName());
        }
        myPWriter.println("# Archivo de Filtraciones de Embalses (plpcenfi.dat)");
        myPWriter.println("# N\u00famero Embalses con Filtraciones");
        myPWriter.println(nResWFilt);
        filtcount = -1;
        for (i = 0; i < this.mydbm.resHydGen.length; ++i) {
            if (this.mydbm.resHydGen[i].getFiltType() == 0) continue;
            myPWriter.println("# Nombre de la Central");
            myPWriter.println("'" + this.mydbm.filHydGen[++filtcount].getName() + "'");
            myPWriter.println("# Nombre del Embalse");
            myPWriter.println("'" + this.mydbm.resHydGen[i].getName() + "'");
            myPWriter.println("#Filtraciones Medias");
            double medfilt = this.mydbm.getResParam(this.mydbm.resHydGen[i].getName())[6];
            myPWriter.println(StringUtil.numformat(medfilt, 5, 3));
            myPWriter.println("# N\u00famero de Tramos");
            myPWriter.println(filtTang[i].length);
            myPWriter.println("#Tramo      Volumen     Pendiente    Constante  F.Escala");
            for (int j = 0; j < filtTang[i].length; ++j) {
                myPWriter.println(StringUtil.numformat(j + 1, 6) + StringUtil.numformat(filtTang[i][j][0], 13, 7) + StringUtil.numformat(filtTang[i][j][1], 14, 7) + StringUtil.numformat(filtTang[i][j][2], 13, 7) + "   " + filtTang[i][j][3]);
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileRENDCENT() throws Exception {
        int i;
        PrintWriter myPWriter = this.openPWFile(RENDCENT);
        System.out.println("writing File: " + RENDCENT);
        int nResWRend = 0;
        Vector resVec = this.mydbm.getReservoirs();
        double[][][] rendTang = new double[resVec.size()][0][0];
        for (i = 0; i < resVec.size(); ++i) {
            rendTang[i] = this.mydbm.getRendTangents(i);
            if (rendTang[i].length <= 0) continue;
            ++nResWRend;
        }
        myPWriter.println("# Archivo de Rendimiento de Embalses (plpcenre.dat)");
        myPWriter.println("# N\u00famero de Embalses con Rendimiento");
        myPWriter.println(nResWRend);
        for (i = 0; i < resVec.size(); ++i) {
            if (rendTang[i].length == 0) continue;
            hdb_res tempRes = (hdb_res)resVec.elementAt(i);
            myPWriter.println("# Nombre de Central");
            myPWriter.println("'" + tempRes.getName() + "'");
            myPWriter.println("# Nombre del Embalse");
            myPWriter.println("'" + tempRes.getName() + "'");
            myPWriter.println("# Rendimiento Medio");
            myPWriter.println(StringUtil.numformat(tempRes.getWat2PowRate(), 5, 3));
            myPWriter.println("# N\u00famero de Tramos");
            myPWriter.println(rendTang[i].length);
            myPWriter.println("#Tramo      Volumen     Pendiente    Constante  F.Escala");
            for (int j = 0; j < rendTang[i].length; ++j) {
                myPWriter.println(StringUtil.numformat(j + 1, 6) + StringUtil.numformat(rendTang[i][j][0], 13, 7) + StringUtil.numformat(rendTang[i][j][1], 14, 7) + StringUtil.numformat(rendTang[i][j][2], 13, 7) + "   " + rendTang[i][j][3]);
            }
        }
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileCONVLAJA() throws Exception {
        String mitipo = "";
        String lastparam = "";
        String currentparam = "";
        int NY = 0;
        boolean onIter = false;
        PrintWriter myPWriter = this.openPWFile(CONVLAJA);
        myPWriter.println("# Archivo de convenio del Laja (plplaja.dat)");
        int[][] indHydYear = this.mydbm.getStageIndHydYear();
        int NS = this.mydbm.getStageDef().size();
        NY = indHydYear[NS - 1][0] + 1;
        try {
            this.stmt = this.dbtrab.createStatement();
            this.query = "SELECT * FROM Convenios WHERE Nombre = 'LAJA' order by Parametro,Tipo";
            this.rs = this.stmt.executeQuery(this.query);
            int paramcount = 0;
            myPWriter.println("'NumAnos'");
            myPWriter.println(NY);
            while (this.rs.next()) {
                currentparam = this.rs.getString("Parametro");
                if (!currentparam.equals(lastparam)) {
                    myPWriter.println("'" + currentparam + "' ");
                    if (onIter && paramcount != NY * 12) {
                        System.out.println("Error: deberian ser: " + NY * 12 + " meses, en PLPDB convenio Laja, en parametros '" + lastparam + "'");
                    }
                    paramcount = 1;
                    onIter = false;
                } else {
                    ++paramcount;
                    onIter = true;
                }
                mitipo = this.rs.getString("Tipo");
                String aux = mitipo.equals("texto") ? "'" + this.rs.getString("Valor") + "' " : this.rs.getString("Valor");
                aux = StringUtil.strformat(aux, 15);
                myPWriter.print(aux);
                aux = "'" + this.rs.getString("Unidad") + "'";
                aux = StringUtil.strformat(aux, 8);
                myPWriter.print(aux);
                aux = "'" + mitipo + "'";
                aux = StringUtil.strformat(aux, 10);
                myPWriter.print(aux);
                myPWriter.println("'" + this.rs.getString("Descripcion") + "'");
                lastparam = currentparam;
            }
            this.rs.close();
            this.stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error en Lectura de Convenio Laja.");
        }
        System.out.println("writing File: " + CONVLAJA);
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileCONVMAULE() throws Exception {
        String mitipo = "";
        String lastparam = "";
        String currentparam = "";
        int NY = 0;
        boolean onIter = false;
        PrintWriter myPWriter = this.openPWFile(CONVMAULE);
        myPWriter.println("# Archivo de convenio del Maule (plpmaule.dat)");
        int[][] indHydYear = this.mydbm.getStageIndHydYear();
        int NS = this.mydbm.getStageDef().size();
        NY = indHydYear[NS - 1][0] + 1;
        try {
            this.stmt = this.dbtrab.createStatement();
            this.query = "SELECT * FROM Convenios WHERE Nombre = 'MAULE' order by Parametro, Tipo";
            this.rs = this.stmt.executeQuery(this.query);
            int paramcount = 0;
            myPWriter.println("'NumAnos'");
            myPWriter.println(NY);
            while (this.rs.next()) {
                currentparam = this.rs.getString("Parametro");
                if (!currentparam.equals(lastparam)) {
                    myPWriter.println("'" + currentparam + "' ");
                    if (onIter && paramcount != NY * 12) {
                        System.out.println("Error: deberian ser: " + NY * 12 + " meses, en PLPDB convenio Maule, parametros '" + lastparam + "'");
                    }
                    paramcount = 1;
                    onIter = false;
                } else {
                    ++paramcount;
                    onIter = true;
                }
                mitipo = this.rs.getString("Tipo");
                String aux = mitipo.equals("texto") ? "'" + this.rs.getString("Valor") + "' " : this.rs.getString("Valor");
                aux = StringUtil.strformat(aux, 15);
                myPWriter.print(aux);
                aux = "'" + this.rs.getString("Unidad") + "'";
                aux = StringUtil.strformat(aux, 8);
                myPWriter.print(aux);
                aux = "'" + mitipo + "'";
                aux = StringUtil.strformat(aux, 10);
                myPWriter.print(aux);
                myPWriter.println("'" + this.rs.getString("Descripcion") + "'");
                lastparam = currentparam;
            }
            this.rs.close();
            this.stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error en Lectura de Convenio Maule.");
        }
        System.out.println("writing File: " + CONVMAULE);
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileMATPAR() throws Exception {
        PrintWriter myPWriter = this.openPWFile(MATPAR);
        System.out.println("writing File: " + MATPAR);
        this.copyFile2F(myPWriter, MATPAR);
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFileDEBUGPAR() throws Exception {
        PrintWriter myPWriter = this.openPWFile(DEBUGPAR);
        System.out.println("writing File: " + DEBUGPAR);
        this.copyFile2F(myPWriter, DEBUGPAR);
        myPWriter.flush();
        this.closeActFOS();
    }

    public void writeFilePARAM() throws Exception {
        PrintWriter myPWriter = this.openPWFile(PARAM);
        System.out.println("writing File: " + PARAM);
        this.copyFile2F(myPWriter, PARAM);
        myPWriter.flush();
        this.closeActFOS();
    }

    public void editFile(String filename, int editor2) throws Exception {
        if (editor2 == NOTEPAD) {
            Runtime r = Runtime.getRuntime();
            r.exec("notepad " + this.plpWorkPath + "\\" + filename);
        } else if (editor2 == ZFILEVIWER) {
            this.DoListResults(this.plpWorkPath + "\\" + filename);
        }
    }

    public Connection OpenDataBase(String DBName, String user, String password) throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println("Error: en Connection OpenDatabase " + message);
            return null;
        }
        String dsn = "jdbc:odbc:" + DBName;
        return DriverManager.getConnection(dsn, user, password);
    }

    private void copyFile2F(PrintWriter pw2, String fname) throws Exception {
        int nc;
        FileReader orig = new FileReader(this.plpTempPath + "\\" + fname);
        char[] cbuf = new char[500];
        while ((nc = orig.read(cbuf, 0, 500)) > 0) {
            if (nc < 500) {
                for (int i = 0; i < nc; ++i) {
                    pw2.print(cbuf[i]);
                }
                continue;
            }
            pw2.print(cbuf);
        }
        orig.close();
    }
}

