/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Busbar;
import de.core.CvaLinPartes;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.PLPException;
import de.core.Schematic;
import de.core.Trafo;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_comp;
import de.core.hdb_irr;
import de.core.hdb_link;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.core.ndb_branch;
import de.core.ndb_inj;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.Vector;

public final class PLPUtils {
    static String[] monthsnames = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
    static String[] AffMonNames = new String[]{"ABR", "MAY", "JUN", "JUL", "AGO", "SEP", "OCT", "NOV", "DIC", "ENE", "FEB", "MAR"};
    public Vector busVector = null;
    public Vector branchesVector = null;
    public Vector generatorVector = null;
    public Vector reservoirVector = null;
    String[] busNames = null;
    double[][] busPLoad = null;
    Vector stageDef = null;
    int[] weeksDur = null;
    int[] stageFrTo = null;
    Date[][] stageDiniDend = null;
    int[][] stageIndHYear = null;
    int[][] randSimHydYear = null;
    int[] stageIndHMonth = null;
    Date iniHorizDate = null;
    Date endHorizDate = null;
    static String[] mantCxSt = new String[]{"Conexion", "Cx_Mantenimientos", "FlujoIJ_Max", "FlujoJI_Max"};
    static String[] mantGenSt = new String[]{"Generador", "Gen_Mantenimientos", "PG_Min", "PG_Max"};
    static String[] mantResSt = new String[]{"Embalse", "Emb_Mantenimientos", "Cota_Min", "Cota_Max"};
    CvaLinPartes[] funcCotaVol = null;
    public int[] bloStagNumH = null;
    public int[] bloStagMonth = null;
    public int[] bloStagYear = null;
    public Vector bloStagDefVec = null;
    Random myRandNumGen = null;
    private Schematic sch;
    private Connection dBConn;
    public Generator[] thermalGen;
    public Vector hydUnitsVec;
    public Generator[] resEleGen;
    public Generator[] serEleGen;
    public Generator[] ppEleGen;
    public hdb_res[] resHydGen;
    public hdb_ser[] serHydGen;
    public hdb_paspur[] ppHydGen;
    public hdb_ser[] filHydGen;
    public hdb_irr[] irrigs;
    private DeepEdit applet;
    private double[][] auxAffMat = null;
    private double[][] auxWeekAffMat = null;
    private double[][] auxWSAffsMat = null;
    private double[][] auxppBMat = null;

    PLPUtils(Schematic psch, Connection pdBConn, DeepEdit depApp) {
        this.sch = psch;
        this.dBConn = pdBConn;
        this.applet = depApp;
    }

    public Vector getStageDef() throws Exception {
        if (this.stageDef != null) {
            return this.stageDef;
        }
        int regcount = 0;
        this.stageDef = new Vector(36);
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Def_Etapas ORDER BY Num_Etapa");
        while (r.next()) {
            int stage = r.getInt("Num_Etapa");
            int value = r.getInt("Duracion");
            if (stage != ++regcount || value < 1) {
                throw new PLPException("tabla Def_Etapas, datos inconsistentes., PLPDB");
            }
            this.stageDef.addElement(new Integer(value));
        }
        s.close();
        return this.stageDef;
    }

    public int[] getWeeksDur() throws Exception {
        if (this.weeksDur != null) {
            return this.weeksDur;
        }
        int regcount = 0;
        int month = 1;
        int week = 1;
        int dur = 7;
        int cmonth = 1;
        int cweek = 1;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FDCA_Semanas ORDER BY Mes, Semana");
        int[] weekdur = new int[48];
        while (r.next()) {
            month = r.getInt("Mes");
            week = r.getInt("Semana");
            dur = r.getInt("Num_dias");
            if (month != cmonth || week != cweek || dur < 7 || dur > 8) {
                throw new PLPException("Numero incorrecto de dias en Dem_FDCA_Semanas, PLPDB");
            }
            weekdur[regcount] = dur;
            ++regcount;
            if (++cweek != 5) continue;
            cweek = 1;
            ++cmonth;
        }
        s.close();
        regcount = 0;
        for (int i = 0; i < 48; ++i) {
            regcount += weekdur[i];
        }
        if (regcount > 365) {
            throw new PLPException("Total de dias excede 365 en Dem_FDCA_Semanas, PLPDB");
        }
        this.weeksDur = weekdur;
        return weekdur;
    }

    public double[] getWeeksPEngy() throws Exception {
        double pEngy;
        int regcount = 0;
        int month = 1;
        int week = 1;
        int cmonth = 1;
        int cweek = 1;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FDCA_Semanas ORDER BY Mes, Semana");
        double[] weekPEngy = new double[48];
        while (r.next()) {
            month = r.getInt("Mes");
            week = r.getInt("Semana");
            pEngy = r.getDouble("FDDS");
            if (month != cmonth || week != cweek) {
                throw new PLPException("datos incorrectos de FDDS en Dem_FDCA_Semanas, PLPDB");
            }
            weekPEngy[regcount] = pEngy;
            ++regcount;
            if (++cweek != 5) continue;
            cweek = 1;
            ++cmonth;
        }
        s.close();
        pEngy = 0.0;
        for (int i = 0; i < 48; ++i) {
            pEngy += weekPEngy[i];
        }
        if (pEngy > 100.1 || pEngy < 99.9) {
            throw new PLPException("suma de FDDS es " + pEngy + "% de la demanda anual en Dem_FDCA_Semanas, PLPDB");
        }
        return weekPEngy;
    }

    public String[] getBlocksNames() throws Exception {
        int regcount = 0;
        int block = 0;
        int numblocks = this.getParam_Sim("Num_Bloques_CC");
        if (numblocks == 0) {
            throw new PLPException("Numero de bloques incorrectos en Param_Sim, PLPDB");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Nombre_Bloques_CDC WHERE (Grupo_NumBloques=" + numblocks + ") ORDER BY Num_Bloque");
        String[] BlocksNames = new String[numblocks];
        while (r.next()) {
            block = r.getInt("Num_Bloque");
            if (++regcount != block || regcount > numblocks) {
                throw new PLPException("tabla Nombre_Bloques_CDC, datos incorrectos, PLPDB");
            }
            BlocksNames[regcount - 1] = r.getString("Nombre_Bloque");
        }
        s.close();
        return BlocksNames;
    }

    public int getParam_Sim(String Prameter) throws Exception {
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Param_Sim WHERE Parametro='" + Prameter + "'");
        int value = -1;
        while (r.next()) {
            value = r.getInt("Valor");
        }
        s.close();
        if (value == -1) {
            throw new PLPException(" '" + Prameter + "' erroneo o no encontrado en Param_Sim, PLPDB");
        }
        return value;
    }

    public double getYearRate(int Year) throws Exception {
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Tasas_Descuento WHERE (Ano=" + Year + ") ORDER BY Ano");
        double value = 1.0;
        while (r.next()) {
            value = r.getInt("Tasa_Descuento");
        }
        s.close();
        return value;
    }

    public double[][] getBlocksPDur() throws Exception {
        int regcount = 0;
        int numblocks = this.getParam_Sim("Num_Bloques_CC");
        if (numblocks == 0) {
            throw new PLPException("Numero de bloques incorrectos en Param_Sim, PLPDB");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FCDC_Semanal_" + numblocks + "B" + " ORDER BY Mes, Semana");
        double[][] blocksPDur = new double[48][numblocks];
        while (r.next()) {
            if (regcount > 47) {
                throw new PLPException("tabla Dem_FCDC_Semanal_" + numblocks + "B, datos incorrectos, PLPDB");
            }
            double sumver = 0.0;
            for (int i = 1; i <= numblocks; ++i) {
                blocksPDur[regcount][i - 1] = r.getDouble("Bloq" + i + "_Fact_Dur");
                if (blocksPDur[regcount][i - 1] <= 0.0) {
                    throw new PLPException("tabla Dem_FCDC_Semanal_" + numblocks + "B, duracion de bloques incorrecta, PLPDB");
                }
                sumver += blocksPDur[regcount][i - 1];
            }
            if (sumver > 100.1 || sumver < 99.9) {
                throw new PLPException("tabla Dem_FCDC_Semanal_" + numblocks + "B, duracion de bloques incorrecta, PLPDB");
            }
            ++regcount;
        }
        s.close();
        return blocksPDur;
    }

    public double[][] getBlocksPEngy() throws Exception {
        int regcount = 0;
        int numblocks = this.getParam_Sim("Num_Bloques_CC");
        if (numblocks == 0) {
            throw new PLPException("Numero de bloques incorrectos en Param_Sim, PLPDB");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FCDC_Semanal_" + numblocks + "B" + " ORDER BY Mes, Semana");
        double[][] blocksPEngy = new double[48][numblocks];
        while (r.next()) {
            if (regcount > 47) {
                throw new PLPException("tabla Dem_FCDC_Semanal_" + numblocks + "B, datos incorrectos, PLPDB");
            }
            double sumver = 0.0;
            for (int i = 1; i <= numblocks; ++i) {
                blocksPEngy[regcount][i - 1] = r.getDouble("Bloq" + i + "_Fact_Dem");
                sumver += blocksPEngy[regcount][i - 1];
            }
            if (sumver > 100.1 || sumver < 99.9) {
                throw new PLPException("tabla Dem_FCDC_Semanal_" + numblocks + "B, energia de bloques incorrecta, PLPDB");
            }
            ++regcount;
        }
        s.close();
        return blocksPEngy;
    }

    public String[] getBusNames() {
        if (this.busVector == null) {
            int ix;
            this.busVector = new Vector(30);
            for (ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp TempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(TempComponent instanceof Busbar) || !TempComponent.getinservice()) continue;
                this.busVector.addElement(TempComponent);
            }
            this.busNames = new String[this.busVector.size()];
            for (ix = 0; ix < this.busVector.size(); ++ix) {
                this.busNames[ix] = ((Busbar)this.busVector.elementAt(ix)).getName();
            }
        }
        return this.busNames;
    }

    public Vector getBusVector() {
        if (this.busVector != null) {
            return this.busVector;
        }
        this.getBusNames();
        return this.busVector;
    }

    public Vector getGenerators() {
        if (this.generatorVector == null) {
            this.generatorVector = new Vector(40);
            for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp TempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(TempComponent instanceof Generator) || !TempComponent.getinservice()) continue;
                this.generatorVector.addElement(TempComponent);
            }
        }
        return this.generatorVector;
    }

    public Vector getReservoirs() {
        if (this.reservoirVector == null) {
            this.reservoirVector = new Vector(10);
            for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp TempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(TempComponent instanceof hdb_res) || !TempComponent.getinservice()) continue;
                this.reservoirVector.addElement(TempComponent);
            }
        }
        return this.reservoirVector;
    }

    public double[] getStagBlockPEn() throws Exception {
        if (this.stageDef == null) {
            this.getStageDef();
        }
        int[] daysOnWeeks = this.getWeeksDur();
        int numBlocks = this.getParam_Sim("Num_Bloques_CC");
        double[] actBlockPEngy = new double[numBlocks];
        double[][] BlocksPEngy = this.getBlocksPEngy();
        double[] WeeksPEngy = this.getWeeksPEngy();
        double[] stagBlockEn = new double[numBlocks * this.stageDef.size()];
        int actMonth = this.getParam_Sim("Mes_Inicio") - 1;
        int actWeek = this.getParam_Sim("Semana_Inicio") - 1;
        actWeek += actMonth * 4;
        --actWeek;
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            int i;
            int j;
            int dur = (Integer)this.stageDef.elementAt(stage);
            for (j = 0; j < numBlocks; ++j) {
                actBlockPEngy[j] = 0.0;
            }
            int stageDays = 0;
            double stagePEngy = 0.0;
            for (i = 0; i < dur; ++i) {
                actWeek = actWeek == 47 ? 0 : ++actWeek;
                stageDays += daysOnWeeks[actWeek];
                stagePEngy += WeeksPEngy[actWeek];
                for (j = 0; j < numBlocks; ++j) {
                    int n = j;
                    actBlockPEngy[n] = actBlockPEngy[n] + (double)daysOnWeeks[actWeek] * BlocksPEngy[actWeek][j];
                }
            }
            i = stage * numBlocks;
            for (j = 0; j < numBlocks; ++j) {
                stagBlockEn[i + j] = actBlockPEngy[j] / (double)stageDays * stagePEngy / 100.0;
            }
        }
        return stagBlockEn;
    }

    public double[] getBusPLoad(int iniY, int endY, int bindex) throws Exception {
        int ibus = 0;
        Statement s = this.dBConn.createStatement();
        if (endY < iniY) {
            throw new PLPException("a\u00f1o final inferior al inicial en parametros, PLPDB.");
        }
        if (this.busPLoad == null) {
            if (this.busVector == null) {
                this.getBusNames();
            }
            this.busPLoad = new double[this.busNames.length][endY - iniY + 1];
            for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp tempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(tempComponent instanceof Load) || !tempComponent.getinservice()) continue;
                Load tempLoad = (Load)tempComponent;
                tempLoad.InformAllComponents();
                ibus = this.numbus(tempLoad.getcon2());
                if (ibus < 0) {
                    throw new PLPException("load '" + tempLoad.getName() + "' no conectada.");
                }
                ResultSet r = s.executeQuery("SELECT * FROM Dem_FDCA_Cargas WHERE (Carga='" + tempLoad.getName() + "') AND (Ano>=" + iniY + ") AND (Ano<=" + endY + ") ORDER BY Ano");
                int regcount = -1;
                int year = iniY - 1;
                while (r.next()) {
                    ++regcount;
                    int sy = r.getInt("Ano");
                    double value = r.getDouble("FDDC");
                    if (sy != ++year) {
                        throw new PLPException("no se encuentra FCDC carga'" + tempLoad.getName() + "' a\u00f1o: " + year + ", PLPDB.");
                    }
                    double[] dArray = this.busPLoad[ibus];
                    int n = regcount;
                    dArray[n] = dArray[n] + value;
                }
                r.close();
                if (regcount < 0) {
                    throw new PLPException("no se encuentran FCDC para la carga'" + tempLoad.getName() + ", PLPDB.");
                }
                if (year == endY) continue;
                throw new PLPException("no se encuentra FCDC carga'" + tempLoad.getName() + "' a\u00f1o: " + year + ", PLPDB.");
            }
        }
        s.close();
        return this.busPLoad[bindex];
    }

    public double[] getBusFaultCost() throws Exception {
        int ibus;
        int numsysloads = 0;
        double sysPromFailCost = 0.0;
        if (this.busVector == null) {
            this.getBusNames();
        }
        double[] failcost = new double[this.busNames.length];
        int[] numloads = new int[this.busNames.length];
        for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
            comp tempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(tempComponent instanceof Load) || !tempComponent.getinservice()) continue;
            Load tempLoad = (Load)tempComponent;
            tempLoad.InformAllComponents();
            ibus = this.numbus(tempLoad.getcon2());
            if (ibus < 0) {
                throw new PLPException("load '" + tempLoad.getName() + "' no conectada.");
            }
            int n = ibus;
            numloads[n] = numloads[n] + 1;
            int n2 = ibus;
            failcost[n2] = failcost[n2] + tempLoad.getbeta();
            sysPromFailCost += tempLoad.getbeta();
            ++numsysloads;
        }
        if (numsysloads > 0) {
            sysPromFailCost /= (double)numsysloads;
        }
        for (ibus = 0; ibus < this.busNames.length; ++ibus) {
            if (numloads[ibus] > 0) {
                int n = ibus;
                failcost[n] = failcost[n] / (double)numloads[ibus];
                continue;
            }
            failcost[ibus] = sysPromFailCost;
        }
        return failcost;
    }

    public Vector getBloStagNumH() throws Exception {
        int iniYear;
        if (this.bloStagDefVec != null) {
            return this.bloStagDefVec;
        }
        if (this.stageDef == null) {
            this.getStageDef();
        }
        int[] daysOnWeeks = this.getWeeksDur();
        int numBlocks = this.getParam_Sim("Num_Bloques_CC");
        int[] actBlocksNH = new int[numBlocks];
        double[][] BlocksPDur = this.getBlocksPDur();
        this.bloStagNumH = new int[numBlocks * this.stageDef.size()];
        this.bloStagMonth = new int[numBlocks * this.stageDef.size()];
        this.bloStagYear = new int[numBlocks * this.stageDef.size()];
        int[] auxhydMonth = this.getStageIndHydMonth();
        int cyear = 1;
        int actYear = iniYear = this.getParam_Sim("A\u00f1o_Inicio");
        int actMonth = this.getParam_Sim("Mes_Inicio") - 1;
        int actWeek = this.getParam_Sim("Semana_Inicio") - 1;
        actWeek += actMonth * 4;
        --actWeek;
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            int i;
            int j;
            int dur = (Integer)this.stageDef.elementAt(stage);
            for (j = 0; j < numBlocks; ++j) {
                actBlocksNH[j] = 0;
            }
            int stageHours = 0;
            for (i = 0; i < dur; ++i) {
                if (actWeek == 47) {
                    actWeek = 0;
                    ++cyear;
                } else {
                    ++actWeek;
                }
                stageHours += daysOnWeeks[actWeek] * 24;
                for (j = 0; j < numBlocks; ++j) {
                    int n = j;
                    actBlocksNH[n] = (int)((long)actBlocksNH[n] + Math.round((double)daysOnWeeks[actWeek] * BlocksPDur[actWeek][j] * 0.24));
                }
            }
            for (j = 0; j < numBlocks; ++j) {
                stageHours -= actBlocksNH[j];
            }
            int n = numBlocks - 1;
            actBlocksNH[n] = actBlocksNH[n] + stageHours;
            i = stage * numBlocks;
            for (j = 0; j < numBlocks; ++j) {
                this.bloStagYear[i + j] = cyear;
                this.bloStagNumH[i + j] = actBlocksNH[j];
                this.bloStagMonth[i + j] = auxhydMonth[stage];
            }
        }
        this.bloStagDefVec = new Vector(3);
        this.bloStagDefVec.addElement(this.bloStagYear);
        this.bloStagDefVec.addElement(this.bloStagMonth);
        this.bloStagDefVec.addElement(this.bloStagNumH);
        return this.bloStagDefVec;
    }

    public double[] getAnnEngy(int iniY, int endY) throws Exception {
        int regcount = -1;
        if (endY < iniY) {
            throw new PLPException("a\u00f1o final inferior al inicial en parametros, PLPDB.");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Demanda_Anual WHERE (Ano >= " + iniY + ") AND (Ano<=" + endY + ") ORDER BY Ano");
        int year = iniY - 1;
        double[] annEngy = new double[endY - iniY + 1];
        while (r.next()) {
            ++regcount;
            int sy = r.getInt("Ano");
            double value = r.getDouble("Energia");
            if (++year != sy) {
                throw new PLPException("no se encuentra demanada de energia a\u00f1o " + year + ", PLPDB.");
            }
            annEngy[regcount] = value;
        }
        s.close();
        if (regcount < 0) {
            throw new PLPException("no se encontr\u00f3 informaci\u00f3n de demanada anual de energ\u00eda, PLPDB.");
        }
        if (year != endY) {
            throw new PLPException("no se encuentra demanada de energia a\u00f1o " + year + ", PLPDB.");
        }
        return annEngy;
    }

    public int numbus(String Busbarname) {
        if (this.busVector == null) {
            this.getBusNames();
        }
        for (int ix = 0; ix < this.busNames.length; ++ix) {
            if (!this.busNames[ix].equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    public Vector getBranches() throws Exception {
        if (this.branchesVector != null) {
            return this.branchesVector;
        }
        this.branchesVector = new Vector(30);
        this.getBusNames();
        boolean[][] cxMat = new boolean[this.busNames.length][this.busNames.length];
        for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
            ndb_branch tempbranch;
            comp tempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(tempComponent instanceof ndb_branch) || !(tempbranch = (ndb_branch)tempComponent).getinservice()) continue;
            if (tempbranch instanceof Line || tempbranch instanceof Trafo) {
                if (tempbranch instanceof Line) {
                    Line TempLine = (Line)tempbranch;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                } else {
                    tempbranch.InformAllComponents();
                }
                int busi = this.numbus(tempbranch.getcon1());
                int busj = this.numbus(tempbranch.getcon2());
                if (busi < 0 || busj < 0) {
                    new PLPException("rama '" + tempbranch.getName() + "' mal conectada.");
                }
                if (cxMat[busi][busj] || cxMat[busj][busi]) {
                    new PLPException("herramienta PLP no acepta ramas en paralelo, reduzca '" + tempbranch.getName() + "'");
                } else {
                    cxMat[busj][busi] = true;
                    cxMat[busi][busj] = true;
                }
                this.branchesVector.addElement(tempbranch);
                continue;
            }
            throw new PLPException("herramienta PLP no permite este objeto:'" + tempComponent.getName() + "'");
        }
        return this.branchesVector;
    }

    public double[] getCxParam(String bname) throws Exception {
        int regcount = 0;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Conexiones WHERE (Conexion = '" + bname + "')");
        double[] cxParam = new double[4];
        while (r.next()) {
            double value;
            ++regcount;
            cxParam[0] = value = r.getDouble("Flujo_Max_IJ");
            cxParam[1] = value = r.getDouble("Flujo_Max_JI");
            cxParam[2] = value = r.getDouble("Mod_Perdidas");
            cxParam[3] = value = r.getDouble("Num_Tramos");
        }
        s.close();
        if (regcount == 0) {
            throw new PLPException("sin datos para la rama '" + bname + "' en tabla 'Conexiones', PLPDB.");
        }
        if (regcount > 1) {
            throw new PLPException("tabla 'Conexiones' con exceso de registros para rama '" + bname + "', PLPDB.");
        }
        return cxParam;
    }

    public double[] getGenParam(String gname) throws Exception {
        double[] genParam = new double[2];
        if (this.generatorVector != null) {
            for (int ix = 0; ix < this.generatorVector.size(); ++ix) {
                Generator tempGen = (Generator)this.generatorVector.elementAt(ix);
                if (!gname.equals(tempGen.getName())) continue;
                genParam[0] = tempGen.getpmin();
                genParam[1] = tempGen.getpmax();
                break;
            }
        }
        return genParam;
    }

    public double[] getResParam(String rname) throws Exception {
        int regcount = 0;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Embalses WHERE (Embalse = '" + rname + "')");
        double[] resParam = new double[7];
        while (r.next()) {
            double value;
            ++regcount;
            resParam[0] = value = r.getDouble("Cota_Min");
            resParam[1] = value = r.getDouble("Cota_Max");
            resParam[2] = value = r.getDouble("Uso_CMg_Final");
            resParam[3] = 1.0;
            resParam[4] = value = r.getDouble("Cota_Inicial");
            resParam[5] = value = r.getDouble("Cota_Final");
            resParam[6] = value = r.getDouble("Filt_Med");
        }
        s.close();
        if (regcount == 0) {
            throw new PLPException("sin datos para el embalse4 '" + rname + "' en tabla 'Embalses', PLPDB.");
        }
        if (regcount > 1) {
            throw new PLPException("tabla 'Embalses' con exceso de registros para embalse '" + rname + "', PLPDB.");
        }
        return resParam;
    }

    public int getNumStages() throws Exception {
        Vector stV = this.getStageDef();
        return stV.size();
    }

    public Vector getMantObjN(String[] mantSt) throws Exception {
        comp tempcomp = null;
        Vector objVector = mantSt == mantCxSt ? this.getBranches() : (mantSt == mantGenSt ? this.getGenerators() : this.getReservoirs());
        Vector<String> mantObjVector = new Vector<String>(objVector.size());
        Date[][] stDinDen = this.getStageDiniDend();
        Date iniHoriz = this.getIniHorizDate();
        Date finHoriz = this.getEndHorizDate();
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT " + mantSt[0] + " FROM " + mantSt[1] + " WHERE (Fecha_Ini<={ts '" + finHoriz + " 00:00:00'})" + " AND (Fecha_Fin>={ts '" + iniHoriz + " 00:00:00'}) ORDER BY " + mantSt[0]);
        String objName = "";
        while (r.next()) {
            String tmpObjName = r.getString(mantSt[0]);
            if (tmpObjName.equals(objName)) continue;
            boolean isInSch = false;
            for (int ix = 0; ix < objVector.size(); ++ix) {
                tempcomp = (comp)objVector.elementAt(ix);
                if (!tmpObjName.equals(tempcomp.getName()) || !tempcomp.getinservice()) continue;
                isInSch = true;
                break;
            }
            if (!isInSch) continue;
            objName = tempcomp.getName();
            mantObjVector.addElement(objName);
        }
        s.close();
        return mantObjVector;
    }

    public double[][] getMantRedefObj(String objName, String[] mantSt) throws Exception {
        Date[][] stDiDend = this.getStageDiniDend();
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM " + mantSt[1] + " WHERE (" + mantSt[0] + "='" + objName + "')" + " AND (Fecha_Ini<={ts '" + stDiDend[stDiDend.length - 1][1] + " 00:00:00'})" + " AND (Fecha_Fin>={ts '" + stDiDend[0][0] + " 00:00:00'}) ORDER BY Fecha_Ini");
        double[] objPar = mantSt == mantCxSt ? this.getCxParam(objName) : (mantSt == mantGenSt ? this.getGenParam(objName) : this.getResParam(objName));
        double[][] redefObjPar = new double[this.stageDiniDend.length][0];
        while (r.next()) {
            double val1 = r.getDouble(mantSt[2]);
            double val2 = r.getDouble(mantSt[3]);
            Date iniMant = r.getDate("Fecha_Ini");
            Date finMant = r.getDate("Fecha_Fin");
            for (int st = 0; st < stDiDend.length; ++st) {
                int comondays = PLPUtils.daysLap1inLap2(iniMant, finMant, stDiDend[st][0], stDiDend[st][1]);
                if (comondays <= 0) continue;
                double propor = comondays;
                propor /= (double)PLPUtils.daysinLap(stDiDend[st][0], stDiDend[st][1]);
                if (redefObjPar[st].length == 0) {
                    redefObjPar[st] = new double[2];
                    redefObjPar[st][0] = objPar[0];
                    redefObjPar[st][1] = objPar[1];
                }
                redefObjPar[st][0] = (1.0 - propor) * redefObjPar[st][0] + propor * val1;
                redefObjPar[st][1] = (1.0 - propor) * redefObjPar[st][1] + propor * val2;
            }
        }
        s.close();
        return redefObjPar;
    }

    public Date[][] getStageDiniDend() throws Exception {
        if (this.stageDiniDend != null) {
            return this.stageDiniDend;
        }
        Vector stageDef = this.getStageDef();
        int[] weeksDur = this.getWeeksDur();
        Date finHoriz = this.getEndHorizDate();
        Date iniHoriz = this.getIniHorizDate();
        int year = this.getParam_Sim("A\u00f1o_Inicio") - 1900;
        int month = this.getParam_Sim("Mes_Inicio");
        int week = this.getParam_Sim("Semana_Inicio");
        this.stageDiniDend = new Date[stageDef.size()][2];
        int actWeek = (month - 1) * 4 + week - 1;
        this.stageDiniDend[0][0] = iniHoriz;
        for (int st = 0; st < stageDef.size(); ++st) {
            if ((actWeek += ((Integer)stageDef.elementAt(st)).intValue()) > 47) {
                ++year;
                actWeek -= 48;
            }
            month = actWeek / 4;
            week = actWeek - month * 4;
            int day = 1;
            for (int i = 0; i < week; ++i) {
                day += weeksDur[month * 4 + i];
            }
            Date aux = new Date(year, month, day);
            if (st < stageDef.size() - 1) {
                this.stageDiniDend[st + 1][0] = aux;
            }
            this.stageDiniDend[st][1] = new Date(aux.getTime() - 86400000L);
        }
        return this.stageDiniDend;
    }

    public static int daysLap1inLap2(Date iniLap1, Date endLap1, Date iniLap2, Date endLap2) {
        if (endLap1.before(iniLap2) || iniLap1.after(endLap2)) {
            return 0;
        }
        if (endLap1.equals(iniLap2) || iniLap1.equals(endLap2)) {
            return 1;
        }
        Date ini = iniLap1.after(iniLap2) || iniLap1.equals(iniLap2) ? iniLap1 : iniLap2;
        Date end = endLap1.before(endLap2) || endLap1.equals(endLap2) ? endLap1 : endLap2;
        int durdays = (int)((double)(end.getTime() - ini.getTime()) / 3600.0 / 1000.0 / 24.0);
        if (durdays < 0) {
            return 0;
        }
        return durdays + 1;
    }

    public static int daysinLap(Date iniLap, Date endLap) {
        int ndays = (int)((double)(endLap.getTime() - iniLap.getTime()) / 3600.0 / 1000.0 / 24.0);
        return ndays + 1;
    }

    public Date getIniHorizDate() throws Exception {
        if (this.iniHorizDate == null) {
            int[] weeksDur = this.getWeeksDur();
            int month = this.getParam_Sim("Mes_Inicio");
            int week = this.getParam_Sim("Semana_Inicio");
            int day = 1;
            for (int i = 0; i < week - 1; ++i) {
                day += weeksDur[(month - 1) * 4 + i];
            }
            this.iniHorizDate = new Date(this.getParam_Sim("A\u00f1o_Inicio") - 1900, month - 1, day);
        }
        return this.iniHorizDate;
    }

    public Date getEndHorizDate() throws Exception {
        if (this.endHorizDate == null) {
            int[] weeksDur = this.getWeeksDur();
            int month = this.getParam_Sim("Mes_Fin");
            int week = this.getParam_Sim("Semana_Fin");
            int day = 0;
            for (int i = 0; i < week; ++i) {
                day += weeksDur[(month - 1) * 4 + i];
            }
            this.endHorizDate = new Date(this.getParam_Sim("A\u00f1o_Fin") - 1900, month - 1, day);
        }
        return this.endHorizDate;
    }

    public int[] getStageIndHydMonth() throws Exception {
        if (this.stageIndHMonth != null) {
            return this.stageIndHMonth;
        }
        int actMonth = this.getParam_Sim("Mes_Inicio");
        int iniStWeek = this.getParam_Sim("Semana_Inicio");
        iniStWeek += (actMonth - 1) * 4 - 1;
        this.getStageDef();
        this.stageIndHMonth = new int[this.stageDef.size()];
        if ((iniStWeek -= 12) < 0) {
            iniStWeek += 48;
        }
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            this.stageIndHMonth[stage] = iniStWeek / 4 + 1;
            if ((iniStWeek += ((Integer)this.stageDef.elementAt(stage)).intValue()) <= 47) continue;
            iniStWeek -= 48;
        }
        return this.stageIndHMonth;
    }

    public int[][] getStageIndHydYear() throws Exception {
        int daysinThaw;
        int actYear;
        if (this.stageIndHYear != null) {
            return this.stageIndHYear;
        }
        Date[][] stageDates = this.getStageDiniDend();
        this.stageIndHYear = new int[stageDates.length][2];
        int iniYear = actYear = this.getParam_Sim("A\u00f1o_Inicio");
        if (stageDates[0][0].getMonth() < 3) {
            iniYear = actYear = iniYear - 1;
        }
        Date auxBegHydYear = new Date(actYear - 1900, 3, 1);
        Date auxEndHydYear = new Date(actYear + 1 - 1900, 2, 31);
        Date auxBegThaw = new Date(actYear - 1900, this.getParam_Sim("Mes_Deshielo") - 1, 1);
        int durdays = PLPUtils.daysinLap(stageDates[0][0], stageDates[0][1]);
        int daysinHY = PLPUtils.daysLap1inLap2(stageDates[0][0], stageDates[0][1], auxBegHydYear, auxEndHydYear);
        this.stageIndHYear[0][0] = 0;
        if (daysinHY < durdays) {
            auxBegHydYear = new Date(++actYear - 1900, 3, 1);
            auxEndHydYear = new Date(actYear + 1 - 1900, 2, 31);
        }
        if ((daysinThaw = PLPUtils.daysLap1inLap2(stageDates[0][0], stageDates[0][1], auxBegThaw, auxEndHydYear)) == durdays) {
            this.stageIndHYear[0][1] = -1;
        }
        for (int stage = 1; stage < stageDates.length; ++stage) {
            durdays = PLPUtils.daysinLap(stageDates[stage][0], stageDates[stage][1]);
            daysinHY = PLPUtils.daysLap1inLap2(stageDates[stage][0], stageDates[stage][1], auxBegHydYear, auxEndHydYear);
            daysinThaw = PLPUtils.daysLap1inLap2(stageDates[stage][0], stageDates[stage][1], auxBegThaw, auxEndHydYear);
            if (daysinHY < durdays) {
                this.stageIndHYear[stage][0] = (double)daysinHY <= 0.5 * (double)durdays ? actYear - iniYear : ++actYear - iniYear - 1;
                auxBegHydYear = new Date(actYear - 1900, 3, 1);
                auxEndHydYear = new Date(actYear + 1 - 1900, 2, 31);
                auxBegThaw = new Date(actYear - 1900, this.getParam_Sim("Mes_Deshielo") - 1, 1);
            } else {
                this.stageIndHYear[stage][0] = actYear - iniYear;
            }
            this.stageIndHYear[stage][1] = daysinThaw == durdays ? -1 : 1;
        }
        return this.stageIndHYear;
    }

    public int[][] getRandSimYear() throws Exception {
        if (this.randSimHydYear != null) {
            return this.randSimHydYear;
        }
        int numSim = this.getParam_Sim("Num_Simulaciones");
        int numHStat = this.getParam_Sim("Num_Hidrologias");
        int[][] auxIndHYear = this.getStageIndHydYear();
        int numHYinHoriz = 1;
        for (int st = 1; st < auxIndHYear.length; ++st) {
            if (auxIndHYear[st][0] == auxIndHYear[st - 1][0]) continue;
            ++numHYinHoriz;
        }
        this.randSimHydYear = new int[numHYinHoriz][numSim];
        int aleat = this.getParam_Sim("Tipo_Simulacion");
        if (aleat == 0) {
            for (int i = 0; i < numHYinHoriz; ++i) {
                for (int j = 0; j < numSim; ++j) {
                    this.randSimHydYear[i][j] = this.getRandInt(numHStat);
                }
            }
        } else {
            int i;
            int j;
            if (aleat == 1) {
                for (j = 0; j < numSim; ++j) {
                    this.randSimHydYear[0][j] = this.getRandInt(numHStat);
                }
            } else {
                i = 1;
                for (j = 0; j < numSim; ++j) {
                    this.randSimHydYear[0][j] = i++;
                    if (i <= numHStat) continue;
                    i = 1;
                }
            }
            for (i = 1; i < numHYinHoriz; ++i) {
                for (j = 0; j < numSim; ++j) {
                    this.randSimHydYear[i][j] = this.randSimHydYear[i - 1][j] + 1;
                    if (this.randSimHydYear[i][j] <= numHStat) continue;
                    this.randSimHydYear[i][j] = 1;
                }
            }
        }
        return this.randSimHydYear;
    }

    public int getRandInt(int nmax) {
        if (this.myRandNumGen == null) {
            this.myRandNumGen = new Random(15000L);
        }
        return (int)((double)(this.myRandNumGen.nextFloat() * (float)nmax) - 1.0E-6) + 1;
    }

    public int[] getAperArray(int numHStat, int numApe) {
        int[] apeArray = new int[numApe];
        for (int i = 0; i < numApe; ++i) {
            apeArray[i] = this.getRandInt(numHStat);
        }
        return apeArray;
    }

    public void loadFuncCotaVol() throws Exception {
        if (this.funcCotaVol != null) {
            return;
        }
        Vector resVec = null;
        resVec = this.reservoirVector == null ? this.getReservoirs() : this.reservoirVector;
        this.funcCotaVol = new CvaLinPartes[resVec.size()];
        Statement s = this.dBConn.createStatement();
        for (int i = 0; i < resVec.size(); ++i) {
            Vector<Double> vecCotas = new Vector<Double>(200);
            Vector<Double> vecVol = new Vector<Double>(200);
            hdb_res tempRes = (hdb_res)resVec.elementAt(i);
            ResultSet r = s.executeQuery("SELECT * FROM Emb_Fnc_Cota_Volumen WHERE (Embalse='" + tempRes.getName() + "') ORDER BY Intervalo");
            int regcount = 0;
            double prevVol = -10.0;
            double prevCota = -10.0;
            while (r.next()) {
                ++regcount;
                double cota = r.getDouble("Cota");
                double volumen = r.getDouble("Volumen");
                int intervalo = r.getInt("Intervalo");
                if (cota <= prevCota || volumen <= prevVol) {
                    throw new PLPException("relacion cota-volumen no creciente, intervalo '" + intervalo + "' embalse '" + tempRes.getName() + "', PLPDB.");
                }
                if (intervalo != regcount) {
                    throw new PLPException("intervalo cota-volumen '" + intervalo + "' no encontrado, embalse '" + tempRes.getName() + "', PLPDB.");
                }
                vecCotas.addElement(new Double(cota));
                vecVol.addElement(new Double(volumen));
                prevCota = cota;
                prevVol = volumen;
            }
            if (regcount == 0) {
                throw new PLPException("no se encuentra relacion cota-volumen embalse '" + tempRes.getName() + "', PLPDB.");
            }
            r.close();
            this.funcCotaVol[i] = new CvaLinPartes(vecCotas, vecVol);
        }
        s.close();
    }

    public double evalCota2Vol(double cota, int resOrdNum) throws PLPException {
        if (this.reservoirVector == null) {
            throw new PLPException("numero de embalse incorrecto, evalCota2Vol.");
        }
        if (this.funcCotaVol == null) {
            throw new PLPException("funciones de relacion cota-volumen no cargadas.");
        }
        return this.funcCotaVol[resOrdNum].evalIn(cota);
    }

    public double evalVol2Cota(double vol, int resOrdNum) throws PLPException {
        if (this.reservoirVector == null) {
            throw new PLPException("numero de embalse incorrecto, evalCota2Vol.");
        }
        if (this.funcCotaVol == null) {
            throw new PLPException("funciones de relacion cota-volumen no cargadas.");
        }
        return this.funcCotaVol[resOrdNum].evalInverseIn(vol);
    }

    public double evalCota2Vol(double cota, String resName) throws PLPException {
        int resOrd = this.getResOrd(resName);
        if (resOrd < 0) {
            throw new PLPException("embalse '" + resName + "', no encontrado en sistema.");
        }
        return this.evalCota2Vol(cota, resOrd);
    }

    public double evalVol2Cota(double vol, String resName) throws PLPException {
        int resOrd = this.getResOrd(resName);
        if (resOrd < 0) {
            throw new PLPException("embalse '" + resName + "', no encontrado en sistema.");
        }
        return this.evalVol2Cota(vol, resOrd);
    }

    public int getResOrd(String resName) throws PLPException {
        if (this.reservoirVector == null) {
            throw new PLPException("vector de embalses no cargado");
        }
        int resOrd = -1;
        for (int i = 0; i < this.reservoirVector.size(); ++i) {
            hdb_res tempRes = (hdb_res)this.reservoirVector.elementAt(i);
            if (!resName.equals(tempRes.getName())) continue;
            resOrd = i;
            break;
        }
        return resOrd;
    }

    public double[][] getRendTangents(int resOrdNum) throws Exception {
        if (this.reservoirVector == null) {
            return null;
        }
        double[][] tangArray = null;
        hdb_res tempRes = (hdb_res)this.reservoirVector.elementAt(resOrdNum);
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Emb_Tang_Func_Rendimiento WHERE (Embalse='" + tempRes.getName() + "') ORDER BY Tramo");
        int regcount = 0;
        Vector<double[]> tangVec = new Vector<double[]>(10);
        while (r.next()) {
            ++regcount;
            int tramo = r.getInt("Tramo");
            double volumen = r.getDouble("Volumen");
            double pend = r.getDouble("Pendiente");
            double constante = r.getDouble("Constante");
            double fesc = r.getDouble("FEscala");
            if (tramo != regcount) {
                throw new PLPException("tramo tang-rendimiento '" + tramo + "' no encontrado, embalse '" + tempRes.getName() + "', PLPDB.");
            }
            double[] auxArr = new double[]{volumen, pend, constante, fesc};
            tangVec.addElement(auxArr);
        }
        s.close();
        tangArray = new double[tangVec.size()][0];
        for (regcount = 0; regcount < tangVec.size(); ++regcount) {
            tangArray[regcount] = (double[])tangVec.elementAt(regcount);
        }
        return tangArray;
    }

    public double[][] getFilterTangents(int resOrdNum) throws Exception {
        if (this.reservoirVector == null) {
            this.getReservoirs();
        }
        double[][] tangArray = null;
        hdb_res tempRes = (hdb_res)this.reservoirVector.elementAt(resOrdNum);
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Emb_Tang_Func_Filtraciones WHERE (Embalse='" + tempRes.getName() + "') ORDER BY Tramo");
        int regcount = 0;
        Vector<double[]> tangVec = new Vector<double[]>(10);
        while (r.next()) {
            ++regcount;
            int tramo = r.getInt("Tramo");
            double volumen = r.getDouble("Volumen");
            double pend = r.getDouble("Pendiente");
            double constante = r.getDouble("Constante");
            double fesc = r.getDouble("FEscala");
            if (tramo != regcount) {
                throw new PLPException("tramo tang-filtracion '" + tramo + "' no encontrado, embalse '" + tempRes.getName() + "', PLPDB.");
            }
            double[] auxArr = new double[]{volumen, pend, constante, fesc};
            tangVec.addElement(auxArr);
        }
        s.close();
        tangArray = new double[tangVec.size()][0];
        for (regcount = 0; regcount < tangVec.size(); ++regcount) {
            tangArray[regcount] = (double[])tangVec.elementAt(regcount);
        }
        return tangArray;
    }

    public double[][] getPlanEmb(String resName) throws Exception {
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Emb_CMg_Finales WHERE (Embalse='" + resName + "') ORDER BY Intervalo");
        int regcount = 0;
        Vector<double[]> interVec = new Vector<double[]>(10);
        while (r.next()) {
            int intervalo = r.getInt("Intervalo");
            double cota = r.getDouble("Cota");
            double cmg = r.getDouble("CMg");
            if (intervalo != ++regcount) {
                throw new PLPException("intervalo Emb_CMg_Finales '" + intervalo + "' no encontrado, embalse '" + resName + "', PLPDB.");
            }
            double[] auxArr = new double[]{cota, cmg};
            interVec.addElement(auxArr);
        }
        s.close();
        double[][] planemb = new double[interVec.size()][2];
        for (regcount = 0; regcount < interVec.size(); ++regcount) {
            planemb[regcount] = (double[])interVec.elementAt(regcount);
        }
        return planemb;
    }

    public void loadHydroConnect() throws Exception {
        int sx;
        Object tempcomp;
        int ix;
        if (this.hydUnitsVec != null) {
            return;
        }
        Object tempGen = null;
        hdb_comp temphdb = null;
        Object tempirr = null;
        Object tempInj = null;
        hdb_res tempRes = null;
        hdb_ser tempFilt = null;
        hdb_unit temphunit = null;
        int NS = 0;
        int NE = 0;
        int NP = 0;
        int NI = 0;
        int NF = 0;
        this.initTermHydroCx();
        Vector GenVec = this.getGenerators();
        Vector ElTeGen = (Vector)GenVec.clone();
        Vector ElHyGen = new Vector(20);
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_unit) || !(temphunit = (hdb_unit)tempcomp).getinservice()) continue;
            if (temphunit instanceof hdb_paspur) {
                if (!this.checkAndClasifElGen(ElTeGen, ElHyGen, temphunit, "HydroS")) {
                    throw new PLPException("unidad hidro '" + temphunit.getName() + "' generador el\u00e9ctrico asociado no encontrado");
                }
                ++NP;
                continue;
            }
            if (temphunit instanceof hdb_res) {
                if (!temphunit.getgrounded() && !this.checkAndClasifElGen(ElTeGen, ElHyGen, temphunit, "HydroR")) {
                    throw new PLPException("unidad hidro '" + temphunit.getName() + "' generador el\u00e9ctrico asociado no encontrado");
                }
                tempRes = (hdb_res)temphunit;
                if (tempRes.getFiltType() > 0) {
                    ++NF;
                }
                ++NE;
                continue;
            }
            if (temphunit instanceof hdb_ser) {
                if (!temphunit.getgrounded() && !this.checkAndClasifElGen(ElTeGen, ElHyGen, temphunit, "HydroS")) {
                    throw new PLPException("unidad hidro '" + temphunit.getName() + "' generador el\u00e9ctrico asociado no encontrado");
                }
                ++NS;
                continue;
            }
            if (!(temphunit instanceof hdb_irr)) continue;
            ++NI;
        }
        this.thermalGen = new Generator[ElTeGen.size()];
        ElTeGen.copyInto(this.thermalGen);
        this.resEleGen = new Generator[NE];
        this.resHydGen = new hdb_res[NE];
        this.serEleGen = new Generator[NS];
        this.serHydGen = new hdb_ser[NS];
        this.ppEleGen = new Generator[NP];
        this.ppHydGen = new hdb_paspur[NP];
        this.irrigs = new hdb_irr[NI];
        this.filHydGen = new hdb_ser[NF];
        int indNF = 0;
        int indNP = 0;
        int indNE = 0;
        int indNS = 0;
        int indNI = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_comp)) continue;
            temphdb = (hdb_comp)tempcomp;
            if (!temphunit.getinservice()) continue;
            if (temphdb instanceof hdb_paspur) {
                this.ppHydGen[indNP] = (hdb_paspur)temphdb;
                ++indNP;
                continue;
            }
            if (temphdb instanceof hdb_res) {
                this.resHydGen[indNE] = tempRes = (hdb_res)temphdb;
                ++indNE;
                if (tempRes.getFiltType() <= 0) continue;
                this.filHydGen[indNF] = tempFilt = new hdb_ser("Filt_" + tempRes.getName(), tempRes);
                ++indNF;
                continue;
            }
            if (temphdb instanceof hdb_ser) {
                this.serHydGen[indNS] = (hdb_ser)temphdb;
                ++indNS;
                continue;
            }
            if (!(temphdb instanceof hdb_irr)) continue;
            this.irrigs[indNI] = (hdb_irr)temphdb;
            ++indNI;
        }
        for (ix = 0; ix < NE; ++ix) {
            if (this.resHydGen[ix].getgrounded()) continue;
            sx = this.searchCompName(this.resHydGen[ix].getName(), ElHyGen);
            if (sx < 0) {
                throw new PLPException("Generador El\u00e9ctrico asociado no encontrado '" + this.resHydGen[ix].getName() + "'.");
            }
            tempcomp = ElHyGen.elementAt(sx);
            this.resEleGen[ix] = (Generator)tempcomp;
        }
        for (ix = 0; ix < NS; ++ix) {
            if (this.serHydGen[ix].getgrounded()) continue;
            sx = this.searchCompName(this.serHydGen[ix].getName(), ElHyGen);
            if (sx < 0) {
                throw new PLPException("Generador El\u00e9ctrico asociado no encontrado '" + this.serHydGen[ix].getName() + "'.");
            }
            tempcomp = ElHyGen.elementAt(sx);
            this.serEleGen[ix] = (Generator)tempcomp;
        }
        for (ix = 0; ix < NP; ++ix) {
            sx = this.searchCompName(this.ppHydGen[ix].getName(), ElHyGen);
            if (sx < 0) {
                throw new PLPException("Generador El\u00e9ctrico asociado no encontrado '" + this.serHydGen[ix].getName() + "'.");
            }
            tempcomp = ElHyGen.elementAt(sx);
            this.ppEleGen[ix] = (Generator)tempcomp;
        }
        this.hydUnitsVec = new Vector(NE + NS + NP + NI);
        for (ix = 0; ix < NE; ++ix) {
            this.hydUnitsVec.addElement(this.resHydGen[ix]);
        }
        for (ix = 0; ix < NF; ++ix) {
            this.hydUnitsVec.addElement(this.filHydGen[ix]);
        }
        for (ix = 0; ix < NS; ++ix) {
            this.hydUnitsVec.addElement(this.serHydGen[ix]);
        }
        for (ix = 0; ix < NI; ++ix) {
            this.hydUnitsVec.addElement(this.irrigs[ix]);
        }
        for (ix = 0; ix < NP; ++ix) {
            this.hydUnitsVec.addElement(this.ppHydGen[ix]);
        }
    }

    public int searchCompName(String gname, Vector CompVec) {
        for (int i = 0; i < CompVec.size(); ++i) {
            if (!gname.equals(((comp)CompVec.elementAt(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    private boolean checkAndClasifElGen(Vector ElTeGen, Vector ElHyGen, hdb_unit temphunit, String GenType) {
        boolean found = false;
        for (int ix = 0; ix < ElTeGen.size(); ++ix) {
            Generator tempGen = (Generator)ElTeGen.elementAt(ix);
            if (!temphunit.getName().equals(tempGen.getName())) continue;
            found = true;
            tempGen.setinv_type(GenType);
            ElTeGen.removeElementAt(ix);
            ElHyGen.addElement(tempGen);
            break;
        }
        return found;
    }

    private void initTermHydroCx() throws Exception {
        int ix;
        Object tempcomp = null;
        hdb_link templink = null;
        hdb_unit tempHUnit = null;
        hdb_ser tempSer = null;
        hdb_res tempRes = null;
        hdb_irr tempIrr = null;
        Generator tempGen = null;
        boolean allok = false;
        PLPUtils pLPUtils = this;
        pLPUtils.applet.SimulateSetUp();
        allok = false;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_link) || (allok = (templink = (hdb_link)tempcomp).InformEndComponents())) continue;
            throw new PLPException("link conectado erroneamente: '" + templink.getName() + "'");
        }
        System.out.println("Links Initialized");
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (tempcomp instanceof hdb_unit) {
                tempHUnit = tempcomp;
                if (!tempHUnit.getinservice()) continue;
                tempHUnit.InformRiverUpComps();
                if (tempHUnit.riverUpComps.size() == 0) {
                    throw new PLPException("Unidad hidr\u00e1ulica aislada, " + tempHUnit.getName());
                }
                if (!(tempHUnit instanceof hdb_res ? !(tempRes = (hdb_res)tempHUnit).InformRecipients() : (tempHUnit instanceof hdb_ser ? !(tempSer = (hdb_ser)tempHUnit).InformRecipients() : tempHUnit instanceof hdb_irr && !(tempIrr = (hdb_irr)tempHUnit).InformRecipients()))) continue;
                throw new PLPException("Unidad hidr\u00e1ulica mal conectada, " + tempHUnit.getName());
            }
            if (!(tempcomp instanceof Generator) || !(tempGen = (Generator)tempcomp).getinservice()) continue;
            tempGen.InformAllComponents();
        }
        System.out.println("hdb_units Initialized");
    }

    public double getAffMed(hdb_unit myhydUnit) {
        double affmed = 0.0;
        Vector rivUpCmp = myhydUnit.riverUpComps;
        for (int ix = 0; ix < rivUpCmp.size(); ++ix) {
            Object tempObj = rivUpCmp.elementAt(ix);
            if (!(tempObj instanceof hdb_affl) || ((hdb_affl)tempObj).getIsStoch()) continue;
            affmed += ((hdb_affl)tempObj).getQ();
        }
        return affmed;
    }

    public boolean isHUnitWStochAff(hdb_unit tempHUnit) throws Exception {
        for (int ix = 0; ix < tempHUnit.riverUpComps.size(); ++ix) {
            hdb_affl tempAff;
            if (!(tempHUnit.riverUpComps.elementAt(ix) instanceof hdb_affl) || !(tempAff = (hdb_affl)tempHUnit.riverUpComps.elementAt(ix)).getIsStoch()) continue;
            return true;
        }
        return false;
    }

    public Vector getStochAffHydUnits() throws Exception {
        int ic;
        this.loadHydroConnect();
        this.initAuxMat();
        Vector<hdb_unit> stochAffHydUnitsVec = new Vector<hdb_unit>(20);
        for (ic = 0; ic < this.resHydGen.length; ++ic) {
            if (!this.isHUnitWStochAff(this.resHydGen[ic])) continue;
            stochAffHydUnitsVec.addElement(this.resHydGen[ic]);
        }
        for (ic = 0; ic < this.serHydGen.length; ++ic) {
            if (!this.isHUnitWStochAff(this.serHydGen[ic])) continue;
            stochAffHydUnitsVec.addElement(this.serHydGen[ic]);
        }
        for (ic = 0; ic < this.ppHydGen.length; ++ic) {
            if (!this.isHUnitWStochAff(this.ppHydGen[ic])) continue;
            stochAffHydUnitsVec.addElement(this.ppHydGen[ic]);
        }
        for (ic = 0; ic < this.irrigs.length; ++ic) {
            if (!this.isHUnitWStochAff(this.irrigs[ic])) continue;
            stochAffHydUnitsVec.addElement(this.irrigs[ic]);
        }
        return stochAffHydUnitsVec;
    }

    private void initAuxMat() throws Exception {
        int nhydros = this.getParam_Sim("Num_Hidrologias");
        int numbloqs = this.getParam_Sim("Num_Bloques_CC");
        this.auxWeekAffMat = new double[48][nhydros];
        this.auxWSAffsMat = new double[48][nhydros];
        this.auxAffMat = new double[this.getNumStages()][nhydros];
        this.auxppBMat = new double[numbloqs][nhydros];
    }

    private double[][] getAffStat(int iniY, int endY, String affName) throws Exception {
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Caudal_Afluentes WHERE (Afluente='" + affName + "') AND (Ano_Historico<=" + endY + ") AND (Ano_Historico>=" + iniY + ") ORDER BY Ano_Historico");
        int regcount = 0;
        int year = iniY;
        while (r.next()) {
            int sy = r.getInt("Ano_Historico");
            if (sy == year) {
                for (int ix = 0; ix < 12; ++ix) {
                    for (int jx = 0; jx < 4; ++jx) {
                        this.auxWeekAffMat[ix * 4 + jx][regcount] = r.getDouble(AffMonNames[ix] + (jx + 1));
                    }
                }
                ++year;
                ++regcount;
                continue;
            }
            if (sy <= year) continue;
        }
        s.close();
        if (year != endY + 1) {
            throw new PLPException("no se encuentra caudal afluente'" + affName + "' a\u00f1o: " + year + ", PLPDB.");
        }
        return this.auxWeekAffMat;
    }

    public double[][] getCentAffCaud(int iniY, int endY, hdb_unit hdbUnit) throws Exception {
        int wk;
        int ihyd;
        int st;
        double[][] caudStat = null;
        Vector stageDur = this.getStageDef();
        int[] wksdur = this.getWeeksDur();
        if (this.stageFrTo == null) {
            this.stageFrTo = new int[stageDur.size() + 1];
            for (st = 0; st < stageDur.size(); ++st) {
                this.stageFrTo[st + 1] = (Integer)stageDur.elementAt(st);
            }
            int iniHW = (this.getParam_Sim("Mes_Inicio") - 1) * 4 + this.getParam_Sim("Semana_Inicio") - 1;
            if ((iniHW -= 12) < 0) {
                iniHW += 48;
            }
            this.stageFrTo[0] = iniHW;
            for (st = 1; st < this.stageFrTo.length; ++st) {
                int n = st;
                this.stageFrTo[n] = this.stageFrTo[n] + this.stageFrTo[st - 1];
                if (this.stageFrTo[st] <= 47) continue;
                int n2 = st;
                this.stageFrTo[n2] = this.stageFrTo[n2] - 48;
            }
        }
        for (st = 0; st < this.auxAffMat.length; ++st) {
            for (ihyd = 0; ihyd < this.auxAffMat[0].length; ++ihyd) {
                this.auxAffMat[st][ihyd] = 0.0;
            }
        }
        for (wk = 0; wk < this.auxWSAffsMat.length; ++wk) {
            for (ihyd = 0; ihyd < this.auxWSAffsMat[0].length; ++ihyd) {
                this.auxWSAffsMat[wk][ihyd] = 0.0;
            }
        }
        for (int vecInd = 0; vecInd < hdbUnit.riverUpComps.size(); ++vecInd) {
            Object tempObj = hdbUnit.riverUpComps.elementAt(vecInd);
            if (!(tempObj instanceof hdb_affl)) continue;
            hdb_affl tempAff = (hdb_affl)tempObj;
            if (tempAff.getIsStoch()) {
                caudStat = this.getAffStat(iniY, endY, tempAff.getName());
                for (wk = 0; wk < this.auxWSAffsMat.length; ++wk) {
                    for (ihyd = 0; ihyd < this.auxWSAffsMat[0].length; ++ihyd) {
                        double[] dArray = this.auxWSAffsMat[wk];
                        int n = ihyd;
                        dArray[n] = dArray[n] + caudStat[wk][ihyd];
                    }
                }
                continue;
            }
            for (wk = 0; wk < this.auxWSAffsMat.length; ++wk) {
                ihyd = 0;
                while (ihyd < this.auxWSAffsMat[0].length) {
                    double[] dArray = this.auxWSAffsMat[wk];
                    int n = ihyd++;
                    dArray[n] = dArray[n] + tempAff.getQ();
                }
            }
        }
        for (st = 0; st < this.auxAffMat.length; ++st) {
            int to = this.stageFrTo[st + 1];
            int from = this.stageFrTo[st];
            if (to <= from) {
                to += 48;
            }
            int sumdays = 0;
            for (wk = from; wk < to; ++wk) {
                boolean hydbias;
                int wkc;
                if (wk > 47) {
                    wkc = wk - 48;
                    hydbias = true;
                } else {
                    hydbias = false;
                    wkc = wk;
                }
                int wkcr = wkc + 12;
                if (wkcr > 47) {
                    wkcr -= 48;
                }
                sumdays += wksdur[wkcr];
                ihyd = 0;
                while (ihyd < this.auxWSAffsMat[0].length) {
                    int i2hyd;
                    if (hydbias) {
                        i2hyd = ihyd - 1;
                        if (i2hyd < 0) {
                            i2hyd += caudStat[0].length;
                        }
                    } else {
                        i2hyd = ihyd;
                    }
                    double[] dArray = this.auxAffMat[st];
                    int n = ihyd++;
                    dArray[n] = dArray[n] + this.auxWSAffsMat[wkc][i2hyd] * (double)wksdur[wkcr];
                }
            }
            ihyd = 0;
            while (ihyd < this.auxWSAffsMat[0].length) {
                double[] dArray = this.auxAffMat[st];
                int n = ihyd++;
                dArray[n] = dArray[n] / (double)sumdays;
            }
        }
        return this.auxAffMat;
    }

    public double[][] getModAdjCaud(hdb_paspur myPaspPur, int stage, double[] stCaud) throws Exception {
        int i;
        int stageNumH = 0;
        if (this.bloStagNumH == null) {
            this.getBloStagNumH();
        }
        int numbloqs = this.auxppBMat.length;
        int actbloqSt = stage * numbloqs;
        ndb_inj tempGen = null;
        for (i = 0; i < numbloqs; ++i) {
            stageNumH += this.bloStagNumH[actbloqSt + i];
        }
        i = 0;
        while (i < stCaud.length) {
            int n = i++;
            stCaud[n] = stCaud[n] * (myPaspPur.getWat2PowRate() * (double)stageNumH);
        }
        for (i = 0; i < this.ppEleGen.length; ++i) {
            if (!this.ppEleGen[i].getName().equals(myPaspPur.getName())) continue;
            tempGen = this.ppEleGen[i];
            break;
        }
        if (numbloqs == 3 && (myPaspPur.getName().equals("PANGUE") || myPaspPur.getName().equals("RALPAN"))) {
            double[] porcPangue = new double[]{50.0, 30.0, 100.0};
            double[] porcRalPan = new double[]{50.0, 30.0, 100.0};
            double abEnergy = 0.0;
            double[] porc = myPaspPur.getName().equals("PANGUE") ? porcPangue : porcRalPan;
            for (i = 0; i < stCaud.length; ++i) {
                abEnergy = stCaud[i];
                for (int ibloq = 0; ibloq < numbloqs; ++ibloq) {
                    double emax = tempGen.getpmax() * (double)this.bloStagNumH[actbloqSt + ibloq];
                    this.auxppBMat[ibloq][i] = Math.min(Math.min(emax, stCaud[i]), abEnergy * porc[ibloq] / 100.0);
                    int n = i;
                    stCaud[n] = stCaud[n] - this.auxppBMat[ibloq][i];
                    double[] dArray = this.auxppBMat[ibloq];
                    int n2 = i;
                    dArray[n2] = dArray[n2] / (double)this.bloStagNumH[actbloqSt + ibloq];
                }
            }
        } else {
            for (int ibloq = 0; ibloq < numbloqs; ++ibloq) {
                double emax = tempGen.getpmax() * (double)this.bloStagNumH[actbloqSt + ibloq];
                i = 0;
                while (i < stCaud.length) {
                    this.auxppBMat[ibloq][i] = Math.min(emax, stCaud[i]);
                    int n = i;
                    stCaud[n] = stCaud[n] - this.auxppBMat[ibloq][i];
                    double[] dArray = this.auxppBMat[ibloq];
                    int n3 = i++;
                    dArray[n3] = dArray[n3] / (double)this.bloStagNumH[actbloqSt + ibloq];
                }
            }
        }
        return this.auxppBMat;
    }

    public static void renameTableRegPLPDB(String ActN, String NewN, String tableN, String columN, Connection dBCon) throws SQLException {
        Statement s = dBCon.createStatement();
        s.executeUpdate("UPDATE " + tableN + " SET " + columN + "='" + NewN + "' WHERE " + columN + "='" + ActN + "'");
        s.close();
    }
}

