/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.PLPException;
import de.core.PLPFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

final class PLPStageEditFrame
extends Frame
implements KeyListener,
ActionListener,
ItemListener,
AdjustmentListener {
    Panel mp;
    Panel p;
    Panel cp;
    Panel mbp;
    Font TextDialogFont;
    FontMetrics TextDialogFontMetrics;
    Label stageLabel;
    Label fromLabel;
    Label toLabel;
    PLPFrame myPLPFr;
    Scrollbar scrollStage;
    static int iniValue = 1;
    static int widthBlock = 1;
    static int min_Value = 1;
    static int defaulDur = 4;
    static int def_max_Value = 36;
    int actStage = 0;
    int oldNumStages;
    Vector stageDuration;
    Choice ChStD = null;
    public static String[] monthsnames = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
    private int i;
    Connection dBConn;

    public PLPStageEditFrame(Frame ff, Connection dBC) throws PLPException {
        super("Etapas");
        this.myPLPFr = (PLPFrame)ff;
        this.dBConn = dBC;
        this.stageDuration = new Vector(this.myPLPFr.getNumStages() * 2);
        this.i = 0;
        while (this.i < def_max_Value) {
            this.stageDuration.addElement(new Integer(defaulDur));
            ++this.i;
        }
        this.myPLPFr.setEnabled(false);
        this.mp = new Panel();
        this.p = new Panel();
        this.cp = new Panel();
        this.mbp = new Panel();
        this.setBackground(SystemColor.control);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new BorderLayout(1, 1));
        this.cp.setLayout(new FlowLayout());
        GridBagLayout gridbag = new GridBagLayout();
        this.p.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this.scrollStage = new Scrollbar(1, iniValue, widthBlock, min_Value, def_max_Value + 1);
        this.scrollStage.addAdjustmentListener(this);
        this.ChStD = new Choice();
        this.ChStD.addItem("1 Semana   ");
        this.ChStD.addItem("2 Semanas  ");
        this.ChStD.addItem("3 Semanas  ");
        this.ChStD.addItem("1 Mes      ");
        this.ChStD.addItem("2 Meses    ");
        this.ChStD.addItem("3 Meses    ");
        this.ChStD.addItem("6 Meses    ");
        this.ChStD.addItem("1 A\u00f1o      ");
        this.ChStD.select(3);
        this.ChStD.addItemListener(this);
        Panel ip = new Panel();
        ip.setLayout(new BorderLayout());
        ip.add("West", this.p);
        ip.add("Center", this.scrollStage);
        c.anchor = 17;
        this.stageLabel = new Label("Etapa: " + (this.actStage + 1) + " ");
        this.stageLabel.setAlignment(1);
        this.fromLabel = new Label("de semana1 de Abril de 2002       ");
        this.toLabel = new Label(" a semana1 de Abril de 2004        ");
        c.gridwidth = 1;
        gridbag.setConstraints(this.stageLabel, c);
        c.anchor = 10;
        c.gridwidth = 0;
        gridbag.setConstraints(this.ChStD, c);
        c.anchor = 17;
        gridbag.setConstraints(this.fromLabel, c);
        gridbag.setConstraints(this.toLabel, c);
        this.p.add(this.stageLabel);
        this.p.add(this.ChStD);
        this.p.add(this.fromLabel);
        this.p.add(this.toLabel);
        this.mbp.setLayout(new FlowLayout());
        this.mbp.setFont(DeepEdit.TextFont);
        Button b = new Button("Nuevo");
        b.addActionListener(this);
        this.mbp.add(b);
        b = new Button("Insertar");
        b.addActionListener(this);
        this.mbp.add(b);
        b = new Button("Eliminar");
        b.addActionListener(this);
        this.mbp.add(b);
        ip.add("South", this.mbp);
        Label title2 = new Label("DEFINICION DE ETAPAS");
        title2.setForeground(Color.blue);
        title2.setAlignment(1);
        this.add("North", title2);
        this.add("Center", ip);
        this.add("West", new Label(" "));
        this.add("East", new Label(" "));
        b = new Button("Aceptar");
        b.addActionListener(this);
        this.cp.add(b);
        b = new Button("Cancelar");
        b.addActionListener(this);
        this.cp.add(b);
        this.add("South", this.cp);
        this.loadData();
        this.setResizable(false);
        this.pack();
        ip.setSize(60, ip.getSize().height);
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.stageDuration.setElementAt(new Integer(this.index2Duration(this.ChStD.getSelectedIndex())), this.actStage);
        this.actulizStVis(this.actStage);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        int scrollval = this.scrollStage.getValue();
        this.setStage(scrollval - 1);
        this.actulizStVis(this.actStage);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String arg = ev.getActionCommand();
        if ("Aceptar".equals(arg)) {
            this.saveStagesLength();
            this.myPLPFr.setEnabled(true);
            try {
                this.saveData();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this.dispose();
        } else if ("Cancelar".equals(arg)) {
            this.myPLPFr.setNumStages(this.oldNumStages);
            this.myPLPFr.setEnabled(true);
            this.dispose();
        } else if ("Nuevo".equals(arg)) {
            this.loadDefault();
        } else if ("Insertar".equals(arg)) {
            this.insertStageAt(this.scrollStage.getValue() - 1);
        } else if ("Eliminar".equals(arg)) {
            this.deleteStageAt(this.scrollStage.getValue() - 1);
        }
    }

    private void setStage(int stage) {
        this.actStage = stage;
        this.stageLabel.setText("Etapa: " + (stage + 1) + " ");
        this.repaint();
    }

    private int index2Duration(int id) {
        int index;
        int dur = index = id + 1;
        if (index > 3 && index < 7) {
            dur = (index - 3) * 4;
        } else if (index == 7) {
            dur = 24;
        } else if (index == 8) {
            dur = 48;
        }
        return dur;
    }

    private int duration2index(int dur) {
        int index = -1;
        if (dur < 4) {
            index = dur - 1;
        } else if (dur / 4 < 4) {
            index = dur / 4 + 2;
        } else if (dur == 24) {
            index = 6;
        } else if (dur == 48) {
            index = 7;
        }
        return index;
    }

    private void actulizStVis(int targetStage) {
        int weekBef = 0;
        int weekAft = (Integer)this.stageDuration.elementAt(targetStage) - 1;
        this.ChStD.select(this.duration2index((Integer)this.stageDuration.elementAt(targetStage)));
        this.i = 0;
        while (this.i < targetStage) {
            weekBef += ((Integer)this.stageDuration.elementAt(this.i)).intValue();
            ++this.i;
        }
        int y = weekBef / 48;
        int m = (weekBef - y * 48) / 4;
        int w = weekBef - m * 4 - y * 48;
        this.fromLabel.setText("de semana" + (w + 1) + " de " + monthsnames[m] + " del " + (y + this.myPLPFr.iniYear) + "       ");
        y = (weekAft += (weekBef += this.myPLPFr.iniWeek - 1 + (this.myPLPFr.iniMonth - 1) * 4)) / 48;
        m = (weekAft - y * 48) / 4;
        w = weekAft - m * 4 - y * 48;
        this.toLabel.setText(" a semana" + (w + 1) + " de " + monthsnames[m] + " del " + (y + this.myPLPFr.iniYear) + "       ");
        this.repaint();
    }

    private void loadDefault() {
        this.setEnabled(false);
        Vector<Integer> tempStageD = new Vector<Integer>(def_max_Value * 2);
        for (int i = 0; i < def_max_Value; ++i) {
            tempStageD.addElement(new Integer(defaulDur));
        }
        this.stageDuration = tempStageD;
        this.scrollStage.setMaximum(def_max_Value + 1);
        this.scrollStage.setValue(iniValue);
        this.actStage = 0;
        this.actulizStVis(this.actStage);
        this.myPLPFr.setNumStages(def_max_Value);
        this.setEnabled(true);
    }

    private void insertStageAt(int targetStage) {
        this.setEnabled(false);
        this.stageDuration.insertElementAt(new Integer(defaulDur), targetStage);
        this.scrollStage.setMaximum(this.stageDuration.size() + 1);
        this.setStage(this.actStage);
        this.actulizStVis(this.actStage);
        this.myPLPFr.setNumStages(this.stageDuration.size());
        this.setEnabled(true);
    }

    private void deleteStageAt(int targetStage) {
        if (this.stageDuration.size() < 2) {
            return;
        }
        this.setEnabled(false);
        this.stageDuration.removeElementAt(targetStage);
        this.scrollStage.setMaximum(this.stageDuration.size() + 1);
        if (this.actStage == this.stageDuration.size()) {
            this.setStage(this.actStage - 1);
        } else {
            this.setStage(this.actStage);
        }
        this.actulizStVis(this.actStage);
        this.myPLPFr.setNumStages(this.stageDuration.size());
        this.setEnabled(true);
    }

    private void saveStagesLength() {
        int sumWeeks = 0;
        for (int i = 0; i < this.stageDuration.size(); ++i) {
            sumWeeks += ((Integer)this.stageDuration.elementAt(i)).intValue();
        }
        this.myPLPFr.setStagesLength(sumWeeks);
    }

    private void loadData() throws PLPException {
        int regcount = 0;
        this.oldNumStages = this.myPLPFr.getNumStages();
        try {
            Vector<Integer> StageDef = new Vector<Integer>(def_max_Value);
            Statement s = this.dBConn.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM Def_Etapas ORDER BY Num_Etapa");
            while (r.next()) {
                int stage = r.getInt("Num_Etapa");
                int value = r.getInt("Duracion");
                if (stage != ++regcount || this.duration2index(value) == -1 || value < 1) {
                    this.myPLPFr.plpFrameError("tabla Def_Etapas, datos inconsistentes.");
                }
                StageDef.addElement(new Integer(value));
            }
            s.close();
            this.stageDuration = StageDef;
            this.scrollStage.setMaximum(this.stageDuration.size() + 1);
            this.scrollStage.setValue(iniValue);
            this.actStage = 0;
            this.actulizStVis(this.actStage);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.myPLPFr.plpFrameError("al leer PLPDB, tabla Def_Etapas");
            this.loadDefault();
        }
        if (regcount == 0) {
            this.loadDefault();
        }
    }

    private void saveData() throws Exception {
        try {
            Statement s = this.dBConn.createStatement();
            s.executeUpdate("DELETE * FROM Def_Etapas");
            this.i = 0;
            while (this.i < this.stageDuration.size()) {
                int stage = this.i + 1;
                int value = (Integer)this.stageDuration.elementAt(this.i);
                s.executeUpdate("INSERT INTO Def_Etapas (Num_Etapa,Duracion)VALUES (" + stage + "," + value + ")");
                ++this.i;
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.myPLPFr.plpFrameError("al escribir PLPDB, tabla Def_Etapas");
        }
    }
}

