/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.PLPException;
import de.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

final class PLPNomBloqEdFrame
extends Frame
implements ActionListener {
    Panel mp;
    Panel p;
    Panel cp;
    Font TextDialogFont;
    FontMetrics TextDialogFontMetrics;
    Label title;
    TextField[] blocks;
    TextField[] bnames;
    private int i;
    private int numBloqs;
    Connection dBConn;

    public PLPNomBloqEdFrame(Connection dBC, int nb) {
        super("Curva de Carga");
        this.numBloqs = nb;
        this.blocks = new TextField[this.numBloqs];
        this.bnames = new TextField[this.numBloqs];
        this.title = new Label("NOMBRES DE BLOQUES");
        this.title.setForeground(Color.blue);
        this.title.setAlignment(1);
        this.dBConn = dBC;
        this.p = new Panel();
        this.cp = new Panel();
        this.setBackground(SystemColor.control);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new BorderLayout(1, 1));
        this.cp.setLayout(new FlowLayout());
        GridBagLayout gridbag = new GridBagLayout();
        this.p.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        GridBagConstraints cend = new GridBagConstraints();
        cend.anchor = 10;
        c.anchor = 10;
        c.gridwidth = 1;
        cend.gridwidth = 0;
        Button b = new Button("Aceptar");
        b.addActionListener(this);
        this.cp.add(b);
        b = new Button("Cancelar");
        b.addActionListener(this);
        this.cp.add(b);
        this.add("South", this.cp);
        this.add("North", this.title);
        Utils.makeLabel((Frame)this, "Bloque", gridbag, c, this.p);
        Utils.makeLabel((Frame)this, "Nombre Asociado", gridbag, cend, this.p);
        this.i = 0;
        while (this.i < this.numBloqs) {
            this.blocks[this.i] = Utils.makeTField(this, "" + (this.i + 1), gridbag, c, 3, this.p);
            this.bnames[this.i] = Utils.makeTField(this, "Bloque" + (this.i + 1), gridbag, cend, 15, this.p);
            ++this.i;
        }
        try {
            this.loadData();
        }
        catch (Exception e) {
            System.out.println("Error: al leer base de datos, tabla Nombre_Bloques_CC");
            System.out.println("Valores por defecto cargados");
            return;
        }
        this.i = 0;
        while (this.i < this.numBloqs) {
            this.blocks[this.i].setEditable(false);
            ++this.i;
        }
        this.setResizable(false);
        this.add("Center", this.p);
        this.add("East", new Label(" "));
        this.add("West", new Label(" "));
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String arg = ev.getActionCommand();
        if ("Aceptar".equals(arg)) {
            this.saveData();
            this.dispose();
        } else if ("Cancelar".equals(arg)) {
            this.dispose();
        }
    }

    private void loadData() throws PLPException {
        int regcount = 0;
        try {
            Statement s = this.dBConn.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM Nombre_Bloques_CDC WHERE (Grupo_NumBloques=" + this.numBloqs + ")" + " ORDER BY Num_Bloque");
            while (r.next()) {
                int val = r.getInt("Num_Bloque");
                String tmpName = r.getString("Nombre_Bloque");
                if (val != ++regcount) {
                    throw new PLPException("datos inconsistentes");
                }
                if (val - 1 == this.numBloqs) break;
                this.blocks[val - 1].setText("" + val);
                this.bnames[val - 1].setText(tmpName);
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e + " ,al leer PLPDB, tabla Nombre_Bloques_CC");
        }
    }

    private void saveData() {
        try {
            Statement s = this.dBConn.createStatement();
            s.executeUpdate("DELETE * FROM Nombre_Bloques_CDC WHERE (Grupo_NumBloques=" + this.numBloqs + ")");
            this.i = 0;
            while (this.i < this.numBloqs) {
                int block = this.i + 1;
                String name = "'" + this.bnames[this.i].getText() + "'";
                s.executeUpdate("INSERT INTO Nombre_Bloques_CDC (Num_Bloque,Grupo_NumBloques,Nombre_Bloque)VALUES (" + block + "," + this.numBloqs + "," + name + ")");
                ++this.i;
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error: al escribir PLPDB, tabla Nombre_Bloques_CC");
            return;
        }
        System.out.println("Nombres de bloques guardados");
    }
}

