/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.PLPFrame;
import de.core.SimpleDialog;
import de.core.comp;
import de.core.hdb_link;
import de.core.hdb_res;
import de.core.hdb_unit;
import de.utils.StringUtil;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

class PLPLoadScenarioFrame
extends Frame
implements KeyListener,
ActionListener {
    DeepEdit applet;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    TextField Hidro = null;
    TextField Etapa = null;
    String[] NameDBBar;
    double[] PDBBar;
    String[] NameDBCen;
    double[] PDBCen;
    int dimDBBar;
    int dimDBCen;

    PLPLoadScenarioFrame(DeepEdit app) {
        super("PLP Carga de Escenario Simulado");
        this.applet = app;
        PLPLoadScenarioFrame pLPLoadScenarioFrame = this;
        pLPLoadScenarioFrame.applet.SimulateSetUp();
        this.setBackground(SystemColor.control);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        this.setLayout(new FlowLayout());
        Panel P = new Panel();
        P.setLayout(new GridLayout(4, 2));
        Label titel = new Label("Opciones de Carga");
        titel.setForeground(Color.blue);
        P.add(titel);
        P.add(new Label(" "));
        P.add(new Label("Indique Simulaci\u00f3n"));
        this.Hidro = new TextField("1", 11);
        P.add(this.Hidro);
        P.add(new Label("Indique Etapa"));
        this.Etapa = new TextField("1", 11);
        P.add(this.Etapa);
        Button button1 = new Button("Cargar");
        button1.setActionCommand("OK");
        button1.addActionListener(this);
        Button button2 = new Button("Cancelar");
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        P.add(button1);
        P.add(button2);
        this.add(P);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PLPLoadScenarioFrame.this.setVisible(false);
                PLPLoadScenarioFrame.this.dispose();
            }
        });
        this.pack();
        this.setVisible(true);
        try {
            PLPFrame cfr_ignored_0 = DeepEdit.frame.MyPLPFrame;
            if (PLPFrame.myPLPser == null) {
                System.out.println(" Leyendo base de datos PLPser... ");
                DeepEdit.frame.MyPLPFrame.DoReadResults(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.toString();
            String[] DlgButtons = new String[]{"Apply"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading PLPser information", message, DlgButtons, 1, 0, 0, 2);
        }
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        boolean todos = false;
        boolean ixx = false;
        if (obj instanceof TextField || obj instanceof Button) {
            if (label.equals("OK") || obj instanceof TextField) {
                this.setVisible(false);
                try {
                    DeepEdit.frame.MyPLPFrame.myPLPtool.mydbm.getReservoirs();
                    DeepEdit.frame.MyPLPFrame.myPLPtool.mydbm.loadFuncCotaVol();
                    System.out.println(" Inicio de Lectura de Base de Datos ... ");
                    this.LoadDataBase(this.Hidro.getText(), this.Etapa.getText());
                    System.out.println(" Metodolog\u00eda Finalizada");
                    this.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = e.toString();
                    String[] DlgButtons = new String[]{"Apply"};
                    SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading PLP Load Scenario information", message, DlgButtons, 1, 0, 0, 2);
                }
            }
            this.dispose();
        }
    }

    public void LoadDataBase(String hid, String eta) {
        int i = -1;
        int j = -1;
        int h = -1;
        int e = -1;
        int hhid = 0;
        int ix = 0;
        String auxs = "";
        boolean found = false;
        double auxf = 0.0;
        try {
            hdb_res Temphdb_res;
            hdb_unit Temphdb_unit;
            comp TempComponent;
            String mihidro;
            System.out.println("Cargando Informaci\u00f3n de la Base de Datos PLPRes");
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String dsn = "jdbc:odbc:PLPRes";
            String user = "";
            String password = "";
            Connection conPLPRes = DriverManager.getConnection(dsn, user, password);
            conPLPRes.setAutoCommit(true);
            Statement s = conPLPRes.createStatement();
            System.out.println(" ");
            System.out.println("-------------------------------------");
            System.out.println("       Despacho Seleccionado");
            System.out.println("-------------------------------------");
            System.out.println("       Hidrolog\u00eda/   Etapa");
            System.out.println(" " + StringUtil.strformat(hid, 16) + "/" + StringUtil.strformat(eta, 8));
            System.out.println(" ");
            h = Integer.parseInt(hid);
            e = Integer.parseInt(eta);
            if (h >= 1 && h < 10) {
                mihidro = "Sim  " + h;
            } else if (h >= 10 && h < 100) {
                mihidro = "Sim " + h;
            } else if (h >= 100 && h < 1000) {
                mihidro = "Sim" + h;
            } else {
                System.out.println("");
                System.out.println("Se consider\u00f3 la media como simulaci\u00f3n");
                System.out.println("");
                mihidro = "MEDIA";
                h = DeepEdit.frame.MyPLPFrame.myPLPtool.mydbm.getParam_Sim("Num_Simulaciones") + 1;
            }
            System.out.println(" mihidro = ***" + mihidro + "***");
            System.out.println(" etapa   = ***" + e + "***");
            ResultSet r1 = s.executeQuery("SELECT *\tFROM PLPIDSIMRes.csv   WHERE Etapa=" + e);
            i = 0;
            while (r1.next()) {
                ++i;
                hhid = r1.getInt("Sim" + h);
            }
            if (i == 0) {
                String[] DlgButtons = new String[]{"OK"};
                String message = "Error: No se encontraron datos I";
                SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Caution:", message, DlgButtons, 1, 0, 0, 2);
                s.close();
                conPLPRes.commit();
                conPLPRes.close();
                return;
            }
            PLPLoadScenarioFrame pLPLoadScenarioFrame = this;
            pLPLoadScenarioFrame.applet.SimulateSetUp();
            r1 = s.executeQuery("SELECT *\tFROM PLPAFLCERes.csv   WHERE Etapa=" + e);
            i = 0;
            while (r1.next()) {
                ++i;
                auxs = r1.getString("CenNom");
                System.out.println("Cargando para " + auxs);
                found = false;
                ix = 0;
                while (true) {
                    if (ix >= DeepEdit.MySchematic.Components.size()) break;
                    TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
                    if (TempComponent instanceof hdb_unit && (Temphdb_unit = (hdb_unit)TempComponent).getName().equals(auxs)) {
                        Temphdb_unit.caudaffl = r1.getDouble("Hidro" + hhid);
                        found = true;
                        break;
                    }
                    ++ix;
                }
                if (found) continue;
                System.out.println("Cautio: Unit " + auxs + " not found in Schematic!");
            }
            r1 = s.executeQuery("SELECT *\tFROM plpemb.csv   WHERE Etapa=" + e + "   AND Hidro='" + mihidro + "'");
            i = 0;
            while (r1.next()) {
                ++i;
                auxs = r1.getString("EmbNom");
                System.out.println("Cargando para " + auxs);
                found = false;
                ix = 0;
                while (true) {
                    if (ix >= DeepEdit.MySchematic.Components.size()) break;
                    TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
                    if (TempComponent instanceof hdb_res && (Temphdb_res = (hdb_res)TempComponent).getName().equals(auxs)) {
                        auxf = r1.getDouble("EmbFac") / 1000000.0;
                        Temphdb_res.Vini = r1.getDouble("EmbVini") * auxf;
                        Temphdb_res.Vfin = r1.getDouble("EmbVfin") * auxf;
                        Temphdb_res.Vinim = DeepEdit.frame.MyPLPFrame.myPLPtool.mydbm.evalVol2Cota(Temphdb_res.Vini, auxs);
                        Temphdb_res.Vfinm = DeepEdit.frame.MyPLPFrame.myPLPtool.mydbm.evalVol2Cota(Temphdb_res.Vfin, auxs);
                        Temphdb_res.caudgener = r1.getDouble("EmbQgen");
                        Temphdb_res.cauddef = r1.getDouble("EmbQdef");
                        found = true;
                        break;
                    }
                    ++ix;
                }
                if (found) continue;
                System.out.println("Cautio: Unit " + auxs + " not found in Schematic!");
            }
            if (i == 0) {
                String[] DlgButtons = new String[]{"OK"};
                String message = "Error: No se encontraron datos II";
                SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Caution:", message, DlgButtons, 1, 0, 0, 2);
                s.close();
                conPLPRes.commit();
                conPLPRes.close();
                return;
            }
            i = 0;
            while (true) {
                PLPFrame cfr_ignored_0 = DeepEdit.frame.MyPLPFrame;
                if (i >= PLPFrame.myPLPser.numser) break;
                PLPFrame cfr_ignored_1 = DeepEdit.frame.MyPLPFrame;
                auxs = PLPFrame.myPLPser.SerNom[i];
                System.out.println("Cargando para " + auxs);
                found = false;
                ix = 0;
                while (true) {
                    if (ix >= DeepEdit.MySchematic.Components.size()) break;
                    TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
                    if (TempComponent instanceof hdb_unit && (Temphdb_unit = (hdb_unit)TempComponent).getName().equals(auxs)) {
                        PLPFrame cfr_ignored_2 = DeepEdit.frame.MyPLPFrame;
                        Temphdb_unit.caudspill = PLPFrame.myPLPser.Data[h - 1][i][e - 1][1];
                        PLPFrame cfr_ignored_3 = DeepEdit.frame.MyPLPFrame;
                        Temphdb_unit.caudgener = PLPFrame.myPLPser.Data[h - 1][i][e - 1][0];
                        found = true;
                        break;
                    }
                    if (TempComponent instanceof hdb_res) {
                        Temphdb_res = (hdb_res)TempComponent;
                        if (("Filt_" + Temphdb_res.getName()).equals(auxs)) {
                            PLPFrame cfr_ignored_4 = DeepEdit.frame.MyPLPFrame;
                            Temphdb_res.caudfilt = PLPFrame.myPLPser.Data[h - 1][i][e - 1][0];
                            PLPFrame cfr_ignored_5 = DeepEdit.frame.MyPLPFrame;
                            Temphdb_res.caudspill = PLPFrame.myPLPser.Data[h - 1][i][e - 1][1];
                            found = true;
                            break;
                        }
                    }
                    ++ix;
                }
                if (!found) {
                    System.out.println("Caution: Unit " + auxs + " not found in Schematic!");
                }
                ++i;
            }
            if (i == 0) {
                String[] DlgButtons = new String[]{"OK"};
                String message = "Error: No se encontraron datos II";
                SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Caution:", message, DlgButtons, 1, 0, 0, 2);
                s.close();
                conPLPRes.commit();
                conPLPRes.close();
                return;
            }
            ix = 0;
            while (true) {
                if (ix >= DeepEdit.MySchematic.Components.size()) break;
                TempComponent = (comp)DeepEdit.MySchematic.Components.elementAt(ix);
                if (TempComponent instanceof hdb_link) {
                    hdb_link Temphdb_link = (hdb_link)TempComponent;
                    Temphdb_link.InformEndComponents();
                }
                ++ix;
            }
            s.close();
            conPLPRes.commit();
            conPLPRes.close();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog FinishDialog = new SimpleDialog(DeepEdit.frame, "Caution:", "Finalizaci\u00f3n de Carga de Escenario: Simulaci\u00f3n =" + mihidro + ", Etapa=" + e, DlgButtons, 1, 0, 0, 2);
            DeepEdit.MySchematic.state = mihidro + " | Etapa:" + e;
            PLPFrame cfr_ignored_6 = DeepEdit.frame.MyPLPFrame;
            PLPFrame.View = true;
        }
        catch (Exception ex1) {
            System.out.println("Error: al leer base de datos en carga de escenario" + ex1);
            ex1.printStackTrace();
            String[] DlgButtons = new String[]{"OK"};
            String message = "Error: al leer base de datos en carga de escenario" + ex1;
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Caution:", message, DlgButtons, 1, 0, 0, 2);
        }
        DeepEdit.MySchematicPanel.repaint();
    }
}

