/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.DBReadTableFrame;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.PLPBarrasOpFrame;
import de.core.PLPCotasOpFrame;
import de.core.PLPEGeneraOpFrame;
import de.core.PLPEdFDCAFr;
import de.core.PLPEdLDCBFFr;
import de.core.PLPException;
import de.core.PLPFlujosOpFrame;
import de.core.PLPGeneraOpFrame;
import de.core.PLPLoadDispatchFrame;
import de.core.PLPLoadScenarioFrame;
import de.core.PLPNomBloqEdFrame;
import de.core.PLPSimpTableFr;
import de.core.PLPStageEditFrame;
import de.core.PLPbar;
import de.core.PLPcen;
import de.core.PLPlin;
import de.core.PLPser;
import de.core.PLPtool;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.agreement;
import de.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class PLPFrame
extends Frame
implements KeyListener,
ActionListener,
ItemListener {
    Panel cards;
    public Connection dbtrab;
    static String namecard1 = "Par\u00e1metros de Simulaci\u00f3n";
    static String namecard2 = "Etapas, Bloques y Demanda";
    static String namecard3 = "Ejecuci\u00f3n";
    static String namecard4 = "An\u00e1lisis de Resultados";
    static String[] plpFileNames = new String[]{"PLPETA.DAT", "PLPDEM.DAT", "PLPBAR.DAT", "PLPCNFLI.DAT", "PLPCNFCE.DAT", "PLPPLAEM.DAT", "PLPAFLCE.DAT", "PLPIDSIM.DAT", "PLPIDAPE.DAT", "PLPMANCE.DAT", "PLPMANEM.DAT", "PLPMANLI.DAT", "PLPPATH.DAT", "PLPCENFI.DAT", "PLPCENRE.DAT", "PLPLAJA.DAT", "PLPMAULE.DAT", "PLPMAT.DAT", "PLPDEB.DAT", "PLPPAR.DAT"};
    private Choice cardChoice;
    private Choice ChIniWeek = null;
    private Choice ChEndWeek = null;
    private Choice ChIniMonth = null;
    private Choice ChEndMonth = null;
    private TextField tFIniYear = null;
    private TextField tFEndYear = null;
    public int iniWeek = 1;
    public int endWeek = 4;
    public int iniMonth = 4;
    public int endMonth = 3;
    public int iniYear = 2002;
    public int endYear = 2005;
    public int angRef = 1000;
    private TextField tFNumSim = null;
    private TextField tFNumAper = null;
    private TextField tFNumHydro = null;
    private TextField tFLastHydStat = null;
    private Choice ChMonThaw = null;
    private Choice ChKindSim = null;
    private Choice ChKindApe = null;
    private Choice ChLossMod = null;
    public int numSim = 8;
    public int numAper = 10;
    public int numHydro = 40;
    public int lastHydStat = 2001;
    public int lineLossMod = 0;
    public int monThaw = 10;
    public int kindSim = 0;
    public int kindApe = 0;
    public int lossMod = 0;
    private int stagesLength = 144;
    private TextField tFNumStages = null;
    private TextField tFnumBlockLDC = null;
    public int numBlockLDC = 3;
    public int numStages = 36;
    private Button bEdStage = null;
    private Button bEdBlocks = null;
    private Button bEdDiscR = null;
    private Button bEdEngAn = null;
    private Button bEdWeekLDC = null;
    private Button bEdADDFL = null;
    private Button bEdADDFW = null;
    private Button bGeneraC = null;
    private Button bGeneraCOp = null;
    private Button bEGeneraC = null;
    private Button bEGeneraCOp = null;
    private Button bGeneraE = null;
    private Button bGeneraEOp = null;
    private Button bGeneraS = null;
    private Button bGeneraSOp = null;
    private Button bLoadResults = null;
    private Button bResetResults = null;
    private Button bLoadDispatch = null;
    private Button bLoadScenario = null;
    private Button bBalancesE = null;
    private Button bBalancesEOp = null;
    private Button bBalancesS = null;
    private Button bBalancesSOp = null;
    private Button bCotas = null;
    private Button bCotasOp = null;
    private Button bFlujos = null;
    private Button bFlujosOp = null;
    private Button bBarras = null;
    private Button bBarrasOp = null;
    private Button bValorAgua = null;
    private Button bValorAguaOp = null;
    private Button blaja1 = null;
    private Button blaja2 = null;
    private Button blaja3 = null;
    private Button bmaule1 = null;
    private Button bmaule2 = null;
    private Button bmaule3 = null;
    private Button bmaule4 = null;
    private Button bmaule5 = null;
    private PLPStageEditFrame myStageEditF;
    private PLPSimpTableFr mySimpTab;
    private PLPEdFDCAFr myEdFDCA;
    private PLPNomBloqEdFrame myBloqEdFrame;
    private PLPEdLDCBFFr myEdLDCBFFrame;
    Font TextDialogFont;
    FontMetrics TextDialogFontMetrics;
    Label StatusLabel = null;
    Panel cp1;
    Panel cp2;
    Panel cp3;
    Panel cp4;
    public Checkbox[] CHBplpFile;
    private Button bMakeFile = null;
    private Button bEditFile = null;
    private Button bMakeAll = null;
    private Button bExecute = null;
    private Schematic actSchem = null;
    private DeepEdit myApplet = null;
    public PLPtool myPLPtool = null;
    public String Location = "";
    public static boolean View = false;
    public static PLPcen myPLPcen = null;
    public static PLPlin myPLPlin = null;
    public static PLPbar myPLPbar = null;
    public static PLPser myPLPser = null;
    public static boolean PLPResDone = false;
    public static FileInputStream fis = null;

    public PLPFrame(Schematic sch, DeepEdit app) {
        super("PLP:" + DeepEdit.MySchematic.FileDir);
        this.actSchem = sch;
        this.myApplet = app;
        this.dbtrab = DeepEditFrame.conPLPDB;
        this.init();
    }

    public PLPFrame() {
        super("PLP");
        this.actSchem = new Schematic();
        this.myApplet = null;
        try {
            this.dbtrab = this.OpenDataBase("PLPDB", "admin", "");
            this.dbtrab.setAutoCommit(true);
        }
        catch (Exception e) {
            System.out.println("imposible abrir PLPDB" + e);
            return;
        }
        System.out.println("Base de datos Abierta");
        this.init();
    }

    public void init() {
        this.myPLPtool = new PLPtool(this.actSchem, this.myApplet);
        this.setBackground(SystemColor.control);
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        BorderLayout borderl = new BorderLayout();
        this.setLayout(borderl);
        this.cards = new Panel();
        this.cards.setLayout(new CardLayout());
        this.cp1 = this.create1();
        this.cp2 = this.create2();
        this.cp3 = this.create3();
        this.cp4 = this.create4();
        this.cards.add((Component)this.cp1, namecard1);
        this.cards.add((Component)this.cp2, namecard2);
        this.cards.add((Component)this.cp3, namecard3);
        this.cards.add((Component)this.cp4, namecard4);
        this.add("Center", this.cards);
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        Button b = new Button("|<");
        b.addActionListener(this);
        p.add(b);
        b = new Button("<");
        b.addActionListener(this);
        p.add(b);
        b = new Button(">");
        b.addActionListener(this);
        p.add(b);
        b = new Button(">|");
        b.addActionListener(this);
        p.add(b);
        this.cardChoice = new Choice();
        this.cardChoice.addItem(namecard1);
        this.cardChoice.addItem(namecard2);
        this.cardChoice.addItem(namecard3);
        this.cardChoice.addItem(namecard4);
        this.cardChoice.addItemListener(this);
        p.add(this.cardChoice);
        this.add("North", p);
        Panel q = new Panel();
        q.setLayout(new BorderLayout());
        this.StatusLabel = new Label(" Cargando Datos...");
        this.StatusLabel.setForeground(Color.green);
        this.StatusLabel.setAlignment(1);
        q.add("North", this.StatusLabel);
        q.add("Center", new Label(" "));
        Panel q2 = new Panel();
        q2.setLayout(new FlowLayout());
        b = new Button("Guardar");
        b.addActionListener(this);
        q2.add(b);
        b = new Button("Cerrar");
        b.addActionListener(this);
        q2.add(b);
        q.add("South", q2);
        this.add("South", q);
        this.add("East", new Label(" "));
        this.add("West", new Label(" "));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PLPFrame.this.setVisible(false);
                try {
                    PLPFrame.this.closePLPFrame();
                }
                catch (Exception e) {
                    System.out.println(e);
                    PLPFrame.this.myApplet;
                    PLPFrame cfr_ignored_0 = DeepEdit.frame.MyPLPFrame;
                    View = false;
                    PLPFrame.this.myApplet;
                    DeepEdit.frame.MyPLPFrame = null;
                    PLPFrame.this.dispose();
                }
            }
        });
        this.setIconImage(this.myApplet.getFrameIconImage());
        this.pack();
        this.setVisible(true);
        try {
            this.loadData();
            this.cards.repaint();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ((CardLayout)this.cards.getLayout()).show(this.cards, (String)e.getItem());
        if (((String)e.getItem()).equals("Ejecuci\u00f3n")) {
            this.saveData();
        }
    }

    public Panel create1() {
        int i;
        this.ChIniWeek = new Choice();
        this.ChIniMonth = new Choice();
        this.ChEndWeek = new Choice();
        this.ChEndMonth = new Choice();
        this.ChMonThaw = new Choice();
        this.ChKindSim = new Choice();
        this.ChKindApe = new Choice();
        this.ChLossMod = new Choice();
        Panel p = new Panel();
        p.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(gridbag);
        for (i = 1; i < 5; ++i) {
            this.ChIniWeek.addItem(String.valueOf(i));
            this.ChEndWeek.addItem(String.valueOf(i));
        }
        this.ChIniWeek.select(this.iniWeek - 1);
        this.ChEndWeek.select(this.endWeek - 1);
        for (i = 1; i < 13; ++i) {
            this.ChIniMonth.addItem(String.valueOf(i));
            this.ChEndMonth.addItem(String.valueOf(i));
            this.ChMonThaw.addItem(String.valueOf(i));
        }
        this.ChIniMonth.select(this.iniMonth - 1);
        this.ChEndMonth.select(this.endMonth - 1);
        this.ChMonThaw.select(this.monThaw - 1);
        this.ChKindSim.addItem("Aleatorias");
        this.ChKindSim.addItem("Hist\u00f3ricas Aleatorias");
        this.ChKindSim.addItem("Hist. Determin\u00edstica");
        this.ChKindSim.select(this.kindSim);
        this.ChKindApe.addItem("Anual");
        this.ChKindApe.addItem("por etapa");
        this.ChKindSim.select(this.kindApe);
        this.ChLossMod.addItem("Sin p\u00e9rdidas");
        this.ChLossMod.addItem("Perd/2 a E y R");
        this.ChLossMod.addItem("P\u00e9rdidas a Emisor");
        this.ChLossMod.addItem("P\u00e9rdidas a Receptor");
        this.ChLossMod.select(this.lossMod);
        c.gridwidth = 0;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel(this, "PARAMETROS DE SIMULACION", gridbag, c, Color.blue, p);
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, " ", gridbag, c, p);
        c.gridwidth = 4;
        Utils.makeLabel((Frame)this, "Periodo de Simulaci\u00f3n", gridbag, c, p);
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, " ", gridbag, c, p);
        c.gridwidth = 1;
        Utils.makeLabel((Frame)this, " ", gridbag, c, p);
        Utils.makeLabel((Frame)this, "Semana", gridbag, c, p);
        Utils.makeLabel((Frame)this, "Mes", gridbag, c, p);
        Utils.makeLabel((Frame)this, "A\u00f1o", gridbag, c, p);
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, " ", gridbag, c, p);
        c.gridwidth = 1;
        c.anchor = 17;
        Utils.makeLabel((Frame)this, "Inicio", gridbag, c, p);
        p.add(this.ChIniWeek);
        p.add(this.ChIniMonth);
        this.tFIniYear = Utils.makeTField(this, "" + this.iniYear, gridbag, c, 5, p);
        this.tFIniYear.addKeyListener(this);
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, " ", gridbag, c, p);
        c.gridwidth = 1;
        Utils.makeLabel((Frame)this, "Fin", gridbag, c, p);
        p.add(this.ChEndWeek);
        p.add(this.ChEndMonth);
        this.ChEndWeek.setEnabled(false);
        this.ChEndMonth.setEnabled(false);
        this.tFEndYear = Utils.makeTField(this, "" + this.endYear, gridbag, c, 5, p);
        this.tFEndYear.setEnabled(false);
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, " ", gridbag, c, p);
        Utils.makeLabel((Frame)this, " ", gridbag, c, p);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "N\u00famero de Simulaciones", gridbag, c, p);
        c.gridwidth = 0;
        this.tFNumSim = Utils.makeTField(this, "" + this.numSim, gridbag, c, 5, p);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "N\u00famero de Hidrolog\u00edas", gridbag, c, p);
        c.gridwidth = 0;
        this.tFNumHydro = Utils.makeTField(this, "" + this.numHydro, gridbag, c, 5, p);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "N\u00famero de Aperturas", gridbag, c, p);
        c.gridwidth = 0;
        this.tFNumAper = Utils.makeTField(this, "" + this.numAper, gridbag, c, 5, p);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "Ultimo a\u00f1o  Hidrol\u00f3gico", gridbag, c, p);
        c.gridwidth = 0;
        this.tFLastHydStat = Utils.makeTField(this, "" + this.lastHydStat, gridbag, c, 5, p);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "Mes de Inicio de deshielo", gridbag, c, p);
        c.gridwidth = 0;
        gridbag.setConstraints(this.ChMonThaw, c);
        p.add(this.ChMonThaw);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "Tipo de Simulaci\u00f3n", gridbag, c, p);
        c.gridwidth = 0;
        gridbag.setConstraints(this.ChKindSim, c);
        p.add(this.ChKindSim);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "Tipo de Apertura", gridbag, c, p);
        c.gridwidth = 0;
        gridbag.setConstraints(this.ChKindApe, c);
        p.add(this.ChKindApe);
        c.gridwidth = 3;
        Utils.makeLabel((Frame)this, "Modelo de P\u00e9rdidas", gridbag, c, p);
        c.gridwidth = 0;
        gridbag.setConstraints(this.ChLossMod, c);
        p.add(this.ChLossMod);
        return p;
    }

    public Panel create2() {
        Panel p = new Panel();
        p.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        GridBagConstraints cef = new GridBagConstraints();
        p.setLayout(gridbag);
        this.bEdStage = new Button("EDITAR");
        this.bEdStage.addActionListener(this);
        this.bEdBlocks = new Button("EDITAR");
        this.bEdBlocks.addActionListener(this);
        this.bEdDiscR = new Button("EDITAR");
        this.bEdDiscR.addActionListener(this);
        this.bEdEngAn = new Button("EDITAR");
        this.bEdEngAn.addActionListener(this);
        this.bEdADDFL = new Button("EDITAR");
        this.bEdADDFL.addActionListener(this);
        this.bEdADDFW = new Button("EDITAR");
        this.bEdADDFW.addActionListener(this);
        this.bEdWeekLDC = new Button("EDITAR");
        this.bEdWeekLDC.addActionListener(this);
        c.anchor = 17;
        c.gridwidth = 1;
        c2.anchor = 17;
        c2.gridwidth = 2;
        cef.gridwidth = 0;
        Utils.makeLabel(this, "ETAPAS, BLOQUES Y DEMANDA", gridbag, cef, Color.blue, p);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel((Frame)this, "N\u00famero de Etapas", gridbag, c, p);
        this.tFNumStages = Utils.makeTField(this, "" + this.numStages, gridbag, c, 3, p);
        this.tFNumStages.setEnabled(false);
        gridbag.setConstraints(this.bEdStage, cef);
        p.add(this.bEdStage);
        Utils.makeLabel((Frame)this, "Num. Bloques Curva de Carga", gridbag, c, p);
        this.tFnumBlockLDC = Utils.makeTField(this, "" + this.numBlockLDC, gridbag, c, 3, p);
        gridbag.setConstraints(this.bEdBlocks, cef);
        p.add(this.bEdBlocks);
        Utils.makeLabel((Frame)this, "Tasas de Descuento Anuales", gridbag, c2, p);
        gridbag.setConstraints(this.bEdDiscR, cef);
        p.add(this.bEdDiscR);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel((Frame)this, "Caracter\u00edsticas de la Demanda", gridbag, cef, p);
        Utils.makeLabel((Frame)this, "Consumos de Energ\u00eda Anuales", gridbag, c2, p);
        gridbag.setConstraints(this.bEdEngAn, cef);
        p.add(this.bEdEngAn);
        Utils.makeLabel((Frame)this, "Factores de Distribuci\u00f3n Geogr\u00e1fica de Carga", gridbag, c2, p);
        gridbag.setConstraints(this.bEdADDFL, cef);
        p.add(this.bEdADDFL);
        Utils.makeLabel((Frame)this, "Factores de Distribuci\u00f3n Semanal de Carga", gridbag, c2, p);
        gridbag.setConstraints(this.bEdADDFW, cef);
        p.add(this.bEdADDFW);
        Utils.makeLabel((Frame)this, "Factores de la Curva de Duraci\u00f3n de Carga", gridbag, c2, p);
        gridbag.setConstraints(this.bEdWeekLDC, cef);
        p.add(this.bEdWeekLDC);
        for (int i = 0; i < 4; ++i) {
            Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        }
        return p;
    }

    public Panel create3() {
        int i;
        Panel p = new Panel();
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        p.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        GridBagConstraints cf = new GridBagConstraints();
        this.CHBplpFile = new Checkbox[20];
        p.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        cf.anchor = 10;
        c.anchor = 10;
        cf.gridwidth = 0;
        Utils.makeLabel(this, "EJECUCION", gridbag, cf, Color.blue, p);
        Utils.makeLabel((Frame)this, " ", gridbag, cf, p);
        Utils.makeLabel((Frame)this, "Archivos de Entrada para PLP", gridbag, cf, p);
        cf.anchor = 17;
        c.anchor = 17;
        for (i = 0; i < 20; ++i) {
            this.CHBplpFile[i] = new Checkbox(plpFileNames[i], false);
        }
        for (i = 0; i < 10; ++i) {
            gridbag.setConstraints(this.CHBplpFile[2 * i], c);
            gridbag.setConstraints(this.CHBplpFile[2 * i + 1], cf);
        }
        for (i = 0; i < 20; ++i) {
            p.add(this.CHBplpFile[i]);
        }
        Panel cp = new Panel();
        cp.setLayout(new FlowLayout());
        this.bMakeFile = new Button("Crear");
        this.bMakeFile.addActionListener(this);
        this.bEditFile = new Button("Editar");
        this.bEditFile.addActionListener(this);
        this.bMakeAll = new Button("Crear Todos");
        this.bMakeAll.addActionListener(this);
        this.bExecute = new Button("Ejecutar PLP");
        this.bExecute.addActionListener(this);
        cp.add(this.bMakeFile);
        cp.add(this.bMakeAll);
        cp.add(this.bEditFile);
        cp.add(this.bExecute);
        cf.anchor = 10;
        gridbag.setConstraints(cp, cf);
        p.add(cp);
        Utils.makeLabel((Frame)this, " ", gridbag, cf, p);
        return p;
    }

    public Panel create4() {
        Panel p = new Panel();
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        p.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        GridBagConstraints cef = new GridBagConstraints();
        p.setLayout(gridbag);
        this.bLoadResults = new Button("Crear *.bin");
        this.bLoadResults.addActionListener(this);
        p.setLayout(gridbag);
        this.bResetResults = new Button("Liberar Memoria");
        this.bResetResults.addActionListener(this);
        p.setLayout(gridbag);
        this.bLoadDispatch = new Button("Cargar Despacho (ndb)");
        this.bLoadDispatch.addActionListener(this);
        p.setLayout(gridbag);
        this.bLoadScenario = new Button("Cargar Escenario Simulado (hdb)");
        this.bLoadScenario.addActionListener(this);
        p.setLayout(gridbag);
        this.bGeneraC = new Button("Tabla");
        this.bGeneraC.addActionListener(this);
        this.bGeneraCOp = new Button("Opciones");
        this.bGeneraCOp.addActionListener(this);
        p.setLayout(gridbag);
        this.bEGeneraC = new Button("Tabla");
        this.bEGeneraC.addActionListener(this);
        this.bEGeneraCOp = new Button("Opciones");
        this.bEGeneraCOp.addActionListener(this);
        p.setLayout(gridbag);
        this.bGeneraE = new Button("Tabla");
        this.bGeneraE.addActionListener(this);
        this.bGeneraEOp = new Button("Opciones");
        this.bGeneraEOp.addActionListener(this);
        p.setLayout(gridbag);
        this.bGeneraS = new Button("Tabla");
        this.bGeneraS.addActionListener(this);
        this.bGeneraSOp = new Button("Opciones");
        this.bGeneraSOp.addActionListener(this);
        this.bBalancesE = new Button("Tabla");
        this.bBalancesE.addActionListener(this);
        this.bBalancesEOp = new Button("Opciones");
        this.bBalancesEOp.addActionListener(this);
        this.bBalancesS = new Button("Tabla");
        this.bBalancesS.addActionListener(this);
        this.bBalancesSOp = new Button("Opciones");
        this.bBalancesSOp.addActionListener(this);
        this.bCotas = new Button("Tabla");
        this.bCotas.addActionListener(this);
        this.bCotasOp = new Button("Opciones");
        this.bCotasOp.addActionListener(this);
        this.bValorAgua = new Button("Tabla");
        this.bValorAgua.addActionListener(this);
        this.bValorAguaOp = new Button("Opciones");
        this.bValorAguaOp.addActionListener(this);
        this.bFlujos = new Button("Tabla");
        this.bFlujos.addActionListener(this);
        this.bFlujosOp = new Button("Opciones");
        this.bFlujosOp.addActionListener(this);
        this.bBarras = new Button("Tabla");
        this.bBarras.addActionListener(this);
        this.bBarrasOp = new Button("Opciones");
        this.bBarrasOp.addActionListener(this);
        this.blaja1 = new Button("plplaja1    ");
        this.blaja1.addActionListener(this);
        this.blaja2 = new Button("plplaja2    ");
        this.blaja2.addActionListener(this);
        this.blaja3 = new Button("plplaja3    ");
        this.blaja3.addActionListener(this);
        this.bmaule1 = new Button("plpmaule1");
        this.bmaule1.addActionListener(this);
        this.bmaule2 = new Button("plpmaule2");
        this.bmaule2.addActionListener(this);
        this.bmaule3 = new Button("plpmaule3");
        this.bmaule3.addActionListener(this);
        this.bmaule4 = new Button("plpmaule4");
        this.bmaule4.addActionListener(this);
        this.bmaule5 = new Button("plpmaule5");
        this.bmaule5.addActionListener(this);
        c.anchor = 17;
        c.gridwidth = 1;
        c2.anchor = 17;
        c2.gridwidth = 2;
        cef.gridwidth = 0;
        Utils.makeLabel(this, "ARCHIVOS DE RESULTADOS", gridbag, cef, Color.blue, p);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel(this, "Cargar Resultados de PLP", gridbag, cef, Color.red, p);
        gridbag.setConstraints(this.bLoadResults, c);
        gridbag.setConstraints(this.bResetResults, cef);
        p.add(this.bLoadResults);
        p.add(this.bResetResults);
        Utils.makeLabel(this, "Cargar Despacho Resultante", gridbag, cef, Color.red, p);
        Utils.makeLabel((Frame)this, "Especificar: ", gridbag, c, p);
        gridbag.setConstraints(this.bLoadDispatch, cef);
        p.add(this.bLoadDispatch);
        Utils.makeLabel(this, "Cargar Escenario Simulado", gridbag, cef, Color.red, p);
        Utils.makeLabel((Frame)this, "Especificar: ", gridbag, c, p);
        gridbag.setConstraints(this.bLoadScenario, cef);
        p.add(this.bLoadScenario);
        Utils.makeLabel(this, "Generaciones", gridbag, cef, Color.red, p);
        Utils.makeLabel((Frame)this, "Centrales ", gridbag, c, p);
        gridbag.setConstraints(this.bGeneraC, c);
        gridbag.setConstraints(this.bGeneraCOp, cef);
        p.add(this.bGeneraC);
        p.add(this.bGeneraCOp);
        Utils.makeLabel((Frame)this, "Embalses ", gridbag, c, p);
        gridbag.setConstraints(this.bGeneraE, c);
        p.add(this.bGeneraE);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel((Frame)this, "Serie ", gridbag, c, p);
        gridbag.setConstraints(this.bGeneraS, c);
        p.add(this.bGeneraS);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel(this, "Balances de Agua", gridbag, cef, Color.red, p);
        Utils.makeLabel((Frame)this, "Embalses", gridbag, c, p);
        gridbag.setConstraints(this.bBalancesE, c);
        gridbag.setConstraints(this.bBalancesEOp, cef);
        p.add(this.bBalancesE);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel((Frame)this, "Cotas de Embalses", gridbag, c, p);
        gridbag.setConstraints(this.bCotas, c);
        gridbag.setConstraints(this.bCotasOp, cef);
        p.add(this.bCotas);
        p.add(this.bCotasOp);
        Utils.makeLabel((Frame)this, "Serie", gridbag, c, p);
        gridbag.setConstraints(this.bBalancesS, c);
        gridbag.setConstraints(this.bBalancesSOp, cef);
        p.add(this.bBalancesS);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel(this, "Datos de L\u00edneas", gridbag, cef, Color.red, p);
        Utils.makeLabel((Frame)this, "Flujos por L\u00edneas ", gridbag, c, p);
        gridbag.setConstraints(this.bFlujos, c);
        gridbag.setConstraints(this.bFlujosOp, cef);
        p.add(this.bFlujos);
        p.add(this.bFlujosOp);
        Utils.makeLabel(this, "Costos y Datos Barras", gridbag, cef, Color.red, p);
        Utils.makeLabel((Frame)this, "Costos Marginales", gridbag, c, p);
        gridbag.setConstraints(this.bBarras, c);
        gridbag.setConstraints(this.bBarrasOp, cef);
        p.add(this.bBarras);
        p.add(this.bBarrasOp);
        Utils.makeLabel((Frame)this, "Valor del Agua", gridbag, c, p);
        gridbag.setConstraints(this.bValorAgua, c);
        p.add(this.bValorAgua);
        Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        Utils.makeLabel(this, "Otros", gridbag, cef, Color.red, p);
        Utils.makeLabel((Frame)this, "Emisiones ", gridbag, c, p);
        gridbag.setConstraints(this.bEGeneraC, c);
        gridbag.setConstraints(this.bEGeneraCOp, cef);
        p.add(this.bEGeneraC);
        p.add(this.bEGeneraCOp);
        gridbag.setConstraints(this.blaja1, c);
        gridbag.setConstraints(this.blaja2, c);
        gridbag.setConstraints(this.blaja3, cef);
        p.add(this.blaja1);
        p.add(this.blaja2);
        p.add(this.blaja3);
        gridbag.setConstraints(this.bmaule1, c);
        gridbag.setConstraints(this.bmaule2, c);
        gridbag.setConstraints(this.bmaule3, cef);
        p.add(this.bmaule1);
        p.add(this.bmaule2);
        p.add(this.bmaule3);
        gridbag.setConstraints(this.bmaule4, c);
        gridbag.setConstraints(this.bmaule5, cef);
        p.add(this.bmaule4);
        p.add(this.bmaule5);
        for (int i = 0; i < 0; ++i) {
            Utils.makeLabel((Frame)this, " ", gridbag, cef, p);
        }
        return p;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            try {
                this.closePLPFrame();
            }
            catch (Exception e) {
                System.out.println(e);
                PLPFrame cfr_ignored_0 = DeepEdit.frame.MyPLPFrame;
                View = false;
                DeepEdit.frame.MyPLPFrame = null;
                this.dispose();
            }
        } else if (event.getSource() == this.tFIniYear && event.getKeyCode() == 10) {
            this.iniWeek = this.ChIniWeek.getSelectedIndex() + 1;
            this.iniMonth = this.ChIniMonth.getSelectedIndex() + 1;
            this.iniYear = Integer.parseInt(this.tFIniYear.getText());
            this.actualizEndDate();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            Object obj = ev.getSource();
            String arg = ev.getActionCommand();
            if ("|<".equals(arg)) {
                ((CardLayout)this.cards.getLayout()).first(this.cards);
                this.actualizeCardCh();
            } else if (">".equals(arg)) {
                ((CardLayout)this.cards.getLayout()).next(this.cards);
                this.actualizeCardCh();
            } else if ("<".equals(arg)) {
                ((CardLayout)this.cards.getLayout()).previous(this.cards);
                this.actualizeCardCh();
            } else if (">|".equals(arg)) {
                ((CardLayout)this.cards.getLayout()).last(this.cards);
                this.actualizeCardCh();
            } else if ("Cerrar".equals(arg)) {
                this.closePLPFrame();
            } else if (arg.equals("Guardar") || obj instanceof TextField) {
                this.saveData();
                this.myApplet.UserWantsSaveSchematic(false);
                this.closePLPFrame();
            } else {
                ((CardLayout)this.cards.getLayout()).show(this.cards, arg);
            }
            if (obj instanceof Button) {
                Button b = (Button)obj;
                if (b == this.bEdStage) {
                    try {
                        this.iniWeek = this.ChIniWeek.getSelectedIndex() + 1;
                        this.iniMonth = this.ChIniMonth.getSelectedIndex() + 1;
                        this.myStageEditF = new PLPStageEditFrame(this, this.dbtrab);
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                } else if (b == this.bEdBlocks) {
                    this.StatusLabel.setText(" Cargando Datos...");
                    this.myBloqEdFrame = new PLPNomBloqEdFrame(this.dbtrab, Integer.parseInt(this.tFnumBlockLDC.getText()));
                    this.StatusLabel.setText(" Listo.");
                } else if (b == this.bEdDiscR) {
                    System.out.println("Ventana de tasas");
                    this.StatusLabel.setText(" Cargando Datos...");
                    this.mySimpTab = new PLPSimpTableFr((Frame)this, PLPSimpTableFr.AnnRates);
                    this.StatusLabel.setText(" Listo.");
                } else if (b == this.bEdEngAn) {
                    System.out.println("Ventana de Energ\u00edas anuales");
                    this.StatusLabel.setText(" Cargando Datos...");
                    this.mySimpTab = new PLPSimpTableFr((Frame)this, PLPSimpTableFr.AnnEngys);
                    this.StatusLabel.setText(" Listo.");
                } else if (b == this.bEdADDFL) {
                    System.out.println("Ventana Factores de Distribuci\u00f3n de Carga Geogr\u00e1fica");
                    this.StatusLabel.setText(" Cargando Datos...");
                    this.myEdFDCA = new PLPEdFDCAFr((Frame)this, PLPEdFDCAFr.FDLoad);
                    this.StatusLabel.setText(" Listo.");
                } else if (b == this.bEdADDFW) {
                    System.out.println("Ventana Factores de Distribuci\u00f3n de Carga Semanal");
                    this.StatusLabel.setText(" Cargando Datos...");
                    this.myEdFDCA = new PLPEdFDCAFr((Frame)this, PLPEdFDCAFr.FDWeek);
                    this.StatusLabel.setText(" Listo.");
                } else if (b == this.bEdWeekLDC) {
                    System.out.println("Ventana Factores de Curva Duraci\u00f3n de Carga");
                    this.StatusLabel.setText(" Cargando Datos...");
                    this.myEdLDCBFFrame = new PLPEdLDCBFFr((Frame)this, Integer.parseInt(this.tFnumBlockLDC.getText()));
                    this.StatusLabel.setText(" Listo.");
                } else if (b == this.bMakeFile) {
                    System.out.println("Construyendo archivos: " + this.getSelecNF());
                    this.cards.setEnabled(false);
                    this.makeFiles();
                    this.cards.setEnabled(true);
                } else if (b == this.bMakeAll) {
                    System.out.println("Construyendo todos los archivos de PLP");
                    this.selectAllCheckFile();
                    this.cards.setEnabled(false);
                    this.makeFiles();
                    this.cards.setEnabled(true);
                } else if (b == this.bEditFile) {
                    System.out.println("Editando archivos: " + this.getSelecNF());
                    this.editFiles();
                } else if (b == this.bExecute) {
                    System.out.println("Ejecutando PLP: ");
                    this.executePLP();
                } else if (b == this.bLoadResults) {
                    System.out.println("Carga de Resultados de PLP: ");
                    this.DoLoadResults(0);
                } else if (b == this.bResetResults) {
                    System.out.println("Borrar DB de Resultados de PLP: ");
                    this.DoResetResults();
                } else if (b == this.bLoadDispatch) {
                    System.out.println("Opciones para Carga de Despacho: ");
                    this.DoLoadDispatch();
                } else if (b == this.bLoadScenario) {
                    System.out.println("Opciones para Carga Escenario Simulado: ");
                    this.DoLoadScenario();
                } else if (b == this.bGeneraC) {
                    System.out.println("Resultado de Generaciones de Centrales: ");
                    this.DobGeneraC();
                } else if (b == this.bGeneraCOp) {
                    System.out.println("Opciones de Generaciones de Centrales: ");
                    this.DobGeneraCOp();
                } else if (b == this.bEGeneraC) {
                    System.out.println("Resultado de Emisiones de Centrales: ");
                    this.DobEGeneraC();
                } else if (b == this.bEGeneraCOp) {
                    System.out.println("Opciones de Res. de Emisiones de Centrales: ");
                    this.DobEGeneraCOp();
                } else if (b == this.bGeneraE) {
                    System.out.println("Resultado de Generaciones de Embalses: ");
                    this.DobGeneraE();
                } else if (b == this.bGeneraEOp) {
                    System.out.println("Opciones de Generaciones de Embalses: ");
                    this.DobGeneraEOp();
                } else if (b == this.bGeneraS) {
                    System.out.println("Resultado de Generaciones de Centrales Serie: ");
                    this.DobGeneraS();
                } else if (b == this.bGeneraSOp) {
                    System.out.println("Opciones de Generaciones de Centrales Serie: ");
                    this.DobGeneraSOp();
                } else if (b == this.bBalancesE) {
                    System.out.println("Resultado de Balances de Embalses: ");
                    this.DobBalancesE();
                } else if (b == this.bBalancesEOp) {
                    System.out.println("Opciones de Balances de Embalses : ");
                    this.DobBalancesEOp();
                } else if (b == this.bBalancesS) {
                    System.out.println("Resultado de Balances de Centrales Serie: ");
                    this.DobBalancesS();
                } else if (b == this.bBalancesSOp) {
                    System.out.println("Opciones de Balances de Centrales Serie: ");
                    this.DobBalancesSOp();
                } else if (b == this.bFlujos) {
                    System.out.println("Resultado de Flujos: ");
                    this.DobFlujos();
                } else if (b == this.bFlujosOp) {
                    System.out.println("Opciones de Flujos: ");
                    this.DobFlujosOp();
                } else if (b == this.bCotas) {
                    System.out.println("Resultado de Cotas: ");
                    this.DobCotas();
                } else if (b == this.bCotasOp) {
                    System.out.println("Opciones de Cotas: ");
                    this.DobCotasOp();
                } else if (b == this.bBarras) {
                    System.out.println("Resultado de Barras: ");
                    this.DobBarras();
                } else if (b == this.bBarrasOp) {
                    System.out.println("Opciones de Barras: ");
                    this.DobBarrasOp();
                } else if (b == this.bValorAgua) {
                    System.out.println("Resultado de ValorAgua: ");
                    this.DobValorAgua();
                } else if (b == this.bValorAguaOp) {
                    System.out.println("Opciones de ValorAgua: ");
                    this.DobValorAguaOp();
                } else if (b == this.blaja1) {
                    System.out.println("Resultado de Laja 1: ");
                    this.Doblaja1();
                } else if (b == this.blaja2) {
                    System.out.println("Resultado de Laja 2: ");
                    this.Doblaja2();
                } else if (b == this.blaja3) {
                    System.out.println("Resultado de Laja 3: ");
                    this.Doblaja3();
                } else if (b == this.bmaule1) {
                    System.out.println("Resultado de Maule 1: ");
                    this.Dobmaule1();
                } else if (b == this.bmaule2) {
                    System.out.println("Resultado de Maule 2: ");
                    this.Dobmaule2();
                } else if (b == this.bmaule3) {
                    System.out.println("Resultado de Maule 3: ");
                    this.Dobmaule3();
                } else if (b == this.bmaule4) {
                    System.out.println("Resultado de Maule 4: ");
                    this.Dobmaule4();
                } else if (b == this.bmaule5) {
                    System.out.println("Resultado de Maule 5: ");
                    this.Dobmaule5();
                }
            }
        }
        catch (Exception e) {
            this.cards.setEnabled(true);
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void updatePLPagreement(agreement myagreement) {
        int ii = 0;
        for (int ix = 0; ix < 10; ++ix) {
            myagreement.agreementcom[ix] = " ";
            myagreement.agreementcomT[ix] = 0;
        }
        try {
            Statement stmt = this.dbtrab.createStatement();
            String query = "SELECT * FROM Convenios WHERE Nombre = '" + myagreement.getText() + "' and Tipo = 'texto' and (Tipo_Visual > 0)";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                if (ii < 10) {
                    myagreement.agreementcom[ii] = rs.getString("Valor");
                    myagreement.agreementcomT[ii] = rs.getInt("Tipo_Visual") - 1;
                    ++ii;
                    continue;
                }
                System.out.println("Error !: Para convenio " + myagreement.getText() + " se definieron m\u00e1s de 10 asociaciones a objetos hid\u00e1ulicos.");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error en Lectura de Convenio.");
        }
    }

    private void loadData() {
        String datakey = "";
        int tmpNumSt = 0;
        int sumNumWeeks = 0;
        String[] nameParam = new String[]{"Ang_Ref", "A\u00f1o_Fin", "A\u00f1o_Inicio", "Mes_Deshielo", "Mes_Fin", "Mes_Inicio", "Mod_Dist_Perdidas", "Modelo_Perdidas", "Num_Aperturas", "Num_Bloques_CC", "Num_Hidrologias", "Num_Simulaciones", "Semana_Fin", "Semana_Inicio", "Tipo_Apertura", "Tipo_Simulacion", "Ultimo_A\u00f1o_Est_Hidro"};
        int[] values = new int[17];
        int countrdata = 0;
        try {
            Statement s = this.dbtrab.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM Param_Sim ORDER BY Parametro");
            while (r.next()) {
                datakey = r.getString("Parametro");
                if (!datakey.equals(nameParam[countrdata])) {
                    throw new PLPException("datos corruptos");
                }
                values[countrdata] = r.getInt("Valor");
                ++countrdata;
            }
            if (countrdata != 17) {
                throw new PLPException("datos corruptos");
            }
            r = s.executeQuery("SELECT * FROM Def_Etapas ORDER BY Num_Etapa");
            while (r.next()) {
                tmpNumSt = r.getInt("Num_Etapa");
                sumNumWeeks += r.getInt("Duracion");
            }
            s.close();
            if (tmpNumSt > 0) {
                this.numStages = tmpNumSt;
            }
        }
        catch (Exception e) {
            this.plpFrameError(e + " al leer PLPDB: tabla Param_Sim");
            System.out.println("se cargan valores por defecto.");
            this.StatusLabel.setText("Par\u00e1metros por defecto");
            return;
        }
        System.out.println("lectura OK de Param_Sim");
        this.angRef = values[0];
        this.iniWeek = values[13];
        this.endWeek = values[12];
        this.iniMonth = values[5];
        this.endMonth = values[4];
        this.iniYear = values[2];
        this.endYear = values[1];
        this.numBlockLDC = values[9];
        this.numSim = values[11];
        this.numAper = values[8];
        this.numHydro = values[10];
        this.lineLossMod = values[6];
        this.monThaw = values[3];
        this.kindSim = values[15];
        this.kindApe = values[14];
        this.lossMod = values[7];
        this.lastHydStat = values[16];
        this.stagesLength = sumNumWeeks;
        this.ChIniWeek.select(this.iniWeek - 1);
        this.ChEndWeek.select(this.endWeek - 1);
        this.ChIniMonth.select(this.iniMonth - 1);
        this.ChEndMonth.select(this.endMonth - 1);
        this.ChMonThaw.select(this.monThaw - 1);
        this.ChKindSim.select(this.kindSim);
        this.ChKindApe.select(this.kindApe);
        if (this.lossMod == 0) {
            this.ChLossMod.select(0);
        } else {
            this.ChLossMod.select(this.lineLossMod + 1);
        }
        this.tFIniYear.setText("" + this.iniYear);
        this.tFEndYear.setText("" + this.endYear);
        this.tFNumSim.setText("" + this.numSim);
        this.tFNumHydro.setText("" + this.numHydro);
        this.tFNumAper.setText("" + this.numAper);
        this.tFLastHydStat.setText("" + this.lastHydStat);
        this.tFnumBlockLDC.setText("" + this.numBlockLDC);
        this.tFNumStages.setText("" + this.numStages);
        if (this.actualizEndDate()) {
            System.out.println("Existe discrepancia en fecha de fin del horizonte, se opta por la calculada.");
        }
        this.StatusLabel.setText("Par\u00e1metros de Simulaci\u00f3n Cargados.");
    }

    public void saveData() {
        String datakey = "";
        String[] nameParam = new String[]{"Ang_Ref", "A\u00f1o_Fin", "A\u00f1o_Inicio", "Mes_Deshielo", "Mes_Fin", "Mes_Inicio", "Mod_Dist_Perdidas", "Modelo_Perdidas", "Num_Aperturas", "Num_Bloques_CC", "Num_Hidrologias", "Num_Simulaciones", "Semana_Fin", "Semana_Inicio", "Tipo_Apertura", "Tipo_Simulacion", "Ultimo_A\u00f1o_Est_Hidro"};
        this.setEnabled(false);
        this.StatusLabel.setText("Guardando a la Base de Datos");
        int countrdata = 0;
        this.iniWeek = this.ChIniWeek.getSelectedIndex() + 1;
        this.iniMonth = this.ChIniMonth.getSelectedIndex() + 1;
        this.iniYear = Integer.parseInt(this.tFIniYear.getText());
        this.actualizEndDate();
        this.monThaw = this.ChMonThaw.getSelectedIndex() + 1;
        this.kindSim = this.ChKindSim.getSelectedIndex();
        this.kindApe = this.ChKindApe.getSelectedIndex();
        this.lossMod = this.ChLossMod.getSelectedIndex() > 0 ? 1 : 0;
        this.lineLossMod = this.ChLossMod.getSelectedIndex() - 1;
        this.numSim = Integer.parseInt(this.tFNumSim.getText());
        this.numHydro = Integer.parseInt(this.tFNumHydro.getText());
        this.numAper = Integer.parseInt(this.tFNumAper.getText());
        this.numBlockLDC = Integer.parseInt(this.tFnumBlockLDC.getText());
        this.lastHydStat = Integer.parseInt(this.tFLastHydStat.getText());
        int[] values = new int[17];
        values[0] = this.angRef;
        values[13] = this.iniWeek;
        values[12] = this.endWeek;
        values[5] = this.iniMonth;
        values[4] = this.endMonth;
        values[2] = this.iniYear;
        values[1] = this.endYear;
        values[9] = this.numBlockLDC;
        values[11] = this.numSim;
        values[8] = this.numAper;
        values[10] = this.numHydro;
        values[6] = this.lineLossMod;
        values[3] = this.monThaw;
        values[15] = this.kindSim;
        values[14] = this.kindApe;
        values[7] = this.lossMod;
        values[16] = this.lastHydStat;
        try {
            Statement s = this.dbtrab.createStatement();
            s.executeUpdate("DELETE * FROM Param_Sim");
            for (countrdata = 0; countrdata < 17; ++countrdata) {
                s.executeUpdate("INSERT INTO Param_Sim (Parametro,Valor)VALUES ('" + nameParam[countrdata] + "'," + values[countrdata] + ")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.plpFrameError("al escribir PLPDB: tabla Param_Sim");
        }
        System.out.println("escritura OK de Param_Sim");
        this.StatusLabel.setText("Listo! ");
        this.setEnabled(true);
        if (this.myPLPtool != null) {
            this.myPLPtool.update();
        }
    }

    public void plpFrameError(String mensaje) {
        System.out.println(mensaje);
    }

    public void setNumStages(int Nst) {
        this.tFNumStages.setText("" + Nst);
        this.numStages = Nst;
    }

    public Connection OpenDataBase(String DBName, String user, String password) throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println("Error: en Connection OpenDatabase " + message);
            return null;
        }
        String dsn = "jdbc:odbc:" + DBName;
        return DriverManager.getConnection(dsn, user, password);
    }

    public int getNumStages() {
        this.numStages = Integer.parseInt(this.tFNumStages.getText());
        return this.numStages;
    }

    private void actualizeCardCh() {
        int icp = 0;
        if (this.cp2.isShowing()) {
            icp = 1;
        } else if (this.cp3.isShowing()) {
            icp = 2;
        } else if (this.cp4.isShowing()) {
            icp = 3;
        }
        this.cardChoice.select(icp);
        if (icp == 2) {
            this.saveData();
        }
    }

    private void actualizeChanges() {
    }

    public String getSelecNF() {
        String selfiles = "";
        for (int i = 0; i < plpFileNames.length; ++i) {
            if (!this.CHBplpFile[i].getState()) continue;
            selfiles = selfiles + plpFileNames[i] + ", ";
        }
        return selfiles;
    }

    private void clearCheckFile() {
        for (int i = 0; i < plpFileNames.length; ++i) {
            this.CHBplpFile[i].setState(false);
        }
    }

    private void makeFiles() throws Exception {
        if (this.myPLPtool == null) {
            this.myPLPtool = new PLPtool(this.actSchem, this.myApplet);
        }
        this.StatusLabel.setText("Escrbiendo Archivos PLP...");
        PLPFrame cfr_ignored_0 = DeepEdit.frame.MyPLPFrame;
        View = false;
        if (this.CHBplpFile[0].getState()) {
            this.myPLPtool.writeFileETAPAS();
            this.CHBplpFile[0].setState(false);
        }
        if (this.CHBplpFile[1].getState()) {
            this.myPLPtool.writeFileDEMANDA();
            this.CHBplpFile[1].setState(false);
        }
        if (this.CHBplpFile[2].getState()) {
            this.myPLPtool.writeFileBARRAS();
            this.CHBplpFile[2].setState(false);
        }
        if (this.CHBplpFile[3].getState()) {
            this.myPLPtool.writeFileCONFLIN();
            this.CHBplpFile[3].setState(false);
        }
        if (this.CHBplpFile[4].getState()) {
            this.myPLPtool.writeFileCONFCEN();
            this.CHBplpFile[4].setState(false);
        }
        if (this.CHBplpFile[5].getState()) {
            this.myPLPtool.writeFileCOSTFUTEMB();
            this.CHBplpFile[5].setState(false);
        }
        if (this.CHBplpFile[6].getState()) {
            this.myPLPtool.writeFileAFLCENT();
            this.CHBplpFile[6].setState(false);
        }
        if (this.CHBplpFile[7].getState()) {
            this.myPLPtool.writeFileIDENSIM();
            this.CHBplpFile[7].setState(false);
        }
        if (this.CHBplpFile[8].getState()) {
            this.myPLPtool.writeFileIDENAPER();
            this.CHBplpFile[8].setState(false);
        }
        if (this.CHBplpFile[9].getState()) {
            this.myPLPtool.writeFileMANTCENT();
            this.CHBplpFile[9].setState(false);
        }
        if (this.CHBplpFile[10].getState()) {
            this.myPLPtool.writeFileMANTEMB();
            this.CHBplpFile[10].setState(false);
        }
        if (this.CHBplpFile[11].getState()) {
            this.myPLPtool.writeFileMANTLIN();
            this.CHBplpFile[11].setState(false);
        }
        if (this.CHBplpFile[12].getState()) {
            this.myPLPtool.writeFilePATH();
            this.CHBplpFile[12].setState(false);
        }
        if (this.CHBplpFile[13].getState()) {
            this.myPLPtool.writeFileFILTCENT();
            this.CHBplpFile[13].setState(false);
        }
        if (this.CHBplpFile[14].getState()) {
            this.myPLPtool.writeFileRENDCENT();
            this.CHBplpFile[14].setState(false);
        }
        if (this.CHBplpFile[15].getState()) {
            this.myPLPtool.writeFileCONVLAJA();
            this.CHBplpFile[15].setState(false);
        }
        if (this.CHBplpFile[16].getState()) {
            this.myPLPtool.writeFileCONVMAULE();
            this.CHBplpFile[16].setState(false);
        }
        if (this.CHBplpFile[17].getState()) {
            this.myPLPtool.writeFileMATPAR();
            this.CHBplpFile[17].setState(false);
        }
        if (this.CHBplpFile[18].getState()) {
            this.myPLPtool.writeFileDEBUGPAR();
            this.CHBplpFile[18].setState(false);
        }
        if (this.CHBplpFile[19].getState()) {
            this.myPLPtool.writeFilePARAM();
            this.CHBplpFile[19].setState(false);
        }
        this.StatusLabel.setText("Listo !");
    }

    private void editFiles() throws Exception {
        if (this.myPLPtool == null) {
            this.myPLPtool = new PLPtool(this.actSchem, this.myApplet);
        }
        this.StatusLabel.setText("Editando Archivos PLP...");
        for (int i = 0; i < plpFileNames.length; ++i) {
            if (!this.CHBplpFile[i].getState()) continue;
            this.myPLPtool.editFile(plpFileNames[i], PLPtool.NOTEPAD);
            this.CHBplpFile[i].setState(false);
        }
        this.StatusLabel.setText("Listo !");
    }

    private void executePLP() throws Exception {
        AnalysisTool.Dorun(DeepEdit.PathDOS + "PLPFiles\\plprun.bat", DeepEdit.PathUNIX + "PLPFiles/plprun.bat");
        this.StatusLabel.setText("Listo !");
    }

    private void selectAllCheckFile() {
        for (int i = 0; i < plpFileNames.length; ++i) {
            this.CHBplpFile[i].setState(true);
        }
    }

    private void DoLoadResults(int selec) throws Exception {
        int numStages = this.myPLPtool.mydbm.getNumStages();
        int numBlocks = this.myPLPtool.mydbm.getParam_Sim("Num_Bloques_CC");
        int numEtapas = numStages * numBlocks;
        int numSim = this.myPLPtool.mydbm.getParam_Sim("Num_Simulaciones");
        if (selec == 0 || selec == 1) {
            myPLPcen = new PLPcen(numStages, numBlocks, numEtapas, numSim);
            PLPFrame.objectWrite(myPLPcen, "PLPcen.bin");
            myPLPcen = null;
        }
        if (selec == 0 || selec == 2) {
            myPLPbar = new PLPbar(numStages, numBlocks, numEtapas, numSim);
            PLPFrame.objectWrite(myPLPbar, "PLPbar.bin");
            myPLPbar = null;
        }
        if (selec == 0 || selec == 3) {
            myPLPlin = new PLPlin(numStages, numBlocks, numEtapas, numSim);
            PLPFrame.objectWrite(myPLPlin, "PLPlin.bin");
            myPLPlin = null;
        }
        if (selec == 0 || selec == 4) {
            myPLPser = new PLPser(numStages, numBlocks, numEtapas, numSim);
            PLPFrame.objectWrite(myPLPser, "PLPser.bin");
            myPLPser = null;
        }
        PLPResDone = true;
        String[] DlgButtons = new String[]{"OK"};
        String message = "Creaci\u00f3n de archivos binarios terminada";
        SimpleDialog endDialog = new SimpleDialog(DeepEdit.frame, "Caution:", message, DlgButtons, 1, 0, 0, 2);
    }

    private void DoResetResults() throws Exception {
        myPLPcen = null;
        myPLPbar = null;
        myPLPlin = null;
        myPLPser = null;
        try {
            Runtime r = Runtime.getRuntime();
            r.gc();
        }
        catch (Exception e) {
            System.out.println("Error in Garbage Colector" + e);
        }
    }

    public void DoReadResults(int selec) throws Exception {
        boolean i = false;
        try {
            if (selec == 0 || selec == 1) {
                myPLPcen = (PLPcen)this.objectRead("PLPcen.bin");
                System.out.println("Fin Escritura de Base de Datos PLPcen");
                fis.close();
                fis = null;
            }
            if (selec == 0 || selec == 2) {
                myPLPbar = (PLPbar)this.objectRead("PLPbar.bin");
                System.out.println("Fin Escritura de Base de Datos PLPbar");
                fis.close();
                fis = null;
            }
            if (selec == 0 || selec == 3) {
                myPLPlin = (PLPlin)this.objectRead("PLPlin.bin");
                System.out.println("Fin Escritura de Base de Datos PLPlin");
                fis.close();
                fis = null;
            }
            if (selec == 0 || selec == 4) {
                myPLPser = (PLPser)this.objectRead("PLPser.bin");
                System.out.println("Fin Escritura de Base de Datos PLPser");
                fis.close();
                fis = null;
            }
        }
        catch (Exception eee) {
            System.err.println(eee);
        }
    }

    private void closePLPFrame() throws Exception {
        this.dispose();
        this.myApplet.UserWantsSavePLPStudy();
        PLPFrame cfr_ignored_0 = DeepEdit.frame.MyPLPFrame;
        View = false;
        DeepEdit.frame.MyPLPFrame = null;
        myPLPcen = null;
        myPLPlin = null;
        myPLPbar = null;
        myPLPser = null;
    }

    private void DoLoadDispatch() throws Exception {
        PLPLoadDispatchFrame myLDFrame = new PLPLoadDispatchFrame(this.myApplet);
    }

    private void DoLoadScenario() throws Exception {
        PLPLoadScenarioFrame myLSFrame = new PLPLoadScenarioFrame(this.myApplet);
    }

    private void DobGeneraC() throws Exception {
        DBReadTableFrame myGeneraC = new DBReadTableFrame("PLPRes", "GENERACION DE CENTRALES", "plpcen.csv", 400, 600, "No Importa");
    }

    private void DobGeneraCOp() throws Exception {
        PLPGeneraOpFrame myGeneraOp = new PLPGeneraOpFrame(this.myApplet);
    }

    private void DobEGeneraC() throws Exception {
        DBReadTableFrame myEGeneraC = new DBReadTableFrame("PIETdb", "FACTORES DE EMISION DE CENTRALES", "FE_E", 400, 600, "No Importa");
    }

    private void DobEGeneraCOp() throws Exception {
        PLPEGeneraOpFrame myEGeneraOp = new PLPEGeneraOpFrame(this.myApplet);
    }

    private void DobGeneraE() throws Exception {
        DBReadTableFrame myGeneraE = new DBReadTableFrame("PLPRes", "GENERACION DE CENTRALES DE EMBALSE", "plpemb.csv", 400, 600, "No Importa");
        myGeneraE.NewTable.getColumn(5).setVisible(false);
        myGeneraE.NewTable.getColumn(6).setVisible(false);
        myGeneraE.NewTable.getColumn(7).setVisible(false);
        myGeneraE.NewTable.getColumn(9).setVisible(false);
        myGeneraE.NewTable.getColumn(10).setVisible(false);
        myGeneraE.NewTable.getColumn(11).setVisible(false);
    }

    private void DobGeneraEOp() throws Exception {
        System.out.println("No implementado !!");
    }

    private void DobGeneraS() throws Exception {
        DBReadTableFrame myGeneraS = new DBReadTableFrame("PLPRes", "GENERACION DE CENTRALES SERIE", "plpser.csv", 400, 600, "No Importa");
        myGeneraS.NewTable.getColumn(8).setVisible(false);
        myGeneraS.NewTable.getColumn(9).setVisible(false);
        myGeneraS.NewTable.getColumn(10).setVisible(false);
    }

    private void DobGeneraSOp() throws Exception {
        System.out.println("No implementado !!");
    }

    private void DobBalancesE() throws Exception {
        DBReadTableFrame myBalancesE = new DBReadTableFrame("PLPRes", "BALANCES DE AGUA EN EMBALSES", "plpemb.csv", 400, 600, "No Importa");
    }

    private void DobBalancesEOp() throws Exception {
        System.out.println("No implementado !!");
    }

    private void DobCotas() throws Exception {
        DBReadTableFrame myCotas = new DBReadTableFrame("PLPRes", "COTAS DE EMBALSES POR ETAPA", "plpemb.csv", 400, 600, "No Importa");
        myCotas.NewTable.getColumn(5).setVisible(false);
        myCotas.NewTable.getColumn(8).setVisible(false);
        myCotas.NewTable.getColumn(9).setVisible(false);
        myCotas.NewTable.getColumn(10).setVisible(false);
        myCotas.NewTable.getColumn(11).setVisible(false);
    }

    private void DobCotasOp() throws Exception {
        PLPCotasOpFrame myCotasOp = new PLPCotasOpFrame(this.myApplet);
    }

    private void DobBalancesS() throws Exception {
        DBReadTableFrame myBalancesS = new DBReadTableFrame("PLPRes", "BALANCES DE AGUA EN CENTRALES SERIE", "plpser.csv", 400, 600, "No Importa");
    }

    private void DobBalancesSOp() throws Exception {
        System.out.println("-----------------");
    }

    private void DobFlujos() throws Exception {
        DBReadTableFrame myFlujos = new DBReadTableFrame("PLPRes", "FLUJOS EN LINEAS/CONEXIONES", "plplin.csv", 400, 600, "No Importa");
    }

    private void DobFlujosOp() throws Exception {
        PLPFlujosOpFrame myFlujosOp = new PLPFlujosOpFrame(this.myApplet);
    }

    private void DobBarras() throws Exception {
        DBReadTableFrame myBarras = new DBReadTableFrame("PLPRes", "COSTOS MARGINALES", "plpbar.csv", 400, 600, "No Importa");
    }

    private void DobBarrasOp() throws Exception {
        PLPBarrasOpFrame myBarrasOp = new PLPBarrasOpFrame(this.myApplet);
    }

    private void DobValorAgua() throws Exception {
        DBReadTableFrame myValorAgua = new DBReadTableFrame("PLPRes", "VALOR DEL AGUA", "ValorAgua.csv", 400, 600, "No Importa");
        System.out.println("-----------------");
    }

    private void DobValorAguaOp() throws Exception {
        System.out.println("-----------------");
    }

    private void Doblaja1() throws Exception {
        DBReadTableFrame mylaja1 = new DBReadTableFrame("PLPRes", "DATOS LAJA 1", "plplaja1.csv", 400, 600, "No Importa");
    }

    private void Doblaja2() throws Exception {
        DBReadTableFrame mylaja2 = new DBReadTableFrame("PLPRes", "DATOS LAJA 2", "plplaja2.csv", 400, 600, "No Importa");
    }

    private void Doblaja3() throws Exception {
        DBReadTableFrame mylaja3 = new DBReadTableFrame("PLPRes", "DATOS LAJA 3", "plplaja3.csv", 400, 600, "No Importa");
    }

    private void Dobmaule1() throws Exception {
        DBReadTableFrame mymaule1 = new DBReadTableFrame("PLPRes", "DATOS MAULE 1", "plpmaule1.csv", 400, 600, "No Importa");
    }

    private void Dobmaule2() throws Exception {
        DBReadTableFrame mymaule2 = new DBReadTableFrame("PLPRes", "DATOS MAULE 2", "plpmaule2.csv", 400, 600, "No Importa");
    }

    private void Dobmaule3() throws Exception {
        DBReadTableFrame mymaule3 = new DBReadTableFrame("PLPRes", "DATOS MAULE 3", "plpmaule3.csv", 400, 600, "No Importa");
    }

    private void Dobmaule4() throws Exception {
        DBReadTableFrame mymaule4 = new DBReadTableFrame("PLPRes", "DATOS MAULE 4", "plpmaule4.csv", 400, 600, "No Importa");
    }

    private void Dobmaule5() throws Exception {
        DBReadTableFrame mymaule5 = new DBReadTableFrame("PLPRes", "DATOS MAULE 5", "plpmaule5.csv", 400, 600, "No Importa");
    }

    public Object objectRead(String mifile) {
        try {
            System.out.println("Comienzo lectura " + mifile);
            fis = new FileInputStream("PLPFiles/Resultados/" + mifile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            GZIPInputStream zis = new GZIPInputStream(bis);
            ObjectInputStream objIs = new ObjectInputStream(zis);
            return objIs.readObject();
        }
        catch (NotSerializableException se) {
            System.err.println(se);
            se.printStackTrace();
        }
        catch (FileNotFoundException fe) {
            System.err.println(fe);
            fe.printStackTrace();
        }
        catch (IOException se) {
            System.err.println(se);
            se.printStackTrace();
        }
        catch (ClassNotFoundException ce) {
            System.err.println(ce);
            ce.printStackTrace();
        }
        return null;
    }

    public static void objectWrite(Object oo, String mifile) {
        try {
            FileOutputStream fos = new FileOutputStream("PLPFiles/Resultados/" + mifile, false);
            GZIPOutputStream out = new GZIPOutputStream(fos);
            ObjectOutputStream objOs = new ObjectOutputStream(out);
            objOs.writeObject(oo);
            objOs.flush();
            objOs.close();
            fos.close();
        }
        catch (NotSerializableException se) {
            System.err.println(se);
        }
        catch (FileNotFoundException fe) {
            System.err.println(fe);
        }
        catch (IOException se) {
            System.err.println(se);
        }
    }

    private boolean actualizEndDate() {
        boolean ischanged = false;
        int weekBef = this.stagesLength;
        int weekAft = (weekBef += this.iniWeek - 1 + (this.iniMonth - 1) * 4) - 1;
        int tempD = this.endYear;
        this.endYear = weekAft / 48;
        if (this.endYear != tempD - this.iniYear) {
            ischanged = true;
        }
        tempD = this.endMonth;
        this.endMonth = (weekAft - this.endYear * 48) / 4;
        if (this.endMonth != tempD - 1) {
            ischanged = true;
        }
        tempD = this.endWeek;
        this.endWeek = weekAft - this.endMonth * 4 - this.endYear * 48;
        if (this.endWeek != tempD - 1) {
            ischanged = true;
        }
        this.endYear += this.iniYear;
        ++this.endWeek;
        ++this.endMonth;
        this.tFEndYear.setText("" + this.endYear);
        this.ChEndWeek.select(this.endWeek - 1);
        this.ChEndMonth.select(this.endMonth - 1);
        return ischanged;
    }

    public void setStagesLength(int newSTL) {
        this.stagesLength = newSTL;
        this.actualizEndDate();
    }
}

